/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.svcdump;

import com.ibm.jvm.dump.format.CTypeFile;
import com.ibm.jvm.dump.format.DvAddressSpace;
import com.ibm.jvm.dump.format.DvDump;
import com.ibm.jvm.dump.format.DvRas;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.findroots.Graph;
import com.ibm.jvm.findroots.NullHandler;
import com.ibm.jvm.svcdump.AddressSpace;
import com.ibm.jvm.svcdump.Dsa;
import com.ibm.jvm.svcdump.DumpReader;
import com.ibm.jvm.svcdump.Function;
import com.ibm.jvm.svcdump.HeapClass;
import com.ibm.jvm.svcdump.Jvm;
import com.ibm.jvm.svcdump.Ras;
import com.ibm.jvm.svcdump.Tcb;
import com.ibm.jvm.util.SvcdumpProperties;
import com.ibm.jvm.util.html.Document;
import com.ibm.jvm.util.html.Row;
import com.ibm.jvm.util.html.Table;
import com.ibm.jvm.zseries.Engine;
import com.ibm.jvm.zseries.Instruction;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Vector;

public class Dump
extends DvDump {
    DumpReader dumpReader;
    AddressSpace[] spaces = new AddressSpace[0];
    AddressSpace[] validSpaces;
    static final int HEADERSIZE = 64;
    static final int BLOCKSIZE = 4160;
    static final int DR1 = -992349888;
    static final int DR2 = -992349632;
    boolean old;
    public static boolean verbose = false;
    public static boolean debug = false;
    static boolean printArgs = false;
    static boolean analyzeHeap = false;
    static boolean printAllocCache = false;
    static boolean printExceptionObject = false;
    static boolean disassemble = false;
    static int disassembleAddress;
    static int disassembleLength;
    static boolean dumpstorage;
    static int dumpstorageAddress;
    static int dumpstorageLength;
    static boolean dumpclasses;
    static boolean dumpnative;
    static boolean verifysubpools;
    static int dumpclass;
    static boolean dumpproperties;
    static boolean dumpmdata;
    static int mdata;
    static boolean systrace;
    static boolean search;
    static int searchvalue;
    static int limit;
    static String dvDumpName;
    Graph graph;
    Document doc = new Document();
    Ras ras;
    int defaultAsid = -1;
    static boolean fromJFormat;
    boolean svcdump = true;
    static int arrayLength;
    static int arrayCount;
    static int objectCount;
    static int reg;
    static int caa;
    static /* synthetic */ Class class$com$ibm$jvm$svcdump$Dump;

    public Dump() throws Exception {
        this(dvDumpName, null);
    }

    public static Boolean isSupportedSource(String string) {
        DvUtils.writetoTrace(" svcdump:isSupportedSource entry with " + string);
        dvDumpName = string;
        Boolean bl = new Boolean(Dump.validFile(new File(string)));
        if (bl.booleanValue()) {
            DvUtils.writetoTrace(" Dump recognised as svc dump");
        } else {
            DvUtils.writetoTrace(" Dump not recognised as svc dump");
        }
        DvUtils.writetoTrace(" svcdump:isSupportedSource exit ");
        return bl;
    }

    public DvAddressSpace[] getAddressSpaces() {
        return this.addressSpaces();
    }

    public DvAddressSpace getCurrentAddressSpace() {
        throw new Error("unimplemented method");
    }

    public int getArchitecture() {
        return 5;
    }

    public int getSystemType() {
        return 4;
    }

    public int getSubSystemType() {
        return 11;
    }

    public int getProcessor() {
        throw new Error("unimplemented method");
    }

    public int getProcessorSubType() {
        throw new Error("unimplemented method");
    }

    public int getCurrentProcessor() {
        throw new Error("unimplemented method");
    }

    public int getProcessorCount() {
        throw new Error("unimplemented method");
    }

    public byte[] getCTypedefs() {
        this.getRas();
        if (this.ras == null) {
            return null;
        }
        return this.ras.getCTypedefs();
    }

    public DvRas getRas() {
        if (this.ras == null) {
            AddressSpace addressSpace = this.getDefaultAddressSpace();
            if (addressSpace.jvmRasAddress == 0) {
                if (verbose) {
                    System.out.println("Warning: ras address is zero!");
                }
                return null;
            }
            try {
                int n = addressSpace.readInt(addressSpace.jvmRasAddress);
                if (n != 1247169874) {
                    throw new Error("Unexpected jvm ras eyecatcher: " + Dump.hex(n));
                }
                int n2 = addressSpace.readInt(addressSpace.jvmRasAddress + 24);
                Dump.Assert(n2 != 0);
                int n3 = addressSpace.readInt(addressSpace.jvmRasAddress + 28);
                Dump.Assert(n3 < 65536);
                this.ras = new Ras(addressSpace, (long)n2, (long)n3);
            }
            catch (Exception exception) {
                throw new Error("problem: " + exception);
            }
        }
        return this.ras;
    }

    boolean validBlock(int n) {
        if (n == -992349632) {
            this.old = false;
        } else if (n == -992349888) {
            this.old = true;
        } else {
            return false;
        }
        return true;
    }

    static boolean validFile(File file) {
        try {
            DumpReader dumpReader = new DumpReader(file);
            dumpReader.close();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    static int maxBlocks(File file) {
        return (int)file.length() / 4160;
    }

    void scanFile() throws Exception {
        AddressSpace addressSpace = null;
        try {
            byte[] byArray = new byte[4160];
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            int n = 0;
            while (true) {
                this.dumpReader.read(byArray);
                int n2 = Dump.getInt(byArray, 0);
                if (!this.validBlock(n2)) {
                    throw new Error("No DR2 found at record " + n + " instead found " + Dump.hex(n2));
                }
                int n3 = Dump.getInt(byArray, 3);
                int n4 = Dump.getInt(byArray, this.old ? 5 : 6);
                addressSpace = this.getAddressSpace(n3);
                addressSpace.add(n4, n);
                if (!bl4) {
                    int n5 = 0;
                    while (n5 < 1040) {
                        int n6 = Dump.getInt(byArray, n5);
                        if (!bl) {
                            if (n6 == 1247169874) {
                                bl = true;
                            }
                        } else if (!bl2) {
                            if (n6 == 1095958528) {
                                bl2 = true;
                            } else {
                                bl = false;
                            }
                        } else if (!bl3) {
                            if (n6 == -1437226411) {
                                bl3 = true;
                            } else {
                                bl2 = false;
                                bl = false;
                            }
                        } else if (n6 == -1437226411) {
                            bl4 = true;
                            addressSpace.setJvmRasAddress(n4 + ((n5 << 2) - 64 - 12));
                        } else {
                            bl3 = false;
                            bl2 = false;
                            bl = false;
                        }
                        ++n5;
                    }
                }
                ++n;
            }
        }
        catch (EOFException eOFException) {
            return;
        }
    }

    public Dump(String string, Graph graph) throws Exception {
        Object object;
        Object object2;
        this.doc.setPlainText(!SvcdumpProperties.getBooleanProperty("svcdump.output.html", false));
        this.graph = graph;
        this.dumpReader = new DumpReader(string);
        try {
            object2 = new FileInputStream(string + ".cache");
            object = new ObjectInputStream((InputStream)object2);
            this.spaces = (AddressSpace[])((ObjectInputStream)object).readObject();
            ((ObjectInputStream)object).close();
        }
        catch (Exception exception) {
            object = new FileOutputStream(string + ".cache");
            ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)object);
            this.scanFile();
            objectOutputStream.writeObject(this.spaces);
            objectOutputStream.close();
        }
        object2 = null;
        if (debug) {
            this.doc.println("finished scanning dump");
        }
        int n = 0;
        while (n < this.spaces.length) {
            this.spaces[n].dump = this;
            this.spaces[n].sort();
            ++n;
        }
        int n2 = 0;
        while (n2 < this.spaces.length) {
            block13: {
                object2 = this.spaces[n2];
                try {
                    int n3 = ((AddressSpace)object2).readInt(548L);
                    if (debug) {
                        this.doc.println("asid = " + object2 + ", psaaold = " + Dump.hex(n3));
                    }
                    try {
                        int n4 = ((AddressSpace)object2).readInt(n3 + 108);
                        if (((AddressSpace)object2).id == 1) {
                            if (debug) {
                                this.doc.println("ascb = " + Dump.hex(n4));
                            }
                            AddressSpace.ascbasxb = n4;
                            AddressSpace.root = object2;
                        }
                    }
                    catch (Exception exception) {
                        if (debug) {
                            this.doc.println("inner failed for " + ((AddressSpace)object2).hexId() + " psaaold " + Dump.hex(n3) + " psaanew " + Dump.hex(((AddressSpace)object2).readInt(544L)));
                        }
                    }
                }
                catch (Exception exception) {
                    if (!debug) break block13;
                    this.doc.println("outer failed for " + ((AddressSpace)object2).hexId() + ": " + exception);
                }
            }
            ++n2;
        }
        this.defaultAsid = SvcdumpProperties.getIntProperty("svcdump.default.asid", -1, 16);
    }

    public Dump(String string) throws Exception {
        this(string, new Graph());
    }

    static int getInt(byte[] byArray, int n) {
        int n2 = byArray[n <<= 2] << 24;
        int n3 = byArray[n + 1] << 16 & 0xFFFFFF;
        int n4 = byArray[n + 2] << 8 & 0xFFFF;
        int n5 = byArray[n + 3] & 0xFF;
        return n2 | n3 | n4 | n5;
    }

    void seek(int n) throws IOException {
        this.dumpReader.seek(n);
    }

    AddressSpace getAddressSpace(int n) {
        AddressSpace addressSpace;
        int n2 = 0;
        while (n2 < this.spaces.length) {
            addressSpace = this.spaces[n2];
            if (addressSpace.id == n) {
                return addressSpace;
            }
            ++n2;
        }
        AddressSpace[] addressSpaceArray = new AddressSpace[this.spaces.length + 1];
        System.arraycopy(this.spaces, 0, addressSpaceArray, 0, this.spaces.length);
        addressSpaceArray[this.spaces.length] = addressSpace = new AddressSpace(this, n);
        this.spaces = addressSpaceArray;
        return addressSpace;
    }

    public int[] readBlock() throws IOException {
        int[] nArray = new int[1024];
        byte[] byArray = new byte[4160];
        this.dumpReader.read(byArray);
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = Dump.getInt(byArray, n + 16);
            ++n;
        }
        return nArray;
    }

    static String hex(int n, int n2) {
        String string = Integer.toHexString(n);
        int n3 = string.length();
        while (n3 < n2) {
            string = "0" + string;
            ++n3;
        }
        return string;
    }

    public static String hex(int n) {
        return Dump.hex(n, 8);
    }

    static byte fix(int n) {
        int n2 = n & 0xFF;
        if (n2 < 64 || n2 > 64 && n2 < 75 || n2 > 80 && n2 < 90 || n2 > 97 && n2 < 106 || n2 > 111 && n2 < 121 || n2 > 169 && n2 < 188 || n2 > 249) {
            n2 = 64;
        }
        byte by = (byte)n2;
        return by;
    }

    public static String ebcdic(int n) {
        byte[] byArray = new byte[]{Dump.fix(n >> 24), Dump.fix(n >> 16), Dump.fix(n >> 8), Dump.fix(n >> 0)};
        return Dump.getEbcdicString(byArray);
    }

    public final boolean isEbcdic(short s) {
        return (s = (short)(s | 0x40)) >= 193 && s <= 201 || s >= 209 && s <= 217 || s >= 162 && s <= 169 || s >= 240 && s <= 249;
    }

    public final boolean isEbcdic(int n) {
        short s = (short)(n & 0xFF);
        short s2 = (short)(n >> 8 & 0xFF);
        short s3 = (short)(n >> 16 & 0xFF);
        short s4 = (short)(n >> 24 & 0xFF);
        return this.isEbcdic(s) && this.isEbcdic(s2) && this.isEbcdic(s3) && this.isEbcdic(s4);
    }

    public AddressSpace[] addressSpaces() {
        if (this.validSpaces != null) {
            return this.validSpaces;
        }
        Vector vector = new Vector();
        int n = 0;
        while (n < this.spaces.length) {
            AddressSpace addressSpace = this.spaces[n];
            Tcb[] tcbArray = addressSpace.tcbs();
            if (tcbArray != null) {
                vector.add(addressSpace);
            }
            ++n;
        }
        this.validSpaces = (AddressSpace[])vector.toArray(new AddressSpace[1]);
        Arrays.sort(this.validSpaces, new Comparator(){

            public int compare(Object object, Object object2) {
                AddressSpace addressSpace = (AddressSpace)object;
                AddressSpace addressSpace2 = (AddressSpace)object2;
                return addressSpace2.tcbs().length - addressSpace.tcbs().length;
            }
        });
        return this.validSpaces;
    }

    /*
     * Unable to fully structure code
     */
    public void processTrace(AddressSpace var1_1) throws Exception {
        if (Dump.debug) {
            this.doc.println("found trace in asid 0x" + var1_1.hexId());
        }
        var2_2 = var1_1.addresses.get(0);
        var3_3 = var1_1.readShort(var2_2 + 28);
        var4_4 = var1_1.readInt(var2_2 + 32);
        var5_5 = var4_4 >> 16;
        var7_6 = var5_5 <<= 48;
        var9_7 = null;
        var10_8 = 0;
        while (var10_8 < var3_3) {
            if (Dump.debug) {
                this.doc.println("*** processor " + var10_8 + " trace table ***");
            }
            var11_9 = var2_2 + 56 + var10_8 * 8;
            var12_10 = var1_1.readShort(var11_9);
            var13_11 = var1_1.readInt(var11_9 + 4);
            var14_12 = 0;
            var15_13 = 0;
            while (var15_13 < var12_10) {
                var16_14 = var1_1.readShort(var13_11 + var15_13 * 40 + 8);
                if (Dump.debug) {
                    this.doc.println("*** doing buffer section " + var15_13 + " flags " + Dump.hex(var16_14));
                }
                var17_15 = var1_1.readInt(var13_11 + var15_13 * 40);
                var18_16 = var1_1.readInt(var13_11 + var15_13 * 40 + 4);
                var19_17 = 0;
                var20_18 = var17_15;
                while (var20_18 < var17_15 + var18_16) {
                    block44: {
                        block45: {
                            block43: {
                                var21_19 = var1_1.readUnsignedByte(var20_18);
                                if (var21_19 >= 112) break block43;
                                switch (var21_19) {
                                    case 33: {
                                        var19_17 = 8;
                                        break;
                                    }
                                    case 50: {
                                        var19_17 = 12;
                                        break;
                                    }
                                    case 49: {
                                        var19_17 = 8;
                                        break;
                                    }
                                    case 16: {
                                        var19_17 = 4;
                                        break;
                                    }
                                    default: {
                                        if (var21_19 != 0 && Dump.debug) {
                                            this.doc.println("!!! unknown id " + Dump.hex(var21_19));
                                        }
                                        var19_17 = 4;
                                        break;
                                    }
                                }
                                break block44;
                            }
                            if (var21_19 < 128) break block45;
                            var22_20 = var1_1.readInt(var20_18);
                            var19_17 = 4;
                            if (var9_7 != null) {
                                if (Dump.debug) {
                                    this.doc.println("found branch " + Dump.hex(var22_20) + " in asid " + var9_7.hexId());
                                }
                                var9_7.addTraceEntry(0, null, var22_20, var14_12, ++var7_6);
                            }
                            break block44;
                        }
                        var22_20 = var1_1.readShort(var20_18 + 10);
                        var14_12 = var1_1.readInt(var20_18 + 12);
                        var23_21 = var1_1.readShort(var20_18 + 18);
                        var24_22 = var1_1.readInt(var20_18 + 28);
                        var19_17 = 16 + (var21_19 & 15) * 4;
                        var25_23 = "unknown";
                        switch (var22_20) {
                            case 1: {
                                var25_23 = "SSCH";
                                var24_22 = var1_1.readInt(var20_18 + 24);
                                break;
                            }
                            case 3: {
                                var25_23 = "EXT";
                                break;
                            }
                            case 5: {
                                var25_23 = "SVC";
                                var24_22 = var1_1.readInt(var20_18 + 24);
                                break;
                            }
                            case 7: {
                                var25_23 = "PGM";
                                break;
                            }
                            case 11: {
                                var25_23 = "I/O";
                                break;
                            }
                            case 15: {
                                var25_23 = "DSP";
                                break;
                            }
                            case 25: {
                                var25_23 = "SUSP";
                                break;
                            }
                            case 127: {
                                var25_23 = "USR";
                                var24_22 = var1_1.readInt(var20_18 + 24);
                                break;
                            }
                            case 259: {
                                var25_23 = "EMS";
                                break;
                            }
                            case 261: {
                                var25_23 = "SVCR";
                                var24_22 = var1_1.readInt(var20_18 + 24);
                                break;
                            }
                            case 271: {
                                var25_23 = "SRB";
                                var24_22 = var1_1.readInt(var20_18 + 24);
                                break;
                            }
                            case 517: {
                                var25_23 = "SSRV";
                                var24_22 = var1_1.readInt(var20_18 + 20);
                                break;
                            }
                            case 527: {
                                var25_23 = "SSRB";
                                break;
                            }
                            case 771: {
                                var25_23 = "CALL";
                                break;
                            }
                            case 1025: {
                                var25_23 = "RSCH";
                                var24_22 = var1_1.readInt(var20_18 + 24);
                                break;
                            }
                            case 1027: {
                                var25_23 = "CLKC";
                                break;
                            }
                            case 3855: {
                                var25_23 = "WAIT";
                                var24_22 = var1_1.readInt(var20_18 + 20);
                                break block44;
                            }
                            default: {
                                if (Dump.debug) {
                                    this.doc.println("unknown type " + Dump.hex(var22_20) + " id " + Dump.hex(var21_19));
                                }
                                break block44;
                            }
                        }
                        if (Dump.debug) {
                            // empty if block
                        }
                        if (var24_22 != 0 && (var24_22 & 1) == 1 && Dump.debug) {
                            this.doc.println("found dodgy " + var25_23 + ", tcb = " + Dump.hex(var14_12) + " asid = " + Dump.hex(var23_21) + " psw = " + Dump.hex(var24_22));
                        }
                        if (var9_7 != null && var9_7.id == var23_21) ** GOTO lbl-1000
                        var26_24 = 0;
                        while (var26_24 < this.spaces.length) {
                            var27_26 = this.spaces[var26_24];
                            if (var27_26.id == var23_21) {
                                var9_7 = var27_26;
                                break;
                            }
                            ++var26_24;
                        }
                        if (var26_24 == this.spaces.length) {
                            var9_7 = null;
                            if (Dump.debug) {
                                this.doc.println("Warning: could not locate asid " + Dump.hex(var23_21));
                            }
                        } else lbl-1000:
                        // 2 sources

                        {
                            var26_25 = 0L;
                            var28_27 = 0;
                            while (var28_27 < 6) {
                                var26_25 <<= 8;
                                var26_25 |= (long)var1_1.readUnsignedByte(var20_18 + 2 + var28_27);
                                ++var28_27;
                            }
                            var9_7.addTraceEntry(var22_20, var25_23, var24_22, var14_12, var26_25 |= var5_5);
                            var7_6 = var26_25;
                        }
                    }
                    var20_18 += var19_17;
                }
                ++var15_13;
            }
            ++var10_8;
        }
    }

    private void printTrace(Function[] functionArray) {
        Table table = new Table(new String[]{"Count", "Function"});
        int n = 0;
        while (n < functionArray.length) {
            Function function = functionArray[n];
            table.addRow(new String[]{"" + function.entryCount, function.name});
            ++n;
        }
        this.doc.addElement(table);
    }

    static final int arrayLength(int n, int n2) {
        int n3 = n >> 3;
        int n4 = 1 << (n3 & 3);
        n4 *= n2;
        return n4 += 8;
    }

    static void usage() {
        Document document = new Document();
        document.setPlainText(true);
        document.println("");
        document.println("Usage: java com.ibm.jvm.svcdump.Dump [options] <filename>");
        document.println("");
        Table table = new Table("Option", "Description");
        table.addRow("-debug", "print internal debugging info");
        table.addRow("-verbose", "print extra info");
        table.addRow("-heap", "print a table showing which classes have the most objects allocated");
        table.addRow("-cache", "print alloc cache");
        table.addRow("-exception", "print old exception objects");
        table.addRow("-dis <addr> <n>", "disassemble <n> instructions starting at <addr> (hex)");
        table.addRow("-dump <addr> <n>", "dump <n> words of storage starting at <addr> (hex)");
        table.addRow("-dumpclasses", "print info about all classes");
        table.addRow("-dumpclass <addr>", "print info about class at given address");
        table.addRow("-dumpmdata <addr>", "print info about mdata at given address");
        table.addRow("-dumpprops", "print the system properties");
        table.addRow("-dumpnative", "dump all the native methods");
        table.addRow("-systrace", "print the system trace");
        table.addRow("-caa <addr>", "specify the caa to use when disassembling");
        table.addRow("-r<n>", "include saved register <n> in stack trace");
        table.addRow("-args", "print first four function arguments");
        table.addRow("-verifysubpools", "verify subpools");
        table.addRow("-version", "print the version and exit");
        document.addElement(table);
        document.println("");
        document.println("Visit w3.hursley.ibm.com/~dgriff for more info");
        document.println("");
        if (Dump.isFromJFormat()) {
            document.setPlainText(true);
        }
        document.close();
        System.exit(1);
    }

    public static void main(String[] stringArray) throws Exception {
        Object object;
        block72: {
            Object object2;
            if (stringArray.length == 0) {
                Dump.usage();
            }
            Object object3 = null;
            Graph graph = new Graph();
            int n = 0;
            while (n < stringArray.length) {
                object = stringArray[n];
                if (((String)object).startsWith("-")) {
                    if (((String)object).equals("-verbose")) {
                        verbose = true;
                    } else if (((String)object).equals("-debug")) {
                        debug = true;
                        verbose = true;
                    } else if (((String)object).equals("-xxxhelp")) {
                        int n2;
                        object2 = (class$com$ibm$jvm$svcdump$Dump == null ? Dump.class$("com.ibm.jvm.svcdump.Dump") : class$com$ibm$jvm$svcdump$Dump).getResourceAsStream("help.html");
                        while ((n2 = ((InputStream)object2).read()) != -1) {
                            System.out.print((char)n2);
                        }
                        System.exit(0);
                    } else if (((String)object).equals("-dumpprops")) {
                        dumpproperties = true;
                    } else if (((String)object).equals("-dumpmdata")) {
                        dumpmdata = true;
                        mdata = Integer.parseInt(stringArray[n + 1], 16);
                        ++n;
                    } else if (((String)object).equals("-search")) {
                        search = true;
                        searchvalue = Integer.parseInt(stringArray[n + 1], 16);
                        ++n;
                    } else if (((String)object).equals("-systrace")) {
                        systrace = true;
                    } else if (((String)object).equals("-version")) {
                        try {
                            object2 = (class$com$ibm$jvm$svcdump$Dump == null ? Dump.class$("com.ibm.jvm.svcdump.Dump") : class$com$ibm$jvm$svcdump$Dump).getResource("Dump.class");
                            URLConnection uRLConnection = ((URL)object2).openConnection();
                            Date date = new Date(uRLConnection.getLastModified());
                            System.out.println("");
                            System.out.println("You are using");
                            System.out.println("");
                            System.out.println("" + object2);
                            System.out.println("");
                            System.out.println("which was last modified on");
                            System.out.println("");
                            System.out.println("" + date);
                            System.out.println("");
                        }
                        catch (Exception exception) {
                            System.out.println("Unexpected exception: " + exception);
                        }
                        System.exit(0);
                    } else if (((String)object).equals("-verifysubpools")) {
                        verifysubpools = true;
                    } else if (((String)object).equals("-dumpclasses")) {
                        dumpclasses = true;
                    } else if (((String)object).equals("-dumpnative")) {
                        dumpnative = true;
                    } else if (((String)object).equals("-dumpclass")) {
                        dumpclass = Integer.parseInt(stringArray[n + 1], 16);
                        ++n;
                    } else if (((String)object).equals("-heap")) {
                        analyzeHeap = true;
                    } else if (((String)object).equals("-limit")) {
                        limit = Integer.parseInt(stringArray[n + 1]);
                        ++n;
                    } else if (((String)object).equals("-cache")) {
                        printAllocCache = true;
                    } else if (((String)object).equals("-exception")) {
                        printExceptionObject = true;
                    } else if (((String)object).equals("-args")) {
                        printArgs = true;
                    } else if (((String)object).startsWith("-r")) {
                        reg = Integer.parseInt(((String)object).substring(2));
                    } else if (((String)object).equals("-dis")) {
                        disassemble = true;
                        disassembleAddress = Integer.parseInt(stringArray[n + 1], 16);
                        disassembleLength = Integer.parseInt(stringArray[n + 2]);
                        n += 2;
                    } else if (((String)object).equals("-dump")) {
                        dumpstorage = true;
                        dumpstorageAddress = Integer.parseInt(stringArray[n + 1], 16);
                        dumpstorageLength = Integer.parseInt(stringArray[n + 2]);
                        n += 2;
                    } else if (((String)object).equals("-caa")) {
                        caa = Integer.parseInt(stringArray[n + 1], 16);
                        ++n;
                    } else {
                        Dump.usage();
                    }
                } else {
                    object3 = object;
                }
                ++n;
            }
            object = new Dump((String)object3, graph);
            try {
                object2 = ((Dump)object).getCTypedefs();
                if (object2 != null) {
                    new CTypeFile((byte[])object2);
                }
            }
            catch (Throwable throwable) {
                if (!debug) break block72;
                System.out.println("Warning, problem getting typedefs!");
                throwable.printStackTrace(System.out);
            }
        }
        if (disassemble) {
            ((Dump)object).disassemble();
        } else if (dumpstorage) {
            ((Dump)object).dumpstorage();
        } else if (dumpnative) {
            ((Dump)object).dumpnative();
        } else if (dumpclasses) {
            ((Dump)object).dumpclasses();
        } else if (verifysubpools) {
            ((Dump)object).verifysubpools();
        } else if (dumpclass != 0) {
            ((Dump)object).dumpclass(dumpclass);
        } else if (dumpproperties) {
            ((Dump)object).dumpproperties();
        } else if (dumpmdata) {
            ((Dump)object).dumpmdata(mdata);
        } else if (systrace) {
            ((Dump)object).systrace();
        } else if (search) {
            ((Dump)object).search();
        } else {
            ((Dump)object).doStuff();
        }
        ((Dump)object).flush();
    }

    void flush() {
        if (Dump.isFromJFormat()) {
            this.doc.setPlainText(true);
        }
        this.doc.close();
    }

    public AddressSpace getDefaultAddressSpace() {
        AddressSpace addressSpace = null;
        int n = 0;
        while (n < this.spaces.length) {
            if (this.spaces[n].isJava()) {
                if (addressSpace != null && this.defaultAsid == -1) {
                    System.out.println("Warning: more than one java address space found.");
                    System.out.println("You can use the svcdump.default.asid property to specify");
                    System.out.println("which one you want to use (or use the jformat set asid command).");
                    System.out.println("See http://w3.hursley.ibm.com/~dgriff/ for more details");
                }
                addressSpace = this.spaces[n];
                if (debug) {
                    System.out.println("found java asid " + addressSpace.hexId());
                }
                if (addressSpace.id == this.defaultAsid) {
                    return addressSpace;
                }
            }
            ++n;
        }
        if (addressSpace == null) {
            throw new Error("Could not find a Java address space!");
        }
        return addressSpace;
    }

    public Jvm getDefaultJvm() {
        return this.getDefaultAddressSpace().jvms()[0];
    }

    public void disassemble() throws Exception {
        if (Dump.isFromJFormat()) {
            this.doc.setPlainText(true);
        }
        System.out.println("Disassembly starting at 0x" + Dump.hex(disassembleAddress));
        AddressSpace addressSpace = this.getDefaultAddressSpace();
        Engine engine = new Engine(addressSpace);
        if (caa == 0) {
            Instruction[] instructionArray = engine.disassemble(this.doc, disassembleAddress, disassembleLength);
        } else {
            Instruction[] instructionArray = engine.disassemble(this.doc, disassembleAddress, disassembleLength, caa);
        }
    }

    public void dumpstorage() throws Exception {
        if (Dump.isFromJFormat()) {
            this.doc.setPlainText(true);
        }
        this.doc.println("Storage dump starting at 0x" + Dump.hex(dumpstorageAddress));
        AddressSpace addressSpace = this.getDefaultAddressSpace();
        if (dumpstorageLength == 0) {
            this.doc.println(addressSpace.readString(dumpstorageAddress));
        } else {
            int n = 0;
            while (n < dumpstorageLength) {
                int n2 = dumpstorageAddress + (n << 2);
                this.doc.println("0x" + Dump.hex(n2) + ": 0x" + Dump.hex(addressSpace.readInt(n2)));
                ++n;
            }
        }
    }

    public void dumpclasses() throws Exception {
        if (Dump.isFromJFormat()) {
            this.doc.setPlainText(true);
        }
        Jvm jvm = this.getDefaultJvm();
        System.out.println("Dump of all classes in asid " + jvm.space.hexId());
        try {
            jvm.dumpClasses(this.doc, new NullHandler());
        }
        catch (Exception exception) {
            System.out.println("bad heap in asid " + jvm.space.hexId());
            exception.printStackTrace();
        }
    }

    public void verifysubpools() throws Exception {
        if (Dump.isFromJFormat()) {
            this.doc.setPlainText(true);
        }
        Jvm jvm = this.getDefaultJvm();
        System.out.println("Verifying subpools in asid " + jvm.space.hexId());
        try {
            jvm.verifysubpools();
        }
        catch (Exception exception) {
            System.out.println("Unexpected error");
            exception.printStackTrace();
        }
    }

    public void dumpnative() throws Exception {
        if (Dump.isFromJFormat()) {
            this.doc.setPlainText(true);
        }
        Jvm jvm = this.getDefaultJvm();
        System.out.println("Dump of all native methods in asid " + jvm.space.hexId());
        try {
            jvm.dumpNative(this.doc, new NullHandler());
        }
        catch (Exception exception) {
            System.out.println("bad heap in asid " + jvm.space.hexId());
            exception.printStackTrace();
        }
    }

    public void dumpclass(int n) throws Exception {
        if (Dump.isFromJFormat()) {
            this.doc.setPlainText(true);
        }
        Jvm jvm = this.getDefaultJvm();
        try {
            HeapClass heapClass = jvm.getClass(n);
            jvm.dumpClass(this.doc, heapClass, false);
        }
        catch (Exception exception) {
            System.out.println("bad heap in asid " + jvm.space.hexId());
            exception.printStackTrace();
        }
    }

    public void dumpproperties() throws Exception {
        if (Dump.isFromJFormat()) {
            this.doc.setPlainText(true);
        }
        Jvm jvm = this.getDefaultJvm();
        System.out.println("Dump of system properties in asid " + jvm.space.hexId());
        try {
            jvm.dumpProperties(this.doc, new NullHandler());
        }
        catch (Exception exception) {
            System.out.println("bad heap in asid " + jvm.space.hexId());
            exception.printStackTrace();
        }
    }

    public void dumpmdata(int n) throws Exception {
        if (Dump.isFromJFormat()) {
            this.doc.setPlainText(true);
        }
        Jvm jvm = this.getDefaultJvm();
        try {
            jvm.dumpMdata(this.doc, n);
        }
        catch (Exception exception) {
            System.out.println("bad heap in asid " + jvm.space.hexId());
            exception.printStackTrace();
        }
    }

    public void systrace() throws Exception {
        if (Dump.isFromJFormat()) {
            this.doc.setPlainText(true);
        }
        int n = 0;
        while (n < this.spaces.length) {
            AddressSpace addressSpace = this.spaces[n];
            if (addressSpace.isTrace()) {
                block10: {
                    try {
                        this.processTrace(addressSpace);
                    }
                    catch (Exception exception) {
                        if (!debug) break block10;
                        this.doc.println("problem processing trace!");
                    }
                }
                if (debug) {
                    this.doc.println("finished processing trace");
                }
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < this.spaces.length) {
            block11: {
                AddressSpace addressSpace = this.spaces[n2];
                try {
                    if (n2 > 0) {
                        this.doc.println("");
                    }
                    addressSpace.printFullTrace(this.doc);
                }
                catch (Exception exception) {
                    if (!debug) break block11;
                    this.doc.println("problem processing trace!");
                }
            }
            ++n2;
        }
    }

    public void search() throws Exception {
        int n = 0;
        while (n < this.spaces.length) {
            AddressSpace addressSpace = this.spaces[n];
            ++n;
        }
    }

    public void doStuff() {
        if (Dump.isFromJFormat()) {
            this.doc.setPlainText(true);
        }
        if (debug) {
            this.doc.println("finished scan of dump");
        }
        int n = 0;
        while (n < this.spaces.length) {
            AddressSpace addressSpace = this.spaces[n];
            if (addressSpace.isTrace()) {
                block44: {
                    try {
                        this.processTrace(addressSpace);
                    }
                    catch (Exception exception) {
                        if (!debug) break block44;
                        this.doc.println("problem processing trace!");
                    }
                }
                if (debug) {
                    this.doc.println("finished processing trace");
                }
            }
            ++n;
        }
        if (debug) {
            this.doc.println("finished creating Dump instance");
        }
        int n2 = 0;
        while (n2 < this.spaces.length) {
            Tcb[] tcbArray;
            AddressSpace addressSpace = this.spaces[n2];
            if (verbose) {
                this.doc.println("processing asid " + addressSpace.hexId());
            }
            if ((tcbArray = addressSpace.tcbs()) != null && tcbArray.length != 0) {
                Jvm[] jvmArray;
                int n3;
                Object object;
                this.doc.println("found " + tcbArray.length + " TCBs in asid 0x" + addressSpace.hexId());
                this.doc.println("");
                int n4 = 0;
                int n5 = 0;
                int n6 = 0;
                boolean bl = false;
                int n7 = 0;
                while (n7 < tcbArray.length) {
                    Tcb tcb = tcbArray[n7];
                    if (tcb.isKnownType()) {
                        this.printTCBStack(tcb, bl, n4, n5, n6, addressSpace);
                        Function[] functionArray = tcb.traceFunctions();
                        if (functionArray != null) {
                            this.doc.println("found trace table:");
                            this.doc.println("");
                            this.printTrace(functionArray);
                            this.doc.println("");
                        }
                    } else {
                        this.doc.println("TCB of unknown type " + tcb.hexId() + " caa " + Dump.hex(tcb.caa()));
                        bl = true;
                    }
                    ++n7;
                }
                this.doc.println("");
                int n8 = 0;
                while (addressSpace.jvms() != null && n8 < addressSpace.jvms().length) {
                    addressSpace.jvms()[n8].checkTidChain(this.doc);
                    ++n8;
                }
                int n9 = 0;
                while (n9 < tcbArray.length) {
                    object = tcbArray[n9];
                    if (((Tcb)object).tid() != 0) {
                        n3 = 0;
                        Jvm jvm = ((Tcb)object).jvm;
                        try {
                            int n10 = jvm.rootTid;
                            while (n10 != 0) {
                                if (((Tcb)object).tid() == n10) {
                                    if (verbose) {
                                        this.doc.println("found " + Dump.hex(n10) + " in tid chain");
                                    }
                                    n3 = 1;
                                    if (!((Tcb)object).isKnownType()) {
                                        this.doc.println("*** Warning! tcb " + ((Tcb)object).hexId() + " with tid " + Dump.hex(((Tcb)object).tid()) + " is unknown TCB type but known by Java");
                                        ((Tcb)object).printJavaStack(this.doc);
                                    }
                                    break;
                                }
                                n10 = addressSpace.readInt(n10);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (n3 == 0) {
                            this.doc.println("*** Warning! tid " + Dump.hex(((Tcb)object).tid()) + " not found in tid chain");
                        }
                    }
                    ++n9;
                }
                object = addressSpace.traceFunctions();
                if (object != null && ((Object)object).length != 0) {
                    this.doc.println("trace table for asid " + addressSpace.hexId() + ":");
                    this.doc.println("");
                    this.printTrace((Function[])object);
                    this.doc.println("");
                }
                if (n4 != 0) {
                    try {
                        int n11;
                        Object object2;
                        int n12;
                        int n13;
                        n3 = addressSpace.readInt(n4 + 752);
                        int n14 = addressSpace.readInt(n3 + 88);
                        this.doc.printHeader("environment variables:");
                        this.doc.println("");
                        Table table = new Table(new String[]{"key", "value"});
                        int n15 = 0;
                        while ((n15 = addressSpace.readInt(n14)) != 0) {
                            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                            while ((n13 = addressSpace.readUnsignedByte(n15++)) != 0) {
                                byteArrayOutputStream.write(n13);
                            }
                            String string = Dump.getEbcdicString(byteArrayOutputStream.toByteArray());
                            n12 = string.indexOf(61);
                            object2 = string.substring(0, n12);
                            String string2 = string.substring(n12 + 1);
                            table.addRow(new String[]{object2, string2});
                            n14 += 4;
                        }
                        this.doc.addElement(table);
                        this.doc.println("");
                        this.doc.printHeader("loaded dlls:");
                        this.doc.println("");
                        table = new Table(new String[]{"name", "wsa"});
                        int n16 = addressSpace.readInt(n3 + 1096);
                        while (n16 != 0) {
                            n13 = addressSpace.readShort(n16 + 60);
                            int n17 = addressSpace.readInt(n16 + 64);
                            n12 = addressSpace.readInt(n16 + 20);
                            object2 = new ByteArrayOutputStream();
                            n11 = 0;
                            while (n11 < n13) {
                                int n18 = addressSpace.readUnsignedByte(n17++);
                                ((ByteArrayOutputStream)object2).write(n18);
                                ++n11;
                            }
                            String string = Dump.getEbcdicString(((ByteArrayOutputStream)object2).toByteArray());
                            table.addRow(new String[]{string, Dump.hex(n12)});
                            n16 = addressSpace.readInt(n16);
                        }
                        this.doc.addElement(table);
                        this.doc.println("");
                        this.doc.printHeader("le runtime options:");
                        this.doc.println("");
                        table = new Table(new String[]{"option", "suboption", "value"});
                        n13 = addressSpace.readInt(n3 + 16);
                        int n19 = n13 + addressSpace.readInt(n13 + 240);
                        n12 = addressSpace.readUnsignedByte(n19 + 4);
                        if ((n12 & 0x80) != 0) {
                            int n20 = addressSpace.readUnsignedByte(n19 + 5);
                            table.addRow("STORAGE", "heap_alloc_value", Dump.hex(n20, 2));
                        } else {
                            table.addRow("STORAGE", "heap_alloc_value", "NONE");
                        }
                        if ((n12 & 0x40) != 0) {
                            int n21 = addressSpace.readUnsignedByte(n19 + 6);
                            table.addRow("STORAGE", "heap_free_value", Dump.hex(n21, 2));
                        } else {
                            table.addRow("STORAGE", "heap_free_value", "NONE");
                        }
                        if ((n12 & 0x20) != 0) {
                            int n22 = addressSpace.readUnsignedByte(n19 + 7);
                            table.addRow("STORAGE", "dsa_alloc_value", Dump.hex(n22, 2));
                        } else {
                            table.addRow("STORAGE", "dsa_alloc_value", "NONE");
                        }
                        int n23 = n13 + addressSpace.readInt(n13 + 232);
                        int n24 = addressSpace.readInt(n23 + 4);
                        table.addRow("STACK", "init_size", "" + n24);
                        n11 = addressSpace.readInt(n23 + 8);
                        table.addRow("STACK", "incr_size", "" + n11);
                        n12 = addressSpace.readUnsignedByte(n23 + 12);
                        table.addRow("STACK", "location", (n12 & 0x80) == 0 ? "ANYWHERE" : "BELOW");
                        table.addRow("STACK", "disposition", (n12 & 0x40) == 0 ? "KEEP" : "FREE");
                        this.doc.addElement(table);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((jvmArray = addressSpace.jvms()) != null) {
                    int n25 = 0;
                    while (n25 < jvmArray.length) {
                        Jvm jvm = jvmArray[n25];
                        if (analyzeHeap) {
                            try {
                                jvm.analyzeHeap(this.doc, new NullHandler());
                            }
                            catch (Exception exception) {
                                this.doc.println("bad heap in asid " + addressSpace.hexId());
                                exception.printStackTrace();
                            }
                        }
                        ++n25;
                    }
                }
            }
            ++n2;
        }
    }

    public Jvm[] jvms() {
        Vector vector = new Vector();
        int n = 0;
        while (n < this.spaces.length) {
            AddressSpace addressSpace = this.spaces[n];
            Tcb[] tcbArray = addressSpace.tcbs();
            int n2 = 0;
            while (n2 < tcbArray.length) {
                Tcb tcb = tcbArray[n2];
                if (tcb.isKnownType()) {
                    Dsa dsa = tcb.topDsa;
                    while (dsa != null) {
                        dsa.function();
                        dsa = dsa.previous();
                    }
                }
                ++n2;
            }
            if (addressSpace.jvms() != null) {
                int n3 = 0;
                while (n3 < addressSpace.jvms().length) {
                    vector.addElement(addressSpace.jvms()[n3]);
                    ++n3;
                }
            }
            ++n;
        }
        return (Jvm[])vector.toArray(new Jvm[0]);
    }

    public static String getEbcdicString(byte[] byArray) {
        try {
            int n = 0;
            while (n < byArray.length) {
                if (byArray[n] == -83) {
                    byArray[n] = 74;
                } else if (byArray[n] == -67) {
                    byArray[n] = 90;
                }
                ++n;
            }
            return new String(byArray, "Cp500");
        }
        catch (Exception exception) {
            throw new Error("No Cp500");
        }
    }

    static void Assert(boolean bl) {
        if (!bl) {
            throw new Error("assert failed!");
        }
    }

    public void printStacks() {
        if (Dump.isFromJFormat()) {
            this.doc.setPlainText(true);
        }
        if (debug) {
            this.doc.println("finished scan of dump");
        }
        int n = 0;
        while (n < this.spaces.length) {
            Tcb[] tcbArray;
            AddressSpace addressSpace = this.spaces[n];
            if (verbose) {
                this.doc.println("processing asid " + addressSpace.hexId());
            }
            if ((tcbArray = addressSpace.tcbs()) != null && tcbArray.length != 0) {
                this.doc.println("found " + tcbArray.length + " TCBs in asid 0x" + addressSpace.hexId());
                this.doc.println("");
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                boolean bl = false;
                int n5 = 0;
                while (n5 < tcbArray.length) {
                    Tcb tcb = tcbArray[n5];
                    if (tcb.isKnownType()) {
                        this.printTCBStack(tcb, bl, n2, n3, n4, addressSpace);
                    } else {
                        this.doc.println("TCB of unknown type " + tcb.hexId() + " caa " + Dump.hex(tcb.caa()));
                        bl = true;
                    }
                    ++n5;
                }
                this.doc.println("");
            }
            ++n;
        }
    }

    private void printTCBStack(Tcb tcb, boolean bl, int n, int n2, int n3, AddressSpace addressSpace) {
        Object object;
        Table table;
        int[] nArray;
        if (bl) {
            this.doc.println("");
            bl = false;
        }
        this.doc.print("TCB " + tcb.hexId() + " tid " + Dump.hex(tcb.tid()));
        if (tcb.threadIndex() != 0) {
            this.doc.print(" tindex " + Dump.hex(tcb.threadIndex()));
        }
        if (tcb.tid_type() != -1) {
            this.doc.print(" tid type 0x" + Dump.hex(tcb.tid_type()));
        }
        if (tcb.tid_state() != -1) {
            this.doc.print(" tid state 0x" + Dump.hex(tcb.tid_state()));
        }
        if (tcb.tid_singled() != -1) {
            this.doc.print(" tid singled 0x" + Dump.hex(tcb.tid_singled()));
        }
        if (tcb.jvm != null) {
            this.doc.print(" jvmp " + Dump.hex(tcb.jvm.jvmp));
            this.doc.print(" ee " + Dump.hex(tcb.ee()));
        }
        this.doc.println(tcb.caa() == 0 ? "" : " caa " + Dump.hex(tcb.caa()));
        this.doc.println("");
        if (tcb.caa() != 0 && !tcb.dodgy && n == 0) {
            n = tcb.caa();
        }
        if ((nArray = tcb.failingRegisters()) != null) {
            this.doc.println("Registers at point of failure:");
            table = new Table();
            table.setBorder(0);
            table.addRow(new String[]{"r0:", Dump.hex(nArray[0]), "r1:", Dump.hex(nArray[1]), "r2:", Dump.hex(nArray[2]), "r3:", Dump.hex(nArray[3])});
            table.addRow(new String[]{"r4:", Dump.hex(nArray[4]), "r5:", Dump.hex(nArray[5]), "r6:", Dump.hex(nArray[6]), "r7:", Dump.hex(nArray[7])});
            table.addRow(new String[]{"r8:", Dump.hex(nArray[8]), "r9:", Dump.hex(nArray[9]), "r10:", Dump.hex(nArray[10]), "r11:", Dump.hex(nArray[11])});
            table.addRow(new String[]{"r12:", Dump.hex(nArray[12]), "r13:", Dump.hex(nArray[13]), "r14:", Dump.hex(nArray[14]), "r15:", Dump.hex(nArray[15])});
            table.addRow(new String[]{"psw:", Dump.hex(nArray[16]), "", Dump.hex(nArray[17])});
            this.doc.addElement(table);
            this.doc.println("");
        }
        table = new Table();
        table.suppressEmptyColumns(true);
        table.addHeaderCell("Dsa");
        table.addHeaderCell("Entry");
        table.addHeaderCell("Offset");
        if (reg != -1) {
            object = reg < 10 ? "r" + reg + " " : "r" + reg;
            table.addHeaderCell((String)object);
        }
        table.addHeaderCell("Function");
        if (tcb.isJava()) {
            table.addHeaderCell("Method");
        }
        table.addHeaderCell("Module");
        object = tcb.topDsa;
        while (object != null) {
            Row row = new Row();
            row.addCell(Dump.hex(((Dsa)object).address));
            row.addCell(Dump.hex(((Dsa)object).entryPoint()));
            row.addCell(Dump.hex(((Dsa)object).offset()));
            if (reg != -1) {
                row.addCell(Dump.hex(((Dsa)object).reg(reg)));
            }
            row.addCell(((Dsa)object).function());
            if (tcb.isJava()) {
                row.addCell(((Dsa)object).method());
            }
            row.addCell(((Dsa)object).program());
            table.addRow(row);
            object = ((Dsa)object).previous();
        }
        this.doc.addElement(table);
        if (tcb.isJava()) {
            tcb.printJavaStack(this.doc);
        }
        if (tcb.hasPendingException() || printExceptionObject) {
            tcb.printException(this.doc);
        }
        if (printAllocCache && tcb.tid() != 0) {
            tcb.printAllocCache(this.doc);
        }
        if (tcb.tid() != 0 && tcb.jvm != null) {
            int n4 = 0;
            Jvm jvm = tcb.jvm;
            try {
                int n5 = tcb.tid();
                while (n5 != 0) {
                    ++n4;
                    n5 = addressSpace.readInt(n5);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (n4 > jvm.longestTidChain) {
                jvm.longestTidChain = n4;
                jvm.rootTid = tcb.tid();
            }
        }
        this.doc.println("");
    }

    protected static boolean isFromJFormat() {
        return fromJFormat;
    }

    public void setFromJFormat(boolean bl) {
        fromJFormat = bl;
    }

    public static void setDisassemble(boolean bl) {
        disassemble = bl;
    }

    public static void setDisassembleAddress(int n) {
        disassembleAddress = n;
    }

    public static void setDisassembleLength(int n) {
        disassembleLength = n;
    }

    public static void setDumpstorage(boolean bl) {
        dumpstorage = bl;
    }

    public static void setDumpstorageAddress(int n) {
        dumpstorageAddress = n;
    }

    public static void setDumpstorageLength(int n) {
        dumpstorageLength = n;
    }

    public static void setDumpclasses(boolean bl) {
        dumpclasses = bl;
    }

    public static void setDumpclass(int n) {
        dumpclass = n;
    }

    public static void setSystrace(boolean bl) {
        systrace = bl;
    }

    public static void setDumpmdata(boolean bl) {
        dumpmdata = bl;
    }

    public static void setAnalyzeHeap(boolean bl) {
        analyzeHeap = bl;
    }

    public static void setReg(int n) {
        reg = n;
    }

    public boolean isSvcdump() {
        return this.svcdump;
    }

    public AddressSpace[] getSpaces() {
        return this.spaces;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        dumpstorage = false;
        dumpclasses = false;
        dumpnative = false;
        verifysubpools = false;
        dumpclass = 0;
        dumpproperties = false;
        dumpmdata = false;
        mdata = 0;
        systrace = false;
        search = false;
        limit = 10;
        fromJFormat = false;
        arrayLength = 0;
        arrayCount = 0;
        objectCount = 0;
        reg = -1;
    }
}

