/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.svcdump;

import com.ibm.jvm.svcdump.Dump;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;

class DumpReader {
    static final int HEADERSIZE = 64;
    static final int BLOCKSIZE = 4160;
    static final boolean USE_JRIO = false;
    String filename;
    RandomAccessFile raf;
    Object rarf;
    Method seekMethod;
    Method readMethod;
    Method closeMethod;
    int fp;
    int[] fpos = new int[8];
    int blockSize;
    int recordsPerBlock;
    int lowerLimit;
    boolean debug = false;
    ThreadLocalMvsDumpReader mvsDumpReaderWrapper = new ThreadLocalMvsDumpReader();
    static /* synthetic */ Class class$java$lang$String;

    DumpReader(String string) throws Exception {
        try {
            this.raf = new RandomAccessFile(string, "r");
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string2 = System.getProperty("svcdump.libpath");
            if (string2 == null) {
                try {
                    System.loadLibrary("svcdump");
                }
                catch (Exception exception) {
                    if (System.getProperty("os.arch").equals("390")) {
                        throw new Exception("file " + string + " not found in HFS and no svcdump.libpath set");
                    }
                    throw new Exception("file " + string + " not found");
                }
            } else {
                System.load(string2 + System.getProperty("file.separator") + "libsvcdump.so");
            }
            this.open("//'" + string + "'");
            Dump.Assert(this.recordsPerBlock == this.blockSize / 4160);
            Dump.Assert(this.lowerLimit > 0);
        }
        int n = this.readInt();
        if (n != -992349888 && n != -992349632) {
            this.close();
            throw new Exception("bad magic: " + Dump.hex(n));
        }
        this.seek(0);
    }

    DumpReader(File file) throws Exception {
        this(file.getPath());
    }

    void seek(int n) throws IOException {
        if (this.debug) {
            System.out.println("enter seek: " + n);
        }
        if (this.raf != null) {
            this.raf.seek(n * 4160);
        } else {
            this.setpos(n);
        }
        if (this.debug) {
            System.out.println("exit seek: " + n);
        }
    }

    void read(byte[] byArray) throws IOException {
        Dump.Assert(byArray.length == 4160);
        if (this.debug) {
            System.out.println("enter read");
        }
        if (this.raf != null) {
            this.raf.readFully(byArray);
        } else {
            int n = this.fread(byArray);
            if (n <= 0) {
                throw new EOFException();
            }
        }
        if (this.debug) {
            System.out.println("exit read");
        }
    }

    int readInt() throws IOException {
        byte[] byArray = new byte[4160];
        this.read(byArray);
        return DumpReader.getInt(byArray, 0);
    }

    static int getInt(byte[] byArray, int n) {
        int n2 = byArray[n <<= 2] << 24;
        int n3 = byArray[n + 1] << 16 & 0xFFFFFF;
        int n4 = byArray[n + 2] << 8 & 0xFFFF;
        int n5 = byArray[n + 3] & 0xFF;
        return n2 | n3 | n4 | n5;
    }

    void close() throws IOException {
        if (this.raf != null) {
            this.raf.close();
        }
    }

    public native void open(String var1);

    public native void setpos(int var1);

    public native int fread(byte[] var1);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class MvsDumpReader {
        MvsDumpReader(String string) {
        }
    }

    class ThreadLocalMvsDumpReader
    extends ThreadLocal {
        ThreadLocalMvsDumpReader() {
        }

        protected Object initialValue() {
            return new MvsDumpReader(DumpReader.this.filename);
        }
    }
}

