/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.svcdump;

import com.ibm.jvm.findroots.HeapdumpContentHandler;
import com.ibm.jvm.findroots.SimpleGraph;
import com.ibm.jvm.findroots.Visitor;
import com.ibm.jvm.svcdump.AddressSpace;
import com.ibm.jvm.svcdump.Base;
import com.ibm.jvm.svcdump.Heap;
import com.ibm.jvm.svcdump.HeapClass;
import com.ibm.jvm.svcdump.HeapObject;
import com.ibm.jvm.svcdump.HeapVisitor;
import com.ibm.jvm.svcdump.Jvm;
import com.ibm.jvm.svcdump.Tcb;
import java.util.BitSet;
import java.util.Enumeration;
import sun.misc.SoftCache;

public class Heap
extends Base
implements HeapdumpContentHandler {
    Jvm jvm;
    AddressSpace space;
    int numberOfObjects;
    Heap us = this;
    SimpleGraph graph;
    boolean verbose = true;
    SoftCache objectCache = new SoftCache();
    SoftCache classCache = new SoftCache();

    Heap(Jvm jvm) {
        this.jvm = jvm;
        this.space = jvm.space;
    }

    public boolean verbose() {
        return this.verbose;
    }

    public HeapClass getClass(String string) {
        HeapClass heapClass = (HeapClass)this.classCache.get(string);
        if (heapClass == null) {
            Enumeration enumeration = this.getObjects();
            while (enumeration.hasMoreElements()) {
                HeapObject heapObject = (HeapObject)enumeration.nextElement();
                heapClass = heapObject.getHeapClass();
                if (!heapClass.getName().equals(string)) continue;
                this.classCache.put(string, heapClass);
                break;
            }
        }
        return heapClass;
    }

    public HeapObject getObject(int n) {
        Integer n2 = new Integer(n);
        HeapObject heapObject = (HeapObject)this.objectCache.get(n2);
        if (heapObject == null) {
            heapObject = new HeapObject(this, n);
            this.objectCache.put(n2, heapObject);
        }
        return heapObject;
    }

    public int numberOfObjects() {
        if (this.numberOfObjects == 0) {
            Enumeration enumeration = this.getObjects();
            while (enumeration.hasMoreElements()) {
                ++this.numberOfObjects;
                enumeration.nextElement();
            }
        }
        return this.numberOfObjects;
    }

    public Enumeration getObjects() {
        return new Enumeration(){
            boolean doneMH;
            boolean doneTH;
            boolean doneTLH;
            int chunk;
            int chunkLimit;
            int tcbIndex;
            int count;
            {
                this.doneMH = Heap.this.jvm.mh_heapbase == Heap.this.jvm.mh_heaplimit;
                this.doneTH = Heap.this.jvm.th_heapbase == Heap.this.jvm.th_heaplimit;
                this.doneTLH = false;
                this.chunk = Heap.this.jvm.mh_heapbase;
                this.chunkLimit = Heap.this.jvm.mh_heaplimit;
                this.tcbIndex = -1;
                this.findNextChunk();
            }

            void nextChunk() {
                try {
                    int n = Heap.this.space.readInt(this.chunk) & 0x3FFFFFF8;
                    if (n == 0) {
                        throw new Exception("bad length");
                    }
                    this.chunk += n;
                }
                catch (Exception exception) {
                    this.chunk = this.chunkLimit;
                }
            }

            void findNextChunk() {
                while (this.chunk < this.chunkLimit) {
                    if (this.doneMH && this.doneTH || Heap.this.jvm.isLiveChunk(this.chunk)) {
                        return;
                    }
                    this.nextChunk();
                }
                if (!this.doneMH) {
                    this.doneMH = true;
                    if (!this.doneTH) {
                        this.chunk = Heap.this.jvm.th_heapbase;
                        this.chunkLimit = Heap.this.jvm.th_heaplimit;
                        this.findNextChunk();
                        return;
                    }
                }
                this.doneTH = true;
                ++this.tcbIndex;
                Tcb[] tcbArray = Heap.this.space.tcbs();
                while (this.tcbIndex < tcbArray.length) {
                    if (tcbArray[this.tcbIndex].jvm == Heap.this.jvm) {
                        this.chunk = tcbArray[this.tcbIndex].cacheBlock() + tcbArray[this.tcbIndex].cacheSize();
                        this.chunkLimit = tcbArray[this.tcbIndex].cacheBlock() + tcbArray[this.tcbIndex].cacheOrigSize();
                        this.findNextChunk();
                        return;
                    }
                    ++this.tcbIndex;
                }
            }

            public boolean hasMoreElements() {
                return this.chunk < this.chunkLimit;
            }

            public Object nextElement() {
                HeapObject heapObject = Heap.this.getObject(this.chunk + 4);
                ++this.count;
                this.nextChunk();
                this.findNextChunk();
                return heapObject;
            }
        };
    }

    void checkHeapScanned() {
        if (this.graph == null) {
            this.graph = new SimpleGraph();
            try {
                this.log("begin scan heap");
                this.jvm.scanHeap(this, false);
                this.log("end scan heap");
            }
            catch (Exception exception) {
                throw new Error("uh oh: " + exception);
            }
            this.graph.complete();
        }
    }

    int numberOfReachableObjects(int n, BitSet bitSet) {
        this.checkHeapScanned();
        int n2 = this.graph.reachFrom(n, bitSet);
        return n2;
    }

    int numberOfReachableObjects(int n) {
        return this.numberOfReachableObjects(n, new BitSet());
    }

    public Object depthFirstSearch(int n, HeapVisitor heapVisitor) {
        this.checkHeapScanned();
        int n2 = this.graph.idToIndex(n);
        class DfsVisitor
        extends Visitor {
            HeapVisitor visitor;
            private final /* synthetic */ Heap this$0;

            DfsVisitor(Heap heap, HeapVisitor heapVisitor) {
                this.this$0 = heap;
                this.visitor = heapVisitor;
            }

            public void init() {
                this.visitor.init();
            }

            public void enterNode(int n, int n2) {
                this.visitor.enterNode(this.this$0.getObject(this.this$0.graph.id(n)), n2);
            }

            public boolean continueSearch(int n, int n2) {
                return this.visitor.continueSearch(n2);
            }

            public Object result() {
                return this.visitor.result();
            }
        }
        return this.graph.dfs(new DfsVisitor(this, heapVisitor), n2);
    }

    HeapObject[] getChildrenOf(HeapObject heapObject) {
        return null;
    }

    public void instanceDump(int n, String string, int[] nArray, int n2) {
        this.graph.addVertex(n, nArray, n2);
    }

    public void classDump(int n, String string, int[] nArray, int n2) {
        this.graph.addVertex(n, nArray, n2);
    }

    public void objectArrayDump(int n, String string, int[] nArray, int n2) {
        this.graph.addVertex(n, nArray, n2);
    }

    public void primitiveArrayDump(int n, int n2, int n3) {
        this.graph.addVertex(n, n3);
    }

    public void error(String string) {
        throw new Error("not implemented");
    }

    public void addEdge(int n, int n2) {
        throw new Error("not implemented");
    }
}

