/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.svcdump;

import com.ibm.jvm.dump.format.CType;
import com.ibm.jvm.svcdump.AddressSpace;
import com.ibm.jvm.svcdump.Base;
import com.ibm.jvm.svcdump.Heap;
import com.ibm.jvm.svcdump.HeapField;
import com.ibm.jvm.svcdump.HeapMethod;
import com.ibm.jvm.svcdump.Jvm;
import com.ibm.jvm.util.IntegerArray;

public class HeapClass
extends Base {
    Jvm jvm;
    int address;
    String type;
    String name;
    int[] staticReferences;
    AddressSpace space;
    static HeapClass javaLangClass;
    static HeapClass javaLangString;
    boolean doneReferenceCheck;
    boolean isInstanceOfReference;
    boolean doneSuperClassCheck;
    HeapClass superClass;
    Heap heap;
    HeapClass arrayClass;
    int objectOffsets = -1;
    static HeapClass[] primitiveArrayClasses;
    static String[] arrayName;

    HeapClass(Jvm jvm, int n, String string) {
        this.jvm = jvm;
        this.address = n;
        this.type = this.type;
        this.name = string.intern();
        this.space = jvm.space;
        this.heap = jvm.getHeap();
    }

    HeapClass(Jvm jvm, HeapClass heapClass) {
        this.name = "array of " + heapClass.getName();
        this.name = this.name.intern();
    }

    HeapClass(String string) {
        this.name = string.intern();
    }

    static HeapClass getPrimitiveArrayClass(int n) {
        if (primitiveArrayClasses[n] == null) {
            HeapClass.primitiveArrayClasses[n] = new HeapClass(arrayName[n]);
        }
        return primitiveArrayClasses[n];
    }

    public HeapField getField(String string) {
        try {
            return new HeapField(this, this.getFieldPointer(string));
        }
        catch (Exception exception) {
            throw new Error("field " + string + " not found in class " + this.name);
        }
    }

    HeapClass getArrayClass() {
        if (this.arrayClass == null) {
            this.arrayClass = new HeapClass(this.jvm, this);
        }
        return this.arrayClass;
    }

    public int getAddress() {
        Base.Assert(this.address != 0);
        return this.address;
    }

    boolean isJavaLangClass() {
        if (javaLangClass != null) {
            return this == javaLangClass;
        }
        if (this.name.equals("java/lang/Class")) {
            javaLangClass = this;
            return true;
        }
        return false;
    }

    boolean isJavaLangString() {
        if (javaLangString != null) {
            return this == javaLangString;
        }
        if (this.name.equals("java/lang/String")) {
            javaLangString = this;
            return true;
        }
        return false;
    }

    int[] staticReferences() throws Exception {
        if (this.staticReferences != null) {
            return this.staticReferences;
        }
        int n = this.cbDeclaredFields();
        int n2 = this.cbFieldsCount();
        IntegerArray integerArray = null;
        if (n != 0 && n2 > 0) {
            int n3 = 0;
            while (n3 < n2) {
                int n4;
                int n5;
                int n6 = n + n3 * 24;
                if (this.fbIsStatic(n6) && this.fbIsReference(n6) && (n5 = this.space.readInt(n4 = this.fbStaticValueAddress(n6))) != 0 && this.jvm.stIsValidHandle(n5)) {
                    if (integerArray == null) {
                        integerArray = new IntegerArray();
                    }
                    integerArray.add(n5);
                }
                ++n3;
            }
        }
        this.staticReferences = integerArray == null ? new int[]{} : integerArray.toArray();
        return this.staticReferences;
    }

    int getStaticField(String string) throws Exception {
        int n = this.cbDeclaredFields();
        int n2 = this.cbFieldsCount();
        if (n != 0 && n2 > 0) {
            int n3 = 0;
            while (n3 < n2) {
                int n4;
                int n5;
                int n6 = n + n3 * 24;
                if (this.fbIsStatic(n6) && this.fbIsReference(n6) && this.fbName(n6).equals(string) && (n5 = this.space.readInt(n4 = this.fbStaticValueAddress(n6))) != 0 && this.jvm.stIsValidHandle(n5)) {
                    return n5;
                }
                ++n3;
            }
        }
        return -1;
    }

    int getFieldOffset(String string) throws Exception {
        int n = this.cbDeclaredFields();
        int n2 = this.cbFieldsCount();
        if (n != 0 && n2 > 0) {
            int n3 = 0;
            while (n3 < n2) {
                int n4 = n + n3 * 24;
                if (!this.fbIsStatic(n4) && this.fbName(n4).equals(string)) {
                    return this.fbStaticValueAddress(n4);
                }
                ++n3;
            }
        }
        throw new Exception("Field not found: " + string);
    }

    char getFieldType(String string) throws Exception {
        int n = this.cbDeclaredFields();
        int n2 = this.cbFieldsCount();
        if (n != 0 && n2 > 0) {
            int n3 = 0;
            while (n3 < n2) {
                int n4 = n + n3 * 24;
                if (!this.fbIsStatic(n4) && this.fbName(n4).equals(string)) {
                    return this.fbFieldType(n4);
                }
                ++n3;
            }
        }
        throw new Exception("Field not found: " + string);
    }

    int getFieldPointer(String string) throws Exception {
        int n = this.cbDeclaredFields();
        int n2 = this.cbFieldsCount();
        if (n != 0 && n2 > 0) {
            int n3 = 0;
            while (n3 < n2) {
                int n4 = n + n3 * 24;
                if (!this.fbIsStatic(n4) && this.fbName(n4).equals(string)) {
                    return n4;
                }
                ++n3;
            }
        }
        throw new Exception("Field not found: " + string);
    }

    int cbObjectOffsets() throws Exception {
        if (this.objectOffsets == -1) {
            this.objectOffsets = this.space.readInt(this.address + 184);
        }
        return this.objectOffsets;
    }

    int cbDeclaredMethods() throws Exception {
        return this.space.readInt(this.address + 100);
    }

    int cbDeclaredFields() throws Exception {
        return this.space.readInt(this.address + 104);
    }

    int cbMethodsCount() throws Exception {
        return this.space.readShort(this.address + 146);
    }

    int cbFieldsCount() throws Exception {
        return this.space.readShort(this.address + 148);
    }

    HeapClass cbSuperclass() throws Exception {
        if (this.doneSuperClassCheck) {
            return this.superClass;
        }
        this.doneSuperClassCheck = true;
        int n = this.space.readInt(this.address + 76);
        if (n != 0) {
            this.superClass = this.jvm.getClass(n);
        }
        return this.superClass;
    }

    boolean isInstanceOfReference() throws Exception {
        if (this.doneReferenceCheck) {
            return this.isInstanceOfReference;
        }
        this.doneReferenceCheck = true;
        if (this.name.equals("java/lang/ref/Reference")) {
            if (this.verbose()) {
                System.out.println("found reference subclass: " + this.name);
            }
            this.isInstanceOfReference = true;
        } else if (this.cbSuperclass() != null && this.cbSuperclass().isInstanceOfReference()) {
            if (this.verbose()) {
                System.out.println("found reference subclass: " + this.name);
            }
            this.isInstanceOfReference = true;
        }
        return this.isInstanceOfReference;
    }

    boolean fbIsStatic(int n) throws Exception {
        return (this.space.readShort(n + 12) & 8) != 0;
    }

    boolean fbIsReference(int n) throws Exception {
        return (this.space.readShort(n + 14) & 2) != 0;
    }

    int fbStaticValueAddress(int n) throws Exception {
        return this.space.readInt(n + 20);
    }

    String cbSourceName() throws Exception {
        int n = CType.offsetof("Classjava_lang_Class", "source_name", 64);
        int n2 = this.space.readInt(this.address + 8 + n);
        try {
            return this.space.readString(n2);
        }
        catch (Exception exception) {
            return "";
        }
    }

    String fbSignature(int n) throws Exception {
        int n2 = this.space.readInt(n + 4);
        return this.space.readString(n2);
    }

    char fbFieldType(int n) throws Exception {
        return this.fbSignature(n).charAt(0);
    }

    String mbName(int n) throws Exception {
        int n2 = this.space.readInt(n + 8);
        return this.space.readString(n2);
    }

    String fbName(int n) throws Exception {
        return this.mbName(n);
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.name;
    }

    public HeapMethod[] getMethods() throws Exception {
        int n = this.cbMethodsCount();
        HeapMethod[] heapMethodArray = new HeapMethod[n];
        int n2 = this.cbDeclaredMethods();
        int n3 = 0;
        while (n3 < n) {
            int n4 = n2 + n3 * 100;
            heapMethodArray[n3] = new HeapMethod(this, n4);
            ++n3;
        }
        return heapMethodArray;
    }

    public HeapField[] getFields() throws Exception {
        int n = this.cbFieldsCount();
        HeapField[] heapFieldArray = new HeapField[n];
        int n2 = this.cbDeclaredFields();
        int n3 = 0;
        while (n3 < n) {
            int n4 = n2 + n3 * 24;
            heapFieldArray[n3] = new HeapField(this, n4);
            ++n3;
        }
        return heapFieldArray;
    }

    public boolean equals(Object object) {
        if (!(object instanceof HeapClass)) {
            return false;
        }
        HeapClass heapClass = (HeapClass)object;
        return heapClass.name == this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    static {
        primitiveArrayClasses = new HeapClass[16];
        arrayName = new String[]{"unknown array type", "unknown array type", "array of references", "unknown array type", "array of boolean", "array of char", "array of float", "array of double", "array of byte", "array of short", "array of int", "array of long", "array of unsigned byte", "array of unsigned char", "array of unsigned int", "array of unsigned long"};
    }
}

