/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.svcdump;

import com.ibm.jvm.dump.format.CType;
import com.ibm.jvm.svcdump.AddressSpace;
import com.ibm.jvm.svcdump.Base;
import com.ibm.jvm.svcdump.HeapClass;
import com.ibm.jvm.svcdump.Jvm;

public class HeapMethod
extends Base {
    Jvm jvm;
    int mb;
    AddressSpace space;
    HeapClass classclass;
    String fullname;
    String fullnameNoSig;

    HeapMethod(HeapClass heapClass, int n) {
        this.jvm = heapClass.jvm;
        this.mb = n;
        this.classclass = heapClass;
        this.space = this.jvm.space;
    }

    HeapMethod(Jvm jvm, int n) throws Exception {
        this.space = jvm.space;
        int n2 = this.space.readInt(n);
        this.classclass = jvm.getClass(n2);
        this.jvm = jvm;
        this.mb = n;
    }

    String fullname() throws Exception {
        if (this.fullname == null) {
            this.fullname = this.classclass + "." + this;
        }
        return this.fullname;
    }

    String fullnameNoSig() throws Exception {
        if (this.fullnameNoSig == null) {
            this.fullnameNoSig = this.classclass + "." + this.mbName();
        }
        return this.fullnameNoSig;
    }

    String mbName() throws Exception {
        int n = this.space.readInt(this.mb + 8);
        return this.space.readString(n);
    }

    String mbSignature() throws Exception {
        int n = this.space.readInt(this.mb + 4);
        return this.space.readString(n);
    }

    public String toString() {
        try {
            return this.mbName() + " " + this.mbSignature();
        }
        catch (Exception exception) {
            throw new Error("error getting mbName: " + exception);
        }
    }

    public int mbLocalVariableCount() throws Exception {
        return this.space.readShort(this.mb + 68);
    }

    int mbByteCode() throws Exception {
        int n = CType.offsetof("methodblock", "code", 20);
        int n2 = this.space.readInt(this.mb + n);
        return n2;
    }

    int mbAccess() throws Exception {
        int n = CType.offsetof("methodblock", "member", 0);
        int n2 = CType.offsetof("MemberBlock", "access", 12);
        int n3 = this.space.readShort(this.mb + n + n2);
        return n3;
    }

    boolean mbIsNative() throws Exception {
        return (this.mbAccess() & 0x100) != 0;
    }

    /*
     * Unable to fully structure code
     */
    int pc2LineNumber(int var1_1) throws Exception {
        block4: {
            var2_2 = var1_1 - this.mbByteCode();
            var3_3 = this.mbLineNumberTable();
            if (var3_3.length <= 0) break block4;
            var5_4 = 0;
            var6_5 = var3_3.length;
            if (var2_2 < var3_3[var5_4].pc) {
                throw new Error("pc_offset " + var2_2 + " smaller than " + var3_3[var5_4].pc);
            }
            if (var2_2 < var3_3[var6_5 - 1].pc) ** GOTO lbl20
            var4_6 = var3_3[var6_5 - 1].line_number;
            return var4_6;
lbl-1000:
            // 1 sources

            {
                var7_8 = var5_4 + var6_5 >> 1;
                if (var2_2 < var3_3[var7_8].pc) {
                    var6_5 = var7_8;
                    continue;
                }
                if (var2_2 >= var3_3[var7_8 + 1].pc) {
                    var5_4 = var7_8;
                    continue;
                }
                var4_7 = var3_3[var7_8].line_number;
                return var4_7;
lbl20:
                // 3 sources

                ** while (var5_4 < var6_5)
            }
lbl21:
            // 1 sources

            throw new Error("pc_offset " + var2_2 + " not found in line number table");
        }
        throw new Exception("no line number table found in " + this.fullname());
    }

    LineNumberEntry[] mbLineNumberTable() throws Exception {
        int n = CType.offsetof("methodblock", "line_number_table", 44);
        int n2 = this.space.readInt(this.mb + n);
        int n3 = CType.offsetof("methodblock", "line_number_table_length", 52);
        int n4 = this.space.readInt(this.mb + n3);
        LineNumberEntry[] lineNumberEntryArray = new LineNumberEntry[n4];
        CType cType = CType.find("LineNumberEntry");
        Base.Assert(cType == null || cType.getSize() == 4);
        int n5 = 0;
        while (n5 < n4) {
            int n6 = this.space.readShort(n2 + (n5 << 2));
            int n7 = this.space.readShort(n2 + (n5 << 2) + 2);
            lineNumberEntryArray[n5] = new LineNumberEntry(n6, n7);
            ++n5;
        }
        return lineNumberEntryArray;
    }

    class LineNumberEntry {
        int pc;
        int line_number;

        LineNumberEntry(int n, int n2) {
            this.pc = n;
            this.line_number = n2;
        }
    }
}

