/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.svcdump;

import com.ibm.jvm.svcdump.Base;
import com.ibm.jvm.svcdump.Heap;
import com.ibm.jvm.svcdump.HeapClass;
import com.ibm.jvm.svcdump.HeapField;
import com.ibm.jvm.svcdump.HeapVisitor;
import java.util.BitSet;

public class HeapObject
extends Base {
    Heap heap;
    HeapClass cl;
    int address;

    HeapObject(Heap heap, int n) {
        this.heap = heap;
        this.address = n;
    }

    public int getAddress() {
        return this.address;
    }

    public Object getField(String string) {
        return this.getField(this.cl.getField(string));
    }

    public int getIntField(HeapField heapField) {
        try {
            return this.heap.space.readInt(this.address + 8 + heapField.offset);
        }
        catch (Exception exception) {
            throw new Error("Problem reading object: " + exception);
        }
    }

    public long getLongField(HeapField heapField) {
        try {
            return this.heap.space.readLong(this.address + 8 + heapField.offset);
        }
        catch (Exception exception) {
            throw new Error("Problem reading object: " + exception);
        }
    }

    public Object getField(HeapField heapField) {
        switch (heapField.type) {
            case 'B': {
                return new Byte((byte)this.getIntField(heapField));
            }
            case 'C': {
                return new Character((char)this.getIntField(heapField));
            }
            case 'L': 
            case '[': {
                return new HeapObject(this.heap, this.getIntField(heapField));
            }
            case 'F': {
                return new Float(Float.intBitsToFloat(this.getIntField(heapField)));
            }
            case 'D': {
                return new Double(Double.longBitsToDouble(this.getLongField(heapField)));
            }
            case 'I': {
                return new Integer(this.getIntField(heapField));
            }
            case 'J': {
                return new Long(this.getLongField(heapField));
            }
            case 'S': {
                return new Short((short)this.getIntField(heapField));
            }
            case 'Z': {
                return new Boolean(this.getIntField(heapField) != 0);
            }
        }
        throw new Error("Cannot yet handle type: " + heapField.type);
    }

    public HeapClass getHeapClass() {
        if (this.cl == null) {
            try {
                this.cl = this.heap.jvm.getObjectClass(this.address);
            }
            catch (Exception exception) {
                throw new Error("Uh oh: " + exception);
            }
        }
        return this.cl;
    }

    public int numberOfReachableObjects() {
        return this.heap.numberOfReachableObjects(this.address);
    }

    public int numberOfReachableObjects(BitSet bitSet) {
        return this.heap.numberOfReachableObjects(this.address, bitSet);
    }

    public Object depthFirstSearch(HeapVisitor heapVisitor) {
        return this.heap.depthFirstSearch(this.address, heapVisitor);
    }

    HeapObject[] getChildren() {
        return null;
    }

    public boolean equals(Object object) {
        if (!(object instanceof HeapObject)) {
            return false;
        }
        HeapObject heapObject = (HeapObject)object;
        return heapObject.address == this.address;
    }

    public int hashCode() {
        return this.address;
    }

    public String toString() {
        try {
            if (this.getHeapClass().isJavaLangString()) {
                return this.heap.space.readStringObject(this.address);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.toString();
    }
}

