/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.svcdump;

import com.ibm.jvm.dump.format.CType;
import com.ibm.jvm.dump.format.DvJavaFrame;
import com.ibm.jvm.svcdump.AddressSpace;
import com.ibm.jvm.svcdump.Dsa;
import com.ibm.jvm.svcdump.HeapClass;
import com.ibm.jvm.svcdump.HeapMethod;
import com.ibm.jvm.svcdump.Tcb;

public class JavaFrame
extends DvJavaFrame {
    Dsa dsa;
    AddressSpace space;
    JavaFrame previous;
    int sf;
    int address;
    Tcb tcb;
    HeapMethod mb;
    String toString;
    String description;

    public JavaFrame(Dsa dsa, int n) throws Exception {
        this.dsa = dsa;
        this.frameType = n;
        this.space = dsa.space;
        this.tcb = dsa.tcb;
        if (this.frameType == DvJavaFrame.FRAME_TYPE_JIT) {
            int n2;
            int n3 = dsa.getMdata();
            int n4 = dsa.reg(14) & Integer.MAX_VALUE;
            int n5 = this.space.readInt(n3);
            if (n5 != 0 && n5 != -1 && (n2 = this.space.readInt(n3 + 12)) != 0) {
                int n6 = this.space.readInt(n2);
                n2 += 4;
                int n7 = 0;
                while (n7 < n6) {
                    int n8 = this.space.readInt(n2);
                    if (n8 == n4) {
                        this.sf = this.space.readInt(n2 + 4);
                        break;
                    }
                    if (n8 > n4) break;
                    ++n7;
                    n2 += 8;
                }
            }
        }
    }

    public JavaFrame(Dsa dsa, int n, int n2) throws Exception {
        this.dsa = dsa;
        this.frameType = n;
        this.sf = n2;
        this.space = dsa.space;
        this.tcb = dsa.tcb;
    }

    public JavaFrame(int n, Tcb tcb) {
        this.address = n;
        this.tcb = tcb;
        this.space = tcb.space;
        this.frameType = DvJavaFrame.FRAME_TYPE_JAVA;
    }

    public boolean isPseudo() {
        return false;
    }

    public JavaFrame previous() throws Exception {
        JavaFrame.Assert(this.tcb != null);
        if (this.previous != null) {
            return this.previous;
        }
        if (this.frameType == DvJavaFrame.FRAME_TYPE_JIT) {
            Dsa dsa;
            int n = this.sf;
            if (n != 0) {
                n = this.space.readInt(n + 4);
            }
            this.previous = n != 0 ? new JavaFrame(this.dsa, this.frameType, n) : ((dsa = this.dsa.jitFramePrevious()).isJitFrame() ? new JavaFrame(dsa, DvJavaFrame.FRAME_TYPE_JIT) : new JavaFrame(dsa, DvJavaFrame.FRAME_TYPE_MMI));
        } else if (this.frameType == DvJavaFrame.FRAME_TYPE_JAVA) {
            JavaFrame.Assert(this.dsa == null);
            int n = CType.offsetof("JavaFrame", "prev", 16);
            int n2 = CType.offsetof("JavaFrame", "profiler_info", 36);
            int n3 = this.space.readInt(this.address + n2);
            int n4 = this.space.readInt(this.address + n);
            if (n4 == 0 || n3 == 0 || (n3 & 0xFFFFFFFC) == n4) {
                if (n4 != 0) {
                    this.previous = new JavaFrame(n4, this.tcb);
                }
            } else {
                int n5 = CType.offsetof("JavaFrame", "returnpc", 4);
                int n6 = this.space.readInt(this.address + n5);
                Dsa dsa = new Dsa(this.tcb, n6);
                this.previous = dsa.isJitFrame() ? new JavaFrame(dsa, DvJavaFrame.FRAME_TYPE_JIT) : new JavaFrame(dsa, DvJavaFrame.FRAME_TYPE_MMI);
            }
        } else {
            Dsa dsa = this.dsa.jitFramePrevious();
            while (true) {
                if (!dsa.isMmiFrame()) {
                    if (dsa.isJitFrame()) {
                        this.previous = new JavaFrame(dsa, DvJavaFrame.FRAME_TYPE_JIT);
                        break;
                    }
                } else {
                    int n = dsa.prevJavaFrame();
                    if (n != 0) {
                        this.previous = new JavaFrame(n, this.tcb);
                        break;
                    }
                    this.previous = new JavaFrame(dsa, DvJavaFrame.FRAME_TYPE_MMI);
                    break;
                }
                dsa = dsa.jitFramePrevious();
            }
        }
        if (this.previous == null || this.previous.mb() == null) {
            // empty if block
        }
        return this.previous;
    }

    public HeapMethod mb() throws Exception {
        if (this.mb == null) {
            if (this.frameType == DvJavaFrame.FRAME_TYPE_JIT) {
                int n;
                int n2 = this.dsa.getMdata();
                if (n2 < (n = this.dsa.entryPoint()) || n2 > n + 256) {
                    return null;
                }
                if (this.sf != 0) {
                    int n3 = this.space.readInt(this.sf);
                    this.mb = new HeapMethod(this.tcb.jvm, n3);
                } else {
                    int n4 = this.space.readInt(n2);
                    if (n4 == -1) {
                        return null;
                    }
                    this.mb = new HeapMethod(this.tcb.jvm, n4);
                }
            } else if (this.frameType == DvJavaFrame.FRAME_TYPE_MMI) {
                this.mb = this.dsa.mb();
            } else if (this.frameType == DvJavaFrame.FRAME_TYPE_JAVA) {
                int n = CType.offsetof("JavaFrame", "current_method", 28);
                int n5 = this.space.readInt(this.address + n);
                if (n5 != 0) {
                    this.mb = new HeapMethod(this.tcb.jvm, n5);
                }
            } else {
                JavaFrame.Assert(false);
            }
        }
        return this.mb;
    }

    String sourceName(HeapClass heapClass) throws Exception {
        String string = heapClass.cbSourceName();
        int n = string.lastIndexOf(47);
        if (n >= 0) {
            string = string.substring(n);
        }
        return string;
    }

    String sourceName() throws Exception {
        return this.sourceName(this.mb().classclass);
    }

    int lastpc() throws Exception {
        if (this.frameType == DvJavaFrame.FRAME_TYPE_MMI) {
            return this.dsa.last_pc();
        }
        if (this.frameType == DvJavaFrame.FRAME_TYPE_JAVA) {
            int n = CType.offsetof("JavaFrame", "lastpc", 28);
            int n2 = this.space.readInt(this.address + n);
            return n2;
        }
        throw new Error("uh oh");
    }

    public String description() {
        if (this.description != null) {
            return this.description;
        }
        try {
            if (this.mb() == null) {
                this.description = "";
            } else if (this.mb().mbIsNative()) {
                this.description = "Native Method";
            } else if (this.frameType == DvJavaFrame.FRAME_TYPE_MMI || this.frameType == DvJavaFrame.FRAME_TYPE_JAVA) {
                try {
                    int n = this.mb().mbByteCode();
                    int n2 = this.mb().pc2LineNumber(this.lastpc());
                    this.description = this.sourceName() + ":" + n2;
                }
                catch (Exception exception) {
                    this.description = this.sourceName();
                }
            } else if (this.frameType == DvJavaFrame.FRAME_TYPE_JIT) {
                this.description = this.sf != 0 && this.space.readInt(this.sf + 4) != 0 ? this.sourceName() + "(Inlined Compiled Code)" : this.sourceName() + "(Compiled Code)";
            } else {
                JavaFrame.Assert(false);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new Error("Unexpected exception: " + exception);
        }
        return this.description;
    }

    public String fullname() {
        try {
            if (this.mb() == null) {
                return "empty frame";
            }
            return this.mb().fullnameNoSig();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new Error("Unexpected exception: " + exception);
        }
    }

    public String toString() {
        if (this.toString != null) {
            return this.toString;
        }
        try {
            if (this.mb() == null) {
                return "empty frame";
            }
            this.toString = this.mb().fullnameNoSig() + "(" + this.description() + ")";
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new Error("Unexpected exception: " + exception);
        }
        return this.toString;
    }

    static String hex(int n) {
        return Integer.toHexString(n);
    }

    static void Assert(boolean bl) {
        if (!bl) {
            throw new Error("assert failed!");
        }
    }
}

