/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.svcdump;

import com.ibm.jvm.dump.format.CType;
import com.ibm.jvm.findroots.Graph;
import com.ibm.jvm.findroots.HeapdumpContentHandler;
import com.ibm.jvm.findroots.NullHandler;
import com.ibm.jvm.findroots.PrintClient;
import com.ibm.jvm.svcdump.AddressSpace;
import com.ibm.jvm.svcdump.Base;
import com.ibm.jvm.svcdump.Dsa;
import com.ibm.jvm.svcdump.Dump;
import com.ibm.jvm.svcdump.Heap;
import com.ibm.jvm.svcdump.HeapClass;
import com.ibm.jvm.svcdump.HeapField;
import com.ibm.jvm.svcdump.HeapMethod;
import com.ibm.jvm.svcdump.Tcb;
import com.ibm.jvm.util.IntHashtable;
import com.ibm.jvm.util.IntegerArray;
import com.ibm.jvm.util.SortListener;
import com.ibm.jvm.util.SvcdumpProperties;
import com.ibm.jvm.util.html.Document;
import com.ibm.jvm.util.html.Element;
import com.ibm.jvm.util.html.Table;
import java.text.DateFormat;
import java.util.Enumeration;
import java.util.Hashtable;

public final class Jvm
extends Base {
    AddressSpace space;
    boolean checkedVersion = false;
    boolean is131 = false;
    boolean printstrings;
    IntHashtable names = new IntHashtable();
    IntHashtable classes = new IntHashtable();
    Hashtable livecounts;
    Hashtable deadcounts = new Hashtable();
    public int jvmp;
    int st;
    int mh_heapbase;
    int mh_heaplimit;
    int th_heapbase;
    int th_heaplimit;
    int freeObjectCtr;
    int totalObjectCtr;
    int freeList;
    int allocbits;
    int lastaddress;
    HeapdumpContentHandler handler;
    int limit = 10;
    int totalLength = 0;
    int totalObjects = 0;
    static DateFormat df = DateFormat.getTimeInstance();
    boolean isPostRas;
    int stglobal;
    int st_jab;
    int longestTidChain;
    int rootTid;
    boolean includeDead;
    boolean isDebugBuild;
    boolean isPostMarkStack;
    int mmiLow;
    int mmiHigh;
    boolean doneInit;
    Heap heap;
    IntHashtable refArrays = new IntHashtable();
    static boolean includeReferences = SvcdumpProperties.getBooleanProperty("findroots.include.references", false);
    Graph graph;
    String[] arrayName = new String[]{"unknown array type", "unknown array type", "array of references", "unknown array type", "array of boolean", "array of char", "array of float", "array of double", "array of byte", "array of short", "array of int", "array of long", "array of unsigned byte", "array of unsigned char", "array of unsigned int", "array of unsigned long"};
    int finalClass;
    boolean foundFinalClass;

    Jvm(AddressSpace addressSpace) {
        this.space = addressSpace;
        Base.Assert(false);
    }

    Jvm(AddressSpace addressSpace, int n, boolean bl) {
        this.space = addressSpace;
        this.jvmp = n;
        this.isPostRas = bl;
    }

    public void init() throws Exception {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        if (this.doneInit) {
            return;
        }
        this.doneInit = true;
        if (this.space.jvmRasAddress != 0) {
            this.expect(this.space.jvmRasAddress, "JVMR", true);
            if (Dump.verbose) {
                System.out.println("found jvm ras eyecatcher");
            }
        }
        this.is131 = true;
        if (Dump.verbose) {
            System.out.println("asid = " + this.space + " jvmp = " + Jvm.hex(this.jvmp));
        }
        this.expect(this.jvmp, "MAIN", false);
        if (this.isPostRas) {
            this.st = this.jvmp + 340 + 8;
            if (Dump.verbose) {
                System.out.println("is post ras");
            }
        } else {
            this.st = this.jvmp + 340;
        }
        if (Dump.verbose) {
            System.out.println("st = " + Jvm.hex(this.st));
        }
        if (this.isPostRas) {
            try {
                this.expect(this.st, "STOR", false);
            }
            catch (Error error) {
                this.st += 8;
                this.expect(this.st, "STOR", false);
            }
            this.stglobal = this.space.readInt(this.st + 404 + 8);
        } else {
            this.stglobal = this.space.readInt(this.st + 404);
        }
        if (Dump.verbose) {
            System.out.println("stglobal = " + Jvm.hex(this.stglobal));
        }
        if (this.isPostRas) {
            this.expect(this.stglobal, "STDA", false);
            this.stglobal += 16;
        }
        this.st_jab = this.space.readInt(this.stglobal + 12);
        if (Dump.verbose) {
            System.out.println("st_jab = " + Jvm.hex(this.st_jab));
        }
        int n6 = this.space.readInt(this.stglobal + 20);
        if (Dump.verbose) {
            System.out.println("real_heapbase = " + Jvm.hex(n6));
        }
        int n7 = this.space.readInt(this.stglobal + 24);
        if (Dump.verbose) {
            System.out.println("real_heaptop = " + Jvm.hex(n7));
        }
        int n8 = this.space.readInt(this.stglobal + 32);
        if (Dump.verbose) {
            System.out.println("real_TH_limit = " + Jvm.hex(n8));
        }
        this.mh_heapbase = this.space.readInt(this.stglobal + 36);
        if (Dump.verbose) {
            System.out.println("mh_heapbase = " + Jvm.hex(this.mh_heapbase));
        }
        this.mh_heaplimit = this.space.readInt(this.stglobal + 40);
        if (Dump.verbose) {
            System.out.println("mh_heaplimit = " + Jvm.hex(this.mh_heaplimit));
        }
        this.th_heapbase = this.space.readInt(this.stglobal + 44);
        if (Dump.verbose) {
            System.out.println("th_heapbase = " + Jvm.hex(this.th_heapbase));
        }
        this.th_heaplimit = this.space.readInt(this.stglobal + 48);
        if (Dump.verbose) {
            System.out.println("th_heaplimit = " + Jvm.hex(this.th_heaplimit));
        }
        this.allocbits = this.space.readInt(this.stglobal + 100);
        if (Dump.verbose) {
            System.out.println("allocbits = " + Jvm.hex(this.allocbits));
        }
        if ((n5 = this.space.readInt(this.stglobal + 132)) != 512) {
            this.stglobal += 16;
            n5 = this.space.readInt(this.stglobal + 132);
            if (n5 == 512) {
                this.isPostMarkStack = true;
                if (Dump.verbose) {
                    System.out.println("found post mark stack build");
                }
            } else {
                this.stglobal += 4;
                n5 = this.space.readInt(this.stglobal + 132);
                if (n5 == 512) {
                    this.isPostMarkStack = true;
                    this.isDebugBuild = true;
                    if (Dump.verbose) {
                        System.out.println("found post mark stack debug build");
                    }
                } else {
                    this.stglobal -= 16;
                    n5 = this.space.readInt(this.stglobal + 132);
                    if (n5 == 512) {
                        this.isDebugBuild = true;
                        if (Dump.verbose) {
                            System.out.println("found debug build");
                        }
                    } else {
                        throw new Exception("Bad jvmp!");
                    }
                }
            }
        }
        int n9 = this.space.readInt(this.stglobal + 168 + (this.isPostMarkStack ? 8 : 0));
        if (Dump.verbose) {
            System.out.println("gcctr = " + n9);
        }
        if (n9 > 100000) {
            if (Dump.verbose) {
                System.out.println("found post 53299.1 build");
            }
            this.stglobal += 8;
        }
        int n10 = this.space.readInt(this.stglobal + 136);
        if (Dump.verbose) {
            System.out.println("loadedSystemClasses = " + Jvm.hex(n10));
        }
        if (n10 != 0) {
            Base.Assert(n10 > 4096);
            this.addClassChain(n10);
        }
        if (this.isPostMarkStack) {
            this.stglobal += 4;
        }
        int n11 = this.space.readInt(this.stglobal + 140);
        if (Dump.verbose) {
            System.out.println("loadedACSClasses = " + Jvm.hex(n11));
        }
        if (n11 != 0) {
            this.addClassChain(n11);
        }
        if (this.isPostMarkStack) {
            this.stglobal += 4;
        }
        int n12 = this.space.readInt(this.stglobal + 144);
        if (Dump.verbose) {
            System.out.println("loadedClasses = " + Jvm.hex(n12));
        }
        n9 = this.space.readInt(this.stglobal + 168);
        if (Dump.verbose) {
            System.out.println("gcctr = " + n9);
        }
        if (this.isPostMarkStack) {
            n4 = this.space.readInt(this.stglobal + 172);
            if (Dump.verbose) {
                System.out.println("overflowctr = " + n4);
            }
            this.stglobal += 4;
        }
        n4 = this.space.readInt(this.stglobal + 172);
        if (Dump.verbose) {
            System.out.println("last_compactgc = " + n4);
        }
        int n13 = this.space.readInt(this.stglobal + 176);
        if (Dump.verbose) {
            System.out.println("last_icompactgc = " + n13);
        }
        int n14 = this.space.readInt(this.stglobal + 180);
        if (Dump.verbose) {
            System.out.println("last_fullgc = " + n14);
        }
        int n15 = this.space.readInt(this.stglobal + 184);
        if (Dump.verbose) {
            System.out.println("onlineCPUs = " + n15);
        }
        int n16 = this.space.readInt(this.stglobal + 188);
        if (Dump.verbose) {
            System.out.println("maxedOutTLHs = " + n16);
        }
        int n17 = this.space.readInt(this.stglobal + 192);
        if (Dump.verbose) {
            System.out.println("maxTLHSize = " + Jvm.hex(n17));
        }
        int n18 = this.space.readInt(this.stglobal + 960);
        if (Dump.verbose) {
            System.out.println("num_hints = " + Jvm.hex(n18));
        }
        int n19 = this.space.readInt(this.stglobal + 964);
        if (Dump.verbose) {
            System.out.println("hint_first = " + Jvm.hex(n19));
        }
        int n20 = this.space.readInt(this.stglobal + 968);
        if (Dump.verbose) {
            System.out.println("hint_free = " + Jvm.hex(n20));
        }
        int n21 = n20;
        while (n21 != 0) {
            n3 = this.space.readInt(n21);
            n2 = this.space.readInt(n21 + 4);
            n = this.space.readInt(n21 + 8);
            if (Dump.verbose) {
                System.out.println("hint chunk: " + Jvm.hex(n2) + " len: " + Jvm.hex(n3) + " lru: " + Jvm.hex(n));
            }
            n21 = this.space.readInt(n21 + 8);
        }
        if (this.isPostRas) {
            this.stglobal += 4;
        }
        n3 = this.space.readInt(this.stglobal + 996);
        this.freeObjectCtr = this.space.readInt(this.stglobal + 1016);
        if (Dump.verbose) {
            System.out.println("freeObjectCtr = " + this.freeObjectCtr);
        }
        this.totalObjectCtr = this.space.readInt(this.stglobal + 1020);
        if (Dump.verbose) {
            System.out.println("totalObjectCtr = " + this.totalObjectCtr);
        }
        this.freeList = this.space.readInt(this.stglobal + 1036);
        if (Dump.verbose) {
            System.out.println("freeList = " + Jvm.hex(this.freeList));
        }
        n2 = this.space.readInt(this.stglobal + 1040);
        if (Dump.verbose) {
            System.out.println("freeTail = " + Jvm.hex(n2));
        }
        n = this.space.readInt(this.stglobal + 1044);
        if (Dump.verbose) {
            System.out.println("deferredList = " + Jvm.hex(n));
        }
        if (Dump.verbose) {
            System.out.println("");
        }
    }

    void checkTidChain(Document document) {
        boolean bl = false;
        if (this.rootTid != 0) {
            int n = 0;
            int n2 = 0;
            try {
                n = this.rootTid;
                while (n != 0) {
                    int n3 = this.space.readInt(n + 4);
                    if (n3 != n2) {
                        document.println("Warning! in tid " + Jvm.hex(n) + " prev pointer does not match! expected " + Jvm.hex(n2) + " found " + Jvm.hex(n3));
                        bl = true;
                    }
                    n2 = n;
                    n = this.space.readInt(n);
                }
            }
            catch (Exception exception) {
                document.println("*** uh oh " + Jvm.hex(n));
            }
        }
        if (bl) {
            document.println("");
        }
    }

    String cbName(int n) throws Exception {
        this.init();
        if (this.space.readInt(n + 28) == n) {
            if (this.checkedVersion) {
                if (this.is131 && this.space.readInt(n + 12) != n) {
                    throw new Error("Blooming heck!");
                }
            } else {
                this.is131 = false;
            }
        } else if (this.checkedVersion) {
            if (!this.is131) {
                throw new Error("Blooming heck!");
            }
        } else {
            this.is131 = true;
        }
        this.checkedVersion = true;
        int n2 = this.is131 ? this.space.readInt(n + 64) : this.space.readInt(n + 12);
        String string = (String)this.names.get(n2);
        if (string == null) {
            StringBuffer stringBuffer = new StringBuffer();
            try {
                int n3;
                while ((n3 = this.space.readUnsignedByte(n2++)) != 0) {
                    stringBuffer.append((char)n3);
                }
            }
            catch (Exception exception) {
                return "(error reading " + Jvm.hex(n2) + ")";
            }
            string = stringBuffer.toString();
            this.names.put(n2, (Object)string);
        }
        return string;
    }

    void expect(int n, String string, boolean bl) throws Exception {
        byte[] byArray = bl ? string.getBytes("8859_1") : string.getBytes("Cp500");
        int n2 = Dump.getInt(byArray, 0);
        int n3 = this.space.readInt(n);
        if (n3 != n2) {
            throw new Error("did not find expected eyecatcher! found " + Jvm.hex(n3) + " expected " + Jvm.hex(n2));
        }
    }

    HeapClass getClass(int n) throws Exception {
        HeapClass heapClass = (HeapClass)this.classes.get(n);
        if (heapClass == null) {
            heapClass = new HeapClass(this, n, this.cbName(n));
            this.classes.put(n, (Object)heapClass);
        }
        return heapClass;
    }

    void addClassChain(int n) {
        block3: {
            try {
                while (n != 0) {
                    this.getClass(n);
                    n = this.space.readInt(n + 32);
                }
            }
            catch (Exception exception) {
                if (!Dump.debug) break block3;
                System.out.println("Warning: dodgy cb in class chain: 0x" + Jvm.hex(n));
            }
        }
    }

    boolean isLive(int n) {
        Tcb[] tcbArray = this.space.tcbs();
        int n2 = 0;
        while (n2 < tcbArray.length) {
            if (tcbArray[n2].inAllocCache(n)) {
                System.out.println("yes! " + Jvm.hex(n));
                System.exit(1);
                return true;
            }
            ++n2;
        }
        return false;
    }

    boolean isLiveChunk(int n) {
        try {
            int n2 = n - this.mh_heapbase;
            int n3 = n2 >> 8;
            int n4 = n2 >> 3 & 0x1F;
            int n5 = this.space.readInt(this.allocbits + (n3 << 2));
            int n6 = Integer.MIN_VALUE >>> n4;
            boolean bl = (n5 & n6) != 0;
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    void processChunks(int n, int n2) throws Exception {
        int n3 = n;
        int n4 = 0;
        while (n3 < n2) {
            boolean bl = this.isLiveChunk(n3);
            int n5 = this.space.readInt(n3) & 0x3FFFFFF8;
            if (n5 > 0x10000000) {
                System.out.println("bad chunk at " + Jvm.hex(n3) + " chunk[0] = " + Jvm.hex(this.space.readInt(n3)));
                System.out.println("last address = " + Jvm.hex(this.lastaddress));
            }
            if (bl) {
                this.processObject(n3 + 4, n5 - 4);
            } else if (this.includeDead) {
                try {
                    this.processObject(n3 + 4, n5 - 4);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if ((this.verbose() || n4 % 131072 == 0) && this.handler != null) {
                this.handler.log("analyzing heap at " + Jvm.hex(n3) + " total objects so far = " + this.totalObjects);
            }
            if (n5 == 0 || (n3 += n5) < 0 || n3 > n2 + 16) {
                System.out.println("found bad length? " + Jvm.hex(n5));
            }
            if (n5 == 0) break;
            ++n4;
        }
    }

    public Heap getHeap() {
        if (this.heap == null) {
            this.heap = new Heap(this);
        }
        return this.heap;
    }

    void analyze131Heap() throws Exception {
        Tcb[] tcbArray;
        Enumeration enumeration = this.classes.elements();
        while (enumeration.hasMoreElements()) {
            tcbArray = (Tcb[])enumeration.nextElement();
            if (this.handler == null) continue;
            this.handler.classDump(tcbArray.getAddress(), tcbArray.getName(), tcbArray.staticReferences(), 256);
        }
        this.processChunks(this.mh_heapbase, this.mh_heaplimit);
        this.processChunks(this.th_heapbase, this.th_heaplimit);
        tcbArray = this.space.tcbs();
        int n = 0;
        while (n < tcbArray.length) {
            if (tcbArray[n].jvm == this) {
                int n2 = tcbArray[n].cacheBlock();
                int n3 = tcbArray[n].cacheSize();
                int n4 = tcbArray[n].cacheOrigSize();
                if (n2 != 0 && n3 != 0 && n4 != 0) {
                    try {
                        int n5 = n2 + n3;
                        while (n5 < n2 + n4) {
                            int n6 = this.space.readInt(n5) & 0x3FFFFFF8;
                            this.processObject(n5 + 4, n6 - 4);
                            if (n6 == 0 || (n5 += n6) < 0) {
                                System.out.println("found bad length? " + Jvm.hex(n6));
                            }
                            if (n6 != 0) {
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            ++n;
        }
    }

    int methodsToClass(int n) throws Exception {
        if (this.isPostRas) {
            return this.space.readInt(n + 8);
        }
        return this.space.readInt(n);
    }

    void searchHeap(int n) throws Exception {
        System.out.println("searchHeap: value = " + Jvm.hex(n) + " base = " + Jvm.hex(this.mh_heapbase) + " limit = " + Jvm.hex(this.mh_heaplimit));
        int n2 = this.mh_heapbase;
        while (n2 < this.mh_heaplimit) {
            int n3 = this.space.readInt(n2) & 0x3FFFFFF8;
            int n4 = n2 + 12;
            while (n4 < n2 + n3) {
                if (this.space.readInt(n4) == n) {
                    System.out.println("found it at " + Jvm.hex(n2 + 4));
                    int n5 = this.space.readInt(n2 + 4);
                    int n6 = this.space.readInt(n2 + 8);
                    if ((n6 & 2) == 2) {
                        System.out.println("found ref to " + Jvm.hex(n) + " in array at " + Jvm.hex(n2 + 4));
                    } else if (n5 != 0) {
                        int n7 = this.methodsToClass(n5);
                        String string = this.cbName(n7);
                        System.out.println("found ref to " + Jvm.hex(n) + " in object " + string + " at " + Jvm.hex(n2 + 4));
                    } else {
                        System.out.println("found ref to " + Jvm.hex(n) + " in unknown at " + Jvm.hex(n2 + 4));
                    }
                }
                n4 += 4;
            }
            n2 += n3;
        }
    }

    void analyzeHaifaHeap() throws Exception {
        IntegerArray integerArray = this.space.addresses;
        int n = 0;
        while (n < integerArray.size()) {
            int n2 = integerArray.get(n);
            if (this.space.readInt(n2) == -926820925) {
                int n3 = this.space.readInt(n2 + 24);
                if (this.verbose()) {
                    System.out.println("found HANC at " + Jvm.hex(n2) + " length = " + Jvm.hex(n3) + " in asid " + this.space.hexId());
                }
                if (n3 > 0x6000000) {
                    this.handler.log("found Haifa Java heap of size 0x" + Jvm.hex(n3));
                    int n4 = n2 + 4096;
                    while (n4 < n2 + n3) {
                        try {
                            int n5 = this.space.readInt(n4);
                            int n6 = this.space.readInt(n4 + 4);
                            n4 += this.processBlock(n4);
                        }
                        catch (Exception exception) {
                            if (this.verbose()) {
                                System.out.println("*** error reading " + Jvm.hex(n4) + " ***");
                            }
                            n4 += 4096;
                        }
                    }
                }
            }
            ++n;
        }
    }

    public void findRoots(Graph graph) throws Exception {
        this.graph = graph;
        this.analyze(new HeapdumpContentHandler(){

            public void instanceDump(int n, String string, int[] nArray, int n2) {
                if (!Jvm.this.graph.nofinal || !string.equals("java/lang/ref/Finalizer")) {
                    Jvm.this.graph.addVertex(n, nArray, n2);
                }
            }

            public void classDump(int n, String string, int[] nArray, int n2) {
                Jvm.this.graph.addVertex(n, nArray, 300);
            }

            public void objectArrayDump(int n, String string, int[] nArray, int n2) {
                Jvm.this.graph.addVertex(n, nArray, nArray.length << 2);
            }

            public void primitiveArrayDump(int n, int n2, int n3) {
                Jvm.this.graph.addVertex(n, n3);
            }

            public void error(String string) {
                Base.Assert(false);
            }

            public void addEdge(int n, int n2) {
                Base.Assert(false);
            }

            public void log(String string) {
                Graph.log(string);
            }
        });
        Graph.log("");
        Graph.log("end heap analysis");
        this.graph.print(new PrintClient(){

            public String getName(int n) {
                return Jvm.this.xgetName(n);
            }
        });
    }

    void analyze(HeapdumpContentHandler heapdumpContentHandler) throws Exception {
        this.init();
        this.handler = heapdumpContentHandler;
        if (heapdumpContentHandler != null) {
            heapdumpContentHandler.log("begin heap analysis");
        }
        if (this.is131) {
            this.analyze131Heap();
        } else {
            this.analyzeHaifaHeap();
        }
    }

    public void scanHeap(HeapdumpContentHandler heapdumpContentHandler, boolean bl) throws Exception {
        this.includeDead = bl;
        this.analyze(heapdumpContentHandler);
        heapdumpContentHandler.log("");
        heapdumpContentHandler.log("end heap analysis, cache misses = " + this.space.cacheMisses);
    }

    public void analyzeHeap() {
        Document document = new Document();
        document.setPlainText(Dump.isFromJFormat());
        try {
            this.analyzeHeap(document, new NullHandler());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void analyzeHeap(Document document, HeapdumpContentHandler heapdumpContentHandler) throws Exception {
        this.init();
        this.livecounts = new Hashtable();
        this.analyze(heapdumpContentHandler);
        document.println("");
        document.println("*** dump of live objects in the heap ***");
        document.println("");
        this.printCounts(document, this.livecounts);
        document.println("");
        document.println("end heap analysis, cache misses = " + this.space.cacheMisses);
        document.println("total objects = " + this.totalObjects + " total length = " + this.totalLength);
        if (this.is131 && this.verbose()) {
            document.println("*** dump of free list: ***");
            int n = this.freeList;
            int n2 = 0;
            while (n != 0) {
                try {
                    document.println("chunk = " + Jvm.hex(n) + " free total = " + (n2 += this.space.readInt(n)));
                    n = this.space.readInt(n + 4);
                }
                catch (Exception exception) {
                    document.println("*** problem reading chunk " + Jvm.hex(n));
                    break;
                }
            }
        }
    }

    public void dumpClass(Document document, HeapClass heapClass, boolean bl) throws Exception {
        HeapField[] heapFieldArray;
        HeapClass heapClass2 = heapClass.cbSuperclass();
        if (!bl) {
            System.out.println("class " + heapClass + " (" + Jvm.hex(heapClass.getAddress()) + ")" + " extends " + heapClass2 + " (" + Jvm.hex(heapClass2.getAddress()) + ")");
            System.out.println("methods:");
        }
        HeapMethod[] heapMethodArray = heapClass.getMethods();
        int n = 0;
        while (n < heapMethodArray.length) {
            heapFieldArray = heapMethodArray[n];
            if (bl) {
                if (heapFieldArray.mbIsNative()) {
                    System.out.println(heapClass + "." + heapFieldArray);
                }
            } else {
                System.out.println("    method " + heapFieldArray);
            }
            if (Dump.verbose) {
                System.out.println("        local variable count " + heapFieldArray.mbLocalVariableCount());
            }
            ++n;
        }
        if (!bl) {
            System.out.println("fields:");
            heapFieldArray = heapClass.getFields();
            int n2 = 0;
            while (n2 < heapFieldArray.length) {
                HeapField heapField = heapFieldArray[n2];
                System.out.println("    field " + heapField);
                ++n2;
            }
        }
    }

    public void dumpMdata(Document document, int n) throws Exception {
        int n2 = this.space.readInt(n);
        HeapMethod heapMethod = new HeapMethod(this, n2);
        System.out.println("Dump of mdata at 0x" + Jvm.hex(n));
        System.out.println("");
        System.out.println("Method: " + heapMethod.fullname());
        System.out.println("");
        int n3 = this.space.readInt(n + 12);
        if (n3 != 0) {
            int n4 = this.space.readInt(n3);
            System.out.println("Found " + n4 + " inlined methods");
            System.out.println("");
            int n5 = 0;
            while (n5 < n4) {
                int n6 = this.space.readInt(n3 + 4 + (n5 << 3));
                int n7 = this.space.readInt(n3 + 8 + (n5 << 3));
                System.out.print("0x" + Jvm.hex(n6) + ": ");
                boolean bl = true;
                while (n7 != 0) {
                    int n8 = this.space.readInt(n7);
                    HeapMethod heapMethod2 = new HeapMethod(this, n8);
                    System.out.print((bl ? "" : " <- ") + heapMethod2.fullname());
                    bl = false;
                    n7 = this.space.readInt(n7 + 4);
                }
                System.out.println("");
                ++n5;
            }
        }
    }

    void dumpClasses(Document document, HeapdumpContentHandler heapdumpContentHandler, boolean bl) throws Exception {
        System.out.println("Scanning heap, please wait...");
        this.analyze(null);
        System.out.println("");
        if (bl) {
            System.out.println("*** dump of all native methods in the heap ***");
        } else {
            System.out.println("*** dump of classes in the heap ***");
        }
        System.out.println("");
        Enumeration enumeration = this.classes.elements();
        while (enumeration.hasMoreElements()) {
            HeapClass heapClass = (HeapClass)enumeration.nextElement();
            try {
                this.dumpClass(document, heapClass, bl);
            }
            catch (Throwable throwable) {
                System.out.println("Error while dumping " + Jvm.hex(heapClass.getAddress()) + " possible corrupt heap");
            }
        }
    }

    public void dumpClasses(Document document, HeapdumpContentHandler heapdumpContentHandler) throws Exception {
        this.dumpClasses(document, heapdumpContentHandler, false);
    }

    public void dumpNative(Document document, HeapdumpContentHandler heapdumpContentHandler) throws Exception {
        this.dumpClasses(document, heapdumpContentHandler, true);
    }

    public void verifysubpools() throws Exception {
        this.init();
        int n = CType.offsetof("StorageJab", "subpool_id_table", 96);
        int n2 = CType.offsetof("SubpoolHdr", "current_extent", 12);
        System.out.println("offset = " + n);
        int n3 = 1;
        while (n3 < 8) {
            int n4 = this.space.readInt(this.st_jab + n + (n3 << 3));
            int n5 = this.space.readInt(this.st_jab + n + (n3 << 3) + 4);
            System.out.println("token = " + Jvm.hex(n4));
            System.out.println("header = " + Jvm.hex(n5));
            if (n4 != 0 && n5 != 0) {
                Base.Assert((n4 & 0xF) == n3);
                this.expect(n5, "STSM", false);
                int n6 = this.space.readInt(n5 + n2);
                while (n6 != 0) {
                    System.out.println("    extent = " + Jvm.hex(n6));
                    n6 = this.space.readInt(n6);
                }
            }
            ++n3;
        }
    }

    void appendProperties(Table table, int n) throws Exception {
        int n2;
        Base.Assert(n > 0);
        Base.Assert(this.getName(n).equals("java/util/Properties"));
        int n3 = this.space.readInt(n + 8);
        int n4 = this.space.readInt(n + 12);
        int n5 = 0;
        while (n5 < n4) {
            n2 = this.space.readInt(n3 + 8 + (n5 << 2));
            while (n2 != 0) {
                int n6 = this.space.readInt(n2 + 12);
                int n7 = this.space.readInt(n2 + 16);
                String string = this.space.readStringObject(n6);
                String string2 = this.space.readStringObject(n7);
                table.addRow(string, string2);
                n2 = this.space.readInt(n2 + 20);
            }
            ++n5;
        }
        n2 = this.space.readInt(n + 40);
        if (n2 != 0) {
            this.appendProperties(table, n2);
        }
    }

    public void dumpProperties(Document document, HeapdumpContentHandler heapdumpContentHandler) throws Exception {
        System.out.println("Scanning heap, please wait...");
        this.analyze(null);
        document.println("");
        document.println("*** dump of system properties ***");
        document.println("");
        Table table = new Table("key", "value");
        Enumeration enumeration = this.classes.elements();
        while (enumeration.hasMoreElements()) {
            HeapClass heapClass = (HeapClass)enumeration.nextElement();
            if (!"java/lang/System".equals(heapClass.toString())) continue;
            int n = heapClass.getStaticField("props");
            this.appendProperties(table, n);
            break;
        }
        document.addElement(table);
    }

    void printCounts(Document document, Hashtable hashtable) {
        Object object;
        final String[] stringArray = new String[hashtable.size()];
        IntegerArray integerArray = new IntegerArray();
        int n = 0;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            int n2 = (Integer)hashtable.get(object);
            stringArray[n++] = object;
            integerArray.add(n2);
        }
        integerArray.reverseSort(new SortListener(){

            public void swap(int n, int n2) {
                String string = stringArray[n];
                stringArray[n] = stringArray[n2];
                stringArray[n2] = string;
            }
        });
        object = new Table(new String[]{"count", "class"});
        n = 0;
        while (n < hashtable.size()) {
            ((Table)object).addRow(new String[]{"" + integerArray.get(n), stringArray[n]});
            ++n;
        }
        document.addElement((Element)object);
    }

    final int arrayLength(int n, int n2) {
        int n3 = n >> 3;
        int n4 = 1 << (n3 & 3);
        n4 *= n2;
        return n4 += 8;
    }

    int processBlock(int n) throws Exception {
        int n2;
        int n3;
        int n4 = this.space.readInt(n);
        int n5 = this.space.readInt(n + 4);
        if ((n5 & 2) == 2 && n5 <= 122) {
            n3 = this.arrayLength(n5, n4);
            if (n3 >= 2048) {
                this.processObject(n, n3);
                return n3 + 4095 & 0xFFFFF000;
            }
        } else {
            if (n5 != 0) {
                if (this.verbose()) {
                    System.out.println("unknown block flags at " + Jvm.hex(n));
                }
                return 4096;
            }
            n3 = 8;
        }
        int n6 = n3 + 3 & 0xFFFFFFFC;
        boolean bl = true;
        while (n6 < 2048) {
            bl = true;
            n2 = n + n6;
            while (n2 < n + 4096) {
                block17: {
                    n4 = this.space.readInt(n2);
                    n5 = this.space.readInt(n2 + 4);
                    if ((n5 & 2) == 2 && n5 <= 122) {
                        n3 = this.arrayLength(n5, n4);
                        if (n3 > n6) {
                            bl = false;
                            break;
                        }
                    } else {
                        if (n5 != 0 || n4 != 0 && n4 < 0x10000000 || (n4 & 3) != 0) {
                            bl = false;
                            break;
                        }
                        try {
                            if (n4 == 0) break block17;
                            int n7 = this.space.readInt(n4);
                            int n8 = this.space.readInt(n7 + 12);
                        }
                        catch (Exception exception) {
                            bl = false;
                            break;
                        }
                    }
                }
                n2 += n6;
            }
            if (bl) break;
            n6 += 4;
        }
        if (bl) {
            n2 = n;
            while (n2 < n + 4096) {
                this.processObject(n2, n6);
                n2 += n6;
            }
        } else if (this.verbose()) {
            System.out.println("couldn't figure out " + Jvm.hex(n));
        }
        return 4096;
    }

    boolean stIsValidHandle(int n) {
        return n >= this.mh_heapbase && n < this.mh_heaplimit || n >= this.th_heapbase && n < this.th_heaplimit;
    }

    void addCount(int n) {
        String string = this.getName(n);
        Integer n2 = (Integer)this.livecounts.get(string);
        if (n2 == null) {
            this.livecounts.put(string, new Integer(1));
        } else {
            this.livecounts.put(string, new Integer(n2 + 1));
        }
    }

    boolean is_normal_object(int n) {
        return (n & 2) == 0;
    }

    HeapClass getObjectClass(int n) throws Exception {
        HeapClass heapClass;
        int n2 = this.space.readInt(n);
        int n3 = this.space.readInt(n + 4);
        if (this.is_normal_object(n3)) {
            int n4 = this.methodsToClass(n2);
            heapClass = this.getClass(n4);
        } else if (n3 > 0 && n3 <= 122) {
            if (n3 == 18) {
                int n5 = this.space.readInt(n + 8 + (n2 << 2));
                heapClass = this.getClass(n5);
                heapClass = heapClass.getArrayClass();
            } else {
                heapClass = HeapClass.getPrimitiveArrayClass(n3 >> 3 & 0xF);
            }
        } else {
            throw new Exception("Unknown flags: " + Jvm.hex(n3));
        }
        return heapClass;
    }

    int[] getRefArray(int n) {
        int[] nArray = (int[])this.refArrays.get(n);
        if (nArray == null) {
            nArray = new int[n];
            this.refArrays.put(n, (Object)nArray);
        }
        return nArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void processObject(int n, int n2) throws Exception {
        this.totalLength += n2;
        ++this.totalObjects;
        this.lastaddress = n;
        int n3 = this.space.readInt(n);
        int n4 = this.space.readInt(n + 4);
        if (this.livecounts != null) {
            this.addCount(n);
        }
        if (this.is_normal_object(n4)) {
            try {
                int[] nArray;
                int n5 = 0;
                try {
                    n5 = this.methodsToClass(n3);
                }
                catch (Exception exception) {
                    throw new Exception("Problem reading object at " + Jvm.hex(n) + " with methods " + Jvm.hex(n3) + ": " + exception);
                }
                HeapClass heapClass = this.getClass(n5);
                if (heapClass.isJavaLangClass()) {
                    HeapClass heapClass2 = this.getClass(n);
                    if (this.handler == null) return;
                    this.handler.classDump(n, this.cbName(n), heapClass2.staticReferences(), n2);
                    return;
                }
                if (this.handler == null) return;
                if (!includeReferences && heapClass.isInstanceOfReference()) {
                    if (!Dump.verbose) return;
                    System.out.println("exclude reference " + Jvm.hex(n) + " " + heapClass);
                    return;
                }
                int n6 = heapClass.cbObjectOffsets();
                if (n6 != 0) {
                    int n7;
                    int n8;
                    int n9 = 0;
                    while ((n8 = this.space.readShort(n6)) != 0) {
                        Base.Assert(n8 > 0);
                        Base.Assert(n8 < n2);
                        Base.Assert((n8 & 1) != 0);
                        n7 = this.space.readInt(n + 7 + n8);
                        if (n7 != 0 && this.stIsValidHandle(n7)) {
                            ++n9;
                        }
                        n6 += 2;
                    }
                    nArray = this.getRefArray(n9);
                    n6 = heapClass.cbObjectOffsets();
                    n8 = 0;
                    while ((n7 = this.space.readShort(n6)) != 0) {
                        int n10 = this.space.readInt(n + 7 + n7);
                        if (n10 != 0 && this.stIsValidHandle(n10)) {
                            nArray[n8++] = n10;
                        }
                        n6 += 2;
                    }
                } else {
                    nArray = this.getRefArray(0);
                }
                this.handler.instanceDump(n, this.cbName(n5), nArray, n2);
                return;
            }
            catch (Exception exception) {
                if (this.includeDead) throw new Error("yuk");
                exception.printStackTrace();
                throw new Error("yuk");
            }
        }
        if (n4 <= 0 || n4 > 122 || this.handler == null) return;
        if (n4 == 18) {
            int n11;
            IntegerArray integerArray = null;
            int n12 = 0;
            while (n12 < n3) {
                n11 = this.space.readInt(n + 8 + (n12 << 2));
                if (n11 != 0 && this.stIsValidHandle(n11)) {
                    if (integerArray == null) {
                        integerArray = new IntegerArray();
                    }
                    integerArray.add(n11);
                }
                ++n12;
            }
            n11 = this.space.readInt(n + 8 + (n3 << 2));
            int[] nArray = integerArray == null ? new int[]{} : integerArray.toArray();
            this.handler.objectArrayDump(n, this.cbName(n11), nArray, n2);
            return;
        } else {
            this.handler.primitiveArrayDump(n, n4 >> 3 & 0xF, n2);
        }
    }

    public String xgetName(int n) {
        return this.getName(n);
    }

    public String getName(int n) {
        try {
            int n2 = this.space.readInt(n + 4);
            if ((n2 & 2) == 2) {
                int n3 = n2 >> 3 & 0xF;
                if (n3 == 5 && this.printstrings) {
                    int n4 = this.space.readInt(n);
                    int n5 = this.arrayLength(n2, n4);
                    if (n5 > 40) {
                        n5 = 40;
                    }
                    char[] cArray = new char[n5];
                    int n6 = 0;
                    while (n6 < n5) {
                        cArray[n6] = (char)this.space.readShort(n + 8 + (n6 << 1));
                        ++n6;
                    }
                    String string = "array of char: " + new String(cArray);
                    return string.intern();
                }
                return this.arrayName[n3];
            }
            int n7 = this.space.readInt(n);
            int n8 = this.methodsToClass(n7);
            return this.cbName(n8);
        }
        catch (Exception exception) {
            return "error";
        }
    }

    static String hex(int n) {
        return Integer.toHexString(n);
    }

    public int asid() {
        return this.space.id;
    }

    boolean isMmiFrame(Dsa dsa) {
        if (this.mmiLow == 0) {
            Dsa dsa2 = dsa.tcb.topDsa;
            while (dsa2 != null) {
                if (dsa2.simpleFunction().equals("EXECJAVA")) {
                    this.mmiLow = dsa2.entryPoint();
                    this.mmiHigh = this.mmiLow + 60000;
                    break;
                }
                dsa2 = dsa2.previous();
            }
        }
        return dsa.entryPoint() >= this.mmiLow && dsa.entryPoint() < this.mmiHigh;
    }

    public String toString() {
        return "0x" + Jvm.hex(this.jvmp);
    }
}

