/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.svcdump;

import com.ibm.jvm.dump.format.CType;
import com.ibm.jvm.dump.format.DvAddress;
import com.ibm.jvm.dump.format.DvJavaFrame;
import com.ibm.jvm.dump.format.DvJavaStack;
import com.ibm.jvm.dump.format.DvNativeFrame;
import com.ibm.jvm.dump.format.DvNativeStack;
import com.ibm.jvm.dump.format.DvProcess;
import com.ibm.jvm.dump.format.DvRegister;
import com.ibm.jvm.dump.format.DvThread;
import com.ibm.jvm.svcdump.Address;
import com.ibm.jvm.svcdump.AddressSpace;
import com.ibm.jvm.svcdump.Caa;
import com.ibm.jvm.svcdump.Dsa;
import com.ibm.jvm.svcdump.Dump;
import com.ibm.jvm.svcdump.Function;
import com.ibm.jvm.svcdump.JavaFrame;
import com.ibm.jvm.svcdump.JavaStack;
import com.ibm.jvm.svcdump.Jvm;
import com.ibm.jvm.svcdump.NativeFrame;
import com.ibm.jvm.svcdump.NativeStack;
import com.ibm.jvm.util.html.Document;
import com.ibm.jvm.util.html.Row;
import com.ibm.jvm.util.html.Table;
import java.util.Hashtable;
import java.util.Vector;

public class Tcb
extends DvThread {
    AddressSpace space;
    int topDsaAddress;
    Dsa topDsa;
    Dsa[] stack;
    int tcbid;
    int tid;
    int ee;
    int state;
    Caa caa;
    String type;
    boolean isKnownType;
    boolean scannedTid;
    Hashtable traceTable;
    Function[] traceFunctions;
    static final int STCB = 312;
    static final int OTCB = 216;
    static final int THLI = 188;
    static final int TID = 52;
    boolean is131;
    boolean verbose;
    boolean isPostRas;
    int[] failingRegisters;
    Jvm jvm;
    boolean dodgy;
    int cacheBlock;
    int cacheSize;
    int cacheOrigSize;
    NativeStack nativeStack;
    JavaStack javaStack;

    public DvProcess getProcess() {
        return this.space.getProcesses()[0];
    }

    public String id() {
        return this.hexId();
    }

    public boolean isJava() {
        return this.tid != 0;
    }

    public DvAddress eeAddress() {
        return new Address(this.ee);
    }

    public DvNativeFrame[] getNativeFrames() {
        Vector vector = new Vector();
        Dsa dsa = this.topDsa;
        while (dsa != null) {
            vector.add(new NativeFrame(dsa));
            dsa = dsa.previous();
        }
        return (DvNativeFrame[])vector.toArray(new DvNativeFrame[0]);
    }

    public DvJavaFrame[] getJavaFrames() {
        throw new Error("unimplemented method");
    }

    public DvAddress getPSW() {
        throw new Error("unimplemented method");
    }

    public DvRegister[] getRegisters() {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DvJavaStack getJavaStack() {
        if (this.javaStack == null) {
            int n;
            Vector vector = new Vector();
            try {
                JavaFrame javaFrame;
                n = CType.offsetof("execenv", "jit_ee", 408);
                int n2 = CType.offsetof("jit_execenv", "last_frame", 4);
                int n3 = this.space.readInt(this.ee + n + n2);
                if (n3 != 0) {
                    Dsa dsa = new Dsa(this, n3);
                    javaFrame = dsa.isMmiFrame() ? new JavaFrame(dsa, DvJavaFrame.FRAME_TYPE_MMI) : new JavaFrame(dsa, DvJavaFrame.FRAME_TYPE_JIT);
                } else {
                    int n4 = CType.offsetof("execenv", "current_frame", 8);
                    int n5 = this.space.readInt(this.ee + n4);
                    javaFrame = new JavaFrame(n5, this);
                }
                if (javaFrame.mb() == null && javaFrame.previous() == null) {
                    return null;
                }
                while (javaFrame != null) {
                    vector.add(javaFrame);
                    javaFrame = javaFrame.previous();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            n = vector.size() - 1;
            while (n >= 0) {
                JavaFrame javaFrame = (JavaFrame)vector.elementAt(n);
                try {
                    if (javaFrame.mb() != null) break;
                    vector.remove(n);
                }
                catch (Exception exception) {
                    break;
                }
                --n;
            }
            DvJavaFrame[] dvJavaFrameArray = (DvJavaFrame[])vector.toArray(new DvJavaFrame[0]);
            this.javaStack = new JavaStack(dvJavaFrameArray);
        }
        return this.javaStack;
    }

    public DvNativeStack getNativeStack() {
        if (this.nativeStack == null) {
            this.nativeStack = new NativeStack(this.getNativeFrames());
        }
        return this.nativeStack;
    }

    public int cacheBlock() {
        if (this.cacheBlock != 0) {
            return this.cacheBlock;
        }
        if (this.ee == 0) {
            return 0;
        }
        try {
            int n = this.space.readInt(this.ee + 40);
            this.space.readInt(n);
            this.cacheBlock = n;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.cacheBlock;
    }

    public int cacheSize() {
        if (this.cacheSize != 0 || this.cacheBlock() == 0) {
            return this.cacheSize;
        }
        if (this.ee == 0) {
            return 0;
        }
        try {
            this.cacheSize = this.space.readInt(this.ee + 36);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.cacheSize;
    }

    public int cacheOrigSize() {
        if (this.cacheOrigSize != 0 || this.cacheBlock() == 0) {
            return this.cacheOrigSize;
        }
        if (this.ee == 0) {
            return 0;
        }
        try {
            this.cacheOrigSize = this.space.readInt(this.ee + 44);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.cacheOrigSize;
    }

    public boolean inAllocCache(int n) {
        try {
            if (n >= this.cacheBlock() + this.cacheSize() && n <= this.cacheBlock() + this.cacheOrigSize()) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean hasPendingException() {
        if (this.ee != 0 && this.is131) {
            try {
                int n = this.space.readInt(this.ee + 16);
                if (n != 0) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public void printException() {
        Document document = new Document();
        document.setPlainText(Dump.isFromJFormat());
        this.printException(document);
    }

    public void printException(Document document) {
        if (this.ee != 0 && this.is131) {
            try {
                int n = this.space.readInt(this.ee + 20);
                int n2 = this.space.readInt(this.ee + 16);
                if (n != 0) {
                    document.println("");
                    String string = this.jvm.getName(n);
                    String string2 = this.space.readStringObject(this.space.readInt(n + 12));
                    String string3 = n2 == 0 ? "old" : "pending";
                    document.println("found " + string3 + " exception: " + string + ": " + string2);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void printJavaStack(Document document) {
        DvJavaStack dvJavaStack = this.getJavaStack();
        if (dvJavaStack != null) {
            document.println("");
            document.println("Java stack:");
            document.println("");
            Table table = new Table("Method", "Location");
            int n = 0;
            while ((long)n < dvJavaStack.getNumFrames()) {
                JavaFrame javaFrame = (JavaFrame)dvJavaStack.getFrame(n);
                table.addRow(javaFrame.fullname(), javaFrame.description());
                ++n;
            }
            document.addElement(table);
        }
    }

    public void printAllocCache() {
        Document document = new Document();
        document.setPlainText(Dump.isFromJFormat());
        this.printAllocCache(document);
    }

    public void printAllocCache(Document document) {
        if (this.ee != 0 && this.is131) {
            try {
                int n;
                document.println("");
                document.println("alloc cache info:");
                int n2 = this.space.readInt(this.ee + 32);
                int n3 = this.space.readInt(this.ee + 68);
                document.println("cache_busy = 0x" + Tcb.hex(n2));
                document.println("cache_block = 0x" + Tcb.hex(this.cacheBlock()));
                document.println("cache_size = 0x" + Tcb.hex(this.cacheSize()) + " -> 0x" + Tcb.hex(this.cacheBlock() + this.cacheSize()));
                document.println("cache_orig_size = 0x" + Tcb.hex(this.cacheOrigSize()) + " -> 0x" + Tcb.hex(this.cacheBlock() + this.cacheOrigSize()));
                document.println("target_size = 0x" + Tcb.hex(n3));
                int n4 = 0;
                if (this.cacheBlock() != 0 && this.cacheSize() != 0) {
                    n = this.cacheOrigSize() - this.cacheSize();
                    int n5 = this.cacheBlock() + this.cacheSize();
                    int n6 = n5 + n;
                    int n7 = this.space.readInt(this.cacheBlock() - 12);
                    int n8 = this.space.readInt(this.cacheBlock() - 8);
                    int n9 = this.space.readInt(this.cacheBlock() - 4);
                    document.println("cache link size = 0x" + Tcb.hex(n7));
                    document.println("cache obj size = 0x" + Tcb.hex(n8));
                    document.println("cache flags = 0x" + Tcb.hex(n9));
                    document.println("");
                    Table table = new Table(new String[]{"address", "length", "methods", "flags", "class name"});
                    while (n5 < n6) {
                        Row row = new Row();
                        int n10 = this.space.readInt(n5) & 0x3FFFFFF8;
                        row.addCell(Tcb.hex(n5));
                        row.addCell(Tcb.hex(n10));
                        int n11 = this.space.readInt(n5 + 4);
                        int n12 = this.space.readInt(n5 + 8);
                        row.addCell(Tcb.hex(n11));
                        row.addCell(Tcb.hex(n12));
                        if (n11 != 0) {
                            String string = this.jvm.getName(n5 + 4);
                            row.addCell(string);
                        } else {
                            row.addCell("");
                        }
                        table.addRow(row);
                        if (n10 <= 0 || n10 > this.cacheOrigSize()) {
                            n4 = n5;
                            break;
                        }
                        n5 += n10;
                    }
                    document.addElement(table);
                }
                if (n4 != 0) {
                    document.println("*** dodgy alloc cache? dump follows ***");
                    n = this.cacheBlock();
                    while (n < n4 + 256) {
                        document.println("0x" + Tcb.hex(n) + ": " + Tcb.hex(this.space.readInt(n)));
                        n += 4;
                    }
                }
            }
            catch (Exception exception) {
                document.println("problem reading ee " + Tcb.hex(this.ee) + " exception: " + exception);
            }
        }
    }

    void checkEE() throws Exception {
        if (this.verbose) {
            System.out.println("asid = " + this.space.hexId() + " ee = " + Tcb.hex(this.ee));
        }
        int n = this.space.readInt(this.ee);
        if (this.verbose) {
            System.out.println("jnienv = " + Tcb.hex(n));
        }
        int n2 = this.space.readInt(n + 4);
        if (this.verbose) {
            System.out.println("reserved1 = " + Tcb.hex(n2));
        }
        if (n2 != 0) {
            throw new Exception("reserved1 is not zero! " + n2);
        }
        int n3 = this.space.readInt(this.ee + 12);
        if (this.verbose) {
            System.out.println("thread = " + Tcb.hex(n3));
        }
        if (n3 == 0) {
            throw new Exception("thread pointer in ee is zero");
        }
        int n4 = this.space.readInt(n3);
        if (this.verbose) {
            System.out.println("methodtable = " + Tcb.hex(n4));
        }
        int n5 = this.space.readInt(n4);
        if (this.verbose) {
            System.out.println("eyecatcher = " + Tcb.hex(n5));
        }
        if (n5 == 1129074004) {
            this.isPostRas = true;
        }
    }

    void findEE() throws Exception {
        this.ee = this.space.readInt(this.tid + 40);
        if (this.ee < 65536) {
            this.ee = this.tid - 512;
            this.is131 = true;
            if (this.space.readInt(this.ee - 24) == 1481459013) {
                this.ee -= 16;
                this.isPostRas = true;
            } else if (this.space.readInt(this.ee - 40) == 1481459013) {
                this.ee -= 32;
                this.isPostRas = true;
            }
            int n = this.space.readInt(this.ee + 452);
            try {
                if (this.verbose) {
                    System.out.println("adding jvm " + Tcb.hex(n));
                }
                this.jvm = this.space.addJvm(n, this.isPostRas);
            }
            catch (Throwable throwable) {
                if (Dump.debug) {
                    System.out.println("could not create jvm at " + Tcb.hex(n) + " because " + throwable);
                    throwable.printStackTrace(System.out);
                }
            }
        } else {
            throw new Exception("bad ee " + Tcb.hex(this.ee));
        }
    }

    void findDsaFromLastFrame() {
        block5: {
            if (this.verbose) {
                System.out.println("findDsaFromLastFrame begin");
            }
            try {
                int n = 0;
                n = this.is131 ? this.space.readInt(this.ee + 412) : this.space.readInt(this.ee + 64);
                if (n != 0) {
                    this.topDsa = Dsa.findTop(this, n);
                    this.isKnownType = true;
                }
            }
            catch (Exception exception) {
                if (!this.verbose) break block5;
                exception.printStackTrace(System.out);
            }
        }
        if (this.verbose) {
            System.out.println("findDsaFromLastFrame end");
        }
    }

    Tcb(AddressSpace addressSpace, int n) {
        int n2;
        int n3;
        int n4;
        block17: {
            this.is131 = false;
            this.verbose = false;
            this.isPostRas = false;
            this.dodgy = false;
            this.cacheBlock = 0;
            this.cacheSize = 0;
            this.cacheOrigSize = 0;
            this.verbose = Dump.debug;
            if (this.verbose) {
                System.out.println("creating tcb " + Tcb.hex(n));
            }
            this.space = addressSpace;
            this.tcbid = n;
            try {
                n4 = addressSpace.readInt(n + 324);
                n3 = addressSpace.readInt(n4 + 0);
                n2 = addressSpace.readInt(n3 + 8);
                int n5 = addressSpace.readInt(n2 + 0);
                if (!this.isValidCaa(n5) && !this.isValidCaa(n5 = addressSpace.readInt(n3 + 32)) && this.verbose) {
                    System.out.println("could not find caa for this tcb");
                }
            }
            catch (Exception exception) {
                if (!this.verbose) break block17;
                System.out.println("could not find caa for this tcb");
            }
        }
        try {
            n4 = addressSpace.readInt(n + 312);
            n3 = addressSpace.readInt(n4 + 216);
            n2 = addressSpace.readInt(n3 + 188);
            this.tid = addressSpace.readInt(n2 + 52);
            if (this.tid != 0) {
                addressSpace.mapTid(this.tid, this);
                this.findEE();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.isLE() || this.isRtwa() || this.isLinkage() || this.isLinkage2() || this.isIrb() || this.isCics() || this.isUsta()) {
            block18: {
                this.isKnownType = true;
                if (this.verbose) {
                    System.out.println("is known type: " + this.type);
                }
                try {
                    this.topDsa = new Dsa(this, this.topDsaAddress);
                }
                catch (Exception exception) {
                    if (!this.verbose) break block18;
                    System.out.println("could not create Dsa: " + exception);
                }
            }
            if (this.topDsa == null || this.topDsa.prevCount() < 3) {
                this.type = "dodgy";
                this.dodgy = true;
                try {
                    this.topDsaAddress = this.findBestDsa();
                    this.topDsa = new Dsa(this, this.topDsaAddress);
                }
                catch (Exception exception) {
                    if (this.verbose) {
                        System.out.println("could not create dodgy Dsa: " + exception);
                    }
                }
            }
        } else {
            this.type = "unknown";
            this.findDsaFromLastFrame();
            this.findCaa();
        }
        if (this.verbose) {
            System.out.println("finished creating tcb " + Tcb.hex(n));
        }
    }

    Tcb(AddressSpace addressSpace, int n, int n2) {
        this.is131 = false;
        this.verbose = false;
        this.isPostRas = false;
        this.dodgy = false;
        this.cacheBlock = 0;
        this.cacheSize = 0;
        this.cacheOrigSize = 0;
        this.space = addressSpace;
        this.tid = n2;
        try {
            this.findEE();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.type = "Java thread with no TCB";
        this.findDsaFromLastFrame();
        this.findCaa();
    }

    void findCaa() {
    }

    public void addTraceEntry(int n, int n2) {
        Integer n3;
        Integer n4;
        if (this.traceTable == null) {
            this.traceTable = new Hashtable();
        }
        this.traceTable.put(n4, new Integer((n3 = (Integer)this.traceTable.get(n4 = new Integer(n2))) == null ? 1 : n3 + 1));
    }

    public Function[] traceFunctions() {
        if (this.traceFunctions == null && this.traceTable != null) {
            this.traceFunctions = this.space.traceFunctions(this.traceTable);
        }
        return this.traceFunctions;
    }

    public Dsa topDsa() {
        return this.topDsa;
    }

    public Dsa[] stack() {
        if (this.stack == null) {
            Vector vector = new Vector();
            Dsa dsa = this.topDsa();
            while (dsa != null) {
                vector.add(dsa);
                dsa = dsa.previous();
            }
            this.stack = (Dsa[])vector.toArray(new Dsa[0]);
        }
        return this.stack;
    }

    public String where() {
        try {
            return this.topDsa.function();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public boolean isValidCaa(int n) {
        this.caa = Caa.create(this.space, n);
        return this.caa != null;
    }

    public int caa() {
        return this.caa == null ? 0 : this.caa.caa;
    }

    public boolean isLE() {
        try {
            int n = this.space.readInt(this.tcbid + 96);
            if (this.isValidCaa(n)) {
                this.topDsaAddress = this.space.readInt(this.tcbid + 100);
                this.type = "LE";
                return true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
        return false;
    }

    int findBestDsa() throws Exception {
        int n;
        block26: {
            int n2;
            int n3;
            int n4;
            if (this.verbose) {
                System.out.println("findBestDsa begin");
            }
            int n5 = this.caa.dummyDsa();
            int n6 = this.space.readInt(n5 + 76);
            Dsa dsa = Dsa.findTop(this, n6);
            n = dsa.stackPointer();
            int n7 = dsa.prevCount();
            int n8 = this.space.readInt(this.tcbid + 100);
            try {
                dsa = new Dsa(this, n8);
                if (dsa.prevCount() > n7) {
                    n = dsa.stackPointer();
                    n7 = dsa.prevCount();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                int n9 = this.space.readInt(this.tcbid + 312);
                n4 = this.space.readInt(n9 + 216);
                n3 = this.space.readInt(n4 + 56);
                n2 = this.space.readInt(n3 + 4);
                n8 = this.space.readInt(n2 + 76);
                dsa = new Dsa(this, n8);
                if (dsa.prevCount() > n7) {
                    n = dsa.stackPointer();
                    n7 = dsa.prevCount();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                int n10 = this.space.readInt(this.tcbid + 224);
                n8 = this.space.readInt(n10 + 112);
                dsa = new Dsa(this, n8);
                if (dsa.prevCount() > n7) {
                    n = dsa.stackPointer();
                    n7 = dsa.prevCount();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                int n11 = this.space.readInt(this.tcbid + 312);
                n4 = this.space.readInt(n11 + 116);
                n3 = this.space.readInt(n11 + 128);
                if (n4 != n3 && (dsa = new Dsa(this, n8 = this.space.readInt(n3 + 8 + 52))).prevCount() > n7) {
                    n = dsa.stackPointer();
                    n7 = dsa.prevCount();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                int n12 = this.space.readInt(this.tcbid);
                n8 = this.space.readInt(n12 + 84);
                dsa = new Dsa(this, n8);
                if (dsa.prevCount() > n7) {
                    n = dsa.stackPointer();
                    n7 = dsa.prevCount();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                int n13 = this.space.readInt(this.tcbid + 72);
                if (this.space.readInt(n13 + 112) == this.tcbid && (dsa = new Dsa(this, n8 = this.space.readInt(n13 + 132))).prevCount() > n7) {
                    n = dsa.stackPointer();
                    n7 = dsa.prevCount();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                int n14 = this.space.readInt(this.tcbid + 312);
                n4 = this.space.readInt(n14 + 116);
                n3 = this.space.readInt(n14 + 128);
                if (n4 == n3) break block26;
                try {
                    n2 = this.space.readInt(n3 + 8 + 20);
                    n8 = this.space.readInt(n2 + 84);
                    dsa = new Dsa(this, n8);
                    if (dsa.prevCount() > n7) {
                        n = dsa.stackPointer();
                        n7 = dsa.prevCount();
                    }
                }
                catch (Exception exception) {
                    int n15 = this.space.readInt(n3 + 8 + 44);
                    n8 = this.space.readInt(n15 + 84);
                    dsa = new Dsa(this, n8);
                    if (dsa.prevCount() > n7) {
                        n = dsa.stackPointer();
                        n7 = dsa.prevCount();
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.verbose) {
            System.out.println("findBestDsa end: " + Tcb.hex(n));
        }
        return n;
    }

    public boolean isUsta() {
        block3: {
            try {
                int n = this.space.readInt(this.tcbid + 312);
                int n2 = this.space.readInt(n + 216);
                int n3 = this.space.readInt(n2 + 56);
                int n4 = this.space.readInt(n3 + 4);
                int n5 = this.space.readInt(n4 + 72);
                if (this.isValidCaa(n5)) {
                    this.topDsaAddress = this.findBestDsa();
                    this.type = "Usta";
                    return true;
                }
            }
            catch (Exception exception) {
                if (!this.verbose) break block3;
                exception.printStackTrace(System.out);
            }
        }
        return false;
    }

    public boolean isLinkage() {
        block3: {
            try {
                int n;
                int n2 = this.space.readInt(this.tcbid + 312);
                int n3 = this.space.readInt(n2 + 116);
                int n4 = this.space.readInt(n2 + 128);
                if (n3 != n4 && this.isValidCaa(n = this.space.readInt(n4 + 8 + 48))) {
                    this.topDsaAddress = this.space.readInt(n4 + 8 + 52);
                    this.type = "Linkage";
                    return true;
                }
            }
            catch (Exception exception) {
                if (!this.verbose) break block3;
                exception.printStackTrace(System.out);
            }
        }
        return false;
    }

    public boolean isLinkage2() {
        block3: {
            try {
                int n;
                int n2;
                int n3 = this.space.readInt(this.tcbid + 312);
                int n4 = this.space.readInt(n3 + 116);
                int n5 = this.space.readInt(n3 + 128);
                if (n4 != n5 && this.space.readInt(n2 = this.space.readInt(n5 + 8 + 8)) == -454892607 && this.isValidCaa(n = this.space.readInt(n2 + 72))) {
                    this.topDsaAddress = this.space.readInt(n2 + 76);
                    this.type = "Linkage 2";
                    return true;
                }
            }
            catch (Exception exception) {
                if (!this.verbose) break block3;
                exception.printStackTrace(System.out);
            }
        }
        return false;
    }

    public boolean isRtwa() {
        block4: {
            try {
                int n;
                int n2 = this.space.readInt(this.tcbid + 224);
                if (n2 != 0 && this.isValidCaa(n = this.space.readInt(n2 + 108))) {
                    this.topDsaAddress = this.space.readInt(n2 + 112);
                    this.type = "Failing";
                    this.failingRegisters = new int[18];
                    int n3 = 0;
                    while (n3 < this.failingRegisters.length) {
                        this.failingRegisters[n3] = this.space.readInt(n2 + 60 + (n3 << 2));
                        ++n3;
                    }
                    return true;
                }
            }
            catch (Exception exception) {
                if (!this.verbose) break block4;
                exception.printStackTrace(System.out);
            }
        }
        return false;
    }

    public boolean isIrb() {
        block3: {
            try {
                int n = this.space.readInt(this.tcbid);
                int n2 = this.space.readInt(n + 80);
                if (this.isValidCaa(n2)) {
                    this.topDsaAddress = this.space.readInt(n + 84);
                    this.type = "IRB";
                    return true;
                }
            }
            catch (Exception exception) {
                if (!this.verbose) break block3;
                exception.printStackTrace(System.out);
            }
        }
        return false;
    }

    public boolean isCics() {
        block3: {
            try {
                int n = this.space.readInt(this.tcbid + 72);
                if (this.space.readInt(n + 112) == this.tcbid) {
                    this.topDsaAddress = this.space.readInt(n + 132);
                    int n2 = this.space.readInt(this.topDsaAddress + 4);
                    n2 = this.space.readInt(n2 + 4);
                    this.type = "Cics";
                    return true;
                }
            }
            catch (Exception exception) {
                if (!this.verbose) break block3;
                exception.printStackTrace(System.out);
            }
        }
        return false;
    }

    public boolean isKnownType() {
        return this.isKnownType;
    }

    public String type() {
        return this.type;
    }

    public int tid() {
        return this.tid;
    }

    public int ee() {
        return this.ee;
    }

    public int threadIndex() {
        if (this.isJava() && this.is131) {
            try {
                return this.space.readInt(this.ee + 340);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0;
    }

    public int failingDsa() {
        int[] nArray = this.failingRegisters();
        if (nArray != null) {
            return nArray[13];
        }
        return 0;
    }

    public int failingPsw() {
        int[] nArray = this.failingRegisters();
        if (nArray != null) {
            return nArray[17] & Integer.MAX_VALUE;
        }
        return 0;
    }

    public int[] failingRegisters() {
        if (this.failingRegisters != null) {
            return this.failingRegisters;
        }
        try {
            int n = this.caa.cib();
            int n2 = this.space.readInt(n + 36);
            int n3 = this.space.readInt(n2);
            if (n3 != -371932216) {
                return null;
            }
            this.failingRegisters = new int[18];
            int n4 = 0;
            while (n4 < this.failingRegisters.length) {
                this.failingRegisters[n4] = this.space.readInt(n2 + 8 + (n4 << 2));
                ++n4;
            }
            return this.failingRegisters;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public int tid_type() {
        try {
            return this.space.readInt(this.tid + 36);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public int tid_state() {
        try {
            return this.space.readInt(this.tid + 40);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public int tid_singled() {
        try {
            return this.space.readInt(this.tid + 60);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public String hexId() {
        return Integer.toHexString(this.tcbid);
    }

    public String toString() {
        return this.hexId();
    }

    static String hex(int n) {
        return Integer.toHexString(n);
    }
}

