/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.util;

import com.ibm.jvm.util.SortListener;
import java.io.Serializable;
import java.util.Random;

public final class IntegerArray
implements Serializable,
SortListener {
    static final int shift = 12;
    static final int CHUNK_SIZE = 4096;
    static final int mask = 4095;
    int[][] chunks = new int[1][4096];
    int chunkOffset;
    SortListener listener;
    Random random = new Random();

    public IntegerArray() {
    }

    public IntegerArray(int n, int n2) {
        int n3 = 0;
        while (n3 < n) {
            this.add(n2);
            ++n3;
        }
    }

    public Object clone() {
        throw new Error("clone no longer implemented!");
    }

    public int[] toArray() {
        int[] nArray = new int[this.size()];
        int n = 0;
        while (n < this.chunks.length) {
            System.arraycopy(this.chunks[n], 0, nArray, n << 12, n == this.chunks.length - 1 ? this.chunkOffset : 4096);
            ++n;
        }
        return nArray;
    }

    public void add(int n) {
        if (this.chunkOffset >= 4096) {
            int[][] nArrayArray = new int[this.chunks.length + 1][];
            int n2 = 0;
            while (n2 < this.chunks.length) {
                nArrayArray[n2] = this.chunks[n2];
                ++n2;
            }
            nArrayArray[this.chunks.length] = new int[4096];
            this.chunks = nArrayArray;
            this.chunkOffset = 0;
        }
        this.chunks[this.chunks.length - 1][this.chunkOffset++] = n;
    }

    public int size() {
        return (this.chunks.length - 1 << 12) + this.chunkOffset;
    }

    public int get(int n) {
        return this.chunks[n >> 12][n & 0xFFF];
    }

    public void put(int n, int n2) {
        this.chunks[n >> 12][n & 0xFFF] = n2;
    }

    public void putAll(int n) {
        int n2 = 0;
        while (n2 < this.size()) {
            this.put(n2, n);
            ++n2;
        }
    }

    public int indexOf(int n) {
        return this.indexOf(n, -1);
    }

    /*
     * Enabled aggressive block sorting
     */
    public int indexOf(int n, int n2) {
        int n3;
        int n4 = 0;
        int n5 = this.size() - 1;
        if (n2 >= 0 && n2 <= n5) {
            n3 = this.get(n2);
            if (n3 < n) {
                n4 = n2 + 1;
            } else {
                if (n3 <= n) {
                    return n2;
                }
                n5 = n2 - 1;
            }
        }
        while (n4 <= n5) {
            n3 = n4 + n5 >> 1;
            int n6 = this.get(n3);
            if (n6 < n) {
                n4 = n3 + 1;
                continue;
            }
            if (n6 <= n) {
                return n3;
            }
            n5 = n3 - 1;
        }
        return -1;
    }

    public void sort() {
        this.sort(null);
    }

    public void reverseSort() {
        this.reverseSort(null);
    }

    public void sort(SortListener sortListener) {
        this.listener = sortListener;
        this.quickSort(0, this.size() - 1);
        this.listener = null;
    }

    public void reverseSort(SortListener sortListener) {
        this.listener = sortListener;
        this.quickSort(0, this.size() - 1);
        int n = 0;
        int n2 = this.size() - 1;
        while (n < n2) {
            this.swap(n, n2);
            ++n;
            --n2;
        }
        this.listener = null;
    }

    public void swap(int n, int n2) {
        int n3 = this.get(n);
        this.put(n, this.get(n2));
        this.put(n2, n3);
        if (this.listener != null) {
            this.listener.swap(n, n2);
        }
    }

    void quickSort(int n, int n2) {
        if (n2 - n < 7) {
            int n3 = n;
            while (n3 <= n2) {
                int n4 = n3;
                while (n4 > n && this.get(n4 - 1) > this.get(n4)) {
                    this.swap(n4, n4 - 1);
                    --n4;
                }
                ++n3;
            }
            return;
        }
        if (n < n2) {
            int n5 = this.randomPartition(n, n2);
            this.quickSort(n, n5);
            this.quickSort(n5 + 1, n2);
        }
    }

    int randomPartition(int n, int n2) {
        int n3 = this.random.nextInt(n2 - n + 1) + n;
        this.swap(n, n3);
        return this.partition(n, n2);
    }

    int partition(int n, int n2) {
        int n3 = this.get(n);
        int n4 = n - 1;
        int n5 = n2 + 1;
        while (true) {
            if (this.get(--n5) > n3) {
                continue;
            }
            while (this.get(++n4) < n3) {
            }
            if (n4 >= n5) break;
            this.swap(n4, n5);
        }
        return n5;
    }
}

