/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.util;

import com.ibm.jvm.util.IntEnumeration;
import com.ibm.jvm.util.IntPairEnumeration;
import com.ibm.jvm.util.Memory;
import com.ibm.jvm.util.SubsetClass;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Random;

public final class TreeBitSet
implements Serializable {
    static SubsetClass rootSubset;
    static Memory memory;
    static BitSet liveRoots;
    static BitSet shared;
    static final int MAX_BITS = 29;
    static final int MAX_BIT = 0x1FFFFFFF;
    static final int MAX_NBITS = 29;
    static final int MAX_NBIT = 0x1FFFFFFF;
    static final int MAX_SMALL_SET_SIZE = 16;
    static final int MAX_MEDIUM_SET_SIZE = 1024;
    static final int EMPTY_SET = 0;
    static final int ONE_MEMBER_SET = 1;
    static final int TWO_MEMBER_SET = 2;
    static final int THREE_MEMBER_SET = 3;
    static final int SMALL_SET = 4;
    static final int MEDIUM_SET = 5;
    static final int LARGE_SET = 6;
    static final int FULL_SET = 7;
    static final int PARTIAL_TREE = -3;
    static final int EMPTY_TREE = -2;
    static final int FULL_TREE = -1;
    static final int COPY_ON_WRITE = Integer.MIN_VALUE;
    static int[] freeLists;
    static int freeMemory;
    public static boolean verbose;
    int _root = 0;
    static int[] tmpintervals;
    static int[] tmplengths;
    static int[] bytePopulations;

    public static int freeMemory() {
        return freeMemory * 4;
    }

    public static int usage() {
        return memory.size() * 4;
    }

    public static void reset() {
        memory = new Memory();
        liveRoots = new BitSet();
        int n = 0;
        while (n < freeLists.length) {
            TreeBitSet.freeLists[n] = -1;
            ++n;
        }
        freeMemory = 0;
    }

    public static int getType(int n) {
        return n >>> 29;
    }

    static int setType(int n, int n2) {
        return n & 0x1FFFFFFF | n2 << 29;
    }

    static synchronized int alloc(int n) {
        try {
            TreeBitSet.checkFreeList(n);
            int n2 = freeLists[n - 1];
            if (n2 != -1) {
                TreeBitSet.freeLists[n - 1] = memory.get(n2);
                int n3 = 0;
                while (n3 < n) {
                    memory.put(n2 + n3, 0);
                    ++n3;
                }
                freeMemory -= n;
                return n2;
            }
            int n4 = memory.size();
            int n5 = 0;
            while (n5 < n) {
                memory.add(0);
                ++n5;
            }
            return n4;
        }
        catch (Exception exception) {
            System.out.println("size = " + n);
            System.out.println("freeList = " + freeLists[n - 1]);
            System.out.println("freeLists.length = " + freeLists.length);
            throw new Error("uh oh " + exception);
        }
    }

    static synchronized int rootalloc(int n) {
        int n2 = TreeBitSet.alloc(n);
        liveRoots.set(n2);
        return n2;
    }

    static synchronized int copyalloc(int n, int n2, int n3) {
        int n4 = TreeBitSet.alloc(n3);
        int n5 = 0;
        while (n5 < n2) {
            memory.put(n4 + n5, memory.get(n + n5));
            ++n5;
        }
        if (liveRoots.get(n)) {
            liveRoots.set(n4);
        }
        return n4;
    }

    public static synchronized void freeroot(int n, int n2) {
        TreeBitSet.Assert(liveRoots.get(n));
        liveRoots.clear(n);
        TreeBitSet.free(n, n2);
    }

    static void checkFreeList(int n) {
        if (n > freeLists.length) {
            int[] nArray = new int[n];
            System.arraycopy(freeLists, 0, nArray, 0, freeLists.length);
            int n2 = freeLists.length;
            while (n2 < nArray.length) {
                nArray[n2] = -1;
                ++n2;
            }
            freeLists = nArray;
        }
    }

    static synchronized void free(int n, int n2) {
        TreeBitSet.checkFreeList(n2);
        n &= Integer.MAX_VALUE;
        int n3 = 0;
        while (n3 < n2) {
            memory.put(n + n3, Integer.MAX_VALUE);
            ++n3;
        }
        memory.put(n, freeLists[n2 - 1]);
        TreeBitSet.freeLists[n2 - 1] = n;
        freeMemory += n2;
    }

    public void setAll(int n) {
        this._root = TreeBitSet.setAll(this._root, n);
    }

    public void set(int n) {
        this._root = TreeBitSet.set(this._root, n);
    }

    public static int setAll(int n, int n2) {
        TreeBitSet.Assert(n == 0);
        return TreeBitSet.setType(n2, 7);
    }

    public static int set(int n, int n2) {
        int n3 = -1;
        int n4 = -1;
        TreeBitSet.Assert(n2 <= 0x1FFFFFFF);
        if (TreeBitSet.get(n, n2)) {
            return n;
        }
        switch (TreeBitSet.getType(n)) {
            case 0: {
                TreeBitSet.Assert(n == 0);
                n = TreeBitSet.setType(n2, 1);
                break;
            }
            case 1: {
                n4 = TreeBitSet.rootalloc(2);
                memory.put(n4, n & 0x1FFFFFFF);
                memory.put(n4 + 1, n2);
                n = TreeBitSet.setType(n4, 2);
                break;
            }
            case 2: {
                n3 = n & 0x1FFFFFFF;
                TreeBitSet.Assert(liveRoots.get(n3));
                n4 = TreeBitSet.copyalloc(n3, 2, 3);
                memory.put(n4, memory.get(n3));
                memory.put(n4 + 1, memory.get(n3 + 1));
                memory.put(n4 + 2, n2);
                TreeBitSet.freeroot(n3, 2);
                n = TreeBitSet.setType(n4, 3);
                break;
            }
            case 3: {
                n3 = n & 0x1FFFFFFF;
                TreeBitSet.Assert(liveRoots.get(n3));
                n4 = TreeBitSet.rootalloc(5);
                memory.put(n4, 262148);
                memory.put(n4 + 1, memory.get(n3));
                memory.put(n4 + 2, memory.get(n3 + 1));
                memory.put(n4 + 3, memory.get(n3 + 2));
                memory.put(n4 + 4, n2);
                TreeBitSet.freeroot(n3, 3);
                n = TreeBitSet.setType(n4, 4);
                break;
            }
            case 4: {
                n3 = n & 0x1FFFFFFF;
                TreeBitSet.Assert(liveRoots.get(n3));
                int n5 = memory.get(n3) & 0xFFFF;
                int n6 = memory.get(n3) >>> 16;
                if (n5 < n6) {
                    memory.put(n3 + n5 + 1, n2);
                    memory.put(n3, n6 << 16 | ++n5);
                    break;
                }
                if ((n6 <<= 1) <= 16) {
                    n4 = TreeBitSet.copyalloc(n3, n5 + 1, n6 + 1);
                    TreeBitSet.freeroot(n3, n5 + 1);
                    memory.put(n4 + n5 + 1, n2);
                    memory.put(n4, n6 << 16 | ++n5);
                    n = TreeBitSet.setType(n4, 4);
                    break;
                }
                n4 = TreeBitSet.rootalloc(10);
                memory.put(n4, 0);
                memory.put(n4 + 1, 4);
                n = TreeBitSet.setType(n4, 5);
                int n7 = 0;
                while (n7 < n5) {
                    n = TreeBitSet.intervalSet(n, memory.get(n3 + n7 + 1));
                    ++n7;
                }
                n = TreeBitSet.intervalSet(n, n2);
                TreeBitSet.freeroot(n3, n5 + 1);
                break;
            }
            case 5: {
                n = TreeBitSet.intervalSet(n, n2);
                break;
            }
            case 6: {
                TreeBitSet.treeSet(rootSubset, n & 0x1FFFFFFF, n2);
                break;
            }
            default: {
                TreeBitSet.Assert(false);
            }
        }
        TreeBitSet.check(n);
        return n;
    }

    static int intervalMerge(int n, int n2) {
        int n3;
        int n4;
        int n5 = n & 0x1FFFFFFF;
        int n6 = memory.get(n5 + 1);
        int n7 = n5 + 2;
        int n8 = n7 + n6;
        int n9 = TreeBitSet.mediumSetSize(n);
        memory.put(n8 + n2, memory.get(n8 + n2) + memory.get(n8 + n2 + 1));
        if (n2 < n9 - 2) {
            n4 = n9 - (n2 + 2);
            n3 = 0;
            while (n3 < n4) {
                memory.put(n7 + n2 + 1 + n3, memory.get(n7 + n2 + 2 + n3));
                memory.put(n8 + n2 + 1 + n3, memory.get(n8 + n2 + 2 + n3));
                ++n3;
            }
        }
        TreeBitSet.Assert(--n9 > 0);
        memory.put(n5, n9);
        if (n9 * 3 < n6) {
            n4 = n6;
            n3 = TreeBitSet.rootalloc(((n6 >>= 1) << 1) + 2);
            int n10 = n3 + 2;
            int n11 = n10 + n6;
            int n12 = 0;
            while (n12 < n9) {
                memory.put(n10 + n12, memory.get(n7 + n12));
                memory.put(n11 + n12, memory.get(n8 + n12));
                ++n12;
            }
            memory.put(n3, n9);
            memory.put(n3 + 1, n6);
            n = TreeBitSet.setType(n3, 5);
            TreeBitSet.freeroot(n5, (n4 << 1) + 2);
        }
        TreeBitSet.check(n);
        return n;
    }

    /*
     * Unable to fully structure code
     */
    static int intervalSet(int var0, int var1_1) {
        TreeBitSet.Assert(TreeBitSet.getType(var0) == 5);
        var2_2 = 0;
        var3_3 = TreeBitSet.mediumSetSize(var0);
        var4_4 = var3_3 - 1;
        var5_5 = -1;
        var6_6 = -1;
        var7_7 = var0 & 0x1FFFFFFF;
        var8_8 = var7_7 + 2;
        var9_9 = TreeBitSet.memory.get(var7_7 + 1);
        var10_10 = var8_8 + var9_9;
        if (var3_3 != 0) ** GOTO lbl39
        TreeBitSet.Assert(var9_9 > 0);
        TreeBitSet.memory.put(var7_7, 1);
        TreeBitSet.memory.put(var7_7 + 2, var1_1);
        TreeBitSet.memory.put(var7_7 + 2 + var9_9, 1);
        TreeBitSet.check(var0);
        return var0;
lbl-1000:
        // 1 sources

        {
            var5_5 = var2_2 + var4_4 >> 1;
            var6_6 = TreeBitSet.memory.get(var8_8 + var5_5);
            if (var1_1 >= var6_6) {
                if (var1_1 < var6_6 + TreeBitSet.memory.get(var10_10 + var5_5)) {
                    return var0;
                }
                if (var1_1 == var6_6 + TreeBitSet.memory.get(var10_10 + var5_5)) {
                    TreeBitSet.memory.put(var10_10 + var5_5, TreeBitSet.memory.get(var10_10 + var5_5) + 1);
                    if (var5_5 < var3_3 - 1 && var1_1 + 1 == TreeBitSet.memory.get(var8_8 + var5_5 + 1)) {
                        var0 = TreeBitSet.intervalMerge(var0, var5_5);
                    }
                    TreeBitSet.check(var0);
                    return var0;
                }
                var2_2 = var5_5 + 1;
                continue;
            }
            if (var1_1 == var6_6 - 1) {
                TreeBitSet.memory.put(var8_8 + var5_5, TreeBitSet.memory.get(var8_8 + var5_5) - 1);
                TreeBitSet.memory.put(var10_10 + var5_5, TreeBitSet.memory.get(var10_10 + var5_5) + 1);
                if (var5_5 > 0 && var1_1 == TreeBitSet.memory.get(var8_8 + var5_5 - 1) + TreeBitSet.memory.get(var10_10 + var5_5 - 1)) {
                    var0 = TreeBitSet.intervalMerge(var0, var5_5 - 1);
                }
                TreeBitSet.check(var0);
                return var0;
            }
            var4_4 = var5_5 - 1;
lbl39:
            // 3 sources

            ** while (var2_2 <= var4_4)
        }
lbl40:
        // 1 sources

        if (var3_3 == var9_9) {
            if ((var9_9 <<= 1) <= 1024) {
                var11_11 = TreeBitSet.rootalloc((var9_9 << 1) + 2);
                var12_12 = var11_11 + 2;
                var13_13 = var12_12 + var9_9;
                var14_14 = 0;
                while (var14_14 < var3_3) {
                    TreeBitSet.memory.put(var12_12 + var14_14, TreeBitSet.memory.get(var8_8 + var14_14));
                    TreeBitSet.memory.put(var13_13 + var14_14, TreeBitSet.memory.get(var10_10 + var14_14));
                    ++var14_14;
                }
                TreeBitSet.memory.put(var11_11, var3_3);
                TreeBitSet.memory.put(var11_11 + 1, var9_9);
                var0 = TreeBitSet.setType(var11_11, 5);
                TreeBitSet.freeroot(var7_7, var9_9 + 2);
                var7_7 = var11_11;
                var8_8 = var12_12;
                var10_10 = var13_13;
            } else {
                var0 = TreeBitSet.promoteToLarge(var0);
                TreeBitSet.treeSet(TreeBitSet.rootSubset, var0 & 0x1FFFFFFF, var1_1);
                TreeBitSet.freeroot(var7_7, var9_9 + 2);
                TreeBitSet.check(var0);
                return var0;
            }
        }
        if (var1_1 < TreeBitSet.memory.get(var8_8)) {
            var11_11 = var3_3 - 1;
            while (var11_11 >= 0) {
                TreeBitSet.memory.put(var8_8 + var11_11 + 1, TreeBitSet.memory.get(var8_8 + var11_11));
                TreeBitSet.memory.put(var10_10 + var11_11 + 1, TreeBitSet.memory.get(var10_10 + var11_11));
                --var11_11;
            }
            TreeBitSet.memory.put(var8_8, var1_1);
            TreeBitSet.memory.put(var10_10, 1);
        } else if (var1_1 > TreeBitSet.memory.get(var8_8 + var3_3 - 1)) {
            TreeBitSet.memory.put(var8_8 + var3_3, var1_1);
            TreeBitSet.memory.put(var10_10 + var3_3, 1);
        } else {
            if (var1_1 < var6_6) {
                --var5_5;
            }
            TreeBitSet.Assert(var3_3 - var5_5 - 2 >= 0);
            var11_11 = var3_3 - var5_5 - 2;
            while (var11_11 >= 0) {
                TreeBitSet.memory.put(var8_8 + var5_5 + 2 + var11_11, TreeBitSet.memory.get(var8_8 + var5_5 + 1 + var11_11));
                TreeBitSet.memory.put(var10_10 + var5_5 + 2 + var11_11, TreeBitSet.memory.get(var10_10 + var5_5 + 1 + var11_11));
                --var11_11;
            }
            TreeBitSet.memory.put(var8_8 + var5_5 + 1, var1_1);
            TreeBitSet.memory.put(var10_10 + var5_5 + 1, 1);
        }
        TreeBitSet.memory.put(var7_7, ++var3_3);
        TreeBitSet.Assert((var0 & 0x1FFFFFFF) == var7_7);
        TreeBitSet.check(var0);
        return var0;
    }

    static int intervalCopy(int n) {
        TreeBitSet.Assert(TreeBitSet.getType(n) == 5);
        int n2 = n & 0x1FFFFFFF;
        int n3 = memory.get(n2);
        int n4 = memory.get(n2 + 1);
        int n5 = TreeBitSet.rootalloc((n4 << 1) + 2);
        int n6 = n2 + 2;
        int n7 = n6 + n4;
        int n8 = n5 + 2;
        int n9 = n8 + n4;
        int n10 = 0;
        while (n10 < n3) {
            memory.put(n8 + n10, memory.get(n6 + n10));
            memory.put(n9 + n10, memory.get(n7 + n10));
            ++n10;
        }
        memory.put(n5, n3);
        memory.put(n5 + 1, n4);
        return TreeBitSet.setType(n5, 5);
    }

    static int intervalOr(int n, int n2) {
        int n3;
        TreeBitSet.Assert(TreeBitSet.getType(n) == 5 && TreeBitSet.getType(n2) == 5);
        TreeBitSet.check(n);
        TreeBitSet.check(n2);
        int n4 = n & 0x1FFFFFFF;
        int n5 = n2 & 0x1FFFFFFF;
        int n6 = memory.get(n4);
        int n7 = memory.get(n5);
        TreeBitSet.Assert(n6 != Integer.MAX_VALUE);
        TreeBitSet.Assert(n7 != Integer.MAX_VALUE);
        int n8 = n4 + 2;
        int n9 = n5 + 2;
        int n10 = memory.get(n4 + 1);
        int n11 = n8 + n10;
        int n12 = n9 + memory.get(n5 + 1);
        if (tmpintervals == null || tmpintervals.length < n6 + n7) {
            tmpintervals = new int[n6 + n7];
            tmplengths = new int[n6 + n7];
        }
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        if (memory.get(n8) <= memory.get(n9)) {
            TreeBitSet.tmpintervals[0] = memory.get(n8);
            TreeBitSet.tmplengths[0] = memory.get(n11);
            ++n14;
        } else {
            TreeBitSet.tmpintervals[0] = memory.get(n9);
            TreeBitSet.tmplengths[0] = memory.get(n12);
            ++n15;
        }
        while (n14 < n6 || n15 < n7) {
            int n16;
            int n17;
            n3 = Integer.MAX_VALUE;
            int n18 = Integer.MAX_VALUE;
            if (n14 < n6) {
                n18 = memory.get(n8 + n14);
            }
            if (n15 < n7) {
                n3 = memory.get(n9 + n15);
            }
            if (n14 == n6 || n15 != n7 && n3 <= n18) {
                if (n3 > tmpintervals[n13] + tmplengths[n13]) {
                    TreeBitSet.tmpintervals[++n13] = n3;
                    TreeBitSet.tmplengths[n13] = memory.get(n12 + n15);
                } else {
                    n17 = tmpintervals[n13] + tmplengths[n13];
                    n16 = n3 + memory.get(n12 + n15);
                    TreeBitSet.tmplengths[n13] = n17 > n16 ? n17 - tmpintervals[n13] : n16 - tmpintervals[n13];
                }
                ++n15;
                continue;
            }
            if (n18 > tmpintervals[n13] + tmplengths[n13]) {
                TreeBitSet.tmpintervals[++n13] = n18;
                TreeBitSet.tmplengths[n13] = memory.get(n11 + n14);
            } else {
                n17 = tmpintervals[n13] + tmplengths[n13];
                n16 = n18 + memory.get(n11 + n14);
                TreeBitSet.tmplengths[n13] = n17 > n16 ? n17 - tmpintervals[n13] : n16 - tmpintervals[n13];
            }
            ++n14;
        }
        if (++n13 > n10) {
            TreeBitSet.free(n);
            n10 = n13 * 3 / 2;
            n = TreeBitSet.rootalloc((n10 << 1) + 2);
            n8 = n + 2;
            n11 = n8 + n10;
            memory.put(n + 1, n10);
        }
        n3 = 0;
        while (n3 < n13) {
            memory.put(n8 + n3, tmpintervals[n3]);
            memory.put(n11 + n3, tmplengths[n3]);
            ++n3;
        }
        memory.put(n & 0x1FFFFFFF, n13);
        n = TreeBitSet.setType(n, 5);
        TreeBitSet.check(n);
        return n;
    }

    static int promoteToLarge(int n) {
        int n2 = TreeBitSet.rootalloc(TreeBitSet.rootSubset.subsets);
        int n3 = 0;
        while (n3 < TreeBitSet.rootSubset.subsets) {
            memory.put(n2 + n3, -2);
            ++n3;
        }
        BitEnum bitEnum = new BitEnum(n);
        while (bitEnum.hasMoreElements()) {
            int n4 = bitEnum.nextInt();
            TreeBitSet.treeSet(rootSubset, n2, n4);
        }
        return TreeBitSet.setType(n2, 6);
    }

    static void treeSet(SubsetClass subsetClass, int n, int n2) {
        TreeBitSet.Assert((n & Integer.MIN_VALUE) == 0);
        if (subsetClass.next == null) {
            int n3 = n2 >> 5;
            TreeBitSet.Assert(n3 < subsetClass.subsets);
            int n4 = memory.get(n + n3) | 1 << (n2 & 0x1F);
            memory.put(n + n3, n4);
            return;
        }
        int n5 = subsetClass.subsetIndex(n2);
        int n6 = memory.get(n + n5);
        if (n6 == -1) {
            return;
        }
        if (n6 == -2) {
            n6 = TreeBitSet.treeAlloc(subsetClass.next);
            memory.put(n + n5, n6);
        } else if ((n6 & Integer.MIN_VALUE) != 0) {
            n6 = TreeBitSet.treeShallowCopy(subsetClass.next, n6);
            memory.put(n + n5, n6);
        }
        TreeBitSet.treeSet(subsetClass.next, n6, subsetClass.subsetBits(n2));
        if (TreeBitSet.treeFull(subsetClass.next, n6)) {
            TreeBitSet.treeFree(subsetClass.next, n6);
            memory.put(n + n5, -1);
        }
    }

    static void treeFree(SubsetClass subsetClass, int n) {
        if ((n & Integer.MIN_VALUE) == 0) {
            if (subsetClass.next != null) {
                int n2 = 0;
                while (n2 < subsetClass.subsets) {
                    int n3 = memory.get(n + n2);
                    if (n3 != -1 && n3 != -2) {
                        TreeBitSet.treeFree(subsetClass.next, n3);
                    }
                    ++n2;
                }
            }
            TreeBitSet.free(n, subsetClass.subsets);
        }
    }

    static int treeClone(SubsetClass subsetClass, int n) {
        n &= Integer.MAX_VALUE;
        int n2 = TreeBitSet.alloc(subsetClass.subsets);
        int n3 = 0;
        while (n3 < subsetClass.subsets) {
            int n4;
            if (subsetClass.next != null) {
                n4 = memory.get(n + n3);
                if (n4 != -1 && n4 != -2) {
                    memory.put(n2 + n3, TreeBitSet.treeClone(subsetClass.next, n4));
                } else {
                    memory.put(n2 + n3, n4);
                }
            } else {
                n4 = memory.get(n + n3);
                memory.put(n2 + n3, n4);
            }
            ++n3;
        }
        return n2;
    }

    static int treeMemoryUsage(SubsetClass subsetClass, int n) {
        if ((n & Integer.MIN_VALUE) != 0) {
            if (shared.get(n &= Integer.MAX_VALUE)) {
                return 0;
            }
            shared.set(n);
        }
        int n2 = subsetClass.subsets;
        if (subsetClass.next != null) {
            int n3 = 0;
            while (n3 < subsetClass.subsets) {
                int n4 = memory.get(n + n3);
                if (n4 != -1 && n4 != -2) {
                    n2 += TreeBitSet.treeMemoryUsage(subsetClass.next, n4);
                }
                ++n3;
            }
        }
        return n2;
    }

    static boolean treeFull(SubsetClass subsetClass, int n) {
        TreeBitSet.Assert((n & Integer.MIN_VALUE) == 0);
        int n2 = 0;
        while (n2 < subsetClass.subsets) {
            if (memory.get(n + n2) != -1) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    static boolean treeGet(SubsetClass subsetClass, int n, int n2) {
        n &= Integer.MAX_VALUE;
        if (subsetClass.next == null) {
            int n3 = n2 >> 5;
            TreeBitSet.Assert(n3 < subsetClass.subsets);
            return (memory.get(n + n3) & 1 << (n2 & 0x1F)) != 0;
        }
        int n4 = subsetClass.subsetIndex(n2);
        int n5 = memory.get(n + n4);
        if (n5 == -1) {
            return true;
        }
        if (n5 == -2) {
            return false;
        }
        return TreeBitSet.treeGet(subsetClass.next, n5, subsetClass.subsetBits(n2));
    }

    static int treeAlloc(SubsetClass subsetClass) {
        int n = TreeBitSet.alloc(subsetClass.subsets);
        if (subsetClass.next != null) {
            int n2 = 0;
            while (n2 < subsetClass.subsets) {
                memory.put(n + n2, -2);
                ++n2;
            }
        }
        return n;
    }

    public boolean get(int n) {
        return TreeBitSet.get(this._root, n);
    }

    public static boolean get(int n, int n2) {
        int n3 = n & 0x1FFFFFFF;
        TreeBitSet.Assert(n2 <= 0x1FFFFFFF);
        switch (TreeBitSet.getType(n)) {
            case 0: {
                TreeBitSet.Assert(n == 0);
                return false;
            }
            case 1: {
                return n3 == n2;
            }
            case 2: {
                return memory.get(n3) == n2 || memory.get(n3 + 1) == n2;
            }
            case 3: {
                return memory.get(n3) == n2 || memory.get(n3 + 1) == n2 || memory.get(n3 + 2) == n2;
            }
            case 4: {
                int n4 = TreeBitSet.smallSetSize(n);
                int n5 = 0;
                while (n5 < n4) {
                    if (memory.get(n3 + n5 + 1) == n2) {
                        return true;
                    }
                    ++n5;
                }
                return false;
            }
            case 5: {
                return TreeBitSet.intervalGet(n, n2);
            }
            case 6: {
                return TreeBitSet.treeGet(rootSubset, n & 0x1FFFFFFF, n2);
            }
            case 7: {
                return n2 <= (n & 0x1FFFFFFF);
            }
        }
        TreeBitSet.Assert(false);
        return false;
    }

    private static int max(int n, int n2) {
        return n > n2 ? n : n2;
    }

    public static int length(int n) {
        int n2 = n & 0x1FFFFFFF;
        switch (TreeBitSet.getType(n)) {
            case 0: {
                TreeBitSet.Assert(n == 0);
                return 0;
            }
            case 1: {
                return n2 + 1;
            }
            case 2: {
                int n3 = memory.get(n2);
                int n4 = memory.get(n2 + 1);
                return TreeBitSet.max(n3, n4) + 1;
            }
            case 3: {
                int n5 = memory.get(n2);
                int n6 = memory.get(n2 + 1);
                int n7 = memory.get(n2 + 2);
                int n8 = TreeBitSet.max(n5, n6);
                int n9 = TreeBitSet.max(n5, n7);
                return TreeBitSet.max(n8, n9) + 1;
            }
            case 4: {
                int n10 = TreeBitSet.smallSetSize(n);
                int n11 = 0;
                int n12 = 0;
                while (n12 < n10) {
                    n11 = TreeBitSet.max(memory.get(n2 + n12 + 1), n11);
                    ++n12;
                }
                return n11 + 1;
            }
            case 5: {
                int n13 = n2 + 2;
                int n14 = memory.get(n2 + 1);
                int n15 = n13 + n14;
                int n16 = memory.get(n2);
                int n17 = memory.get(n13 + n16 - 1);
                int n18 = memory.get(n15 + n16 - 1);
                return n17 + n18;
            }
            case 6: {
                return TreeBitSet.treeLastBit(rootSubset, n2) + 1;
            }
            case 7: {
                return n2 + 1;
            }
        }
        TreeBitSet.Assert(false);
        return -1;
    }

    public int length() {
        return TreeBitSet.length(this._root);
    }

    static boolean intervalGet(int n, int n2) {
        TreeBitSet.Assert(TreeBitSet.getType(n) == 5);
        int n3 = 0;
        int n4 = TreeBitSet.mediumSetSize(n);
        int n5 = n4 - 1;
        int n6 = n & 0x1FFFFFFF;
        int n7 = n6 + 2;
        int n8 = memory.get(n6 + 1);
        int n9 = n7 + n8;
        while (n3 <= n5) {
            int n10 = n3 + n5 >> 1;
            int n11 = memory.get(n7 + n10);
            if (n2 >= n11) {
                if (n2 < n11 + memory.get(n9 + n10)) {
                    return true;
                }
                n3 = n10 + 1;
                continue;
            }
            n5 = n10 - 1;
        }
        return false;
    }

    static final int treeLastBit(SubsetClass subsetClass, int n) {
        n &= Integer.MAX_VALUE;
        if (subsetClass.next == null) {
            int n2 = subsetClass.subsets - 1;
            while (n2 >= 0) {
                int n3 = memory.get(n + n2);
                int n4 = 31;
                while (n4 >= 0) {
                    if ((1 << n4 & n3) != 0) {
                        return (n2 << 5) + n4;
                    }
                    --n4;
                }
                --n2;
            }
            TreeBitSet.Assert(false);
            return -1;
        }
        int n5 = subsetClass.subsets - 1;
        while (n5 >= 0) {
            int n6 = memory.get(n + n5);
            if (n6 == -1) {
                return (n5 << subsetClass.shift + 1) - 1;
            }
            if (n6 != -2) {
                int n7 = TreeBitSet.treeLastBit(subsetClass.next, n6);
                return (n5 << subsetClass.shift) + n7;
            }
            --n5;
        }
        TreeBitSet.Assert(false);
        return -1;
    }

    static final int treeNextBit(SubsetClass subsetClass, int n, int n2) {
        n &= Integer.MAX_VALUE;
        if (subsetClass.next == null) {
            int n3 = subsetClass.subsets;
            int n4 = n2 >> 5;
            while (n4 < n3) {
                int n5 = memory.get(n + n4);
                int n6 = n2 & 0x1F;
                while (n6 <= 31) {
                    if ((1 << n6 & n5) != 0) {
                        return (n4 << 5) + n6;
                    }
                    ++n6;
                }
                n2 = 0;
                ++n4;
            }
            return -1;
        }
        int n7 = subsetClass.subsetIndex(n2);
        while (n7 < subsetClass.subsets) {
            int n8;
            int n9 = memory.get(n + n7);
            if (n9 == -1) {
                return (n7 << subsetClass.shift) + subsetClass.subsetBits(n2);
            }
            if (n9 != -2 && (n8 = TreeBitSet.treeNextBit(subsetClass.next, n9, subsetClass.subsetBits(n2))) != -1) {
                return (n7 << subsetClass.shift) + n8;
            }
            n2 = ++n7 << subsetClass.shift;
        }
        return -1;
    }

    static final int treeNextUnsetBit(SubsetClass subsetClass, int n, int n2) {
        n &= Integer.MAX_VALUE;
        if (subsetClass.next == null) {
            int n3 = subsetClass.subsets;
            int n4 = n2 >> 5;
            while (n4 < n3) {
                int n5 = memory.get(n + n4);
                int n6 = n2 & 0x1F;
                while (n6 <= 31) {
                    if ((1 << n6 & n5) == 0) {
                        return (n4 << 5) + n6;
                    }
                    ++n6;
                }
                n2 = 0;
                ++n4;
            }
            return -1;
        }
        int n7 = subsetClass.subsetIndex(n2);
        while (n7 < subsetClass.subsets) {
            int n8 = memory.get(n + n7);
            if (n8 != -1) {
                if (n8 == -2) {
                    return (n7 << subsetClass.shift) + subsetClass.subsetBits(n2);
                }
                int n9 = TreeBitSet.treeNextUnsetBit(subsetClass.next, n8, subsetClass.subsetBits(n2));
                if (n9 != -1) {
                    return (n7 << subsetClass.shift) + n9;
                }
            }
            n2 = ++n7 << subsetClass.shift;
        }
        return -1;
    }

    static void treeUnion(SubsetClass subsetClass, int n, int n2) {
        TreeBitSet.Assert((n & Integer.MIN_VALUE) == 0);
        int n3 = n & Integer.MAX_VALUE;
        int n4 = n2 & Integer.MAX_VALUE;
        if (subsetClass.next == null) {
            int n5 = 0;
            while (n5 < subsetClass.subsets) {
                memory.put(n3 + n5, memory.get(n3 + n5) | memory.get(n4 + n5));
                ++n5;
            }
            return;
        }
        int n6 = 0;
        while (n6 < subsetClass.subsets) {
            int n7 = memory.get(n3 + n6);
            int n8 = memory.get(n4 + n6);
            if (n8 == -1) {
                if (n7 != -2 && n7 != -1) {
                    TreeBitSet.treeFree(subsetClass.next, n7);
                }
                memory.put(n3 + n6, -1);
            } else if (n8 != -2 && n7 != -1) {
                if (n7 == -2) {
                    n7 = TreeBitSet.treeDeepCopy(subsetClass.next, n8);
                    memory.put(n3 + n6, n7);
                    memory.put(n4 + n6, n7);
                } else if (TreeBitSet.treeIsSubset(subsetClass.next, n7, n8)) {
                    TreeBitSet.treeFree(subsetClass.next, n7);
                    n7 = TreeBitSet.treeDeepCopy(subsetClass.next, n8);
                    memory.put(n3 + n6, n7);
                    memory.put(n4 + n6, n7);
                } else if (!TreeBitSet.treeIsSubset(subsetClass.next, n8, n7) && n7 != n8) {
                    if ((n7 & Integer.MIN_VALUE) != 0) {
                        n7 = TreeBitSet.treeShallowCopy(subsetClass.next, n7);
                        memory.put(n3 + n6, n7);
                    }
                    TreeBitSet.treeUnion(subsetClass.next, n7, n8);
                    if (TreeBitSet.treeFull(subsetClass.next, n7)) {
                        TreeBitSet.treeFree(subsetClass.next, n7);
                        memory.put(n3 + n6, -1);
                    }
                }
            }
            ++n6;
        }
    }

    static boolean treeIsSubset(SubsetClass subsetClass, int n, int n2) {
        int n3 = n & Integer.MAX_VALUE;
        int n4 = n2 & Integer.MAX_VALUE;
        if (subsetClass.next == null) {
            int n5 = 0;
            while (n5 < subsetClass.subsets) {
                int n6;
                int n7 = memory.get(n3 + n5);
                if ((n7 & (n6 = memory.get(n4 + n5))) != n7) {
                    return false;
                }
                ++n5;
            }
            return true;
        }
        int n8 = 0;
        while (n8 < subsetClass.subsets) {
            int n9 = memory.get(n3 + n8);
            int n10 = memory.get(n4 + n8);
            if (n10 != -1) {
                if (n10 == -2) {
                    if (n9 != -2) {
                        return false;
                    }
                } else {
                    if (n9 == -1) {
                        return false;
                    }
                    if (n9 != -2 && n9 != n10 && !TreeBitSet.treeIsSubset(subsetClass.next, n9, n10)) {
                        return false;
                    }
                }
            }
            ++n8;
        }
        return true;
    }

    static int treeDeepCopy(SubsetClass subsetClass, int n) {
        n &= Integer.MAX_VALUE;
        if (subsetClass.next != null) {
            int n2 = 0;
            while (n2 < subsetClass.subsets) {
                int n3 = memory.get(n + n2);
                if (n3 != -2 && n3 != -1 && (n3 & Integer.MIN_VALUE) == 0) {
                    n3 = TreeBitSet.treeDeepCopy(subsetClass.next, n3);
                    memory.put(n + n2, n3);
                }
                ++n2;
            }
        }
        return n | Integer.MIN_VALUE;
    }

    static int treeShallowCopy(SubsetClass subsetClass, int n) {
        n &= Integer.MAX_VALUE;
        int n2 = TreeBitSet.alloc(subsetClass.subsets);
        int n3 = 0;
        while (n3 < subsetClass.subsets) {
            memory.put(n2 + n3, memory.get(n + n3));
            ++n3;
        }
        return n2;
    }

    static int treePopulation(SubsetClass subsetClass, int n) {
        n &= Integer.MAX_VALUE;
        int n2 = 0;
        if (subsetClass.next == null) {
            int n3 = 0;
            while (n3 < subsetClass.subsets) {
                int n4 = memory.get(n + n3);
                while (n4 != 0) {
                    n2 += bytePopulations[n4 & 0xFF];
                    n4 >>>= 8;
                }
                ++n3;
            }
            return n2;
        }
        int n5 = 0;
        while (n5 < subsetClass.subsets) {
            int n6 = memory.get(n + n5);
            if (n6 == -1) {
                n2 += subsetClass.size;
            } else if (n6 != -2) {
                n2 += TreeBitSet.treePopulation(subsetClass.next, n6);
            }
            ++n5;
        }
        return n2;
    }

    static int smallSetSize(int n) {
        int n2 = n & 0x1FFFFFFF;
        TreeBitSet.Assert(liveRoots.get(n2));
        return memory.get(n2) & 0xFFFF;
    }

    static int mediumSetSize(int n) {
        int n2 = n & 0x1FFFFFFF;
        TreeBitSet.Assert(liveRoots.get(n2));
        return memory.get(n2);
    }

    public void and(TreeBitSet treeBitSet) {
        this._root = TreeBitSet.and(this._root, treeBitSet._root);
    }

    public void or(TreeBitSet treeBitSet) {
        this._root = TreeBitSet.or(this._root, treeBitSet._root);
    }

    static void check(int n) {
    }

    public static int close(int n) {
        return n;
    }

    public static int or(int n, int n2) {
        TreeBitSet.check(n);
        TreeBitSet.check(n2);
        if (n == n2) {
            return n;
        }
        if (TreeBitSet.getType(n2) == 6) {
            if (TreeBitSet.getType(n) != 6) {
                int n3 = n;
                n = TreeBitSet.promoteToLarge(n);
                TreeBitSet.free(n3);
            }
            TreeBitSet.treeUnion(rootSubset, n & 0x1FFFFFFF, n2 & 0x1FFFFFFF);
        } else if (TreeBitSet.getType(n2) == 5 && TreeBitSet.getType(n) == 6) {
            int n4 = TreeBitSet.promoteToLarge(n2);
            TreeBitSet.treeUnion(rootSubset, n & 0x1FFFFFFF, n4 & 0x1FFFFFFF);
            TreeBitSet.free(n4);
        } else if (TreeBitSet.getType(n) == 5 && TreeBitSet.getType(n2) == 5) {
            n = TreeBitSet.intervalOr(n, n2);
        } else if (TreeBitSet.getType(n) < 5 && TreeBitSet.getType(n2) == 5) {
            int n5 = TreeBitSet.intervalCopy(n2);
            n5 = TreeBitSet.or(n5, n);
            TreeBitSet.free(n);
            n = n5;
        } else {
            BitEnum bitEnum = new BitEnum(n2);
            while (bitEnum.hasMoreElements()) {
                n = TreeBitSet.set(n, bitEnum.nextInt());
            }
        }
        TreeBitSet.check(n);
        return n;
    }

    public static int compress(int n) {
        int n2 = 0;
        BitEnum bitEnum = new BitEnum(n);
        while (bitEnum.hasMoreElements()) {
            n2 = TreeBitSet.set(n2, bitEnum.nextInt());
        }
        TreeBitSet.free(n);
        return n2;
    }

    public static int and(int n, int n2) {
        TreeBitSet.check(n);
        TreeBitSet.check(n2);
        int n3 = n;
        int n4 = n2;
        if (n == n2) {
            return n;
        }
        if (TreeBitSet.getType(n) == 7 && TreeBitSet.length(n) >= TreeBitSet.length(n2)) {
            TreeBitSet.free(n);
            return TreeBitSet.clone(n2);
        }
        if (TreeBitSet.getType(n2) == 7 && TreeBitSet.length(n2) >= TreeBitSet.length(n)) {
            return n;
        }
        if (TreeBitSet.getType(n) > TreeBitSet.getType(n2)) {
            n3 = n2;
            n4 = n;
        }
        int n5 = 0;
        BitEnum bitEnum = new BitEnum(n3);
        while (bitEnum.hasMoreElements()) {
            int n6 = bitEnum.nextInt();
            if (!TreeBitSet.get(n4, n6)) continue;
            n5 = TreeBitSet.set(n5, n6);
        }
        TreeBitSet.free(n);
        TreeBitSet.check(n5);
        return n5;
    }

    static String hex(int n) {
        return Integer.toHexString(n);
    }

    public int memoryUsage() {
        return TreeBitSet.memoryUsage(this._root);
    }

    public static int memoryUsage(int n) {
        switch (TreeBitSet.getType(n)) {
            case 0: {
                TreeBitSet.Assert(n == 0);
                return 0;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 8;
            }
            case 3: {
                return 12;
            }
            case 4: {
                int n2 = (memory.get(n & 0x1FFFFFFF) & 0xFFFF) * 4 + 4;
                return n2;
            }
            case 5: {
                int n3 = memory.get((n & 0x1FFFFFFF) + 1) * 8 + 8;
                return n3;
            }
            case 6: {
                int n4 = TreeBitSet.treeMemoryUsage(rootSubset, n & 0x1FFFFFFF) * 4;
                return n4;
            }
            case 7: {
                return 0;
            }
        }
        TreeBitSet.Assert(false);
        return 0;
    }

    public int type() {
        return TreeBitSet.getType(this._root);
    }

    public int numberOfElements() {
        return TreeBitSet.numberOfElements(this._root);
    }

    public static int numberOfElements(int n) {
        switch (TreeBitSet.getType(n)) {
            case 0: {
                TreeBitSet.Assert(n == 0);
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return memory.get(n & 0x1FFFFFFF) & 0xFFFF;
            }
            case 5: {
                int n2 = 0;
                int n3 = n & 0x1FFFFFFF;
                int n4 = memory.get(n3);
                int n5 = memory.get(n3 + 1);
                int n6 = 0;
                while (n6 < n4) {
                    n2 += memory.get(n3 + 2 + n5 + n6);
                    ++n6;
                }
                return n2;
            }
            case 6: {
                return TreeBitSet.treePopulation(rootSubset, n & 0x1FFFFFFF);
            }
            case 7: {
                return (n & 0x1FFFFFFF) + 1;
            }
        }
        TreeBitSet.Assert(false);
        return 0;
    }

    public static int clone(int n) {
        int n2 = n & 0x1FFFFFFF;
        switch (TreeBitSet.getType(n)) {
            case 0: {
                TreeBitSet.Assert(n == 0);
                return n;
            }
            case 1: {
                return n;
            }
            case 2: {
                int n3 = TreeBitSet.copyalloc(n2, 2, 2);
                n3 = TreeBitSet.setType(n3, 2);
                return n3;
            }
            case 3: {
                int n4 = TreeBitSet.copyalloc(n2, 3, 3);
                n4 = TreeBitSet.setType(n4, 3);
                return n4;
            }
            case 4: {
                int n5 = memory.get(n2) >>> 16;
                int n6 = TreeBitSet.copyalloc(n2, n5 + 1, n5 + 1);
                n6 = TreeBitSet.setType(n6, 4);
                return n6;
            }
            case 5: {
                int n7 = memory.get(n2 + 1);
                int n8 = TreeBitSet.copyalloc(n2, n7 * 2 + 2, n7 * 2 + 2);
                n8 = TreeBitSet.setType(n8, 5);
                return n8;
            }
            case 6: {
                int n9 = TreeBitSet.treeClone(rootSubset, n2);
                liveRoots.set(n9);
                n9 = TreeBitSet.setType(n9, 6);
                return n9;
            }
            case 7: {
                return n;
            }
        }
        TreeBitSet.Assert(false);
        return 0;
    }

    public boolean equals(Object object) {
        TreeBitSet treeBitSet = (TreeBitSet)object;
        return TreeBitSet.equals(this._root, treeBitSet._root);
    }

    public static boolean equals(int n, int n2) {
        if (TreeBitSet.getType(n) == 5 && TreeBitSet.getType(n2) == 5) {
            int n3;
            int n4 = n & 0x1FFFFFFF;
            int n5 = n2 & 0x1FFFFFFF;
            int n6 = memory.get(n4);
            if (n6 != (n3 = memory.get(n5))) {
                return false;
            }
            int n7 = memory.get(n4 + 1);
            int n8 = memory.get(n5 + 1);
            int n9 = 0;
            while (n9 < n6) {
                if (memory.get(n4 + n9 + 2) != memory.get(n5 + n9 + 2)) {
                    return false;
                }
                if (memory.get(n4 + n9 + n7 + 2) != memory.get(n5 + n9 + n8 + 2)) {
                    return false;
                }
                ++n9;
            }
            return true;
        }
        if (TreeBitSet.length(n) != TreeBitSet.length(n2)) {
            return false;
        }
        if (TreeBitSet.getType(n) == 7 && TreeBitSet.getType(n2) == 7) {
            return true;
        }
        if (TreeBitSet.numberOfElements(n) != TreeBitSet.numberOfElements(n2)) {
            return false;
        }
        int n10 = TreeBitSet.length(n);
        int n11 = 0;
        while (n11 < n10) {
            if (TreeBitSet.get(n, n11) != TreeBitSet.get(n2, n11)) {
                return false;
            }
            ++n11;
        }
        return true;
    }

    public Object clone() {
        TreeBitSet treeBitSet = new TreeBitSet();
        treeBitSet._root = TreeBitSet.clone(this._root);
        return treeBitSet;
    }

    public int size() {
        TreeBitSet.Assert(false);
        return 0;
    }

    public IntEnumeration elements() {
        return TreeBitSet.elements(this._root);
    }

    public static IntEnumeration elements(int n) {
        return new BitEnum(n);
    }

    public static IntPairEnumeration intPairs(int n) {
        return new PairEnum(n);
    }

    protected void finalize() throws Throwable {
        TreeBitSet.free(this._root);
    }

    public static synchronized void free(int n) {
        int n2 = n & 0x1FFFFFFF;
        switch (TreeBitSet.getType(n)) {
            case 0: {
                TreeBitSet.Assert(n == 0);
            }
            case 1: {
                return;
            }
            case 2: {
                TreeBitSet.freeroot(n2, 2);
                return;
            }
            case 3: {
                TreeBitSet.freeroot(n2, 3);
                return;
            }
            case 4: {
                int n3 = memory.get(n2) >>> 16;
                TreeBitSet.freeroot(n2, n3 + 1);
                return;
            }
            case 5: {
                int n4 = memory.get(n2 + 1);
                TreeBitSet.freeroot(n2, n4 * 2 + 2);
                return;
            }
            case 6: {
                TreeBitSet.treeFree(rootSubset, n2);
                liveRoots.clear(n2);
                return;
            }
            case 7: {
                return;
            }
        }
        TreeBitSet.Assert(false);
    }

    static void treeWriteObject(ObjectOutputStream objectOutputStream, SubsetClass subsetClass, int n) throws IOException {
        int n2 = 0;
        while (n2 < subsetClass.subsets) {
            int n3 = memory.get(n + n2);
            if (subsetClass.next != null && n3 != -2 && n3 != -1) {
                objectOutputStream.writeInt(-3);
                TreeBitSet.treeWriteObject(objectOutputStream, subsetClass.next, n3 &= Integer.MAX_VALUE);
            } else {
                objectOutputStream.writeInt(n3);
            }
            ++n2;
        }
    }

    static int treeReadObject(ObjectInputStream objectInputStream, SubsetClass subsetClass) throws IOException {
        int n = TreeBitSet.treeAlloc(subsetClass);
        int n2 = 0;
        while (n2 < subsetClass.subsets) {
            int n3 = objectInputStream.readInt();
            if (subsetClass.next != null && n3 == -3) {
                n3 = TreeBitSet.treeReadObject(objectInputStream, subsetClass.next);
            }
            memory.put(n + n2, n3);
            ++n2;
        }
        return n;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        TreeBitSet.writeRoot(objectOutputStream, this._root);
    }

    public static void writeRoot(ObjectOutputStream objectOutputStream, int n) throws IOException {
        objectOutputStream.writeInt(n);
        int n2 = n & 0x1FFFFFFF;
        switch (TreeBitSet.getType(n)) {
            case 0: {
                TreeBitSet.Assert(n == 0);
            }
            case 1: {
                return;
            }
            case 2: {
                objectOutputStream.writeInt(memory.get(n2));
                objectOutputStream.writeInt(memory.get(n2 + 1));
                return;
            }
            case 3: {
                objectOutputStream.writeInt(memory.get(n2));
                objectOutputStream.writeInt(memory.get(n2 + 1));
                objectOutputStream.writeInt(memory.get(n2 + 2));
                return;
            }
            case 4: {
                int n3 = memory.get(n2) >>> 16;
                objectOutputStream.writeInt(memory.get(n2));
                int n4 = 0;
                while (n4 < n3) {
                    objectOutputStream.writeInt(memory.get(n2 + 1 + n4));
                    ++n4;
                }
                return;
            }
            case 5: {
                int n5 = memory.get(n2 + 1);
                objectOutputStream.writeInt(memory.get(n2));
                objectOutputStream.writeInt(memory.get(n2 + 1));
                int n6 = 0;
                while (n6 < n5 * 2) {
                    objectOutputStream.writeInt(memory.get(n2 + 2 + n6));
                    ++n6;
                }
                return;
            }
            case 6: {
                TreeBitSet.treeWriteObject(objectOutputStream, rootSubset, n2);
                return;
            }
            case 7: {
                return;
            }
        }
        TreeBitSet.Assert(false);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this._root = TreeBitSet.readRoot(objectInputStream);
    }

    public static int readRoot(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n = objectInputStream.readInt();
        int n2 = TreeBitSet.getType(n);
        switch (n2) {
            case 0: {
                TreeBitSet.Assert(n == 0);
            }
            case 1: {
                return n;
            }
            case 2: {
                n = TreeBitSet.rootalloc(2);
                memory.put(n, objectInputStream.readInt());
                memory.put(n + 1, objectInputStream.readInt());
                return TreeBitSet.setType(n, n2);
            }
            case 3: {
                n = TreeBitSet.rootalloc(3);
                memory.put(n, objectInputStream.readInt());
                memory.put(n + 1, objectInputStream.readInt());
                memory.put(n + 2, objectInputStream.readInt());
                return TreeBitSet.setType(n, n2);
            }
            case 4: {
                int n3 = objectInputStream.readInt();
                int n4 = n3 & 0xFFFF;
                int n5 = n3 >>> 16;
                n = TreeBitSet.rootalloc(n5 + 1);
                memory.put(n, n3);
                int n6 = 0;
                while (n6 < n5) {
                    memory.put(n + 1 + n6, objectInputStream.readInt());
                    ++n6;
                }
                return TreeBitSet.setType(n, n2);
            }
            case 5: {
                int n7 = objectInputStream.readInt();
                int n8 = objectInputStream.readInt();
                n = TreeBitSet.rootalloc(n8 * 2 + 2);
                memory.put(n, n7);
                memory.put(n + 1, n8);
                int n9 = 0;
                while (n9 < n8 * 2) {
                    memory.put(n + 2 + n9, objectInputStream.readInt());
                    ++n9;
                }
                return TreeBitSet.setType(n, n2);
            }
            case 6: {
                n = TreeBitSet.treeReadObject(objectInputStream, rootSubset);
                return TreeBitSet.setType(n, n2);
            }
            case 7: {
                return n;
            }
        }
        TreeBitSet.Assert(false);
        return 0;
    }

    static void Assert(boolean bl) {
        if (!bl) {
            throw new Error("assert failed!");
        }
    }

    public static void main(String[] stringArray) {
        int n = TreeBitSet.setAll(0, 100);
        int n2 = TreeBitSet.clone(n);
        n2 = TreeBitSet.or(n2, TreeBitSet.set(0, 50));
        TestBits testBits = new TestBits(6833, 71, 7034);
        testBits.compare();
        TestBits testBits2 = (TestBits)testBits.clone();
        testBits2.compare();
        TestBits testBits3 = new TestBits(0, 2, 2049);
        testBits3.expect(0, 2, 2049);
        testBits3 = new TestBits(0, 1, 1000);
        testBits3.expect(0, 1, 1000);
        testBits3 = new TestBits(0, 2, 1000);
        testBits3.expect(0, 2, 1000);
        TestBits testBits4 = new TestBits(1, 2, 1000);
        testBits4.expect(1, 2, 1000);
        testBits3.or(testBits4);
        testBits3.expect(0, 1, 1000);
        testBits4 = new TestBits(1000, 2, 2000);
        testBits4.expect(1000, 2, 2000);
        testBits3.or(testBits4);
        testBits4.expect(1000, 2, 2000);
        testBits4 = new TestBits(1001, 2, 2000);
        testBits3.or(testBits4);
        testBits4.expect(1001, 2, 2000);
        testBits3.expect(0, 1, 2000);
        testBits3 = new TestBits(0, 2, 8000);
        testBits4 = new TestBits(1, 2, 2);
        testBits4.or(testBits3);
        testBits3 = new TestBits(3, 2, 8000);
        TestBits testBits5 = new TestBits(3, 2, 8000);
        testBits5.or(testBits4);
        testBits5.expect(0, 1, 8000);
        testBits5 = new TestBits(3, 2, 4);
        testBits5.or(testBits4);
        testBits5.or(new TestBits(0, 1, 3));
        TestBits testBits6 = new TestBits(3, 2, 4);
        testBits6.or(testBits4);
        testBits5.or(testBits6);
        testBits5.or(new TestBits(3, 2, 8000));
        testBits5.expect(0, 1, 8000);
        testBits4.or(testBits3);
        testBits4.expect(0, 1, 8000);
        int n3 = 0;
        while (n3 < 1000) {
            testBits3 = new TestBits(0, 100, n3);
            testBits3.expect(0, 100, n3);
            testBits3 = new TestBits(0, 2, n3);
            testBits3.expect(0, 2, n3);
            testBits3 = new TestBits(0, 1, n3);
            testBits3.expect(0, 1, n3);
            testBits3 = new TestBits(0, 1, n3);
            testBits4 = new TestBits(0, 2, n3);
            testBits5 = new TestBits(n3);
            testBits3.and(testBits4);
            testBits3.and(testBits5);
            testBits3.expect(0, 2, n3);
            ++n3;
        }
        Random random = new Random(23L);
        int n4 = 0;
        while (n4 < 10000) {
            int n5 = random.nextInt(100);
            int n6 = random.nextInt(10000);
            int n7 = n6 + random.nextInt(10000);
            System.out.println("i = " + n4 + " doing min " + n6 + " int " + n5 + " max " + n7);
            testBits3 = new TestBits(n6, n5, n7);
            testBits3.compare();
            n5 = random.nextInt(100);
            n6 = random.nextInt(10000);
            n7 = n6 + random.nextInt(10000);
            System.out.println("doing min " + n6 + " int " + n5 + " max " + n7);
            testBits4 = new TestBits(n6, n5, n7);
            testBits3.or(testBits4);
            testBits3.compare();
            n5 = random.nextInt(100);
            n6 = random.nextInt(10000);
            n7 = n6 + random.nextInt(10000);
            System.out.println("doing min " + n6 + " int " + n5 + " max " + n7);
            testBits5 = new TestBits(n6, n5, n7);
            testBits5.and(testBits3);
            testBits5.compare();
            int n8 = 0;
            while (n8 < 10) {
                testBits3.set(random.nextInt(10000));
                testBits3.set(random.nextInt(10000));
                testBits5.set(random.nextInt(10000));
                ++n8;
            }
            testBits3.compare();
            testBits4.compare();
            testBits5.compare();
            TestBits testBits7 = (TestBits)testBits3.clone();
            testBits7.compare();
            TestBits testBits8 = (TestBits)testBits4.clone();
            testBits8.compare();
            if (!TreeBitSet.equals(testBits4.set._root, testBits8.set._root)) {
                throw new Error("equals failed!");
            }
            TestBits testBits9 = (TestBits)testBits5.clone();
            testBits9.compare();
            ++n4;
        }
    }

    static {
        memory = new Memory();
        liveRoots = new BitSet();
        shared = new BitSet();
        freeLists = new int[256];
        int n = 7;
        rootSubset = new SubsetClass(null, n);
        int n2 = 2;
        while (n + n2 < 29) {
            rootSubset = new SubsetClass(rootSubset, n2);
            n += n2;
        }
        if (n < 29) {
            rootSubset = new SubsetClass(rootSubset, 29 - n);
        }
        if ((n2 = TreeBitSet.rootSubset.shift + TreeBitSet.rootSubset.bits) != 29) {
            throw new Error("total bits is " + n2 + " but should be " + 29);
        }
        freeLists = new int[2048];
        n = 0;
        while (n < freeLists.length) {
            TreeBitSet.freeLists[n] = -1;
            ++n;
        }
        bytePopulations = new int[]{0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8};
    }

    static class TestBits {
        BitSet bits;
        TreeBitSet set;

        TestBits(int n, int n2, int n3) {
            this.set = new TreeBitSet();
            this.bits = new BitSet();
            if (n2 == 0) {
                n2 = 1;
            }
            int n4 = n;
            while (n4 < n3) {
                this.set.set(n4);
                this.bits.set(n4);
                n4 += n2;
            }
        }

        TestBits(int n) {
            this.set = new TreeBitSet();
            this.bits = new BitSet();
            int n2 = 0;
            while (n2 < n) {
                this.bits.set(n2);
                ++n2;
            }
            this.set.setAll(n - 1);
        }

        TestBits() {
        }

        public Object clone() {
            TestBits testBits = new TestBits();
            testBits.bits = (BitSet)this.bits.clone();
            testBits.set = (TreeBitSet)this.set.clone();
            return testBits;
        }

        void set(int n) {
            this.set.set(n);
            this.bits.set(n);
        }

        void and(TestBits testBits) {
            this.set.and(testBits.set);
            this.bits.and(testBits.bits);
        }

        void or(TestBits testBits) {
            this.set.or(testBits.set);
            this.bits.or(testBits.bits);
        }

        void compare() {
            int n = this.bits.length();
            if (n != this.set.length()) {
                throw new Error("length mismatch, bits = " + n + " set = " + this.set.length() + " type = " + this.set.type());
            }
            int n2 = 0;
            while (n2 < n) {
                if (this.bits.get(n2) != this.set.get(n2)) {
                    throw new Error("mismatch on bit " + n2);
                }
                ++n2;
            }
        }

        void expect(int n, int n2, int n3) {
            int n4 = 0;
            boolean bl = false;
            int n5 = n;
            while (n5 < n3) {
                bl = true;
                if (!this.set.get(n5)) {
                    throw new Error("i " + n5 + " was not set!");
                }
                n5 += n2;
                ++n4;
            }
            if (bl && this.set.length() != n5 - n2 + 1) {
                throw new Error("expected length " + (n5 - n2) + " but found " + this.set.length());
            }
            if (this.set.numberOfElements() != n4) {
                throw new Error("expected " + n4 + " found " + this.set.numberOfElements());
            }
            n5 = n3;
            while (n5 < n3 * 2) {
                if (this.set.get(n5)) {
                    throw new Error("i " + n5 + " IS set!");
                }
                ++n5;
            }
            BitSet bitSet = new BitSet();
            IntEnumeration intEnumeration = this.set.elements();
            while (intEnumeration.hasMoreElements()) {
                n5 = intEnumeration.nextInt();
                if (!this.bits.get(n5)) {
                    throw new Error("i " + n5 + " was not set!");
                }
                bitSet.set(n5);
            }
            if (!this.bits.equals(bitSet)) {
                throw new Error("enum did not match");
            }
        }
    }

    static class PairEnum
    extends BitEnum
    implements IntPairEnumeration {
        PairEnum(int n) {
            super(n);
        }

        public Object nextElement() {
            return new Long(this.nextIntPair());
        }

        long makePair(int n, int n2) {
            return (long)n << 32 | (long)n2;
        }

        public long nextIntPair() {
            int n = this.root & 0x1FFFFFFF;
            switch (TreeBitSet.getType(this.root)) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    int n2;
                    int n3 = n2 = this.nextInt();
                    while (this.hasMoreElements() && this.peekInt() == n3 + 1) {
                        n3 = this.nextInt();
                    }
                    return this.makePair(n2, n3);
                }
                case 5: {
                    int n4 = memory.get(n + 2 + this.index);
                    int n5 = memory.get(n + 1);
                    int n6 = n4 + memory.get(n + 2 + n5 + this.index) - 1;
                    ++this.index;
                    return this.makePair(n4, n6);
                }
                case 6: {
                    int n7 = this.index;
                    int n8 = TreeBitSet.treeNextUnsetBit(rootSubset, n, this.index + 1) - 1;
                    TreeBitSet.Assert(n8 != -1);
                    this.index = TreeBitSet.treeNextBit(rootSubset, n, n8 + 1);
                    return this.makePair(n7, n8);
                }
                case 7: {
                    int n9 = 0;
                    int n10 = this.root & 0x1FFFFFFF;
                    this.index = n10 + 1;
                    return this.makePair(n9, n10);
                }
            }
            TreeBitSet.Assert(false);
            return -1L;
        }

        public void reset() {
            this.index = 0;
            this.offset = 0;
            if (TreeBitSet.getType(this.root) == 6) {
                this.index = TreeBitSet.treeNextBit(rootSubset, this.root & 0x1FFFFFFF, 0);
            }
        }
    }

    static class BitEnum
    implements IntEnumeration {
        int index;
        int offset;
        int root;

        BitEnum(int n) {
            this.root = n;
            this.reset();
        }

        public boolean hasMoreElements() {
            switch (TreeBitSet.getType(this.root)) {
                case 0: {
                    TreeBitSet.Assert(this.root == 0);
                    return false;
                }
                case 1: {
                    return this.index == 0;
                }
                case 2: {
                    return this.index <= 1;
                }
                case 3: {
                    return this.index <= 2;
                }
                case 4: {
                    return this.index < (memory.get(this.root & 0x1FFFFFFF) & 0xFFFF);
                }
                case 5: {
                    return this.index < memory.get(this.root & 0x1FFFFFFF);
                }
                case 6: {
                    return this.index != -1;
                }
                case 7: {
                    return this.index <= (this.root & 0x1FFFFFFF);
                }
            }
            TreeBitSet.Assert(false);
            return false;
        }

        public Object nextElement() {
            return new Integer(this.nextInt());
        }

        public int nextInt() {
            int n = this.root & 0x1FFFFFFF;
            switch (TreeBitSet.getType(this.root)) {
                case 1: {
                    ++this.index;
                    return this.root & 0x1FFFFFFF;
                }
                case 2: 
                case 3: {
                    return memory.get(n + this.index++);
                }
                case 4: {
                    return memory.get(n + 1 + this.index++);
                }
                case 5: {
                    int n2 = memory.get(n + 2 + this.index) + this.offset;
                    int n3 = memory.get(n + 1);
                    if (++this.offset >= memory.get(n + 2 + n3 + this.index)) {
                        ++this.index;
                        this.offset = 0;
                    }
                    return n2;
                }
                case 6: {
                    int n4 = this.index;
                    this.index = TreeBitSet.treeNextBit(rootSubset, n, this.index + 1);
                    return n4;
                }
                case 7: {
                    return this.index++;
                }
            }
            TreeBitSet.Assert(false);
            return -1;
        }

        public int peekInt() {
            int n = this.root & 0x1FFFFFFF;
            switch (TreeBitSet.getType(this.root)) {
                case 1: {
                    return this.root & 0x1FFFFFFF;
                }
                case 2: 
                case 3: {
                    return memory.get(n + this.index);
                }
                case 4: {
                    return memory.get(n + 1 + this.index);
                }
                case 5: {
                    return memory.get(n + 2 + this.index) + this.offset;
                }
                case 6: {
                    return this.index;
                }
                case 7: {
                    return this.index;
                }
            }
            TreeBitSet.Assert(false);
            return -1;
        }

        public void reset() {
            this.index = 0;
            this.offset = 0;
            if (TreeBitSet.getType(this.root) == 6) {
                this.index = TreeBitSet.treeNextBit(rootSubset, this.root & 0x1FFFFFFF, 0);
            }
        }
    }
}

