/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi;

import com.ibm.CORBA.iiop.ExtendedServerDelegate;
import com.ibm.CORBA.iiop.IOR;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.CORBA.iiop.ObjectKey;
import com.ibm.CORBA.iiop.Profile;
import com.ibm.CORBA.iiop.ServerDelegate;
import com.ibm.CORBA.iiop.ServerSubcontract;
import com.ibm.CORBA.ras.ORBRas;
import com.ibm.rmi.corba.ClientSubcontract;
import com.ibm.rmi.corba.INSRegistry;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import javax.rmi.CORBA.Util;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;

public class SubcontractRegistry
implements com.ibm.CORBA.iiop.SubcontractRegistry {
    public static final String[] default_serverClassNames = new String[]{"com.ibm.CORBA.iiop.ServerDelegate", "com.ibm.CORBA.iiop.ExtendedServerDelegate", "com.ibm.rmi.poa.GenericPOAServerSC", "com.ibm.rmi.poa.GenericPOAServerSC"};
    public static final int[] default_scIds = new int[]{16, 18, 21, 22};
    protected ServerSubcontract[] serverRegistry;
    protected int[] scIds;
    protected ServerSubcontract bootstrapServer = null;
    private INSRegistry insRegistry = null;
    private Map delegateCache = Collections.synchronizedMap(new WeakHashMap());
    protected ORB orb;
    protected boolean closed = false;

    public SubcontractRegistry(ORB oRB) {
        this.orb = oRB;
        this.initialize();
    }

    protected void initialize() {
        int n = default_scIds.length;
        this.scIds = new int[n];
        System.arraycopy(default_scIds, 0, this.scIds, 0, n);
        this.serverRegistry = new ServerSubcontract[n];
    }

    public void registerDefaultSubcontracts() {
        int n = 0;
        while (n < this.serverRegistry.length) {
            if (this.serverRegistry[n] == null) {
                this.registerServerSubcontract(default_serverClassNames[n], n, default_scIds[n]);
            }
            ++n;
        }
        this.closed = true;
    }

    public synchronized boolean registerServerSubcontract(String string, int n, int n2) {
        try {
            if (this.closed) {
                throw new Exception("registration period is closed - this method should only be called by a SubcontractInit plugin during ORB init processing");
            }
            this.validate(n, n2);
            Class clazz = Util.loadClass(string, null, null);
            ServerSubcontract serverSubcontract = (ServerSubcontract)clazz.newInstance();
            serverSubcontract.setOrb(this.orb);
            serverSubcontract.setId(n2);
            this.scIds[n] = n2;
            this.serverRegistry[n] = serverSubcontract;
        }
        catch (Exception exception) {
            ORBRas.orbTrcLogger.trace(4104L, (Object)this, "registerServerSubcontract:160", "failed to register server subcontract: " + string + " subcontract type: " + n + " subcontract id: " + n2, (Object)exception);
            return false;
        }
        return true;
    }

    private void validate(int n, int n2) {
        if (n < 0 || n > default_scIds.length - 1) {
            throw new IllegalArgumentException("Invalid subcontract type: " + n);
        }
        if (this.serverRegistry[n] != null) {
            throw new IllegalArgumentException("A server subcontract is already registered for subcontract type: " + n);
        }
        int n3 = 0;
        while (n3 < default_scIds.length) {
            if (n3 != n && default_scIds[n3] == n2) {
                throw new IllegalArgumentException("Subcontract id: " + n2 + " is already registered for subcontract type: " + n3);
            }
            ++n3;
        }
    }

    public boolean registerClient(Class clazz, int n) {
        return true;
    }

    public boolean registerServer(ServerSubcontract serverSubcontract, int n) {
        int n2;
        if (serverSubcontract instanceof ExtendedServerDelegate) {
            n2 = 1;
        } else if (serverSubcontract instanceof ServerDelegate) {
            n2 = 0;
        } else {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(4104L, (Object)this, "registerServer:217", "subcontract type cannot be inferred from the server subcontract - use orb.registerServerSubcontract ", (Object)serverSubcontract);
            }
            return false;
        }
        return this.registerServerSubcontract(serverSubcontract.getClass().getName(), n2, n);
    }

    public void registerBootstrapServer(ServerSubcontract serverSubcontract) {
        this.bootstrapServer = serverSubcontract;
    }

    public void setINSRegistry(INSRegistry iNSRegistry) {
        this.insRegistry = iNSRegistry;
    }

    public ServerSubcontract getServerSubcontract(int n) {
        ServerSubcontract serverSubcontract = null;
        if (n >= 0 && n < this.serverRegistry.length) {
            serverSubcontract = this.serverRegistry[n];
        }
        if (serverSubcontract == null) {
            throw new INTERNAL("Unknown subcontract type:" + n, 1229125022, CompletionStatus.COMPLETED_NO);
        }
        return serverSubcontract;
    }

    private ServerSubcontract getServerSubcontractForId(int n) {
        Object var2_2 = null;
        int n2 = 0;
        while (n2 < this.scIds.length) {
            if (this.scIds[n2] == n) {
                return this.getServerSubcontract(n2);
            }
            ++n2;
        }
        throw new INTERNAL("Unknown subcontract id:" + n, 1229125018, CompletionStatus.COMPLETED_NO);
    }

    public ServerSubcontract getServerSubcontract(ObjectKey objectKey) {
        ServerSubcontract serverSubcontract = null;
        if (objectKey.isSINO()) {
            return this.bootstrapServer;
        }
        try {
            if (objectKey.isMBI()) {
                int n = objectKey.getSCID();
                serverSubcontract = this.getServerSubcontractForId(n);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (serverSubcontract == null && this.insRegistry != null) {
            serverSubcontract = this.insRegistry.getSubcontract(objectKey.getBytes());
        }
        return serverSubcontract;
    }

    public ClientSubcontract getClientSubcontract(IOR iOR) {
        Class clazz = null;
        ClientSubcontract clientSubcontract = null;
        int n = 0;
        int n2 = this.scIds[n];
        Profile profile = iOR.getProfile();
        ObjectKey objectKey = profile.getObjectKeyObject();
        WeakReference weakReference = (WeakReference)this.delegateCache.get(profile);
        if (weakReference != null) {
            clientSubcontract = (ClientSubcontract)weakReference.get();
        }
        if (clientSubcontract == null) {
            try {
                try {
                    if (objectKey.isMBI()) {
                        n2 = objectKey.getSCID();
                        clazz = this.getServerSubcontractForId(n2).getClientSubcontractClass();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (clazz == null) {
                    clazz = this.getServerSubcontract(n).getClientSubcontractClass();
                }
                clientSubcontract = (ClientSubcontract)clazz.newInstance();
                clientSubcontract.unmarshal(iOR);
                clientSubcontract.setOrb(this.orb);
                this.delegateCache.put(profile, new WeakReference(clientSubcontract));
            }
            catch (Exception exception) {
                ORBRas.orbTrcLogger.exception(4104L, this, "getClientSubcontract:344", exception);
                throw new INTERNAL("Unable to create ClientSubcontract for scid:" + n2, 1229125021, CompletionStatus.COMPLETED_NO);
            }
        }
        return clientSubcontract;
    }
}

