/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.corba;

import com.ibm.CORBA.iiop.ClientRequest;
import com.ibm.CORBA.iiop.ClientResponse;
import com.ibm.CORBA.iiop.ObjectKey;
import com.ibm.CORBA.ras.ORBRas;
import com.ibm.org.omg.CORBA._ObjectStub;
import com.ibm.rmi.IOR;
import com.ibm.rmi.SubcontractRegistry;
import com.ibm.rmi.corba.ClientSubcontract;
import com.ibm.rmi.corba.ORB;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Properties;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.DATA_CONVERSION;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.RemarshalException;

public class InitialNamingClient {
    private URL servicesURL = null;
    private int initialServicesPort = 2809;
    private String[] listOfInitialServices;
    private Properties resolvedInitialReferences = null;
    protected ORB orb;
    private static final ObjectKey initialKey = ObjectKey.getSINOKey();

    InitialNamingClient(ORB oRB) {
        this.orb = oRB;
    }

    void setServicesURL(URL uRL) {
        this.servicesURL = uRL;
    }

    void setInitialServicesPort(int n) {
        this.initialServicesPort = n;
    }

    String[] list_initial_services() {
        return this.cachedServices();
    }

    private synchronized Properties getInitialReferenceCache() {
        if (this.resolvedInitialReferences == null) {
            Properties properties = new Properties();
            if (this.servicesURL != null) {
                try {
                    URLConnection uRLConnection = this.servicesURL.openConnection();
                    InputStream inputStream = uRLConnection.getInputStream();
                    properties.load(inputStream);
                    inputStream.close();
                }
                catch (IOException iOException) {
                    ORBRas.orbTrcLogger.exception(4104L, this, "getInitialReferenceCache:139", (Exception)iOException);
                    throw new COMM_FAILURE(iOException.toString(), 1229124376, CompletionStatus.COMPLETED_NO);
                }
            }
            this.resolvedInitialReferences = properties;
        }
        return this.resolvedInitialReferences;
    }

    private String[] cachedServices() {
        if (this.listOfInitialServices == null) {
            String[] stringArray = null;
            if (this.listOfInitialServices == null && this.servicesURL != null) {
                Properties properties;
                Properties properties2 = properties = this.getInitialReferenceCache();
                synchronized (properties2) {
                    stringArray = new String[properties.size()];
                    Enumeration enumeration = properties.keys();
                    int n = 0;
                    while (enumeration.hasMoreElements()) {
                        stringArray[n] = (String)enumeration.nextElement();
                        ++n;
                    }
                }
            } else {
                stringArray = this.getInitialServices(this.orb.getORBInitialHost(), this.initialServicesPort);
            }
            this.listOfInitialServices = stringArray;
        }
        return this.listOfInitialServices;
    }

    private String[] getInitialServices(String string, int n) {
        ClientSubcontract clientSubcontract = this.getInitialRep(string, n);
        _ObjectStub _ObjectStub2 = new _ObjectStub();
        _ObjectStub2._set_delegate(clientSubcontract);
        ClientRequest clientRequest = clientSubcontract.createRequest(_ObjectStub2, "list", false);
        try {
            ClientResponse clientResponse = clientSubcontract.invoke(clientRequest);
            if (clientResponse.isSystemException()) {
                throw clientResponse.getSystemException();
            }
            int n2 = clientResponse.read_long();
            String[] stringArray = new String[n2];
            int n3 = 0;
            while (n3 < n2) {
                stringArray[n3] = clientResponse.read_string();
                ++n3;
            }
            return stringArray;
        }
        catch (RemarshalException remarshalException) {
            return this.getInitialServices(string, n);
        }
    }

    private ClientSubcontract getInitialRep(String string, int n) {
        com.ibm.CORBA.iiop.ORB cfr_ignored_0 = (com.ibm.CORBA.iiop.ORB)this.orb;
        IOR iOR = (IOR)com.ibm.CORBA.iiop.ORB.createBootstrapIOR((com.ibm.CORBA.iiop.ORB)this.orb, string, n, initialKey);
        iOR.getProfile().setMinor((byte)0);
        SubcontractRegistry subcontractRegistry = (SubcontractRegistry)this.orb.getSubcontractRegistry();
        ClientSubcontract clientSubcontract = subcontractRegistry.getClientSubcontract(iOR);
        return clientSubcontract;
    }

    Object resolve_initial_references(String string) throws InvalidName {
        return this.cachedInitialReferences(string);
    }

    private Object resolve(String string, String string2, int n) {
        ClientSubcontract clientSubcontract = this.getInitialRep(string2, n);
        _ObjectStub _ObjectStub2 = new _ObjectStub();
        _ObjectStub2._set_delegate(clientSubcontract);
        ClientRequest clientRequest = clientSubcontract.createRequest(_ObjectStub2, "get", false);
        clientRequest.write_string(string);
        try {
            ClientResponse clientResponse = clientSubcontract.invoke(clientRequest);
            if (clientResponse.isSystemException()) {
                throw clientResponse.getSystemException();
            }
            return clientResponse.read_Object();
        }
        catch (RemarshalException remarshalException) {
            return this.resolve(string, string2, n);
        }
    }

    Object resolve_initial_references(String string, String string2) throws InvalidName {
        int n = string2.indexOf(":");
        if (n <= 0) {
            throw new DATA_CONVERSION("BAD_MODIFIER (1) ':' missing from modifier", 1229124485, CompletionStatus.COMPLETED_NO);
        }
        try {
            String string3 = string2.substring(0, n);
            int n2 = Integer.parseInt(string2.substring(n + 1, string2.length()));
            return this.resolve_initial_references(string, string3, n2);
        }
        catch (Exception exception) {
            ORBRas.orbTrcLogger.exception(4104L, this, "resolve_initial_references:302", exception);
            throw new DATA_CONVERSION("BAD_MODIFIER (2)", 1229124486, CompletionStatus.COMPLETED_NO);
        }
    }

    Object resolve_initial_references(String string, String string2, int n) throws InvalidName {
        Object object = this.resolve(string, string2, n);
        if (object == null) {
            throw new InvalidName("Unable to resolve initial references (1)");
        }
        return object;
    }

    private Object cachedInitialReferences(String string) throws InvalidName {
        Object object = null;
        String string2 = null;
        Properties properties = this.getInitialReferenceCache();
        string2 = properties.getProperty(string);
        if (string2 == null && this.servicesURL == null && (object = this.resolve(string, this.orb.getORBInitialHost(), this.initialServicesPort)) != null) {
            string2 = this.orb.object_to_string(object);
            properties.put(string, string2);
        }
        if (string2 == null || string2.length() == 0) {
            throw new InvalidName("Unable to resolve initial reference");
        }
        if (object == null) {
            object = this.orb.string_to_object(string2);
        }
        return object;
    }

    Object resolve_initial_references_remote(String string, String[] stringArray) throws InvalidName {
        String string2 = null;
        Object object = null;
        Exception exception = null;
        int n = 0;
        while (n < stringArray.length) {
            String string3 = null;
            int n2 = 0;
            try {
                String string4 = stringArray[n].substring(0, 7).toLowerCase();
                if (!string4.equals("iiop://")) {
                    exception = new BAD_PARAM("resolve_initial_references_remote() - Syntax of modifierList - Only iiop is currently supported", 1229124128, CompletionStatus.COMPLETED_NO);
                } else {
                    string2 = stringArray[n].substring(7);
                    int n3 = string2.indexOf(":");
                    if (n3 < 0) {
                        string3 = string2;
                        n2 = this.orb.getBootstrapPort();
                    } else if (n3 == 0) {
                        string3 = this.orb.getBootstrapHost();
                        n2 = Integer.parseInt(string2.substring(1));
                    } else {
                        string3 = string2.substring(0, n3);
                        n2 = Integer.parseInt(string2.substring(n3 + 1));
                    }
                    object = this.resolve_initial_references(string, string3, n2);
                    if (object != null) {
                        break;
                    }
                }
            }
            catch (Exception exception2) {
                ORBRas.orbTrcLogger.exception(4104L, this, "resolve_initial_references_remote:439", exception2);
                exception = exception2;
            }
            ++n;
        }
        if (object != null) {
            return object;
        }
        if (exception == null) {
            return null;
        }
        if (exception instanceof InvalidName) {
            throw (InvalidName)exception;
        }
        if (exception instanceof SystemException) {
            throw (SystemException)exception;
        }
        return null;
    }

    String[] list_initial_services_remote(String[] stringArray) {
        String string = null;
        String[] stringArray2 = null;
        Exception exception = null;
        int n = 0;
        while (n < stringArray.length) {
            String string2 = null;
            int n2 = 0;
            try {
                String string3 = stringArray[n].substring(0, 7).toLowerCase();
                if (!string3.equals("iiop://")) {
                    exception = new BAD_PARAM("list_initial_services_remote() - Syntax of modifierList - Only iiop is currently supported", 1229126547, CompletionStatus.COMPLETED_NO);
                } else {
                    string = stringArray[n].substring(7);
                    int n3 = string.indexOf(":");
                    if (n3 < 0) {
                        string2 = string;
                        n2 = this.orb.getBootstrapPort();
                    } else if (n3 == 0) {
                        string2 = this.orb.getBootstrapHost();
                        n2 = Integer.parseInt(string.substring(1));
                    } else {
                        string2 = string.substring(0, n3);
                        n2 = Integer.parseInt(string.substring(n3 + 1));
                    }
                    stringArray2 = this.getInitialServices(string2, n2);
                    if (stringArray2 != null) {
                        break;
                    }
                }
            }
            catch (Exception exception2) {
                ORBRas.orbTrcLogger.exception(4104L, this, "list_initial_services_remote:534", exception2);
                exception = exception2;
            }
            ++n;
        }
        if (stringArray2 != null) {
            return stringArray2;
        }
        if (exception instanceof SystemException) {
            throw (SystemException)exception;
        }
        return null;
    }
}

