/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.corba;

import com.ibm.CORBA.iiop.UserKey;
import com.ibm.rmi.corba.Element;
import com.ibm.rmi.corba.ObjectManagerInterface;
import com.ibm.rmi.corba.UserKeyImpl;
import com.ibm.rmi.util.Utility;

public final class TransientObjectManager
implements ObjectManagerInterface {
    private int maxSize = 128;
    private Element[] elementArray = new Element[this.maxSize];
    private Element freeList;

    public TransientObjectManager() {
        this.elementArray[this.maxSize - 1] = new Element(this.maxSize - 1, null);
        int n = this.maxSize - 2;
        while (n >= 0) {
            this.elementArray[n] = new Element(n, this.elementArray[n + 1]);
            --n;
        }
        this.freeList = this.elementArray[0];
    }

    public synchronized UserKey storeServant(Object object) {
        if (this.freeList == null) {
            this.doubleSize();
        }
        Element element = this.freeList;
        this.freeList = (Element)this.freeList.servant;
        return new UserKeyImpl(element.getKey(object));
    }

    public synchronized Object lookupServant(UserKey userKey) {
        byte[] byArray = userKey.getBytes();
        int n = Utility.bytesToInt(byArray, 0);
        int n2 = Utility.bytesToInt(byArray, 4);
        if (this.elementArray[n].counter == n2 && this.elementArray[n].valid) {
            return this.elementArray[n].servant;
        }
        return null;
    }

    public synchronized void deleteServant(UserKey userKey) {
        byte[] byArray = userKey.getBytes();
        int n = Utility.bytesToInt(byArray, 0);
        this.freeList = this.elementArray[n].delete(this.freeList);
    }

    public synchronized UserKey getKey(Object object) {
        int n = 0;
        while (n < this.maxSize) {
            if (this.elementArray[n].valid && this.elementArray[n].servant == object) {
                return new UserKeyImpl(this.elementArray[n].toBytes());
            }
            ++n;
        }
        return null;
    }

    public Object preinvoke(Object object, String string) {
        return null;
    }

    public void postinvoke(Object object) {
    }

    private void doubleSize() {
        Element[] elementArray = this.elementArray;
        int n = this.maxSize;
        this.maxSize *= 2;
        this.elementArray = new Element[this.maxSize];
        int n2 = 0;
        while (n2 < n) {
            this.elementArray[n2] = elementArray[n2];
            ++n2;
        }
        this.elementArray[this.maxSize - 1] = new Element(this.maxSize - 1, null);
        int n3 = this.maxSize - 2;
        while (n3 >= n) {
            this.elementArray[n3] = new Element(n3, this.elementArray[n3 + 1]);
            --n3;
        }
        this.freeList = this.elementArray[n];
    }
}

