/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.iiop;

import com.ibm.CORBA.iiop.CDROutputStream;
import com.ibm.CORBA.iiop.LSDPlugin;
import com.ibm.CORBA.iiop.LSDPlugin_02;
import com.ibm.CORBA.iiop.ORBConnection;
import com.ibm.CORBA.iiop.PMIPlugin;
import com.ibm.CORBA.ras.ORBRas;
import com.ibm.CORBA.transport.TransportConnection;
import com.ibm.org.omg.CORBA.ValueDefPackage.FullValueDescription;
import com.ibm.org.omg.SendingContext.CodeBase;
import com.ibm.org.omg.SendingContext.CodeBaseHelper;
import com.ibm.rmi.IOR;
import com.ibm.rmi.RequestHandler;
import com.ibm.rmi.ServerGIOP;
import com.ibm.rmi.iiop.CDRConnection;
import com.ibm.rmi.iiop.CDRInputStream;
import com.ibm.rmi.iiop.CancelRequestException;
import com.ibm.rmi.iiop.ClientResponseImpl;
import com.ibm.rmi.iiop.FVDCodeBaseDelegate;
import com.ibm.rmi.iiop.GIOPVersionException;
import com.ibm.rmi.iiop.IIOPInputStream;
import com.ibm.rmi.iiop.IIOPOutputStream;
import com.ibm.rmi.iiop.LocateReplyMessage;
import com.ibm.rmi.iiop.LocateRequestMessage;
import com.ibm.rmi.iiop.Message;
import com.ibm.rmi.iiop.MessageErrorMessage;
import com.ibm.rmi.iiop.ORB;
import com.ibm.rmi.iiop.OutCallDesc;
import com.ibm.rmi.iiop.ReplyMessage;
import com.ibm.rmi.iiop.RequestMessage;
import com.ibm.rmi.iiop.ServerRequestImpl;
import com.ibm.rmi.iiop.ServerResponseImpl;
import com.ibm.rmi.iiop.WorkUnitImpl;
import com.ibm.rmi.util.Condition;
import com.ibm.rmi.util.Lock;
import com.ibm.rmi.util.PartnerVersion;
import com.ibm.rmi.util.Utility;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_RESPONSE;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;
import org.omg.CORBA.UNKNOWN;

public class Connection
implements CDRConnection,
PartnerVersion,
ORBConnection {
    private static final int OPENING = 1;
    private static final int ESTABLISHED = 2;
    private static final int CLOSE_SENT = 3;
    private static final int CLOSE_RECVD = 4;
    private static final int ABORT = 5;
    private static final int FAILING = 6;
    private static final int CLOSED = 7;
    private static final java.lang.Object END_FRAG = new java.lang.Object();
    private static final java.lang.Object CANCEL_REQUEST = new java.lang.Object();
    public static final int CONN_ABORT = 1;
    public static final int CONN_REBIND = 2;
    private static long globalTimeCounter = 0L;
    protected boolean debug = false;
    protected ORB orb;
    protected long timeStamp = 0L;
    protected boolean isServer = false;
    protected Hashtable fragments;
    private Hashtable out_calls = new Hashtable();
    protected int requestCount = 0;
    protected ServerGIOP server;
    private byte GIOPMajor = 1;
    private byte GIOPMinor = 0;
    private boolean firstMessage = true;
    private boolean newConnection = true;
    private Hashtable implementations = null;
    private Hashtable fvds = null;
    private Hashtable bases = null;
    private CodeBase codeBaseRef;
    private boolean postInitialRequestContexts = false;
    private boolean postInitialReplyContexts = false;
    private int tcsChar = 0;
    private int tcsWChar = 0;
    private com.ibm.CORBA.iiop.IOR codeBaseServerIOR = null;
    private FVDCodeBaseDelegate cbDelegate;
    private String connectionString = null;
    int state;
    private Condition event;
    private Lock lock;
    private boolean writeLocked;
    protected InputStream inputStream;
    protected OutputStream outputStream;
    protected boolean versionIdSent = false;
    byte[] buf;
    private int startMsgOffset = 0;
    private int endDataOffset = 0;
    private int bytesAlreadyRead = 0;
    private int bufferSize = 2048;
    private int halfBufferSize = this.bufferSize / 2;
    private int fragTimeout = 0;
    private TransportConnection transportConnection = null;
    private PMIPlugin pmiServer;
    private LSDPlugin lsdPlugin;
    private short addressingDisposition = 0;
    private short partnerMajor = 0;
    private short partnerMinor = 0;
    private short partnerExtended;
    private static Hashtable cbs = new Hashtable();
    static /* synthetic */ Class class$com$ibm$rmi$iiop$Connection;

    public Connection() {
        this.updateTimeStamp();
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public void dprint(String string) {
        Utility.dprint(this, string);
    }

    public ORB getORB() {
        return this.orb;
    }

    public com.ibm.CORBA.iiop.IOR locate(int n, com.ibm.CORBA.iiop.IOR iOR, byte by, byte by2, short s) {
        int n2 = 0;
        return this._locate(n, iOR, by, by2, s, n2);
    }

    private com.ibm.CORBA.iiop.IOR _locate(int n, com.ibm.CORBA.iiop.IOR iOR, byte by, byte by2, short s, int n2) {
        LocateRequestMessage locateRequestMessage = new LocateRequestMessage(n, iOR, by, by2, s);
        IIOPOutputStream iIOPOutputStream = (IIOPOutputStream)this.orb.newOutputStream(this, by, by2);
        locateRequestMessage.write(iIOPOutputStream);
        iIOPOutputStream.setMessage(locateRequestMessage);
        IIOPInputStream iIOPInputStream = this.send(iIOPOutputStream, false);
        LocateReplyMessage locateReplyMessage = (LocateReplyMessage)iIOPInputStream.getMessage();
        switch (locateReplyMessage.getLocateReplyStatus()) {
            case 0: {
                throw new OBJECT_NOT_EXIST("Received LocateReply.UNKNOWN_OBJECT", 1229126657, CompletionStatus.COMPLETED_NO);
            }
            case 1: {
                return null;
            }
            case 2: {
                IOR iOR2 = new IOR(this.orb);
                iOR2.read(iIOPInputStream);
                return iOR2;
            }
            case 4: {
                throw locateReplyMessage.getSystemException();
            }
            case 5: {
                s = locateReplyMessage.getAddressingDisposition();
                if (n2 > 0) {
                    throw new INTERNAL("LocateReplyLocNeedsAddressingMode received twice", 1229125049, CompletionStatus.COMPLETED_NO);
                }
                return this._locate(n, iOR, by, by2, s, ++n2);
            }
        }
        throw new INTERNAL("Unknown LocateReply status: " + locateReplyMessage.getLocateReplyStatus(), 1229124997, CompletionStatus.COMPLETED_NO);
    }

    public void updateTimeStamp() {
        Class clazz = class$com$ibm$rmi$iiop$Connection == null ? (class$com$ibm$rmi$iiop$Connection = Connection.class$("com.ibm.rmi.iiop.Connection")) : class$com$ibm$rmi$iiop$Connection;
        synchronized (clazz) {
            this.timeStamp = globalTimeCounter++;
        }
    }

    public boolean isMoreStaleThan(ORBConnection oRBConnection) {
        if (oRBConnection == null) {
            return true;
        }
        return this.timeStamp < ((Connection)oRBConnection).timeStamp;
    }

    public int localPort() {
        return this.transportConnection.getLocalPort();
    }

    public String localHost() {
        return this.transportConnection.getLocalHostName();
    }

    public void pmiInit() {
        if (this.orb != null) {
            this.pmiServer = this.orb.getPMIServer();
        }
    }

    public void lsdInit() {
        if (this.orb != null) {
            this.lsdPlugin = (LSDPlugin)this.orb.getPlugin("com.ibm.CORBA.iiop.LSDPlugin");
        }
    }

    public Connection(ORB oRB, ServerGIOP serverGIOP, boolean bl) {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4132L, this, "<init>:504");
        }
        this.orb = (com.ibm.CORBA.iiop.ORB)oRB;
        this.server = serverGIOP;
        this.fragments = new Hashtable();
        this.bufferSize = oRB.getBufferSize();
        this.halfBufferSize = this.bufferSize / 2;
        this.buf = new byte[this.bufferSize];
        this.fragTimeout = oRB.getFragmentTimeout();
        this.addressingDisposition = oRB.getAddressingDisposition();
        if (bl) {
            this.isServer = true;
        }
        this.state = 1;
        this.event = new Condition();
        this.lock = new Lock();
        this.pmiInit();
        this.lsdInit();
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "<init>:539");
        }
    }

    public synchronized void setPartnerVersion(short s, short s2) {
        if (this.partnerMajor == 0) {
            this.partnerMajor = s;
            this.partnerMinor = s2;
        } else if ((this.partnerMajor != s || this.partnerMinor != s2) && ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(4112L, this, "Connection.setPartnerVersion:557", "PartnerVersion conflict: partnerMajor=" + this.partnerMajor + " partnerMinor=" + this.partnerMinor + " major=" + s + " minor=" + s2);
        }
    }

    public synchronized void setPartnerExtended(short s) {
        this.partnerExtended = s;
    }

    public synchronized short getPartnerMajor() {
        return this.partnerMajor;
    }

    public synchronized short getPartnerMinor() {
        return this.partnerMinor;
    }

    public synchronized short getPartnerExtended() {
        return this.partnerExtended;
    }

    public synchronized void setAddressingDisposition(short s) {
        this.addressingDisposition = s;
    }

    public synchronized short getAddressingDisposition() {
        return this.addressingDisposition;
    }

    public synchronized boolean isPostInitialRequestContexts() {
        return this.postInitialRequestContexts;
    }

    public synchronized boolean isPostInitialReplyContexts() {
        return this.postInitialReplyContexts;
    }

    public synchronized void setPostInitialRequestContexts() {
        this.postInitialRequestContexts = true;
    }

    public synchronized void setPostInitialReplyContexts() {
        this.postInitialReplyContexts = true;
    }

    public synchronized void setCodeBaseRef(com.ibm.CORBA.iiop.IOR iOR) {
        this.codeBaseServerIOR = iOR;
    }

    public synchronized com.ibm.CORBA.iiop.IOR getCodeBaseRef() {
        return this.codeBaseServerIOR;
    }

    public synchronized void setCodeSets(int n, int n2) {
        this.tcsChar = n;
        this.tcsWChar = n2;
    }

    public synchronized int getCharCodeSet() {
        return this.tcsChar;
    }

    public synchronized int getWCharCodeSet() {
        return this.tcsWChar;
    }

    public CodeBase getFVDCodeBase() {
        if (this.cbDelegate == null) {
            this.cbDelegate = new FVDCodeBaseDelegate(this);
        }
        return this.cbDelegate;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public ServerGIOP getServerGIOP() {
        return this.server;
    }

    public boolean isVersionIdSent() {
        return this.versionIdSent;
    }

    public void setVersionIdSent() {
        this.versionIdSent = true;
    }

    public IIOPInputStream createInputStream() throws Exception {
        java.lang.Object object;
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, this, "createInputStream:720");
        }
        this.bytesAlreadyRead = this.endDataOffset - this.startMsgOffset;
        IIOPInputStream iIOPInputStream = null;
        byte[] byArray = null;
        if (this.bytesAlreadyRead < 12) {
            if ((double)this.endDataOffset > 0.8 * (double)this.halfBufferSize) {
                object = this.buf;
                this.buf = new byte[this.bufferSize];
                System.arraycopy(object, this.startMsgOffset, this.buf, 0, this.bytesAlreadyRead);
                this.startMsgOffset = 0;
                this.endDataOffset = this.bytesAlreadyRead;
            }
            this.readMoreData(this.buf, this.endDataOffset, 12 - this.bytesAlreadyRead, this.halfBufferSize - this.endDataOffset);
        }
        try {
            object = Message.createMessage(this.buf, this.startMsgOffset);
        }
        catch (GIOPVersionException gIOPVersionException) {
            IIOPOutputStream iIOPOutputStream = new IIOPOutputStream(this.orb, this);
            MessageErrorMessage messageErrorMessage = new MessageErrorMessage(1, 2);
            iIOPOutputStream.setMessage(messageErrorMessage);
            this.send(iIOPOutputStream, true);
            throw gIOPVersionException;
        }
        int n = ((Message)object).getSize();
        if (this.firstMessage) {
            this.GIOPMajor = ((Message)object).getGIOPMajor();
            this.GIOPMinor = ((Message)object).getGIOPMinor();
            this.firstMessage = false;
        }
        if (this.startMsgOffset + n > this.buf.length) {
            byArray = new byte[n];
            System.arraycopy(this.buf, this.startMsgOffset, byArray, 0, this.bytesAlreadyRead);
        }
        if (n > this.bytesAlreadyRead) {
            if (byArray == null) {
                int n2 = (double)(this.startMsgOffset + n) > 0.8 * (double)this.halfBufferSize ? n - this.bytesAlreadyRead : this.halfBufferSize - this.endDataOffset;
                this.readMoreData(this.buf, this.endDataOffset, n - this.bytesAlreadyRead, n2);
            } else {
                this.readMoreData(byArray, this.bytesAlreadyRead, n - this.bytesAlreadyRead, n - this.bytesAlreadyRead);
            }
        }
        if (byArray == null) {
            iIOPInputStream = this.createStreamObject(this.buf, this.startMsgOffset, (Message)object);
            this.startMsgOffset += n;
        } else {
            iIOPInputStream = this.createStreamObject(byArray, 0, (Message)object);
            this.endDataOffset = this.startMsgOffset;
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "createInputStream:817");
        }
        return iIOPInputStream;
    }

    private IIOPInputStream createStreamObject(byte[] byArray, int n, Message message) throws Exception {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, this, "createStreamObject:832");
        }
        switch (message.getType()) {
            case 0: {
                ((RequestMessage)message).setOrb((com.ibm.CORBA.iiop.ORB)this.orb);
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.exit(4100L, this, "createStreamObject:844");
                }
                return new ServerRequestImpl(this, byArray, (RequestMessage)message, n);
            }
            case 1: {
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.exit(4100L, this, "createStreamObject:855");
                }
                return new ClientResponseImpl(this, byArray, (ReplyMessage)message, n);
            }
            case 3: {
                ((LocateRequestMessage)message).setOrb((com.ibm.CORBA.iiop.ORB)this.orb);
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.exit(4100L, this, "createStreamObject:874");
                }
                return new IIOPInputStream(this, byArray, message, n);
            }
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "createStreamObject:885");
        }
        throw new INTERNAL("Bad GIOP request" + message.getType(), 1229125000, CompletionStatus.COMPLETED_NO);
    }

    private void readMoreData(byte[] byArray, int n, int n2, int n3) throws IOException {
        int n4 = 0;
        int n5 = 0;
        while (n5 < n3) {
            int n6 = 0;
            while (true) {
                try {
                    n4 = this.inputStream.read(byArray, n + n5, n3 - n5);
                }
                catch (SocketException socketException) {
                    if (n6++ < 5) continue;
                    throw socketException;
                }
                break;
            }
            if (n4 < 0) {
                throw new IOException("bytesRead < 0");
            }
            if ((n5 += n4) >= n2) break;
        }
        if (byArray == this.buf) {
            this.endDataOffset += n5;
            this.bytesAlreadyRead += n5;
        }
    }

    void processInput(IIOPInputStream iIOPInputStream) {
        LinkedList linkedList;
        boolean bl = false;
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, this, "processInput:951");
        }
        Message message = (Message)iIOPInputStream.getMessage();
        int n = message.getType();
        Integer n2 = new Integer(message.getRequestId());
        if (n != 7 && message.isFragmentToFollow()) {
            linkedList = new LinkedList();
            this.fragments.put(n2, linkedList);
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(4112L, this, "processInput:972", "messageType=" + message.getTypeName());
        }
        switch (n) {
            case 0: 
            case 3: {
                if (this.debug) {
                    this.dprint("Connection:processInput: got incoming request");
                }
                WorkUnitImpl workUnitImpl = new WorkUnitImpl(this.server.getRequestHandler(), this, iIOPInputStream);
                this.orb.getThreadPool().startWorkerThread(workUnitImpl);
                break;
            }
            case 1: {
                bl = ((ReplyMessage)message).needsReAddressing();
            }
            case 4: {
                OutCallDesc outCallDesc;
                if (this.debug) {
                    this.dprint("Connection:processInput: got RESPONSE");
                }
                if ((outCallDesc = (OutCallDesc)this.out_calls.get(n2)) != null && !outCallDesc.alreadyReceived()) {
                    outCallDesc.setReceived(true);
                    this.lock.lock();
                    outCallDesc.complete(iIOPInputStream);
                    this.lock.unlock();
                    break;
                }
                linkedList = (LinkedList)this.fragments.get(n2);
                if (linkedList == null) break;
                LinkedList linkedList2 = linkedList;
                synchronized (linkedList2) {
                    LocateReplyMessage locateReplyMessage;
                    if (n == 1) {
                        ReplyMessage replyMessage = (ReplyMessage)message;
                        if (replyMessage.getReplyStatus() == 2) {
                            linkedList.addFirst(replyMessage.getSystemException());
                        } else if (replyMessage.getReplyStatus() == 1) {
                            linkedList.addFirst(replyMessage.getExceptionId());
                        }
                    } else if (n == 4 && (locateReplyMessage = (LocateReplyMessage)message).getLocateReplyStatus() == 4) {
                        linkedList.addFirst(locateReplyMessage.getSystemException());
                    }
                    linkedList.notify();
                    break;
                }
            }
            case 2: {
                if (this.debug) {
                    this.dprint("Connection:processInput: got cancel");
                }
                if ((linkedList = (LinkedList)this.fragments.get(n2)) == null) break;
                LinkedList linkedList3 = linkedList;
                synchronized (linkedList3) {
                    linkedList.addFirst(CANCEL_REQUEST);
                    linkedList.notify();
                    break;
                }
            }
            case 5: {
                if (this.debug) {
                    this.dprint("Connection.processInput: got CloseConn, purging");
                }
                this.purge_calls(2, true, false);
                break;
            }
            case 7: {
                linkedList = (LinkedList)this.fragments.get(n2);
                if (linkedList == null) {
                    linkedList = new LinkedList();
                    this.fragments.put(n2, linkedList);
                }
                LinkedList linkedList4 = linkedList;
                synchronized (linkedList4) {
                    linkedList.add(iIOPInputStream);
                    if (!message.isFragmentToFollow()) {
                        linkedList.add(END_FRAG);
                    }
                    linkedList.notify();
                    break;
                }
            }
            default: {
                if (this.debug) {
                    this.dprint("Connection: bad message type " + String.valueOf(n));
                }
                this.purge_calls(1, true, false);
            }
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "processInput:1103");
        }
    }

    void purge_calls(int n, boolean bl, boolean bl2) {
        int n2;
        CompletionStatus completionStatus;
        block17: {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.entry(4100L, (java.lang.Object)this, "purge_calls:1121", (java.lang.Object)("reason=" + n + " die=" + bl + " lockHeld=" + bl2 + " connection state is " + this.state));
            }
            if (this.debug) {
                this.dprint("purge_calls: starting: code = " + n + " die = " + bl);
            }
            try {
                if (!bl2) {
                    this.writeLock(false);
                }
            }
            catch (SystemException systemException) {
                if (!ORBRas.isTrcLogging) break block17;
                ORBRas.orbTrcLogger.trace(8208L, this, "purge_calls:1146", systemException.toString());
            }
        }
        if (this.state == 5 || this.state == 4 || this.state == 7) {
            if (this.state != 7) {
                this.lock.lock();
                this.state = 7;
                this.lock.unlock();
            }
            this.writeUnlock();
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.exit(4100L, this, "purge_calls:1170");
            }
            return;
        }
        this.lock.lock();
        if (n == 2) {
            this.state = 4;
            completionStatus = CompletionStatus.COMPLETED_NO;
            n2 = 1229124357;
        } else {
            this.state = 5;
            completionStatus = CompletionStatus.COMPLETED_MAYBE;
            n2 = 1229124358;
        }
        this.lock.unlock();
        COMM_FAILURE cOMM_FAILURE = new COMM_FAILURE("purge_calls:1197reason=" + n + " state=" + this.state, n2, completionStatus);
        Enumeration enumeration = this.out_calls.elements();
        while (enumeration.hasMoreElements()) {
            OutCallDesc outCallDesc = (OutCallDesc)enumeration.nextElement();
            this.lock.lock();
            outCallDesc.exception(cOMM_FAILURE);
            this.lock.unlock();
        }
        Enumeration enumeration2 = this.fragments.elements();
        while (enumeration2.hasMoreElements()) {
            LinkedList linkedList;
            LinkedList linkedList2 = linkedList = (LinkedList)enumeration2.nextElement();
            synchronized (linkedList2) {
                linkedList.addFirst(cOMM_FAILURE);
                linkedList.notify();
            }
        }
        this.out_calls.clear();
        if (this.transportConnection != null) {
            this.transportConnection.removeConnection();
            this.transportConnection = null;
        }
        this.lock.lock();
        this.state = 7;
        this.lock.unlock();
        this.writeUnlock();
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "purge_calls:1261");
        }
    }

    public void setStreams(InputStream inputStream, OutputStream outputStream, TransportConnection transportConnection) {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(4112L, this, "setStreams:1288", "setting streams into " + this + " TransportConnection's connection parameters are:" + transportConnection.getConnectionParameterString());
        }
        this.inputStream = inputStream;
        this.outputStream = outputStream;
        this.transportConnection = transportConnection;
        this.lock.lock();
        this.state = 2;
        this.event.signalAll();
        this.lock.unlock();
    }

    public void abortConnection() {
        this.lock.lock();
        this.state = 5;
        this.event.signalAll();
        this.lock.unlock();
    }

    private boolean writeLock(boolean bl) {
        this.lock.lock();
        block6: while (true) {
            switch (this.state) {
                case 1: 
                case 3: {
                    this.event.wait(this.lock);
                    continue block6;
                }
                case 2: {
                    if (!this.writeLocked) {
                        this.writeLocked = true;
                        this.lock.unlock();
                        return true;
                    }
                    this.event.wait(this.lock);
                    continue block6;
                }
                case 4: 
                case 6: {
                    if (bl) {
                        this.event.wait(this.lock);
                        continue block6;
                    }
                }
                case 5: 
                case 7: {
                    this.lock.unlock();
                    throw new COMM_FAILURE("Connection state: " + this.state, 1229124360, CompletionStatus.COMPLETED_NO);
                }
            }
            break;
        }
        if (this.debug) {
            this.dprint("Connection:writeLock: weird state");
        }
        this.lock.unlock();
        this.delete(1);
        return false;
    }

    private void writeUnlock() {
        this.lock.lock();
        this.writeLocked = false;
        if (this.state == 2) {
            this.event.signal();
        } else {
            this.event.signalAll();
        }
        this.lock.unlock();
    }

    public void delete() {
        this.delete(1);
    }

    void delete(int n) {
        if (this.transportConnection != null) {
            this.transportConnection.removeConnection();
            this.transportConnection = null;
        }
    }

    public IIOPInputStream invoke(IIOPOutputStream iIOPOutputStream) throws SystemException {
        return this.send(iIOPOutputStream, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IIOPInputStream send(IIOPOutputStream iIOPOutputStream, boolean bl) {
        IIOPInputStream iIOPInputStream;
        int n;
        block25: {
            IIOPInputStream iIOPInputStream2;
            boolean bl2;
            block23: {
                OutCallDesc outCallDesc = null;
                bl2 = false;
                this.newConnection = false;
                Message message = (Message)iIOPOutputStream.getMessage();
                n = message.getRequestId();
                int n2 = message.getType();
                SystemException systemException = null;
                iIOPInputStream = null;
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.entry(8196L, (java.lang.Object)this, "send:1467", (java.lang.Object)("reqID=" + n + " type=" + message.getTypeName()));
                }
                try {
                    if (n2 == 7) {
                        outCallDesc = (OutCallDesc)this.out_calls.get(new Integer(n));
                    } else {
                        outCallDesc = new OutCallDesc();
                        this.out_calls.put(new Integer(n), outCallDesc);
                    }
                    this.writeLock(true);
                    bl2 = true;
                    try {
                        iIOPOutputStream.writeTo(this.outputStream);
                        iIOPOutputStream.lastFragSent();
                        this.outputStream.flush();
                    }
                    catch (IOException iOException) {
                        ORBRas.orbTrcLogger.exception(4104L, this, "send:1491", (Exception)iOException);
                        this.lock.lock();
                        this.state = 6;
                        this.lock.unlock();
                        throw new COMM_FAILURE(iOException.getMessage(), 1229124368, CompletionStatus.COMPLETED_NO);
                    }
                    this.writeUnlock();
                    bl2 = false;
                    if (bl) {
                        if (ORBRas.isTrcLogging) {
                            ORBRas.orbTrcLogger.exit(8196L, this, "send:1508", (java.lang.Object)("reqID=" + n + ":one-way"));
                        }
                        iIOPInputStream2 = null;
                        java.lang.Object var18_14 = null;
                        this.out_calls.remove(new Integer(n));
                        break block23;
                    }
                    this.lock.lock();
                    int n3 = 0;
                    n3 = iIOPOutputStream.getMessage() instanceof LocateRequestMessage ? this.orb.getLocateRequestTimeout() : this.orb.getRequestTimeout();
                    if (0 == n3) {
                        while ((iIOPInputStream = outCallDesc.getStream()) == null && (systemException = outCallDesc.getException()) == null) {
                            outCallDesc.wait(this.lock);
                        }
                    } else {
                        long l = System.currentTimeMillis() + (long)n3;
                        long l2 = n3;
                        while ((iIOPInputStream = outCallDesc.getStream()) == null && (systemException = outCallDesc.getException()) == null) {
                            block24: {
                                if (l2 <= 0L) {
                                    this.lock.unlock();
                                    throw new NO_RESPONSE("Response timed out", 1229126401, CompletionStatus.COMPLETED_MAYBE);
                                }
                                try {
                                    outCallDesc.wait(this.lock, (int)l2);
                                }
                                catch (InterruptedException interruptedException) {
                                    if (!ORBRas.isTrcLogging) break block24;
                                    ORBRas.orbTrcLogger.trace(8208L, this, "send:1557", "Timer interrupted");
                                }
                            }
                            l2 = l - System.currentTimeMillis();
                        }
                    }
                    this.lock.unlock();
                    if (systemException != null) {
                        ORBRas.orbTrcLogger.exception(4104L, this, "send:1573", (Exception)systemException);
                        throw systemException;
                    }
                    java.lang.Object var18_15 = null;
                    this.out_calls.remove(new Integer(n));
                    if (bl2) {
                        this.writeUnlock();
                    }
                    break block25;
                }
                catch (Throwable throwable) {
                    java.lang.Object var18_16 = null;
                    this.out_calls.remove(new Integer(n));
                    if (bl2) {
                        this.writeUnlock();
                    }
                    throw throwable;
                }
            }
            if (bl2) {
                this.writeUnlock();
            }
            return iIOPInputStream2;
        }
        Message message = (Message)iIOPInputStream.getMessage();
        if (message.isFragmentToFollow()) {
            message.read(iIOPInputStream);
            if (iIOPInputStream.isFirstFragment()) {
                iIOPInputStream.logCommTrace();
            }
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(8196L, this, "send:1599", (java.lang.Object)("reqID=" + n + " type=" + message.getTypeName()));
        }
        return iIOPInputStream;
    }

    public void sendFragment(IIOPOutputStream iIOPOutputStream, int n, int n2, boolean bl) throws Exception {
        boolean bl2 = false;
        this.newConnection = false;
        try {
            this.writeLock(true);
            bl2 = true;
            if (n2 == 2) {
                this.out_calls.remove(new Integer(n));
            } else if (n2 == 0 || n2 == 3) {
                OutCallDesc outCallDesc;
                if (!bl) {
                    outCallDesc = new OutCallDesc();
                    this.out_calls.put(new Integer(n), outCallDesc);
                    iIOPOutputStream.setCall(outCallDesc);
                } else {
                    outCallDesc = iIOPOutputStream.getCall();
                }
                SystemException systemException = outCallDesc.getException();
                if (systemException != null) {
                    ORBRas.orbTrcLogger.exception(4104L, this, "sendFragment:1643", (Exception)systemException);
                    if (bl2) {
                        this.writeUnlock();
                    }
                    throw systemException;
                }
            }
            iIOPOutputStream.writeTo(this.outputStream);
            this.outputStream.flush();
            this.writeUnlock();
            bl2 = false;
        }
        catch (Exception exception) {
            ORBRas.orbTrcLogger.exception(4104L, this, "sendFragment:1660", exception);
            if (bl2) {
                this.writeUnlock();
            }
            this.out_calls.remove(new Integer(n));
            throw exception;
        }
    }

    public void sendReply(CDROutputStream cDROutputStream) throws Exception {
        boolean bl = false;
        try {
            this.writeLock(true);
            bl = true;
            cDROutputStream.writeTo(this.outputStream);
            this.outputStream.flush();
            this.writeUnlock();
            bl = false;
        }
        catch (Exception exception) {
            ORBRas.orbTrcLogger.exception(4104L, this, "sendReply:1700", exception);
            if (bl) {
                this.writeUnlock();
            }
            throw exception;
        }
    }

    public CDRInputStream getNextFragment(int n, int n2) {
        LinkedList linkedList = null;
        long l = System.currentTimeMillis() + (long)this.fragTimeout;
        long l2 = this.fragTimeout;
        Integer n3 = new Integer(n);
        while (true) {
            if (this.fragments != null && linkedList == null && (linkedList = (LinkedList)this.fragments.get(n3)) == null) {
                throw new MARSHAL("Read beyond end of data. No fragments available.", 1229125825, CompletionStatus.COMPLETED_MAYBE);
            }
            LinkedList linkedList2 = linkedList;
            synchronized (linkedList2) {
                if (linkedList != null && !linkedList.isEmpty()) {
                    java.lang.Object object = linkedList.removeFirst();
                    if (object == CANCEL_REQUEST) {
                        this.fragments.remove(n3);
                        throw new CancelRequestException();
                    }
                    if (object instanceof SystemException) {
                        this.fragments.remove(n3);
                        throw (SystemException)object;
                    }
                    if (object instanceof String) {
                        this.fragments.remove(n3);
                        throw new UNKNOWN((String)object, 1229127326, CompletionStatus.COMPLETED_MAYBE);
                    }
                    if (linkedList.size() == 1 && linkedList.getFirst() == END_FRAG) {
                        this.fragments.remove(n3);
                    }
                    CDRInputStream cDRInputStream = (CDRInputStream)object;
                    return cDRInputStream;
                }
                try {
                    if (this.fragTimeout == 0) {
                        linkedList.wait();
                    } else {
                        if (l2 <= 0L) {
                            this.fragments.remove(n3);
                            throw new NO_RESPONSE("Fragment timed out", 1229126402, CompletionStatus.COMPLETED_NO);
                        }
                        linkedList.wait(l2);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                l2 = l - System.currentTimeMillis();
            }
        }
    }

    private static CodeBase getCodeBase(ORB oRB, com.ibm.CORBA.iiop.IOR iOR) {
        if (iOR == null) {
            throw new MARSHAL("No sending context", 1229125802, CompletionStatus.COMPLETED_NO);
        }
        CodeBase codeBase = (CodeBase)cbs.get(iOR);
        if (codeBase != null) {
            return codeBase;
        }
        Object object = oRB.string_to_object(iOR.stringify());
        codeBase = CodeBaseHelper.narrow(object);
        cbs.put(iOR, codeBase);
        return codeBase;
    }

    public String getImplementation(String string) {
        String string2 = null;
        if (this.implementations == null) {
            this.implementations = new Hashtable();
        } else {
            string2 = (String)this.implementations.get(string);
        }
        if (string2 == null) {
            if (this.codeBaseRef == null) {
                this.codeBaseRef = Connection.getCodeBase(this.orb, this.codeBaseServerIOR);
            }
            if ((string2 = this.codeBaseRef.implementation(string)) != null) {
                this.implementations.put(string, string2);
            }
        }
        return string2;
    }

    public FullValueDescription getFVD(String string) {
        FullValueDescription fullValueDescription = null;
        if (this.fvds == null) {
            this.fvds = new Hashtable();
        } else {
            fullValueDescription = (FullValueDescription)this.fvds.get(string);
        }
        if (fullValueDescription == null) {
            if (this.codeBaseRef == null) {
                this.codeBaseRef = Connection.getCodeBase(this.orb, this.codeBaseServerIOR);
            }
            if ((fullValueDescription = this.codeBaseRef.meta(string)) != null) {
                this.fvds.put(string, fullValueDescription);
            }
        }
        return fullValueDescription;
    }

    public String[] getBases(String string) {
        String[] stringArray = null;
        if (this.bases == null) {
            this.bases = new Hashtable();
        } else {
            stringArray = (String[])this.bases.get(string);
        }
        if (stringArray == null) {
            if (this.codeBaseRef == null) {
                this.codeBaseRef = Connection.getCodeBase(this.orb, this.codeBaseServerIOR);
            }
            if ((stringArray = this.codeBaseRef.bases(string)) != null) {
                this.bases.put(string, stringArray);
            }
        }
        return stringArray;
    }

    private void sendCloseConnection() {
        Message message = new Message(this.GIOPMajor, this.GIOPMinor);
        message.setType(5);
        IIOPOutputStream iIOPOutputStream = (IIOPOutputStream)this.orb.newOutputStream(this, this.GIOPMajor, this.GIOPMinor);
        message.write(iIOPOutputStream);
        iIOPOutputStream.setMessage(message);
        try {
            iIOPOutputStream.writeTo(this.outputStream);
            this.outputStream.flush();
        }
        catch (IOException iOException) {
            ORBRas.orbTrcLogger.exception(4104L, this, "sendCloseConnection:1898", (Exception)iOException);
        }
    }

    public boolean isBusy() {
        return this.requestCount > 0 || this.out_calls.size() > 0 || this.newConnection;
    }

    public synchronized void cleanUp() throws Exception {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(4112L, this, "cleanUp:1935", "cleaning up " + this);
        }
        this.writeLock(true);
        if (this.requestCount > 0 || this.out_calls.size() > 0) {
            this.writeUnlock();
            throw new Exception();
        }
        try {
            if (this.isServer) {
                this.sendCloseConnection();
                this.lock.lock();
                this.state = 3;
                this.lock.unlock();
            }
            this.transportConnection.removeConnection();
            this.transportConnection = null;
            this.purge_calls(2, false, true);
        }
        catch (Exception exception) {
            ORBRas.orbTrcLogger.exception(4104L, this, "cleanUp:1969", exception);
        }
    }

    public synchronized void requestBegins() {
        if (this.pmiServer != null) {
            this.pmiServer.newRequest();
        }
        ++this.requestCount;
    }

    public synchronized void requestEnds() {
        if (this.pmiServer != null) {
            this.pmiServer.requestCompleted();
        }
        --this.requestCount;
    }

    public boolean isClosed() {
        boolean bl;
        try {
            this.writeLock(true);
            this.writeUnlock();
            bl = false;
        }
        catch (Exception exception) {
            ORBRas.orbTrcLogger.exception(4104L, this, "isClosed:2025", exception);
            bl = true;
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doWork(RequestHandler requestHandler, IIOPInputStream iIOPInputStream) {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, (java.lang.Object)this, "doWork:2054", (java.lang.Object)this.getConnectionString());
        }
        IIOPOutputStream iIOPOutputStream = null;
        Message message = (Message)iIOPInputStream.getMessage();
        if (message.getType() == 7 || message.isFragmentToFollow()) {
            try {
                message.read(iIOPInputStream);
                if (iIOPInputStream.isFirstFragment()) {
                    iIOPInputStream.logCommTrace();
                }
            }
            catch (CancelRequestException cancelRequestException) {
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(4112L, this, "doWork:2076", "REQUEST CANCELLED");
                }
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.exit(4100L, this, "doWork:2083");
                }
                return;
            }
        }
        this.requestBegins();
        this.newConnection = false;
        if (this.isClosed()) {
            this.requestEnds();
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.exit(4100L, this, "doWork:2103");
            }
            return;
        }
        switch (message.getType()) {
            case 0: {
                ServerRequestImpl serverRequestImpl = (ServerRequestImpl)iIOPInputStream;
                serverRequestImpl.runInterceptors();
                if (((RequestMessage)message).needsReAddressing()) {
                    iIOPOutputStream = (IIOPOutputStream)((java.lang.Object)serverRequestImpl.createNeedsAddressingMode(this.addressingDisposition));
                    break;
                }
                try {
                    com.ibm.CORBA.iiop.IOR iOR;
                    if (this.lsdPlugin == null || (iOR = this.lsdPlugin instanceof LSDPlugin_02 ? ((LSDPlugin_02)((java.lang.Object)this.lsdPlugin)).getDirectIOR(((RequestMessage)message).getObjectKeyObject(), this.transportConnection.getRemoteHost(), this.transportConnection.getRemotePort()) : this.lsdPlugin.getDirectIOR(((RequestMessage)message).getObjectKeyObject().getBytes(), this.transportConnection.getRemoteHost(), this.transportConnection.getRemotePort())) == null) {
                        iIOPOutputStream = (IIOPOutputStream)((java.lang.Object)requestHandler.process(serverRequestImpl));
                        if (!serverRequestImpl.isOneWay()) break;
                        this.requestEnds();
                        if (ORBRas.isTrcLogging) {
                            ORBRas.orbTrcLogger.exit(4100L, this, "doWork:2173");
                        }
                        return;
                    }
                    ReplyMessage replyMessage = new ReplyMessage(null, message.getRequestId(), 3, message.getGIOPMajor(), message.getGIOPMinor());
                    iIOPOutputStream = new ServerResponseImpl(serverRequestImpl, replyMessage, iOR, true);
                    break;
                }
                catch (CancelRequestException cancelRequestException) {
                    serverRequestImpl.createDummyExceptionResponse(new TRANSIENT("Request Cancelled", 1330446339, CompletionStatus.COMPLETED_NO));
                    this.requestEnds();
                    if (ORBRas.isTrcLogging) {
                        ORBRas.orbTrcLogger.exit(4100L, this, "doWork:2195", (java.lang.Object)"REQUEST CANCELLED");
                    }
                    return;
                }
                catch (SystemException systemException) {
                    ORBRas.orbTrcLogger.exception(4104L, this, "doWork:2206", (Exception)systemException);
                    try {
                        iIOPOutputStream = (IIOPOutputStream)((java.lang.Object)serverRequestImpl.createSystemExceptionResponse(systemException));
                        break;
                    }
                    catch (Exception exception) {
                        ORBRas.orbTrcLogger.exception(4104L, this, "doWork:2216", exception);
                        this.requestEnds();
                        return;
                    }
                }
                catch (ThreadDeath threadDeath) {
                    throw threadDeath;
                }
                catch (Throwable throwable) {
                    ORBRas.orbTrcLogger.trace(4104L, (java.lang.Object)this, "doWork:2230", "Caught an unknown Throwable, marshal SystemException back to client", (java.lang.Object)throwable);
                    UNKNOWN uNKNOWN = new UNKNOWN(throwable.getMessage(), 1229127299, CompletionStatus.COMPLETED_MAYBE);
                    try {
                        iIOPOutputStream = (IIOPOutputStream)((java.lang.Object)serverRequestImpl.createSystemExceptionResponse(uNKNOWN));
                        break;
                    }
                    catch (Exception exception) {
                        ORBRas.orbTrcLogger.exception(4104L, this, "doWork:2249", exception);
                        this.requestEnds();
                        return;
                    }
                }
            }
            case 3: {
                iIOPOutputStream = this.doLocateRequestWork(requestHandler, iIOPInputStream, message);
                break;
            }
            case 2: {
                this.requestEnds();
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.exit(4100L, this, "doWork:2272");
                }
                return;
            }
            default: {
                this.requestEnds();
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.exit(4100L, this, "doWork:2287");
                }
                return;
            }
        }
        try {
            this.sendReply(iIOPOutputStream);
            this.requestEnds();
            iIOPOutputStream.releaseBuffer();
        }
        catch (Exception exception) {
            ORBRas.orbTrcLogger.exception(4104L, this, "doWork:2302", exception);
            this.requestEnds();
            iIOPOutputStream.releaseBuffer();
            return;
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "doWork:2313");
        }
    }

    private IIOPOutputStream doLocateRequestWork(RequestHandler requestHandler, IIOPInputStream iIOPInputStream, Message message) {
        LocateReplyMessage locateReplyMessage;
        IIOPOutputStream iIOPOutputStream = null;
        LocateRequestMessage locateRequestMessage = (LocateRequestMessage)message;
        int n = message.getRequestId();
        com.ibm.CORBA.iiop.IOR iOR = null;
        SystemException systemException = null;
        if (locateRequestMessage.needsReAddressing()) {
            locateReplyMessage = new LocateReplyMessage(n, 5, message.getGIOPMajor(), message.getGIOPMinor());
        } else {
            try {
                if (this.lsdPlugin != null) {
                    iOR = this.lsdPlugin instanceof LSDPlugin_02 ? ((LSDPlugin_02)((java.lang.Object)this.lsdPlugin)).getDirectIOR(locateRequestMessage.getObjectKeyObject(), this.transportConnection.getRemoteHost(), this.transportConnection.getRemotePort()) : this.lsdPlugin.getDirectIOR(locateRequestMessage.getObjectKeyObject().getBytes(), this.transportConnection.getRemoteHost(), this.transportConnection.getRemotePort());
                }
                if (iOR == null) {
                    iOR = requestHandler.locate(locateRequestMessage.getObjectKeyObject());
                }
                locateReplyMessage = iOR == null ? new LocateReplyMessage(n, 1, message.getGIOPMajor(), message.getGIOPMinor()) : new LocateReplyMessage(n, 2, message.getGIOPMajor(), message.getGIOPMinor());
            }
            catch (Exception exception) {
                ORBRas.orbTrcLogger.exception(4104L, this, "doLocateRequestWork:2384", exception);
                if (exception instanceof SystemException && !message.preGIOP12()) {
                    systemException = (SystemException)exception;
                    locateReplyMessage = new LocateReplyMessage(n, 4, message.getGIOPMajor(), message.getGIOPMinor());
                }
                locateReplyMessage = new LocateReplyMessage(n, 0, message.getGIOPMajor(), message.getGIOPMinor());
            }
        }
        iIOPOutputStream = new IIOPOutputStream(iIOPInputStream.getConnection().getORB(), iIOPInputStream.getConnection(), message.getGIOPMajor(), message.getGIOPMinor());
        locateReplyMessage.write(iIOPOutputStream);
        iIOPOutputStream.setMessage(locateReplyMessage);
        if (systemException != null) {
            Utility.writeSystemException(systemException, iIOPOutputStream);
        } else if (locateRequestMessage.needsReAddressing()) {
            iIOPOutputStream.write_short(this.addressingDisposition);
        } else if (iOR != null) {
            iOR.write(iIOPOutputStream);
        }
        return iIOPOutputStream;
    }

    public void doReaderWorkOnce() throws Exception {
        try {
            IIOPInputStream iIOPInputStream = null;
            try {
                iIOPInputStream = this.createInputStream();
            }
            catch (IOException iOException) {
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(8208L, this, "doReaderWorkOnce:2458", "IOException [" + iOException + "]" + " for " + this);
                }
                this.purge_calls(1, true, false);
            }
            if (iIOPInputStream != null) {
                this.processInput(iIOPInputStream);
            }
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Error error) {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(4104L, (java.lang.Object)this, "doReaderWorkOnce:2480", error.toString(), (java.lang.Object)error);
            }
            try {
                this.purge_calls(1, false, false);
                java.lang.Object var5_5 = null;
            }
            catch (Throwable throwable) {
                java.lang.Object var5_6 = null;
                throw error;
            }
            throw error;
        }
        catch (Exception exception) {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.exception(4104L, this, "doReaderWorkOnce:2493", exception);
            }
            try {
                this.purge_calls(1, false, false);
                java.lang.Object var7_9 = null;
            }
            catch (Throwable throwable) {
                java.lang.Object var7_10 = null;
                throw exception;
            }
            throw exception;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append('@');
        stringBuffer.append(Integer.toHexString(this.hashCode()));
        stringBuffer.append(" timeStamp=" + this.timeStamp);
        stringBuffer.append(" isServer=" + this.isServer);
        stringBuffer.append(" state=" + this.state);
        stringBuffer.append(" transportConnection=" + this.transportConnection);
        return stringBuffer.toString();
    }

    private void checkEstablished() {
        this.lock.lock();
        while (this.state == 1) {
            this.event.wait(this.lock);
        }
        if (this.state != 2) {
            this.lock.unlock();
            throw new TRANSIENT("Connection state: " + this.state, 1229124359, CompletionStatus.COMPLETED_NO);
        }
        this.lock.unlock();
    }

    public TransportConnection getTransportConnection() {
        this.checkEstablished();
        return this.transportConnection;
    }

    public String getConnectionParameterString() {
        this.checkEstablished();
        if (this.transportConnection != null) {
            return this.transportConnection.getConnectionParameterString();
        }
        return "";
    }

    public java.lang.Object getConnectionData() {
        this.checkEstablished();
        if (this.transportConnection != null) {
            return this.transportConnection.getConnectionData();
        }
        return null;
    }

    private String getConnectionString() {
        if (this.connectionString == null) {
            this.connectionString = "P=" + ORB.orbLoadTime + ":" + "O=" + this.orb.thisInstanceNumber + ":" + this.getConnectionParameterString();
        }
        return this.connectionString;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

