/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.iiop;

import com.ibm.CORBA.ras.ORBRas;
import com.ibm.rmi.iiop.CDROutputStream;
import com.ibm.rmi.iiop.CancelRequestException;
import com.ibm.rmi.iiop.Connection;
import com.ibm.rmi.iiop.IIOPInputStream;
import com.ibm.rmi.iiop.Message;
import com.ibm.rmi.iiop.ORB;
import com.ibm.rmi.iiop.OutCallDesc;
import com.ibm.rmi.ras.Trace;
import com.ibm.rmi.ras.Utility;
import java.io.IOException;
import java.io.OutputStream;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.portable.InputStream;

public class IIOPOutputStream
extends CDROutputStream
implements com.ibm.CORBA.iiop.IIOPOutputStream {
    protected Connection conn;
    protected Message msg;
    private IIOPOutputStream fIIOPOutputStream;
    boolean firstFragSent;
    boolean lastFragSent;
    boolean requestCancelled;
    int firstMsgType = -1;
    OutCallDesc call;

    public IIOPOutputStream(ORB oRB, Connection connection) {
        super(oRB);
        this.conn = connection;
    }

    public IIOPOutputStream(ORB oRB, Connection connection, byte by, byte by2) {
        super(oRB);
        this.setGIOPVersion(by, by2, false);
        this.conn = connection;
    }

    public IIOPOutputStream(IIOPInputStream iIOPInputStream) {
        super(iIOPInputStream.orb);
        this.setGIOPVersion(iIOPInputStream.getGIOPMajor(), iIOPInputStream.getGIOPMinor(), false);
        this.conn = iIOPInputStream.getConnection();
    }

    public final Connection getConnection() {
        return this.conn;
    }

    public final void setConnection(Connection connection) {
        this.conn = connection;
    }

    public final com.ibm.CORBA.iiop.Message getMessage() {
        return this.msg;
    }

    public final void setMessage(com.ibm.CORBA.iiop.Message message) {
        this.msg = (Message)message;
    }

    public void lastFragSent() {
        this.lastFragSent = true;
    }

    public boolean isFirstFragSent() {
        return this.firstFragSent;
    }

    public void setCall(OutCallDesc outCallDesc) {
        this.call = outCallDesc;
    }

    public OutCallDesc getCall() {
        return this.call;
    }

    protected void sendFragment() {
        this.offset += this.size;
        this.offset -= 16;
        this.size = this.fragSize;
        this.msg.setFragmentToFollow(this.buf, true);
        try {
            this.getConnection().sendFragment(this, this.msg.getRequestId(), this.msg.getType(), this.firstFragSent);
            if (!this.firstFragSent) {
                this.firstMsgType = this.msg.getType();
                this.firstFragSent = true;
            }
        }
        catch (Exception exception) {
            ORBRas.orbTrcLogger.exception(4104L, this, "sendFragment:147", exception);
            throw new MARSHAL("Error sending fragment", 1229125820, CompletionStatus.COMPLETED_NO);
        }
        this.msg.setFragmentToFollow(this.buf, false);
        this.size = 12;
        this.msg.setType(7, this.buf);
        this.write_long(this.msg.getRequestId(), false);
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(4112L, this, "sendFragment:169", "reqId " + this.msg.getRequestId() + " next fragment offset_hex " + Integer.toHexString(this.get_offset()));
        }
    }

    protected void cancelRequest() {
        if (!this.firstFragSent || this.lastFragSent || this.requestCancelled) {
            return;
        }
        if (this.firstMsgType != 0 && this.firstMsgType != 3) {
            return;
        }
        this.msg.setType(2, this.buf);
        this.size = 12;
        this.write_long(this.msg.getRequestId());
        this.msg.setFragmentToFollow(this.buf, false);
        try {
            this.getConnection().sendFragment(this, this.msg.getRequestId(), this.msg.getType(), this.firstFragSent);
            this.requestCancelled = true;
        }
        catch (Exception exception) {
            ORBRas.orbTrcLogger.exception(4104L, this, "cancelRequest:201", exception);
            throw new MARSHAL("Error sending cancel request", 1229125821, CompletionStatus.COMPLETED_NO);
        }
    }

    protected void cancelReply() {
        if (!this.firstFragSent || this.lastFragSent || this.requestCancelled) {
            return;
        }
        this.msg.setType(7, this.buf);
        this.size = 12;
        this.write_long(this.msg.getRequestId());
        this.msg.setFragmentToFollow(this.buf, false);
        try {
            this.getConnection().sendFragment(this, this.msg.getRequestId(), this.msg.getType(), this.firstFragSent);
        }
        catch (Exception exception) {
            ORBRas.orbTrcLogger.exception(4104L, this, "cancelReply:232", exception);
        }
        this.requestCancelled = true;
        throw new CancelRequestException();
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, this, "writeTo:255");
        }
        this.msg.setSize(this.getBuffer(), this.size);
        if (((ORB)this.orb).CommTraceIsEnabled()) {
            boolean bl = true;
            int n = this.msg.getType();
            if (!(this.firstFragSent || this.msg.headerWritten() || n != 0 && n != 3 && n != 1 && n != 4)) {
                bl = false;
            }
            Trace.dump(Utility.getMessage("Trace.outGoing"), bl, true, this.getBuffer(), this.size, 0, (com.ibm.CORBA.iiop.ORB)this.orb, this.conn.getTransportConnection());
        }
        outputStream.write(this.getBuffer(), 0, this.size);
        this.conn.updateTimeStamp();
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "writeTo:295");
        }
    }

    public InputStream create_input_stream() {
        return new IIOPInputStream((ORB)this.orb, this.getBuffer(), this.size, this.littleEndian, this.msg);
    }
}

