/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.iiop;

import com.ibm.CORBA.iiop.WorkUnit;
import com.ibm.CORBA.ras.ORBRas;
import com.ibm.rmi.iiop.WorkQueue;
import java.security.AccessController;
import java.security.PrivilegedAction;

final class WorkerThread
implements Runnable {
    private final WorkQueue workQueue;
    private final long inactivityTimeout;
    private final boolean isCached;
    private final String threadName;

    public WorkerThread(long l, boolean bl, WorkQueue workQueue, String string) {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4132L, this, "<init>:148");
        }
        this.inactivityTimeout = l;
        this.isCached = bl;
        this.workQueue = workQueue;
        this.threadName = string;
        final Thread thread = new Thread(this, this.threadName);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                thread.setDaemon(true);
                return null;
            }
        });
        thread.start();
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "<init>:172");
        }
    }

    public void run() {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, this, "run:181");
        }
        if (this.isCached) {
            try {
                try {
                    WorkUnit workUnit;
                    while ((workUnit = this.getWork()) != null) {
                        workUnit.doWork();
                    }
                    Object var4_4 = null;
                    this.workQueue.removeThread(this);
                }
                catch (Throwable throwable) {
                    ORBRas.orbTrcLogger.trace(4104L, (Object)this, "run", "WorkerThread " + this.threadName + " terminated prematurely. Exception text: " + throwable.getMessage(), (Object)throwable);
                    if (throwable instanceof ThreadDeath) {
                        throw (ThreadDeath)throwable;
                    }
                    Object var4_5 = null;
                    this.workQueue.removeThread(this);
                }
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                this.workQueue.removeThread(this);
                throw throwable;
            }
        } else {
            WorkUnit workUnit = this.getWork();
            if (workUnit != null) {
                workUnit.doWork();
            }
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "run:216");
        }
    }

    String getName() {
        return this.threadName;
    }

    private WorkUnit getWork() {
        WorkQueue workQueue = this.workQueue;
        synchronized (workQueue) {
            this.workQueue.incrementWorkerCount();
            WorkUnit workUnit = this.workQueue.getWorkToDo();
            long l = this.inactivityTimeout <= 0L ? 0L : System.currentTimeMillis();
            long l2 = this.inactivityTimeout;
            while (workUnit == null && !this.workQueue.isShutdownPending()) {
                if (l2 < 0L) break;
                try {
                    this.workQueue.wait(l2);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                l2 = this.inactivityTimeout - (System.currentTimeMillis() - l);
                workUnit = this.workQueue.getWorkToDo();
            }
            this.workQueue.decrementWorkerCount();
            WorkUnit workUnit2 = workUnit;
            return workUnit2;
        }
    }
}

