/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.io;

import com.ibm.CORBA.iiop.IOOutputStream;
import com.ibm.CORBA.ras.ORBRas;
import com.ibm.jvm.ExtendedSystem;
import com.ibm.rmi.iiop.CDROutputStream;
import com.ibm.rmi.io.ObjectStreamClass;
import com.ibm.rmi.io.ObjectStreamField;
import com.ibm.rmi.io.OutputStreamHook;
import com.ibm.rmi.io.ReflectField;
import com.ibm.rmi.util.PartnerVersion;
import com.ibm.rmi.util.PartnerVersionUtil;
import com.ibm.rmi.util.RepositoryId;
import com.ibm.rmi.util.Utility;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.NotActiveException;
import java.io.NotSerializableException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import javax.rmi.CORBA.Util;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INV_OBJREF;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.portable.ValueOutputStream;
import org.omg.CORBA_2_3.portable.OutputStream;

public class IIOPOutputStream
extends OutputStreamHook
implements IOOutputStream {
    private static final String thisClassName = "com.ibm.rmi.io.IIOPOutputStream";
    private OutputStream orbStream;
    private CDROutputStream orbStream2;
    private ValueOutputStream vStream;
    private byte formatVersion = 1;
    public static boolean usePortableInterface = false;
    private Object currentObject = null;
    private ObjectStreamClass currentClassDesc = null;
    private Object[] writeObjectArglist = new Object[]{this};
    private int index = -1;
    private static final int ENCLOSE_NONE = 0;
    private static final int ENCLOSE_START = 1;
    private static final int ENCLOSE_END = 2;
    private int currentEnclose = 0;
    private PendingWriteStack pendingWriteStack = new PendingWriteStack();

    public final void setOrbStream(OutputStream outputStream) {
        this.orbStream = outputStream;
        if (outputStream instanceof CDROutputStream) {
            this.orbStream2 = (CDROutputStream)outputStream;
            this.vStream = (ValueOutputStream)((Object)outputStream);
        } else if (outputStream instanceof ValueOutputStream) {
            this.vStream = (ValueOutputStream)((Object)outputStream);
        }
        if (usePortableInterface) {
            this.orbStream2 = null;
        }
    }

    public final void setFormatVersion(byte by) {
        this.formatVersion = by;
        if (by > 2) {
            throw new BAD_PARAM("Requested stream format not supported", 1330446375, CompletionStatus.COMPLETED_MAYBE);
        }
        if (by > 1 && this.vStream == null) {
            throw new BAD_PARAM("ORB stream does not support format version", 1330446376, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    public final void writeObjectDelegate(Object object) throws IOException {
        this.startEnclosure();
        int n = this.currentEnclose;
        this.currentEnclose = 0;
        if (this.orbStream2 == null) {
            Util.writeAbstractObject(this.orbStream, object);
        } else {
            Object object2 = this.orbStream2.fast_write_abstract_interface(object = Utility.autoConnect(object, this.orbStream.orb(), false));
            if (object2 == CDROutputStream.PENDING_WRITE) {
                if (!this.pendingWriteStack.isEmpty()) {
                    this.pendingWriteStack.addRecursionBreak();
                }
                boolean bl = this.orbStream2.getPrevMustChunk();
                object = this.orbStream2.getCurrentObject();
                this.simpleWriteObjectLoop(object);
                this.orbStream2.post_fast_write_value(bl);
            }
        }
        this.currentEnclose = n;
    }

    public final void writeObjectOverride(Object object) throws IOException {
        this.writeObjectDelegate(object);
    }

    private Object writeArray(Object object, Class clazz) throws IOException {
        if (clazz.isPrimitive()) {
            this.writePrimArray(object, clazz);
            return null;
        }
        Object[] objectArray = (Object[])object;
        int n = objectArray.length;
        this.orbStream.write_ulong(n);
        ObjectStreamClass objectStreamClass = ObjectStreamClass.lookup(clazz);
        return this.writeArray(objectArray, objectStreamClass, 0);
    }

    private Object writeArray(Object[] objectArray, ObjectStreamClass objectStreamClass, int n) {
        if (objectStreamClass.isValueType()) {
            return this.writeValueArray(objectArray, objectStreamClass, n);
        }
        if (objectStreamClass.isRemoteInterface()) {
            return this.writeRemoteInterfaceArray(objectArray, n);
        }
        if (objectStreamClass.isAny()) {
            return this.writeObjectArray(objectArray, objectStreamClass, n);
        }
        if (objectStreamClass.isAbstractInterface()) {
            return this.writeAbstractInterfaceArray(objectArray, objectStreamClass, n);
        }
        throw new MARSHAL("Unknown array type " + objectStreamClass.forClass().getName(), 1229125817, CompletionStatus.COMPLETED_NO);
    }

    private Object writeValueArray(Object[] objectArray, ObjectStreamClass objectStreamClass, int n) {
        int n2 = n;
        while (n2 < objectArray.length) {
            Object object = objectArray[n2];
            if ((object = this.writeValueType(object)) == CDROutputStream.PENDING_WRITE) {
                boolean bl = this.orbStream2.getPrevMustChunk();
                this.pendingWriteStack.addResumeArray(objectArray, objectStreamClass, n2, bl);
                object = this.orbStream2.getCurrentObject();
                return object;
            }
            ++n2;
        }
        return null;
    }

    private Object writeAbstractInterfaceArray(Object[] objectArray, ObjectStreamClass objectStreamClass, int n) {
        int n2 = n;
        while (n2 < objectArray.length) {
            Object object = objectArray[n2];
            Object object2 = this.writeAbstractInterface(object);
            if (object2 == CDROutputStream.PENDING_WRITE) {
                boolean bl = this.orbStream2.getPrevMustChunk();
                this.pendingWriteStack.addResumeArray(objectArray, objectStreamClass, n2, bl);
                object = this.orbStream2.getCurrentObject();
                return object;
            }
            ++n2;
        }
        return null;
    }

    private Object writeRemoteInterfaceArray(Object[] objectArray, int n) {
        int n2 = n;
        while (n2 < objectArray.length) {
            Object object = objectArray[n2];
            Util.writeRemoteObject(this.orbStream, object);
            ++n2;
        }
        return null;
    }

    private Object writeObjectArray(Object[] objectArray, ObjectStreamClass objectStreamClass, int n) {
        int n2 = n;
        while (n2 < objectArray.length) {
            Object object = objectArray[n2];
            if (this.orbStream2 == null) {
                Util.writeAny(this.orbStream, object);
            } else {
                Object object2 = this.orbStream2.fast_writeAnyOpt(object);
                if (object2 == CDROutputStream.PENDING_WRITE) {
                    boolean bl = this.orbStream2.getPrevMustChunk();
                    this.pendingWriteStack.addResumeArray(objectArray, objectStreamClass, n2, bl);
                    object = this.orbStream2.getCurrentObject();
                    return object;
                }
            }
            ++n2;
        }
        return null;
    }

    private void writePrimArray(Object object, Class clazz) {
        if (clazz == Integer.TYPE) {
            int[] nArray = (int[])object;
            int n = nArray.length;
            this.orbStream.write_ulong(n);
            this.orbStream.write_long_array(nArray, 0, n);
        } else if (clazz == Byte.TYPE) {
            byte[] byArray = (byte[])object;
            int n = byArray.length;
            this.orbStream.write_ulong(n);
            this.orbStream.write_octet_array(byArray, 0, n);
        } else if (clazz == Boolean.TYPE) {
            boolean[] blArray = (boolean[])object;
            int n = blArray.length;
            this.orbStream.write_ulong(n);
            this.orbStream.write_boolean_array(blArray, 0, n);
        } else if (clazz == Long.TYPE) {
            long[] lArray = (long[])object;
            int n = lArray.length;
            this.orbStream.write_ulong(n);
            this.orbStream.write_longlong_array(lArray, 0, n);
        } else if (clazz == Float.TYPE) {
            float[] fArray = (float[])object;
            int n = fArray.length;
            this.orbStream.write_ulong(n);
            this.orbStream.write_float_array(fArray, 0, n);
        } else if (clazz == Double.TYPE) {
            double[] dArray = (double[])object;
            int n = dArray.length;
            this.orbStream.write_ulong(n);
            this.orbStream.write_double_array(dArray, 0, n);
        } else if (clazz == Short.TYPE) {
            short[] sArray = (short[])object;
            int n = sArray.length;
            this.orbStream.write_ulong(n);
            this.orbStream.write_short_array(sArray, 0, n);
        } else {
            short s;
            if (clazz != Character.TYPE) {
                throw new MARSHAL("Invalid primitive type : " + object.getClass().getName(), 1229125812, CompletionStatus.COMPLETED_NO);
            }
            boolean bl = false;
            if (this.orbStream instanceof PartnerVersion) {
                short s2 = ((PartnerVersion)((Object)this.orbStream)).getPartnerMajor();
                s = ((PartnerVersion)((Object)this.orbStream)).getPartnerMinor();
                bl = PartnerVersionUtil.useOldChar(s2, s);
            }
            char[] cArray = (char[])object;
            s = cArray.length;
            this.orbStream.write_ulong(s);
            if (bl) {
                this.orbStream.write_char_array(cArray, 0, s);
            } else {
                this.orbStream.write_wchar_array(cArray, 0, s);
            }
        }
    }

    private Object simpleWriteObjectInternal(Object object) throws IOException {
        Class clazz = object.getClass();
        if (clazz.isArray()) {
            return this.writeArray(object, clazz.getComponentType());
        }
        ObjectStreamClass objectStreamClass = ObjectStreamClass.lookup(clazz);
        if (objectStreamClass == null) {
            throw new NotSerializableException(clazz.getName());
        }
        if (objectStreamClass.isExternalizable()) {
            this.writeByte(this.formatVersion);
            Externalizable externalizable = (Externalizable)object;
            externalizable.writeExternal(this);
            return null;
        }
        if (objectStreamClass.isSerializable()) {
            return this.writeSerializable(object, objectStreamClass);
        }
        throw new NotSerializableException(clazz.getName());
    }

    private void simpleWriteObjectLoop(Object object) throws IOException {
        while (true) {
            if (object == null) {
                PendingWrite pendingWrite = this.pendingWriteStack.getNextPendingWrite();
                if (pendingWrite == null || pendingWrite.isRecursionBreak()) {
                    return;
                }
                object = this.continueSimpleWriteObject(pendingWrite);
                continue;
            }
            object = this.simpleWriteObjectInternal(object);
        }
    }

    private Object continueSimpleWriteObject(PendingWrite pendingWrite) throws IOException {
        Object object = pendingWrite.obj;
        ObjectStreamClass objectStreamClass = pendingWrite.classDesc;
        if (pendingWrite.isSubclass()) {
            return this.outputObject(object, objectStreamClass);
        }
        if (pendingWrite.isBeginFields()) {
            return this.outputClassFields(object, objectStreamClass, 0);
        }
        this.orbStream2.post_fast_write_value(pendingWrite.mustChunk);
        if (pendingWrite.isResumeFields()) {
            int n = pendingWrite.index;
            return this.outputClassFields(object, objectStreamClass, ++n);
        }
        if (pendingWrite.isResumeArray()) {
            Object[] objectArray = (Object[])object;
            int n = pendingWrite.index;
            return this.writeArray(objectArray, objectStreamClass, ++n);
        }
        throw new MARSHAL("Unknown PendingWrite type", 1229125827, CompletionStatus.COMPLETED_NO);
    }

    public final void simpleWriteObject(Object object) {
        try {
            if (object instanceof String) {
                this.orbStream.write_wstring((String)object);
                return;
            }
            if (object instanceof Class) {
                Utility.writeClassValue(this.orbStream, (Class)object);
                return;
            }
            if (!this.pendingWriteStack.isEmpty()) {
                this.pendingWriteStack.addRecursionBreak();
            }
            this.simpleWriteObjectLoop(object);
        }
        catch (IOException iOException) {
            ORBRas.orbTrcLogger.exception(4104L, this, "simpleWriteObject:470", (Exception)iOException);
            throw new MARSHAL(iOException.getMessage(), 1229125806, CompletionStatus.COMPLETED_NO);
        }
    }

    public final void defaultWriteObjectDelegate() throws IOException {
        if (this.currentObject == null || this.currentClassDesc == null) {
            throw new NotActiveException("defaultWriteObjectDelegate");
        }
        int n = this.currentEnclose;
        this.currentEnclose = 0;
        if (this.orbStream2 == null) {
            this.outputClassFields(this.currentObject, this.currentClassDesc, 0);
        } else {
            if (this.index != -1) {
                if (this.orbStream2.get_offset() == this.index) {
                    this.orbStream2.writeBooleanBack(true);
                }
                this.index = -1;
            }
            if (!this.pendingWriteStack.isEmpty()) {
                this.pendingWriteStack.addRecursionBreak();
            }
            this.pendingWriteStack.addBeginFields(this.currentObject, this.currentClassDesc);
            this.simpleWriteObjectLoop(null);
        }
        this.currentEnclose = n;
    }

    public final boolean enableReplaceObjectDelegate(boolean bl) {
        return false;
    }

    protected final void annotateClass(Class clazz) throws IOException {
        throw new IOException("Method annotateClass not supported");
    }

    public final void close() throws IOException {
    }

    protected final void drain() throws IOException {
    }

    public final void flush() throws IOException {
        try {
            this.orbStream.flush();
        }
        catch (Error error) {
            ORBRas.orbTrcLogger.trace(4104L, (Object)this, "flush:554", error.toString(), (Object)error);
            throw new IOException(error.getMessage());
        }
    }

    protected final Object replaceObject(Object object) throws IOException {
        throw new IOException("Method replaceObject not supported");
    }

    public final void reset() throws IOException {
        throw new IOException("Method reset not supported");
    }

    public final void write(byte[] byArray) throws IOException {
        try {
            this.startEnclosure();
            this.orbStream.write_octet_array(byArray, 0, byArray.length);
        }
        catch (Error error) {
            ORBRas.orbTrcLogger.trace(4104L, (Object)this, "write (byte[]):577", error.toString(), (Object)error);
            throw new IOException(error.getMessage());
        }
    }

    public final void write(byte[] byArray, int n, int n2) throws IOException {
        try {
            this.startEnclosure();
            this.orbStream.write_octet_array(byArray, n, n2);
        }
        catch (Error error) {
            ORBRas.orbTrcLogger.trace(4104L, (Object)this, "write (byte[], int, int):592", error.toString(), (Object)error);
            throw new IOException(error.getMessage());
        }
    }

    public final void write(int n) throws IOException {
        try {
            this.startEnclosure();
            this.orbStream.write_octet((byte)(n & 0xFF));
        }
        catch (Error error) {
            ORBRas.orbTrcLogger.trace(4104L, (Object)this, "write (int):607", error.toString(), (Object)error);
            throw new IOException(error.getMessage());
        }
    }

    public final void writeBoolean(boolean bl) throws IOException {
        try {
            this.startEnclosure();
            this.orbStream.write_boolean(bl);
        }
        catch (Error error) {
            ORBRas.orbTrcLogger.trace(4104L, (Object)this, "writeBoolean:622", error.toString(), (Object)error);
            throw new IOException(error.getMessage());
        }
    }

    public final void writeByte(int n) throws IOException {
        try {
            this.startEnclosure();
            this.orbStream.write_octet((byte)n);
        }
        catch (Error error) {
            ORBRas.orbTrcLogger.trace(4104L, (Object)this, "writeByte:637", error.toString(), (Object)error);
            throw new IOException(error.getMessage());
        }
    }

    public final void writeBytes(String string) throws IOException {
        try {
            this.startEnclosure();
            byte[] byArray = string.getBytes();
            this.orbStream.write_octet_array(byArray, 0, byArray.length);
        }
        catch (Error error) {
            ORBRas.orbTrcLogger.trace(4104L, (Object)this, "writeBytes:653", error.toString(), (Object)error);
            throw new IOException(error.getMessage());
        }
    }

    public final void writeChar(int n) throws IOException {
        try {
            this.startEnclosure();
            this.orbStream.write_wchar((char)n);
        }
        catch (Error error) {
            ORBRas.orbTrcLogger.trace(4104L, (Object)this, "writeChar:668", error.toString(), (Object)error);
            throw new IOException(error.getMessage());
        }
    }

    public final void writeChars(String string) throws IOException {
        try {
            this.startEnclosure();
            char[] cArray = string.toCharArray();
            this.orbStream.write_wchar_array(cArray, 0, cArray.length);
        }
        catch (Error error) {
            ORBRas.orbTrcLogger.trace(4104L, (Object)this, "writeChars:684", error.toString(), (Object)error);
            throw new IOException(error.getMessage());
        }
    }

    public final void writeDouble(double d) throws IOException {
        try {
            this.startEnclosure();
            this.orbStream.write_double(d);
        }
        catch (Error error) {
            ORBRas.orbTrcLogger.trace(4104L, (Object)this, "writeDouble:699", error.toString(), (Object)error);
            throw new IOException(error.getMessage());
        }
    }

    public final void writeFloat(float f) throws IOException {
        try {
            this.startEnclosure();
            this.orbStream.write_float(f);
        }
        catch (Error error) {
            ORBRas.orbTrcLogger.trace(4104L, (Object)this, "writeFloat:714", error.toString(), (Object)error);
            throw new IOException(error.getMessage());
        }
    }

    public final void writeInt(int n) throws IOException {
        try {
            this.startEnclosure();
            this.orbStream.write_long(n);
        }
        catch (Error error) {
            ORBRas.orbTrcLogger.trace(4104L, (Object)this, "writeInt:729", error.toString(), (Object)error);
            throw new IOException(error.getMessage());
        }
    }

    public final void writeLong(long l) throws IOException {
        try {
            this.startEnclosure();
            this.orbStream.write_longlong(l);
        }
        catch (Error error) {
            ORBRas.orbTrcLogger.trace(4104L, (Object)this, "writeLong:744", error.toString(), (Object)error);
            throw new IOException(error.getMessage());
        }
    }

    public final void writeShort(int n) throws IOException {
        try {
            this.startEnclosure();
            this.orbStream.write_short((short)n);
        }
        catch (Error error) {
            ORBRas.orbTrcLogger.trace(4104L, (Object)this, "writeShort:759", error.toString(), (Object)error);
            throw new IOException(error.getMessage());
        }
    }

    protected final void writeStreamHeader() throws IOException {
    }

    public final void writeUTF(String string) throws IOException {
        try {
            this.startEnclosure();
            if (this.orbStream instanceof PartnerVersion) {
                short s;
                short s2 = ((PartnerVersion)((Object)this.orbStream)).getPartnerMajor();
                if (PartnerVersionUtil.sendJavaCharAsIDLChar(s2, s = ((PartnerVersion)((Object)this.orbStream)).getPartnerMinor())) {
                    this.orbStream.write_string(string);
                } else {
                    this.orbStream.write_wstring(string);
                }
            } else {
                this.orbStream.write_wstring(string);
            }
        }
        catch (Error error) {
            ORBRas.orbTrcLogger.trace(4104L, (Object)this, "writeUTF:789", error.toString(), (Object)error);
            throw new IOException(error.getMessage());
        }
    }

    private void invokeObjectWriter(ObjectStreamClass objectStreamClass, Object object) throws IOException {
        try {
            this.writeByte(this.formatVersion);
            this.writeBoolean(false);
            if (this.orbStream2 != null) {
                this.index = this.orbStream2.get_offset();
            }
            if (this.formatVersion >= 2) {
                this.currentEnclose = 1;
            }
            objectStreamClass.writeObjectMethod.invoke(object, this.writeObjectArglist);
            if (this.currentEnclose != 0) {
                this.endEnclosure();
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            ORBRas.orbTrcLogger.exception(4104L, this, "invokeObjectWriter:829", (Exception)invocationTargetException);
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new Error("invokeObjectWriter internal error");
        }
        catch (IllegalAccessException illegalAccessException) {
            ORBRas.orbTrcLogger.exception(4104L, this, "invokeObjectWriter:842", (Exception)illegalAccessException);
        }
    }

    private Object outputObject(Object object, ObjectStreamClass objectStreamClass) throws IOException {
        if (objectStreamClass.hasWriteObject()) {
            this.currentClassDesc = objectStreamClass;
            this.currentObject = object;
            this.currentEnclose = 0;
            this.invokeObjectWriter(objectStreamClass, object);
            return null;
        }
        return this.outputClassFields(object, objectStreamClass, 0);
    }

    private Object outputClassFields(Object object, ObjectStreamClass objectStreamClass, int n) throws InvalidClassException {
        ObjectStreamField[] objectStreamFieldArray = objectStreamClass.getFieldsNoCopy();
        int n2 = n;
        while (n2 < objectStreamFieldArray.length) {
            ObjectStreamField objectStreamField = objectStreamFieldArray[n2];
            if (objectStreamField.isPrimitive()) {
                this.writePrimField(object, objectStreamField);
            } else {
                Object object2 = this.getObjectField(object, objectStreamField);
                Object object3 = this.writeObjectField(object2, objectStreamField);
                if (object3 == CDROutputStream.PENDING_WRITE) {
                    boolean bl = this.orbStream2.getPrevMustChunk();
                    this.pendingWriteStack.addResumeFields(object, objectStreamClass, n2, bl);
                    object2 = this.orbStream2.getCurrentObject();
                    return object2;
                }
            }
            ++n2;
        }
        return null;
    }

    private Object writeSerializable(Object object, ObjectStreamClass objectStreamClass) throws IOException {
        ObjectStreamClass objectStreamClass2 = objectStreamClass;
        objectStreamClass = objectStreamClass.getSuperclass();
        while (objectStreamClass != null && objectStreamClass.isSerializable()) {
            this.pendingWriteStack.addSubclass(object, objectStreamClass2);
            objectStreamClass2 = objectStreamClass;
            objectStreamClass = objectStreamClass.getSuperclass();
        }
        return this.outputObject(object, objectStreamClass2);
    }

    private Object getObjectField(Object object, ObjectStreamField objectStreamField) throws InvalidClassException {
        ReflectField reflectField = objectStreamField.getReflectField();
        if (reflectField == null) {
            throw new InvalidClassException(objectStreamField.getClazz().getName(), "Nonexistent field " + objectStreamField.getName());
        }
        Object object2 = null;
        try {
            object2 = reflectField.get(object);
        }
        catch (IllegalAccessException illegalAccessException) {
            ORBRas.orbTrcLogger.exception(4104L, this, "getObjectField:927", (Exception)illegalAccessException);
            throw new InvalidClassException(objectStreamField.getClazz().getName(), "IllegalAccessException " + objectStreamField.getName());
        }
        return object2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object writeObjectField(Object object, ObjectStreamField objectStreamField) {
        ObjectStreamClass objectStreamClass = objectStreamField.getObjectStreamClass();
        if (objectStreamClass.isValueType()) {
            return this.writeValueType(object);
        }
        if (objectStreamClass.isRemoteInterface()) {
            Util.writeRemoteObject(this.orbStream, object);
            return object;
        } else {
            if (objectStreamClass.isAbstractInterface()) {
                return this.writeAbstractInterface(object);
            }
            if (!objectStreamClass.isAny()) throw new MARSHAL("Unknown field type " + objectStreamClass.forClass().getName(), 1229125816, CompletionStatus.COMPLETED_NO);
            if (this.orbStream2 != null) return this.orbStream2.fast_writeAnyOpt(object);
            Util.writeAny(this.orbStream, object);
        }
        return object;
    }

    private Object writeAbstractInterface(Object object) {
        block3: {
            if (this.orbStream2 == null) {
                Util.writeAbstractObject(this.orbStream, object);
                return object;
            }
            try {
                object = Utility.autoConnect(object, this.orbStream.orb(), false);
            }
            catch (INV_OBJREF iNV_OBJREF) {
                if (!ORBRas.isTrcLogging) break block3;
                ORBRas.orbTrcLogger.trace(4112L, this, "writeAbstractInterface982", iNV_OBJREF.toString());
            }
        }
        return this.orbStream2.fast_write_abstract_interface(object);
    }

    private Object writeValueType(Object object) {
        try {
            if (this.orbStream2 == null) {
                this.orbStream.write_value((Serializable)object);
                return object;
            }
            return this.orbStream2.fast_write_value((Serializable)object);
        }
        catch (ClassCastException classCastException) {
            if (object instanceof Serializable) {
                throw classCastException;
            }
            ORBRas.orbTrcLogger.exception(4104L, this, "writeValueType:1003", (Exception)classCastException);
            Utility.throwNotSerializableForCorba(object.getClass().getName());
            return object;
        }
    }

    private void writePrimPutField(Object object, ObjectStreamField objectStreamField) {
        switch (objectStreamField.getTypeCode()) {
            case 'B': {
                byte by = (Byte)object;
                this.orbStream.write_octet(by);
                break;
            }
            case 'C': {
                char c = ((Character)object).charValue();
                this.orbStream.write_wchar(c);
                break;
            }
            case 'F': {
                float f = ((Float)object).floatValue();
                this.orbStream.write_float(f);
                break;
            }
            case 'D': {
                double d = (Double)object;
                this.orbStream.write_double(d);
                break;
            }
            case 'I': {
                int n = (Integer)object;
                this.orbStream.write_long(n);
                break;
            }
            case 'J': {
                long l = (Long)object;
                this.orbStream.write_longlong(l);
                break;
            }
            case 'S': {
                short s = (Short)object;
                this.orbStream.write_short(s);
                break;
            }
            case 'Z': {
                boolean bl = (Boolean)object;
                this.orbStream.write_boolean(bl);
                break;
            }
            default: {
                throw new IllegalArgumentException("field is not a primitive");
            }
        }
    }

    private void writePrimField(Object object, ObjectStreamField objectStreamField) throws InvalidClassException {
        ReflectField reflectField = objectStreamField.getReflectField();
        if (reflectField == null) {
            throw new InvalidClassException(objectStreamField.getClazz().getName(), "Nonexistent field " + objectStreamField.getName());
        }
        try {
            switch (objectStreamField.getTypeCode()) {
                case 'I': {
                    int n = reflectField.getInt(object);
                    this.orbStream.write_long(n);
                    break;
                }
                case 'Z': {
                    boolean bl = reflectField.getBoolean(object);
                    this.orbStream.write_boolean(bl);
                    break;
                }
                case 'B': {
                    byte by = reflectField.getByte(object);
                    this.orbStream.write_octet(by);
                    break;
                }
                case 'J': {
                    long l = reflectField.getLong(object);
                    this.orbStream.write_longlong(l);
                    break;
                }
                case 'F': {
                    float f = reflectField.getFloat(object);
                    this.orbStream.write_float(f);
                    break;
                }
                case 'S': {
                    short s = reflectField.getShort(object);
                    this.orbStream.write_short(s);
                    break;
                }
                case 'C': {
                    char c = reflectField.getChar(object);
                    this.orbStream.write_wchar(c);
                    break;
                }
                case 'D': {
                    double d = reflectField.getDouble(object);
                    this.orbStream.write_double(d);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("field is not a primitive");
                }
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            ORBRas.orbTrcLogger.exception(4104L, this, "writePrimField:1106", (Exception)illegalAccessException);
            throw new InvalidClassException(objectStreamField.getClazz().getName(), "IllegalAccessException " + objectStreamField.getName());
        }
    }

    protected void putClassFields(Hashtable hashtable) throws IOException {
        int n = this.currentEnclose;
        this.currentEnclose = 0;
        ObjectStreamField[] objectStreamFieldArray = this.currentClassDesc.getFieldsNoCopy();
        int n2 = 0;
        while (n2 < objectStreamFieldArray.length) {
            Object object;
            ObjectStreamField objectStreamField = objectStreamFieldArray[n2];
            String string = objectStreamField.getName();
            Object object2 = hashtable.get(string);
            if (objectStreamField.isPrimitive()) {
                if (object2 != null) {
                    this.writePrimPutField(object2, objectStreamField);
                }
            } else if (hashtable.containsKey(string) && (object = this.writeObjectField(object2, objectStreamField)) == CDROutputStream.PENDING_WRITE) {
                object2 = this.orbStream2.getCurrentObject();
                if (!this.pendingWriteStack.isEmpty()) {
                    this.pendingWriteStack.addRecursionBreak();
                }
                boolean bl = this.orbStream2.getPrevMustChunk();
                object2 = this.orbStream2.getCurrentObject();
                this.simpleWriteObjectLoop(object2);
                this.orbStream2.post_fast_write_value(bl);
            }
            ++n2;
        }
        this.currentEnclose = n;
    }

    protected void clearStream() {
        this.pendingWriteStack.reset();
        this.orbStream = null;
        this.orbStream2 = null;
        this.currentObject = null;
        this.currentClassDesc = null;
        this.currentEnclose = 0;
    }

    private void startEnclosure() {
        if (this.currentEnclose == 1) {
            String string = RepositoryId.createForCustomJavaType(this.currentClassDesc.forClass());
            this.vStream.start_value(string);
            this.currentEnclose = 2;
        }
    }

    private void endEnclosure() {
        if (this.currentEnclose == 2) {
            this.vStream.end_value();
        } else if (this.currentEnclose == 1) {
            this.orbStream.write_long(0);
        }
    }

    private class PendingWrite {
        protected static final byte RECURSION_BREAK = 0;
        protected static final byte SUBCLASS = 1;
        protected static final byte BEGIN_FIELDS = 2;
        protected static final byte RESUME_FIELDS = 3;
        protected static final byte RESUME_ARRAY = 4;
        protected byte type;
        protected Object obj;
        protected ObjectStreamClass classDesc;
        protected int index;
        protected boolean mustChunk;

        private PendingWrite() {
        }

        protected boolean isRecursionBreak() {
            return this.type == 0;
        }

        protected boolean isSubclass() {
            return this.type == 1;
        }

        protected boolean isBeginFields() {
            return this.type == 2;
        }

        protected boolean isResumeFields() {
            return this.type == 3;
        }

        protected boolean isResumeArray() {
            return this.type == 4;
        }

        protected void reset() {
            this.obj = null;
            this.classDesc = null;
        }
    }

    private class PendingWriteStack {
        PendingWrite[] pendingWrites = new PendingWrite[20];
        int size = 0;

        private PendingWriteStack() {
        }

        protected void reset() {
            int n = 0;
            while (n < this.size) {
                this.pendingWrites[n].reset();
                ++n;
            }
            this.size = 0;
        }

        protected boolean isEmpty() {
            return this.size == 0;
        }

        protected void addRecursionBreak() {
            PendingWrite pendingWrite = this.createPendingWrite();
            pendingWrite.type = 0;
        }

        protected void addSubclass(Object object, ObjectStreamClass objectStreamClass) {
            PendingWrite pendingWrite = this.createPendingWrite();
            pendingWrite.type = 1;
            pendingWrite.obj = object;
            pendingWrite.classDesc = objectStreamClass;
        }

        protected void addBeginFields(Object object, ObjectStreamClass objectStreamClass) {
            PendingWrite pendingWrite = this.createPendingWrite();
            pendingWrite.type = (byte)2;
            pendingWrite.obj = object;
            pendingWrite.classDesc = objectStreamClass;
        }

        protected void addResumeFields(Object object, ObjectStreamClass objectStreamClass, int n, boolean bl) {
            PendingWrite pendingWrite = this.createPendingWrite();
            pendingWrite.type = (byte)3;
            pendingWrite.obj = object;
            pendingWrite.classDesc = objectStreamClass;
            pendingWrite.index = n;
            pendingWrite.mustChunk = bl;
        }

        protected void addResumeArray(Object object, ObjectStreamClass objectStreamClass, int n, boolean bl) {
            PendingWrite pendingWrite = this.createPendingWrite();
            pendingWrite.type = (byte)4;
            pendingWrite.obj = object;
            pendingWrite.classDesc = objectStreamClass;
            pendingWrite.index = n;
            pendingWrite.mustChunk = bl;
        }

        private PendingWrite createPendingWrite() {
            PendingWrite pendingWrite = this.pendingWrites[this.size];
            if (pendingWrite == null) {
                this.pendingWrites[this.size] = pendingWrite = new PendingWrite();
            }
            ++this.size;
            if (this.size == this.pendingWrites.length) {
                int n = this.pendingWrites.length;
                int n2 = Math.min(n * 2, n + 50);
                this.pendingWrites = (PendingWrite[])ExtendedSystem.resizeArray(n2, this.pendingWrites, 0, n);
            }
            return pendingWrite;
        }

        protected PendingWrite getNextPendingWrite() {
            if (this.size == 0) {
                return null;
            }
            return this.pendingWrites[--this.size];
        }
    }
}

