/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.io;

import com.ibm.CORBA.ras.ORBRas;
import com.ibm.rmi.io.ClassDescription;
import com.ibm.rmi.io.InputStreamHook;
import com.ibm.rmi.io.ObjectStreamField;
import com.ibm.rmi.io.ValueUtility;
import com.ibm.rmi.util.RepositoryId;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.ValueMember;

public class ObjectStreamClass
implements ClassDescription,
Serializable {
    public static final long kDefaultUID = -1L;
    private static Object[] noArgsList = new Object[0];
    private static Class[] noTypesList = new Class[0];
    private int isAbstractInterface = -1;
    private int isRemoteInterface = -1;
    private int isValueType = -1;
    private int isAny = -1;
    private boolean hasSerialVersionUIDField = false;
    private boolean mayNeedOldSUID = false;
    private static Method methodHasStaticInitializer = null;
    private static final String thisClassName = "com.ibm.rmi.io.ObjectStreamClass";
    private static ObjectStreamClassEntry[] descriptorFor;
    private static Hashtable descTable;
    private String name;
    private ObjectStreamClass superclass;
    private boolean serializable;
    private boolean externalizable;
    private ObjectStreamField[] fields;
    private ObjectStreamField[] localFields;
    private Class ofClass;
    private long suid = -1L;
    private long computedSuid = -1L;
    private String suidStr = null;
    private long computedHashCode = -1L;
    private long oldComputedHashCode = -1L;
    int primBytes;
    int objFields;
    private boolean hasWriteObjectMethod;
    private boolean hasSerialPersistentFields;
    private boolean hasExternalizableBlockData;
    Method writeObjectMethod;
    Method readObjectMethod;
    Method writeReplaceObjectMethod;
    Method readResolveObjectMethod;
    private ObjectStreamClass localClassDesc;
    private static final Class classSerializable;
    private static final Class classExternalizable;
    private static final long serialVersionUID = -6120832682080437368L;
    private static Comparator compareClassByName;
    private static Comparator compareObjectStreamFieldByName;
    private static Comparator compareMemberByName;
    static /* synthetic */ Class class$java$io$ObjectStreamClass;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$rmi$Remote;
    static /* synthetic */ Class class$org$omg$CORBA$Object;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$io$Serializable;
    static /* synthetic */ Class class$java$io$Externalizable;
    static /* synthetic */ Class class$java$io$ObjectOutputStream;
    static /* synthetic */ Class array$Ljava$io$ObjectStreamField;
    static /* synthetic */ Class class$java$io$ObjectInputStream;
    static /* synthetic */ Class class$java$rmi$RemoteException;
    static /* synthetic */ Class class$java$lang$Throwable;
    static /* synthetic */ Class class$java$lang$Exception;
    static /* synthetic */ Class class$java$io$IOException;

    public final boolean isAbstractInterface() {
        if (this.isAbstractInterface == -1) {
            ObjectStreamClass objectStreamClass = this;
            synchronized (objectStreamClass) {
                if (this.isAbstractInterface == -1) {
                    this.isAbstractInterface = this.isRMIAbstractInterface() ? 1 : (RepositoryId.isAbstractBase(this.ofClass) ? 1 : 0);
                }
            }
        }
        return this.isAbstractInterface == 1;
    }

    public boolean isRemoteInterface() {
        if (this.isRemoteInterface == -1) {
            this.isRemoteInterface = !this.ofClass.isInterface() ? 0 : ((class$java$rmi$Remote == null ? (class$java$rmi$Remote = ObjectStreamClass.class$("java.rmi.Remote")) : class$java$rmi$Remote).isAssignableFrom(this.ofClass) ? 1 : ((class$org$omg$CORBA$Object == null ? (class$org$omg$CORBA$Object = ObjectStreamClass.class$("org.omg.CORBA.Object")) : class$org$omg$CORBA$Object).isAssignableFrom(this.ofClass) ? 1 : 0));
        }
        return this.isRemoteInterface == 1;
    }

    public boolean isValueType() {
        if (this.isValueType == -1) {
            this.isValueType = !this.isAny() && !this.isRemoteInterface() && !this.isAbstractInterface() ? 1 : 0;
        }
        return this.isValueType == 1;
    }

    public boolean isAny() {
        if (this.isAny == -1) {
            this.isAny = this.ofClass == (class$java$lang$Object == null ? (class$java$lang$Object = ObjectStreamClass.class$("java.lang.Object")) : class$java$lang$Object) || this.ofClass == (class$java$io$Serializable == null ? (class$java$io$Serializable = ObjectStreamClass.class$("java.io.Serializable")) : class$java$io$Serializable) || this.ofClass == (class$java$io$Externalizable == null ? (class$java$io$Externalizable = ObjectStreamClass.class$("java.io.Externalizable")) : class$java$io$Externalizable) ? 1 : 0;
        }
        return this.isAny == 1;
    }

    public static ObjectStreamClass lookup(Class clazz) {
        ObjectStreamClass objectStreamClass = ObjectStreamClass.lookupInternal(clazz);
        return objectStreamClass;
    }

    static ObjectStreamClass lookupInternal(Class clazz) {
        ObjectStreamClass objectStreamClass = (ObjectStreamClass)descTable.get(clazz);
        if (objectStreamClass == null) {
            ObjectStreamClassEntry[] objectStreamClassEntryArray = descriptorFor;
            synchronized (objectStreamClassEntryArray) {
                objectStreamClass = ObjectStreamClass.findDescriptorFor(clazz);
                if (objectStreamClass == null) {
                    Class clazz2;
                    boolean bl = classSerializable.isAssignableFrom(clazz);
                    boolean bl2 = classExternalizable.isAssignableFrom(clazz);
                    if (bl2) {
                        bl = false;
                    }
                    ObjectStreamClass objectStreamClass2 = null;
                    if (clazz.getSuperclass() != (class$java$lang$Class == null ? (class$java$lang$Class = ObjectStreamClass.class$("java.lang.Class")) : class$java$lang$Class) && (clazz2 = clazz.getSuperclass()) != null) {
                        objectStreamClass2 = ObjectStreamClass.lookup(clazz2);
                    }
                    objectStreamClass = new ObjectStreamClass(clazz, objectStreamClass2, bl, bl2);
                }
            }
            objectStreamClass.init();
            descTable.put(clazz, objectStreamClass);
        }
        return objectStreamClass;
    }

    public final String getName() {
        return this.name;
    }

    public final long getSerialVersionUID() {
        if (this.hasSerialVersionUIDField) {
            return this.suid;
        }
        return this.computedSuid;
    }

    public final long getSerialVersionUID(boolean bl) {
        if (bl && this.mayNeedOldSUID) {
            return this.computedSuid;
        }
        return this.getSerialVersionUID();
    }

    public final String getSerialVersionUIDStr() {
        if (this.hasSerialVersionUIDField) {
            if (this.suidStr == null) {
                this.suidStr = Long.toHexString(this.suid).toUpperCase();
            }
            return this.suidStr;
        }
        if (this.suidStr == null) {
            this.suidStr = Long.toHexString(this.computedSuid).toUpperCase();
        }
        return this.suidStr;
    }

    public final long getActualSerialVersionUID(boolean bl) {
        if (bl) {
            return this.oldComputedHashCode;
        }
        return this.computedHashCode;
    }

    public final Class forClass() {
        return this.ofClass;
    }

    public Class getType() {
        return this.ofClass;
    }

    public ObjectStreamField[] getFields() {
        if (this.fields.length > 0) {
            ObjectStreamField[] objectStreamFieldArray = new ObjectStreamField[this.fields.length];
            System.arraycopy(this.fields, 0, objectStreamFieldArray, 0, this.fields.length);
            return objectStreamFieldArray;
        }
        return this.fields;
    }

    public ObjectStreamField[] getLocalFields() {
        if (this.localFields.length > 0) {
            ObjectStreamField[] objectStreamFieldArray = new ObjectStreamField[this.localFields.length];
            System.arraycopy(this.localFields, 0, objectStreamFieldArray, 0, this.localFields.length);
            return objectStreamFieldArray;
        }
        return this.localFields;
    }

    public boolean hasSerialVersionUIDField() {
        return this.hasSerialVersionUIDField;
    }

    ObjectStreamField getField(ValueMember valueMember) throws InvalidClassException {
        int n = 0;
        while (n < this.fields.length) {
            if (this.fields[n].getName().equals(valueMember.name)) {
                Class clazz = this.fields[n].getType();
                Class clazz2 = ValueUtility.getType(valueMember);
                if (clazz.isPrimitive() || clazz2.isPrimitive()) {
                    if (clazz == clazz2) {
                        return this.fields[n];
                    }
                    throw new InvalidClassException(this.getName(), "The type of field " + valueMember.name + " is incompatible");
                }
                return this.fields[n];
            }
            ++n;
        }
        return null;
    }

    final ObjectStreamField[] getFieldsNoCopy() {
        return this.fields;
    }

    public final ObjectStreamField getField(String string) {
        int n = this.fields.length - 1;
        while (n >= 0) {
            if (string.equals(this.fields[n].getName())) {
                return this.fields[n];
            }
            --n;
        }
        return null;
    }

    public Serializable writeReplace(Serializable serializable) {
        if (this.writeReplaceObjectMethod != null) {
            try {
                return (Serializable)this.writeReplaceObjectMethod.invoke(serializable, noArgsList);
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                ORBRas.orbTrcLogger.trace(4104L, (Object)this, "writeReplace:463", throwable.toString(), (Object)throwable);
                throw new RuntimeException(throwable.getMessage());
            }
        }
        return serializable;
    }

    public Object readResolve(Object object) {
        Object object2;
        if (this.readResolveObjectMethod == null) {
            return object;
        }
        try {
            object2 = this.readResolveObjectMethod.invoke(object, noArgsList);
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(8208L, this, "readResolve:487", object2 == null ? "null" : object2.getClass().getName());
            }
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            ORBRas.orbTrcLogger.trace(4104L, (Object)this, "readResolve:495", throwable.toString(), (Object)throwable);
            throw new RuntimeException(throwable.getMessage());
        }
        return object2;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.name);
        stringBuffer.append(": static final long serialVersionUID = ");
        stringBuffer.append(Long.toString(this.suid));
        stringBuffer.append("L;");
        return stringBuffer.toString();
    }

    private ObjectStreamClass(Class clazz, ObjectStreamClass objectStreamClass, boolean bl, boolean bl2) {
        this.ofClass = clazz;
        this.name = clazz.getName();
        this.superclass = objectStreamClass;
        this.serializable = bl;
        this.externalizable = bl2;
        ObjectStreamClass.insertDescriptorFor(this);
    }

    private synchronized void init() {
        Class[] classArray;
        block51: {
            block50: {
                block49: {
                    if (this.fields != null) {
                        return;
                    }
                    if (!this.serializable || this.externalizable || this.name.equals("java.lang.String")) {
                        this.fields = new ObjectStreamField[0];
                        this.localFields = new ObjectStreamField[0];
                    } else if (this.serializable) {
                        int n;
                        ObjectStreamField[] objectStreamFieldArray;
                        int n2;
                        Object[] objectArray;
                        try {
                            objectArray = new Class[]{class$java$io$ObjectOutputStream == null ? (class$java$io$ObjectOutputStream = ObjectStreamClass.class$("java.io.ObjectOutputStream")) : class$java$io$ObjectOutputStream};
                            this.writeObjectMethod = ObjectStreamClass.getDeclaredMethod(this.ofClass, "writeObject", (Class[])objectArray);
                            this.hasWriteObjectMethod = true;
                            n2 = this.writeObjectMethod.getModifiers();
                            if (!Modifier.isPrivate(n2) || Modifier.isStatic(n2)) {
                                this.writeObjectMethod = null;
                                this.hasWriteObjectMethod = false;
                            } else {
                                ObjectStreamClass.setAccessible(this.writeObjectMethod);
                            }
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            // empty catch block
                        }
                        try {
                            objectArray = ObjectStreamClass.getDeclaredField(this.ofClass, "serialPersistentFields");
                            n2 = objectArray.getModifiers();
                            if (Modifier.isPrivate(n2) && Modifier.isStatic(n2) && Modifier.isFinal(n2) && objectArray.getType().isAssignableFrom(array$Ljava$io$ObjectStreamField == null ? (array$Ljava$io$ObjectStreamField = ObjectStreamClass.class$("[Ljava.io.ObjectStreamField;")) : array$Ljava$io$ObjectStreamField)) {
                                ObjectStreamClass.setAccessible((AccessibleObject)objectArray);
                                this.hasSerialPersistentFields = true;
                                this.fields = (ObjectStreamField[])InputStreamHook.translateFields((Object[])objectArray.get(this.ofClass));
                            }
                        }
                        catch (NoSuchFieldException noSuchFieldException) {
                            this.fields = null;
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            if (ORBRas.isTrcLogging) {
                                ORBRas.orbTrcLogger.trace(4112L, this, "init:612", illegalAccessException.toString());
                            }
                            this.fields = null;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            if (ORBRas.isTrcLogging) {
                                ORBRas.orbTrcLogger.trace(4112L, this, "init:620", illegalArgumentException.toString());
                            }
                            this.fields = null;
                        }
                        catch (SecurityException securityException) {
                            if (ORBRas.isTrcLogging) {
                                ORBRas.orbTrcLogger.trace(4112L, this, "init:628", securityException.toString());
                            }
                            this.fields = null;
                        }
                        if (this.fields == null) {
                            objectArray = ObjectStreamClass.getDeclaredFields(this.ofClass, true);
                            int n3 = 0;
                            objectStreamFieldArray = new ObjectStreamField[objectArray.length];
                            int n4 = 0;
                            while (n4 < objectArray.length) {
                                n = ((Field)objectArray[n4]).getModifiers();
                                if (!Modifier.isStatic(n) && !Modifier.isTransient(n)) {
                                    objectStreamFieldArray[n3++] = new ObjectStreamField((Field)objectArray[n4]);
                                }
                                ++n4;
                            }
                            this.fields = new ObjectStreamField[n3];
                            System.arraycopy(objectStreamFieldArray, 0, this.fields, 0, n3);
                        } else {
                            int n5 = this.fields.length - 1;
                            while (n5 >= 0) {
                                block48: {
                                    try {
                                        Field field = ObjectStreamClass.getDeclaredField(this.ofClass, this.fields[n5].getName());
                                        if (this.fields[n5].getType() == field.getType()) {
                                            this.fields[n5].setField(field);
                                        }
                                    }
                                    catch (NoSuchFieldException noSuchFieldException) {
                                        if (this.hasWriteObjectMethod) break block48;
                                        ORBRas.orbTrcLogger.exception(4104L, this, "init:686", (Exception)noSuchFieldException);
                                        throw new MARSHAL("serialPersistentFields member has superset of fields in local version of class and no writeObject() method defined.", 1229125822, CompletionStatus.COMPLETED_NO);
                                    }
                                }
                                --n5;
                            }
                        }
                        if (this.fields.length > 1) {
                            Arrays.sort(this.fields);
                        }
                        this.computeFieldInfo();
                        if (this.localFields == null) {
                            Field[] fieldArray = ObjectStreamClass.getDeclaredFields(this.ofClass, true);
                            int n6 = 0;
                            objectStreamFieldArray = new ObjectStreamField[fieldArray.length];
                            int n7 = 0;
                            while (n7 < fieldArray.length) {
                                n = fieldArray[n7].getModifiers();
                                if (!Modifier.isStatic(n) && !Modifier.isTransient(n)) {
                                    objectStreamFieldArray[n6++] = new ObjectStreamField(fieldArray[n7]);
                                }
                                ++n7;
                            }
                            this.localFields = new ObjectStreamField[n6];
                            System.arraycopy(objectStreamFieldArray, 0, this.localFields, 0, n6);
                            if (this.localFields.length > 1) {
                                Arrays.sort(this.localFields);
                            }
                        }
                    }
                    try {
                        classArray = ObjectStreamClass.getDeclaredField(this.ofClass, "serialVersionUID");
                        int n = classArray.getModifiers();
                        if (Modifier.isStatic(n) && Modifier.isFinal(n)) {
                            this.hasSerialVersionUIDField = true;
                            ObjectStreamClass.setAccessible((AccessibleObject)classArray);
                            try {
                                this.suid = classArray.getLong(null);
                            }
                            catch (IllegalAccessException illegalAccessException) {
                                ORBRas.orbTrcLogger.exception(4104L, this, "init:752", (Exception)illegalAccessException);
                                throw new NoSuchFieldException();
                            }
                            this.computedHashCode = ObjectStreamClass.computeHashCode(this, this.ofClass, false);
                            this.oldComputedHashCode = ObjectStreamClass.computeHashCode(this, this.ofClass, true);
                            if (!Modifier.isPrivate(n)) {
                                this.mayNeedOldSUID = true;
                            }
                            break block49;
                        }
                        this.hasSerialVersionUIDField = false;
                        this.suid = 0L;
                        this.computedHashCode = ObjectStreamClass.computeHashCode(this, this.ofClass, false);
                        this.oldComputedHashCode = ObjectStreamClass.computeHashCode(this, this.ofClass, true);
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        this.hasSerialVersionUIDField = false;
                        this.suid = 0L;
                        this.computedHashCode = ObjectStreamClass.computeHashCode(this, this.ofClass, false);
                        this.oldComputedHashCode = ObjectStreamClass.computeHashCode(this, this.ofClass, true);
                    }
                }
                this.computedSuid = ObjectStreamClass._computeSerialVersionUID(this, this.ofClass);
                try {
                    this.writeReplaceObjectMethod = ObjectStreamClass.getDeclaredMethod(this.ofClass, "writeReplace", noTypesList);
                    if (Modifier.isStatic(this.writeReplaceObjectMethod.getModifiers())) {
                        this.writeReplaceObjectMethod = null;
                    } else {
                        ObjectStreamClass.setAccessible(this.writeReplaceObjectMethod);
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    if (this.superclass == null || !this.checkSuperMethodAccess(this.superclass.writeReplaceObjectMethod)) break block50;
                    this.writeReplaceObjectMethod = this.superclass.writeReplaceObjectMethod;
                }
            }
            try {
                this.readResolveObjectMethod = ObjectStreamClass.getDeclaredMethod(this.ofClass, "readResolve", noTypesList);
                if (Modifier.isStatic(this.readResolveObjectMethod.getModifiers())) {
                    this.readResolveObjectMethod = null;
                } else {
                    ObjectStreamClass.setAccessible(this.readResolveObjectMethod);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (this.superclass == null || !this.checkSuperMethodAccess(this.superclass.readResolveObjectMethod)) break block51;
                this.readResolveObjectMethod = this.superclass.readResolveObjectMethod;
            }
        }
        try {
            classArray = new Class[]{class$java$io$ObjectInputStream == null ? (class$java$io$ObjectInputStream = ObjectStreamClass.class$("java.io.ObjectInputStream")) : class$java$io$ObjectInputStream};
            this.readObjectMethod = ObjectStreamClass.getDeclaredMethod(this.ofClass, "readObject", classArray);
            int n = this.readObjectMethod.getModifiers();
            if (!Modifier.isPrivate(n) || Modifier.isStatic(n)) {
                this.readObjectMethod = null;
            } else {
                ObjectStreamClass.setAccessible(this.readObjectMethod);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    ObjectStreamClass(String string, long l) {
        this.name = string;
        this.suid = l;
        this.superclass = null;
    }

    final void setClass(Class clazz) throws InvalidClassException {
        if (clazz == null) {
            this.localClassDesc = null;
            this.ofClass = null;
            this.computeFieldInfo();
            return;
        }
        this.localClassDesc = ObjectStreamClass.lookupInternal(clazz);
        if (this.localClassDesc == null) {
            throw new InvalidClassException(clazz.getName(), "Local class not compatible");
        }
        if (this.suid != this.localClassDesc.suid && (!clazz.isArray() || clazz.getName().equals(this.name))) {
            throw new InvalidClassException(clazz.getName(), "Local class not compatible: stream classdesc serialVersionUID=" + this.suid + " local class serialVersionUID=" + this.localClassDesc.suid);
        }
        if (!ObjectStreamClass.compareClassNames(this.name, clazz.getName(), '.')) {
            throw new InvalidClassException(this.name, "Incompatible local class name: " + clazz.getName());
        }
        if (this.serializable != this.localClassDesc.serializable || this.externalizable != this.localClassDesc.externalizable) {
            throw new InvalidClassException(clazz.getName(), "Serialization incompatible with Externalization");
        }
        ObjectStreamField[] objectStreamFieldArray = this.localClassDesc.fields;
        ObjectStreamField[] objectStreamFieldArray2 = this.fields;
        int n = 0;
        int n2 = 0;
        while (n2 < objectStreamFieldArray2.length) {
            int n3 = n;
            while (n3 < objectStreamFieldArray.length) {
                if (objectStreamFieldArray2[n2].getName().equals(objectStreamFieldArray[n3].getName())) {
                    if (objectStreamFieldArray2[n2].isPrimitive() && !objectStreamFieldArray2[n2].typeEquals(objectStreamFieldArray[n3])) {
                        throw new InvalidClassException(clazz.getName(), "The type of field " + objectStreamFieldArray2[n2].getName() + " of class " + this.name + " is incompatible.");
                    }
                    n = n3;
                    objectStreamFieldArray2[n2].setField(objectStreamFieldArray[n].getField());
                    break;
                }
                ++n3;
            }
            ++n2;
        }
        this.computeFieldInfo();
        this.ofClass = clazz;
        try {
            Class[] classArray = new Class[]{class$java$io$ObjectInputStream == null ? (class$java$io$ObjectInputStream = ObjectStreamClass.class$("java.io.ObjectInputStream")) : class$java$io$ObjectInputStream};
            this.readObjectMethod = ObjectStreamClass.getDeclaredMethod(clazz, "readObject", classArray);
            int n4 = this.readObjectMethod.getModifiers();
            if (!Modifier.isPrivate(n4) || Modifier.isStatic(n4)) {
                this.readObjectMethod = null;
            } else {
                ObjectStreamClass.setAccessible(this.readObjectMethod);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    static boolean compareClassNames(String string, String string2, char c) {
        int n;
        int n2 = string.lastIndexOf(c);
        if (n2 < 0) {
            n2 = 0;
        }
        if ((n = string2.lastIndexOf(c)) < 0) {
            n = 0;
        }
        return string.regionMatches(false, n2, string2, n, string.length() - n2);
    }

    final boolean typeEquals(ObjectStreamClass objectStreamClass) {
        return this.suid == objectStreamClass.suid && ObjectStreamClass.compareClassNames(this.name, objectStreamClass.name, '.');
    }

    final void setSuperclass(ObjectStreamClass objectStreamClass) {
        this.superclass = objectStreamClass;
    }

    final ObjectStreamClass getSuperclass() {
        return this.superclass;
    }

    final boolean hasWriteObject() {
        return this.hasWriteObjectMethod;
    }

    public final boolean isCustomMarshaled() {
        return this.hasWriteObject() || this.isExternalizable();
    }

    public final boolean isCustomIDL() {
        return this.isCustomMarshaled() || this.superclass != null && this.superclass.isCustomIDL();
    }

    boolean hasExternalizableBlockDataMode() {
        return this.hasExternalizableBlockData;
    }

    final ObjectStreamClass localClassDescriptor() {
        return this.localClassDesc;
    }

    boolean isSerializable() {
        return this.serializable;
    }

    boolean isExternalizable() {
        return this.externalizable;
    }

    private void computeFieldInfo() {
        this.primBytes = 0;
        this.objFields = 0;
        int n = 0;
        while (n < this.fields.length) {
            switch (this.fields[n].getTypeCode()) {
                case 'B': 
                case 'Z': {
                    ++this.primBytes;
                    break;
                }
                case 'C': 
                case 'S': {
                    this.primBytes += 2;
                    break;
                }
                case 'F': 
                case 'I': {
                    this.primBytes += 4;
                    break;
                }
                case 'D': 
                case 'J': {
                    this.primBytes += 8;
                    break;
                }
                case 'L': 
                case '[': {
                    ++this.objFields;
                }
            }
            ++n;
        }
    }

    private boolean isRMIAbstractInterface() {
        if (!this.ofClass.isInterface()) {
            return false;
        }
        if ((class$java$rmi$Remote == null ? (class$java$rmi$Remote = ObjectStreamClass.class$("java.rmi.Remote")) : class$java$rmi$Remote).isAssignableFrom(this.ofClass)) {
            return false;
        }
        Method[] methodArray = ObjectStreamClass.getDeclaredMethods(this.ofClass);
        int n = methodArray.length - 1;
        while (n > -1) {
            Class[] classArray = methodArray[n].getExceptionTypes();
            if (classArray.length == 0) {
                return false;
            }
            int n2 = classArray.length - 1;
            while (n2 > -1) {
                if ((class$java$rmi$RemoteException == null ? ObjectStreamClass.class$("java.rmi.RemoteException") : class$java$rmi$RemoteException) == classArray[n2] || (class$java$lang$Throwable == null ? ObjectStreamClass.class$("java.lang.Throwable") : class$java$lang$Throwable) == classArray[n2] || (class$java$lang$Exception == null ? ObjectStreamClass.class$("java.lang.Exception") : class$java$lang$Exception) == classArray[n2] || (class$java$io$IOException == null ? ObjectStreamClass.class$("java.io.IOException") : class$java$io$IOException) == classArray[n2]) break;
                if (n2 == 0) {
                    return false;
                }
                --n2;
            }
            --n;
        }
        return this.superclass == null || this.superclass.isAbstractInterface();
    }

    private static long _computeSerialVersionUID(ObjectStreamClass objectStreamClass, Class clazz) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
        long l = 0L;
        try {
            Object object;
            Object object2;
            int n;
            MethodSignature[] methodSignatureArray;
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            DigestOutputStream digestOutputStream = new DigestOutputStream(byteArrayOutputStream, messageDigest);
            DataOutputStream dataOutputStream = new DataOutputStream(digestOutputStream);
            dataOutputStream.writeUTF(clazz.getName());
            int n2 = clazz.getModifiers();
            Member[] memberArray = ObjectStreamClass.getDeclaredMethods(clazz);
            if (((n2 &= 0x611) & 0x200) != 0) {
                n2 &= 0xFFFFFBFF;
                if (memberArray.length > 0) {
                    n2 |= 0x400;
                }
            }
            dataOutputStream.writeInt(n2);
            Object[] objectArray = clazz.getInterfaces();
            Arrays.sort(objectArray, compareClassByName);
            int n3 = 0;
            while (n3 < objectArray.length) {
                dataOutputStream.writeUTF(((Class)objectArray[n3]).getName());
                ++n3;
            }
            Object[] objectArray2 = ObjectStreamClass.getDeclaredFields(clazz);
            Arrays.sort(objectArray2, compareMemberByName);
            int n4 = 0;
            while (n4 < objectArray2.length) {
                methodSignatureArray = objectArray2[n4];
                n = methodSignatureArray.getModifiers();
                if (!Modifier.isPrivate(n) || !Modifier.isTransient(n) && !Modifier.isStatic(n)) {
                    dataOutputStream.writeUTF(methodSignatureArray.getName());
                    dataOutputStream.writeInt(n);
                    dataOutputStream.writeUTF(ObjectStreamClass.getSignature(methodSignatureArray.getType()));
                }
                ++n4;
            }
            if (ObjectStreamClass.hasStaticInitializer(clazz)) {
                dataOutputStream.writeUTF("<clinit>");
                dataOutputStream.writeInt(8);
                dataOutputStream.writeUTF("()V");
            }
            methodSignatureArray = MethodSignature.removePrivateAndSort(ObjectStreamClass.getDeclaredConstructors(clazz));
            n = 0;
            while (n < methodSignatureArray.length) {
                object2 = methodSignatureArray[n];
                String string = "<init>";
                object = object2.signature;
                object = ((String)object).replace('/', '.');
                dataOutputStream.writeUTF(string);
                dataOutputStream.writeInt(object2.member.getModifiers());
                dataOutputStream.writeUTF((String)object);
                ++n;
            }
            object2 = MethodSignature.removePrivateAndSort(memberArray);
            int n5 = 0;
            while (n5 < ((MethodSignature[])object2).length) {
                object = object2[n5];
                String string = ((MethodSignature)object).signature;
                string = string.replace('/', '.');
                dataOutputStream.writeUTF(((MethodSignature)object).member.getName());
                dataOutputStream.writeInt(((MethodSignature)object).member.getModifiers());
                dataOutputStream.writeUTF(string);
                ++n5;
            }
            dataOutputStream.flush();
            object = messageDigest.digest();
            int n6 = 0;
            while (n6 < Math.min(8, ((Object)object).length)) {
                l += (long)(object[n6] & 0xFF) << n6 * 8;
                ++n6;
            }
        }
        catch (IOException iOException) {
            l = -1L;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            ORBRas.orbTrcLogger.exception(4104L, thisClassName, "_computeSerialVersionUID:1286", (Exception)noSuchAlgorithmException);
            throw new SecurityException(noSuchAlgorithmException.getMessage());
        }
        return l;
    }

    private static long computeHashCode(ObjectStreamClass objectStreamClass, Class clazz, boolean bl) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
        long l = 0L;
        try {
            int n;
            int n2;
            Object[] objectArray;
            Object[] objectArray2;
            if (!(class$java$io$Serializable == null ? (class$java$io$Serializable = ObjectStreamClass.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(clazz) || clazz.isInterface()) {
                return 0L;
            }
            if ((class$java$io$Externalizable == null ? (class$java$io$Externalizable = ObjectStreamClass.class$("java.io.Externalizable")) : class$java$io$Externalizable).isAssignableFrom(clazz)) {
                return 1L;
            }
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            DigestOutputStream digestOutputStream = new DigestOutputStream(byteArrayOutputStream, messageDigest);
            DataOutputStream dataOutputStream = new DataOutputStream(digestOutputStream);
            Class clazz2 = clazz.getSuperclass();
            if (!(clazz2 == null || bl && clazz2 == (class$java$lang$Object == null ? (class$java$lang$Object = ObjectStreamClass.class$("java.lang.Object")) : class$java$lang$Object))) {
                dataOutputStream.writeLong(ObjectStreamClass.computeHashCode(ObjectStreamClass.lookup(clazz2), clazz2, bl));
            }
            if (objectStreamClass.hasWriteObject() && !bl) {
                dataOutputStream.writeInt(2);
            } else {
                dataOutputStream.writeInt(1);
            }
            if (bl) {
                objectArray2 = objectStreamClass.getLocalFields();
                objectArray = new Field[objectArray2.length];
                n2 = 0;
                while (n2 < objectArray2.length) {
                    objectArray[n2] = objectArray2[n2].getField();
                    ++n2;
                }
                Arrays.sort(objectArray, compareMemberByName);
                n = 0;
                while (n < objectArray.length) {
                    Object object = objectArray[n];
                    int n3 = ((Field)object).getModifiers();
                    if (!Modifier.isTransient(n3) && !Modifier.isStatic(n3)) {
                        dataOutputStream.writeUTF(((Field)object).getName());
                        dataOutputStream.writeUTF(ObjectStreamClass.getSignature(((Field)object).getType()));
                    }
                    ++n;
                }
            } else {
                objectArray2 = objectStreamClass.getFields();
                objectArray = new PersistentField[objectArray2.length];
                n2 = 0;
                while (n2 < objectArray2.length) {
                    objectArray[n2] = new PersistentField(objectArray2[n2].getName(), objectArray2[n2].getSignature());
                    ++n2;
                }
                Arrays.sort(objectArray);
                n = 0;
                while (n < objectArray.length) {
                    dataOutputStream.writeUTF(((PersistentField)objectArray[n]).getName());
                    dataOutputStream.writeUTF(((PersistentField)objectArray[n]).getSignature());
                    ++n;
                }
            }
            dataOutputStream.flush();
            objectArray2 = messageDigest.digest();
            if (bl) {
                int n4;
                n2 = n4 = Math.min(8, objectArray2.length);
                while (n2 > 0) {
                    l += (long)(objectArray2[n2] & 0xFF) << n2 * 8;
                    --n2;
                }
            } else {
                int n5 = 0;
                while (n5 < Math.min(8, objectArray2.length)) {
                    l += (long)(objectArray2[n5] & 0xFF) << n5 * 8;
                    ++n5;
                }
            }
        }
        catch (IOException iOException) {
            l = -1L;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            ORBRas.orbTrcLogger.exception(4104L, thisClassName, "computeHashCode:1423", (Exception)noSuchAlgorithmException);
            throw new SecurityException(noSuchAlgorithmException.getMessage());
        }
        return l;
    }

    static String getSignature(Class clazz) {
        String string = null;
        if (clazz.isArray()) {
            Class clazz2 = clazz;
            int n = 0;
            while (clazz2.isArray()) {
                ++n;
                clazz2 = clazz2.getComponentType();
            }
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while (n2 < n) {
                stringBuffer.append("[");
                ++n2;
            }
            stringBuffer.append(ObjectStreamClass.getSignature(clazz2));
            string = stringBuffer.toString();
        } else if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                string = "I";
            } else if (clazz == Byte.TYPE) {
                string = "B";
            } else if (clazz == Long.TYPE) {
                string = "J";
            } else if (clazz == Float.TYPE) {
                string = "F";
            } else if (clazz == Double.TYPE) {
                string = "D";
            } else if (clazz == Short.TYPE) {
                string = "S";
            } else if (clazz == Character.TYPE) {
                string = "C";
            } else if (clazz == Boolean.TYPE) {
                string = "Z";
            } else if (clazz == Void.TYPE) {
                string = "V";
            }
        } else {
            string = "L" + clazz.getName().replace('.', '/') + ";";
        }
        return string;
    }

    static String getSignature(Method method) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        Class[] classArray = method.getParameterTypes();
        int n = 0;
        while (n < classArray.length) {
            stringBuffer.append(ObjectStreamClass.getSignature(classArray[n]));
            ++n;
        }
        stringBuffer.append(")");
        stringBuffer.append(ObjectStreamClass.getSignature(method.getReturnType()));
        return stringBuffer.toString();
    }

    static String getSignature(Constructor constructor) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        Class[] classArray = constructor.getParameterTypes();
        int n = 0;
        while (n < classArray.length) {
            stringBuffer.append(ObjectStreamClass.getSignature(classArray[n]));
            ++n;
        }
        stringBuffer.append(")V");
        return stringBuffer.toString();
    }

    private static ObjectStreamClass findDescriptorFor(Class clazz) {
        ObjectStreamClassEntry objectStreamClassEntry;
        int n = clazz.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % descriptorFor.length;
        while ((objectStreamClassEntry = descriptorFor[n2]) != null && objectStreamClassEntry.get() == null) {
            ObjectStreamClass.descriptorFor[n2] = objectStreamClassEntry.next;
        }
        ObjectStreamClassEntry objectStreamClassEntry2 = objectStreamClassEntry;
        while (objectStreamClassEntry != null) {
            ObjectStreamClass objectStreamClass = (ObjectStreamClass)objectStreamClassEntry.get();
            if (objectStreamClass == null) {
                objectStreamClassEntry2.next = objectStreamClassEntry.next;
            } else {
                if (objectStreamClass.ofClass == clazz) {
                    return objectStreamClass;
                }
                objectStreamClassEntry2 = objectStreamClassEntry;
            }
            objectStreamClassEntry = objectStreamClassEntry.next;
        }
        return null;
    }

    private static void insertDescriptorFor(ObjectStreamClass objectStreamClass) {
        if (ObjectStreamClass.findDescriptorFor(objectStreamClass.ofClass) != null) {
            return;
        }
        int n = objectStreamClass.ofClass.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % descriptorFor.length;
        ObjectStreamClassEntry objectStreamClassEntry = new ObjectStreamClassEntry(objectStreamClass);
        objectStreamClassEntry.next = descriptorFor[n2];
        ObjectStreamClass.descriptorFor[n2] = objectStreamClassEntry;
    }

    private static Field getDeclaredField(final Class clazz, final String string) throws NoSuchFieldException {
        try {
            return (Field)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws NoSuchFieldException {
                    return clazz.getDeclaredField(string);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            if (!(privilegedActionException.getException() instanceof NoSuchFieldException)) {
                ORBRas.orbTrcLogger.exception(4104L, thisClassName, "getDeclaredField:1581", (Exception)privilegedActionException);
            }
            throw (NoSuchFieldException)privilegedActionException.getException();
        }
    }

    private static Field[] getDeclaredFields(Class clazz) {
        return ObjectStreamClass.getDeclaredFields(clazz, false);
    }

    private static Field[] getDeclaredFields(final Class clazz, final boolean bl) {
        return (Field[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                AccessibleObject[] accessibleObjectArray = clazz.getDeclaredFields();
                if (bl) {
                    AccessibleObject.setAccessible(accessibleObjectArray, true);
                }
                return accessibleObjectArray;
            }
        });
    }

    private static Method getDeclaredMethod(final Class clazz, final String string, final Class[] classArray) throws NoSuchMethodException {
        try {
            return (Method)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws NoSuchMethodException {
                    return clazz.getDeclaredMethod(string, classArray);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            if (!(privilegedActionException.getException() instanceof NoSuchMethodException)) {
                ORBRas.orbTrcLogger.exception(4104L, thisClassName, "getDeclaredMethod:1624", (Exception)privilegedActionException);
            }
            throw (NoSuchMethodException)privilegedActionException.getException();
        }
    }

    private static Method[] getDeclaredMethods(final Class clazz) {
        return (Method[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return clazz.getDeclaredMethods();
            }
        });
    }

    private static Constructor[] getDeclaredConstructors(final Class clazz) {
        return (Constructor[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return clazz.getDeclaredConstructors();
            }
        });
    }

    private static void setAccessible(final AccessibleObject accessibleObject) throws SecurityException {
        if (accessibleObject != null && !accessibleObject.isAccessible()) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    accessibleObject.setAccessible(true);
                    return null;
                }
            });
        }
    }

    private static boolean hasStaticInitializer(Class clazz) {
        try {
            return (Boolean)methodHasStaticInitializer.invoke(null, new Object[]{clazz});
        }
        catch (Exception exception) {
            ORBRas.orbTrcLogger.exception(4104L, thisClassName, "hasStaticInitializer:1761", exception);
            throw new RuntimeException(exception.getMessage());
        }
    }

    private boolean checkSuperMethodAccess(Method method) {
        if (method == null) {
            return false;
        }
        int n = method.getModifiers();
        if (Modifier.isPublic(n) || Modifier.isProtected(n)) {
            return true;
        }
        if (Modifier.isPrivate(n)) {
            return false;
        }
        return ObjectStreamClass.isSameClassPackage(method.getDeclaringClass(), this.ofClass);
    }

    private static boolean isSameClassPackage(Class clazz, Class clazz2) {
        if (clazz.getClassLoader() != clazz2.getClassLoader()) {
            return false;
        }
        String string = clazz.getName();
        String string2 = clazz2.getName();
        int n = string.lastIndexOf(46);
        int n2 = string2.lastIndexOf(46);
        if (n == -1 || n2 == -1) {
            return n == n2;
        }
        return string.regionMatches(false, 0, string2, 0, n - 1);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            methodHasStaticInitializer = ObjectStreamClass.getDeclaredMethod(class$java$io$ObjectStreamClass == null ? (class$java$io$ObjectStreamClass = ObjectStreamClass.class$("java.io.ObjectStreamClass")) : class$java$io$ObjectStreamClass, "hasStaticInitializer", new Class[]{class$java$lang$Class == null ? (class$java$lang$Class = ObjectStreamClass.class$("java.lang.Class")) : class$java$lang$Class});
        }
        catch (NoSuchMethodException noSuchMethodException) {
            ORBRas.orbTrcLogger.exception(4104L, thisClassName, "<clinit>:129", (Exception)noSuchMethodException);
            throw new RuntimeException(noSuchMethodException.getMessage());
        }
        ObjectStreamClass.setAccessible(methodHasStaticInitializer);
        descriptorFor = new ObjectStreamClassEntry[61];
        descTable = new Hashtable();
        classSerializable = class$java$io$Serializable == null ? (class$java$io$Serializable = ObjectStreamClass.class$("java.io.Serializable")) : class$java$io$Serializable;
        classExternalizable = class$java$io$Externalizable == null ? (class$java$io$Externalizable = ObjectStreamClass.class$("java.io.Externalizable")) : class$java$io$Externalizable;
        compareClassByName = new CompareClassByName();
        compareObjectStreamFieldByName = new CompareObjectStreamFieldByName();
        compareMemberByName = new CompareMemberByName();
    }

    private static class PersistentField
    implements Comparable {
        String name;
        String signature;

        public PersistentField(String string, String string2) {
            this.name = string;
            this.signature = string2;
            int n = 0;
            while (n < string2.length() && string2.charAt(n) == '[') {
                ++n;
            }
            if (string2.charAt(n) == 'L' && !string2.endsWith(";")) {
                this.signature = string2 + ";";
            }
        }

        public String getName() {
            return this.name;
        }

        public String getSignature() {
            return this.signature;
        }

        public int compareTo(Object object) {
            return this.name.compareTo(((PersistentField)object).getName());
        }
    }

    private static class MethodSignature
    implements Comparator {
        Member member;
        String signature;

        static MethodSignature[] removePrivateAndSort(Member[] memberArray) {
            int n = 0;
            int n2 = 0;
            while (n2 < memberArray.length) {
                if (!Modifier.isPrivate(memberArray[n2].getModifiers())) {
                    ++n;
                }
                ++n2;
            }
            Object[] objectArray = new MethodSignature[n];
            int n3 = 0;
            int n4 = 0;
            while (n4 < memberArray.length) {
                if (!Modifier.isPrivate(memberArray[n4].getModifiers())) {
                    objectArray[n3] = new MethodSignature(memberArray[n4]);
                    ++n3;
                }
                ++n4;
            }
            if (n3 > 0) {
                Arrays.sort(objectArray, objectArray[0]);
            }
            return objectArray;
        }

        public int compare(Object object, Object object2) {
            int n;
            if (object == object2) {
                return 0;
            }
            MethodSignature methodSignature = (MethodSignature)object;
            MethodSignature methodSignature2 = (MethodSignature)object2;
            if (this.isConstructor()) {
                n = methodSignature.signature.compareTo(methodSignature2.signature);
            } else {
                n = methodSignature.member.getName().compareTo(methodSignature2.member.getName());
                if (n == 0) {
                    n = methodSignature.signature.compareTo(methodSignature2.signature);
                }
            }
            return n;
        }

        private final boolean isConstructor() {
            return this.member instanceof Constructor;
        }

        private MethodSignature(Member member) {
            this.member = member;
            this.signature = this.isConstructor() ? ObjectStreamClass.getSignature((Constructor)member) : ObjectStreamClass.getSignature((Method)member);
        }
    }

    private static class CompareMemberByName
    implements Comparator {
        private CompareMemberByName() {
        }

        public int compare(Object object, Object object2) {
            String string = ((Member)object).getName();
            String string2 = ((Member)object2).getName();
            if (object instanceof Method) {
                string = string + ObjectStreamClass.getSignature((Method)object);
                string2 = string2 + ObjectStreamClass.getSignature((Method)object2);
            } else if (object instanceof Constructor) {
                string = string + ObjectStreamClass.getSignature((Constructor)object);
                string2 = string2 + ObjectStreamClass.getSignature((Constructor)object2);
            }
            return string.compareTo(string2);
        }
    }

    private static class CompareObjectStreamFieldByName
    implements Comparator {
        private CompareObjectStreamFieldByName() {
        }

        public int compare(Object object, Object object2) {
            String string = ((ObjectStreamField)object).getName();
            String string2 = ((ObjectStreamField)object2).getName();
            return string.compareTo(string2);
        }
    }

    private static class CompareClassByName
    implements Comparator {
        private CompareClassByName() {
        }

        public int compare(Object object, Object object2) {
            Class clazz = (Class)object;
            Class clazz2 = (Class)object2;
            return clazz.getName().compareTo(clazz2.getName());
        }
    }

    private static class ObjectStreamClassEntry {
        ObjectStreamClassEntry next;
        private ObjectStreamClass c;

        ObjectStreamClassEntry(ObjectStreamClass objectStreamClass) {
            this.c = objectStreamClass;
        }

        public Object get() {
            return this.c;
        }
    }
}

