/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.poa;

import com.ibm.CORBA.ras.ORBRas;
import com.ibm.rmi.corba.LocalObjectImpl;
import com.ibm.rmi.iiop.ORB;
import org.omg.CORBA.Any;
import org.omg.CORBA.Policy;
import org.omg.CORBA.PolicyError;
import org.omg.PortableInterceptor.PolicyFactory;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.IdUniquenessPolicyValue;
import org.omg.PortableServer.ImplicitActivationPolicyValue;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.RequestProcessingPolicyValue;
import org.omg.PortableServer.ServantRetentionPolicyValue;
import org.omg.PortableServer.ThreadPolicyValue;

public class PolicyFactoryImpl
extends LocalObjectImpl
implements PolicyFactory {
    public PolicyFactoryImpl(ORB oRB) {
        super(oRB);
    }

    public static void initialize(ORB oRB) {
        PolicyFactoryImpl policyFactoryImpl = new PolicyFactoryImpl(oRB);
        policyFactoryImpl.registerPolicies();
    }

    private void registerPolicies() {
        this.orb.register_policy_factory(16, this);
        this.orb.register_policy_factory(17, this);
        this.orb.register_policy_factory(18, this);
        this.orb.register_policy_factory(19, this);
        this.orb.register_policy_factory(21, this);
        this.orb.register_policy_factory(22, this);
        this.orb.register_policy_factory(20, this);
    }

    public Policy create_policy(int n, Any any) throws PolicyError {
        try {
            POA pOA = (POA)this.orb.resolve_initial_references("RootPOA");
            switch (n) {
                case 16: {
                    return pOA.create_thread_policy(ThreadPolicyValue.from_int(any.extract_long()));
                }
                case 17: {
                    return pOA.create_lifespan_policy(LifespanPolicyValue.from_int(any.extract_long()));
                }
                case 18: {
                    return pOA.create_id_uniqueness_policy(IdUniquenessPolicyValue.from_int(any.extract_long()));
                }
                case 19: {
                    return pOA.create_id_assignment_policy(IdAssignmentPolicyValue.from_int(any.extract_long()));
                }
                case 21: {
                    return pOA.create_servant_retention_policy(ServantRetentionPolicyValue.from_int(any.extract_long()));
                }
                case 22: {
                    return pOA.create_request_processing_policy(RequestProcessingPolicyValue.from_int(any.extract_long()));
                }
                case 20: {
                    return pOA.create_implicit_activation_policy(ImplicitActivationPolicyValue.from_int(any.extract_long()));
                }
            }
        }
        catch (Exception exception) {
            ORBRas.orbTrcLogger.exception(4104L, this, "create_policy:112", exception);
            throw new PolicyError("Exception reading policy value: " + exception.toString(), 3);
        }
        throw new PolicyError("Invalid POA PolicyType: " + n, 2);
    }
}

