/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.ras;

import com.ibm.CORBA.transport.TransportConnection;
import com.ibm.rmi.iiop.CDRInputStream;
import com.ibm.rmi.ras.CancelRequestMessage;
import com.ibm.rmi.ras.CloseConnectionMessage;
import com.ibm.rmi.ras.ErrorMessage;
import com.ibm.rmi.ras.FragmentMessage;
import com.ibm.rmi.ras.LocateReplyMessage;
import com.ibm.rmi.ras.LocateRequestMessage;
import com.ibm.rmi.ras.ReplyMessage;
import com.ibm.rmi.ras.RequestMessage;
import com.ibm.rmi.ras.UnknownMessage;
import com.ibm.rmi.ras.Utility;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Date;

public abstract class Message {
    static final int GIOPRequest = 0;
    static final int GIOPReply = 1;
    static final int GIOPCancelRequest = 2;
    static final int GIOPLocateRequest = 3;
    static final int GIOPLocateReply = 4;
    static final int GIOPCloseConnection = 5;
    static final int GIOPMessageError = 6;
    static final int GIOPFragment = 7;
    protected int GIOPMajor;
    protected int GIOPMinor;
    protected short KeyAddr = 0;
    protected short ProfileAddr = 1;
    protected short ReferenceAddr = (short)2;
    protected byte[] buf = null;
    protected int size = 0;
    protected CDRInputStream is = null;
    protected int dataOffset = 0;
    private boolean dumpMsgHeader = true;
    protected PrintWriter pw = null;

    public Message(byte[] byArray, int n) {
        this.buf = byArray;
        this.size = n;
        this.setGIOPMajorMinor();
    }

    private void setGIOPMajorMinor() {
        this.GIOPMajor = this.buf[4];
        this.GIOPMinor = this.buf[5];
    }

    public byte[] buffer() {
        return this.buf;
    }

    public void dumpBuffer(PrintWriter printWriter) {
        this.pw = printWriter;
        int n = 0;
        int n2 = 1;
        while (n < this.size) {
            if (n < this.dataOffset && this.dataOffset <= n + 16) {
                this.dumpSplitRow(n);
            } else {
                this.dumpRow(n);
            }
            n = (++n2 - 1) * 16;
        }
        this.pw.println();
    }

    private void dumpRow(int n) {
        this.pw.println();
        this.dumpHex(n >> 12 & 0xF);
        this.dumpHex(n >> 8 & 0xF);
        this.dumpHex(n >> 4 & 0xF);
        this.dumpHex(n & 0xF);
        this.pw.print(": ");
        int n2 = 0;
        while (n2 < 16) {
            if (n + n2 < this.size) {
                this.dumpHex(this.buf[n + n2] >> 4 & 0xF);
                this.dumpHex(this.buf[n + n2] & 0xF);
            } else {
                this.pw.print("  ");
            }
            if ((n2 + 1) % 4 == 0) {
                this.pw.print(" ");
            }
            ++n2;
        }
        this.pw.print("  ");
        int n3 = 0;
        while (n3 < 16) {
            if (n + n3 < this.size) {
                char c = (char)this.buf[n + n3];
                if (c > '\u001f' && c < '\u0080') {
                    this.pw.print(c);
                } else {
                    this.pw.print('.');
                }
            } else {
                this.pw.print(' ');
            }
            ++n3;
        }
    }

    private void dumpSplitRow(int n) {
        char c;
        this.pw.println();
        this.dumpHex(n >> 12 & 0xF);
        this.dumpHex(n >> 8 & 0xF);
        this.dumpHex(n >> 4 & 0xF);
        this.dumpHex(n & 0xF);
        this.pw.print(": ");
        int n2 = 0;
        while (n2 < this.dataOffset - n) {
            if (n + n2 < this.size) {
                this.dumpHex(this.buf[n + n2] >> 4 & 0xF);
                this.dumpHex(this.buf[n + n2] & 0xF);
            } else {
                this.pw.print("  ");
            }
            if ((n2 + 1) % 4 == 0) {
                this.pw.print(" ");
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < 16 - this.dataOffset + n) {
            this.pw.print("  ");
            if ((n3 + 1) % 4 == 0) {
                this.pw.print(" ");
            }
            ++n3;
        }
        this.pw.print("  ");
        int n4 = 0;
        while (n4 < this.dataOffset - n) {
            if (n + n4 < this.size) {
                c = (char)this.buf[n + n4];
                if (c > '\u001f' && c < '\u0080') {
                    this.pw.print(c);
                } else {
                    this.pw.print('.');
                }
            } else {
                this.pw.print(' ');
            }
            ++n4;
        }
        this.pw.println();
        this.pw.print("      ");
        int n5 = 0;
        while (n5 < this.dataOffset - n) {
            this.pw.print("  ");
            if ((n5 + 1) % 4 == 0) {
                this.pw.print(" ");
            }
            ++n5;
        }
        int n6 = this.dataOffset - n;
        while (n6 < 16) {
            if (n + n6 < this.size) {
                this.dumpHex(this.buf[n + n6] >> 4 & 0xF);
                this.dumpHex(this.buf[n + n6] & 0xF);
            } else {
                this.pw.print("  ");
            }
            if ((n6 + 1) % 4 == 0) {
                this.pw.print(" ");
            }
            ++n6;
        }
        this.pw.print("  ");
        int n7 = 0;
        while (n7 < this.dataOffset - n) {
            this.pw.print(" ");
            ++n7;
        }
        int n8 = this.dataOffset - n;
        while (n8 < 16) {
            if (n + n8 < this.size) {
                c = (char)this.buf[n + n8];
                if (c > '\u001f' && c < '\u0080') {
                    this.pw.print(c);
                } else {
                    this.pw.print('.');
                }
            } else {
                this.pw.print(' ');
            }
            ++n8;
        }
    }

    protected void dumpHex(int n) {
        switch (n) {
            case 0: {
                this.pw.print('0');
                break;
            }
            case 1: {
                this.pw.print('1');
                break;
            }
            case 2: {
                this.pw.print('2');
                break;
            }
            case 3: {
                this.pw.print('3');
                break;
            }
            case 4: {
                this.pw.print('4');
                break;
            }
            case 5: {
                this.pw.print('5');
                break;
            }
            case 6: {
                this.pw.print('6');
                break;
            }
            case 7: {
                this.pw.print('7');
                break;
            }
            case 8: {
                this.pw.print('8');
                break;
            }
            case 9: {
                this.pw.print('9');
                break;
            }
            case 10: {
                this.pw.print('A');
                break;
            }
            case 11: {
                this.pw.print('B');
                break;
            }
            case 12: {
                this.pw.print('C');
                break;
            }
            case 13: {
                this.pw.print('D');
                break;
            }
            case 14: {
                this.pw.print('E');
                break;
            }
            case 15: {
                this.pw.print('F');
            }
        }
    }

    protected void resetStream() {
        if (this.is == null) {
            this.is = new CDRInputStream(null, this.buf, this.size, this.buf[6] == 1);
        } else {
            this.is.rewind();
        }
    }

    protected void dumpHexTidily(String string, byte[] byArray) {
        int n = 0;
        int n2 = byArray.length;
        while (n < n2) {
            this.pw.print(string);
            int n3 = 0;
            while (n3 < 16) {
                if (n + n3 < n2) {
                    this.dumpHex(byArray[n + n3] >> 4 & 0xF);
                    this.dumpHex(byArray[n + n3] & 0xF);
                } else {
                    this.pw.print("  ");
                }
                if ((n3 + 1) % 4 == 0) {
                    this.pw.print(" ");
                }
                ++n3;
            }
            this.pw.println();
            n += 16;
        }
    }

    protected void dumpServiceContextList() {
        int n = 0;
        int n2 = this.is.read_long();
        this.pw.println(Utility.getMessage("Trace.ServiceContext", Integer.toString(n2) + " (0x" + Integer.toHexString(n2).toUpperCase() + ")"));
        if (n2 != 0) {
            int n3 = 0;
            while (n3 < n2) {
                n = this.is.read_ulong();
                this.pw.println(Utility.getMessage("Trace.ContextID", Integer.toString(n) + " (0x" + Integer.toHexString(n).toUpperCase() + ")"));
                int n4 = this.is.read_long();
                if (n4 == 0) {
                    this.pw.println(Utility.getMessage("Trace.NoContextData"));
                } else {
                    byte[] byArray = new byte[n4];
                    this.is.read_octet_array(byArray, 0, n4);
                    this.pw.println(Utility.getMessage("Trace.ContextData", Integer.toString(n4) + " (0x" + Integer.toHexString(n4).toUpperCase() + ")"));
                    this.dumpHexTidily("                   ", byArray);
                }
                ++n3;
            }
        }
    }

    protected void dumpObjectKey() {
        int n = this.is.read_long();
        this.pw.println(Utility.getMessage("Trace.ObjectKey", Integer.toString(n) + " (0x" + Integer.toHexString(n).toUpperCase() + ")"));
        if (n != 0) {
            byte[] byArray = new byte[n];
            this.is.read_octet_array(byArray, 0, n);
            this.dumpHexTidily("                   ", byArray);
        }
    }

    protected void dumpProfileData() {
        this.pw.println(Utility.getMessage("Trace.ProfileID", Integer.toString(this.is.read_ulong())));
        int n = this.is.read_long();
        this.pw.println(Utility.getMessage("Trace.ProfileData", Integer.toString(n) + " (0x" + Integer.toHexString(n).toUpperCase() + ")"));
        if (n != 0) {
            byte[] byArray = new byte[n];
            this.is.read_octet_array(byArray, 0, n);
            this.dumpHexTidily("                   ", byArray);
        }
    }

    public void dumpMessage(PrintWriter printWriter, TransportConnection transportConnection) {
        int n;
        this.is.read_long();
        String[] stringArray = new String[]{Byte.toString(this.is.read_octet()), Byte.toString(this.is.read_octet())};
        Date date = new Date();
        DateFormat dateFormat = DateFormat.getDateTimeInstance(1, 1);
        printWriter.println(Utility.getMessage("Trace.fulldate", dateFormat.format(date)));
        printWriter.println(Utility.getMessage("Trace.threadName", Thread.currentThread().getName()));
        int n2 = transportConnection.getLocalPort();
        printWriter.println(Utility.getMessage("Trace.localPort", Integer.toString(n2) + " (0x" + Integer.toHexString(n2).toUpperCase() + ")"));
        printWriter.println(Utility.getMessage("Trace.localIP", transportConnection.getLocalHost()));
        int n3 = transportConnection.getRemotePort();
        printWriter.println(Utility.getMessage("Trace.remotePort", Integer.toString(n3) + " (0x" + Integer.toHexString(n3).toUpperCase() + ")"));
        printWriter.println(Utility.getMessage("Trace.remoteIP", transportConnection.getRemoteHost()));
        printWriter.println(Utility.getMessage("Trace.GIOPVersion", stringArray));
        if (this.GIOPMajor == 1 && this.GIOPMinor == 0) {
            if (this.is.read_boolean()) {
                printWriter.println(Utility.getMessage("Trace.LittleEndian"));
            } else {
                printWriter.println(Utility.getMessage("Trace.BigEndian"));
            }
        } else if (this.GIOPMajor == 1 && (this.GIOPMinor == 1 || this.GIOPMinor == 2)) {
            n = this.is.read_octet();
            if (n % 2 == 1) {
                printWriter.println(Utility.getMessage("Trace.LittleEndian"));
            } else {
                printWriter.println(Utility.getMessage("Trace.BigEndian"));
            }
            if ((n >> 1) % 2 == 1) {
                printWriter.println(Utility.getMessage("Trace.FragmentToFollow"));
            } else {
                printWriter.println(Utility.getMessage("Trace.NoFragmentToFollow"));
            }
        }
        n = this.is.read_long();
        printWriter.println(Utility.getMessage("Trace.MsgSize", Integer.toString(n) + " (0x" + Integer.toHexString(n).toUpperCase() + ")"));
        printWriter.println("--");
        if (!this.dumpMsgHeader) {
            printWriter.println("Message header fragmented");
        }
    }

    public void dumpMessage(PrintWriter printWriter) {
        int n;
        this.is.read_long();
        String[] stringArray = new String[]{Byte.toString(this.is.read_octet()), Byte.toString(this.is.read_octet())};
        printWriter.println(Utility.getMessage("Trace.GIOPVersion", stringArray));
        if (this.GIOPMajor == 1 && this.GIOPMinor == 0) {
            if (this.is.read_boolean()) {
                printWriter.println(Utility.getMessage("Trace.LittleEndian"));
            } else {
                printWriter.println(Utility.getMessage("Trace.BigEndian"));
            }
        } else if (this.GIOPMajor == 1 && (this.GIOPMinor == 1 || this.GIOPMinor == 2)) {
            n = this.is.read_octet();
            if (n % 2 == 1) {
                printWriter.println(Utility.getMessage("Trace.LittleEndian"));
            } else {
                printWriter.println(Utility.getMessage("Trace.BigEndian"));
            }
            if ((n >> 1) % 2 == 1) {
                printWriter.println(Utility.getMessage("Trace.FragmentToFollow"));
            } else {
                printWriter.println(Utility.getMessage("Trace.NoFragmentToFollow"));
            }
        }
        n = this.is.read_long();
        printWriter.println(Utility.getMessage("Trace.MsgSize", Integer.toString(n) + " (0x" + Integer.toHexString(n).toUpperCase() + ")"));
        printWriter.println("--");
        if (!this.dumpMsgHeader) {
            printWriter.println("Message header fragmented");
        }
    }

    public static Message createMessage(byte[] byArray, int n, int n2) {
        if (n2 > 0) {
            byte[] byArray2 = byArray;
            byArray = new byte[n -= n2];
            System.arraycopy(byArray2, n2, byArray, 0, n);
        }
        if (byArray[0] == 71 && byArray[1] == 73 && byArray[2] == 79 && byArray[3] == 80) {
            switch (byArray[7]) {
                case 0: {
                    return new RequestMessage(byArray, n);
                }
                case 1: {
                    return new ReplyMessage(byArray, n);
                }
                case 2: {
                    return new CancelRequestMessage(byArray, n);
                }
                case 3: {
                    return new LocateRequestMessage(byArray, n);
                }
                case 4: {
                    return new LocateReplyMessage(byArray, n);
                }
                case 5: {
                    return new CloseConnectionMessage(byArray, n);
                }
                case 6: {
                    return new ErrorMessage(byArray, n);
                }
                case 7: {
                    return new FragmentMessage(byArray, n);
                }
            }
            return new UnknownMessage(byArray, n);
        }
        return new UnknownMessage(byArray, n);
    }

    protected void dumpTargetAddress() {
        short s = this.is.read_short();
        this.pw.println(Utility.getMessage("Trace.TargetAddress", Short.toString(s)));
        switch (s) {
            case 0: {
                this.dumpObjectKey();
                break;
            }
            case 1: {
                this.dumpProfileData();
                break;
            }
            case 2: {
                this.getReferenceAddr();
                break;
            }
            default: {
                this.pw.println("Bad Target address");
            }
        }
    }

    private void getReferenceAddr() {
        this.pw.println(Utility.getMessage("Trace.SelectedProfileIndex", Integer.toString(this.is.read_ulong())));
        this.pw.println(Utility.getMessage("Trace.IORTypeID", this.is.read_string()));
        int n = this.is.read_ulong();
        int n2 = 0;
        while (n2 < n) {
            this.dumpProfileData();
            ++n2;
        }
    }

    protected void setDumpMessageHeader(boolean bl) {
        this.dumpMsgHeader = bl;
    }

    protected boolean dumpMessageHeader() {
        return this.dumpMsgHeader;
    }
}

