/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.transport;

import com.ibm.CORBA.iiop.Delegate;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.CORBA.iiop.ORBConnection;
import com.ibm.CORBA.iiop.ORBForTransports;
import com.ibm.CORBA.iiop.Profile;
import com.ibm.CORBA.ras.ORBRas;
import com.ibm.CORBA.transport.ConnectionTable;
import com.ibm.CORBA.transport.TransportBase;
import com.ibm.CORBA.transport.TransportConnection;
import com.ibm.rmi.transport.ConnectionKeyImpl;
import com.ibm.rmi.transport.ListenerThread;
import com.ibm.rmi.transport.TCPTransportConnection;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;

public class TCPTransport
extends TransportBase {
    protected ORB fORB;
    protected ConnectionTable fConnectionTable;
    protected ORBForTransports fORBForTransports;
    protected long globalCounter = 0L;
    protected Profile serverProfile = null;
    protected int acceptTimeout = 0;
    protected Set listeners;

    public void init(ORB oRB) {
        this.fORB = oRB;
        this.fConnectionTable = ORB.createConnectionTable(this.fORB, this);
        this.fORBForTransports = this.fORB.getORBForTransports();
        this.listeners = new HashSet(1);
        try {
            this.acceptTimeout = Integer.parseInt(this.fORB.getProperty("com.ibm.CORBA.AcceptTimeout"));
            if (this.acceptTimeout < 0 || this.acceptTimeout > 5000) {
                this.acceptTimeout = 5000;
            }
        }
        catch (Exception exception) {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(8208L, this, "init:113", exception.toString());
            }
            this.acceptTimeout = 0;
        }
    }

    public ORBConnection getConnection(Profile profile, String string, Delegate delegate) {
        ConnectionKeyImpl connectionKeyImpl;
        ORBConnection oRBConnection;
        String string2 = profile.getHost();
        int n = profile.getPort();
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, (Object)this, "getConnection:133", (Object)("host=" + string2 + ",port=" + n + ",operation=" + string));
        }
        if ((oRBConnection = this.fConnectionTable.getConnection(connectionKeyImpl = new ConnectionKeyImpl(string2, n))) != null) {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.exit(4100L, this, "getConnection:145", (Object)oRBConnection);
            }
            return oRBConnection;
        }
        TCPTransport tCPTransport = this;
        synchronized (tCPTransport) {
            oRBConnection = this.fConnectionTable.getConnection(connectionKeyImpl);
            if (oRBConnection != null) {
                ORBConnection oRBConnection2 = oRBConnection;
                return oRBConnection2;
            }
            oRBConnection = this.fORBForTransports.createORBConnection();
            this.fConnectionTable.addConnection(connectionKeyImpl, oRBConnection);
        }
        TCPTransportConnection tCPTransportConnection = new TCPTransportConnection(this.fORBForTransports, this.fConnectionTable, connectionKeyImpl, oRBConnection, this.fORB.getReaderPool(), profile);
        tCPTransportConnection.connect();
        this.fConnectionTable.checkConnectionTable();
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "getConnection:194", (Object)oRBConnection);
        }
        return oRBConnection;
    }

    public void createListener(int n) {
        this.startListening(n);
    }

    public int startListening(int n) {
        ServerSocket serverSocket;
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, (Object)this, "startListening:216", (Object)("port=" + n));
        }
        final ConnectionTable connectionTable = this.fConnectionTable;
        try {
            int n2 = this.fORB.getSocketQueueDepth();
            serverSocket = n2 > 0 ? new ServerSocket(n, n2) : new ServerSocket(n);
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(4112L, this, "startListening:231", "new socket=" + serverSocket);
            }
            final String string = "P=" + com.ibm.rmi.iiop.ORB.orbLoadTime + ":" + "O=" + this.fORB.thisInstanceNumber + ":" + "port=" + serverSocket.getLocalPort();
            Thread thread = (Thread)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Thread thread = TCPTransport.this.createListenerThread(connectionTable, serverSocket, TCPTransport.this.acceptTimeout, string);
                    thread.setDaemon(true);
                    return thread;
                }
            });
            thread.start();
            Set set = this.listeners;
            synchronized (set) {
                this.listeners.add(thread);
            }
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(4112L, this, "startListening:258", "new listener=" + thread);
            }
        }
        catch (Exception exception) {
            ORBRas.orbTrcLogger.exception(4104L, this, "startListening:265", exception);
            throw new INTERNAL(exception.getMessage(), 1229124996, CompletionStatus.COMPLETED_NO);
        }
        return serverSocket.getLocalPort();
    }

    public void initTransports() {
        int n = this.fORB.getListenerPort();
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(4112L, this, "initTransports:286", "ORB.getListenerPort() returned " + n);
        }
        int n2 = this.startListening(n);
        this.serverProfile = ORB.createProfile(this.fORB, this.fORB.getORBServerHost(), n2);
    }

    public Profile getIIOPProfile() {
        return this.serverProfile;
    }

    public TransportConnection createTransportConnection(Socket socket, Thread thread) {
        return new TCPTransportConnection(this.fConnectionTable, socket, this.fORB.getReaderPool(), this.fORBForTransports);
    }

    public void shutdown() {
        Set set = this.listeners;
        synchronized (set) {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                ((ListenerThread)iterator.next()).setShutdownPending(true);
            }
        }
    }
}

