/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.util;

import com.ibm.CORBA.ras.ORBRas;
import com.ibm.rmi.util.JDKClassLoader;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;

public final class ClassInfo {
    static final String thisClassName = "com.ibm.rmi.util.ClassInfo";
    private static Method latestLoaderMethod = (Method)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return JDKClassLoader.getMethodLatestUserDefinedLoader();
        }
    });
    private Class actualClass;
    private Class expectedType;
    private String codebase;
    private String repID;
    private ClassLoader actualCL;
    private ClassLoader preferredCL;
    private ClassLoader latestUserDefinedCL;
    private ClassLoader contextCL;
    private ClassInfo next = null;

    public ClassInfo(Class clazz, Class clazz2, String string, String string2, ClassLoader classLoader) {
        this.actualClass = clazz;
        this.expectedType = clazz2;
        this.codebase = string;
        this.repID = string2;
        this.preferredCL = classLoader;
        this.latestUserDefinedCL = ClassInfo.latestUserDefinedLoader();
        this.contextCL = Thread.currentThread().getContextClassLoader();
        this.actualCL = clazz == null ? null : clazz.getClassLoader();
    }

    public boolean matches(Class clazz, String string, String string2, ClassLoader classLoader) {
        if (this.codebase != null && !this.codebase.equals(string) || this.codebase == null && string != null) {
            return false;
        }
        if (this.repID != null && !this.repID.equals(string2) || this.repID == null && string2 != null) {
            return false;
        }
        ClassLoader classLoader2 = ClassInfo.latestUserDefinedLoader();
        ClassLoader classLoader3 = Thread.currentThread().getContextClassLoader();
        if (this.actualClass == null) {
            return this.preferredCL == classLoader && this.latestUserDefinedCL == classLoader2 && this.contextCL == classLoader3 && this.expectedType == clazz;
        }
        if (this.actualCL == null) {
            return true;
        }
        if (clazz != null && !clazz.isAssignableFrom(this.actualClass)) {
            return false;
        }
        if (ClassInfo.isAncestor(this.actualCL, classLoader)) {
            return true;
        }
        if (classLoader == this.preferredCL) {
            if (ClassInfo.isAncestor(this.actualCL, classLoader2)) {
                return true;
            }
            if (classLoader2 == this.latestUserDefinedCL) {
                if (ClassInfo.isAncestor(this.actualCL, classLoader3)) {
                    return true;
                }
                if (classLoader3 == this.contextCL) {
                    return true;
                }
            }
        }
        return false;
    }

    public void next(ClassInfo classInfo) {
        this.next = classInfo;
    }

    public ClassInfo next() {
        return this.next;
    }

    public Class getActualClass() {
        return this.actualClass;
    }

    private static boolean isAncestor(ClassLoader classLoader, ClassLoader classLoader2) {
        while (classLoader2 != null) {
            if (classLoader == classLoader2) {
                return true;
            }
            classLoader2 = classLoader2.getParent();
        }
        return classLoader == classLoader2;
    }

    private static ClassLoader latestUserDefinedLoader() {
        ClassLoader classLoader = null;
        if (latestLoaderMethod != null) {
            try {
                classLoader = (ClassLoader)latestLoaderMethod.invoke(null, null);
            }
            catch (Exception exception) {
                ORBRas.orbTrcLogger.exception(4104L, thisClassName, "latestUserDefinedLoader:203", exception);
            }
        }
        return classLoader;
    }
}

