/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.util;

import com.ibm.jvm.ExtendedSystem;
import com.ibm.rmi.util.Collision;

class FastCacheTable {
    static final int kGrowthRate = 101;
    static final int kMaxCacheSize = 30;
    static final int kKeysPos = 0;
    static final int kValsPos = 1;
    static final int kHashCodesPos = 2;
    static final int kCollisionsPos = 3;
    static final Object[][] cache = new Object[31][4];
    private static int cacheIndex = -1;
    Object[] keys = null;
    int[] vals;
    int[] hashCodes;
    Collision[] collisions;
    int count;
    int threshold;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$com$ibm$rmi$util$Collision;

    public final void put(Object object, int n) {
        this.checkForGrowth();
        int n2 = System.identityHashCode(object);
        int n3 = (n2 & Integer.MAX_VALUE) % this.keys.length;
        if (this.keys[n3] == null) {
            this.keys[n3] = object;
            this.vals[n3] = n;
            this.hashCodes[n3] = n2;
            if (this.collisions != null) {
                this.collisions[n3] = null;
            }
        } else {
            Collision collision = new Collision();
            collision.key = object;
            collision.val = n;
            collision.hash = n2;
            if (this.collisions == null) {
                this.collisions = new Collision[this.keys.length];
            }
            collision.next = this.collisions[n3];
            this.collisions[n3] = collision;
        }
        ++this.count;
    }

    public final boolean containsKey(Object object) {
        Collision collision;
        int n = System.identityHashCode(object);
        int n2 = (n & Integer.MAX_VALUE) % this.keys.length;
        if (this.keys[n2] == null) {
            return false;
        }
        if (this.keys[n2] == object) {
            return true;
        }
        Collision collision2 = collision = this.collisions == null ? null : this.collisions[n2];
        if (collision == null) {
            return false;
        }
        do {
            if (collision.key != object) continue;
            return true;
        } while ((collision = collision.next) != null);
        return false;
    }

    public final int getVal(Object object) {
        Collision collision;
        int n = System.identityHashCode(object);
        int n2 = (n & Integer.MAX_VALUE) % this.keys.length;
        if (this.keys[n2] == null) {
            return -1;
        }
        if (this.keys[n2] == object) {
            return this.vals[n2];
        }
        Collision collision2 = collision = this.collisions == null ? null : this.collisions[n2];
        if (collision == null) {
            return -1;
        }
        do {
            if (collision.key != object) continue;
            return collision.val;
        } while ((collision = collision.next) != null);
        return -1;
    }

    public void done() {
        Object[][] objectArray = cache;
        synchronized (objectArray) {
            if (cacheIndex < 30) {
                FastCacheTable.cache[++FastCacheTable.cacheIndex][0] = this.keys;
                FastCacheTable.cache[FastCacheTable.cacheIndex][1] = this.vals;
                FastCacheTable.cache[FastCacheTable.cacheIndex][2] = this.hashCodes;
                FastCacheTable.cache[FastCacheTable.cacheIndex][3] = this.collisions;
            }
        }
        this.keys = null;
        this.vals = null;
        this.hashCodes = null;
        this.collisions = null;
    }

    private final void checkForGrowth() {
        if (this.keys == null) {
            this.count = 0;
            Object[][] objectArray = cache;
            synchronized (objectArray) {
                if (cacheIndex > -1) {
                    this.keys = (Object[])cache[cacheIndex][0];
                    this.vals = (int[])cache[cacheIndex][1];
                    this.hashCodes = (int[])cache[cacheIndex][2];
                    this.collisions = (Collision[])cache[cacheIndex][3];
                    int n = this.keys.length;
                    while (n > 0) {
                        this.keys[n - 1] = null;
                        --n;
                    }
                    --cacheIndex;
                    this.threshold = 3 * this.keys.length / 4;
                    return;
                }
            }
            this.keys = (Object[])ExtendedSystem.newArray(class$java$lang$Object == null ? (class$java$lang$Object = FastCacheTable.class$("java.lang.Object")) : class$java$lang$Object, 101, this);
            this.vals = (int[])ExtendedSystem.newArray(Integer.TYPE, 101, this);
            this.hashCodes = (int[])ExtendedSystem.newArray(Integer.TYPE, 101, this);
            this.collisions = null;
            this.threshold = 3 * this.keys.length / 4;
        } else if (this.threshold == this.count) {
            int n = this.keys.length;
            int n2 = n + 101;
            Object[] objectArray = (Object[])ExtendedSystem.newArray(class$java$lang$Object == null ? (class$java$lang$Object = FastCacheTable.class$("java.lang.Object")) : class$java$lang$Object, n2, this);
            int[] nArray = (int[])ExtendedSystem.newArray(Integer.TYPE, n2, this);
            int[] nArray2 = (int[])ExtendedSystem.newArray(Integer.TYPE, n2, this);
            Collision[] collisionArray = null;
            int n3 = 0;
            while (n3 < n) {
                if (this.keys[n3] != null) {
                    Collision collision;
                    int n4 = this.hashCodes[n3];
                    int n5 = (n4 & Integer.MAX_VALUE) % n2;
                    if (objectArray[n5] == null) {
                        objectArray[n5] = this.keys[n3];
                        nArray[n5] = this.vals[n3];
                        nArray2[n5] = n4;
                        if (collisionArray != null) {
                            collisionArray[n5] = null;
                        }
                    } else {
                        collision = new Collision();
                        collision.key = this.keys[n3];
                        collision.val = this.vals[n3];
                        collision.hash = n4;
                        if (collisionArray == null) {
                            collisionArray = (Collision[])ExtendedSystem.newArray(class$com$ibm$rmi$util$Collision == null ? FastCacheTable.class$("com.ibm.rmi.util.Collision") : class$com$ibm$rmi$util$Collision, n2, this);
                        }
                        collision.next = collisionArray[n5];
                        collisionArray[n5] = collision;
                    }
                    if (this.collisions != null) {
                        collision = this.collisions[n3];
                        while (collision != null) {
                            n4 = collision.hash;
                            n5 = (n4 & Integer.MAX_VALUE) % n2;
                            if (objectArray[n5] == null) {
                                objectArray[n5] = collision.key;
                                nArray[n5] = collision.val;
                                nArray2[n5] = n4;
                                if (collisionArray != null) {
                                    collisionArray[n5] = null;
                                }
                            } else {
                                Collision collision2 = new Collision();
                                collision2.key = collision.key;
                                collision2.val = collision.val;
                                collision2.hash = n4;
                                if (collisionArray == null) {
                                    collisionArray = new Collision[n2];
                                }
                                collision2.next = collisionArray[n5];
                                collisionArray[n5] = collision2;
                            }
                            collision = collision.next;
                        }
                    }
                }
                ++n3;
            }
            Object[][] objectArray2 = cache;
            synchronized (objectArray2) {
                if (cacheIndex < 30) {
                    FastCacheTable.cache[++FastCacheTable.cacheIndex][0] = this.keys;
                    FastCacheTable.cache[FastCacheTable.cacheIndex][1] = this.vals;
                    FastCacheTable.cache[FastCacheTable.cacheIndex][2] = this.hashCodes;
                    FastCacheTable.cache[FastCacheTable.cacheIndex][3] = this.collisions;
                }
            }
            this.keys = objectArray;
            this.vals = nArray;
            this.hashCodes = nArray2;
            this.collisions = collisionArray;
            this.threshold = 3 * this.keys.length / 4;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

