/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.util;

import com.ibm.CORBA.ras.ORBRas;
import com.ibm.jvm.ExtendedSystem;
import com.ibm.rmi.io.IIOPInputStream;
import com.ibm.rmi.io.IIOPOutputStream;
import com.ibm.rmi.util.CreateIIOPInputStream;
import com.ibm.rmi.util.CreateIIOPOutputStream;
import com.ibm.rmi.util.JDKClassLoader;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamField;
import java.net.MalformedURLException;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.server.RMIClassLoader;
import java.rmi.server.RemoteObject;
import java.rmi.server.UnicastRemoteObject;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;

public class JDKBridge {
    private static final String thisClassName = "com.ibm.rmi.util.JDKBridge";
    private static final String LOCAL_CODEBASE_KEY = "java.rmi.server.codebase";
    private static final String USE_CODEBASE_ONLY_KEY = "java.rmi.server.useCodebaseOnly";
    private static String localCodebase = null;
    private static boolean useCodebaseOnly;
    private static final boolean isJDK12 = true;

    public static boolean is12VM() {
        return true;
    }

    public static boolean isPre12VM() {
        return false;
    }

    public static String getCodebase(Class clazz) {
        return RMIClassLoader.getClassAnnotation(clazz);
    }

    public static String getLocalCodebase() {
        return localCodebase;
    }

    public static boolean useCodebaseOnly() {
        return useCodebaseOnly;
    }

    public static Class loadClass(String string, String string2, ClassLoader classLoader) throws ClassNotFoundException {
        if (classLoader == null) {
            return JDKBridge.loadClassM(string, string2, useCodebaseOnly);
        }
        try {
            return JDKBridge.loadClassM(string, string2, useCodebaseOnly);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return Class.forName(string, false, classLoader);
        }
    }

    public static Class loadClass(String string, String string2) throws ClassNotFoundException {
        return JDKBridge.loadClass(string, string2, null);
    }

    public static Class loadClass(String string) throws ClassNotFoundException {
        return JDKBridge.loadClass(string, null, null);
    }

    public static Remote getJRMPStub(Remote remote) throws NoSuchObjectException {
        return RemoteObject.toStub(remote);
    }

    public static void unexportJRMP(Remote remote) throws NoSuchObjectException {
        UnicastRemoteObject.unexportObject(remote, true);
    }

    public static Hashtable getPersistentFields(Class clazz) {
        Hashtable hashtable = new Hashtable();
        ObjectStreamClass objectStreamClass = ObjectStreamClass.lookup(clazz);
        if (objectStreamClass != null) {
            ObjectStreamField[] objectStreamFieldArray = objectStreamClass.getFields();
            int n = 0;
            while (n < objectStreamFieldArray.length) {
                String string;
                String string2 = String.valueOf(objectStreamFieldArray[n].getTypeCode());
                if (objectStreamFieldArray[n].isPrimitive()) {
                    string = string2;
                } else {
                    if (objectStreamFieldArray[n].getTypeCode() == '[') {
                        string2 = "";
                    }
                    if ((string = string2 + objectStreamFieldArray[n].getType().getName().replace('.', '/')).endsWith(";")) {
                        string = string.substring(0, string.length() - 1);
                    }
                }
                hashtable.put(objectStreamFieldArray[n].getName(), string);
                ++n;
            }
        }
        return hashtable;
    }

    public static final void main(String[] stringArray) {
        System.out.println("1.2 VM");
    }

    public static synchronized void setCodebaseProperties() {
        String string = JDKBridge.getSystemProperty(LOCAL_CODEBASE_KEY);
        if (string != null && string.trim().length() > 0) {
            localCodebase = string;
        }
        if ((string = JDKBridge.getSystemProperty(USE_CODEBASE_ONLY_KEY)) != null && string.trim().length() > 0) {
            useCodebaseOnly = Boolean.valueOf(string);
        }
        ExtendedSystem.setJVMUnresettableConditionally(131073, new String("Undoable update of static variable"));
    }

    public static synchronized void setLocalCodebase(String string) {
        localCodebase = string;
    }

    public static IIOPOutputStream createOutputStream() {
        return (IIOPOutputStream)AccessController.doPrivileged(new CreateIIOPOutputStream());
    }

    public static IIOPInputStream createInputStream() {
        return (IIOPInputStream)AccessController.doPrivileged(new CreateIIOPInputStream());
    }

    private static Class loadClassM(String string, String string2, boolean bl) throws ClassNotFoundException {
        try {
            return JDKClassLoader.loadClass(null, string, true);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                if (!bl && string2 != null) {
                    return RMIClassLoader.loadClass(string2, string);
                }
                return RMIClassLoader.loadClass(string);
            }
            catch (MalformedURLException malformedURLException) {
                ORBRas.orbTrcLogger.exception(4104L, thisClassName, "loadClassM:303", (Exception)malformedURLException);
                string = string + ": " + malformedURLException.toString();
                throw new ClassNotFoundException(string);
            }
        }
    }

    private static String getSystemProperty(final String string) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(string);
            }
        });
    }

    static {
        JDKBridge.setCodebaseProperties();
    }
}

