/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.util;

import com.ibm.CORBA.ras.ORBRas;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class JDKClassLoader {
    private static final String thisClassName = "com.ibm.rmi.util.JDKClassLoader";
    private static Method latestLoaderMethod = null;

    public static Method getMethodLatestUserDefinedLoader() {
        Method method = null;
        try {
            method = Class.forName("java.io.ObjectInputStream").getDeclaredMethod("latestUserDefinedLoader", null);
            int n = method.getModifiers();
            if (!Modifier.isStatic(n)) {
                method = null;
            } else if (!Modifier.isPublic(n)) {
                method.setAccessible(true);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            method = null;
            ORBRas.orbTrcLogger.exception(4104L, thisClassName, "getMethodLatestUserDefinedLoader:105", (Exception)classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            method = null;
            ORBRas.orbTrcLogger.exception(4104L, thisClassName, "getMethodLatestUserDefinedLoader:112", (Exception)noSuchMethodException);
        }
        return method;
    }

    private static ClassLoader latestUserDefinedLoader() {
        ClassLoader classLoader = null;
        if (latestLoaderMethod != null) {
            try {
                classLoader = (ClassLoader)latestLoaderMethod.invoke(null, null);
            }
            catch (Exception exception) {
                ORBRas.orbTrcLogger.exception(4104L, thisClassName, "latestUserDefinedLoader:129", exception);
            }
        }
        return classLoader;
    }

    public static Class loadClass(Class clazz, String string, boolean bl) throws ClassNotFoundException {
        return JDKClassLoader.loadClass(clazz, string);
    }

    public static Class loadClass(Class clazz, String string) throws ClassNotFoundException {
        if (string == null) {
            throw new NullPointerException("Attempted to load null class");
        }
        if (string.length() == 0) {
            throw new ClassNotFoundException("Attempted to load non-existent class");
        }
        ClassLoader classLoader = null;
        classLoader = clazz != null ? clazz.getClassLoader() : JDKClassLoader.latestUserDefinedLoader();
        return Class.forName(string, false, classLoader);
    }

    static {
        try {
            latestLoaderMethod = (Method)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return JDKClassLoader.getMethodLatestUserDefinedLoader();
                }
            });
        }
        catch (SecurityException securityException) {
            ORBRas.orbTrcLogger.exception(4104L, thisClassName, "<clinit>:72", (Exception)securityException);
        }
    }
}

