/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.util;

import com.ibm.CORBA.ras.ORBRas;
import com.ibm.rmi.corba.ORB;
import com.ibm.rmi.iiop.CDRInputStream;
import com.ibm.rmi.javax.rmi.CORBA.StubDelegateImpl;
import com.ibm.rmi.util.ClassInfo;
import com.ibm.rmi.util.IdentityHashtable;
import com.ibm.rmi.util.JDKClassLoader;
import com.ibm.rmi.util.PartnerVersion;
import com.ibm.rmi.util.PartnerVersionUtil;
import com.ibm.rmi.util.RepositoryId;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import javax.rmi.CORBA.Stub;
import javax.rmi.CORBA.Tie;
import javax.rmi.CORBA.Util;
import javax.rmi.PortableRemoteObject;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.DATA_CONVERSION;
import org.omg.CORBA.INV_OBJREF;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.OBJ_ADAPTER;
import org.omg.CORBA.Object;
import org.omg.CORBA.StructMember;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.portable.BoxedValueHelper;
import org.omg.CORBA.portable.Delegate;
import org.omg.CORBA.portable.ValueFactory;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.ObjectImpl;
import org.omg.CORBA_2_3.portable.OutputStream;
import org.omg.PortableServer.Servant;

public final class Utility {
    static final String thisClassName = "com.ibm.rmi.util.Utility";
    public static final String STUB_PREFIX = "_";
    public static final String RMI_STUB_SUFFIX = "_Stub";
    public static final String IDL_STUB_SUFFIX = "Stub";
    public static final String TIE_SUFFIX = "_Tie";
    public static final String STUB_PACKAGE_PREFIX = "org.omg.stub.";
    public static final String OMG_PACKAGE_PREFIX = "org.omg.";
    public static final String IBM_PACKAGE_PREFIX = "com.ibm.";
    private static IdentityHashtable tieToStubCache = new IdentityHashtable();
    private static IdentityHashtable stubToTieCache = new IdentityHashtable();
    private static Hashtable narrowToClassCache = new Hashtable();
    private static Hashtable tieClassCache = new Hashtable();
    private static java.lang.Object CACHE_MISS = new java.lang.Object();
    private static Hashtable stubToClassCache = new Hashtable();
    private static Hashtable tieToStubClassCache = new Hashtable();
    private static final int[] charConversion = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private static final char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static Method latestLoaderMethod = null;
    private static Hashtable exceptionTypeCodes;
    private static final String[] completionStatusValues;
    private static final Hashtable exceptionClassNames;
    private static final Hashtable exceptionRepositoryIds;
    static /* synthetic */ Class class$javax$rmi$PortableRemoteObject;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$rmi$Remote;
    static /* synthetic */ Class class$com$ibm$org$omg$CORBA$_ObjectStub;
    static /* synthetic */ Class class$org$omg$stub$java$rmi$_Remote_Stub;
    static /* synthetic */ Class class$org$omg$CORBA$TypeCode;
    static /* synthetic */ Class class$org$omg$CORBA$CompletionStatus;

    private static ClassLoader latestUserDefinedLoader() {
        ClassLoader classLoader = null;
        if (latestLoaderMethod != null) {
            try {
                classLoader = (ClassLoader)latestLoaderMethod.invoke(null, null);
            }
            catch (Exception exception) {
                ORBRas.orbTrcLogger.exception(4104L, thisClassName, "latestUserDefinedLoader:169", exception);
            }
        }
        return classLoader;
    }

    public static int hexOf(char c) {
        int n = charConversion[c];
        if (n < 0) {
            throw new DATA_CONVERSION("Bad Hex Digit: " + c, 1229124481, CompletionStatus.COMPLETED_NO);
        }
        return n;
    }

    public static java.lang.Object autoConnect(java.lang.Object object, org.omg.CORBA.ORB oRB, boolean bl) {
        if (object == null) {
            return object;
        }
        if (object instanceof Stub) {
            Stub stub = (Stub)object;
            try {
                stub._get_delegate();
            }
            catch (BAD_OPERATION bAD_OPERATION) {
                try {
                    stub.connect(oRB);
                }
                catch (RemoteException remoteException) {
                    ORBRas.orbTrcLogger.exception(4104L, thisClassName, "autoConnect:235", (Exception)remoteException);
                    throw new INV_OBJREF(object.getClass().getName() + "did not originate from connected object", 1229125520, CompletionStatus.COMPLETED_NO);
                }
            }
            return object;
        }
        if (object instanceof Remote) {
            Remote remote = (Remote)object;
            Tie tie = Util.getTie(remote);
            if (tie != null) {
                try {
                    tie.orb();
                }
                catch (BAD_OPERATION bAD_OPERATION) {
                    if (oRB instanceof ORB) {
                        ((ORB)oRB).internalConnect((Object)((java.lang.Object)tie));
                    } else {
                        tie.orb(oRB);
                    }
                }
                catch (BAD_INV_ORDER bAD_INV_ORDER) {
                    tie.orb(oRB);
                }
                catch (OBJ_ADAPTER oBJ_ADAPTER) {
                    if (oBJ_ADAPTER.minor == 1229126573) {
                        tie.orb(oRB);
                    }
                    throw oBJ_ADAPTER;
                }
                if (bl) {
                    Remote remote2 = Utility.loadStub(tie, null, null, true);
                    if (remote2 != null) {
                        return remote2;
                    }
                    throw new INV_OBJREF("Could not load stub for " + object.getClass().getName(), 1229125521, CompletionStatus.COMPLETED_NO);
                }
                return tie.thisObject();
            }
            throw new INV_OBJREF(object.getClass().getName() + " not exported or is a JRMP stub", 1229125522, CompletionStatus.COMPLETED_NO);
        }
        return object;
    }

    public static Tie loadTie(Remote remote) {
        Class clazz = remote.getClass();
        Class clazz2 = (Class)tieClassCache.get(clazz);
        if (clazz2 == CACHE_MISS) {
            return null;
        }
        if (clazz2 == null) {
            try {
                clazz2 = Utility.loadTieClass(clazz);
                while (clazz2 == null && (clazz = clazz.getSuperclass()) != null && clazz != (class$javax$rmi$PortableRemoteObject == null ? Utility.class$("javax.rmi.PortableRemoteObject") : class$javax$rmi$PortableRemoteObject) && clazz != (class$java$lang$Object == null ? Utility.class$("java.lang.Object") : class$java$lang$Object)) {
                    clazz2 = Utility.loadTieClass(clazz);
                }
            }
            catch (Exception exception) {
                ORBRas.orbTrcLogger.exception(4104L, thisClassName, "loadTie:372", exception);
            }
            if (clazz2 == null) {
                tieClassCache.put(clazz, CACHE_MISS);
                return null;
            }
            tieClassCache.put(clazz, clazz2);
        }
        try {
            Tie tie = (Tie)clazz2.newInstance();
            Utility.loadStub(tie, null, null, true);
            return tie;
        }
        catch (Exception exception) {
            ORBRas.orbTrcLogger.exception(4104L, thisClassName, "loadTie:401", exception);
            return null;
        }
    }

    private static Class loadTieClass(Class clazz) {
        Class clazz2 = null;
        try {
            String string = Utility.tieName(clazz.getName());
            clazz2 = Utility.loadClassForClass(string, Util.getCodebase(clazz), null, clazz, clazz.getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(8208L, thisClassName, "loadTieClass:429", classNotFoundException.toString());
            }
        }
        catch (Exception exception) {
            ORBRas.orbTrcLogger.exception(4104L, thisClassName, "loadTieClass:433", exception);
        }
        return clazz2;
    }

    public static void clearCaches() {
        IdentityHashtable identityHashtable = tieToStubCache;
        synchronized (identityHashtable) {
            tieToStubCache.clear();
        }
        IdentityHashtable identityHashtable2 = stubToTieCache;
        synchronized (identityHashtable2) {
            stubToTieCache.clear();
        }
        Hashtable hashtable = tieToStubClassCache;
        synchronized (hashtable) {
            tieToStubClassCache.clear();
        }
    }

    static Class loadClassOfType(String string, String string2, ClassLoader classLoader, Class clazz, ClassLoader classLoader2, ClassLoader classLoader3) throws ClassNotFoundException {
        Class clazz2;
        block11: {
            block10: {
                clazz2 = null;
                if (classLoader3 != null) {
                    try {
                        clazz2 = classLoader3.loadClass(string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        if (!ORBRas.isTrcLogging) break block10;
                        ORBRas.orbTrcLogger.trace(8208L, thisClassName, "loadClassOfType:482", classNotFoundException.toString(), (java.lang.Object)classLoader3);
                    }
                }
            }
            if (clazz2 == null) {
                try {
                    clazz2 = Util.loadClass(string, string2, classLoader);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (ORBRas.isTrcLogging) {
                        ORBRas.orbTrcLogger.trace(8208L, thisClassName, "loadClassOfType:494", classNotFoundException.toString());
                    }
                    if (clazz != null) break block11;
                    throw classNotFoundException;
                }
            }
        }
        if (clazz == null) {
            return clazz2;
        }
        if (clazz2 == null || !clazz.isAssignableFrom(clazz2)) {
            if (clazz.getClassLoader() != classLoader2) {
                throw new IllegalArgumentException("expectedTypeClassLoader not class loader of expectedType.");
            }
            clazz2 = classLoader2 != null ? classLoader2.loadClass(string) : Class.forName(string);
        }
        return clazz2;
    }

    public static Class loadClassForClass(String string, String string2, ClassLoader classLoader, Class clazz, ClassLoader classLoader2) throws ClassNotFoundException {
        Class clazz2;
        block7: {
            if (clazz == null) {
                return Util.loadClass(string, string2, classLoader);
            }
            clazz2 = null;
            try {
                clazz2 = Util.loadClass(string, string2, classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(8208L, thisClassName, "loadClassForClass:547", classNotFoundException.toString());
                }
                if (clazz.getClassLoader() != null) break block7;
                throw classNotFoundException;
            }
        }
        if (clazz2 == null || clazz2.getClassLoader() != null && clazz2.getClassLoader().loadClass(clazz.getName()) != clazz) {
            if (clazz.getClassLoader() != classLoader2) {
                throw new IllegalArgumentException("relatedTypeClassLoader not class loader of relatedType.");
            }
            if (classLoader2 != null) {
                clazz2 = classLoader2.loadClass(string);
            }
        }
        return clazz2;
    }

    public static Remote loadStub(Tie tie, Class clazz, String string, boolean bl) {
        return (Remote)((java.lang.Object)Utility.loadStub(tie, clazz, null, string, bl));
    }

    public static Object loadStub(java.lang.Object object, Class clazz, Class clazz2, String string, boolean bl) {
        java.lang.Object object2;
        java.lang.Object object3;
        StubEntry stubEntry = null;
        if (ORBRas.isTrcLogging) {
            object3 = null;
            if (clazz != null) {
                object3 = clazz.getClassLoader();
            }
            ORBRas.orbTrcLogger.entry(2064L, thisClassName, "loadStub (Object, Class, Class, String, boolean):619", (java.lang.Object)("tie:" + object.getClass().getName() + ", stubClass:" + clazz + ", stubCl:" + object3 + ", expectedType:" + clazz2 + ", remoteCodebase:" + string + ", onlyMostDerived:" + (bl ? "true" : "false")));
        }
        if (string == null) {
            string = Util.getCodebase(object.getClass());
        }
        object3 = tieToStubCache;
        synchronized (object3) {
            object2 = (StubEntry)tieToStubCache.get(object);
            stubEntry = object2;
            while (stubEntry != null && !stubEntry.matches(clazz, clazz2, string, bl)) {
                stubEntry = stubEntry.next;
            }
            if (stubEntry == null) {
                stubEntry = Utility.loadStubAndUpdateCache((StubEntry)object2, object, clazz, clazz2, string, bl);
            }
            if (stubEntry.stub != null) {
                Utility.setDelegateForStub(object, stubEntry.stub);
            }
        }
        if (ORBRas.isTrcLogging) {
            object2 = null;
            ClassLoader classLoader = null;
            if (stubEntry != null && stubEntry.stub != null) {
                object2 = stubEntry.stub.getClass().getName();
                classLoader = stubEntry.stub.getClass().getClassLoader();
            }
            ORBRas.orbTrcLogger.exit(2064L, thisClassName, "loadStub (Object, Class, Class, String, boolean):668", (java.lang.Object)((String)object2 + ", CL=" + classLoader));
        }
        return (Object)stubEntry.stub;
    }

    public static void setDelegateForStub(java.lang.Object object, java.lang.Object object2) {
        block5: {
            org.omg.CORBA.portable.ObjectImpl objectImpl = (org.omg.CORBA.portable.ObjectImpl)object2;
            try {
                Delegate delegate = objectImpl._get_delegate();
            }
            catch (Exception exception) {
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(8208L, thisClassName, "setDelegateForStub:693", exception.toString());
                }
                try {
                    Object object3 = object instanceof Servant ? ((Servant)object)._this_object() : (object instanceof Tie ? ((Tie)object).thisObject() : (Object)object);
                    Delegate delegate = ((org.omg.CORBA.portable.ObjectImpl)object3)._get_delegate();
                    objectImpl._set_delegate(delegate);
                }
                catch (Exception exception2) {
                    if (!ORBRas.isTrcLogging) break block5;
                    ORBRas.orbTrcLogger.trace(8208L, thisClassName, "setDelegateForStub:718", exception2.toString());
                }
            }
        }
    }

    private static boolean isAncestor(ClassLoader classLoader, ClassLoader classLoader2) {
        while (classLoader2 != null) {
            if (classLoader == classLoader2) {
                return true;
            }
            classLoader2 = classLoader2.getParent();
        }
        return classLoader == classLoader2;
    }

    private static Stub loadStub(Stub stub, ClassLoader classLoader) {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, thisClassName, "loadNewStub:749", (java.lang.Object)stub.getClass().getName(), (java.lang.Object)classLoader);
        }
        Stub stub2 = null;
        try {
            stub2 = (Stub)Class.forName(stub.getClass().getName(), false, classLoader).newInstance();
            try {
                stub2._set_delegate(stub._get_delegate());
            }
            catch (BAD_OPERATION bAD_OPERATION) {
                stub2.equals(null);
                StubDelegateImpl stubDelegateImpl = Utility.getStubDelegate(stub2);
                if (stubDelegateImpl != null) {
                    stubDelegateImpl.setProfileData(Utility.getStubDelegate(stub));
                }
            }
        }
        catch (Exception exception) {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(8208L, thisClassName, "loadNewStub:779", exception.toString());
            }
            stub2 = null;
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, thisClassName, "loadNewStub:789");
        }
        return stub2;
    }

    private static StubDelegateImpl getStubDelegate(final Stub stub) {
        java.lang.Object object = AccessController.doPrivileged(new PrivilegedAction(){
            static /* synthetic */ Class class$javax$rmi$CORBA$Stub;

            public java.lang.Object run() {
                try {
                    Field field = (class$javax$rmi$CORBA$Stub == null ? (class$javax$rmi$CORBA$Stub = 2.class$("javax.rmi.CORBA.Stub")) : class$javax$rmi$CORBA$Stub).getDeclaredField("stubDelegate");
                    field.setAccessible(true);
                    return field.get(stub);
                }
                catch (Exception exception) {
                    ORBRas.orbTrcLogger.exception(4104L, Utility.thisClassName, "getStubDelegate:810", exception);
                    return null;
                }
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        });
        if (object instanceof StubDelegateImpl) {
            return (StubDelegateImpl)object;
        }
        return null;
    }

    private static StubEntry loadStubAndUpdateCache(StubEntry stubEntry, java.lang.Object object, Class clazz, Class clazz2, String string, boolean bl) {
        java.lang.Object object2;
        java.lang.Object object3;
        java.lang.Object object4;
        StubClassEntry stubClassEntry;
        Object object5;
        block16: {
            StubClassEntry stubClassEntry2;
            object5 = null;
            stubClassEntry = null;
            stubClassEntry = stubClassEntry2 = (StubClassEntry)tieToStubClassCache.get(object.getClass());
            while (stubClassEntry != null && !stubClassEntry.matches(clazz, clazz2, string, bl)) {
                stubClassEntry = stubClassEntry.next;
            }
            if (stubClassEntry == null) {
                stubClassEntry = Utility.loadStubClassAndUpdateCache(stubClassEntry2, object, clazz, clazz2, string, bl);
            }
            if (stubClassEntry.actualClass != null) {
                try {
                    object5 = (Object)stubClassEntry.actualClass.newInstance();
                }
                catch (Exception exception) {
                    if (!ORBRas.isTrcLogging) break block16;
                    ORBRas.orbTrcLogger.trace(8208L, thisClassName, "loadStubAndUpdateCache:874", exception.toString());
                }
            }
        }
        if (object5 != null) {
            object4 = (org.omg.CORBA.portable.ObjectImpl)object5;
            try {
                object3 = object instanceof Servant ? ((Servant)object)._this_object() : (object instanceof Tie ? ((Tie)object).thisObject() : (Object)object);
                object2 = ((org.omg.CORBA.portable.ObjectImpl)object3)._get_delegate();
                ((org.omg.CORBA.portable.ObjectImpl)object4)._set_delegate((Delegate)object2);
            }
            catch (Exception exception) {
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(8208L, thisClassName, "loadStubAndUpdateCache:914", exception.toString());
                }
                object2 = stubToTieCache;
                synchronized (object2) {
                    stubToTieCache.put(object5, object);
                }
            }
        }
        object4 = new StubEntry(object5, stubClassEntry);
        if (stubEntry == null) {
            tieToStubCache.put(object, object4);
        } else {
            stubEntry.next = object4;
        }
        if (ORBRas.isTrcLogging) {
            object3 = null;
            object2 = null;
            if (object4 != null && ((StubEntry)object4).stub != null) {
                object3 = ((StubEntry)object4).stub.getClass().getName();
                object2 = ((StubEntry)object4).stub.getClass().getClassLoader();
            }
            ORBRas.orbTrcLogger.exit(2064L, thisClassName, "loadStubAndUpdateCache:941", (java.lang.Object)((String)object3 + ", CL=" + object2));
        }
        return object4;
    }

    private static StubClassEntry loadStubClassAndUpdateCache(StubClassEntry stubClassEntry, java.lang.Object object, Class clazz, Class clazz2, String string, boolean bl) {
        StubClassEntry stubClassEntry2 = null;
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(2064L, thisClassName, "loadStubClassAndUpdateCache:971", (java.lang.Object)("tie:" + object.getClass().getName() + ", stubClass:" + clazz + ", expectedType:" + clazz2 + ", remoteCodebase:" + string + ", onlyMostDerived:" + (bl ? "true" : "false")));
        }
        String[] stringArray = null;
        if (object instanceof Servant) {
            stringArray = ((Servant)object)._all_interfaces(null, null);
        } else {
            Object object2 = object instanceof Tie ? ((Tie)object).thisObject() : (Object)object;
            stringArray = ((org.omg.CORBA.portable.ObjectImpl)object2)._ids();
        }
        if (object instanceof Tie) {
            boolean bl2 = false;
            if (clazz2 != null && !(class$java$rmi$Remote == null ? (class$java$rmi$Remote = Utility.class$("java.rmi.Remote")) : class$java$rmi$Remote).isAssignableFrom(clazz2)) {
                bl2 = true;
            }
            if ((stubClassEntry2 = Utility.loadStubClassOfType(object, stringArray, clazz, clazz2, string, bl, bl2)) == null) {
                stubClassEntry2 = Utility.loadStubClassOfType(object, stringArray, clazz, clazz2, string, bl, !bl2);
            }
        } else {
            stubClassEntry2 = Utility.loadStubClassOfType(object, stringArray, clazz, clazz2, string, bl, true);
        }
        if (stubClassEntry == null) {
            tieToStubClassCache.put(object, stubClassEntry2);
        } else {
            stubClassEntry.next = stubClassEntry2;
        }
        if (ORBRas.isTrcLogging) {
            String string2 = null;
            ClassLoader classLoader = null;
            if (stubClassEntry2 != null && stubClassEntry2.actualClass != null) {
                string2 = stubClassEntry2.actualClass.getName();
                classLoader = stubClassEntry2.actualClass.getClassLoader();
            }
            ORBRas.orbTrcLogger.exit(2064L, thisClassName, "loadStubClassAndUpdateCache:1034", (java.lang.Object)(string2 + ", CL=" + classLoader));
        }
        return stubClassEntry2;
    }

    private static StubClassEntry loadStubClassOfType(java.lang.Object object, String[] stringArray, Class clazz, Class clazz2, String string, boolean bl, boolean bl2) {
        java.lang.Object object2;
        java.lang.Object object3;
        boolean bl3 = false;
        Class clazz3 = null;
        StubClassEntry stubClassEntry = null;
        int n = -1;
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(2064L, thisClassName, "loadStubClassOfType:1062", (java.lang.Object)("tie:" + object.getClass().getName() + ", stubClass:" + clazz + ", expectedType:" + clazz2 + ", remoteCodebase:" + string + ", onlyMostDerived:" + (bl ? "true" : "false") + ", isIDL:" + (bl2 ? "true" : "false")));
        }
        if (!bl && clazz != null) {
            clazz3 = clazz;
        } else {
            object3 = clazz2 == null ? null : clazz2.getClassLoader();
            n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].length() == 0) {
                    if (bl2) {
                        clazz3 = class$com$ibm$org$omg$CORBA$_ObjectStub == null ? (class$com$ibm$org$omg$CORBA$_ObjectStub = Utility.class$("com.ibm.org.omg.CORBA._ObjectStub")) : class$com$ibm$org$omg$CORBA$_ObjectStub;
                        break;
                    }
                    clazz3 = class$org$omg$stub$java$rmi$_Remote_Stub == null ? (class$org$omg$stub$java$rmi$_Remote_Stub = Utility.class$("org.omg.stub.java.rmi._Remote_Stub")) : class$org$omg$stub$java$rmi$_Remote_Stub;
                    break;
                }
                object2 = Utility.stubNameFromRepID(stringArray[n], bl2);
                if (bl && n == 0 && clazz != null && clazz.getName().equals(object2)) {
                    clazz3 = clazz;
                    break;
                }
                try {
                    clazz3 = null;
                    try {
                        clazz3 = Utility.loadClassOfType((String)object2, string, (ClassLoader)object3, clazz2, (ClassLoader)object3, null);
                        break;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        if (!bl2) {
                            if (ORBRas.isTrcLogging) {
                                ORBRas.orbTrcLogger.trace(8208L, thisClassName, "loadStubClassOfType:1125", classNotFoundException.toString());
                            }
                            clazz3 = Utility.loadClassOfType(STUB_PACKAGE_PREFIX + (String)object2, string, (ClassLoader)object3, clazz2, (ClassLoader)object3, null);
                            break;
                        }
                        throw classNotFoundException;
                    }
                }
                catch (Exception exception) {
                    if (ORBRas.isTrcLogging) {
                        ORBRas.orbTrcLogger.exception(4104L, thisClassName, "loadStubClassOfType:1143", exception);
                    }
                    if (bl) break;
                    ++n;
                }
            }
        }
        if (clazz3 != null) {
            if (n == 0) {
                bl3 = true;
            }
            stubClassEntry = new StubClassEntry(clazz3, bl3, clazz2, string);
        } else {
            stubClassEntry = new StubClassEntry(null, bl, clazz2, string);
        }
        tieToStubClassCache.put(object.getClass(), stubClassEntry);
        if (ORBRas.isTrcLogging) {
            object3 = null;
            object2 = null;
            if (clazz3 != null) {
                object3 = clazz3.getName();
                object2 = clazz3.getClassLoader();
            }
            ORBRas.orbTrcLogger.exit(2064L, thisClassName, "loadStubClassOfType:1177", (java.lang.Object)((String)object3 + ", CL=" + object2));
        }
        return stubClassEntry;
    }

    public static Tie getAndForgetTie(Stub stub) {
        IdentityHashtable identityHashtable = stubToTieCache;
        synchronized (identityHashtable) {
            Tie tie = (Tie)stubToTieCache.remove(stub);
            return tie;
        }
    }

    public static void purgeStubForTie(java.lang.Object object) {
        StubEntry stubEntry;
        IdentityHashtable identityHashtable = tieToStubCache;
        synchronized (identityHashtable) {
            stubEntry = (StubEntry)tieToStubCache.remove(object);
        }
        if (stubEntry != null) {
            IdentityHashtable identityHashtable2 = stubToTieCache;
            synchronized (identityHashtable2) {
                while (stubEntry != null) {
                    stubToTieCache.remove(stubEntry.stub);
                    stubEntry = stubEntry.next;
                }
            }
        }
    }

    public static String stubNameFromRepID(String string) {
        return Utility.stubNameFromRepID(string, false);
    }

    public static String stubNameFromRepID(String string, boolean bl) {
        RepositoryId repositoryId = RepositoryId.cache.getId(string);
        String string2 = repositoryId.getClassName();
        string2 = bl || repositoryId.isIDLType() ? Utility.idlStubName(string2) : Utility.stubName(string2);
        return string2;
    }

    public static Remote loadStub(org.omg.CORBA.portable.ObjectImpl objectImpl, Class clazz) throws ClassNotFoundException {
        Class clazz2;
        Remote remote;
        block22: {
            java.lang.Object object;
            ClassNotFoundException classNotFoundException = null;
            remote = null;
            clazz2 = null;
            String string = null;
            ClassInfo classInfo = null;
            ClassInfo classInfo2 = null;
            boolean bl = true;
            boolean bl2 = false;
            try {
                string = ((ObjectImpl)objectImpl)._get_codebase();
            }
            catch (ClassCastException classCastException) {
                ORBRas.orbTrcLogger.exception(4104L, thisClassName, "loadStub:1268", (Exception)classCastException);
            }
            classInfo = (ClassInfo)narrowToClassCache.get(clazz);
            if (classInfo != null) {
                bl = false;
                object = narrowToClassCache;
                synchronized (object) {
                    while (!(bl2 = classInfo.matches(null, string, null, null)) && classInfo.next() != null) {
                        classInfo = classInfo.next();
                    }
                }
            }
            if (bl2) {
                clazz2 = classInfo.getActualClass();
            } else {
                try {
                    object = Utility.stubName(clazz.getName());
                    try {
                        clazz2 = Utility.loadClassOfType((String)object, string, objectImpl.getClass().getClassLoader(), clazz, clazz.getClassLoader(), null);
                    }
                    catch (ClassNotFoundException classNotFoundException2) {
                        classNotFoundException = classNotFoundException2;
                        clazz2 = Utility.loadClassOfType(STUB_PACKAGE_PREFIX + (String)object, string, objectImpl.getClass().getClassLoader(), clazz, clazz.getClassLoader(), null);
                    }
                    classInfo2 = new ClassInfo(clazz2, null, string, null, null);
                    if (bl) {
                        narrowToClassCache.put(clazz, classInfo2);
                        break block22;
                    }
                    Hashtable hashtable = narrowToClassCache;
                    synchronized (hashtable) {
                        classInfo.next(classInfo2);
                    }
                }
                catch (ClassNotFoundException classNotFoundException3) {
                    ORBRas.orbTrcLogger.exception(4104L, thisClassName, "loadStub:1339", classNotFoundException);
                    throw classNotFoundException;
                }
                catch (Exception exception) {
                    ORBRas.orbTrcLogger.exception(4104L, thisClassName, "loadStub:1344", exception);
                }
            }
        }
        try {
            remote = (Remote)clazz2.newInstance();
            ((org.omg.CORBA.portable.ObjectImpl)((java.lang.Object)remote))._set_delegate(objectImpl._get_delegate());
        }
        catch (BAD_OPERATION bAD_OPERATION) {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.exception(4104L, thisClassName, "loadStub:1357", (Exception)bAD_OPERATION);
            }
        }
        catch (Exception exception) {
            ORBRas.orbTrcLogger.exception(4104L, thisClassName, "loadStub:1361", exception);
        }
        return remote;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Class loadStubClass(String string, String string2, Class clazz, ClassLoader classLoader) throws ClassNotFoundException {
        Class clazz2;
        ClassInfo classInfo;
        ClassInfo classInfo2;
        block13: {
            if (string.length() == 0) {
                throw new ClassNotFoundException("repository id is empty");
            }
            classInfo2 = null;
            classInfo = null;
            boolean bl = true;
            boolean bl2 = false;
            Class clazz3 = null;
            classInfo2 = (ClassInfo)stubToClassCache.get(string);
            if (classInfo2 != null) {
                bl = false;
                while (!(bl2 = classInfo2.matches(clazz, string2, null, classLoader)) && classInfo2.next() != null) {
                    classInfo2 = classInfo2.next();
                }
            }
            if (bl2) {
                clazz3 = classInfo2.getActualClass();
                if (clazz3 != null) return clazz3;
                throw new ClassNotFoundException(string + ": stub cache miss");
            }
            ClassLoader classLoader2 = clazz == null ? null : clazz.getClassLoader();
            String string3 = Utility.stubNameFromRepID(string);
            try {
                try {
                    clazz2 = clazz3 = Utility.loadClassOfType(string3, string2, classLoader2, clazz, classLoader2, classLoader);
                    java.lang.Object var15_13 = null;
                    classInfo = new ClassInfo(clazz3, clazz, string2, null, classLoader);
                    if (!bl) break block13;
                    stubToClassCache.put(string, classInfo);
                    return clazz2;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Class clazz4;
                    block14: {
                        try {
                            clazz4 = clazz3 = Utility.loadClassOfType(STUB_PACKAGE_PREFIX + string3, string2, classLoader2, clazz, classLoader2, classLoader);
                            java.lang.Object var15_14 = null;
                            classInfo = new ClassInfo(clazz3, clazz, string2, null, classLoader);
                            if (!bl) break block14;
                            stubToClassCache.put(string, classInfo);
                            return clazz4;
                        }
                        catch (ClassNotFoundException classNotFoundException2) {
                            block15: {
                                Class clazz5;
                                block16: {
                                    try {
                                        if (!string3.startsWith(OMG_PACKAGE_PREFIX)) break block15;
                                        clazz5 = clazz3 = Utility.loadClassOfType(IBM_PACKAGE_PREFIX + string3, string2, classLoader2, clazz, classLoader2, classLoader);
                                        java.lang.Object var15_15 = null;
                                        classInfo = new ClassInfo(clazz3, clazz, string2, null, classLoader);
                                        if (!bl) break block16;
                                        stubToClassCache.put(string, classInfo);
                                        return clazz5;
                                    }
                                    catch (ClassNotFoundException classNotFoundException3) {
                                        // empty catch block
                                        break block15;
                                    }
                                }
                                classInfo2.next(classInfo);
                                return clazz5;
                            }
                            if (!ORBRas.isTrcLogging) throw classNotFoundException;
                            ORBRas.orbTrcLogger.trace(4112L, thisClassName, "loadStubClass:1475", classNotFoundException.toString());
                            throw classNotFoundException;
                        }
                    }
                    classInfo2.next(classInfo);
                    return clazz4;
                }
            }
            catch (Throwable throwable) {
                java.lang.Object var15_16 = null;
                classInfo = new ClassInfo(clazz3, clazz, string2, null, classLoader);
                if (bl) {
                    stubToClassCache.put(string, classInfo);
                    throw throwable;
                }
                classInfo2.next(classInfo);
                throw throwable;
            }
        }
        classInfo2.next(classInfo);
        return clazz2;
    }

    public static String stubName(String string) {
        int n = string.indexOf(36);
        if (n < 0) {
            n = string.lastIndexOf(46);
        }
        if (n > 0) {
            return string.substring(0, n + 1) + STUB_PREFIX + string.substring(n + 1) + RMI_STUB_SUFFIX;
        }
        return STUB_PREFIX + string + RMI_STUB_SUFFIX;
    }

    public static String tieName(String string) {
        int n = string.indexOf(36);
        if (n < 0) {
            n = string.lastIndexOf(46);
        }
        if (n > 0) {
            return string.substring(0, n + 1) + STUB_PREFIX + string.substring(n + 1) + TIE_SUFFIX;
        }
        return STUB_PREFIX + string + TIE_SUFFIX;
    }

    public static void throwNotSerializableForCorba(String string) {
        throw new BAD_PARAM(string + " is not serializable", 1330446342, CompletionStatus.COMPLETED_MAYBE);
    }

    public static String idlStubName(String string) {
        String string2 = null;
        int n = string.lastIndexOf(46);
        string2 = n > 0 ? string.substring(0, n + 1) + STUB_PREFIX + string.substring(n + 1) + IDL_STUB_SUFFIX : STUB_PREFIX + string + IDL_STUB_SUFFIX;
        return string2;
    }

    public static void dprint(java.lang.Object object, String string) {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(8208L, thisClassName, "dprint:1576", object.getClass().getName() + "(" + Thread.currentThread() + "): " + string);
        }
    }

    public static void dprint(String string, String string2) {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(8208L, thisClassName, "dprint:1588", string + "(" + Thread.currentThread() + "): " + string2);
        }
    }

    public void dprint(String string) {
        Utility.dprint(this, string);
    }

    public static int bytesToInt(byte[] byArray, int n) {
        int n2 = byArray[n++] << 24 & 0xFF000000;
        int n3 = byArray[n++] << 16 & 0xFF0000;
        int n4 = byArray[n++] << 8 & 0xFF00;
        int n5 = byArray[n++] << 0 & 0xFF;
        return n2 | n3 | n4 | n5;
    }

    public static void intToBytes(int n, byte[] byArray, int n2) {
        byArray[n2++] = (byte)(n >>> 24 & 0xFF);
        byArray[n2++] = (byte)(n >>> 16 & 0xFF);
        byArray[n2++] = (byte)(n >>> 8 & 0xFF);
        byArray[n2++] = (byte)(n >>> 0 & 0xFF);
    }

    public static short bytesToShort(byte[] byArray, int n) {
        int n2 = byArray[n++] << 8 & 0xFF00;
        int n3 = byArray[n++] << 0 & 0xFF;
        return (short)(n2 | n3);
    }

    public static void shortToBytes(short s, byte[] byArray, int n) {
        byArray[n++] = (byte)(s >>> 8 & 0xFF);
        byArray[n++] = (byte)(s >>> 0 & 0xFF);
    }

    public static String bytesToHexString(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        if (byArray.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        int n = 0;
        while (n < byArray.length) {
            stringBuffer.append(hexChars[byArray[n] >> 4 & 0xF]);
            stringBuffer.append(hexChars[byArray[n] & 0xF]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public static void writeSystemException(SystemException systemException, org.omg.CORBA.portable.OutputStream outputStream) {
        String string = Utility.repositoryIdOf(systemException.getClass().getName());
        outputStream.write_string(string);
        outputStream.write_long(systemException.minor);
        outputStream.write_long(systemException.completed.value());
    }

    public static SystemException readSystemException(org.omg.CORBA.portable.InputStream inputStream) {
        try {
            String string = Utility.classNameOf(inputStream.read_string());
            SystemException systemException = (SystemException)Class.forName(string).newInstance();
            systemException.minor = inputStream.read_long();
            systemException.completed = CompletionStatus.from_int(inputStream.read_long());
            return systemException;
        }
        catch (Exception exception) {
            ORBRas.orbTrcLogger.exception(4104L, thisClassName, "readSystemException:1717", exception);
            return new UNKNOWN(exception.getMessage(), 1229127300, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    public static TypeCode typeSystemException(SystemException systemException) {
        Class clazz = systemException.getClass();
        TypeCode typeCode = (TypeCode)exceptionTypeCodes.get(clazz);
        if (typeCode == null) {
            Class clazz2 = class$org$omg$CORBA$TypeCode == null ? (class$org$omg$CORBA$TypeCode = Utility.class$("org.omg.CORBA.TypeCode")) : class$org$omg$CORBA$TypeCode;
            synchronized (clazz2) {
                typeCode = (TypeCode)exceptionTypeCodes.get(clazz);
                if (typeCode == null) {
                    StructMember[] structMemberArray = new StructMember[2];
                    TypeCode typeCode2 = null;
                    typeCode2 = org.omg.CORBA.ORB.init().get_primitive_tc(TCKind.tk_ulong);
                    structMemberArray[0] = new StructMember("minor", typeCode2, null);
                    typeCode2 = org.omg.CORBA.ORB.init().create_enum_tc(RepositoryId.createForAnyType(class$org$omg$CORBA$CompletionStatus == null ? (class$org$omg$CORBA$CompletionStatus = Utility.class$("org.omg.CORBA.CompletionStatus")) : class$org$omg$CORBA$CompletionStatus), Utility.getShortName(class$org$omg$CORBA$CompletionStatus == null ? (class$org$omg$CORBA$CompletionStatus = Utility.class$("org.omg.CORBA.CompletionStatus")) : class$org$omg$CORBA$CompletionStatus), completionStatusValues);
                    structMemberArray[1] = new StructMember("completed", typeCode2, null);
                    typeCode = org.omg.CORBA.ORB.init().create_exception_tc(Utility.repositoryIdOf(clazz.getName()), Utility.getShortName(clazz), structMemberArray);
                    exceptionTypeCodes.put(clazz, typeCode);
                }
            }
        }
        return typeCode;
    }

    private static String getShortName(Class clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        if (n > 0) {
            return string.substring(n + 1);
        }
        return string;
    }

    public static String classNameOf(String string) {
        String string2 = null;
        string2 = (String)exceptionClassNames.get(string);
        if (string2 == null) {
            string2 = "org.omg.CORBA.UNKNOWN";
        }
        return string2;
    }

    public static boolean isSystemException(String string) {
        String string2 = null;
        string2 = (String)exceptionClassNames.get(string);
        return string2 != null;
    }

    public static String repositoryIdOf(String string) {
        String string2 = (String)exceptionRepositoryIds.get(string);
        if (string2 == null) {
            string2 = "IDL:omg.org/CORBA/UNKNOWN:1.0";
        }
        return string2;
    }

    public static BoxedValueHelper getHelper(Class clazz, String string, String string2) {
        String string3 = null;
        if (clazz != null) {
            string3 = clazz.getName();
            if (string == null) {
                string = Util.getCodebase(clazz);
            }
        } else {
            if (string2 != null) {
                string3 = RepositoryId.cache.getId(string2).getClassName();
            }
            if (string3 == null) {
                throw new MARSHAL("No repId or unrecognised repId", 1229125762, CompletionStatus.COMPLETED_MAYBE);
            }
        }
        try {
            ClassLoader classLoader = clazz == null ? null : clazz.getClassLoader();
            Class clazz2 = Utility.loadClassForClass(string3 + "Helper", string, classLoader, clazz, classLoader);
            return (BoxedValueHelper)clazz2.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(8208L, thisClassName, "BoxedValueHelper:1860", classNotFoundException.toString());
            }
            throw new MARSHAL(classNotFoundException.toString(), 1229125763, CompletionStatus.COMPLETED_MAYBE);
        }
        catch (IllegalAccessException illegalAccessException) {
            ORBRas.orbTrcLogger.exception(4104L, thisClassName, "BoxedValueHelper:1870", (Exception)illegalAccessException);
            throw new MARSHAL(illegalAccessException.toString(), 1229125764, CompletionStatus.COMPLETED_MAYBE);
        }
        catch (InstantiationException instantiationException) {
            ORBRas.orbTrcLogger.exception(4104L, thisClassName, "BoxedValueHelper:1880", (Exception)instantiationException);
            throw new MARSHAL(instantiationException.toString(), 1229125765, CompletionStatus.COMPLETED_MAYBE);
        }
        catch (ClassCastException classCastException) {
            ORBRas.orbTrcLogger.exception(4104L, thisClassName, "BoxedValueHelper:1890", (Exception)classCastException);
            throw new MARSHAL(classCastException.toString(), 1229125766, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    public static ValueFactory getFactory(Class clazz, String string, org.omg.CORBA.ORB oRB, String string2) {
        ValueFactory valueFactory = null;
        if (oRB != null && string2 != null) {
            try {
                valueFactory = ((org.omg.CORBA_2_3.ORB)oRB).lookup_value_factory(string2);
            }
            catch (BAD_PARAM bAD_PARAM) {
                ORBRas.orbTrcLogger.exception(4104L, thisClassName, "getFactory:1916", (Exception)bAD_PARAM);
            }
        }
        String string3 = null;
        if (clazz != null) {
            string3 = clazz.getName();
            if (string == null) {
                string = Util.getCodebase(clazz);
            }
        } else {
            if (string2 != null) {
                string3 = RepositoryId.cache.getId(string2).getClassName();
            }
            if (string3 == null) {
                throw new MARSHAL(1330446337, CompletionStatus.COMPLETED_MAYBE);
            }
        }
        if (valueFactory != null && (!valueFactory.getClass().getName().equals(string3 + "DefaultFactory") || clazz == null && string == null)) {
            return valueFactory;
        }
        try {
            ClassLoader classLoader = clazz == null ? null : clazz.getClassLoader();
            Class clazz2 = Utility.loadClassForClass(string3 + "DefaultFactory", string, classLoader, clazz, classLoader);
            return (ValueFactory)clazz2.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            ORBRas.orbTrcLogger.exception(4104L, thisClassName, "getFactory:1955", (Exception)classNotFoundException);
            throw new MARSHAL(classNotFoundException.toString(), 1330446337, CompletionStatus.COMPLETED_MAYBE);
        }
        catch (IllegalAccessException illegalAccessException) {
            ORBRas.orbTrcLogger.exception(4104L, thisClassName, "getFactory:1965", (Exception)illegalAccessException);
            throw new MARSHAL(illegalAccessException.toString(), 1330446337, CompletionStatus.COMPLETED_MAYBE);
        }
        catch (InstantiationException instantiationException) {
            ORBRas.orbTrcLogger.exception(4104L, thisClassName, "getFactory:1975", (Exception)instantiationException);
            throw new MARSHAL(instantiationException.toString(), 1330446337, CompletionStatus.COMPLETED_MAYBE);
        }
        catch (ClassCastException classCastException) {
            ORBRas.orbTrcLogger.exception(4104L, thisClassName, "getFactory:1985", (Exception)classCastException);
            throw new MARSHAL(classCastException.toString(), 1330446337, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    public static java.lang.Object readObjectAndNarrow(org.omg.CORBA.portable.InputStream inputStream, Class clazz) throws ClassCastException {
        Object object = inputStream.read_Object();
        if (object != null) {
            return PortableRemoteObject.narrow(object, clazz);
        }
        return null;
    }

    public static java.lang.Object readAbstractAndNarrow(InputStream inputStream, Class clazz) throws ClassCastException {
        java.lang.Object object = inputStream.read_abstract_interface();
        if (object != null) {
            return PortableRemoteObject.narrow(object, clazz);
        }
        return null;
    }

    public static void writeClassValue(OutputStream outputStream, Class clazz) {
        if (Utility.isWrongFormat(outputStream, null)) {
            outputStream.write_value((Serializable)((java.lang.Object)RepositoryId.createForAnyType(clazz)));
            outputStream.write_value((Serializable)((java.lang.Object)Util.getCodebase(clazz)));
        } else {
            outputStream.write_value((Serializable)((java.lang.Object)Util.getCodebase(clazz)));
            outputStream.write_value((Serializable)((java.lang.Object)RepositoryId.createForAnyType(clazz)));
        }
    }

    public static Class readClassValue(InputStream inputStream) {
        String string;
        String string2;
        if (Utility.isWrongFormat(null, inputStream)) {
            string2 = (String)((java.lang.Object)inputStream.read_value());
            string = (String)((java.lang.Object)inputStream.read_value());
        } else {
            string = (String)((java.lang.Object)inputStream.read_value());
            string2 = (String)((java.lang.Object)inputStream.read_value());
        }
        RepositoryId repositoryId = RepositoryId.cache.getId(string2);
        try {
            ClassLoader classLoader = null;
            if (inputStream instanceof CDRInputStream) {
                classLoader = ((CDRInputStream)inputStream).getClassLoader();
            }
            return repositoryId.getClassFromType(string, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(8208L, thisClassName, "readClassValue:2178", classNotFoundException.toString());
            }
            throw new MARSHAL("Unable to load Class " + repositoryId.getClassName() + " : " + classNotFoundException.getMessage(), 1229125803, CompletionStatus.COMPLETED_NO);
        }
    }

    private static boolean isWrongFormat(OutputStream outputStream, InputStream inputStream) {
        short s;
        short s2;
        if (outputStream != null && outputStream instanceof PartnerVersion) {
            s2 = ((PartnerVersion)((java.lang.Object)outputStream)).getPartnerMajor();
            s = ((PartnerVersion)((java.lang.Object)outputStream)).getPartnerMinor();
        } else if (inputStream != null && inputStream instanceof PartnerVersion) {
            s2 = ((PartnerVersion)((java.lang.Object)inputStream)).getPartnerMajor();
            s = ((PartnerVersion)((java.lang.Object)inputStream)).getPartnerMinor();
        } else {
            return false;
        }
        return PartnerVersionUtil.isWrongSerializationFormat(s2, s);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        latestLoaderMethod = (Method)AccessController.doPrivileged(new PrivilegedAction(){

            public java.lang.Object run() {
                return JDKClassLoader.getMethodLatestUserDefinedLoader();
            }
        });
        exceptionTypeCodes = new Hashtable();
        completionStatusValues = new String[]{"COMPLETED_YES", "COMPLETED_NO", "COMPLETED_MAYBE"};
        exceptionClassNames = new Hashtable();
        exceptionRepositoryIds = new Hashtable();
        exceptionClassNames.put("IDL:omg.org/CORBA/BAD_CONTEXT:1.0", "org.omg.CORBA.BAD_CONTEXT");
        exceptionClassNames.put("IDL:omg.org/CORBA/BAD_INV_ORDER:1.0", "org.omg.CORBA.BAD_INV_ORDER");
        exceptionClassNames.put("IDL:omg.org/CORBA/BAD_OPERATION:1.0", "org.omg.CORBA.BAD_OPERATION");
        exceptionClassNames.put("IDL:omg.org/CORBA/BAD_PARAM:1.0", "org.omg.CORBA.BAD_PARAM");
        exceptionClassNames.put("IDL:omg.org/CORBA/BAD_TYPECODE:1.0", "org.omg.CORBA.BAD_TYPECODE");
        exceptionClassNames.put("IDL:omg.org/CORBA/COMM_FAILURE:1.0", "org.omg.CORBA.COMM_FAILURE");
        exceptionClassNames.put("IDL:omg.org/CORBA/DATA_CONVERSION:1.0", "org.omg.CORBA.DATA_CONVERSION");
        exceptionClassNames.put("IDL:omg.org/CORBA/IMP_LIMIT:1.0", "org.omg.CORBA.IMP_LIMIT");
        exceptionClassNames.put("IDL:omg.org/CORBA/INTF_REPOS:1.0", "org.omg.CORBA.INTF_REPOS");
        exceptionClassNames.put("IDL:omg.org/CORBA/INTERNAL:1.0", "org.omg.CORBA.INTERNAL");
        exceptionClassNames.put("IDL:omg.org/CORBA/INV_FLAG:1.0", "org.omg.CORBA.INV_FLAG");
        exceptionClassNames.put("IDL:omg.org/CORBA/INV_IDENT:1.0", "org.omg.CORBA.INV_IDENT");
        exceptionClassNames.put("IDL:omg.org/CORBA/INV_OBJREF:1.0", "org.omg.CORBA.INV_OBJREF");
        exceptionClassNames.put("IDL:omg.org/CORBA/MARSHAL:1.0", "org.omg.CORBA.MARSHAL");
        exceptionClassNames.put("IDL:omg.org/CORBA/NO_MEMORY:1.0", "org.omg.CORBA.NO_MEMORY");
        exceptionClassNames.put("IDL:omg.org/CORBA/FREE_MEM:1.0", "org.omg.CORBA.FREE_MEM");
        exceptionClassNames.put("IDL:omg.org/CORBA/NO_IMPLEMENT:1.0", "org.omg.CORBA.NO_IMPLEMENT");
        exceptionClassNames.put("IDL:omg.org/CORBA/NO_PERMISSION:1.0", "org.omg.CORBA.NO_PERMISSION");
        exceptionClassNames.put("IDL:omg.org/CORBA/NO_RESOURCES:1.0", "org.omg.CORBA.NO_RESOURCES");
        exceptionClassNames.put("IDL:omg.org/CORBA/NO_RESPONSE:1.0", "org.omg.CORBA.NO_RESPONSE");
        exceptionClassNames.put("IDL:omg.org/CORBA/OBJ_ADAPTER:1.0", "org.omg.CORBA.OBJ_ADAPTER");
        exceptionClassNames.put("IDL:omg.org/CORBA/INITIALIZE:1.0", "org.omg.CORBA.INITIALIZE");
        exceptionClassNames.put("IDL:omg.org/CORBA/PERSIST_STORE:1.0", "org.omg.CORBA.PERSIST_STORE");
        exceptionClassNames.put("IDL:omg.org/CORBA/TRANSIENT:1.0", "org.omg.CORBA.TRANSIENT");
        exceptionClassNames.put("IDL:omg.org/CORBA/UNKNOWN:1.0", "org.omg.CORBA.UNKNOWN");
        exceptionClassNames.put("IDL:omg.org/CORBA/OBJECT_NOT_EXIST:1.0", "org.omg.CORBA.OBJECT_NOT_EXIST");
        exceptionClassNames.put("IDL:omg.org/CORBA/INVALID_TRANSACTION:1.0", "org.omg.CORBA.INVALID_TRANSACTION");
        exceptionClassNames.put("IDL:omg.org/CORBA/TRANSACTION_REQUIRED:1.0", "org.omg.CORBA.TRANSACTION_REQUIRED");
        exceptionClassNames.put("IDL:omg.org/CORBA/TRANSACTION_ROLLEDBACK:1.0", "org.omg.CORBA.TRANSACTION_ROLLEDBACK");
        exceptionClassNames.put("IDL:omg.org/CORBA/INV_POLICY:1.0", "org.omg.CORBA.INV_POLICY");
        exceptionClassNames.put("IDL:omg.org/CORBA/ACTIVITY_COMPLETED:1.0", "org.omg.CORBA.ACTIVITY_COMPLETED");
        exceptionClassNames.put("IDL:omg.org/CORBA/ACTIVITY_REQUIRED:1.0", "org.omg.CORBA.ACTIVITY_REQUIRED");
        exceptionClassNames.put("IDL:omg.org/CORBA/INVALID_ACTIVITY:1.0", "org.omg.CORBA.INVALID_ACTIVITY");
        Enumeration enumeration = exceptionClassNames.keys();
        try {
            while (enumeration.hasMoreElements()) {
                java.lang.Object object = enumeration.nextElement();
                String string = (String)object;
                String string2 = (String)exceptionClassNames.get(string);
                exceptionRepositoryIds.put(string2, string);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    static class StubEntry {
        java.lang.Object stub;
        StubClassEntry stubClassEntry;
        StubEntry next;

        StubEntry(java.lang.Object object, StubClassEntry stubClassEntry) {
            this.stub = object;
            this.stubClassEntry = stubClassEntry;
        }

        boolean matches(Class clazz, Class clazz2, String string, boolean bl) {
            return this.stubClassEntry.matches(clazz, clazz2, string, bl);
        }

        boolean matches(ClassLoader classLoader, boolean bl) {
            return this.stubClassEntry.matches(classLoader, bl);
        }
    }

    private static class StubClassEntry {
        boolean isMostDerived;
        Class actualClass;
        ClassInfo classInfo;
        StubClassEntry next;

        StubClassEntry(Class clazz, boolean bl, Class clazz2, String string) {
            this.isMostDerived = bl;
            this.actualClass = clazz;
            this.classInfo = new ClassInfo(clazz, clazz2, string, null, null);
        }

        boolean matches(Class clazz, Class clazz2, String string, boolean bl) {
            if (this.actualClass != null) {
                if (!this.isMostDerived) {
                    if (bl) {
                        return false;
                    }
                    if (clazz != null && clazz != this.actualClass) {
                        return false;
                    }
                }
            } else if (this.isMostDerived && !bl) {
                return false;
            }
            ClassLoader classLoader = null;
            if (clazz != null) {
                classLoader = clazz.getClassLoader();
            }
            return this.classInfo.matches(clazz2, string, null, classLoader);
        }

        boolean matches(ClassLoader classLoader, boolean bl) {
            if (bl && !this.isMostDerived) {
                return false;
            }
            return this.actualClass != null && this.actualClass.getClassLoader() == classLoader;
        }
    }
}

