/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.motif;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import javax.swing.JSplitPane;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class MotifSplitPaneDivider
extends BasicSplitPaneDivider {
    private static final Cursor defaultCursor = Cursor.getPredefinedCursor(0);
    public static final int minimumThumbSize = 6;
    public static final int defaultDividerSize = 18;
    protected static final int pad = 6;
    private int hThumbOffset = 30;
    private int vThumbOffset = 40;
    protected int hThumbWidth = 12;
    protected int hThumbHeight = 18;
    protected int vThumbWidth = 18;
    protected int vThumbHeight = 12;
    protected Color highlightColor = UIManager.getColor("SplitPane.highlight");
    protected Color shadowColor = UIManager.getColor("SplitPane.shadow");
    protected Color focusedColor = UIManager.getColor("SplitPane.activeThumb");

    public MotifSplitPaneDivider(BasicSplitPaneUI basicSplitPaneUI) {
        super(basicSplitPaneUI);
        this.setDividerSize(this.hThumbWidth + 6);
    }

    public void setDividerSize(int n) {
        Insets insets = this.getInsets();
        int n2 = 0;
        if (this.getBasicSplitPaneUI().getOrientation() == 1) {
            if (insets != null) {
                n2 = insets.left + insets.right;
            }
        } else if (insets != null) {
            n2 = insets.top + insets.bottom;
        }
        if (n < 12 + n2) {
            this.setDividerSize(12 + n2);
        } else {
            this.vThumbHeight = this.hThumbWidth = n - 6 - n2;
            super.setDividerSize(n);
        }
    }

    public void paint(Graphics graphics) {
        Color color = this.getBackground();
        Dimension dimension = this.getSize();
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        if (this.getBasicSplitPaneUI().getOrientation() == 1) {
            int n = dimension.width / 2;
            int n2 = n - this.hThumbWidth / 2;
            int n3 = this.hThumbOffset;
            graphics.setColor(this.shadowColor);
            graphics.drawLine(n - 1, 0, n - 1, dimension.height);
            graphics.setColor(this.highlightColor);
            graphics.drawLine(n, 0, n, dimension.height);
            graphics.setColor(this.splitPane.hasFocus() ? this.focusedColor : this.getBackground());
            graphics.fillRect(n2 + 1, n3 + 1, this.hThumbWidth - 2, this.hThumbHeight - 1);
            graphics.setColor(this.highlightColor);
            graphics.drawLine(n2, n3, n2 + this.hThumbWidth - 1, n3);
            graphics.drawLine(n2, n3 + 1, n2, n3 + this.hThumbHeight - 1);
            graphics.setColor(this.shadowColor);
            graphics.drawLine(n2 + 1, n3 + this.hThumbHeight - 1, n2 + this.hThumbWidth - 1, n3 + this.hThumbHeight - 1);
            graphics.drawLine(n2 + this.hThumbWidth - 1, n3 + 1, n2 + this.hThumbWidth - 1, n3 + this.hThumbHeight - 2);
        } else {
            int n = dimension.height / 2;
            int n4 = dimension.width - this.vThumbOffset;
            int n5 = dimension.height / 2 - this.vThumbHeight / 2;
            graphics.setColor(this.shadowColor);
            graphics.drawLine(0, n - 1, dimension.width, n - 1);
            graphics.setColor(this.highlightColor);
            graphics.drawLine(0, n, dimension.width, n);
            graphics.setColor(this.splitPane.hasFocus() ? this.focusedColor : this.getBackground());
            graphics.fillRect(n4 + 1, n5 + 1, this.vThumbWidth - 1, this.vThumbHeight - 1);
            graphics.setColor(this.highlightColor);
            graphics.drawLine(n4, n5, n4 + this.vThumbWidth, n5);
            graphics.drawLine(n4, n5 + 1, n4, n5 + this.vThumbHeight);
            graphics.setColor(this.shadowColor);
            graphics.drawLine(n4 + 1, n5 + this.vThumbHeight, n4 + this.vThumbWidth, n5 + this.vThumbHeight);
            graphics.drawLine(n4 + this.vThumbWidth, n5 + 1, n4 + this.vThumbWidth, n5 + this.vThumbHeight - 1);
        }
        super.paint(graphics);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void setBasicSplitPaneUI(BasicSplitPaneUI basicSplitPaneUI) {
        if (this.splitPane != null) {
            this.splitPane.removePropertyChangeListener(this);
            if (this.mouseHandler != null) {
                this.splitPane.removeMouseListener(this.mouseHandler);
                this.splitPane.removeMouseMotionListener(this.mouseHandler);
                this.removeMouseListener(this.mouseHandler);
                this.removeMouseMotionListener(this.mouseHandler);
                this.mouseHandler = null;
            }
        }
        this.splitPaneUI = basicSplitPaneUI;
        if (basicSplitPaneUI != null) {
            this.splitPane = basicSplitPaneUI.getSplitPane();
            if (this.splitPane != null) {
                if (this.mouseHandler == null) {
                    this.mouseHandler = new MotifMouseHandler();
                }
                this.splitPane.addMouseListener(this.mouseHandler);
                this.splitPane.addMouseMotionListener(this.mouseHandler);
                this.addMouseListener(this.mouseHandler);
                this.addMouseMotionListener(this.mouseHandler);
                this.splitPane.addPropertyChangeListener(this);
                if (this.splitPane.isOneTouchExpandable()) {
                    this.oneTouchExpandableChanged();
                }
            }
        } else {
            this.splitPane = null;
        }
    }

    private boolean isInThumb(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        Dimension dimension = this.getSize();
        if (this.getBasicSplitPaneUI().getOrientation() == 1) {
            int n7 = dimension.width / 2;
            n6 = n7 - this.hThumbWidth / 2;
            n5 = this.hThumbOffset;
            n4 = this.hThumbWidth;
            n3 = this.hThumbHeight;
        } else {
            int n8 = dimension.height / 2;
            n6 = dimension.width - this.vThumbOffset;
            n5 = dimension.height / 2 - this.vThumbHeight / 2;
            n4 = this.vThumbWidth;
            n3 = this.vThumbHeight;
        }
        return n >= n6 && n < n6 + n4 && n2 >= n5 && n2 < n5 + n3;
    }

    private BasicSplitPaneDivider.DragController getDragger() {
        return this.dragger;
    }

    private JSplitPane getSplitPane() {
        return this.splitPane;
    }

    private class MotifMouseHandler
    extends BasicSplitPaneDivider.MouseHandler {
        private MotifMouseHandler() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getSource() == MotifSplitPaneDivider.this && MotifSplitPaneDivider.this.getDragger() == null && MotifSplitPaneDivider.this.getSplitPane().isEnabled() && MotifSplitPaneDivider.this.isInThumb(mouseEvent.getX(), mouseEvent.getY())) {
                super.mousePressed(mouseEvent);
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (MotifSplitPaneDivider.this.getDragger() != null) {
                return;
            }
            if (!MotifSplitPaneDivider.this.isInThumb(mouseEvent.getX(), mouseEvent.getY())) {
                if (MotifSplitPaneDivider.this.getCursor() != defaultCursor) {
                    MotifSplitPaneDivider.this.setCursor(defaultCursor);
                }
                return;
            }
            super.mouseMoved(mouseEvent);
        }
    }
}

