/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.WindowsUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;

public class WindowsIconFactory
implements Serializable {
    private static Icon frame_closeIcon;
    private static Icon frame_iconifyIcon;
    private static Icon frame_maxIcon;
    private static Icon frame_minIcon;
    private static Icon frame_resizeIcon;
    private static Icon checkBoxIcon;
    private static Icon radioButtonIcon;
    private static Icon checkBoxMenuItemIcon;
    private static Icon radioButtonMenuItemIcon;
    private static Icon menuItemCheckIcon;
    private static Icon menuItemArrowIcon;
    private static Icon menuArrowIcon;

    public static Icon getMenuItemCheckIcon() {
        if (menuItemCheckIcon == null) {
            menuItemCheckIcon = new MenuItemCheckIcon();
        }
        return menuItemCheckIcon;
    }

    public static Icon getMenuItemArrowIcon() {
        if (menuItemArrowIcon == null) {
            menuItemArrowIcon = new MenuItemArrowIcon();
        }
        return menuItemArrowIcon;
    }

    public static Icon getMenuArrowIcon() {
        if (menuArrowIcon == null) {
            menuArrowIcon = new MenuArrowIcon();
        }
        return menuArrowIcon;
    }

    public static Icon getCheckBoxIcon() {
        if (checkBoxIcon == null) {
            checkBoxIcon = new CheckBoxIcon();
        }
        return checkBoxIcon;
    }

    public static Icon getRadioButtonIcon() {
        if (radioButtonIcon == null) {
            radioButtonIcon = new RadioButtonIcon();
        }
        return radioButtonIcon;
    }

    public static Icon getCheckBoxMenuItemIcon() {
        if (checkBoxMenuItemIcon == null) {
            checkBoxMenuItemIcon = new CheckBoxMenuItemIcon();
        }
        return checkBoxMenuItemIcon;
    }

    public static Icon getRadioButtonMenuItemIcon() {
        if (radioButtonMenuItemIcon == null) {
            radioButtonMenuItemIcon = new RadioButtonMenuItemIcon();
        }
        return radioButtonMenuItemIcon;
    }

    public static Icon createFrameCloseIcon() {
        if (frame_closeIcon == null) {
            frame_closeIcon = new CloseIcon();
        }
        return frame_closeIcon;
    }

    public static Icon createFrameIconifyIcon() {
        if (frame_iconifyIcon == null) {
            frame_iconifyIcon = new IconifyIcon();
        }
        return frame_iconifyIcon;
    }

    public static Icon createFrameMaximizeIcon() {
        if (frame_maxIcon == null) {
            frame_maxIcon = new MaximizeIcon();
        }
        return frame_maxIcon;
    }

    public static Icon createFrameMinimizeIcon() {
        if (frame_minIcon == null) {
            frame_minIcon = new MinimizeIcon();
        }
        return frame_minIcon;
    }

    public static Icon createFrameResizeIcon() {
        if (frame_resizeIcon == null) {
            frame_resizeIcon = new ResizeIcon();
        }
        return frame_resizeIcon;
    }

    private static class MenuArrowIcon
    implements Icon,
    UIResource,
    Serializable {
        private MenuArrowIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.translate(n, n2);
            if (WindowsUtils.isLeftToRight(component)) {
                graphics.drawLine(0, 0, 0, 7);
                graphics.drawLine(1, 1, 1, 6);
                graphics.drawLine(2, 2, 2, 5);
                graphics.drawLine(3, 3, 3, 4);
            } else {
                graphics.drawLine(4, 0, 4, 7);
                graphics.drawLine(3, 1, 3, 6);
                graphics.drawLine(2, 2, 2, 5);
                graphics.drawLine(1, 3, 1, 4);
            }
            graphics.translate(-n, -n2);
        }

        public int getIconWidth() {
            return 4;
        }

        public int getIconHeight() {
            return 8;
        }
    }

    private static class MenuItemArrowIcon
    implements Icon,
    UIResource,
    Serializable {
        private MenuItemArrowIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        }

        public int getIconWidth() {
            return 4;
        }

        public int getIconHeight() {
            return 8;
        }
    }

    private static class MenuItemCheckIcon
    implements Icon,
    UIResource,
    Serializable {
        private MenuItemCheckIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        }

        public int getIconWidth() {
            return 9;
        }

        public int getIconHeight() {
            return 9;
        }
    }

    private static class RadioButtonMenuItemIcon
    implements Icon,
    UIResource,
    Serializable {
        private RadioButtonMenuItemIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            if (abstractButton.isSelected()) {
                graphics.fillArc(0, 0, this.getIconWidth() - 2, this.getIconHeight() - 2, 0, 360);
            }
        }

        public int getIconWidth() {
            return 12;
        }

        public int getIconHeight() {
            return 12;
        }
    }

    private static class CheckBoxMenuItemIcon
    implements Icon,
    UIResource,
    Serializable {
        private CheckBoxMenuItemIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            boolean bl = buttonModel.isSelected();
            if (bl) {
                graphics.drawLine(n + 9, (n2 -= this.getIconHeight() / 2) + 3, n + 9, n2 + 3);
                graphics.drawLine(n + 8, n2 + 4, n + 9, n2 + 4);
                graphics.drawLine(n + 7, n2 + 5, n + 9, n2 + 5);
                graphics.drawLine(n + 6, n2 + 6, n + 8, n2 + 6);
                graphics.drawLine(n + 3, n2 + 7, n + 7, n2 + 7);
                graphics.drawLine(n + 4, n2 + 8, n + 6, n2 + 8);
                graphics.drawLine(n + 5, n2 + 9, n + 5, n2 + 9);
                graphics.drawLine(n + 3, n2 + 5, n + 3, n2 + 5);
                graphics.drawLine(n + 3, n2 + 6, n + 4, n2 + 6);
            }
        }

        public int getIconWidth() {
            return 9;
        }

        public int getIconHeight() {
            return 9;
        }
    }

    private static class RadioButtonIcon
    implements Icon,
    UIResource,
    Serializable {
        private transient Color bg = UIManager.getColor("RadioButton.background");
        private transient Color hilite = UIManager.getColor("RadioButton.highlight");
        private transient Color shadow = UIManager.getColor("RadioButton.shadow");
        private transient Color dkshadow = UIManager.getColor("RadioButton.darkShadow");

        RadioButtonIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            if (buttonModel.isPressed() && buttonModel.isArmed() || !buttonModel.isEnabled()) {
                graphics.setColor(this.bg);
            } else {
                graphics.setColor(this.hilite);
            }
            graphics.fillRect(n + 2, n2 + 2, 8, 8);
            graphics.setColor(this.shadow);
            graphics.drawLine(n + 4, n2 + 0, n + 7, n2 + 0);
            graphics.drawLine(n + 2, n2 + 1, n + 3, n2 + 1);
            graphics.drawLine(n + 8, n2 + 1, n + 9, n2 + 1);
            graphics.drawLine(n + 1, n2 + 2, n + 1, n2 + 3);
            graphics.drawLine(n + 0, n2 + 4, n + 0, n2 + 7);
            graphics.drawLine(n + 1, n2 + 8, n + 1, n2 + 9);
            graphics.setColor(this.hilite);
            graphics.drawLine(n + 2, n2 + 10, n + 3, n2 + 10);
            graphics.drawLine(n + 4, n2 + 11, n + 7, n2 + 11);
            graphics.drawLine(n + 8, n2 + 10, n + 9, n2 + 10);
            graphics.drawLine(n + 10, n2 + 9, n + 10, n2 + 8);
            graphics.drawLine(n + 11, n2 + 7, n + 11, n2 + 4);
            graphics.drawLine(n + 10, n2 + 3, n + 10, n2 + 2);
            graphics.setColor(this.dkshadow);
            graphics.drawLine(n + 4, n2 + 1, n + 7, n2 + 1);
            graphics.drawLine(n + 2, n2 + 2, n + 3, n2 + 2);
            graphics.drawLine(n + 8, n2 + 2, n + 9, n2 + 2);
            graphics.drawLine(n + 2, n2 + 3, n + 2, n2 + 3);
            graphics.drawLine(n + 1, n2 + 4, n + 1, n2 + 7);
            graphics.drawLine(n + 2, n2 + 8, n + 2, n2 + 8);
            graphics.setColor(this.bg);
            graphics.drawLine(n + 2, n2 + 9, n + 3, n2 + 9);
            graphics.drawLine(n + 4, n2 + 10, n + 7, n2 + 10);
            graphics.drawLine(n + 8, n2 + 9, n + 9, n2 + 9);
            graphics.drawLine(n + 9, n2 + 8, n + 9, n2 + 8);
            graphics.drawLine(n + 10, n2 + 7, n + 10, n2 + 4);
            graphics.drawLine(n + 9, n2 + 3, n + 9, n2 + 3);
            if (buttonModel.isSelected()) {
                graphics.setColor(this.dkshadow);
                graphics.fillRect(n + 4, n2 + 5, 4, 2);
                graphics.fillRect(n + 5, n2 + 4, 2, 4);
            }
        }

        public int getIconWidth() {
            return 13;
        }

        public int getIconHeight() {
            return 13;
        }
    }

    private static class CheckBoxIcon
    implements Icon,
    Serializable {
        static final int csize = 13;
        private transient Color bg = UIManager.getColor("CheckBox.background");
        private transient Color shadow = UIManager.getColor("CheckBox.shadow");
        private transient Color hilite = UIManager.getColor("CheckBox.highlight");
        private transient Color dkshadow = UIManager.getColor("CheckBox.darkShadow");

        CheckBoxIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            JCheckBox jCheckBox = (JCheckBox)component;
            ButtonModel buttonModel = jCheckBox.getModel();
            if (!jCheckBox.isBorderPaintedFlat()) {
                graphics.setColor(this.bg);
                graphics.fill3DRect(n, n2, 13, 13, false);
                graphics.setColor(this.shadow);
                graphics.fill3DRect(n + 1, n2 + 1, 11, 11, false);
                if (buttonModel.isPressed() && buttonModel.isArmed() || !buttonModel.isEnabled()) {
                    graphics.setColor(this.bg);
                } else {
                    graphics.setColor(this.hilite);
                }
                graphics.fillRect(n + 2, n2 + 2, 9, 9);
            } else {
                graphics.setColor(this.shadow);
                graphics.drawRect(n + 1, n2 + 1, 10, 10);
                if (buttonModel.isPressed() && buttonModel.isArmed() || !buttonModel.isEnabled()) {
                    graphics.setColor(this.bg);
                } else {
                    graphics.setColor(this.hilite);
                }
                graphics.fillRect(n + 2, n2 + 2, 9, 9);
            }
            if (buttonModel.isEnabled()) {
                graphics.setColor(this.dkshadow);
            } else {
                graphics.setColor(this.shadow);
            }
            if (buttonModel.isSelected()) {
                graphics.drawLine(n + 9, n2 + 3, n + 9, n2 + 3);
                graphics.drawLine(n + 8, n2 + 4, n + 9, n2 + 4);
                graphics.drawLine(n + 7, n2 + 5, n + 9, n2 + 5);
                graphics.drawLine(n + 6, n2 + 6, n + 8, n2 + 6);
                graphics.drawLine(n + 3, n2 + 7, n + 7, n2 + 7);
                graphics.drawLine(n + 4, n2 + 8, n + 6, n2 + 8);
                graphics.drawLine(n + 5, n2 + 9, n + 5, n2 + 9);
                graphics.drawLine(n + 3, n2 + 5, n + 3, n2 + 5);
                graphics.drawLine(n + 3, n2 + 6, n + 4, n2 + 6);
            }
        }

        public int getIconWidth() {
            return 13;
        }

        public int getIconHeight() {
            return 13;
        }
    }

    private static class ResizeIcon
    implements Icon,
    Serializable {
        private ResizeIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(UIManager.getColor("InternalFrame.resizeIconHighlight"));
            graphics.drawLine(0, 11, 11, 0);
            graphics.drawLine(4, 11, 11, 4);
            graphics.drawLine(8, 11, 11, 8);
            graphics.setColor(UIManager.getColor("InternalFrame.resizeIconShadow"));
            graphics.drawLine(1, 11, 11, 1);
            graphics.drawLine(2, 11, 11, 2);
            graphics.drawLine(5, 11, 11, 5);
            graphics.drawLine(6, 11, 11, 6);
            graphics.drawLine(9, 11, 11, 9);
            graphics.drawLine(10, 11, 11, 10);
        }

        public int getIconWidth() {
            return 13;
        }

        public int getIconHeight() {
            return 13;
        }
    }

    private static class MinimizeIcon
    implements Icon,
    Serializable {
        int height = 16;
        int width = 14;

        private MinimizeIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(UIManager.getColor("InternalFrame.iconForeground"));
            graphics.drawRect(5, 2, 5, 5);
            graphics.drawLine(5, 3, 10, 3);
            graphics.drawRect(3, 5, 5, 5);
            graphics.drawLine(3, 6, 7, 6);
            graphics.setColor(UIManager.getColor("InternalFrame.minimizeIconBackground"));
            graphics.fillRect(4, 7, 4, 3);
        }

        public int getIconWidth() {
            return this.width;
        }

        public int getIconHeight() {
            return this.height;
        }
    }

    private static class MaximizeIcon
    implements Icon,
    Serializable {
        int height = 16;
        int width = 14;

        private MaximizeIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(UIManager.getColor("InternalFrame.iconForeground"));
            graphics.drawRect(3, 2, 8, 8);
            graphics.drawLine(3, 3, 11, 3);
        }

        public int getIconWidth() {
            return this.width;
        }

        public int getIconHeight() {
            return this.height;
        }
    }

    private static class IconifyIcon
    implements Icon,
    Serializable {
        int height = 16;
        int width = 14;

        private IconifyIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(UIManager.getColor("InternalFrame.iconForeground"));
            graphics.drawRect(4, this.height - 7, 6, 1);
        }

        public int getIconWidth() {
            return this.width;
        }

        public int getIconHeight() {
            return this.height;
        }
    }

    private static class CloseIcon
    implements Icon,
    Serializable {
        int height = 16;
        int width = 14;

        private CloseIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(UIManager.getColor("InternalFrame.iconForeground"));
            graphics.drawLine(4, 3, 10, 9);
            graphics.drawLine(5, 3, 11, 9);
            graphics.drawLine(10, 3, 4, 9);
            graphics.drawLine(11, 3, 5, 9);
        }

        public int getIconWidth() {
            return this.width;
        }

        public int getIconHeight() {
            return this.height;
        }
    }
}

