/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.WindowsTextUI;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTextFieldUI;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Highlighter;

public class WindowsTextFieldUI
extends BasicTextFieldUI {
    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsTextFieldUI();
    }

    protected Caret createCaret() {
        return new WindowsFieldCaret();
    }

    static class WindowsFieldCaret
    extends DefaultCaret
    implements UIResource {
        protected void adjustVisibility(Rectangle rectangle) {
            JTextField jTextField = (JTextField)this.getComponent();
            Insets insets = jTextField.getInsets();
            BoundedRangeModel boundedRangeModel = jTextField.getHorizontalVisibility();
            int n = rectangle.x + boundedRangeModel.getValue() - insets.left;
            int n2 = boundedRangeModel.getExtent() / 4;
            if (n < boundedRangeModel.getValue()) {
                boundedRangeModel.setValue(n - n2);
            } else if (n > boundedRangeModel.getValue() + boundedRangeModel.getExtent()) {
                boundedRangeModel.setValue(n - 3 * n2);
            }
        }

        protected Highlighter.HighlightPainter getSelectionPainter() {
            return WindowsTextUI.WindowsPainter;
        }
    }
}

