/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.EventDispatcher;
import com.sun.media.sound.Printer;
import java.util.Vector;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Transmitter;

abstract class AbstractMidiDevice
implements MidiDevice {
    protected static final EventDispatcher eventDispatcher;
    private static Vector openDeviceList;
    protected MidiDevice.Info info;
    protected boolean open = false;
    protected long id = 0L;

    protected AbstractMidiDevice(MidiDevice.Info info) {
        if (Printer.trace) {
            Printer.trace(">> AbstractMidiDevice CONSTRUCTOR");
        }
        this.info = info;
        if (Printer.trace) {
            Printer.trace("<< AbstractMidiDevice CONSTRUCTOR completed");
        }
    }

    public MidiDevice.Info getDeviceInfo() {
        return this.info;
    }

    public void open() throws MidiUnavailableException {
        if (Printer.trace) {
            Printer.trace("> AbstractMidiDevice: open()");
        }
        AbstractMidiDevice abstractMidiDevice = this;
        synchronized (abstractMidiDevice) {
            if (!this.open) {
                this.implOpen();
                this.open = true;
            }
        }
        if (Printer.trace) {
            Printer.trace("< AbstractMidiDevice: open() completed");
        }
    }

    public void close() {
        if (Printer.trace) {
            Printer.trace("> AbstractMidiDevice: close()");
        }
        AbstractMidiDevice abstractMidiDevice = this;
        synchronized (abstractMidiDevice) {
            if (this.open && openDeviceList.isEmpty()) {
                this.implClose();
                this.open = false;
            }
        }
        if (Printer.trace) {
            Printer.trace("< AbstractMidiDevice: close() completed");
        }
    }

    public boolean isOpen() {
        return this.open;
    }

    public long getMicrosecondPosition() {
        return -1L;
    }

    public int getMaxReceivers() {
        return 0;
    }

    public int getMaxTransmitters() {
        return 0;
    }

    public Receiver getReceiver() throws MidiUnavailableException {
        throw new MidiUnavailableException("MIDI IN receiver not available");
    }

    public Transmitter getTransmitter() throws MidiUnavailableException {
        throw new MidiUnavailableException("MIDI OUT transmitter not available");
    }

    long getId() {
        return this.id;
    }

    void open(MidiDevice midiDevice) throws MidiUnavailableException {
        Vector vector = openDeviceList;
        synchronized (vector) {
            if (!openDeviceList.contains(midiDevice)) {
                openDeviceList.addElement(midiDevice);
            }
            this.open();
        }
    }

    void close(MidiDevice midiDevice) {
        Vector vector = openDeviceList;
        synchronized (vector) {
            openDeviceList.removeElement(midiDevice);
            this.close();
        }
    }

    abstract void implOpen() throws MidiUnavailableException;

    abstract void implClose();

    static {
        openDeviceList = new Vector();
        eventDispatcher = new EventDispatcher();
        eventDispatcher.start();
    }
}

