/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AiffFileFormat;
import com.sun.media.sound.SunFileReader;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;

public class AiffFileReader
extends SunFileReader {
    public static final AudioFileFormat.Type[] types = new AudioFileFormat.Type[]{AudioFileFormat.Type.AIFF};

    public AudioFileFormat getAudioFileFormat(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        AudioFormat audioFormat = null;
        AiffFileFormat aiffFileFormat = null;
        int n = 8;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        dataInputStream.mark(n);
        n2 = dataInputStream.readInt();
        n3 = dataInputStream.readInt();
        if (n2 != 1179603533) {
            dataInputStream.reset();
            throw new UnsupportedAudioFileException("not an AIFF file");
        }
        if (n3 <= 0) {
            n3 = -1;
            n4 = -1;
        } else {
            n4 = n3 + 8;
        }
        audioFormat = new AudioFormat(-1.0f, -1, -1, true, true);
        aiffFileFormat = new AiffFileFormat(AudioFileFormat.Type.AIFF, n4, audioFormat, -1);
        dataInputStream.reset();
        return aiffFileFormat;
    }

    public AudioFileFormat getAudioFileFormat(URL uRL) throws UnsupportedAudioFileException, IOException {
        InputStream inputStream = null;
        BufferedInputStream bufferedInputStream = null;
        DataInputStream dataInputStream = null;
        AudioFileFormat audioFileFormat = null;
        Object var6_6 = null;
        inputStream = uRL.openStream();
        bufferedInputStream = new BufferedInputStream(inputStream, 4096);
        audioFileFormat = this.getAudioFileFormat(bufferedInputStream);
        dataInputStream = new DataInputStream(bufferedInputStream);
        audioFileFormat = this.getCOMM(dataInputStream, audioFileFormat);
        bufferedInputStream.close();
        return audioFileFormat;
    }

    public AudioFileFormat getAudioFileFormat(File file) throws UnsupportedAudioFileException, IOException {
        FileInputStream fileInputStream = null;
        BufferedInputStream bufferedInputStream = null;
        DataInputStream dataInputStream = null;
        AudioFileFormat audioFileFormat = null;
        Object var6_6 = null;
        fileInputStream = new FileInputStream(file);
        bufferedInputStream = new BufferedInputStream(fileInputStream, 4096);
        audioFileFormat = this.getAudioFileFormat(bufferedInputStream);
        dataInputStream = new DataInputStream(bufferedInputStream);
        audioFileFormat = this.getCOMM(dataInputStream, audioFileFormat);
        bufferedInputStream.close();
        return audioFileFormat;
    }

    public AudioInputStream getAudioInputStream(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        DataInputStream dataInputStream = null;
        boolean bl = false;
        AudioFileFormat audioFileFormat = null;
        audioFileFormat = this.getAudioFileFormat(inputStream);
        dataInputStream = new DataInputStream(inputStream);
        audioFileFormat = this.getCOMM(dataInputStream, audioFileFormat);
        return new AudioInputStream(dataInputStream, audioFileFormat.getFormat(), audioFileFormat.getFrameLength());
    }

    public AudioInputStream getAudioInputStream(URL uRL) throws UnsupportedAudioFileException, IOException {
        InputStream inputStream = null;
        BufferedInputStream bufferedInputStream = null;
        Object var4_4 = null;
        inputStream = uRL.openStream();
        bufferedInputStream = new BufferedInputStream(inputStream, 4096);
        return this.getAudioInputStream(bufferedInputStream);
    }

    public AudioInputStream getAudioInputStream(File file) throws UnsupportedAudioFileException, IOException {
        FileInputStream fileInputStream = null;
        BufferedInputStream bufferedInputStream = null;
        Object var4_4 = null;
        fileInputStream = new FileInputStream(file);
        bufferedInputStream = new BufferedInputStream(fileInputStream, 4096);
        return this.getAudioInputStream(bufferedInputStream);
    }

    private AudioFileFormat getCOMM(DataInputStream dataInputStream, AudioFileFormat audioFileFormat) throws UnsupportedAudioFileException, IOException {
        AudioFormat.Encoding encoding = null;
        float f = -1.0f;
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        float f2 = -1.0f;
        boolean bl = true;
        int n4 = 0;
        boolean bl2 = false;
        byte[] byArray = new byte[4];
        int n5 = dataInputStream.readInt();
        n4 += 4;
        int n6 = dataInputStream.readInt();
        n4 += 4;
        dataInputStream.read(byArray, 0, 4);
        n4 += 4;
        String string = new String(byArray);
        if (string.startsWith("AIFC")) {
            bl2 = true;
        }
        while (true) {
            int n7;
            int n8 = dataInputStream.readInt();
            byArray[0] = (byte)(n8 >> 24 & 0xFF);
            byArray[1] = (byte)(n8 >> 16 & 0xFF);
            byArray[2] = (byte)(n8 >> 8 & 0xFF);
            byArray[3] = (byte)(n8 & 0xFF);
            string = new String(byArray);
            if (string.startsWith("FVER")) {
                dataInputStream.readLong();
                n4 += 8;
                continue;
            }
            if (string.startsWith("COMM")) {
                n7 = dataInputStream.readInt();
                n4 += 4;
                if (n7 != 18 && n7 < 22) {
                    throw new UnsupportedAudioFileException("Invalid AIFF chunksize");
                }
                n2 = dataInputStream.readShort();
                n4 += 2;
                dataInputStream.readInt();
                n4 += 4;
                n = dataInputStream.readShort();
                n4 += 2;
                f = (float)this.read_ieee_extended(dataInputStream);
                n4 += 10;
                encoding = AudioFormat.Encoding.PCM_SIGNED;
                if (!bl2) continue;
                dataInputStream.read(byArray, 0, 4);
                n4 += 4;
                dataInputStream.skipBytes(n7 - 22);
                n4 += n7 - 22;
                string = new String(byArray);
                if (string.startsWith("NONE")) {
                    encoding = AudioFormat.Encoding.PCM_SIGNED;
                    continue;
                }
                if (string.startsWith("ULAW")) {
                    encoding = AudioFormat.Encoding.ULAW;
                    continue;
                }
                if (string.startsWith("ALAW")) {
                    encoding = AudioFormat.Encoding.ALAW;
                    continue;
                }
                throw new UnsupportedAudioFileException("Invalid AIFF encoding");
            }
            if (string.startsWith("SSND")) {
                n7 = dataInputStream.readInt();
                n4 += 4;
                int n9 = dataInputStream.readInt();
                n4 += 4;
                int n10 = dataInputStream.readInt();
                n4 += 4;
                if (n7 < n6) {
                    n6 = n7 - 8;
                    break;
                }
                n6 -= n4;
                break;
            }
            n7 = dataInputStream.readInt();
            n4 += 4;
            n4 += dataInputStream.skipBytes(n7);
        }
        switch (n) {
            case 8: {
                break;
            }
            case 16: {
                break;
            }
        }
        int n11 = n4;
        n3 = n / 8 * n2;
        f2 = f;
        if (n == 8) {
            encoding = AudioFormat.Encoding.PCM_SIGNED;
        }
        AudioFormat audioFormat = new AudioFormat(encoding, f, n, n2, n3, f2, true);
        return new AiffFileFormat(AudioFileFormat.Type.AIFF, audioFileFormat.getByteLength(), audioFormat, n6 / n3);
    }

    private void write_ieee_extended(DataOutputStream dataOutputStream, double d) throws IOException {
        int n = 16398;
        double d2 = d;
        while (d2 < 44000.0) {
            d2 *= 2.0;
            --n;
        }
        dataOutputStream.writeShort(n);
        dataOutputStream.writeInt((int)d2 << 16);
        dataOutputStream.writeInt(0);
    }

    private double read_ieee_extended(DataInputStream dataInputStream) throws IOException {
        double d = 0.0;
        int n = 0;
        long l = 0L;
        long l2 = 0L;
        double d2 = 3.4028234663852886E38;
        n = dataInputStream.readUnsignedShort();
        long l3 = dataInputStream.readUnsignedShort();
        long l4 = dataInputStream.readUnsignedShort();
        l = l3 << 16 | l4;
        l3 = dataInputStream.readUnsignedShort();
        l4 = dataInputStream.readUnsignedShort();
        l2 = l3 << 16 | l4;
        if (n == 0 && l == 0L && l2 == 0L) {
            d = 0.0;
        } else if (n == Short.MAX_VALUE) {
            d = d2;
        } else {
            n -= 16383;
            d = (double)l * Math.pow(2.0, n -= 31);
            d += (double)l2 * Math.pow(2.0, n -= 32);
        }
        return d;
    }
}

