/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AbstractDataLine;
import com.sun.media.sound.CircularBuffer;
import com.sun.media.sound.HeadspaceMixer;
import com.sun.media.sound.Platform;
import com.sun.media.sound.Printer;
import com.sun.media.sound.Toolkit;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.BooleanControl;
import javax.sound.sampled.Control;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;

public class MixerSourceLine
extends AbstractDataLine
implements SourceDataLine {
    private CircularBuffer circularBuffer = null;
    private byte[] dataBuffer = null;
    private long id;
    private int finalPosition = 0;
    private boolean implStarted = false;
    MixerSourceLineGainControl gainControl;

    MixerSourceLine(DataLine.Info info, HeadspaceMixer headspaceMixer, AudioFormat audioFormat, int n) throws LineUnavailableException {
        super(info, headspaceMixer, new Control[5], audioFormat, n);
        if (Printer.trace) {
            Printer.trace("MixerSourceLine: constructor: format: " + audioFormat + " bufferSize: " + n);
        }
        this.gainControl = new MixerSourceLineGainControl();
        this.controls[0] = this.gainControl;
        this.controls[1] = new MixerSourceLineMuteControl();
        this.controls[2] = new MixerSourceLinePanControl();
        this.controls[3] = new MixerSourceLineSampleRateControl();
        this.controls[4] = new MixerSourceLineApplyReverbControl();
    }

    public int write(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            if (Printer.verbose) {
                Printer.verbose("> MixerSourceLine.write: b: " + byArray);
            }
            this.circularBuffer.markEnd();
            return 0;
        }
        if (Printer.verbose) {
            Printer.verbose("> MixerSourceLine.write(b.length: " + byArray.length + " off: " + n + " len: " + n2);
        }
        int n3 = n2;
        if (n2 % this.getFormat().getFrameSize() != 0) {
            throw new IllegalArgumentException("Illegal request to write non-integral number of frames (" + n2 + " bytes )");
        }
        int n4 = 0;
        int n5 = 0;
        while (this.isOpen() && this.isStartedRunning() && n4 < n3) {
            n5 = this.circularBuffer.write(byArray, n, n3 - n4);
            n += n5;
            if ((n4 += n5) >= n3) continue;
            MixerSourceLine mixerSourceLine = this;
            synchronized (mixerSourceLine) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (Printer.trace) {
            Printer.trace("< MixerSourceLine.write write: " + n4 + " bytes or " + n4 / this.getFormat().getFrameSize() + " frames");
        }
        return n4;
    }

    public int available() {
        return this.circularBuffer.bytesAvailableToWrite();
    }

    synchronized void implOpen(AudioFormat audioFormat, int n) throws LineUnavailableException {
        if (Printer.trace) {
            Printer.trace(">> MixerSourceLine: implOpen");
        }
        if (audioFormat.getSampleRate() == -1.0f) {
            audioFormat = new AudioFormat(audioFormat.getEncoding(), this.mixer.getFormat().getSampleRate(), audioFormat.getSampleSizeInBits(), audioFormat.getChannels(), audioFormat.getFrameSize(), audioFormat.getFrameRate(), audioFormat.isBigEndian());
        }
        if (n == -1) {
            n = MixerSourceLine.calculateBufferSizeInBytes(audioFormat);
        }
        boolean bl = false;
        boolean bl2 = false;
        if (this.getFormat().getSampleSizeInBits() == 8 && this.getFormat().getEncoding() == AudioFormat.Encoding.PCM_SIGNED) {
            bl = true;
        }
        if (this.getFormat().getSampleSizeInBits() > 8 && this.getFormat().isBigEndian() != Platform.isBigEndian()) {
            bl2 = true;
        }
        if (this.circularBuffer == null || this.circularBuffer.getByteLength() != n) {
            this.circularBuffer = new CircularBuffer(n, bl, bl2);
        }
        if (this.dataBuffer == null || this.dataBuffer.length != n) {
            this.dataBuffer = new byte[n];
        }
        this.id = this.nOpen(this.getFormat().getSampleSizeInBits(), this.getFormat().getChannels(), this.getFormat().getSampleRate(), n);
        this.format = audioFormat;
        this.bufferSize = n;
        if (this.id == 0L) {
            throw new LineUnavailableException("Failed to allocate native stream.");
        }
        if (Printer.debug) {
            Printer.debug("MixerSourceLine: constructor: id = " + this.id);
        }
        if (Printer.trace) {
            Printer.trace("<< MixerSourceLine: implOpen succeeded");
        }
    }

    synchronized void implClose() {
        if (Printer.trace) {
            Printer.trace(">> MixerSourceLine: implClose");
        }
        this.nClose(this.id);
        while (this.id != 0L) {
            MixerSourceLine mixerSourceLine = this;
            synchronized (mixerSourceLine) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (Printer.trace) {
            Printer.trace("<< MixerSourceLine: implClose succeeded");
        }
    }

    void implStart() {
        if (Printer.trace) {
            Printer.trace(">> MixerSourceLine: implStart");
        }
        if (!this.implStarted) {
            if (Printer.debug) {
                Printer.debug("MixerSourceLine: implStart: starting the stream");
            }
            this.nStart(this.id);
            this.implStarted = true;
        } else {
            if (Printer.debug) {
                Printer.debug("MixerSourceLine: implStart: resuming the stream");
            }
            this.nResume(this.id);
        }
        if (Printer.trace) {
            Printer.trace("<< MixerSourceLine: implStart succeeded");
        }
    }

    void implStop() {
        if (Printer.trace) {
            Printer.trace(">> MixerSourceLine: implStop");
        }
        this.nPause(this.id);
        if (Printer.trace) {
            Printer.trace("<< MixerSourceLine: implStop succeeded");
        }
    }

    public float getLevel() {
        return this.id != 0L ? this.nGetLevel(this.id) : -1.0f;
    }

    public void drain() {
        this.circularBuffer.drain();
        this.nDrain(this.id);
    }

    public void flush() {
        this.circularBuffer.flush();
        this.nFlush(this.id);
    }

    public int getFramePosition() {
        return this.id != 0L ? (int)this.nGetPosition(this.id) : this.finalPosition;
    }

    long getId() {
        return this.id;
    }

    private static int calculateBufferSizeInBytes(AudioFormat audioFormat) {
        int n = (int)audioFormat.getFrameRate() / 2;
        int n2 = 1;
        while (n > n2) {
            n2 *= 2;
        }
        return n2 * audioFormat.getFrameSize();
    }

    private synchronized int callbackStreamGetData(byte[] byArray, int n) {
        if (Printer.verbose) {
            Printer.verbose("MixerSourceLine: callbackStreamGetData: dataArray.length: " + byArray.length + " frameLength: " + n);
        }
        int n2 = this.getFormat().getFrameSize();
        int n3 = n * n2;
        int n4 = this.circularBuffer.read(byArray, 0, n3 = Math.min(n3, byArray.length));
        n4 = n4 > 0 ? n4 / n2 : n4;
        this.notifyAll();
        if (Printer.verbose) {
            Printer.verbose("MixerSourceLine: callbackStreamGetData: returning length: " + n4);
        }
        return n4;
    }

    private void callbackStreamDestroy() {
        if (Printer.trace) {
            Printer.trace(">> MixerSourceLine: callbackStreamDestroy()");
        }
        this.finalPosition = this.getFramePosition();
        this.id = 0L;
        MixerSourceLine mixerSourceLine = this;
        synchronized (mixerSourceLine) {
            this.notifyAll();
        }
        if (Printer.trace) {
            Printer.trace("<< MixerSourceLine: callbackStreamDestroy() completed");
        }
    }

    private void callbackStreamStart() {
        if (Printer.trace) {
            Printer.trace(">> MixerSourceLine: callbackStreamStart()");
        }
        this.setActive(true);
        this.setStarted(true);
        if (Printer.trace) {
            Printer.trace("<< MixerSourceLine: callbackStreamStart() completed");
        }
    }

    private void callbackStreamStop() {
        if (Printer.trace) {
            Printer.trace(">> MixerSourceLine: callbackStreamStop()");
        }
        this.setActive(false);
        this.setStarted(false);
        if (Printer.trace) {
            Printer.trace("<< MixerSourceLine: callbackStreamStop() completed");
        }
    }

    private void callbackStreamEOM() {
        if (Printer.trace) {
            Printer.trace(">> MixerSourceLine: callbackStreamEOM()");
        }
        this.setActive(false);
        this.setEOM();
        if (Printer.trace) {
            Printer.trace("<< MixerSourceLine: callbackStreamEOM() completed");
        }
    }

    private void callbackStreamActive() {
        if (Printer.trace) {
            Printer.trace(">> MixerSourceLine: callbackStreamActive()");
        }
        this.setActive(true);
        if (Printer.trace) {
            Printer.trace("<< MixerSourceLine: callbackStreamActive() completed");
        }
    }

    private void callbackStreamInactive() {
        if (Printer.trace) {
            Printer.trace(">> MixerSourceLine: callbackStreamInactive()");
        }
        this.setActive(false);
        if (Printer.trace) {
            Printer.trace("<< MixerSourceLine: callbackStreamInactive() completed");
        }
    }

    private native void nDrain(long var1);

    private native void nFlush(long var1);

    private native long nGetPosition(long var1);

    private native float nGetLevel(long var1);

    private native long nOpen(int var1, int var2, float var3, int var4) throws LineUnavailableException;

    private native void nStart(long var1);

    private native void nResume(long var1);

    private native void nPause(long var1);

    private native void nClose(long var1);

    protected native float nSetLinearGain(long var1, float var3);

    protected native float nSetPan(long var1, float var3);

    protected native int nSetSampleRate(long var1, int var3);

    private class MixerSourceLineApplyReverbControl
    extends BooleanControl {
        private MixerSourceLineApplyReverbControl() {
            super(BooleanControl.Type.APPLY_REVERB, false, "Yes", "No");
        }

        public void setValue(boolean bl) {
            if (!MixerSourceLine.this.isOpen()) {
                return;
            }
            if (bl == this.getValue() || MixerSourceLine.this.id != 0L) {
                // empty if block
            }
            super.setValue(bl);
        }
    }

    private class MixerSourceLineMuteControl
    extends BooleanControl {
        private MixerSourceLineMuteControl() {
            super(BooleanControl.Type.MUTE, false, "True", "False");
        }

        public void setValue(boolean bl) {
            if (!MixerSourceLine.this.isOpen()) {
                return;
            }
            if (bl && !this.getValue() && MixerSourceLine.this.id != 0L) {
                MixerSourceLine.this.nSetLinearGain(MixerSourceLine.this.id, 0.0f);
            } else if (!bl && this.getValue() && MixerSourceLine.this.id != 0L) {
                float f = Toolkit.dBToLinear(MixerSourceLine.this.gainControl.getValue());
                MixerSourceLine.this.nSetLinearGain(MixerSourceLine.this.id, f);
            }
            super.setValue(bl);
        }
    }

    private class MixerSourceLineSampleRateControl
    extends FloatControl {
        private MixerSourceLineSampleRateControl() {
            super(FloatControl.Type.SAMPLE_RATE, 0.0f, 48000.0f, 1.0f, -1, MixerSourceLine.this.getFormat().getFrameRate(), "FPS", "Minimum", "", "Maximum");
        }

        public void setValue(float f) {
            if (!MixerSourceLine.this.isOpen()) {
                return;
            }
            f = Math.min(f, this.getMaximum());
            if ((f = Math.max(f, this.getMinimum())) != this.getValue() && MixerSourceLine.this.id != 0L) {
                f = MixerSourceLine.this.nSetSampleRate(MixerSourceLine.this.id, (int)f);
            }
            super.setValue(f);
        }

        private void update() {
            super.setValue(MixerSourceLine.this.getFormat().getFrameRate());
        }
    }

    private class MixerSourceLinePanControl
    extends FloatControl {
        private MixerSourceLinePanControl() {
            super(FloatControl.Type.PAN, -1.0f, 1.0f, 0.015625f, -1, 0.0f, "", "Left", "Center", "Right");
        }

        public void setValue(float f) {
            if (!MixerSourceLine.this.isOpen()) {
                return;
            }
            f = Math.min(f, this.getMaximum());
            if ((f = Math.max(f, this.getMinimum())) != this.getValue() && MixerSourceLine.this.id != 0L) {
                f = -1.0f * MixerSourceLine.this.nSetPan(MixerSourceLine.this.id, -1.0f * f);
            }
            super.setValue(f);
        }
    }

    private class MixerSourceLineGainControl
    extends FloatControl {
        private float linearGain = 1.0f;

        private MixerSourceLineGainControl() {
            super(FloatControl.Type.MASTER_GAIN, Toolkit.linearToDB(0.0f), Toolkit.linearToDB(5.0f), Toolkit.linearToDB(0.0078125f), -1, 0.0f, "dB", "Minimum", "", "Maximum");
        }

        public void setValue(float f) {
            if (!MixerSourceLine.this.isOpen()) {
                return;
            }
            f = Math.min(f, this.getMaximum());
            float f2 = Toolkit.dBToLinear(f = Math.max(f, this.getMinimum()));
            if (f2 != this.linearGain && MixerSourceLine.this.id != 0L) {
                f2 = MixerSourceLine.this.nSetLinearGain(MixerSourceLine.this.id, f2);
            }
            this.linearGain = f2;
            super.setValue(Toolkit.linearToDB(this.linearGain));
        }
    }
}

