/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import sun.awt.geom.Crossings;

public class Polygon
implements Shape,
Serializable {
    public int npoints = 0;
    public int[] xpoints = new int[4];
    public int[] ypoints = new int[4];
    protected Rectangle bounds = null;
    private static final long serialVersionUID = -6460061437900069969L;

    public Polygon() {
    }

    public Polygon(int[] nArray, int[] nArray2, int n) {
        this.npoints = n;
        this.xpoints = new int[n];
        this.ypoints = new int[n];
        System.arraycopy(nArray, 0, this.xpoints, 0, n);
        System.arraycopy(nArray2, 0, this.ypoints, 0, n);
    }

    public void translate(int n, int n2) {
        int n3 = 0;
        while (n3 < this.npoints) {
            int n4 = n3;
            this.xpoints[n4] = this.xpoints[n4] + n;
            int n5 = n3++;
            this.ypoints[n5] = this.ypoints[n5] + n2;
        }
        if (this.bounds != null) {
            this.bounds.translate(n, n2);
        }
    }

    void calculateBounds(int[] nArray, int[] nArray2, int n) {
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MIN_VALUE;
        int n5 = Integer.MIN_VALUE;
        int n6 = 0;
        while (n6 < n) {
            int n7 = nArray[n6];
            n2 = Math.min(n2, n7);
            n4 = Math.max(n4, n7);
            int n8 = nArray2[n6];
            n3 = Math.min(n3, n8);
            n5 = Math.max(n5, n8);
            ++n6;
        }
        this.bounds = new Rectangle(n2, n3, n4 - n2, n5 - n3);
    }

    void updateBounds(int n, int n2) {
        if (n < this.bounds.x) {
            this.bounds.width += this.bounds.x - n;
            this.bounds.x = n;
        } else {
            this.bounds.width = Math.max(this.bounds.width, n - this.bounds.x);
        }
        if (n2 < this.bounds.y) {
            this.bounds.height += this.bounds.y - n2;
            this.bounds.y = n2;
        } else {
            this.bounds.height = Math.max(this.bounds.height, n2 - this.bounds.y);
        }
    }

    public void addPoint(int n, int n2) {
        if (this.npoints == this.xpoints.length) {
            int[] nArray = new int[this.npoints * 2];
            System.arraycopy(this.xpoints, 0, nArray, 0, this.npoints);
            this.xpoints = nArray;
            nArray = new int[this.npoints * 2];
            System.arraycopy(this.ypoints, 0, nArray, 0, this.npoints);
            this.ypoints = nArray;
        }
        this.xpoints[this.npoints] = n;
        this.ypoints[this.npoints] = n2;
        ++this.npoints;
        if (this.bounds != null) {
            this.updateBounds(n, n2);
        }
    }

    public Rectangle getBounds() {
        if (this.bounds != null) {
            return this.bounds.getBounds();
        }
        return this.getBoundingBox();
    }

    public Rectangle getBoundingBox() {
        this.calculateBounds(this.xpoints, this.ypoints, this.npoints);
        return this.bounds;
    }

    public boolean contains(Point point) {
        return this.contains(point.x, point.y);
    }

    public boolean contains(int n, int n2) {
        return this.contains((double)n, (double)n2);
    }

    public boolean inside(int n, int n2) {
        return this.contains((double)n, (double)n2);
    }

    public Rectangle2D getBounds2D() {
        Rectangle rectangle = this.getBounds();
        return new Rectangle2D.Float(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    /*
     * Unable to fully structure code
     */
    public boolean contains(double var1_1, double var3_2) {
        if (this.npoints <= 2 || !this.getBoundingBox().contains(var1_1, var3_2)) {
            return false;
        }
        var5_3 = 0;
        var6_4 = this.xpoints[this.npoints - 1];
        var7_5 = this.ypoints[this.npoints - 1];
        var10_6 = 0;
        while (var10_6 < this.npoints) {
            block8: {
                block11: {
                    block12: {
                        block10: {
                            block9: {
                                var8_7 = this.xpoints[var10_6];
                                var9_8 = this.ypoints[var10_6];
                                if (var9_8 == var7_5) break block8;
                                if (var8_7 >= var6_4) break block9;
                                if (var1_1 >= (double)var6_4) break block8;
                                var11_9 = var8_7;
                                break block10;
                            }
                            if (var1_1 >= (double)var8_7) break block8;
                            var11_9 = var6_4;
                        }
                        if (var9_8 >= var7_5) break block11;
                        if (var3_2 < (double)var9_8 || var3_2 >= (double)var7_5) break block8;
                        if (!(var1_1 < (double)var11_9)) break block12;
                        ++var5_3;
                        break block8;
                    }
                    var12_10 = var1_1 - (double)var8_7;
                    var14_11 = var3_2 - (double)var9_8;
                    ** GOTO lbl35
                }
                if (var3_2 < (double)var7_5 || var3_2 >= (double)var9_8) break block8;
                if (var1_1 < (double)var11_9) {
                    ++var5_3;
                } else {
                    var12_10 = var1_1 - (double)var6_4;
                    var14_11 = var3_2 - (double)var7_5;
lbl35:
                    // 2 sources

                    if (var12_10 < var14_11 / (double)(var7_5 - var9_8) * (double)(var6_4 - var8_7)) {
                        ++var5_3;
                    }
                }
            }
            var6_4 = var8_7;
            var7_5 = var9_8;
            ++var10_6;
        }
        return (var5_3 & true) != false;
    }

    private Crossings getCrossings(double d, double d2, double d3, double d4) {
        Crossings.EvenOdd evenOdd = new Crossings.EvenOdd(d, d2, d3, d4);
        int n = this.xpoints[this.npoints - 1];
        int n2 = this.ypoints[this.npoints - 1];
        int n3 = 0;
        while (n3 < this.npoints) {
            int n4 = this.xpoints[n3];
            int n5 = this.ypoints[n3];
            if (evenOdd.accumulateLine(n, n2, n4, n5)) {
                return null;
            }
            n = n4;
            n2 = n5;
            ++n3;
        }
        return evenOdd;
    }

    public boolean contains(Point2D point2D) {
        return this.contains(point2D.getX(), point2D.getY());
    }

    public boolean intersects(double d, double d2, double d3, double d4) {
        if (this.npoints <= 0 || !this.getBoundingBox().intersects(d, d2, d3, d4)) {
            return false;
        }
        Crossings crossings = this.getCrossings(d, d2, d + d3, d2 + d4);
        return crossings == null || !crossings.isEmpty();
    }

    public boolean intersects(Rectangle2D rectangle2D) {
        return this.intersects(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public boolean contains(double d, double d2, double d3, double d4) {
        if (this.npoints <= 0 || !this.getBoundingBox().intersects(d, d2, d3, d4)) {
            return false;
        }
        Crossings crossings = this.getCrossings(d, d2, d + d3, d2 + d4);
        return crossings != null && crossings.covers(d2, d2 + d4);
    }

    public boolean contains(Rectangle2D rectangle2D) {
        return this.contains(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public PathIterator getPathIterator(AffineTransform affineTransform) {
        return new PolygonPathIterator(this, affineTransform);
    }

    public PathIterator getPathIterator(AffineTransform affineTransform, double d) {
        return this.getPathIterator(affineTransform);
    }

    class PolygonPathIterator
    implements PathIterator {
        Polygon poly;
        AffineTransform transform;
        int index;

        public PolygonPathIterator(Polygon polygon2, AffineTransform affineTransform) {
            this.poly = polygon2;
            this.transform = affineTransform;
        }

        public int getWindingRule() {
            return 0;
        }

        public boolean isDone() {
            return this.index > this.poly.npoints;
        }

        public void next() {
            ++this.index;
        }

        public int currentSegment(float[] fArray) {
            if (this.index >= this.poly.npoints) {
                return 4;
            }
            fArray[0] = this.poly.xpoints[this.index];
            fArray[1] = this.poly.ypoints[this.index];
            if (this.transform != null) {
                this.transform.transform(fArray, 0, fArray, 0, 1);
            }
            return this.index == 0 ? 0 : 1;
        }

        public int currentSegment(double[] dArray) {
            if (this.index >= this.poly.npoints) {
                return 4;
            }
            dArray[0] = this.poly.xpoints[this.index];
            dArray[1] = this.poly.ypoints[this.index];
            if (this.transform != null) {
                this.transform.transform(dArray, 0, dArray, 0, 1);
            }
            return this.index == 0 ? 0 : 1;
        }
    }
}

