/*
 * Decompiled with CFR 0.152.
 */
package java.awt.font;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.GraphicAttribute;
import java.awt.geom.Rectangle2D;

public final class ShapeGraphicAttribute
extends GraphicAttribute {
    private Shape fShape;
    private boolean fStroke;
    public static final boolean STROKE = true;
    public static final boolean FILL = false;
    private Rectangle2D fShapeBounds;

    public ShapeGraphicAttribute(Shape shape, int n, boolean bl) {
        super(n);
        this.fShape = shape;
        this.fStroke = bl;
        this.fShapeBounds = this.fShape.getBounds2D();
    }

    public float getAscent() {
        return (float)Math.max(0.0, -this.fShapeBounds.getMinY());
    }

    public float getDescent() {
        return (float)Math.max(0.0, this.fShapeBounds.getMaxY());
    }

    public float getAdvance() {
        return (float)Math.max(0.0, this.fShapeBounds.getMaxX());
    }

    public void draw(Graphics2D graphics2D, float f, float f2) {
        graphics2D.translate((int)f, (int)f2);
        try {
            if (this.fStroke) {
                graphics2D.draw(this.fShape);
            } else {
                graphics2D.fill(this.fShape);
            }
            Object var5_4 = null;
            graphics2D.translate(-((int)f), -((int)f2));
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            graphics2D.translate(-((int)f), -((int)f2));
            throw throwable;
        }
    }

    public Rectangle2D getBounds() {
        Rectangle2D.Float float_ = new Rectangle2D.Float();
        float_.setRect(this.fShapeBounds);
        if (this.fStroke) {
            float_.width += 1.0f;
            float_.height += 1.0f;
        }
        return float_;
    }

    public int hashCode() {
        return this.fShape.hashCode();
    }

    public boolean equals(Object object) {
        try {
            return this.equals((ShapeGraphicAttribute)object);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public boolean equals(ShapeGraphicAttribute shapeGraphicAttribute) {
        if (shapeGraphicAttribute == null) {
            return false;
        }
        if (this == shapeGraphicAttribute) {
            return true;
        }
        if (this.fStroke != shapeGraphicAttribute.fStroke) {
            return false;
        }
        if (this.getAlignment() != shapeGraphicAttribute.getAlignment()) {
            return false;
        }
        return this.fShape.equals(shapeGraphicAttribute.fShape);
    }
}

