/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.PackedColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;

public class DirectColorModel
extends PackedColorModel {
    private int red_mask;
    private int green_mask;
    private int blue_mask;
    private int alpha_mask;
    private int red_offset;
    private int green_offset;
    private int blue_offset;
    private int alpha_offset;
    private int red_scale;
    private int green_scale;
    private int blue_scale;
    private int alpha_scale;

    public DirectColorModel(int n, int n2, int n3, int n4) {
        this(n, n2, n3, n4, 0);
    }

    public DirectColorModel(int n, int n2, int n3, int n4, int n5) {
        super(ColorSpace.getInstance(1000), n, n2, n3, n4, n5, false, n5 == 0 ? 1 : 3, ColorModel.getDefaultTransferType(n));
        this.setFields();
    }

    public DirectColorModel(ColorSpace colorSpace, int n, int n2, int n3, int n4, int n5, boolean bl, int n6) {
        super(colorSpace, n, n2, n3, n4, n5, bl, n5 == 0 ? 1 : 3, n6);
        this.setFields();
    }

    public final int getRedMask() {
        return this.maskArray[0];
    }

    public final int getGreenMask() {
        return this.maskArray[1];
    }

    public final int getBlueMask() {
        return this.maskArray[2];
    }

    public final int getAlphaMask() {
        if (this.supportsAlpha) {
            return this.maskArray[3];
        }
        return 0;
    }

    private float[] getDefaultRGBComponents(int n) {
        int[] nArray = this.getComponents(n, (int[])null, 0);
        float[] fArray = this.getNormalizedComponents(nArray, 0, null, 0);
        return this.colorSpace.toRGB(fArray);
    }

    public final int getRed(int n) {
        if (!this.is_sRGB) {
            float[] fArray = this.getDefaultRGBComponents(n);
            return (int)(fArray[0] * 255.0f);
        }
        int n2 = (n & this.maskArray[0]) >>> this.maskOffsets[0];
        if (this.scaleFactors[0] != 1.0) {
            n2 = (int)((double)n2 * this.scaleFactors[0]);
        }
        if (this.isAlphaPremultiplied) {
            int n3 = this.getAlpha(n);
            int n4 = n2 = n3 == 0 ? 0 : n2 * 255 / n3;
            if (n2 > 255) {
                n2 = 255;
            }
        }
        return n2;
    }

    public final int getGreen(int n) {
        if (!this.is_sRGB) {
            float[] fArray = this.getDefaultRGBComponents(n);
            return (int)(fArray[1] * 255.0f);
        }
        int n2 = (n & this.maskArray[1]) >>> this.maskOffsets[1];
        if (this.scaleFactors[1] != 1.0) {
            n2 = (int)((double)n2 * this.scaleFactors[1]);
        }
        if (this.isAlphaPremultiplied) {
            int n3 = this.getAlpha(n);
            int n4 = n2 = n3 == 0 ? 0 : n2 * 255 / n3;
            if (n2 > 255) {
                n2 = 255;
            }
        }
        return n2;
    }

    public final int getBlue(int n) {
        if (!this.is_sRGB) {
            float[] fArray = this.getDefaultRGBComponents(n);
            return (int)(fArray[2] * 255.0f);
        }
        int n2 = (n & this.maskArray[2]) >>> this.maskOffsets[2];
        if (this.scaleFactors[2] != 1.0) {
            n2 = (int)((double)n2 * this.scaleFactors[2]);
        }
        if (this.isAlphaPremultiplied) {
            int n3 = this.getAlpha(n);
            int n4 = n2 = n3 == 0 ? 0 : n2 * 255 / n3;
            if (n2 > 255) {
                n2 = 255;
            }
        }
        return n2;
    }

    public final int getAlpha(int n) {
        if (!this.supportsAlpha) {
            return 255;
        }
        int n2 = (n & this.maskArray[3]) >>> this.maskOffsets[3];
        if (this.scaleFactors[3] != 1.0) {
            n2 = (int)((double)n2 * this.scaleFactors[3]);
        }
        return n2;
    }

    public final int getRGB(int n) {
        if (!this.is_sRGB) {
            float[] fArray = this.getDefaultRGBComponents(n);
            return this.getAlpha(n) << 24 | (int)(fArray[0] * 255.0f) << 16 | (int)(fArray[1] * 255.0f) << 8 | (int)(fArray[2] * 255.0f) << 0;
        }
        return this.getAlpha(n) << 24 | this.getRed(n) << 16 | this.getGreen(n) << 8 | this.getBlue(n) << 0;
    }

    public int getRed(Object object) {
        int n = 0;
        switch (this.transferType) {
            case 0: {
                byte[] byArray = (byte[])object;
                n = byArray[0] & 0xFF;
                break;
            }
            case 1: {
                short[] sArray = (short[])object;
                n = sArray[0] & 0xFFFF;
                break;
            }
            case 3: {
                int[] nArray = (int[])object;
                n = nArray[0];
                break;
            }
            default: {
                throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
            }
        }
        return this.getRed(n);
    }

    public int getGreen(Object object) {
        int n = 0;
        switch (this.transferType) {
            case 0: {
                byte[] byArray = (byte[])object;
                n = byArray[0] & 0xFF;
                break;
            }
            case 1: {
                short[] sArray = (short[])object;
                n = sArray[0] & 0xFFFF;
                break;
            }
            case 3: {
                int[] nArray = (int[])object;
                n = nArray[0];
                break;
            }
            default: {
                throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
            }
        }
        return this.getGreen(n);
    }

    public int getBlue(Object object) {
        int n = 0;
        switch (this.transferType) {
            case 0: {
                byte[] byArray = (byte[])object;
                n = byArray[0] & 0xFF;
                break;
            }
            case 1: {
                short[] sArray = (short[])object;
                n = sArray[0] & 0xFFFF;
                break;
            }
            case 3: {
                int[] nArray = (int[])object;
                n = nArray[0];
                break;
            }
            default: {
                throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
            }
        }
        return this.getBlue(n);
    }

    public int getAlpha(Object object) {
        int n = 0;
        switch (this.transferType) {
            case 0: {
                byte[] byArray = (byte[])object;
                n = byArray[0] & 0xFF;
                break;
            }
            case 1: {
                short[] sArray = (short[])object;
                n = sArray[0] & 0xFFFF;
                break;
            }
            case 3: {
                int[] nArray = (int[])object;
                n = nArray[0];
                break;
            }
            default: {
                throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
            }
        }
        return this.getAlpha(n);
    }

    public int getRGB(Object object) {
        int n = 0;
        switch (this.transferType) {
            case 0: {
                byte[] byArray = (byte[])object;
                n = byArray[0] & 0xFF;
                break;
            }
            case 1: {
                short[] sArray = (short[])object;
                n = sArray[0] & 0xFFFF;
                break;
            }
            case 3: {
                int[] nArray = (int[])object;
                n = nArray[0];
                break;
            }
            default: {
                throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
            }
        }
        return this.getRGB(n);
    }

    public Object getDataElements(int n, Object object) {
        int[] nArray = null;
        nArray = this.transferType == 3 && object != null ? (int[])object : new int[1];
        ColorModel colorModel = ColorModel.getRGBdefault();
        if (this == colorModel || this.equals(colorModel)) {
            nArray[0] = n;
        } else if (this.is_sRGB) {
            int n2;
            double d = 1.0;
            if (this.supportsAlpha && this.isAlphaPremultiplied) {
                d = (double)(n >> 24 & 0xFF) / 255.0;
            }
            int[] nArray2 = new int[]{16, 8, 0, 24};
            nArray[0] = 0;
            int n3 = 0;
            while (n3 < 3) {
                n2 = (int)((double)(n >> nArray2[n3] & 0xFF) * d / this.scaleFactors[n3]);
                nArray[0] = nArray[0] | n2 << this.maskOffsets[n3] & this.maskArray[n3];
                ++n3;
            }
            if (this.supportsAlpha) {
                n2 = (int)((double)(n >> nArray2[3] & 0xFF) / this.scaleFactors[3]);
                nArray[0] = nArray[0] | n2 << this.maskOffsets[3] & this.maskArray[3];
            }
        } else {
            int n4;
            int[] nArray3 = colorModel.getComponents(n, (int[])null, 0);
            float[] fArray = colorModel.getNormalizedComponents(nArray3, 0, null, 0);
            float[] fArray2 = this.colorSpace.fromRGB(fArray);
            double d = 1.0;
            if (this.supportsAlpha && this.isAlphaPremultiplied) {
                d = (double)(n >> 24 & 0xFF) / 255.0;
            }
            nArray[0] = 0;
            int n5 = 0;
            while (n5 < 3) {
                n4 = (int)((double)fArray2[n5] * 255.0 * d / this.scaleFactors[n5]);
                nArray[0] = nArray[0] | n4 << this.maskOffsets[n5] & this.maskArray[n5];
                ++n5;
            }
            if (this.supportsAlpha) {
                n4 = (int)((double)(n >> 24 & 0xFF) / this.scaleFactors[3]);
                nArray[0] = nArray[0] | n4 << this.maskOffsets[3] & this.maskArray[3];
            }
        }
        switch (this.transferType) {
            case 0: {
                byte[] byArray = object == null ? new byte[1] : (byte[])object;
                byArray[0] = (byte)(0xFF & nArray[0]);
                return byArray;
            }
            case 1: {
                short[] sArray = object == null ? new short[1] : (short[])object;
                sArray[0] = (short)(nArray[0] & 0xFFFF);
                return sArray;
            }
            case 3: {
                return nArray;
            }
        }
        throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
    }

    public final int[] getComponents(int n, int[] nArray, int n2) {
        if (nArray == null) {
            nArray = new int[n2 + this.numComponents];
        }
        int n3 = 0;
        while (n3 < this.numComponents) {
            nArray[n2 + n3] = (n & this.maskArray[n3]) >>> this.maskOffsets[n3];
            ++n3;
        }
        return nArray;
    }

    public final int[] getComponents(Object object, int[] nArray, int n) {
        int n2 = 0;
        switch (this.transferType) {
            case 0: {
                byte[] byArray = (byte[])object;
                n2 = byArray[0] & 0xFF;
                break;
            }
            case 1: {
                short[] sArray = (short[])object;
                n2 = sArray[0] & 0xFFFF;
                break;
            }
            case 3: {
                int[] nArray2 = (int[])object;
                n2 = nArray2[0];
                break;
            }
            default: {
                throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
            }
        }
        return this.getComponents(n2, nArray, n);
    }

    public final WritableRaster createCompatibleWritableRaster(int n, int n2) {
        int[] nArray;
        if (this.supportsAlpha) {
            nArray = new int[4];
            nArray[3] = this.alpha_mask;
        } else {
            nArray = new int[]{this.red_mask, this.green_mask, this.blue_mask};
        }
        if (this.pixel_bits > 16) {
            return Raster.createPackedRaster(3, n, n2, nArray, null);
        }
        if (this.pixel_bits > 8) {
            return Raster.createPackedRaster(1, n, n2, nArray, null);
        }
        return Raster.createPackedRaster(0, n, n2, nArray, null);
    }

    public int getDataElement(int[] nArray, int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.numComponents) {
            n2 |= nArray[n + n3] << this.maskOffsets[n3] & this.maskArray[n3];
            ++n3;
        }
        return n2;
    }

    public Object getDataElements(int[] nArray, int n, Object object) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.numComponents) {
            n2 |= nArray[n + n3] << this.maskOffsets[n3] & this.maskArray[n3];
            ++n3;
        }
        switch (this.transferType) {
            case 0: {
                if (object instanceof byte[]) {
                    byte[] byArray = (byte[])object;
                    byArray[0] = (byte)(n2 & 0xFF);
                    return byArray;
                }
                if (object != null) {
                    throw new ClassCastException("obj does not match transferType");
                }
                byte[] byArray = new byte[]{(byte)(n2 & 0xFF)};
                return byArray;
            }
            case 1: {
                if (object instanceof short[]) {
                    short[] sArray = (short[])object;
                    sArray[0] = (short)(n2 & 0xFFFF);
                    return sArray;
                }
                if (object != null) {
                    throw new ClassCastException("obj does not match transferType");
                }
                short[] sArray = new short[]{(short)(n2 & 0xFFFF)};
                return sArray;
            }
            case 3: {
                if (object instanceof int[]) {
                    int[] nArray2 = (int[])object;
                    nArray2[0] = n2;
                    return nArray2;
                }
                if (object != null) {
                    throw new ClassCastException("obj does not match transferType");
                }
                int[] nArray3 = new int[]{n2};
                return nArray3;
            }
        }
        throw new ClassCastException("This method has not been implemented for transferType " + this.transferType);
    }

    public final ColorModel coerceData(WritableRaster writableRaster, boolean bl) {
        block36: {
            int[] nArray;
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            block35: {
                if (!this.supportsAlpha || this.isAlphaPremultiplied() == bl) {
                    return this;
                }
                n6 = writableRaster.getWidth();
                n5 = writableRaster.getHeight();
                n4 = this.numColorComponents;
                n3 = (1 << this.nBits[n4]) - 1;
                n2 = writableRaster.getMinX();
                n = writableRaster.getMinY();
                nArray = null;
                if (!bl) break block35;
                switch (this.transferType) {
                    case 0: {
                        int n7 = 0;
                        while (n7 < n5) {
                            int n8 = n2;
                            int n9 = 0;
                            while (n9 < n6) {
                                float f = (nArray = writableRaster.getPixel(n8, n, nArray))[n4] / n3;
                                if (f != 0.0f) {
                                    int n10 = 0;
                                    while (n10 < n4) {
                                        nArray[n10] = (int)((float)nArray[n10] * f);
                                        ++n10;
                                    }
                                    writableRaster.setPixel(n8, n, nArray);
                                }
                                ++n9;
                                ++n8;
                            }
                            ++n7;
                            ++n;
                        }
                        break block36;
                    }
                    case 1: {
                        int n11 = 0;
                        while (n11 < n5) {
                            int n12 = n2;
                            int n13 = 0;
                            while (n13 < n6) {
                                float f = (nArray = writableRaster.getPixel(n12, n, nArray))[n4] / n3;
                                if (f != 0.0f) {
                                    int n14 = 0;
                                    while (n14 < n4) {
                                        nArray[n14] = (int)((float)nArray[n14] * f);
                                        ++n14;
                                    }
                                    writableRaster.setPixel(n12, n, nArray);
                                }
                                ++n13;
                                ++n12;
                            }
                            ++n11;
                            ++n;
                        }
                        break block36;
                    }
                    case 3: {
                        int n15 = 0;
                        while (n15 < n5) {
                            int n16 = n2;
                            int n17 = 0;
                            while (n17 < n6) {
                                float f = (nArray = writableRaster.getPixel(n16, n, nArray))[n4] / n3;
                                if (f != 0.0f) {
                                    int n18 = 0;
                                    while (n18 < n4) {
                                        nArray[n18] = (int)((float)nArray[n18] * f);
                                        ++n18;
                                    }
                                    writableRaster.setPixel(n16, n, nArray);
                                }
                                ++n17;
                                ++n16;
                            }
                            ++n15;
                            ++n;
                        }
                        break block36;
                    }
                    default: {
                        throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
                    }
                }
            }
            switch (this.transferType) {
                case 0: {
                    int n19 = 0;
                    while (n19 < n5) {
                        int n20 = n2;
                        int n21 = 0;
                        while (n21 < n6) {
                            float f = (nArray = writableRaster.getPixel(n20, n, nArray))[n4] / n3;
                            if (f != 0.0f) {
                                int n22 = 0;
                                while (n22 < n4) {
                                    int n23 = n22++;
                                    nArray[n23] = (int)((float)nArray[n23] / f);
                                }
                            }
                            writableRaster.setPixel(n20, n, nArray);
                            ++n21;
                            ++n20;
                        }
                        ++n19;
                        ++n;
                    }
                    break;
                }
                case 1: {
                    int n24 = 0;
                    while (n24 < n5) {
                        int n25 = n2;
                        int n26 = 0;
                        while (n26 < n6) {
                            float f = (nArray = writableRaster.getPixel(n25, n, nArray))[n4] / n3;
                            if (f != 0.0f) {
                                int n27 = 0;
                                while (n27 < n4) {
                                    int n28 = n27++;
                                    nArray[n28] = (int)((float)nArray[n28] / f);
                                }
                            }
                            writableRaster.setPixel(n25, n, nArray);
                            ++n26;
                            ++n25;
                        }
                        ++n24;
                        ++n;
                    }
                    break;
                }
                case 3: {
                    int n29 = 0;
                    while (n29 < n5) {
                        int n30 = n2;
                        int n31 = 0;
                        while (n31 < n6) {
                            float f = (nArray = writableRaster.getPixel(n30, n, nArray))[n4] / n3;
                            if (f != 0.0f) {
                                int n32 = 0;
                                while (n32 < n4) {
                                    int n33 = n32++;
                                    nArray[n33] = (int)((float)nArray[n33] / f);
                                }
                            }
                            writableRaster.setPixel(n30, n, nArray);
                            ++n31;
                            ++n30;
                        }
                        ++n29;
                        ++n;
                    }
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
                }
            }
        }
        return new DirectColorModel(this.colorSpace, this.pixel_bits, this.maskArray[0], this.maskArray[1], this.maskArray[2], this.maskArray[3], bl, this.transferType);
    }

    public boolean isCompatibleRaster(Raster raster) {
        SampleModel sampleModel = raster.getSampleModel();
        if (!(sampleModel instanceof SinglePixelPackedSampleModel)) {
            return false;
        }
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)sampleModel;
        if (singlePixelPackedSampleModel.getNumBands() != this.getNumComponents()) {
            return false;
        }
        int[] nArray = singlePixelPackedSampleModel.getBitMasks();
        int n = 0;
        while (n < this.numComponents) {
            if (nArray[n] != this.maskArray[n]) {
                return false;
            }
            ++n;
        }
        return raster.getTransferType() == this.transferType;
    }

    private void setFields() {
        this.red_mask = this.maskArray[0];
        this.red_offset = this.maskOffsets[0];
        this.green_mask = this.maskArray[1];
        this.green_offset = this.maskOffsets[1];
        this.blue_mask = this.maskArray[2];
        this.blue_offset = this.maskOffsets[2];
        if (this.nBits[0] < 8) {
            this.red_scale = (1 << this.nBits[0]) - 1;
        }
        if (this.nBits[1] < 8) {
            this.green_scale = (1 << this.nBits[1]) - 1;
        }
        if (this.nBits[2] < 8) {
            this.blue_scale = (1 << this.nBits[2]) - 1;
        }
        if (this.supportsAlpha) {
            this.alpha_mask = this.maskArray[3];
            this.alpha_offset = this.maskOffsets[3];
            if (this.nBits[3] < 8) {
                this.alpha_scale = (1 << this.nBits[3]) - 1;
            }
        }
    }

    public String toString() {
        return new String("DirectColorModel: rmask=" + Integer.toHexString(this.red_mask) + " gmask=" + Integer.toHexString(this.green_mask) + " bmask=" + Integer.toHexString(this.blue_mask) + " amask=" + Integer.toHexString(this.alpha_mask));
    }
}

