/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.ibm.jvm.ExtendedSystem;
import com.ibm.jvm.InvalidClassLoaderParentException;
import com.ibm.jvm.classloader.Middleware;
import com.ibm.jvm.classloader.Shareable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import sun.misc.ClassFileTransformer;
import sun.misc.CompoundEnumeration;
import sun.misc.Launcher;
import sun.misc.Resource;
import sun.misc.URLClassPath;

public abstract class ClassLoader {
    private long loaderCachePointer = 0L;
    private boolean isTrusted;
    private boolean isShared;
    private Finalizer finalizer;
    private boolean initialized = false;
    private ClassLoader parent;
    private Hashtable package2certs = new Hashtable(11);
    private Hashtable codesource2buffer = new Hashtable(11);
    Certificate[] nocerts;
    private Vector classes = new Vector();
    private String namespace;
    private boolean deleted = false;
    private static Field launcherExtLoader = null;
    private HashMap packages = new HashMap();
    private static URLClassPath bootstrapClassPath;
    private static ClassLoader scl;
    private static boolean sclSet;
    private static RuntimePermission getClassLoaderPerm;
    private ProtectionDomain defaultDomain = null;
    private static PermissionCollection defaultPermissions;
    private static Vector loadedLibraryNames;
    private static Vector systemNativeLibraries;
    private Vector nativeLibraries = new Vector();
    private static Stack nativeLibraryContext;
    private static String[] usr_paths;
    private static String[] sys_paths;
    static /* synthetic */ Class class$java$lang$ClassLoader;

    void addClass(Class clazz) {
        this.classes.addElement(clazz);
    }

    protected ClassLoader(ClassLoader classLoader) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkCreateClassLoader();
        }
        this.setParent(classLoader);
        this.initialize();
    }

    protected ClassLoader() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkCreateClassLoader();
        }
        this.setParent(ClassLoader.getSystemClassLoader());
        this.initialize();
    }

    private void initialize() {
        this.initialize0();
        this.finalizer = new Finalizer(this);
        if (!(this instanceof Shareable)) {
            this.initialized = true;
        }
    }

    native void initialize0();

    private void setParent(ClassLoader classLoader) {
        if (this instanceof Shareable && !(classLoader instanceof Shareable) && null != classLoader) {
            throw new InvalidClassLoaderParentException("Parent not shareable class loader: " + classLoader);
        }
        if (this instanceof Middleware && !(classLoader instanceof Middleware) && null != classLoader && ClassLoader.getExtClassLoader() != classLoader) {
            throw new InvalidClassLoaderParentException("Parent not middleware class loader: " + classLoader);
        }
        this.parent = classLoader;
    }

    private static ClassLoader getExtClassLoader() {
        try {
            Launcher launcher = Launcher.getLauncher();
            if (null == launcherExtLoader) {
                launcherExtLoader = ClassLoader.getPrivateField(launcher.getClass(), "extLoader");
            }
            return (ClassLoader)launcherExtLoader.get(launcher);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InternalError(illegalAccessException.toString());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InternalError(illegalArgumentException.toString());
        }
        catch (SecurityException securityException) {
            throw new InternalError(securityException.toString());
        }
    }

    private static Field getPrivateField(final Class clazz, final String string) {
        Field field = (Field)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Field field = null;
                try {
                    field = clazz.getDeclaredField(string);
                    if (null != field) {
                        field.setAccessible(true);
                    }
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    throw new InternalError(noSuchFieldException.toString());
                }
                return field;
            }
        });
        return field;
    }

    public Class loadClass(String string) throws ClassNotFoundException {
        return this.loadClass(string, false);
    }

    private static void checkPackageAccess(final String string, ProtectionDomain protectionDomain) {
        final SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    securityManager.checkPackageAccess(string);
                    return null;
                }
            }, new AccessControlContext(new ProtectionDomain[]{protectionDomain}));
        }
    }

    protected synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class clazz = this.findLoadedClass(string);
        if (clazz == null) {
            try {
                clazz = this.parent != null ? this.parent.loadClass(string, false) : this.findBootstrapClass0(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (clazz == null) {
                clazz = this.findClass(string);
            }
        }
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    private synchronized Class loadClassInternal(String string) throws ClassNotFoundException {
        return this.loadClass(string);
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        throw new ClassNotFoundException(string);
    }

    protected final Class defineClass(byte[] byArray, int n, int n2) throws ClassFormatError {
        return this.defineClass(null, byArray, n, n2, null);
    }

    protected final Class defineClass(String string, byte[] byArray, int n, int n2) throws ClassFormatError {
        return this.defineClass(string, byArray, n, n2, null);
    }

    /*
     * Unable to fully structure code
     */
    protected final Class defineClass(String var1_1, byte[] var2_2, int var3_3, int var4_4, ProtectionDomain var5_5) throws ClassFormatError {
        block12: {
            this.check();
            if (var1_1 != null && var1_1.startsWith("java.")) {
                throw new SecurityException("Prohibited package name: " + var1_1.substring(0, var1_1.lastIndexOf(46)));
            }
            if (var5_5 == null) {
                var5_5 = this.getDefaultDomain();
            }
            var6_6 = var5_5.getCodeSource();
            var7_7 = null;
            var8_8 = null;
            if (var6_6 != null) {
                var7_7 = var6_6.getCertificates();
                if (this.isShared) {
                    var8_8 = this.resolveSharedCodeSource(var6_6);
                }
            }
            if (var1_1 != null) {
                this.checkCerts(var1_1, var6_6);
            }
            var9_9 = null;
            try {
                var9_9 = this.defineClass0(var1_1, var2_2, var3_3, var4_4, var5_5, (Certificate[])var7_7, var8_8);
                break block12;
            }
            catch (ClassFormatError var10_10) {
                var11_11 = ClassFileTransformer.getTransformers();
                var12_12 = 0;
                ** while (var11_11 != null && var12_12 < var11_11.length)
            }
lbl-1000:
            // 1 sources

            {
                try {
                    var13_14 = ((ClassFileTransformer)var11_11[var12_12]).transform(var2_2, var3_3, var4_4);
                    var9_9 = this.defineClass0(var1_1, var13_14, 0, var13_14.length, var5_5, (Certificate[])var7_7, var8_8);
                    break;
                }
                catch (ClassFormatError var13_13) {
                    ++var12_12;
                }
                continue;
            }
lbl30:
            // 2 sources

            if (var9_9 == null) {
                throw var10_10;
            }
        }
        if (var7_7 != null) {
            this.setSigners(var9_9, var7_7);
        }
        return var9_9;
    }

    private byte[] resolveSharedCodeSource(CodeSource codeSource) {
        byte[] byArray = (byte[])this.codesource2buffer.get(codeSource);
        if (byArray == null) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                objectOutputStream.writeObject(codeSource);
                byArray = byteArrayOutputStream.toByteArray();
                byArray = this.getSystemHeapArray(byArray);
                this.codesource2buffer.put(codeSource, byArray);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return byArray;
    }

    private native byte[] getSystemHeapArray(byte[] var1);

    private synchronized void checkCerts(String string, CodeSource codeSource) {
        int n = string.lastIndexOf(46);
        String string2 = n == -1 ? "" : string.substring(0, n);
        Certificate[] certificateArray = (Certificate[])this.package2certs.get(string2);
        if (certificateArray == null) {
            if (codeSource != null) {
                certificateArray = codeSource.getCertificates();
            }
            if (certificateArray == null) {
                if (this.nocerts == null) {
                    this.nocerts = new Certificate[0];
                }
                certificateArray = this.nocerts;
            }
            this.package2certs.put(string2, certificateArray);
        } else {
            Certificate[] certificateArray2 = null;
            if (codeSource != null) {
                certificateArray2 = codeSource.getCertificates();
            }
            if (!this.compareCerts(certificateArray, certificateArray2)) {
                throw new SecurityException("class \"" + string + "\"'s signer information does not match signer information of other classes in the same package");
            }
        }
    }

    private boolean compareCerts(Certificate[] certificateArray, Certificate[] certificateArray2) {
        int n;
        boolean bl;
        if (certificateArray2 == null || certificateArray2.length == 0) {
            return certificateArray.length == 0;
        }
        if (certificateArray2.length != certificateArray.length) {
            return false;
        }
        int n2 = 0;
        while (n2 < certificateArray2.length) {
            bl = false;
            n = 0;
            while (n < certificateArray.length) {
                if (certificateArray2[n2].equals(certificateArray[n])) {
                    bl = true;
                    break;
                }
                ++n;
            }
            if (!bl) {
                return false;
            }
            ++n2;
        }
        n = 0;
        while (n < certificateArray.length) {
            bl = false;
            int n3 = 0;
            while (n3 < certificateArray2.length) {
                if (certificateArray[n].equals(certificateArray2[n3])) {
                    bl = true;
                    break;
                }
                ++n3;
            }
            if (!bl) {
                return false;
            }
            ++n;
        }
        return true;
    }

    protected final void resolveClass(Class clazz) {
        this.check();
        this.resolveClass0(clazz);
    }

    protected final Class findSystemClass(String string) throws ClassNotFoundException {
        this.check();
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        if (classLoader == null) {
            return this.findBootstrapClass(string);
        }
        return classLoader.loadClass(string);
    }

    public final ClassLoader getParent() {
        ClassLoader classLoader;
        if (this.parent == null) {
            return null;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && (classLoader = ClassLoader.getCallerClassLoader()) != null && !this.isAncestor(classLoader)) {
            securityManager.checkPermission(ClassLoader.getGetClassLoaderPerm());
        }
        return this.parent;
    }

    protected final void setSigners(Class clazz, Object[] objectArray) {
        this.check();
        clazz.setSigners(objectArray);
    }

    private Class findBootstrapClass0(String string) throws ClassNotFoundException {
        this.check();
        return this.findBootstrapClass(string);
    }

    private native Class defineClass0(String var1, byte[] var2, int var3, int var4, ProtectionDomain var5, Certificate[] var6, byte[] var7);

    private native void resolveClass0(Class var1);

    private native Class findBootstrapClass(String var1) throws ClassNotFoundException;

    private void check() {
        if (!this.initialized) {
            if (this.deleted) {
                ExtendedSystem.setJVMUnresettableConditionally(65555, new String("Application class loader retained across reset"));
            }
            if (!(this instanceof Shareable)) {
                throw new SecurityException("ClassLoader object not initialized");
            }
            throw new SecurityException("ClassLoader object not registered: " + this);
        }
    }

    protected final native Class findLoadedClass(String var1);

    public URL getResource(String string) {
        URL uRL = this.parent != null ? this.parent.getResource(string) : ClassLoader.getBootstrapResource(string);
        if (uRL == null) {
            uRL = this.findResource(string);
        }
        return uRL;
    }

    public final Enumeration getResources(String string) throws IOException {
        Enumeration[] enumerationArray = new Enumeration[]{this.parent != null ? this.parent.getResources(string) : ClassLoader.getBootstrapResources(string), this.findResources(string)};
        return new CompoundEnumeration(enumerationArray);
    }

    protected Enumeration findResources(String string) throws IOException {
        return new CompoundEnumeration(new Enumeration[0]);
    }

    protected URL findResource(String string) {
        return null;
    }

    public static URL getSystemResource(String string) {
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        if (classLoader == null) {
            return ClassLoader.getBootstrapResource(string);
        }
        return classLoader.getResource(string);
    }

    private static URL getBootstrapResource(String string) {
        URLClassPath uRLClassPath = ClassLoader.getBootstrapClassPath();
        Resource resource = uRLClassPath.getResource(string);
        return resource != null ? resource.getURL() : null;
    }

    public static Enumeration getSystemResources(String string) throws IOException {
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        if (classLoader == null) {
            return ClassLoader.getBootstrapResources(string);
        }
        return classLoader.getResources(string);
    }

    private static Enumeration getBootstrapResources(String string) throws IOException {
        final Enumeration enumeration = ClassLoader.getBootstrapClassPath().getResources(string);
        return new Enumeration(){

            public Object nextElement() {
                return ((Resource)enumeration.nextElement()).getURL();
            }

            public boolean hasMoreElements() {
                return enumeration.hasMoreElements();
            }
        };
    }

    static URLClassPath getBootstrapClassPath() {
        if (bootstrapClassPath == null) {
            bootstrapClassPath = Launcher.getBootstrapClassPath();
        }
        return bootstrapClassPath;
    }

    public InputStream getResourceAsStream(String string) {
        URL uRL = this.getResource(string);
        try {
            return uRL != null ? uRL.openStream() : null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static InputStream getSystemResourceAsStream(String string) {
        URL uRL = ClassLoader.getSystemResource(string);
        try {
            return uRL != null ? uRL.openStream() : null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static ClassLoader getSystemClassLoader() {
        ClassLoader classLoader;
        Object object;
        if (!sclSet) {
            object = Launcher.getLauncher();
            if (object != null) {
                scl = ((Launcher)object).getClassLoader();
            }
            sclSet = true;
        }
        if (scl == null) {
            return null;
        }
        object = System.getSecurityManager();
        if (object != null && (classLoader = ClassLoader.getCallerClassLoader()) != null && classLoader != scl && !scl.isAncestor(classLoader)) {
            ((SecurityManager)object).checkPermission(ClassLoader.getGetClassLoaderPerm());
        }
        return scl;
    }

    private static void removeSystemClassLoader() {
        scl = null;
        sclSet = false;
    }

    private void copyFrom(ClassLoader classLoader) {
        this.package2certs = classLoader.package2certs;
        this.nocerts = classLoader.nocerts;
        this.packages = classLoader.packages;
        this.nativeLibraries = classLoader.nativeLibraries;
        this.defaultDomain = classLoader.defaultDomain;
        this.codesource2buffer = classLoader.codesource2buffer;
        classLoader.package2certs = null;
        classLoader.nocerts = null;
        classLoader.packages = null;
        classLoader.nativeLibraries = null;
        classLoader.defaultDomain = null;
        classLoader.codesource2buffer = null;
    }

    boolean isAncestor(ClassLoader classLoader) {
        ClassLoader classLoader2 = this;
        do {
            if (classLoader != (classLoader2 = classLoader2.parent)) continue;
            return true;
        } while (classLoader2 != null);
        return false;
    }

    static native ClassLoader getCallerClassLoader();

    static RuntimePermission getGetClassLoaderPerm() {
        if (getClassLoaderPerm == null) {
            getClassLoaderPerm = new RuntimePermission("getClassLoader");
        }
        return getClassLoaderPerm;
    }

    protected Package definePackage(String string, String string2, String string3, String string4, String string5, String string6, String string7, URL uRL) throws IllegalArgumentException {
        HashMap hashMap = this.packages;
        synchronized (hashMap) {
            Object object;
            Package package_ = this.getPackage(string);
            if (package_ != null) {
                throw new IllegalArgumentException(string);
            }
            package_ = new Package(string, string2, string3, string4, string5, string6, string7, uRL);
            this.packages.put(string, package_);
            if (this.isShared) {
                try {
                    object = new ByteArrayOutputStream();
                    ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)object);
                    objectOutputStream.writeObject(package_);
                    byte[] byArray = ((ByteArrayOutputStream)object).toByteArray();
                    this.addNameSpacePackage(string.intern(), byArray);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            object = package_;
            return object;
        }
    }

    protected Package getPackage(String string) {
        HashMap hashMap = this.packages;
        synchronized (hashMap) {
            Object object;
            Package package_ = (Package)this.packages.get(string);
            if (package_ == null && this.isShared && (object = (Object)this.getNameSpacePackage(string = string.intern())) != null) {
                try {
                    ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream((byte[])object));
                    package_ = (Package)objectInputStream.readObject();
                    this.packages.put(string, package_);
                }
                catch (IOException iOException) {
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (package_ == null && (package_ = this.parent != null ? this.parent.getPackage(string) : Package.getSystemPackage(string)) != null) {
                this.packages.put(string, package_);
            }
            object = package_;
            return object;
        }
    }

    protected Package[] getPackages() {
        Map map;
        String string;
        int n;
        Object[] objectArray;
        HashMap hashMap = this.packages;
        synchronized (hashMap) {
            if (this.isShared) {
                objectArray = this.getNameSpacePackageNames();
                n = 0;
                while (n < objectArray.length) {
                    string = objectArray[n];
                    if (string != null && this.packages.get(string) == null) {
                        try {
                            byte[] byArray = this.getNameSpacePackage(string);
                            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byArray));
                            Package package_ = (Package)objectInputStream.readObject();
                            this.packages.put(string, package_);
                        }
                        catch (IOException iOException) {
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            // empty catch block
                        }
                    }
                    ++n;
                }
            }
            map = (Map)this.packages.clone();
        }
        objectArray = this.parent != null ? this.parent.getPackages() : Package.getSystemPackages();
        if (objectArray != null) {
            n = 0;
            while (n < objectArray.length) {
                string = ((Package)objectArray[n]).getName();
                if (map.get(string) == null) {
                    map.put(string, objectArray[n]);
                }
                ++n;
            }
        }
        return (Package[])map.values().toArray(new Package[map.size()]);
    }

    private native void addNameSpacePackage(String var1, byte[] var2);

    private native byte[] getNameSpacePackage(String var1);

    private native String[] getNameSpacePackageNames();

    protected String findLibrary(String string) {
        return null;
    }

    private ProtectionDomain getDefaultDomain() {
        if (this.defaultDomain == null) {
            Class clazz = class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = ClassLoader.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader;
            synchronized (clazz) {
                if (defaultPermissions == null) {
                    defaultPermissions = (PermissionCollection)AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            CodeSource codeSource = new CodeSource(null, null);
                            return Policy.getPolicy().getPermissions(codeSource);
                        }
                    });
                }
                if (this.defaultDomain == null) {
                    CodeSource codeSource = new CodeSource(null, null);
                    this.defaultDomain = new ProtectionDomain(codeSource, defaultPermissions);
                }
            }
        }
        return this.defaultDomain;
    }

    private static String[] initializePath(String string) {
        String string2 = System.getProperty(string, "");
        String string3 = File.pathSeparator;
        int n = string2.length();
        int n2 = string2.indexOf(string3);
        int n3 = 0;
        while (n2 >= 0) {
            ++n3;
            n2 = string2.indexOf(string3, n2 + 1);
        }
        String[] stringArray = new String[n3 + 1];
        n2 = 0;
        n3 = 0;
        int n4 = string2.indexOf(string3);
        while (n4 >= 0) {
            if (n4 - n2 > 0) {
                stringArray[n3++] = string2.substring(n2, n4);
            } else if (n4 - n2 == 0) {
                stringArray[n3++] = ".";
            }
            n2 = n4 + 1;
            n4 = string2.indexOf(string3, n2);
        }
        stringArray[n3] = string2.substring(n2, n);
        return stringArray;
    }

    static void loadLibrary(Class clazz, String string, boolean bl) {
        String string2;
        ClassLoader classLoader;
        ClassLoader classLoader2 = classLoader = clazz == null ? null : clazz.getClassLoader();
        if (sys_paths == null) {
            usr_paths = ClassLoader.initializePath("java.library.path");
            sys_paths = ClassLoader.initializePath("sun.boot.library.path");
        }
        if (bl) {
            if (ClassLoader.loadLibrary0(clazz, new File(string))) {
                return;
            }
            throw new UnsatisfiedLinkError("Can't load library: " + string);
        }
        if (classLoader != null && (string2 = classLoader.findLibrary(string)) != null) {
            File file = new File(string2);
            if (!file.isAbsolute()) {
                throw new UnsatisfiedLinkError("ClassLoader.findClass failed to return an absolute path: " + string2);
            }
            if (ClassLoader.loadLibrary0(clazz, file)) {
                return;
            }
            throw new UnsatisfiedLinkError("Can't load " + string2);
        }
        string2 = System.mapLibraryName(string);
        String string3 = new String(string2);
        String string4 = System.getProperty("java.execsuffix", "");
        int n = 0;
        while (n < 2) {
            int n2 = 0;
            while (n2 < sys_paths.length) {
                File file = new File(sys_paths[n2], string2);
                if (ClassLoader.loadLibrary0(clazz, file)) {
                    if (n == 1) {
                        System.err.println("Warning: Loaded " + string2 + " instead of " + string3);
                    }
                    return;
                }
                ++n2;
            }
            if (classLoader != null) {
                int n3 = 0;
                while (n3 < usr_paths.length) {
                    File file = new File(usr_paths[n3], string2);
                    if (ClassLoader.loadLibrary0(clazz, file)) {
                        if (n == 1) {
                            System.err.println("Warning: Loaded " + string2 + " instead of " + string3);
                        }
                        return;
                    }
                    ++n3;
                }
            }
            if (string4 == "" || string2.lastIndexOf(string4) < 0) break;
            string2 = string3.substring(0, string3.lastIndexOf(string4)) + string3.substring(string3.lastIndexOf(string4) + string4.length());
            ++n;
        }
        throw new UnsatisfiedLinkError("Can't find library " + string + "  (" + string3 + (System.getProperty("os.name").equals("AIX") ? " or .so" : "") + (string4 != "" ? ", or " + string2 + (System.getProperty("os.name").equals("AIX") ? " or .so" : "") : "") + ") in java.library.path\njava.library.path=" + System.getProperty("java.library.path"));
    }

    private static boolean loadLibrary0(Class clazz, final File file) {
        Vector vector;
        String string;
        try {
            string = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return false;
        }
        ClassLoader classLoader = clazz == null ? null : clazz.getClassLoader();
        Vector vector2 = vector = classLoader != null ? classLoader.nativeLibraries : systemNativeLibraries;
        synchronized (vector2) {
            Object object;
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                object = (NativeLibrary)vector.elementAt(n2);
                if (string.equals(((NativeLibrary)object).name)) {
                    boolean bl = true;
                    return bl;
                }
                ++n2;
            }
            object = loadedLibraryNames;
            synchronized (object) {
                NativeLibrary nativeLibrary;
                if (loadedLibraryNames.contains(string)) {
                    throw new UnsatisfiedLinkError("Native Library " + string + " already loaded in another classloader");
                }
                int n3 = nativeLibraryContext.size();
                int n4 = 0;
                while (n4 < n3) {
                    nativeLibrary = (NativeLibrary)nativeLibraryContext.elementAt(n4);
                    if (string.equals(nativeLibrary.name)) {
                        if (classLoader == nativeLibrary.fromClass.getClassLoader()) {
                            boolean bl = true;
                            return bl;
                        }
                        throw new UnsatisfiedLinkError("Native Library " + string + " is being loaded in another classloader");
                    }
                    ++n4;
                }
                nativeLibrary = new NativeLibrary(clazz, string);
                nativeLibraryContext.push(nativeLibrary);
                try {
                    try {
                        nativeLibrary.load(string);
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                        Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                            public Object run() {
                                return new Boolean(file.exists());
                            }
                        });
                        if (!bl.booleanValue()) {
                            boolean bl2 = false;
                            Object var16_19 = null;
                            nativeLibraryContext.pop();
                            return bl2;
                        }
                        throw unsatisfiedLinkError;
                    }
                    Object var16_18 = null;
                    nativeLibraryContext.pop();
                }
                catch (Throwable throwable) {
                    Object var16_20 = null;
                    nativeLibraryContext.pop();
                    throw throwable;
                }
                if (nativeLibrary.handle != 0L) {
                    loadedLibraryNames.addElement(string);
                    vector.addElement(nativeLibrary);
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
        }
    }

    static long findNative(ClassLoader classLoader, String string) {
        Vector vector;
        Vector vector2 = vector = classLoader != null ? classLoader.nativeLibraries : systemNativeLibraries;
        synchronized (vector2) {
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                NativeLibrary nativeLibrary = (NativeLibrary)vector.elementAt(n2);
                long l = nativeLibrary.find(string);
                if (l != 0L) {
                    long l2 = l;
                    return l2;
                }
                ++n2;
            }
        }
        return 0L;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        getClassLoaderPerm = null;
        defaultPermissions = null;
        loadedLibraryNames = new Vector();
        systemNativeLibraries = new Vector();
        nativeLibraryContext = new Stack();
    }

    static class NativeLibrary {
        long handle;
        private int jniVersion;
        private Class fromClass;
        String name;

        native void load(String var1);

        native long find(String var1);

        native void unload();

        public NativeLibrary(Class clazz, String string) {
            this.name = string;
            this.fromClass = clazz;
        }

        protected void finalize() {
            Vector vector = loadedLibraryNames;
            synchronized (vector) {
                if (this.fromClass.getClassLoader() != null && this.handle != 0L) {
                    int n = loadedLibraryNames.size();
                    int n2 = 0;
                    while (n2 < n) {
                        if (this.name.equals(loadedLibraryNames.elementAt(n2))) {
                            loadedLibraryNames.removeElementAt(n2);
                            break;
                        }
                        ++n2;
                    }
                    nativeLibraryContext.push(this);
                    try {
                        this.unload();
                        Object var5_4 = null;
                        nativeLibraryContext.pop();
                    }
                    catch (Throwable throwable) {
                        Object var5_5 = null;
                        nativeLibraryContext.pop();
                        throw throwable;
                    }
                    {
                    }
                }
            }
        }

        static Class getFromClass() {
            return ((NativeLibrary)nativeLibraryContext.peek()).fromClass;
        }
    }

    static class Finalizer {
        private ClassLoader loader;

        Finalizer(ClassLoader classLoader) {
            this.loader = classLoader;
        }

        native void finalize0(ClassLoader var1);

        protected void finalize() {
            this.finalize0(this.loader);
        }
    }
}

