/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.ibm.jvm.ExtendedSystem;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.Collections;
import java.util.Map;

public class Thread
implements Runnable {
    private long eetop;
    private char[] name;
    private int priority;
    private Thread threadQ;
    private boolean single_step;
    private boolean daemon = false;
    private boolean userDaemon = false;
    private boolean stillborn = false;
    private Runnable target;
    private ThreadGroup group;
    private ClassLoader contextClassLoader;
    private AccessControlContext inheritedAccessControlContext;
    private static int threadInitNumber;
    private static RuntimePermission stopThreadPermission;
    Map threadLocals;
    Map inheritableThreadLocals;
    public static final int MIN_PRIORITY = 1;
    public static final int NORM_PRIORITY = 5;
    public static final int MAX_PRIORITY = 10;

    private static native void registerNatives();

    private static synchronized int nextThreadNum() {
        return threadInitNumber++;
    }

    public static native Thread currentThread();

    public static native void yield();

    public static native void sleep(long var0) throws InterruptedException;

    public static void sleep(long l, int n) throws InterruptedException {
        if (l < 0L) {
            throw new IllegalArgumentException("timeout value is negative");
        }
        if (n < 0 || n > 999999) {
            throw new IllegalArgumentException("nanosecond timeout value out of range");
        }
        if (n >= 500000 || n != 0 && l == 0L) {
            ++l;
        }
        Thread.sleep(l);
    }

    private void init(ThreadGroup threadGroup, Runnable runnable, String string) {
        Thread thread = Thread.currentThread();
        if (threadGroup == null) {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                threadGroup = securityManager.getThreadGroup();
            }
            if (threadGroup == null) {
                threadGroup = thread.getThreadGroup();
            }
        }
        threadGroup.checkAccess();
        this.group = threadGroup;
        this.daemon = thread.isDaemon();
        this.priority = thread.getPriority();
        this.name = string.toCharArray();
        this.contextClassLoader = thread.contextClassLoader;
        this.inheritedAccessControlContext = AccessController.getContext();
        this.target = runnable;
        this.threadLocals = Collections.EMPTY_MAP;
        this.inheritableThreadLocals = Collections.EMPTY_MAP;
        this.setPriority(this.priority);
        InheritableThreadLocal.bequeath(thread, this);
        threadGroup.add(this);
    }

    public Thread() {
        this.init(null, null, "Thread-" + Thread.nextThreadNum());
    }

    public Thread(Runnable runnable) {
        this.init(null, runnable, "Thread-" + Thread.nextThreadNum());
    }

    public Thread(ThreadGroup threadGroup, Runnable runnable) {
        this.init(threadGroup, runnable, "Thread-" + Thread.nextThreadNum());
    }

    public Thread(String string) {
        this.init(null, null, string);
    }

    public Thread(ThreadGroup threadGroup, String string) {
        this.init(threadGroup, null, string);
    }

    public Thread(Runnable runnable, String string) {
        this.init(null, runnable, string);
    }

    public Thread(ThreadGroup threadGroup, Runnable runnable, String string) {
        this.init(threadGroup, runnable, string);
    }

    public synchronized native void start();

    public void run() {
        if (this.target != null) {
            this.target.run();
        }
    }

    private void exit() {
        if (this.group != null) {
            this.group.remove(this);
            this.group = null;
        }
        this.target = null;
    }

    public final void stop() {
        Thread thread = this;
        synchronized (thread) {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                this.checkAccess();
                if (this != Thread.currentThread()) {
                    if (stopThreadPermission == null) {
                        stopThreadPermission = new RuntimePermission("stopThread");
                    }
                    securityManager.checkPermission(stopThreadPermission);
                }
            }
            this.resume();
            this.stop0(new ThreadDeath());
        }
    }

    public final synchronized void stop(Throwable throwable) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            this.checkAccess();
            if (this != Thread.currentThread() || !(throwable instanceof ThreadDeath)) {
                if (stopThreadPermission == null) {
                    stopThreadPermission = new RuntimePermission("stopThread");
                }
                securityManager.checkPermission(stopThreadPermission);
            }
        }
        this.resume();
        this.stop0(throwable);
    }

    public void interrupt() {
        this.checkAccess();
        this.interrupt0();
    }

    public static boolean interrupted() {
        return Thread.currentThread().isInterrupted(true);
    }

    public boolean isInterrupted() {
        return this.isInterrupted(false);
    }

    private native boolean isInterrupted(boolean var1);

    public void destroy() {
        throw new NoSuchMethodError();
    }

    public final native boolean isAlive();

    public final void suspend() {
        this.checkAccess();
        this.suspend0();
    }

    public final void resume() {
        this.checkAccess();
        this.resume0();
    }

    public final void setPriority(int n) {
        this.checkAccess();
        if (n > 10 || n < 1) {
            throw new IllegalArgumentException();
        }
        if (n > this.group.getMaxPriority()) {
            n = this.group.getMaxPriority();
        }
        this.priority = n;
        this.setPriority0(this.priority);
    }

    public final int getPriority() {
        return this.priority;
    }

    public final void setName(String string) {
        this.checkAccess();
        this.name = string.toCharArray();
    }

    public final String getName() {
        return String.valueOf(this.name);
    }

    public final ThreadGroup getThreadGroup() {
        return this.group;
    }

    public static int activeCount() {
        return Thread.currentThread().getThreadGroup().activeCount();
    }

    public static int enumerate(Thread[] threadArray) {
        return Thread.currentThread().getThreadGroup().enumerate(threadArray);
    }

    public native int countStackFrames();

    /*
     * Unable to fully structure code
     */
    public final synchronized void join(long var1_1) throws InterruptedException {
        block3: {
            var3_2 = System.currentTimeMillis();
            var5_3 = 0L;
            if (var1_1 < 0L) {
                throw new IllegalArgumentException("timeout value is negative");
            }
            if (var1_1 != 0L) ** GOTO lbl13
            while (this.isAlive()) {
                this.wait(0L);
            }
            break block3;
            while ((var7_4 = var1_1 - var5_3) > 0L) {
                this.wait(var7_4);
                var5_3 = System.currentTimeMillis() - var3_2;
lbl13:
                // 2 sources

                if (this.isAlive()) continue;
            }
        }
    }

    public final synchronized void join(long l, int n) throws InterruptedException {
        if (l < 0L) {
            throw new IllegalArgumentException("timeout value is negative");
        }
        if (n < 0 || n > 999999) {
            throw new IllegalArgumentException("nanosecond timeout value out of range");
        }
        if (n >= 500000 || n != 0 && l == 0L) {
            ++l;
        }
        this.join(l);
    }

    public final void join() throws InterruptedException {
        this.join(0L);
    }

    public static void dumpStack() {
        new Exception("Stack trace").printStackTrace();
    }

    public final void setDaemon(boolean bl) {
        this.checkAccess();
        if (this.isAlive()) {
            throw new IllegalThreadStateException();
        }
        this.daemon = bl;
    }

    public final boolean isDaemon() {
        return this.daemon;
    }

    public final void checkAccess() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkAccess(this);
        }
    }

    public String toString() {
        if (this.getThreadGroup() != null) {
            return "Thread[" + this.getName() + "," + this.getPriority() + "," + this.getThreadGroup().getName() + "]";
        }
        return "Thread[" + this.getName() + "," + this.getPriority() + "," + "" + "]";
    }

    public ClassLoader getContextClassLoader() {
        ClassLoader classLoader;
        if (this.contextClassLoader == null) {
            return null;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && (classLoader = ClassLoader.getCallerClassLoader()) != null && classLoader != this.contextClassLoader && !this.contextClassLoader.isAncestor(classLoader)) {
            securityManager.checkPermission(ClassLoader.getGetClassLoaderPerm());
        }
        return this.contextClassLoader;
    }

    public void setContextClassLoader(ClassLoader classLoader) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("setContextClassLoader"));
        }
        ExtendedSystem.setJVMUnresettableConditionally(131076, "Set class loader using Thread.setContextClassLoader()");
        this.contextClassLoader = classLoader;
    }

    private native void setPriority0(int var1);

    private native void stop0(Object var1);

    private native void suspend0();

    private native void resume0();

    private native void interrupt0();

    static {
        Thread.registerNatives();
    }
}

