/*
 * Decompiled with CFR 0.152.
 */
package java.lang.ref;

import java.lang.ref.ReferenceQueue;

public abstract class Reference {
    private Object referent;
    ReferenceQueue queue;
    Reference next;
    private static Reference processing;
    private static Lock lock;
    private static Reference pending;

    private static native void initForReset();

    public Object get() {
        return this.referent;
    }

    public void clear() {
        this.referent = null;
    }

    public boolean isEnqueued() {
        Reference reference = this;
        synchronized (reference) {
            boolean bl = this.queue != ReferenceQueue.NULL && this.next != null;
            return bl;
        }
    }

    public boolean enqueue() {
        return this.queue.enqueue(this);
    }

    Reference(Object object) {
        this(object, null);
    }

    Reference(Object object, ReferenceQueue referenceQueue) {
        this.referent = object;
        if (object == null) {
            this.queue = ReferenceQueue.NULL;
            this.next = this;
        } else {
            this.queue = referenceQueue == null ? ReferenceQueue.NULL : referenceQueue;
            this.next = null;
        }
    }

    static {
        ThreadGroup threadGroup;
        processing = null;
        lock = new Lock();
        pending = null;
        ThreadGroup threadGroup2 = threadGroup = Thread.currentThread().getThreadGroup();
        while (threadGroup2 != null) {
            threadGroup = threadGroup2;
            threadGroup2 = threadGroup.getParent();
        }
        ReferenceHandler referenceHandler = new ReferenceHandler(threadGroup, "Reference Handler");
        referenceHandler.setPriority(10);
        referenceHandler.setDaemon(true);
        referenceHandler.start();
    }

    private static class ReferenceHandler
    extends Thread {
        ReferenceHandler(ThreadGroup threadGroup, String string) {
            super(threadGroup, string);
        }

        public void run() {
            Reference.initForReset();
            while (true) {
                Object object;
                Reference reference;
                Lock lock = lock;
                synchronized (lock) {
                    processing = pending;
                    if (pending == null) {
                        try {
                            lock.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        continue;
                    }
                    object = reference.next;
                    reference = pending;
                    pending = (Reference)(object == reference ? null : object);
                    reference.next = reference;
                }
                object = reference.queue;
                if (object == ReferenceQueue.NULL) continue;
                ((ReferenceQueue)object).enqueue(reference);
            }
        }
    }

    private static class Lock {
        private Lock() {
        }
    }
}

