/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.server;

import com.ibm.jvm.ExtendedSystem;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.util.Date;
import java.util.Hashtable;

public class LogStream
extends PrintStream {
    private static Hashtable known = new Hashtable(5);
    private static PrintStream defaultStream = System.err;
    private String name;
    private OutputStream logOut;
    private OutputStreamWriter logWriter;
    private StringBuffer buffer = new StringBuffer();
    private ByteArrayOutputStream bufOut = (ByteArrayOutputStream)this.out;
    public static final int SILENT = 0;
    public static final int BRIEF = 10;
    public static final int VERBOSE = 20;

    private LogStream(String string, OutputStream outputStream) {
        super(new ByteArrayOutputStream());
        this.name = string;
        this.setOutputStream(outputStream);
    }

    public static LogStream log(String string) {
        LogStream logStream;
        Hashtable hashtable = known;
        synchronized (hashtable) {
            logStream = (LogStream)known.get(string);
            if (logStream == null) {
                logStream = new LogStream(string, defaultStream);
            }
            known.put(string, logStream);
        }
        ExtendedSystem.setJVMUnresettableConditionally(131073, new String("Modified known in LogStream.log()"));
        return logStream;
    }

    public static synchronized PrintStream getDefaultStream() {
        return defaultStream;
    }

    public static synchronized void setDefaultStream(PrintStream printStream) {
        defaultStream = printStream;
        ExtendedSystem.setJVMUnresettableConditionally(131073, new String("Modified defaultStream in LogStream.setDefaultStream()"));
    }

    public synchronized OutputStream getOutputStream() {
        return this.logOut;
    }

    public synchronized void setOutputStream(OutputStream outputStream) {
        this.logOut = outputStream;
        this.logWriter = new OutputStreamWriter(this.logOut);
    }

    public void write(int n) {
        if (n == 10) {
            LogStream logStream = this;
            synchronized (logStream) {
                OutputStream outputStream = this.logOut;
                synchronized (outputStream) {
                    this.buffer.setLength(0);
                    this.buffer.append(new Date().toString());
                    this.buffer.append(':');
                    this.buffer.append(this.name);
                    this.buffer.append(':');
                    this.buffer.append(Thread.currentThread().getName());
                    this.buffer.append(':');
                    try {
                        try {
                            this.logWriter.write(this.buffer.toString());
                            this.logWriter.flush();
                            this.bufOut.writeTo(this.logOut);
                            this.logOut.write(n);
                            this.logOut.flush();
                        }
                        catch (IOException iOException) {
                            this.setError();
                            Object var6_5 = null;
                            this.bufOut.reset();
                        }
                        Object var6_4 = null;
                        this.bufOut.reset();
                    }
                    catch (Throwable throwable) {
                        Object var6_6 = null;
                        this.bufOut.reset();
                        throw throwable;
                    }
                }
            }
        }
        super.write(n);
    }

    public void write(byte[] byArray, int n, int n2) {
        if (n2 < 0) {
            throw new ArrayIndexOutOfBoundsException(n2);
        }
        int n3 = 0;
        while (n3 < n2) {
            this.write(byArray[n + n3]);
            ++n3;
        }
    }

    public String toString() {
        return this.name;
    }

    public static int parseLevel(String string) {
        if (string == null || string.length() < 1) {
            return -1;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            if (string.length() < 1) {
                return -1;
            }
            if ("SILENT".startsWith(string.toUpperCase())) {
                return 0;
            }
            if ("BRIEF".startsWith(string.toUpperCase())) {
                return 10;
            }
            if ("VERBOSE".startsWith(string.toUpperCase())) {
                return 20;
            }
            return -1;
        }
    }
}

