/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.CharacterIterator;
import java.text.CompactByteArray;
import java.text.CompactShortArray;
import java.text.IntHashtable;
import java.text.StringCharacterIterator;
import java.text.Utility;

class Normalizer
implements Cloneable {
    static final char DONE = '\uffff';
    static final int NO_DECOMPOSITION = 0;
    static final int CANONICAL_DECOMPOSITION = 1;
    static final int FULL_DECOMPOSITION = 2;
    static final char HANGUL_BASE = '\uac00';
    static final char HANGUL_LIMIT = '\ud7a4';
    static final char JAMO_LBASE = '\u1100';
    static final char JAMO_VBASE = '\u1161';
    static final char JAMO_TBASE = '\u11a7';
    static final int JAMO_LCOUNT = 19;
    static final int JAMO_VCOUNT = 21;
    static final int JAMO_TCOUNT = 28;
    static final int JAMO_NCOUNT = 588;
    private CharacterIterator str = null;
    private transient boolean ownIterator = false;
    private int decmpMode = 0;
    private int decmpLimit;
    private StringBuffer parsedStr = null;
    private int pIndex = 0;
    private int pLimit = 0;
    private static final short SHORT_MAX_VALUE = Short.MAX_VALUE;
    private static final char STERMINATOR = '\u0000';
    private static final short[] kOffsetIndex = Utility.RLEStringToShortArray("\u0000\u0200\u0000a\u00e1\u0161\u01e1\u0231\u02a1\u031d\u039c\u0414\u048e\u0507\ua5a5\u0006\u048e\u055e\u05be\u061e\u048e\u067d\u06e9\u0736\u077f\u07cb\u048e\u0818\u0865\u08c3\u0942\u048e\u048e\u09c1\u0a41\ua5a5\u0018\u048e\u0ac1\u0b41\u0bc1\u0c41\u0cc1\u0d41\u0dbf\u048e\u0e3f\u0ebf\u0f2d\u048e\u0f58\u0fcc\ua5a5\u0016\u048e\u104c\u10ca\u1149\u11c9\u1249\u12c9\u1349\u13c9\ua5a5\u018e\u048e\u1449\u14c9\ua5a5\u0004\u048e\u1549\u15c9\u1648\u16c8");
    private static final short[] kOffsetValues = Utility.RLEStringToShortArray("\u0000\u1748\ua5a5^\u7fff\u0c80\u0c83\u0c86\ua5a5 \u7fff\u0c89\ua5a5\u0007\u7fff\u0c8b\u7fff\u0c8e\ua5a5\u0004\u7fff\u0c90\u7fff\u7fff\u0c93\u0c95\u0c97\u0c9a\u7fff\u7fff\u0c9c\u0c9f\u0ca1\u7fff\u0ca3\u0ca7\u0cab\u7fff\u0000\u0003\u0006\t\f\u000f\u7fff\u0012\u0015\u0018\u001b\u001e!$'*\u7fff-0369<\u7fff\u7fff?BEHK\u7fff\u7fffNQTWZ]\u7fff`cfilorux\u7fff{~\u0081\u0084\u0087\u008a\u7fff\u7fff\u008d\u0090\u0093\u0096\u0099\u7fff\u009c\u009f\u00a2\u00a5\u00a8\u00ab\u00ae\u00b1\u00b4\u00b7\u00ba\u00bd\u00c0\u00c3\u00c6\u00c9\u00cc\u7fff\u7fff\u00cf\u00d2\u00d5\u00d8\u00db\u00de\u00e1\u00e4\u00e7\u00ea\u00ed\u00f0\u00f3\u00f6\u00f9\u00fc\u00ff\u0102\u0105\u0108\u7fff\u7fff\u010b\u010e\u0111\u0114\u0117\u011a\u011d\u0120\u0123\u7fff\u0caf\u0cb2\u0126\u0129\u012c\u012f\u7fff\u0132\u0135\u0138\u013b\u013e\u0141\u0cb5\u0cb8\u7fff\u7fff\u0144\u0147\u014a\u014d\u0150\u0153\u0cbb\u7fff\u7fff\u0156\u0159\u015c\u015f\u0162\u0165\u7fff\u7fff\u0168\u016b\u016e\u0171\u0174\u0177\u017a\u017d\u0180\u0183\u0186\u0189\u018c\u018f\u0192\u0195\u0198\u019b\u7fff\u7fff\u019e\u01a1\u01a4\u01a7\u01aa\u01ad\u01b0\u01b3\u01b6\u01b9\u01bc\u01bf\u01c2\u01c5\u01c8\u01cb\u01ce\u01d1\u01d4\u01d7\u01da\u01dd\u01e0\u0cbe\ua5a5 \u7fff\u01e3\u01e6\ua5a5\r\u7fff\u01e9\u01ec\ua5a5\u0013\u7fff\u0cc0\u0cc4\u0cc8\u0ccc\u0ccf\u0cd2\u0cd5\u0cd8\u0cdb\u01ef\u01f2\u01f5\u01f8\u01fb\u01fe\u0201\u0204\u0207\u020b\u020f\u0213\u0217\u021b\u021f\u0223\u7fff\u0227\u022b\u022f\u0233\u0237\u023a\u7fff\u7fff\u023d\u0240\u0243\u0246\u0249\u024c\u024f\u0253\u0257\u025a\u025d\u0cde\u0ce1\u0ce4\u0260\u0263\ua5a5\u0004\u7fff\u0266\u026a\u026e\u0271\u0274\u0277\u027a\u027d\u0280\u0283\u0286\u0289\u028c\u028f\u0292\u0295\u0298\u029b\u029e\u02a1\u02a4\u02a7\u02aa\u02ad\u02b0\u02b3\u02b6\u02b9\u02bc\u02bf\ua5a5h\u7fff\u0ce7\u0ce9\u0ceb\u0ced\u0cef\u0cf1\u0cf3\u0cf5\u0cf7\ua5a5\u001f\u7fff\u0cf9\u0cfc\u0cff\u0d02\u0d05\u0d08\u7fff\u7fff\u0d0b\u0d0d\u0d0f\u0d11\u0d13\ua5a5\u001b\u7fff\u02c2\ua5a53\u7fff\u02c5\ua5a5/\u7fff\u02c8\ua5a5\u0005\u7fff\u0d15\ua5a5\u0005\u7fff\u0d18\u0d1b\u02cd\u02d0\u02d2\u02d5\u02d8\u7fff\u02db\u7fff\u02de\u02e1\u02e4\ua5a5\u0019\u7fff\u02e8\u02eb\u02ee\u02f1\u02f4\u02f7\u02fa\ua5a5\u0019\u7fff\u02fe\u0301\u0304\u0307\u030a\ua5a5\u0004\u7fff\u030d\u0310\ua5a5+\u7fff\u0313\u7fff\u0316\u7fff\u7fff\u7fff\u0319\ua5a5\u0004\u7fff\u031c\u7fff\u031f\ua5a5\n\u7fff\u0322\ua5a5\u001f\u7fff\u0325\ua5a5\u0017\u7fff\u0328\u7fff\u032b\u7fff\u7fff\u7fff\u032e\ua5a5\u0004\u7fff\u0331\u7fff\u0334\ua5a5\u0017\u7fff\u0337\u033a\ua5a5A\u7fff\u033d\u0340\ua5a5\r\u7fff\u0343\u0346\u0349\u034c\u034f\u0351\u0353\u0356\u0359\u035b\u035d\u0360\u0363\u0366\u0369\u036c\u036f\u0371\u0373\u0376\u0379\u037c\u037f\u0382\u0385\u0387\u0389\u038c\u7fff\u7fff\u038f\u0392\u0395\u0398\u039b\u039e\u03a1\u03a4\u7fff\u7fff\u03a7\u03aa\ua5a5\u0080\u7fff\u0d1f\ua5a5x\u7fff\u03ad\ua5a5\u0007\u7fff\u03b0\u7fff\u7fff\u03b3\ua5a5#\u7fff\u03b6\u03b9\u03bc\u03bf\u03c2\u03c5\u03c8\u03cb\ua5a50\u7fff\u03ce\ua5a5\u001a\u7fff\u03d1\u03d4\ua5a5\u000f\u7fff\u03d7\u03da\u7fff\u03dd\ua5a5Y\u7fff\u03e0\u03e3\u03e6\u03e9\u7fff\u03ec\ua5a5H\u7fff\u03ef\u7fff\u7fff\u03f2\u03f5\ua5a5\u000f\u7fff\u03f8\u03fb\u7fff\u03fe\ua5a5 \u7fff\u0401\ua5a55\u7fff\u0404\u0407\u040a\ua5a5H\u7fff\u040d\ua5a5@\u7fff\u0410\ua5a5\u0006\u7fff\u0413\u0416\u7fff\u0419\u041c\ua5a5J\u7fff\u0420\u0423\u0426\ua5a53\u7fff\u0429\ua5a5L\u7fff\u042c\ua5a5(\u7fff\u0d22\u0d25\ua5a5C\u7fff\u042f\ua5a5\t\u7fff\u0432\ua5a5\u0004\u7fff\u0435\ua5a5\u0004\u7fff\u0438\ua5a5\u0004\u7fff\u043b\ua5a5\f\u7fff\u043e\ua5a5\t\u7fff\u0441\u7fff\u0444\u0447\u044a\u044e\u0451\ua5a5\u0006\u7fff\u0455\ua5a5\u0011\u7fff\u0458\ua5a5\t\u7fff\u045b\ua5a5\u0004\u7fff\u045e\ua5a5\u0004\u7fff\u0461\ua5a5\u0004\u7fff\u0464\ua5a5\f\u7fff\u0467\ua5a5F\u7fff\u0d28\u7fff\u7fff\u0d2b\u7fff\u7fff\u7fff\u0d2e\u7fff\u0d31\u7fff\u7fff\u0d34\ua5a5\u0005\u7fff\u0d37\u0d3a\u0d3d\u0d40\u0d43\u0d46\u0d49\u0d4c\u0d4f\u0d52\u0d55\u0d58\u0d5b\u0d5e\u0d61\u0d64\u0d68\u0d6c\u0d70\u0d74\u0d78\u0d7b\u0d7e\u0d81\u0d84\u0d87\u0d8b\u0d8e\u0d91\u0d94\u0d97\u0d9a\u0d9d\u0da1\u0da5\u0da8\u0dab\u0dae\u0db1\u0db4\u0db7\u7fff\u0dba\u7fff\u0dbd\u7fff\u0dc0\u0dc3\u0dc6\u0dc9\u0dcc\u0dcf\u0dd2\u0dd5\u0dd8\u0ddb\u0dde\u7fff\u0de1\u7fff\u0de4\u7fff\u0de7\u0dea\u0ded\u7fff\u7fff\u0df0\u0df3\u0df6\ua5a5\t\u7fff\u0df9\u7fff\u0dfc\u7fff\u0dff\u7fff\u0e02\u7fff\u0e05\u0e08\u0e0c\u7fff\u7fff\u0e0f\u0e12\u0e16\u7fff\u7fff\u0e19\u7fff\u0e1c\u0e1f\u0e22\u0e25\u0e28\u0e2b\u0e2e\u0e31\u0e34\u0e37\u0e3a\u0e3e\u0e42\u0e45\u0e48\u0e4b\u0e4f\u0e52\u0e55\u0e58\u0e5b\u0e5f\u0e63\u0e67\u0e6a\u0e6d\u0e70\u0e74\u0e77\u0e7b\u0e7e\u0e81\u0e84\u0e87\u0e8b\u0e8e\u0e91\u0e94\u0e97\u0e9a\u7fff\u0e9d\u0ea0\u0ea3\u0ea6\ua5a5\u0006\u7fff\u0ea9\u0eac\u7fff\u0eaf\u0eb2\u7fff\u7fff\u0eb5\u0eb8\u0ebb\u0ebe\u0ec1\u0ec4\u0ec7\u7fff\u7fff\u0eca\u7fff\u0ecd\ua5a5\u0007\u7fff\u0ed0\u0ed3\u0ed7\u0eda\u0edd\u0ee0\u0ee3\u0ee6\u0ee9\u0eec\u0ef0\u0ef3\u0ef6\u0efa\u0efd\u0f01\u0f05\u0f09\u0f0d\u0f11\u0f15\u0f18\u0f1b\u0f1e\u0f21\u0f24\u0f27\u0f2a\u0f2e\u0f31\u0f34\u0f37\u0f3a\u0f3d\u0f40\u0f43\u0f46\u0f49\u0f4c\u0f4f\u7fff\u0f52\u0f55\u0f59\u0f5c\u7fff\u0f5f\u0f62\u0f65\u0f68\u0f6b\u0f6e\u0f71\u0f74\ua5a5\u0007\u7fff\u046a\u046d\u0470\u0473\u0476\u0479\u047c\u047f\u0482\u0486\u048a\u048d\u0490\u0493\u0496\u0499\u049c\u049f\u04a2\u04a5\u04a8\u04ac\u04b0\u04b4\u04b8\u04bb\u04be\u04c1\u04c4\u04c8\u04cc\u04cf\u04d2\u04d5\u04d8\u04db\u04de\u04e1\u04e4\u04e7\u04ea\u04ed\u04f0\u04f3\u04f6\u04f9\u04fc\u0500\u0504\u0507\u050a\u050d\u0510\u0513\u0516\u0519\u051c\u0520\u0524\u0527\u052a\u052d\u0530\u0533\u0536\u0539\u053c\u053f\u0542\u0545\u0548\u054b\u054e\u0551\u0554\u0557\u055a\u055e\u0562\u0566\u056a\u056e\u0572\u0576\u057a\u057d\u0580\u0583\u0586\u0589\u058c\u058f\u0592\u0596\u059a\u059d\u05a0\u05a3\u05a6\u05a9\u05ac\u05b0\u05b4\u05b8\u05bc\u05c0\u05c4\u05c7\u05ca\u05cd\u05d0\u05d3\u05d6\u05d9\u05dc\u05df\u05e2\u05e5\u05e8\u05eb\u05ee\u05f2\u05f6\u05fa\u05fe\u0601\u0604\u0607\u060a\u060d\u0610\u0613\u0616\u0619\u061c\u061f\u0622\u0625\u0628\u062b\u062e\u0631\u0634\u0637\u063a\u063d\u0640\u0643\u0646\u0649\u064c\u064f\u0652\u0655\u7fff\u0f77\ua5a5\u0004\u7fff\u065b\u065e\u0661\u0664\u0667\u066b\u066f\u0673\u0677\u067b\u067f\u0683\u0687\u068b\u068f\u0693\u0697\u069b\u069f\u06a3\u06a7\u06ab\u06af\u06b3\u06b7\u06ba\u06bd\u06c0\u06c3\u06c6\u06c9\u06cd\u06d1\u06d5\u06d9\u06dd\u06e1\u06e5\u06e9\u06ed\u06f1\u06f4\u06f7\u06fa\u06fd\u0700\u0703\u0706\u0709\u070d\u0711\u0715\u0719\u071d\u0721\u0725\u0729\u072d\u0731\u0735\u0739\u073d\u0741\u0745\u0749\u074d\u0751\u0755\u0759\u075c\u075f\u0762\u0765\u0769\u076d\u0771\u0775\u0779\u077d\u0781\u0785\u0789\u078d\u0790\u0793\u0796\u0799\u079c\u079f\u07a2\ua5a5\u0006\u7fff\u07a5\u07a8\u07ab\u07af\u07b3\u07b7\u07bb\u07bf\u07c3\u07c6\u07c9\u07cd\u07d1\u07d5\u07d9\u07dd\u07e1\u07e4\u07e7\u07eb\u07ef\u07f3\u7fff\u7fff\u07f7\u07fa\u07fd\u0801\u0805\u0809\u7fff\u7fff\u080d\u0810\u0813\u0817\u081b\u081f\u0823\u0827\u082b\u082e\u0831\u0835\u0839\u083d\u0841\u0845\u0849\u084c\u084f\u0853\u0857\u085b\u085f\u0863\u0867\u086a\u086d\u0871\u0875\u0879\u087d\u0881\u0885\u0888\u088b\u088f\u0893\u0897\u7fff\u7fff\u089b\u089e\u08a1\u08a5\u08a9\u08ad\u7fff\u7fff\u08b1\u08b4\u08b7\u08bb\u08bf\u08c3\u08c7\u08cb\u7fff\u08cf\u7fff\u08d2\u7fff\u08d6\u7fff\u08da\u08de\u08e1\u08e4\u08e8\u08ec\u08f0\u08f4\u08f8\u08fc\u08ff\u0902\u0906\u090a\u090e\u0912\u0916\u091a\u091d\u0920\u0923\u0926\u0929\u092c\u092f\u0932\u0935\u0938\u093b\u093e\u0941\u7fff\u7fff\u0944\u0948\u094c\u0951\u0956\u095b\u0960\u0965\u096a\u096e\u0972\u0977\u097c\u0981\u0986\u098b\u0990\u0994\u0998\u099d\u09a2\u09a7\u09ac\u09b1\u09b6\u09ba\u09be\u09c3\u09c8\u09cd\u09d2\u09d7\u09dc\u09e0\u09e4\u09e9\u09ee\u09f3\u09f8\u09fd\u0a02\u0a06\u0a0a\u0a0f\u0a14\u0a19\u0a1e\u0a23\u0a28\u0a2b\u0a2e\u0a32\u0a35\u7fff\u0a39\u0a3c\u0a40\u0a43\u0a46\u0a49\u0a4c\u0f7a\u0a4f\u0f7d\u0f80\u0f83\u0a54\u0a58\u0a5b\u7fff\u0a5f\u0a62\u0a66\u0a69\u0a6c\u0a6f\u0a72\u0f87\u0f8b\u0f8f\u0a7e\u0a81\u0a84\u0a88\u7fff\u7fff\u0a8c\u0a8f\u0a93\u0a96\u0a99\u0a9c\u7fff\u0f93\u0f97\u0f9b\u0aa8\u0aab\u0aae\u0ab2\u0ab6\u0ab9\u0abc\u0abf\u0ac3\u0ac6\u0ac9\u0acc\u0acf\u0f9f\u0fa3\u0fa7\u7fff\u7fff\u0ad8\u0adc\u0adf\u7fff\u0ae3\u0ae6\u0aea\u0aed\u0af0\u0af3\u0af6\u0faa\u0fad\u7fff\u0fb0\u0fb2\u0fb4\u0fb6\u0fb8\u0fba\u0fbc\u0fbe\u0fc0\u0fc2\u0fc4\ua5a5\u0006\u7fff\u0fc6\ua5a5\u0005\u7fff\u0fc8\ua5a5\f\u7fff\u0fcb\u0fcd\u0fd0\ua5a5\f\u7fff\u0fd4\u0fd7\u7fff\u0fdb\u0fde\ua5a5\u0004\u7fff\u0fe2\u7fff\u0fe5\ua5a51\u7fff\u0fe8\u7fff\u7fff\u7fff\u0fea\u0fec\u0fee\u0ff0\u0ff2\u0ff4\u0ff6\u0ff8\u0ffa\u0ffc\u0ffe\u1000\u1002\u1004\u1006\u1008\u100a\u100c\u100e\u1010\u1012\u1014\u1016\u1018\u101a\u101c\u101e\ua5a5\u0014\u7fff\u1da2\ua5a5\u0004\u7fff\u1020\ua5a5W\u7fff\u1023\u1025\u7fff\u7fff\u7fff\u1028\u7fff\u102a\u102d\u102f\u1031\u1033\u1035\u1037\u1039\u103b\u103d\u103f\u7fff\u1041\u1043\u7fff\u1046\u1048\u104a\u104c\u104e\u1050\u7fff\u7fff\u1052\u1055\u1059\u7fff\u105c\u7fff\u0aff\u7fff\u105e\u7fff\u0b01\u0b03\u1060\u1062\u7fff\u1064\u1066\u1068\u7fff\u106a\u106c\u106e\u1070\u1072\u1074\ua5a5\u001a\u7fff\u1076\u107a\u107e\u1082\u1086\u108a\u108e\u1092\u1096\u109a\u109e\u10a2\u10a6\u10a9\u10ab\u10ae\u10b2\u10b5\u10b7\u10ba\u10be\u10c3\u10c6\u10c8\u10cb\u10cf\u10d1\u10d3\u10d5\u10d7\u10d9\u10dc\u10e0\u10e3\u10e5\u10e8\u10ec\u10f1\u10f4\u10f6\u10f9\u10fd\u10ff\u1101\u1103\ua5a5\u0004\u7fff\u0b06\ua5a5\u0004\u7fff\u0b09\u7fff\u7fff\u0b0c\ua5a5\u0017\u7fff\u0b0f\u7fff\u0b12\ua5a5\u0005\u7fff\u1105\u1108\u7fff\u110c\u110f\ua5a5\u0013\u7fff\u0b15\u7fff\u7fff\u0b18\u7fff\u0b1b\ua5a5\u0018\u7fff\u0b1e\ua5a5\n\u7fff\u0b21\u7fff\u7fff\u0b24\u0b27\u7fff\u7fff\u0b2a\u0b2d\u7fff\u7fff\u0b30\u0b33\ua5a5\u0006\u7fff\u0b36\u0b39\u7fff\u7fff\u0b3c\u0b3f\u7fff\u7fff\u0b42\u0b45\ua5a5\"\u7fff\u0b48\u0b4b\u0b4e\u0b51\ua5a50\u7fff\u0b54\u0b57\u0b5a\u0b5d\ua5a5\u0006\u7fff\u0b60\u0b63\u0b66\u0b69\ua5a5)\u7fff\u0b6c\u0b6e\ua5a5`\u7fff\u1113\u1115\u1117\u1119\u111b\u111d\u111f\u1121\u1123\u1125\u1127\u112a\u112d\u1130\u1133\u1136\u1139\u113c\u113f\u1142\ua5a56\u7fff\u1145\u1147\u1149\u114b\u114d\u114f\u1151\u1153\u1155\u1157\u1159\u115b\u115d\u115f\u1161\u1163\u1165\u1167\u1169\u116b\u116d\u116f\u1171\u1173\u1175\u1177\u1179\u117b\u117d\u117f\u1181\u1183\u1185\u1187\u1189\u118b\u118d\u118f\u1191\u1193\u1195\u1197\u1199\u119b\u119d\u119f\u11a1\u11a3\u11a5\u11a7\u11a9\u11ab\u11ad\ua5a5\u0015\u7fff\u11af\ua5a55\u7fff\u11b1\ua5a5\u0015\u7fff\u0b70\u7fff\u0b73\u7fff\u0b76\u7fff\u0b79\u7fff\u0b7c\u7fff\u0b7f\u7fff\u0b82\u7fff\u0b85\u7fff\u0b88\u7fff\u0b8b\u7fff\u0b8e\u7fff\u0b91\u7fff\u7fff\u0b94\u7fff\u0b97\u7fff\u0b9a\ua5a5\u0006\u7fff\u0b9d\u0ba0\u7fff\u0ba3\u0ba6\u7fff\u0ba9\u0bac\u7fff\u0baf\u0bb2\u7fff\u0bb5\u0bb8\ua5a5\u0014\u7fff\u0bbb\ua5a5\u0006\u7fff\u11b3\u11b6\u7fff\u0bbe\ua5a5\r\u7fff\u0bc1\u7fff\u0bc4\u7fff\u0bc7\u7fff\u0bca\u7fff\u0bcd\u7fff\u0bd0\u7fff\u0bd3\u7fff\u0bd6\u7fff\u0bd9\u7fff\u0bdc\u7fff\u0bdf\u7fff\u0be2\u7fff\u7fff\u0be5\u7fff\u0be8\u7fff\u0beb\ua5a5\u0006\u7fff\u0bee\u0bf1\u7fff\u0bf4\u0bf7\u7fff\u0bfa\u0bfd\u7fff\u0c00\u0c03\u7fff\u0c06\u0c09\ua5a5\u0016\u7fff\u0c0c\u7fff\u7fff\u0c0f\u0c12\u0c15\u0c18\u7fff\u7fff\u7fff\u0c1b\ua5a51\u7fff\u11b9\u11bb\u11be\u11c1\u11c3\u11c6\u11c9\u11cb\u11ce\u11d0\u11d3\u11d6\u11d9\u11dc\u11df\u11e2\u11e5\u11e7\u11e9\u11ec\u11ef\u11f1\u11f4\u11f6\u11f8\u11fb\u11fd\u11ff\u1201\u1203\u1205\u1207\u120a\u120c\u120f\u1211\u1214\u1216\u1219\u121b\u121e\u1222\u1225\u1227\u1229\u122c\u1230\u1233\u1235\u1237\u123a\u123c\u123e\u1241\u1244\u1247\u124a\u124e\u1251\u1255\u1258\u125b\u125e\u1261\u1264\u1267\u126a\u126d\u1271\u1275\u1278\u127b\u127e\u1282\u1285\u1288\u128b\u128e\u1291\u1293\u1296\u1298\u129b\u129e\u12a1\u12a4\u12a6\u12a9\u12ad\u12b0\u12b3\u12b7\u12ba\u12bc\u7fff\u7fff\u7fff\u12bf\u12c1\u12c3\u12c5\u12c7\u12c9\u12cb\u12cd\u12cf\u12d1\u12d3\u12d5\u12d7\u12d9\ua5a5`\u7fff\u12db\u12df\u12e3\u12e7\u12eb\u12ef\u12f3\u12f7\u12fb\u12ff\u1303\u1307\u130b\u130f\u1313\u1318\u131d\u1322\u1327\u132c\u1331\u1336\u133b\u1340\u1345\u134a\u134f\u1354\u1359\u7fff\u7fff\u7fff\u135e\u1362\u1366\u136a\u136e\u1372\u1376\u137a\u137e\u1382\u1386\u138a\u138e\u1392\u1396\u139a\u139e\u13a2\u13a6\u13aa\u13ae\u13b2\u13b6\u13ba\u13be\u13c2\u13c6\u13ca\u13ce\u13d2\u13d6\u13da\u13de\u13e2\u13e6\u13ea\ua5a5\u001c\u7fff\u13ee\u13f0\u13f2\u13f4\u13f6\u13f8\u13fa\u13fc\u13fe\u1400\u1402\u1404\u1406\u1408\u140a\u140d\u1410\u1413\u1416\u1419\u141c\u141f\u1422\u1425\u1428\u142b\u142e\u1431\ua5a5\u0004\u7fff\u1434\u1436\u1438\u143a\u143c\u143e\u1440\u1442\u1444\u1446\u1448\u144a\u144c\u144e\u1450\u1452\u1454\u1456\u1458\u145a\u145c\u145e\u1460\u1462\u1464\u1466\u1468\u146a\u146c\u146e\u1470\u1472\u1474\u1476\u1478\u147a\u147c\u147e\u1480\u1482\u1484\u1486\u1488\u148a\u148c\u148e\u1490\u1492\u1494\ua5a5\u000f\u7fff\u1496\u1499\u149c\u149f\u14a2\u14a5\u14a8\u14ab\u14ae\u14b1\u14b5\u14b9\ua5a5\u0004\u7fff\u14bd\u14bf\u14c1\u14c3\u14c5\u14c7\u14c9\u14cb\u14cd\u14cf\u14d1\u14d3\u14d5\u14d7\u14d9\u14db\u14dd\u14df\u14e1\u14e3\u14e5\u14e7\u14e9\u14eb\u14ed\u14ef\u14f1\u14f3\u14f5\u14f7\u14f9\u14fb\u14fd\u14ff\u1501\u1503\u1505\u1507\u1509\u150b\u150d\u150f\u1511\u1513\u1515\u1517\u1519\u7fff\u151b\u1521\u1526\u152c\u1530\u1536\u153a\u153e\u1545\u154a\u154e\u1552\u1556\u155b\u1560\u1565\u156a\u156f\u1574\u1579\u1580\u1583\u158a\u1591\u1597\u159c\u15a3\u15aa\u15af\u15b3\u15b7\u15bc\u15c1\u15c7\u15cd\u15d1\u15d5\u15da\u15de\u15e2\u15e5\u15e8\u15ec\u15f0\u15f7\u15fc\u1602\u1609\u160e\u1612\u1616\u161d\u1622\u1629\u162d\u1633\u1637\u163c\u1640\u1645\u164b\u1650\u1656\u165b\u165e\u1664\u1668\u166c\u1671\u1675\u1679\u167d\u1683\u1688\u168b\u1692\u1696\u169c\u16a1\u16a6\u16aa\u16ae\u16b3\u16b6\u16bb\u16c1\u16c4\u16cb\u16cf\u16d2\u16d5\u16d8\u16db\u16de\u16e1\u16e4\u16e7\u16ea\u16ed\u16f1\u16f5\u16f9\u16fd\u1701\u1705\u1709\u170d\u1711\u1715\u1719\u171d\u1721\u1725\u1729\u172d\u1730\u1733\u1737\u173a\ua5a5\u0004\u7fff\u173d\u1740\u1743\u1746\u1749\u174e\u1751\u1754\u1757\u175a\u175d\u1760\u1763\u1766\u176a\u176f\u1772\u1775\u1778\u177b\u177e\u1781\u1784\u1788\u178c\u1790\u1794\u1797\u179a\u179d\u17a0\u17a3\u17a6\u17a9\u17ac\u17af\u17b2\u17b6\u17ba\u17bd\u17c1\u17c5\u17c9\u17cc\u17d0\u17d4\u17d9\u17dc\u17e0\u17e4\u17e8\u17ec\u17f2\u17f9\u17fc\u17ff\u1802\u1805\u1808\u180b\u180e\u1811\u1814\u1817\u181a\u181d\u1820\u1823\u1826\u1829\u182c\u182f\u1834\u1837\u183a\u183d\u1842\u1846\u1849\u184c\u184f\u1852\u1855\u1858\u185b\u185e\u1861\u1864\u1868\u186b\u186e\u1872\u1876\u1879\u187e\u1882\u1885\u1888\u188b\u7fff\u7fff\u188e\u1891\u1894\u1897\u189a\u189d\u18a0\u18a3\u18a6\u18a9\u18ad\u18b1\u18b5\u18b9\u18bd\u18c1\u18c5\u18c9\u18cd\u18d1\u18d5\u18d9\u18dd\u18e1\u18e5\u18e9\u18ed\u18f1\u18f5\u18f9\u18fd\u7fff\u1901\u1904\u1907\u190a\u190e\u1912\u1915\ua5a5\f\u7fff\u1918\u191b\u191e\u1921\u1924\ua5a5\u0007\u7fff\u1927\u192a\u192c\u192e\u1930\u1932\u1934\u1936\u1938\u193a\u193c\u0c1e\u0c21\u0c24\u0c28\u0c2c\u0c2f\u0c32\u0c35\u0c38\u0c3b\u0c3e\u0c41\u0c44\u7fff\u0c47\u0c4a\u0c4d\u0c50\u0c53\u7fff\u0c56\u7fff\u0c59\u0c5c\u7fff\u0c5f\u0c62\u7fff\u0c65\u0c68\u0c6b\u0c6e\u0c71\u0c74\u0c77\u0c7a\u0c7d\u193e\u1941\u1943\u1945\u1947\u1949\u194b\u194d\u194f\u1951\u1953\u1955\u1957\u1959\u195b\u195d\u195f\u1961\u1963\u1965\u1967\u1969\u196b\u196d\u196f\u1971\u1973\u1975\u1977\u1979\u197b\u197d\u197f\u1981\u1983\u1985\u1987\u1989\u198b\u198d\u198f\u1991\u1993\u1995\u1997\u1999\u199b\u199d\u199f\u19a1\u19a3\u19a5\u19a7\u19a9\u19ab\u19ad\u19af\u19b1\u19b3\u19b5\u19b7\u19b9\u19bb\u19bd\u19bf\u19c1\u19c3\u19c5\u19c7\u19c9\u19cb\u19cd\u19cf\u19d1\u19d3\u19d5\u19d7\u19d9\u19db\u19dd\u19df\u19e1\u19e3\u19e5\u19e7\u19e9\u19eb\u19ed\u19ef\u19f1\u19f3\u19f5\u19f7\u19f9\u19fb\u19fd\u19ff\u1a01\u1a03\ua5a5!\u7fff\u1a05\u1a07\u1a09\u1a0b\u1a0d\u1a0f\u1a11\u1a13\u1a15\u1a17\u1a19\u1a1b\u1a1d\u1a1f\u1a21\u1a23\u1a25\u1a27\u1a29\u1a2b\u1a2d\ua5a5\u0014\u7fff\u1a2f\u1a31\u1a33\u1a35\ua5a50\u7fff\u1a37\u1a3a\u1a3c\u1a3e\u1a41\u1a44\u1a46\u1a48\u1a4a\u1a4c\u1a4e\u1a50\u1a52\u1a54\u1a56\u1a58\u1a5a\u1a5c\u1a5e\u1a60\u1a62\ua5a5\u0004\u7fff\u1a64\u1a67\u1a6a\u1a6d\u1a70\u1a73\u1a76\u1a79\u1a7b\u1a7d\u7fff\u1a7f\u1a81\u1a83\u1a85\u1a87\u1a89\u1a8b\u1a8d\u1a8f\u1a91\u1a93\u1a95\u1a97\u1a99\u1a9b\u1a9d\u1a9f\u1aa1\u1aa3\u7fff\u1aa5\u1aa7\u1aa9\u1aab\ua5a5\u0004\u7fff\u1aad\u1ab0\u1ab3\u7fff\u1ab6\u7fff\u1ab9\u1abc\u1abf\u1ac2\u1ac5\u1ac8\u1acb\u1ace\u1ad1\u1ad4\u1ad7\u1ad9\u1adb\u1add\u1adf\u1ae1\u1ae3\u1ae5\u1ae7\u1ae9\u1aeb\u1aed\u1aef\u1af1\u1af3\u1af5\u1af7\u1af9\u1afb\u1afd\u1aff\u1b01\u1b03\u1b05\u1b07\u1b09\u1b0b\u1b0d\u1b0f\u1b11\u1b13\u1b15\u1b17\u1b19\u1b1b\u1b1d\u1b1f\u1b21\u1b23\u1b25\u1b27\u1b29\u1b2b\u1b2d\u1b2f\u1b31\u1b33\u1b35\u1b37\u1b39\u1b3b\u1b3d\u1b3f\u1b41\u1b43\u1b45\u1b47\u1b49\u1b4b\u1b4d\u1b4f\u1b51\u1b53\u1b55\u1b57\u1b59\u1b5b\u1b5d\u1b5f\u1b61\u1b63\u1b65\u1b67\u1b69\u1b6b\u1b6d\u1b6f\u1b71\u1b73\u1b75\u1b77\u1b79\u1b7b\u1b7d\u1b7f\u1b81\u1b83\u1b85\u1b87\u1b89\u1b8b\u1b8d\u1b8f\u1b91\u1b93\u1b95\u1b97\u1b99\u1b9b\u1b9d\u1b9f\u1ba1\u1ba3\u1ba5\u1ba7\u1ba9\u1bab\u1bad\u1baf\u1bb1\u1bb3\u1bb5\u1bb7\u1bb9\u1bbb\u1bbd\u1bbf\ua5a5\u000b\u7fff\u1bc1\u1bc3\u1bc5\u1bc7\u1bc9\u1bcb\u1bcd\u1bcf\u1bd1\u1bd3\u1bd5\u1bd7\u1bd9\u1bdb\u1bdd\u1bdf\u1be1\u1be3\u1be5\u1be7\u1be9\u1beb\u1bed\u1bef\u1bf1\u1bf3\u1bf5\u1bf7\u1bf9\u1bfb\u1bfd\u1bff\u1c01\u1c03\u1c05\u1c07\u1c09\u1c0b\u1c0d\u1c0f\u1c11\u1c13\u1c15\u1c17\u1c19\u1c1b\u1c1d\u1c1f\u1c21\u1c23\u1c25\u1c27\u1c29\u1c2b\u1c2d\u1c2f\u1c31\u1c33\u1c35\u1c37\u1c39\u1c3b\u1c3e\u1c41\u1c44\u1c46\u1c48\u1c4a\u1c4c\u1c4e\u1c50\u1c52\u1c54\u1c56\u1c58\u1c5a\u1c5c\u1c5e\u1c60\u1c62\u1c64\u1c66\u1c68\u1c6a\u1c6c\u1c6e\u1c70\u1c72\u1c74\u1c76\u1c78\u1c7a\u1c7c\u1c7e\u7fff\u7fff\u1c80\u1c82\u1c84\u1c86\u1c88\u1c8a\u1c8c\u1c8e\u1c90\u1c92\u1c94\u1c96\u1c98\u1c9a\u1c9c\u1c9e\u1ca0\u1ca2\u1ca4\u1ca6\u1ca8\u1caa\u1cac\u1cae\u1cb0\u1cb2\u1cb4\u1cb6\u1cb8\u1cba\u1cbc\u1cbe\u1cc0\u1cc2\u1cc4\u1cc6\u1cc8\u1cca\u1ccc\u1cce\u1cd0\u1cd2\u1cd4\u1cd6\u1cd8\u1cda\u1cdc\u1cde\u1ce0\u1ce2\u1ce4\u1ce6\u1ce8\u1cea\u1cec\u1cee\u1cf0\u1cf2\u1cf4\u1cf6\u1cf8\u1cfa\u1cfd\u1d00\u1d02\u1d04\u1d07\u1d0a\u1d0c\u1d0f\u1d12\u1d14\u1d17\u1d19\u1d1c\u1d1f\u1d22\u1d25\u1d28\u1d2b\u1d2e\u1d30\u1d32\u1d35\u1d38\u1d3a\u1d3d\u1d3f\u1d41\u1d44\u1d46\u1d48\u1d4a\u1d4c\u7fff\u7fff\u7fff\u1d4e\u1d50\u1d53\u1d55\u1d58\u1d5a\u7fff\u7fff\u1d5d\u1d5f\u1d62\u1d64\u1d67\u1d6b\u7fff\u7fff\u1d6e\u1d70\u1d72\u1d75\u1d79\u1d7c\u7fff\u7fff\u1d7e\u1d80\u1d83\u7fff\u7fff\u7fff\u1d85\u1d87\u1d89\u1d8b\u1d8e\u1d90\u1d92\u7fff\u1d94\u1d96\u1d98\u1d9a\u1d9c\u1d9e\u1da0\ua5a5\u0011\u7fff");
    private static final short[] kCanonicalIndex = Utility.RLEStringToShortArray("\u0000\u0200\ua5a5\u0006\u0000\u0080\u0000\u0000\u00fd\u0000\u016c\u01b1\u0222\ua5a5\u0004\u0000\u02a1\u0320\u039e\u041d\u049c\u04f3\u0541\u0598\u05e6\u0000\u0635\u0684\u06ec\u076c\ua5a5!\u0000\u07a6\ua5a5\u001e\u0000\u0808\u086f\ua5a5\u0194\u0000\u08d1\ua5a5\u0005\u0000\u0931\u0000\u0000\u0000");
    private static final byte[] kCanonicalValues = Utility.RLEStringToByteArray("\u0000\u09b1\ua580\u80a5\u1566\u68a5\u045c\u6858\ua505\u5c4a\u4aa5\u045c\u4a4a\ua50b\u5ca5\u0581\ua504\u5ca5\u0866\u5ca5\u1a80\u6a6a\ua51e\u80a5\u0466\ua579\u805c\ua504\u665c\u6666\u665e\u5ca5\u0666\u80a5\u055c\u6666\u5c66\u665e\u6666\u8a8b\u8c8d\u8e8f\u9091\u9293\u8094\u9596\u8097\u8098\u9980\u66a5\u4b80\u9b9c\u9d9e\u9fa0\ua1a2\ua51d\u80a3\ua556\u80a5\u0766\u8080\ua504\u665c\u6680\u8066\u6680\u5c66\u665c\ua512\u80a5\ua5a4\ua539\u8087\ua504\u80a6\ua7a8\ua9aa\uabac\uada5\u0480\u8980\u8080\uaeaf\u6666\ua50d\u80b0\ub1a5\u1c80\ub2a5\u3a80\u87a5\u0480\ub3b4\ub5b6\ua508\u8089\ua514\u80b7\ub8a5\u1c80\ub9a5\u3980\u87a5\u0480\ubabb\ua504\u80bc\ubd80\u80be\ubf89\ua522\u80c0\uc1a5\u0e80\uc3c2\ua539\u8087\ua504\u80c4\uc5c6\uc7c8\u80c9\ucaa5\u0480\u89a5\u3280\ucba5\u3a80\u8780\u80cc\u80cd\ucecf\ua509\u8089\ua508\u8066\ua540\u80d0\ua50c\u8089\ua53e\u80d1\ud2d3\ua505\u80d4\ud5d6\u80d7\ud8d9\u89a5\u0780\udadb\ua53f\u80dc\ua506\u80dd\ua505\u80de\u89a5\u4180\udfe0\ue1a5\u0980\u89a5\u3280\ue280\u80e3\ue4e5\ue6e7\ue8e9\ua50c\u80ea\uebec\uedee\ueff0\u00a5\u3180\uf180\u80f2\uf3f4\uf5f6\uf780\uf8f9\ua50b\u80fa\ufbfc\ufdfe\uffa5\u3280\u5c5c\ua51b\u8066\u8066\u8058\ua504\u805c\u5ca5\u3180\u0102\u0304\u0506\u0708\u090a\u0b0c\u0d0e\u800f\u1066\u6689\u80a5\u0666\ua504\u80a5\u0686\u8086\u80a5\u1586\u8080\u80a5\u0786\u8086\ua550\u8066\u6681\u81a5\u0466\u8181\u8166\u66a5\u0480\u81a5\u2a80\u5a64\u685e\u6060\ua550\u8088\u88a5\u6580\u9aa5\u6180\ua504\u66a5\u5c80");
    private static String contents = "A\u0300\u0000A\u0301\u0000A\u0302\u0000A\u0303\u0000A\u0308\u0000A\u030a\u0000C\u0327\u0000E\u0300\u0000E\u0301\u0000E\u0302\u0000E\u0308\u0000I\u0300\u0000I\u0301\u0000I\u0302\u0000I\u0308\u0000N\u0303\u0000O\u0300\u0000O\u0301\u0000O\u0302\u0000O\u0303\u0000O\u0308\u0000U\u0300\u0000U\u0301\u0000U\u0302\u0000U\u0308\u0000Y\u0301\u0000a\u0300\u0000a\u0301\u0000a\u0302\u0000a\u0303\u0000a\u0308\u0000a\u030a\u0000c\u0327\u0000e\u0300\u0000e\u0301\u0000e\u0302\u0000e\u0308\u0000i\u0300\u0000i\u0301\u0000i\u0302\u0000i\u0308\u0000n\u0303\u0000o\u0300\u0000o\u0301\u0000o\u0302\u0000o\u0303\u0000o\u0308\u0000u\u0300\u0000u\u0301\u0000u\u0302\u0000u\u0308\u0000y\u0301\u0000y\u0308\u0000A\u0304\u0000a\u0304\u0000A\u0306\u0000a\u0306\u0000A\u0328\u0000a\u0328\u0000C\u0301\u0000c\u0301\u0000C\u0302\u0000c\u0302\u0000C\u0307\u0000c\u0307\u0000C\u030c\u0000c\u030c\u0000D\u030c\u0000d\u030c\u0000E\u0304\u0000e\u0304\u0000E\u0306\u0000e\u0306\u0000E\u0307\u0000e\u0307\u0000E\u0328\u0000e\u0328\u0000E\u030c\u0000e\u030c\u0000G\u0302\u0000g\u0302\u0000G\u0306\u0000g\u0306\u0000G\u0307\u0000g\u0307\u0000G\u0327\u0000g\u0327\u0000H\u0302\u0000h\u0302\u0000I\u0303\u0000i\u0303\u0000I\u0304\u0000i\u0304\u0000I\u0306\u0000i\u0306\u0000I\u0328\u0000i\u0328\u0000I\u0307\u0000J\u0302\u0000j\u0302\u0000K\u0327\u0000k\u0327\u0000L\u0301\u0000l\u0301\u0000L\u0327\u0000l\u0327\u0000L\u030c\u0000l\u030c\u0000N\u0301\u0000n\u0301\u0000N\u0327\u0000n\u0327\u0000N\u030c\u0000n\u030c\u0000O\u0304\u0000o\u0304\u0000O\u0306\u0000o\u0306\u0000O\u030b\u0000o\u030b\u0000R\u0301\u0000r\u0301\u0000R\u0327\u0000r\u0327\u0000R\u030c\u0000r\u030c\u0000S\u0301\u0000s\u0301\u0000S\u0302\u0000s\u0302\u0000S\u0327\u0000s\u0327\u0000S\u030c\u0000s\u030c\u0000T\u0327\u0000t\u0327\u0000T\u030c\u0000t\u030c\u0000U\u0303\u0000u\u0303\u0000U\u0304\u0000u\u0304\u0000U\u0306\u0000u\u0306\u0000U\u030a\u0000u\u030a\u0000U\u030b\u0000u\u030b\u0000U\u0328\u0000u\u0328\u0000W\u0302\u0000w\u0302\u0000Y\u0302\u0000y\u0302\u0000Y\u0308\u0000Z\u0301\u0000z\u0301\u0000Z\u0307\u0000z\u0307\u0000Z\u030c\u0000z\u030c\u0000O\u031b\u0000o\u031b\u0000U\u031b\u0000u\u031b\u0000A\u030c\u0000a\u030c\u0000I\u030c\u0000i\u030c\u0000O\u030c\u0000o\u030c\u0000U\u030c\u0000u\u030c\u0000U\u0308\u0304\u0000u\u0308\u0304\u0000U\u0308\u0301\u0000u\u0308\u0301\u0000U\u0308\u030c\u0000u\u0308\u030c\u0000U\u0308\u0300\u0000u\u0308\u0300\u0000A\u0308\u0304\u0000a\u0308\u0304\u0000A\u0307\u0304\u0000a\u0307\u0304\u0000\u00c6\u0304\u0000\u00e6\u0304\u0000G\u030c\u0000g\u030c\u0000K\u030c\u0000k\u030c\u0000O\u0328\u0000o\u0328\u0000O\u0328\u0304\u0000o\u0328\u0304\u0000\u01b7\u030c\u0000\u0292\u030c\u0000j\u030c\u0000G\u0301\u0000g\u0301\u0000A\u030a\u0301\u0000a\u030a\u0301\u0000\u00c6\u0301\u0000\u00e6\u0301\u0000\u00d8\u0301\u0000\u00f8\u0301\u0000A\u030f\u0000a\u030f\u0000A\u0311\u0000a\u0311\u0000E\u030f\u0000e\u030f\u0000E\u0311\u0000e\u0311\u0000I\u030f\u0000i\u030f\u0000I\u0311\u0000i\u0311\u0000O\u030f\u0000o\u030f\u0000O\u0311\u0000o\u0311\u0000R\u030f\u0000r\u030f\u0000R\u0311\u0000r\u0311\u0000U\u030f\u0000u\u030f\u0000U\u0311\u0000u\u0311\u0000\u0306\u0307\u0000\u0308\u030d\u0000\u02b9\u0000\u00a8\u030d\u0000\u0391\u030d\u0000\u00b7\u0000\u0395\u030d\u0000\u0397\u030d\u0000\u0399\u030d\u0000\u039f\u030d\u0000\u03a5\u030d\u0000\u03a9\u030d\u0000\u03b9\u0308\u030d\u0000\u0399\u0308\u0000\u03a5\u0308\u0000\u03b1\u030d\u0000\u03b5\u030d\u0000\u03b7\u030d\u0000\u03b9\u030d\u0000\u03c5\u0308\u030d\u0000\u03b9\u0308\u0000\u03c5\u0308\u0000\u03bf\u030d\u0000\u03c5\u030d\u0000\u03c9\u030d\u0000\u03d2\u030d\u0000\u03d2\u0308\u0000\u0415\u0308\u0000\u0413\u0301\u0000\u0406\u0308\u0000\u041a\u0301\u0000\u0423\u0306\u0000\u0418\u0306\u0000\u0438\u0306\u0000\u0435\u0308\u0000\u0433\u0301\u0000\u0456\u0308\u0000\u043a\u0301\u0000\u0443\u0306\u0000\u0474\u030f\u0000\u0475\u030f\u0000\u0416\u0306\u0000\u0436\u0306\u0000\u0410\u0306\u0000\u0430\u0306\u0000\u0410\u0308\u0000\u0430\u0308\u0000\u00c6\u0000\u00e6\u0000\u0415\u0306\u0000\u0435\u0306\u0000\u018f\u0000\u0259\u0000\u018f\u0308\u0000\u0259\u0308\u0000\u0416\u0308\u0000\u0436\u0308\u0000\u0417\u0308\u0000\u0437\u0308\u0000\u01b7\u0000\u0292\u0000\u0418\u0304\u0000\u0438\u0304\u0000\u0418\u0308\u0000\u0438\u0308\u0000\u041e\u0308\u0000\u043e\u0308\u0000\u019f\u0000\u0275\u0000\u019f\u0308\u0000\u0275\u0308\u0000\u0423\u0304\u0000\u0443\u0304\u0000\u0423\u0308\u0000\u0443\u0308\u0000\u0423\u030b\u0000\u0443\u030b\u0000\u0427\u0308\u0000\u0447\u0308\u0000\u042b\u0308\u0000\u044b\u0308\u0000\u0928\u093c\u0000\u0930\u093c\u0000\u0933\u093c\u0000\u0915\u093c\u0000\u0916\u093c\u0000\u0917\u093c\u0000\u091c\u093c\u0000\u0921\u093c\u0000\u0922\u093c\u0000\u092b\u093c\u0000\u092f\u093c\u0000\u09ac\u09bc\u0000\u09c7\u09be\u0000\u09c7\u09d7\u0000\u09a1\u09bc\u0000\u09a2\u09bc\u0000\u09af\u09bc\u0000\u0a16\u0a3c\u0000\u0a17\u0a3c\u0000\u0a1c\u0a3c\u0000\u0a21\u0a3c\u0000\u0a2b\u0a3c\u0000\u0b47\u0b56\u0000\u0b47\u0b3e\u0000\u0b47\u0b57\u0000\u0b21\u0b3c\u0000\u0b22\u0b3c\u0000\u0b2f\u0b3c\u0000\u0b92\u0bd7\u0000\u0bc6\u0bbe\u0000\u0bc7\u0bbe\u0000\u0bc6\u0bd7\u0000\u0c46\u0c56\u0000\u0cbf\u0cd5\u0000\u0cc6\u0cd5\u0000\u0cc6\u0cd6\u0000\u0cc6\u0cc2\u0000\u0cc6\u0cc2\u0cd5\u0000\u0d46\u0d3e\u0000\u0d47\u0d3e\u0000\u0d46\u0d57\u0000\u0e4d\u0e32\u0000\u0ecd\u0eb2\u0000\u0f42\u0fb7\u0000\u0f4c\u0fb7\u0000\u0f51\u0fb7\u0000\u0f56\u0fb7\u0000\u0f5b\u0fb7\u0000\u0f40\u0fb5\u0000\u0f71\u0f72\u0000\u0f74\u0f71\u0000\u0fb2\u0f80\u0000\u0fb2\u0f80\u0f71\u0000\u0fb3\u0f80\u0000\u0fb3\u0f80\u0f71\u0000\u0f80\u0f71\u0000\u0f92\u0fb7\u0000\u0f9c\u0fb7\u0000\u0fa1\u0fb7\u0000\u0fa6\u0fb7\u0000\u0fab\u0fb7\u0000\u0f90\u0fb5\u0000A\u0325\u0000a\u0325\u0000B\u0307\u0000b\u0307\u0000B\u0323\u0000b\u0323\u0000B\u0331\u0000b\u0331\u0000C\u0327\u0301\u0000c\u0327\u0301\u0000D\u0307\u0000d\u0307\u0000D\u0323\u0000d\u0323\u0000D\u0331\u0000d\u0331\u0000D\u0327\u0000d\u0327\u0000D\u032d\u0000d\u032d\u0000E\u0304\u0300\u0000e\u0304\u0300\u0000E\u0304\u0301\u0000e\u0304\u0301\u0000E\u032d\u0000e\u032d\u0000E\u0330\u0000e\u0330\u0000E\u0306\u0327\u0000e\u0306\u0327\u0000F\u0307\u0000f\u0307\u0000G\u0304\u0000g\u0304\u0000H\u0307\u0000h\u0307\u0000H\u0323\u0000h\u0323\u0000H\u0308\u0000h\u0308\u0000H\u0327\u0000h\u0327\u0000H\u032e\u0000h\u032e\u0000I\u0330\u0000i\u0330\u0000I\u0308\u0301\u0000i\u0308\u0301\u0000K\u0301\u0000k\u0301\u0000K\u0323\u0000k\u0323\u0000K\u0331\u0000k\u0331\u0000L\u0323\u0000l\u0323\u0000L\u0323\u0304\u0000l\u0323\u0304\u0000L\u0331\u0000l\u0331\u0000L\u032d\u0000l\u032d\u0000M\u0301\u0000m\u0301\u0000M\u0307\u0000m\u0307\u0000M\u0323\u0000m\u0323\u0000N\u0307\u0000n\u0307\u0000N\u0323\u0000n\u0323\u0000N\u0331\u0000n\u0331\u0000N\u032d\u0000n\u032d\u0000O\u0303\u0301\u0000o\u0303\u0301\u0000O\u0303\u0308\u0000o\u0303\u0308\u0000O\u0304\u0300\u0000o\u0304\u0300\u0000O\u0304\u0301\u0000o\u0304\u0301\u0000P\u0301\u0000p\u0301\u0000P\u0307\u0000p\u0307\u0000R\u0307\u0000r\u0307\u0000R\u0323\u0000r\u0323\u0000R\u0323\u0304\u0000r\u0323\u0304\u0000R\u0331\u0000r\u0331\u0000S\u0307\u0000s\u0307\u0000S\u0323\u0000s\u0323\u0000S\u0301\u0307\u0000s\u0301\u0307\u0000S\u030c\u0307\u0000s\u030c\u0307\u0000S\u0323\u0307\u0000s\u0323\u0307\u0000T\u0307\u0000t\u0307\u0000T\u0323\u0000t\u0323\u0000T\u0331\u0000t\u0331\u0000T\u032d\u0000t\u032d\u0000U\u0324\u0000u\u0324\u0000U\u0330\u0000u\u0330\u0000U\u032d\u0000u\u032d\u0000U\u0303\u0301\u0000u\u0303\u0301\u0000U\u0304\u0308\u0000u\u0304\u0308\u0000V\u0303\u0000v\u0303\u0000V\u0323\u0000v\u0323\u0000W\u0300\u0000w\u0300\u0000W\u0301\u0000w\u0301\u0000W\u0308\u0000w\u0308\u0000W\u0307\u0000w\u0307\u0000W\u0323\u0000w\u0323\u0000X\u0307\u0000x\u0307\u0000X\u0308\u0000x\u0308\u0000Y\u0307\u0000y\u0307\u0000Z\u0302\u0000z\u0302\u0000Z\u0323\u0000z\u0323\u0000Z\u0331\u0000z\u0331\u0000h\u0331\u0000t\u0308\u0000w\u030a\u0000y\u030a\u0000\u017f\u0307\u0000A\u0323\u0000a\u0323\u0000A\u0309\u0000a\u0309\u0000A\u0302\u0301\u0000a\u0302\u0301\u0000A\u0302\u0300\u0000a\u0302\u0300\u0000A\u0302\u0309\u0000a\u0302\u0309\u0000A\u0302\u0303\u0000a\u0302\u0303\u0000A\u0302\u0323\u0000a\u0302\u0323\u0000A\u0306\u0301\u0000a\u0306\u0301\u0000A\u0306\u0300\u0000a\u0306\u0300\u0000A\u0306\u0309\u0000a\u0306\u0309\u0000A\u0306\u0303\u0000a\u0306\u0303\u0000A\u0306\u0323\u0000a\u0306\u0323\u0000E\u0323\u0000e\u0323\u0000E\u0309\u0000e\u0309\u0000E\u0303\u0000e\u0303\u0000E\u0302\u0301\u0000e\u0302\u0301\u0000E\u0302\u0300\u0000e\u0302\u0300\u0000E\u0302\u0309\u0000e\u0302\u0309\u0000E\u0302\u0303\u0000e\u0302\u0303\u0000E\u0302\u0323\u0000e\u0302\u0323\u0000I\u0309\u0000i\u0309\u0000I\u0323\u0000i\u0323\u0000O\u0323\u0000o\u0323\u0000O\u0309\u0000o\u0309\u0000O\u0302\u0301\u0000o\u0302\u0301\u0000O\u0302\u0300\u0000o\u0302\u0300\u0000O\u0302\u0309\u0000o\u0302\u0309\u0000O\u0302\u0303\u0000o\u0302\u0303\u0000O\u0302\u0323\u0000o\u0302\u0323\u0000O\u031b\u0301\u0000o\u031b\u0301\u0000O\u031b\u0300\u0000o\u031b\u0300\u0000O\u031b\u0309\u0000o\u031b\u0309\u0000O\u031b\u0303\u0000o\u031b\u0303\u0000O\u031b\u0323\u0000o\u031b\u0323\u0000U\u0323\u0000u\u0323\u0000U\u0309\u0000u\u0309\u0000U\u031b\u0301\u0000u\u031b\u0301\u0000U\u031b\u0300\u0000u\u031b\u0300\u0000U\u031b\u0309\u0000u\u031b\u0309\u0000U\u031b\u0303\u0000u\u031b\u0303\u0000U\u031b\u0323\u0000u\u031b\u0323\u0000Y\u0300\u0000y\u0300\u0000Y\u0323\u0000y\u0323\u0000Y\u0309\u0000y\u0309\u0000Y\u0303\u0000y\u0303\u0000\u03b1\u0313\u0000\u03b1\u0314\u0000\u03b1\u0313\u0300\u0000\u03b1\u0314\u0300\u0000\u03b1\u0313\u0301\u0000\u03b1\u0314\u0301\u0000\u03b1\u0313\u0342\u0000\u03b1\u0314\u0342\u0000\u0391\u0313\u0000\u0391\u0314\u0000\u0391\u0313\u0300\u0000\u0391\u0314\u0300\u0000\u0391\u0313\u0301\u0000\u0391\u0314\u0301\u0000\u0391\u0313\u0342\u0000\u0391\u0314\u0342\u0000\u03b5\u0313\u0000\u03b5\u0314\u0000\u03b5\u0313\u0300\u0000\u03b5\u0314\u0300\u0000\u03b5\u0313\u0301\u0000\u03b5\u0314\u0301\u0000\u0395\u0313\u0000\u0395\u0314\u0000\u0395\u0313\u0300\u0000\u0395\u0314\u0300\u0000\u0395\u0313\u0301\u0000\u0395\u0314\u0301\u0000\u03b7\u0313\u0000\u03b7\u0314\u0000\u03b7\u0313\u0300\u0000\u03b7\u0314\u0300\u0000\u03b7\u0313\u0301\u0000\u03b7\u0314\u0301\u0000\u03b7\u0313\u0342\u0000\u03b7\u0314\u0342\u0000\u0397\u0313\u0000\u0397\u0314\u0000\u0397\u0313\u0300\u0000\u0397\u0314\u0300\u0000\u0397\u0313\u0301\u0000\u0397\u0314\u0301\u0000\u0397\u0313\u0342\u0000\u0397\u0314\u0342\u0000\u03b9\u0313\u0000\u03b9\u0314\u0000\u03b9\u0313\u0300\u0000\u03b9\u0314\u0300\u0000\u03b9\u0313\u0301\u0000\u03b9\u0314\u0301\u0000\u03b9\u0313\u0342\u0000\u03b9\u0314\u0342\u0000\u0399\u0313\u0000\u0399\u0314\u0000\u0399\u0313\u0300\u0000\u0399\u0314\u0300\u0000\u0399\u0313\u0301\u0000\u0399\u0314\u0301\u0000\u0399\u0313\u0342\u0000\u0399\u0314\u0342\u0000\u03bf\u0313\u0000\u03bf\u0314\u0000\u03bf\u0313\u0300\u0000\u03bf\u0314\u0300\u0000\u03bf\u0313\u0301\u0000\u03bf\u0314\u0301\u0000\u039f\u0313\u0000\u039f\u0314\u0000\u039f\u0313\u0300\u0000\u039f\u0314\u0300\u0000\u039f\u0313\u0301\u0000\u039f\u0314\u0301\u0000\u03c5\u0313\u0000\u03c5\u0314\u0000\u03c5\u0313\u0300\u0000\u03c5\u0314\u0300\u0000\u03c5\u0313\u0301\u0000\u03c5\u0314\u0301\u0000\u03c5\u0313\u0342\u0000\u03c5\u0314\u0342\u0000\u03a5\u0314\u0000\u03a5\u0314\u0300\u0000\u03a5\u0314\u0301\u0000\u03a5\u0314\u0342\u0000\u03c9\u0313\u0000\u03c9\u0314\u0000\u03c9\u0313\u0300\u0000\u03c9\u0314\u0300\u0000\u03c9\u0313\u0301\u0000\u03c9\u0314\u0301\u0000\u03c9\u0313\u0342\u0000\u03c9\u0314\u0342\u0000\u03a9\u0313\u0000\u03a9\u0314\u0000\u03a9\u0313\u0300\u0000\u03a9\u0314\u0300\u0000\u03a9\u0313\u0301\u0000\u03a9\u0314\u0301\u0000\u03a9\u0313\u0342\u0000\u03a9\u0314\u0342\u0000\u03b1\u0300\u0000\u03b1\u0301\u0000\u03b5\u0300\u0000\u03b5\u0301\u0000\u03b7\u0300\u0000\u03b7\u0301\u0000\u03b9\u0300\u0000\u03b9\u0301\u0000\u03bf\u0300\u0000\u03bf\u0301\u0000\u03c5\u0300\u0000\u03c5\u0301\u0000\u03c9\u0300\u0000\u03c9\u0301\u0000\u03b1\u0313\u0345\u0000\u03b1\u0314\u0345\u0000\u03b1\u0300\u0313\u0345\u0000\u03b1\u0300\u0314\u0345\u0000\u03b1\u0301\u0313\u0345\u0000\u03b1\u0301\u0314\u0345\u0000\u03b1\u0342\u0313\u0345\u0000\u03b1\u0342\u0314\u0345\u0000\u0391\u0313\u0345\u0000\u0391\u0314\u0345\u0000\u0391\u0300\u0313\u0345\u0000\u0391\u0300\u0314\u0345\u0000\u0391\u0301\u0313\u0345\u0000\u0391\u0301\u0314\u0345\u0000\u0391\u0342\u0313\u0345\u0000\u0391\u0342\u0314\u0345\u0000\u03b7\u0313\u0345\u0000\u03b7\u0314\u0345\u0000\u03b7\u0300\u0313\u0345\u0000\u03b7\u0300\u0314\u0345\u0000\u03b7\u0301\u0313\u0345\u0000\u03b7\u0301\u0314\u0345\u0000\u03b7\u0342\u0313\u0345\u0000\u03b7\u0342\u0314\u0345\u0000\u0397\u0313\u0345\u0000\u0397\u0314\u0345\u0000\u0397\u0300\u0313\u0345\u0000\u0397\u0300\u0314\u0345\u0000\u0397\u0301\u0313\u0345\u0000\u0397\u0301\u0314\u0345\u0000\u0397\u0342\u0313\u0345\u0000\u0397\u0342\u0314\u0345\u0000\u03c9\u0313\u0345\u0000\u03c9\u0314\u0345\u0000\u03c9\u0300\u0313\u0345\u0000\u03c9\u0300\u0314\u0345\u0000\u03c9\u0301\u0313\u0345\u0000\u03c9\u0301\u0314\u0345\u0000\u03c9\u0342\u0313\u0345\u0000\u03c9\u0342\u0314\u0345\u0000\u03a9\u0313\u0345\u0000\u03a9\u0314\u0345\u0000\u03a9\u0300\u0313\u0345\u0000\u03a9\u0300\u0314\u0345\u0000\u03a9\u0301\u0313\u0345\u0000\u03a9\u0301\u0314\u0345\u0000\u03a9\u0342\u0313\u0345\u0000\u03a9\u0342\u0314\u0345\u0000\u03b1\u0306\u0000\u03b1\u0304\u0000\u03b1\u0300\u0345\u0000\u03b1\u0345\u0000\u03b1\u0301\u0345\u0000\u03b1\u0342\u0000\u03b1\u0342\u0345\u0000\u0391\u0306\u0000\u0391\u0304\u0000\u0391\u0300\u0000\u0391\u0301\u0000\u0391\u0345\u0000\u0399\u0000\u00a8\u0342\u0000\u03b7\u0300\u0345\u0000\u03b7\u0345\u0000\u03b7\u0301\u0345\u0000\u03b7\u0342\u0000\u03b7\u0342\u0345\u0000\u0395\u0300\u0000\u0395\u0301\u0000\u0397\u0300\u0000\u0397\u0301\u0000\u0397\u0345\u0000\u1fbf\u0300\u0000\u1fbf\u0301\u0000\u1fbf\u0342\u0000\u03b9\u0306\u0000\u03b9\u0304\u0000\u03b9\u0308\u0300\u0000\u03b9\u0308\u0301\u0000\u03b9\u0342\u0000\u03b9\u0308\u0342\u0000\u0399\u0306\u0000\u0399\u0304\u0000\u0399\u0300\u0000\u0399\u0301\u0000\u1ffe\u0300\u0000\u1ffe\u0301\u0000\u1ffe\u0342\u0000\u03c5\u0306\u0000\u03c5\u0304\u0000\u03c5\u0308\u0300\u0000\u03c5\u0308\u0301\u0000\u03c1\u0313\u0000\u03c1\u0314\u0000\u03c5\u0342\u0000\u03c5\u0308\u0342\u0000\u03a5\u0306\u0000\u03a5\u0304\u0000\u03a5\u0300\u0000\u03a5\u0301\u0000\u03a1\u0314\u0000\u00a8\u0300\u0000\u00a8\u0301\u0000\u03c9\u0300\u0345\u0000\u03c9\u0345\u0000\u03bf\u0301\u0345\u0000\u03c9\u0342\u0000\u03c9\u0342\u0345\u0000\u039f\u0300\u0000\u039f\u0301\u0000\u03a9\u0300\u0000\u03a9\u0301\u0000\u03a9\u0345\u0000\u00b4\u0000\u2002\u0000\u2003\u0000\u03a9\u0000K\u0000A\u030a\u0000\u2203\u0338\u0000\u2208\u0338\u0000\u220b\u0338\u0000\u2223\u0338\u0000\u2225\u0338\u0000\u2243\u0338\u0000\u2245\u0338\u0000\u2248\u0338\u0000\u2261\u0338\u0000\u224d\u0338\u0000\u2264\u0338\u0000\u2265\u0338\u0000\u2272\u0338\u0000\u2273\u0338\u0000\u2276\u0338\u0000\u2277\u0338\u0000\u227a\u0338\u0000\u227b\u0338\u0000\u2282\u0338\u0000\u2283\u0338\u0000\u2286\u0338\u0000\u2287\u0338\u0000\u22a2\u0338\u0000\u22a8\u0338\u0000\u22a9\u0338\u0000\u22ab\u0338\u0000\u227c\u0338\u0000\u227d\u0338\u0000\u2291\u0338\u0000\u2292\u0338\u0000\u22b2\u0338\u0000\u22b3\u0338\u0000\u22b4\u0338\u0000\u22b5\u0338\u0000\u3008\u0000\u3009\u0000\u304b\u3099\u0000\u304d\u3099\u0000\u304f\u3099\u0000\u3051\u3099\u0000\u3053\u3099\u0000\u3055\u3099\u0000\u3057\u3099\u0000\u3059\u3099\u0000\u305b\u3099\u0000\u305d\u3099\u0000\u305f\u3099\u0000\u3061\u3099\u0000\u3064\u3099\u0000\u3066\u3099\u0000\u3068\u3099\u0000\u306f\u3099\u0000\u306f\u309a\u0000\u3072\u3099\u0000\u3072\u309a\u0000\u3075\u3099\u0000\u3075\u309a\u0000\u3078\u3099\u0000\u3078\u309a\u0000\u307b\u3099\u0000\u307b\u309a\u0000\u3046\u3099\u0000\u309d\u3099\u0000\u30ab\u3099\u0000\u30ad\u3099\u0000\u30af\u3099\u0000\u30b1\u3099\u0000\u30b3\u3099\u0000\u30b5\u3099\u0000\u30b7\u3099\u0000\u30b9\u3099\u0000\u30bb\u3099\u0000\u30bd\u3099\u0000\u30bf\u3099\u0000\u30c1\u3099\u0000\u30c4\u3099\u0000\u30c6\u3099\u0000\u30c8\u3099\u0000\u30cf\u3099\u0000\u30cf\u309a\u0000\u30d2\u3099\u0000\u30d2\u309a\u0000\u30d5\u3099\u0000\u30d5\u309a\u0000\u30d8\u3099\u0000\u30d8\u309a\u0000\u30db\u3099\u0000\u30db\u309a\u0000\u30a6\u3099\u0000\u30ef\u3099\u0000\u30f0\u3099\u0000\u30f1\u3099\u0000\u30f2\u3099\u0000\u30fd\u3099\u0000\u05e9\u05c1\u0000\u05e9\u05c2\u0000\u05e9\u05bc\u05c1\u0000\u05e9\u05bc\u05c2\u0000\u05d0\u05b7\u0000\u05d0\u05b8\u0000\u05d0\u05bc\u0000\u05d1\u05bc\u0000\u05d2\u05bc\u0000\u05d3\u05bc\u0000\u05d4\u05bc\u0000\u05d5\u05bc\u0000\u05d6\u05bc\u0000\u05d8\u05bc\u0000\u05d9\u05bc\u0000\u05da\u05bc\u0000\u05db\u05bc\u0000\u05dc\u05bc\u0000\u05de\u05bc\u0000\u05e0\u05bc\u0000\u05e1\u05bc\u0000\u05e3\u05bc\u0000\u05e4\u05bc\u0000\u05e6\u05bc\u0000\u05e7\u05bc\u0000\u05e8\u05bc\u0000\u05e9\u05bc\u0000\u05ea\u05bc\u0000\u05d5\u05b9\u0000\u05d1\u05bf\u0000\u05db\u05bf\u0000\u05e4\u05bf\u0000 \u0302\u0000 \u0332\u0000 \u0300\u0000 \u0000 \u0308\u0000a\u0000 \u0304\u00002\u00003\u0000 \u0301\u0000\u03bc\u0000 \u0327\u00001\u0000o\u00001\u20444\u00001\u20442\u00003\u20444\u0000IJ\u0000ij\u0000L\u00b7\u0000l\u00b7\u0000\u02bcn\u0000s\u0000DZ\u030c\u0000Dz\u030c\u0000dz\u030c\u0000LJ\u0000Lj\u0000lj\u0000NJ\u0000Nj\u0000nj\u0000DZ\u0000Dz\u0000dz\u0000h\u0000\u0266\u0000j\u0000r\u0000\u0279\u0000\u027b\u0000\u0281\u0000w\u0000y\u0000 \u0306\u0000 \u0307\u0000 \u030a\u0000 \u0328\u0000 \u0303\u0000 \u030b\u0000\u0263\u0000l\u0000s\u0000x\u0000\u0295\u0000 \u0345\u0000 \u030d\u0000 \u0308\u030d\u0000\u0565\u0582\u0000\u0eab\u0e99\u0000\u0eab\u0ea1\u0000\u1100\u1100\u0000\u1103\u1103\u0000\u1107\u1107\u0000\u1109\u1109\u0000\u110c\u110c\u0000\u1102\u1100\u0000\u1102\u1102\u0000\u1102\u1103\u0000\u1102\u1107\u0000\u1103\u1100\u0000\u1105\u1102\u0000\u1105\u1105\u0000\u1105\u1112\u0000\u1105\u110b\u0000\u1106\u1107\u0000\u1106\u110b\u0000\u1107\u1100\u0000\u1107\u1102\u0000\u1107\u1103\u0000\u1107\u1109\u0000\u1107\u1109\u1100\u0000\u1107\u1109\u1103\u0000\u1107\u1109\u1107\u0000\u1107\u1109\u1109\u0000\u1107\u1109\u110c\u0000\u1107\u110c\u0000\u1107\u110e\u0000\u1107\u1110\u0000\u1107\u1111\u0000\u1107\u110b\u0000\u1107\u1107\u110b\u0000\u1109\u1100\u0000\u1109\u1102\u0000\u1109\u1103\u0000\u1109\u1105\u0000\u1109\u1106\u0000\u1109\u1107\u0000\u1109\u1107\u1100\u0000\u1109\u1109\u1109\u0000\u1109\u110b\u0000\u1109\u110c\u0000\u1109\u110e\u0000\u1109\u110f\u0000\u1109\u1110\u0000\u1109\u1111\u0000\u1109\u1112\u0000\u113c\u113c\u0000\u113e\u113e\u0000\u110b\u1100\u0000\u110b\u1103\u0000\u110b\u1106\u0000\u110b\u1107\u0000\u110b\u1109\u0000\u110b\u1140\u0000\u110b\u110b\u0000\u110b\u110c\u0000\u110b\u110e\u0000\u110b\u1110\u0000\u110b\u1111\u0000\u110c\u110b\u0000\u114e\u114e\u0000\u1150\u1150\u0000\u110e\u110f\u0000\u110e\u1112\u0000\u1111\u1107\u0000\u1111\u110b\u0000\u1112\u1112\u0000\u1161\u1175\u0000\u1163\u1175\u0000\u1165\u1175\u0000\u1167\u1175\u0000\u1169\u1161\u0000\u1169\u1161\u1175\u0000\u1169\u1175\u0000\u116e\u1165\u0000\u116e\u1165\u1175\u0000\u116e\u1175\u0000\u1173\u1175\u0000\u1161\u1169\u0000\u1161\u116e\u0000\u1163\u1169\u0000\u1163\u116d\u0000\u1165\u1169\u0000\u1165\u116e\u0000\u1165\u1173\u0000\u1167\u1169\u0000\u1167\u116e\u0000\u1169\u1165\u0000\u1169\u1165\u1175\u0000\u1169\u1167\u1175\u0000\u1169\u1169\u0000\u1169\u116e\u0000\u116d\u1163\u0000\u116d\u1163\u1175\u0000\u116d\u1167\u0000\u116d\u1169\u0000\u116d\u1175\u0000\u116e\u1161\u0000\u116e\u1161\u1175\u0000\u116e\u1165\u1173\u0000\u116e\u1167\u1175\u0000\u116e\u116e\u0000\u1172\u1161\u0000\u1172\u1165\u0000\u1172\u1165\u1175\u0000\u1172\u1167\u0000\u1172\u1167\u1175\u0000\u1172\u116e\u0000\u1172\u1175\u0000\u1173\u116e\u0000\u1173\u1173\u0000\u1173\u1175\u116e\u0000\u1175\u1161\u0000\u1175\u1163\u0000\u1175\u1169\u0000\u1175\u116e\u0000\u1175\u1173\u0000\u1175\u119e\u0000\u119e\u1165\u0000\u119e\u116e\u0000\u119e\u1175\u0000\u119e\u119e\u0000\u11a8\u11a8\u0000\u11a8\u11ba\u0000\u11ab\u11bd\u0000\u11ab\u11c2\u0000\u11af\u11a8\u0000\u11af\u11b7\u0000\u11af\u11b8\u0000\u11af\u11ba\u0000\u11af\u11c0\u0000\u11af\u11c1\u0000\u11af\u11c2\u0000\u11b8\u11ba\u0000\u11ba\u11ba\u0000\u11a8\u11af\u0000\u11a8\u11ba\u11a8\u0000\u11ab\u11a8\u0000\u11ab\u11ae\u0000\u11ab\u11ba\u0000\u11ab\u11eb\u0000\u11ab\u11c0\u0000\u11ae\u11a8\u0000\u11ae\u11af\u0000\u11af\u11a8\u11ba\u0000\u11af\u11ab\u0000\u11af\u11ae\u0000\u11af\u11ae\u11c2\u0000\u11af\u11af\u0000\u11af\u11b7\u11a8\u0000\u11af\u11b7\u11ba\u0000\u11af\u11b8\u11ba\u0000\u11af\u11b8\u11c2\u0000\u11af\u11b8\u11bc\u0000\u11af\u11ba\u11ba\u0000\u11af\u11eb\u0000\u11af\u11bf\u0000\u11af\u11f9\u0000\u11b7\u11a8\u0000\u11b7\u11af\u0000\u11b7\u11b8\u0000\u11b7\u11ba\u0000\u11b7\u11ba\u11ba\u0000\u11b7\u11eb\u0000\u11b7\u11be\u0000\u11b7\u11c2\u0000\u11b7\u11bc\u0000\u11b8\u11af\u0000\u11b8\u11c1\u0000\u11b8\u11c2\u0000\u11b8\u11bc\u0000\u11ba\u11a8\u0000\u11ba\u11ae\u0000\u11ba\u11af\u0000\u11ba\u11b8\u0000\u11bc\u11a8\u0000\u11bc\u11a8\u11a8\u0000\u11bc\u11bc\u0000\u11bc\u11bf\u0000\u11f0\u11ba\u0000\u11f0\u11eb\u0000\u11c1\u11b8\u0000\u11c1\u11bc\u0000\u11c2\u11ab\u0000\u11c2\u11af\u0000\u11c2\u11b7\u0000\u11c2\u11b8\u0000s\u0307\u0000 \u0313\u0000 \u0313\u0000 \u0342\u0000 \u0308\u0342\u0000 \u0313\u0300\u0000 \u0313\u0301\u0000 \u0313\u0342\u0000 \u0314\u0300\u0000 \u0314\u0301\u0000 \u0314\u0342\u0000 \u0308\u0300\u0000 \u0308\u0301\u0000 \u0300\u0000 \u0301\u0000 \u0314\u0000 \u0000 \u0000 \u0000 \u0000 \u0000 \u0000 \u0000 \u0000 \u0000 \u0000 \u0000\u2010\u0000 \u0333\u0000.\u0000..\u0000...\u0000\u2032\u2032\u0000\u2032\u2032\u2032\u0000\u2035\u2035\u0000\u2035\u2035\u2035\u0000!!\u0000 \u0305\u00000\u00004\u00005\u00006\u00007\u00008\u00009\u0000+\u0000\u2212\u0000=\u0000(\u0000)\u0000n\u00000\u00001\u00002\u00003\u00004\u00005\u00006\u00007\u00008\u00009\u0000+\u0000\u2212\u0000=\u0000(\u0000)\u0000Rs\u0000C\u0000\u00b0C\u0000\u0190\u0000\u00b0F\u0000g\u0000H\u0000H\u0000H\u0000h\u0000\u0127\u0000I\u0000I\u0000L\u0000l\u0000N\u0000No\u0000P\u0000P\u0000Q\u0000R\u0000R\u0000R\u0000SM\u0000TEL\u0000TM\u0000Z\u0000Z\u0000B\u0000C\u0000e\u0000E\u0000F\u0000M\u0000o\u0000\u05d0\u0000\u05d1\u0000\u05d2\u0000\u05d3\u00001\u20443\u00002\u20443\u00001\u20445\u00002\u20445\u00003\u20445\u00004\u20445\u00001\u20446\u00005\u20446\u00001\u20448\u00003\u20448\u00005\u20448\u00007\u20448\u00001\u2044\u0000I\u0000II\u0000III\u0000IV\u0000V\u0000VI\u0000VII\u0000VIII\u0000IX\u0000X\u0000XI\u0000XII\u0000L\u0000C\u0000D\u0000M\u0000i\u0000ii\u0000iii\u0000iv\u0000v\u0000vi\u0000vii\u0000viii\u0000ix\u0000x\u0000xi\u0000xii\u0000l\u0000c\u0000d\u0000m\u0000\u222b\u222b\u0000\u222b\u222b\u222b\u0000\u222e\u222e\u0000\u222e\u222e\u222e\u00001\u00002\u00003\u00004\u00005\u00006\u00007\u00008\u00009\u00001\u000010\u000012\u000013\u000014\u000015\u000016\u000017\u000018\u000019\u000020\u0000A\u0000B\u0000C\u0000D\u0000E\u0000F\u0000G\u0000H\u0000I\u0000J\u0000K\u0000L\u0000M\u0000N\u0000O\u0000P\u0000Q\u0000R\u0000S\u0000T\u0000U\u0000V\u0000W\u0000X\u0000Y\u0000Z\u0000a\u0000b\u0000c\u0000d\u0000e\u0000f\u0000g\u0000h\u0000i\u0000j\u0000k\u0000l\u0000m\u0000n\u0000o\u0000p\u0000q\u0000r\u0000s\u0000t\u0000u\u0000v\u0000w\u0000x\u0000y\u0000z\u00000\u0000 \u0000\u3012\u0000 \u3099\u0000 \u309a\u0000\u1100\u0000\u1100\u1100\u0000\u11a8\u11ba\u0000\u1102\u0000\u11ab\u11bd\u0000\u11ab\u11c2\u0000\u1103\u0000\u1103\u1103\u0000\u1105\u0000\u11af\u11a8\u0000\u11af\u11b7\u0000\u11af\u11b8\u0000\u11af\u11ba\u0000\u11af\u11c0\u0000\u11af\u11c1\u0000\u1105\u1112\u0000\u1106\u0000\u1107\u0000\u1107\u1107\u0000\u1107\u1109\u0000\u1109\u0000\u1109\u1109\u0000\u110b\u0000\u110c\u0000\u110c\u110c\u0000\u110e\u0000\u110f\u0000\u1110\u0000\u1111\u0000\u1112\u0000\u1161\u0000\u1161\u1175\u0000\u1163\u0000\u1163\u1175\u0000\u1165\u0000\u1165\u1175\u0000\u1167\u0000\u1167\u1175\u0000\u1169\u0000\u1169\u1161\u0000\u1169\u1175\u1161\u0000\u1169\u1175\u0000\u116d\u0000\u116e\u0000\u116e\u1165\u0000\u116e\u1175\u1165\u0000\u116e\u1175\u0000\u1172\u0000\u1173\u0000\u1173\u1175\u0000\u1175\u0000\u1160\u0000\u1102\u1102\u0000\u1102\u1103\u0000\u11ab\u11ba\u0000\u11ab\u11eb\u0000\u11af\u11ba\u11a8\u0000\u11af\u11ae\u0000\u11af\u11ba\u11b8\u0000\u11af\u11eb\u0000\u11af\u11f9\u0000\u1106\u1107\u0000\u11b7\u11ba\u0000\u11b7\u11eb\u0000\u1106\u110b\u0000\u1107\u1100\u0000\u1107\u1103\u0000\u1107\u1100\u1109\u0000\u1107\u1103\u1109\u0000\u1107\u110c\u0000\u1107\u1110\u0000\u1107\u110b\u0000\u1107\u110b\u1107\u0000\u1109\u1100\u0000\u1109\u1102\u0000\u1109\u1103\u0000\u1109\u1107\u0000\u1109\u110c\u0000\u1140\u0000\u110b\u110b\u0000\u114c\u0000\u11f0\u11ba\u0000\u11f0\u11eb\u0000\u1111\u110b\u0000\u1112\u1112\u0000\u1159\u0000\u116d\u1163\u0000\u116d\u1175\u1163\u0000\u116d\u1175\u0000\u1172\u1167\u0000\u1172\u1175\u1167\u0000\u1172\u1175\u0000\u119e\u0000\u119e\u1175\u0000\u4e00\u0000\u4e8c\u0000\u4e09\u0000\u56db\u0000\u4e0a\u0000\u4e2d\u0000\u4e0b\u0000\u7532\u0000\u4e59\u0000\u4e19\u0000\u4e01\u0000\u5929\u0000\u5730\u0000\u4eba\u0000(\u1100)\u0000(\u1102)\u0000(\u1103)\u0000(\u1105)\u0000(\u1106)\u0000(\u1107)\u0000(\u1109)\u0000(\u110b)\u0000(\u110c)\u0000(\u110e)\u0000(\u110f)\u0000(\u1110)\u0000(\u1111)\u0000(\u1112)\u0000(\u1100\u1161)\u0000(\u1102\u1161)\u0000(\u1103\u1161)\u0000(\u1105\u1161)\u0000(\u1106\u1161)\u0000(\u1107\u1161)\u0000(\u1109\u1161)\u0000(\u110b\u1161)\u0000(\u110c\u1161)\u0000(\u110e\u1161)\u0000(\u110f\u1161)\u0000(\u1110\u1161)\u0000(\u1111\u1161)\u0000(\u1112\u1161)\u0000(\u110c\u116e)\u0000(\u4e00)\u0000(\u4e8c)\u0000(\u4e09)\u0000(\u56db)\u0000(\u4e94)\u0000(\u516d)\u0000(\u4e03)\u0000(\u516b)\u0000(\u4e5d)\u0000(\u5341)\u0000(\u6708)\u0000(\u706b)\u0000(\u6c34)\u0000(\u6728)\u0000(\u91d1)\u0000(\u571f)\u0000(\u65e5)\u0000(\u682a)\u0000(\u6709)\u0000(\u793e)\u0000(\u540d)\u0000(\u7279)\u0000(\u8ca1)\u0000(\u795d)\u0000(\u52b4)\u0000(\u4ee3)\u0000(\u547c)\u0000(\u5b66)\u0000(\u76e3)\u0000(\u4f01)\u0000(\u8cc7)\u0000(\u5354)\u0000(\u796d)\u0000(\u4f11)\u0000(\u81ea)\u0000(\u81f3)\u0000\u1100\u0000\u1102\u0000\u1103\u0000\u1105\u0000\u1106\u0000\u1107\u0000\u1109\u0000\u110b\u0000\u110c\u0000\u110e\u0000\u110f\u0000\u1110\u0000\u1111\u0000\u1112\u0000\u1100\u1161\u0000\u1102\u1161\u0000\u1103\u1161\u0000\u1105\u1161\u0000\u1106\u1161\u0000\u1107\u1161\u0000\u1109\u1161\u0000\u110b\u1161\u0000\u110c\u1161\u0000\u110e\u1161\u0000\u110f\u1161\u0000\u1110\u1161\u0000\u1111\u1161\u0000\u1112\u1161\u0000\u4e00\u0000\u4e8c\u0000\u4e09\u0000\u56db\u0000\u4e94\u0000\u516d\u0000\u4e03\u0000\u516b\u0000\u4e5d\u0000\u5341\u0000\u6708\u0000\u706b\u0000\u6c34\u0000\u6728\u0000\u91d1\u0000\u571f\u0000\u65e5\u0000\u682a\u0000\u6709\u0000\u793e\u0000\u540d\u0000\u7279\u0000\u8ca1\u0000\u795d\u0000\u52b4\u0000\u79d8\u0000\u7537\u0000\u5973\u0000\u9069\u0000\u512a\u0000\u5370\u0000\u6ce8\u0000\u9805\u0000\u4f11\u0000\u5199\u0000\u6b63\u0000\u4e0a\u0000\u4e2d\u0000\u4e0b\u0000\u5de6\u0000\u53f3\u0000\u533b\u0000\u5b97\u0000\u5b66\u0000\u76e3\u0000\u4f01\u0000\u8cc7\u0000\u5354\u0000\u591c\u00001\u6708\u00002\u6708\u00003\u6708\u00004\u6708\u00005\u6708\u00006\u6708\u00007\u6708\u00008\u6708\u00009\u6708\u000010\u6708\u000011\u6708\u000012\u6708\u0000\u30a2\u0000\u30a4\u0000\u30a6\u0000\u30a8\u0000\u30aa\u0000\u30ab\u0000\u30ad\u0000\u30af\u0000\u30b1\u0000\u30b3\u0000\u30b5\u0000\u30b7\u0000\u30b9\u0000\u30bb\u0000\u30bd\u0000\u30bf\u0000\u30c1\u0000\u30c4\u0000\u30c6\u0000\u30c8\u0000\u30ca\u0000\u30cb\u0000\u30cc\u0000\u30cd\u0000\u30ce\u0000\u30cf\u0000\u30d2\u0000\u30d5\u0000\u30d8\u0000\u30db\u0000\u30de\u0000\u30df\u0000\u30e0\u0000\u30e1\u0000\u30e2\u0000\u30e4\u0000\u30e6\u0000\u30e8\u0000\u30e9\u0000\u30ea\u0000\u30eb\u0000\u30ec\u0000\u30ed\u0000\u30ef\u0000\u30f0\u0000\u30f1\u0000\u30f2\u0000\u30a2\u30cf\u309a\u30fc\u30c8\u0000\u30a2\u30eb\u30d5\u30a1\u0000\u30a2\u30f3\u30d8\u309a\u30a2\u0000\u30a2\u30fc\u30eb\u0000\u30a4\u30cb\u30f3\u30af\u3099\u0000\u30a4\u30f3\u30c1\u0000\u30a6\u30a9\u30f3\u0000\u30a8\u30b9\u30af\u30fc\u30c8\u3099\u0000\u30a8\u30fc\u30ab\u30fc\u0000\u30aa\u30f3\u30b9\u0000\u30aa\u30fc\u30e0\u0000\u30ab\u30a4\u30ea\u0000\u30ab\u30e9\u30c3\u30c8\u0000\u30ab\u30ed\u30ea\u30fc\u0000\u30ab\u3099\u30ed\u30f3\u0000\u30ab\u3099\u30f3\u30de\u0000\u30ad\u3099\u30ab\u3099\u0000\u30ad\u3099\u30cb\u30fc\u0000\u30ad\u30e5\u30ea\u30fc\u0000\u30ad\u3099\u30eb\u30bf\u3099\u30fc\u0000\u30ad\u30ed\u0000\u30ad\u30ed\u30af\u3099\u30e9\u30e0\u0000\u30ad\u30ed\u30e1\u30fc\u30c8\u30eb\u0000\u30ad\u30ed\u30ef\u30c3\u30c8\u0000\u30af\u3099\u30e9\u30e0\u0000\u30af\u3099\u30e9\u30e0\u30c8\u30f3\u0000\u30af\u30eb\u30bb\u3099\u30a4\u30ed\u0000\u30af\u30ed\u30fc\u30cd\u0000\u30b1\u30fc\u30b9\u0000\u30b3\u30eb\u30ca\u0000\u30b3\u30fc\u30db\u309a\u0000\u30b5\u30a4\u30af\u30eb\u0000\u30b5\u30f3\u30c1\u30fc\u30e0\u0000\u30b7\u30ea\u30f3\u30af\u3099\u0000\u30bb\u30f3\u30c1\u0000\u30bb\u30f3\u30c8\u0000\u30bf\u3099\u30fc\u30b9\u0000\u30c6\u3099\u30b7\u0000\u30c8\u3099\u30eb\u0000\u30c8\u30f3\u0000\u30ca\u30ce\u0000\u30ce\u30c3\u30c8\u0000\u30cf\u30a4\u30c4\u0000\u30cf\u309a\u30fc\u30bb\u30f3\u30c8\u0000\u30cf\u309a\u30fc\u30c4\u0000\u30cf\u3099\u30fc\u30ec\u30eb\u0000\u30d2\u309a\u30a2\u30b9\u30c8\u30eb\u0000\u30d2\u309a\u30af\u30eb\u0000\u30d2\u309a\u30b3\u0000\u30d2\u3099\u30eb\u0000\u30d5\u30a1\u30e9\u30c3\u30c8\u3099\u0000\u30d5\u30a3\u30fc\u30c8\u0000\u30d5\u3099\u30c3\u30b7\u30a7\u30eb\u0000\u30d5\u30e9\u30f3\u0000\u30d8\u30af\u30bf\u30fc\u30eb\u0000\u30d8\u309a\u30bd\u0000\u30d8\u309a\u30cb\u30d2\u0000\u30d8\u30eb\u30c4\u0000\u30d8\u309a\u30f3\u30b9\u0000\u30d8\u309a\u30fc\u30b7\u3099\u0000\u30d8\u3099\u30fc\u30bf\u0000\u30db\u309a\u30a4\u30f3\u30c8\u0000\u30db\u3099\u30eb\u30c8\u0000\u30db\u30f3\u0000\u30db\u309a\u30f3\u30c8\u3099\u0000\u30db\u30fc\u30eb\u0000\u30db\u30fc\u30f3\u0000\u30de\u30a4\u30af\u30ed\u0000\u30de\u30a4\u30eb\u0000\u30de\u30c3\u30cf\u0000\u30de\u30eb\u30af\u0000\u30de\u30f3\u30b7\u30e7\u30f3\u0000\u30df\u30af\u30ed\u30f3\u0000\u30df\u30ea\u0000\u30df\u30ea\u30cf\u3099\u30fc\u30eb\u0000\u30e1\u30ab\u3099\u0000\u30e1\u30ab\u3099\u30c8\u30f3\u0000\u30e1\u30fc\u30c8\u30eb\u0000\u30e4\u30fc\u30c8\u3099\u0000\u30e4\u30fc\u30eb\u0000\u30e6\u30a2\u30f3\u0000\u30ea\u30c3\u30c8\u30eb\u0000\u30ea\u30e9\u0000\u30eb\u30d2\u309a\u30fc\u0000\u30eb\u30fc\u30d5\u3099\u30eb\u0000\u30ec\u30e0\u0000\u30ec\u30f3\u30c8\u30b1\u3099\u30f3\u0000\u30ef\u30c3\u30c8\u00000\u70b9\u00001\u70b9\u00002\u70b9\u00003\u70b9\u00004\u70b9\u00005\u70b9\u00006\u70b9\u00007\u70b9\u00008\u70b9\u00009\u70b9\u000010\u70b9\u000011\u70b9\u000012\u70b9\u000013\u70b9\u000014\u70b9\u000015\u70b9\u000016\u70b9\u000017\u70b9\u000018\u70b9\u000019\u70b9\u000020\u70b9\u000021\u70b9\u000022\u70b9\u000023\u70b9\u000024\u70b9\u0000hPa\u0000da\u0000AU\u0000bar\u0000oV\u0000pc\u0000\u5e73\u6210\u0000\u662d\u548c\u0000\u5927\u6b63\u0000\u660e\u6cbb\u0000\u682a\u5f0f\u4f1a\u793e\u0000pA\u0000nA\u0000\u03bcA\u0000mA\u0000kA\u0000KB\u0000MB\u0000GB\u0000cal\u0000kcal\u0000pF\u0000nF\u0000\u03bcF\u0000\u03bcg\u0000mg\u0000kg\u0000Hz\u0000kHz\u0000MHz\u0000GHz\u0000THz\u0000\u03bcl\u0000ml\u0000dl\u0000kl\u0000fm\u0000nm\u0000\u03bcm\u0000mm\u0000cm\u0000km\u0000mm2\u0000cm2\u0000m2\u0000km2\u0000mm3\u0000cm3\u0000m3\u0000km3\u0000m\u2215s\u0000m\u2215s2\u0000Pa\u0000kPa\u0000MPa\u0000GPa\u0000rad\u0000rad\u2215s\u0000rad\u2215s2\u0000ps\u0000ns\u0000\u03bcs\u0000ms\u0000pV\u0000nV\u0000\u03bcV\u0000mV\u0000kV\u0000MV\u0000pW\u0000nW\u0000\u03bcW\u0000mW\u0000kW\u0000MW\u0000k\u03a9\u0000M\u03a9\u0000a.m.\u0000Bq\u0000cc\u0000cd\u0000C\u2215kg\u0000Co.\u0000dB\u0000Gy\u0000ha\u0000HP\u0000in\u0000KK\u0000KM\u0000kt\u0000lm\u0000ln\u0000log\u0000lx\u0000mb\u0000mil\u0000mol\u0000PH\u0000p.m.\u0000PPM\u0000PR\u0000sr\u0000Sv\u0000Wb\u00001\u65e5\u00002\u65e5\u00003\u65e5\u00004\u65e5\u00005\u65e5\u00006\u65e5\u00007\u65e5\u00008\u65e5\u00009\u65e5\u000010\u65e5\u000011\u65e5\u000012\u65e5\u000013\u65e5\u000014\u65e5\u000015\u65e5\u000016\u65e5\u000017\u65e5\u000018\u65e5\u000019\u65e5\u000020\u65e5\u000021\u65e5\u000022\u65e5\u000023\u65e5\u000024\u65e5\u000025\u65e5\u000026\u65e5\u000027\u65e5\u000028\u65e5\u000029\u65e5\u000030\u65e5\u000031\u65e5\u0000ff\u0000fi\u0000fl\u0000ffi\u0000ffl\u0000st\u0000st\u0000\u0574\u0576\u0000\u0574\u0565\u0000\u0574\u056b\u0000\u057e\u0576\u0000\u0574\u056d\u0000\u05f2\u05b7\u0000\u05e2\u0000\u05d0\u0000\u05d3\u0000\u05d4\u0000\u05db\u0000\u05dc\u0000\u05dd\u0000\u05e8\u0000\u05ea\u0000+\u0000\u05d0\u05dc\u0000\u0671\u0000\u0671\u0000\u067b\u0000\u067b\u0000\u067b\u0000\u067b\u0000\u067e\u0000\u067e\u0000\u067e\u0000\u067e\u0000\u0680\u0000\u0680\u0000\u0680\u0000\u0680\u0000\u067a\u0000\u067a\u0000\u067a\u0000\u067a\u0000\u067f\u0000\u067f\u0000\u067f\u0000\u067f\u0000\u0679\u0000\u0679\u0000\u0679\u0000\u0679\u0000\u06a4\u0000\u06a4\u0000\u06a4\u0000\u06a4\u0000\u06a6\u0000\u06a6\u0000\u06a6\u0000\u06a6\u0000\u0684\u0000\u0684\u0000\u0684\u0000\u0684\u0000\u0683\u0000\u0683\u0000\u0683\u0000\u0683\u0000\u0686\u0000\u0686\u0000\u0686\u0000\u0686\u0000\u0687\u0000\u0687\u0000\u0687\u0000\u0687\u0000\u068d\u0000\u068d\u0000\u068c\u0000\u068c\u0000\u068e\u0000\u068e\u0000\u0688\u0000\u0688\u0000\u0698\u0000\u0698\u0000\u0691\u0000\u0691\u0000\u06a9\u0000\u06a9\u0000\u06a9\u0000\u06a9\u0000\u06af\u0000\u06af\u0000\u06af\u0000\u06af\u0000\u06b3\u0000\u06b3\u0000\u06b3\u0000\u06b3\u0000\u06b1\u0000\u06b1\u0000\u06b1\u0000\u06b1\u0000\u06ba\u0000\u06ba\u0000\u06bb\u0000\u06bb\u0000\u06bb\u0000\u06bb\u0000\u06c0\u0000\u06c0\u0000\u06c1\u0000\u06c1\u0000\u06c1\u0000\u06c1\u0000\u06be\u0000\u06be\u0000\u06be\u0000\u06be\u0000\u06d2\u0000\u06d2\u0000\u06d3\u0000\u06d3\u0000\u06ad\u0000\u06ad\u0000\u06ad\u0000\u06ad\u0000\u06c7\u0000\u06c7\u0000\u06c6\u0000\u06c6\u0000\u06c8\u0000\u06c8\u0000\u0677\u0000\u06cb\u0000\u06cb\u0000\u06c5\u0000\u06c5\u0000\u06c9\u0000\u06c9\u0000\u06d0\u0000\u06d0\u0000\u06d0\u0000\u06d0\u0000\u06cc\u0000\u06cc\u0000\u06cc\u0000\u06cc\u0000..\u0000\u2014\u0000\u2013\u0000 \u0332\u0000 \u0332\u0000(\u0000)\u0000{\u0000}\u0000\u3014\u0000\u3015\u0000\u3010\u0000\u3011\u0000\u300a\u0000\u300b\u0000\u3008\u0000\u3009\u0000\u300c\u0000\u300d\u0000\u300e\u0000\u300f\u0000 \u0305\u0000 \u0305\u0000 \u0305\u0000 \u0305\u0000 \u0332\u0000 \u0332\u0000 \u0332\u0000,\u0000\u3001\u0000.\u0000;\u0000:\u0000?\u0000!\u0000\u2014\u0000(\u0000)\u0000{\u0000}\u0000\u3014\u0000\u3015\u0000#\u0000&\u0000*\u0000+\u0000-\u0000<\u0000>\u0000=\u0000\\\u0000$\u0000%\u0000@\u0000 \u064b\u0000\u0640\u064b\u0000 \u064c\u0000 \u064d\u0000 \u064e\u0000\u0640\u064e\u0000 \u064f\u0000\u0640\u064f\u0000 \u0650\u0000\u0640\u0650\u0000 \u0651\u0000\u0640\u0651\u0000 \u0652\u0000\u0640\u0652\u0000\u0621\u0000\u0622\u0000\u0622\u0000\u0623\u0000\u0623\u0000\u0624\u0000\u0624\u0000\u0625\u0000\u0625\u0000\u0626\u0000\u0626\u0000\u0626\u0000\u0626\u0000\u0627\u0000\u0627\u0000\u0628\u0000\u0628\u0000\u0628\u0000\u0628\u0000\u0629\u0000\u0629\u0000\u062a\u0000\u062a\u0000\u062a\u0000\u062a\u0000\u062b\u0000\u062b\u0000\u062b\u0000\u062b\u0000\u062c\u0000\u062c\u0000\u062c\u0000\u062c\u0000\u062d\u0000\u062d\u0000\u062d\u0000\u062d\u0000\u062e\u0000\u062e\u0000\u062e\u0000\u062e\u0000\u062f\u0000\u062f\u0000\u0630\u0000\u0630\u0000\u0631\u0000\u0631\u0000\u0632\u0000\u0632\u0000\u0633\u0000\u0633\u0000\u0633\u0000\u0633\u0000\u0634\u0000\u0634\u0000\u0634\u0000\u0634\u0000\u0635\u0000\u0635\u0000\u0635\u0000\u0635\u0000\u0636\u0000\u0636\u0000\u0636\u0000\u0636\u0000\u0637\u0000\u0637\u0000\u0637\u0000\u0637\u0000\u0638\u0000\u0638\u0000\u0638\u0000\u0638\u0000\u0639\u0000\u0639\u0000\u0639\u0000\u0639\u0000\u063a\u0000\u063a\u0000\u063a\u0000\u063a\u0000\u0641\u0000\u0641\u0000\u0641\u0000\u0641\u0000\u0642\u0000\u0642\u0000\u0642\u0000\u0642\u0000\u0643\u0000\u0643\u0000\u0643\u0000\u0643\u0000\u0644\u0000\u0644\u0000\u0644\u0000\u0644\u0000\u0645\u0000\u0645\u0000\u0645\u0000\u0645\u0000\u0646\u0000\u0646\u0000\u0646\u0000\u0646\u0000\u0647\u0000\u0647\u0000\u0647\u0000\u0647\u0000\u0648\u0000\u0648\u0000\u0649\u0000\u0649\u0000\u064a\u0000\u064a\u0000\u064a\u0000\u064a\u0000!\u0000\"\u0000#\u0000$\u0000%\u0000&\u0000'\u0000(\u0000)\u0000*\u0000+\u0000,\u0000-\u0000.\u0000/\u00000\u00001\u00002\u00003\u00004\u00005\u00006\u00007\u00008\u00009\u0000:\u0000;\u0000<\u0000=\u0000>\u0000?\u0000@\u0000A\u0000B\u0000C\u0000D\u0000E\u0000F\u0000G\u0000H\u0000I\u0000J\u0000K\u0000L\u0000M\u0000N\u0000O\u0000P\u0000Q\u0000R\u0000S\u0000T\u0000U\u0000V\u0000W\u0000X\u0000Y\u0000Z\u0000[\u0000\\\u0000]\u0000 \u0302\u0000 \u0332\u0000 \u0300\u0000a\u0000b\u0000c\u0000d\u0000e\u0000f\u0000g\u0000h\u0000i\u0000j\u0000k\u0000l\u0000m\u0000n\u0000o\u0000p\u0000q\u0000r\u0000s\u0000t\u0000u\u0000v\u0000w\u0000x\u0000y\u0000z\u0000{\u0000|\u0000}\u0000~\u0000\u3002\u0000\u300c\u0000\u300d\u0000\u3001\u0000\u30fb\u0000\u30f2\u0000\u30a1\u0000\u30a3\u0000\u30a5\u0000\u30a7\u0000\u30a9\u0000\u30e3\u0000\u30e5\u0000\u30e7\u0000\u30c3\u0000\u30fc\u0000\u30a2\u0000\u30a4\u0000\u30a6\u0000\u30a8\u0000\u30aa\u0000\u30ab\u0000\u30ad\u0000\u30af\u0000\u30b1\u0000\u30b3\u0000\u30b5\u0000\u30b7\u0000\u30b9\u0000\u30bb\u0000\u30bd\u0000\u30bf\u0000\u30c1\u0000\u30c4\u0000\u30c6\u0000\u30c8\u0000\u30ca\u0000\u30cb\u0000\u30cc\u0000\u30cd\u0000\u30ce\u0000\u30cf\u0000\u30d2\u0000\u30d5\u0000\u30d8\u0000\u30db\u0000\u30de\u0000\u30df\u0000\u30e0\u0000\u30e1\u0000\u30e2\u0000\u30e4\u0000\u30e6\u0000\u30e8\u0000\u30e9\u0000\u30ea\u0000\u30eb\u0000\u30ec\u0000\u30ed\u0000\u30ef\u0000\u30f3\u0000 \u3099\u0000 \u309a\u0000\u1160\u0000\u1100\u0000\u1100\u1100\u0000\u11a8\u11ba\u0000\u1102\u0000\u11ab\u11bd\u0000\u11ab\u11c2\u0000\u1103\u0000\u1103\u1103\u0000\u1105\u0000\u11af\u11a8\u0000\u11af\u11b7\u0000\u11af\u11b8\u0000\u11af\u11ba\u0000\u11af\u11c0\u0000\u11af\u11c1\u0000\u1105\u1112\u0000\u1106\u0000\u1107\u0000\u1107\u1107\u0000\u1107\u1109\u0000\u1109\u0000\u1109\u1109\u0000\u110b\u0000\u110c\u0000\u110c\u110c\u0000\u110e\u0000\u110f\u0000\u1110\u0000\u1111\u0000\u1112\u0000\u1161\u0000\u1161\u1175\u0000\u1163\u0000\u1163\u1175\u0000\u1165\u0000\u1165\u1175\u0000\u1167\u0000\u1167\u1175\u0000\u1169\u0000\u1169\u1161\u0000\u1169\u1161\u1175\u0000\u1169\u1175\u0000\u116d\u0000\u116e\u0000\u116e\u1165\u0000\u116e\u1165\u1175\u0000\u116e\u1175\u0000\u1172\u0000\u1173\u0000\u1173\u1175\u0000\u1175\u0000\u00a2\u0000\u00a3\u0000\u00ac\u0000 \u0304\u0000\u00a6\u0000\u00a5\u0000\u20a9\u0000\u2502\u0000\u2190\u0000\u2191\u0000\u2192\u0000\u2193\u0000\u25a0\u0000\u25cb\u0000Fr\u0000";
    private static int maximumDecomposition = 7589;
    private static int maximumCanonical = 3200;
    private static final CompactShortArray startOffsets = new CompactShortArray(kOffsetIndex, kOffsetValues, Short.MAX_VALUE);
    private static final byte BASE = -128;
    private static final CompactByteArray canonicals = new CompactByteArray(kCanonicalIndex, kCanonicalValues);
    private static IntHashtable composeMapping = new IntHashtable(1000);
    private static char minimumCombining = (char)65535;

    Normalizer(String string, int n) {
        this(new StringCharacterIterator(string), n);
        this.ownIterator = true;
    }

    Normalizer(CharacterIterator characterIterator, int n) {
        this.str = characterIterator;
        this.ownIterator = false;
        this.decmpMode = n;
        this.decmpLimit = n == 1 ? maximumCanonical : Short.MAX_VALUE;
        this.parsedStr = null;
        this.pIndex = 0;
    }

    public Object clone() {
        Normalizer normalizer = null;
        try {
            normalizer = (Normalizer)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        normalizer.str = (CharacterIterator)this.str.clone();
        if (this.parsedStr != null) {
            normalizer.parsedStr = new StringBuffer(this.parsedStr.toString());
        }
        return normalizer;
    }

    void setDecomposition(int n) {
        this.decmpMode = n;
    }

    int getDecomposition() {
        return this.decmpMode;
    }

    void setText(String string) {
        if (this.ownIterator) {
            StringCharacterIterator stringCharacterIterator = (StringCharacterIterator)this.str;
            stringCharacterIterator.setText(string);
        } else {
            this.str = new StringCharacterIterator(string);
            this.ownIterator = true;
        }
        this.reset();
    }

    void setText(CharacterIterator characterIterator) {
        this.str = characterIterator;
        this.ownIterator = false;
        this.reset();
    }

    CharacterIterator getText() {
        return this.str;
    }

    final void setOffset(int n) {
        this.str.setIndex(n);
        this.pLimit = 0;
        this.pIndex = 0;
    }

    final int getOffset() {
        return this.str.getIndex();
    }

    void reset() {
        this.str.first();
        this.pLimit = 0;
        this.pIndex = 0;
    }

    char next() {
        int n = 0;
        int n2 = 65535;
        if (this.decmpMode == 0) {
            n2 = this.str.current();
            this.str.next();
        } else if (this.pIndex < this.pLimit) {
            n2 = this.parsedStr.charAt(++this.pIndex);
        } else if (this.str.getIndex() >= this.str.getEndIndex()) {
            n2 = 65535;
            this.pLimit = 0;
            this.pIndex = 0;
        } else {
            this.pLimit = 0;
            this.pIndex = 0;
            char c = this.str.current();
            this.str.next();
            n = startOffsets.elementAt(c);
            if (n < this.decmpLimit || canonicals.elementAt(c) != -128) {
                this.zapParsedStr();
                if (n < this.decmpLimit) {
                    while ((c = contents.charAt(n++)) != '\u0000') {
                        this.parsedStr.append(c);
                    }
                } else {
                    this.parsedStr.append(c);
                }
                while (this.str.getIndex() < this.str.getEndIndex() && canonicals.elementAt(c = this.str.current()) != -128) {
                    this.parsedStr.append(c);
                    this.str.next();
                }
                if (this.parsedStr.length() > 1) {
                    Normalizer.fixCanonical(this.parsedStr);
                    this.pLimit = this.parsedStr.length() - 1;
                    this.pIndex = 0;
                }
                n2 = this.parsedStr.charAt(0);
            } else if (c >= '\uac00' && c < '\ud7a4') {
                this.zapParsedStr();
                Normalizer.hangulToJamo(c, this.parsedStr);
                if (this.decmpMode >= 2) {
                    Normalizer.decompose(this.parsedStr);
                }
                this.pLimit = this.parsedStr.length() - 1;
                this.pIndex = 0;
                n2 = this.parsedStr.charAt(this.pIndex);
            } else {
                n2 = c;
            }
        }
        return (char)n2;
    }

    private final void zapParsedStr() {
        if (this.parsedStr == null) {
            this.parsedStr = new StringBuffer();
        } else {
            this.parsedStr.setLength(0);
        }
    }

    char previous() {
        char c = '\uffff';
        if (this.pIndex > 0) {
            c = this.parsedStr.charAt(--this.pIndex);
        } else if (this.decmpMode == 0) {
            c = this.str.previous();
        } else if (this.str.getIndex() > this.str.getBeginIndex()) {
            this.pLimit = 0;
            this.pIndex = 0;
            char c2 = this.str.previous();
            int n = startOffsets.elementAt(c2);
            if (n < this.decmpLimit || canonicals.elementAt(c2) != -128) {
                this.zapParsedStr();
                while (c2 != '\uffff' && canonicals.elementAt(c2) != -128) {
                    this.parsedStr.insert(0, c2);
                    c2 = this.str.previous();
                }
                n = startOffsets.elementAt(c2);
                if (n < this.decmpLimit) {
                    int n2 = 0;
                    while ((c2 = contents.charAt(n++)) != '\u0000') {
                        this.parsedStr.insert(n2++, c2);
                    }
                } else {
                    this.str.next();
                }
                if (this.parsedStr.length() > 1) {
                    Normalizer.fixCanonical(this.parsedStr);
                }
                this.pIndex = this.pLimit = this.parsedStr.length() - 1;
                c = this.parsedStr.charAt(this.pIndex);
            } else if (c2 >= '\uac00' && c2 < '\ud7a4') {
                this.zapParsedStr();
                Normalizer.hangulToJamo(c2, this.parsedStr);
                this.pIndex = this.pLimit = this.parsedStr.length() - 1;
                c = this.parsedStr.charAt(this.pIndex);
            } else {
                c = c2;
            }
        }
        return c;
    }

    public static String decompose(String string) {
        return Normalizer.decompose(string, 2);
    }

    public static void decompose(StringBuffer stringBuffer) {
        Normalizer.decompose(stringBuffer, 2);
    }

    public static String compose(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        Normalizer.compose(stringBuffer);
        return stringBuffer.toString();
    }

    /*
     * Unable to fully structure code
     */
    public static void compose(StringBuffer var0) {
        if (var0.length() < 2) {
            return;
        }
        var1_1 = 1;
        var2_2 = 0;
        var3_3 = var0.charAt(var2_2);
        var4_4 = false;
        var5_5 = 1;
        while (var5_5 < var0.length()) {
            block7: {
                block8: {
                    var6_6 = var0.charAt(var5_5);
                    var7_7 = Character.getType(var6_6);
                    if (var7_7 == 6 || var7_7 == 8) break block8;
                    var2_2 = var1_1;
                    var3_3 = var6_6;
                    ** GOTO lbl-1000
                }
                if (var2_2 + 1 < var1_1) {
                    var8_8 = Normalizer.canonicals.elementAt(var6_6);
                    var9_9 = var2_2 + 1;
                    while (var9_9 < var1_1) {
                        if (var8_8 == Normalizer.canonicals.elementAt(var0.charAt(var9_9))) {
                            var0.setCharAt(var1_1++, var6_6);
                            break block7;
                        }
                        ++var9_9;
                    }
                }
                if ((var8_8 = Normalizer.composeMapping.get((var3_3 << 16) + var6_6)) != 0) {
                    var3_3 = (char)var8_8;
                    var0.setCharAt(var2_2, var3_3);
                } else lbl-1000:
                // 2 sources

                {
                    var0.setCharAt(var1_1++, var6_6);
                }
            }
            ++var5_5;
        }
        var0.setLength(var1_1);
        Normalizer.jamoToHangul(var0);
    }

    /*
     * Unable to fully structure code
     */
    static void decompose(StringBuffer var0, int var1_1) {
        if (var1_1 == 0) {
            return;
        }
        var2_2 = var1_1 == 1 ? Normalizer.maximumCanonical : 32767;
        var3_3 = new StringBuffer();
        var4_4 = 0;
        while (var4_4 < var0.length()) {
            block4: {
                block3: {
                    var5_5 = var0.charAt(var4_4);
                    var6_6 = Normalizer.startOffsets.elementAt(var5_5);
                    if (var5_5 < '\uac00' || var5_5 >= '\ud7a4') break block3;
                    Normalizer.hangulToJamo(var5_5, var3_3);
                    break block4;
                }
                if (var6_6 < var2_2) ** GOTO lbl19
                var3_3.append(var5_5);
                break block4;
lbl-1000:
                // 1 sources

                {
                    var3_3.append(var5_5);
lbl19:
                    // 2 sources

                    ** while ((var5_5 = Normalizer.contents.charAt((int)var6_6++)) != '\u0000')
                }
            }
            ++var4_4;
        }
        var0.setLength(0);
        var0.append(var3_3.toString());
    }

    /*
     * Unable to fully structure code
     */
    static String decompose(String var0, int var1_1) {
        if (var1_1 == 0) {
            return var0;
        }
        var2_2 = var1_1 == 1 ? Normalizer.maximumCanonical : 32767;
        var3_3 = new StringBuffer();
        var4_4 = 0;
        while (var4_4 < var0.length()) {
            block4: {
                block3: {
                    var5_5 = var0.charAt(var4_4);
                    var6_6 = Normalizer.startOffsets.elementAt(var5_5);
                    if (var5_5 < '\uac00' || var5_5 >= '\ud7a4') break block3;
                    Normalizer.hangulToJamo(var5_5, var3_3);
                    break block4;
                }
                if (var6_6 < var2_2) ** GOTO lbl19
                var3_3.append(var5_5);
                break block4;
lbl-1000:
                // 1 sources

                {
                    var3_3.append(var5_5);
lbl19:
                    // 2 sources

                    ** while ((var5_5 = Normalizer.contents.charAt((int)var6_6++)) != '\u0000')
                }
            }
            ++var4_4;
        }
        return var3_3.toString();
    }

    static int getMaximumDecomposition() {
        return maximumDecomposition;
    }

    private static void fixCanonical(StringBuffer stringBuffer) {
        int n = stringBuffer.length() - 1;
        byte by = canonicals.elementAt(stringBuffer.charAt(n));
        --n;
        while (n >= 0) {
            byte by2 = by;
            by = canonicals.elementAt(stringBuffer.charAt(n));
            if (by > by2 && by2 != -128) {
                char c = stringBuffer.charAt(n);
                stringBuffer.setCharAt(n, stringBuffer.charAt(n + 1));
                stringBuffer.setCharAt(n + 1, c);
                if (n < stringBuffer.length() - 2) {
                    n += 2;
                }
                by = canonicals.elementAt(stringBuffer.charAt(n));
            }
            --n;
        }
    }

    private static void hangulToJamo(char c, StringBuffer stringBuffer) {
        char c2 = (char)(c - 44032);
        char c3 = (char)(4352 + c2 / 588);
        char c4 = (char)(4449 + c2 % 588 / 28);
        char c5 = (char)(4519 + c2 % 28);
        stringBuffer.append(c3);
        stringBuffer.append(c4);
        if (c5 != '\u11a7') {
            stringBuffer.append(c5);
        }
    }

    private static void jamoToHangul(StringBuffer stringBuffer) {
        int n = 0;
        int n2 = stringBuffer.length() - 1;
        int n3 = 0;
        while (n3 < n2) {
            int n4;
            char c = stringBuffer.charAt(n3);
            int n5 = c - 4352;
            if (n5 >= 0 && n5 < 19 && (n4 = stringBuffer.charAt(n3 + 1) - 4449) >= 0 && n4 < 21) {
                int n6;
                int n7 = n6 = ++n3 < n2 ? (int)stringBuffer.charAt(n3 + 1) : 0;
                if ((n6 -= 4519) >= 0 && n6 < 28) {
                    ++n3;
                } else {
                    n6 = 0;
                }
                stringBuffer.setCharAt(n++, (char)((n5 * 21 + n4) * 28 + n6 + 44032));
            } else {
                stringBuffer.setCharAt(n++, c);
            }
            ++n3;
        }
        while (n3 < stringBuffer.length()) {
            stringBuffer.setCharAt(n++, stringBuffer.charAt(n3++));
        }
        stringBuffer.setLength(n);
    }

    static DecompIterator getDecompositions(int n) {
        return new DecompIterator(n);
    }

    static /* synthetic */ CompactShortArray access$300() {
        return startOffsets;
    }

    static {
        String[] stringArray = new String[]{"\u0300A\u00c0E\u00c8I\u00ccO\u00d2U\u00d9W\u1e80Y\u1ef2a\u00e0e\u00e8i\u00eco\u00f2u\u00f9w\u1e81y\u1ef3\u00a8\u1fed\u00c2\u1ea6\u00ca\u1ec0\u00d4\u1ed2\u00dc\u01db\u00e2\u1ea7\u00ea\u1ec1\u00f4\u1ed3\u00fc\u01dc\u0102\u1eb0\u0103\u1eb1\u0112\u1e14\u0113\u1e15\u014c\u1e50\u014d\u1e51\u01a0\u1edc\u01a1\u1edd\u01af\u1eea\u01b0\u1eeb\u0391\u1fba\u0395\u1fc8\u0397\u1fca\u0399\u1fda\u039f\u1ff8\u03a5\u1fea\u03a9\u1ffa\u03b1\u1f70\u03b5\u1f72\u03b7\u1f74\u03b9\u1f76\u03bf\u1f78\u03c5\u1f7a\u03c9\u1f7c\u03ca\u1fd2\u03cb\u1fe2\u1f00\u1f02\u1f01\u1f03\u1f08\u1f0a\u1f09\u1f0b\u1f10\u1f12\u1f11\u1f13\u1f18\u1f1a\u1f19\u1f1b\u1f20\u1f22\u1f21\u1f23\u1f28\u1f2a\u1f29\u1f2b\u1f30\u1f32\u1f31\u1f33\u1f38\u1f3a\u1f39\u1f3b\u1f40\u1f42\u1f41\u1f43\u1f48\u1f4a\u1f49\u1f4b\u1f50\u1f52\u1f51\u1f53\u1f59\u1f5b\u1f60\u1f62\u1f61\u1f63\u1f68\u1f6a\u1f69\u1f6b\u1fbf\u1fcd\u1ffe\u1fdd", "\u0301A\u00c1C\u0106E\u00c9G\u01f4I\u00cdK\u1e30L\u0139M\u1e3eN\u0143O\u00d3P\u1e54R\u0154S\u015aU\u00daW\u1e82Y\u00ddZ\u0179a\u00e1c\u0107e\u00e9g\u01f5i\u00edk\u1e31l\u013am\u1e3fn\u0144o\u00f3p\u1e55r\u0155s\u015bu\u00faw\u1e83y\u00fdz\u017a\u00a8\u1fee\u00c2\u1ea4\u00c5\u01fa\u00c6\u01fc\u00c7\u1e08\u00ca\u1ebe\u00cf\u1e2e\u00d4\u1ed0\u00d5\u1e4c\u00dc\u01d7\u00e2\u1ea5\u00e5\u01fb\u00e6\u01fd\u00e7\u1e09\u00ea\u1ebf\u00ef\u1e2f\u00f4\u1ed1\u00f5\u1e4d\u00fc\u01d8\u0102\u1eae\u0103\u1eaf\u0112\u1e16\u0113\u1e17\u014c\u1e52\u014d\u1e53\u0168\u1e78\u0169\u1e79\u01a0\u1eda\u01a1\u1edb\u01af\u1ee8\u01b0\u1ee9\u0391\u1fbb\u0395\u1fc9\u0397\u1fcb\u0399\u1fdb\u039f\u1ff9\u03a5\u1feb\u03a9\u1ffb\u03b1\u1f71\u03b5\u1f73\u03b7\u1f75\u03b9\u1f77\u03bf\u1f79\u03c5\u1f7b\u03c9\u1f7d\u03ca\u1fd3\u03cb\u1fe3\u0413\u0403\u041a\u040c\u0433\u0453\u043a\u045c\u1f00\u1f04\u1f01\u1f05\u1f08\u1f0c\u1f09\u1f0d\u1f10\u1f14\u1f11\u1f15\u1f18\u1f1c\u1f19\u1f1d\u1f20\u1f24\u1f21\u1f25\u1f28\u1f2c\u1f29\u1f2d\u1f30\u1f34\u1f31\u1f35\u1f38\u1f3c\u1f39\u1f3d\u1f40\u1f44\u1f41\u1f45\u1f48\u1f4c\u1f49\u1f4d\u1f50\u1f54\u1f51\u1f55\u1f59\u1f5d\u1f60\u1f64\u1f61\u1f65\u1f68\u1f6c\u1f69\u1f6d\u1fbf\u1fce\u1ffe\u1fde", "\u0302A\u00c2C\u0108E\u00caG\u011cH\u0124I\u00ceJ\u0134O\u00d4S\u015cU\u00dbW\u0174Y\u0176Z\u1e90a\u00e2c\u0109e\u00eag\u011dh\u0125i\u00eej\u0135o\u00f4s\u015du\u00fbw\u0175y\u0177z\u1e91\u1ea0\u1eac\u1ea1\u1ead\u1eb8\u1ec6\u1eb9\u1ec7\u1ecc\u1ed8\u1ecd\u1ed9", "\u0303A\u00c3E\u1ebcI\u0128N\u00d1O\u00d5U\u0168V\u1e7cY\u1ef8a\u00e3e\u1ebdi\u0129n\u00f1o\u00f5u\u0169v\u1e7dy\u1ef9\u00c2\u1eaa\u00ca\u1ec4\u00d4\u1ed6\u00e2\u1eab\u00ea\u1ec5\u00f4\u1ed7\u0102\u1eb4\u0103\u1eb5\u01a0\u1ee0\u01a1\u1ee1\u01af\u1eee\u01b0\u1eef", "\u0304A\u0100E\u0112G\u1e20I\u012aO\u014cU\u016aa\u0101e\u0113g\u1e21i\u012bo\u014du\u016b\u00c4\u01de\u00c6\u01e2\u00dc\u01d5\u00e4\u01df\u00e6\u01e3\u00fc\u01d6\u030c\u01ed\u0391\u1fb9\u0399\u1fd9\u03a5\u1fe9\u03b1\u1fb1\u03b9\u1fd1\u03c5\u1fe1\u0418\u04e2\u0423\u04ee\u0438\u04e3\u0443\u04ef\u1e36\u1e38\u1e37\u1e39\u1e5a\u1e5c\u1e5b\u1e5d", "\u0306A\u0102E\u0114G\u011eI\u012cO\u014eU\u016ca\u0103e\u0115g\u011fi\u012do\u014fu\u016d\u0391\u1fb8\u0399\u1fd8\u03a5\u1fe8\u03b1\u1fb0\u03b9\u1fd0\u03c5\u1fe0\u0410\u04d0\u0415\u04d6\u0416\u04c1\u0418\u0419\u0423\u040e\u0430\u04d1\u0435\u04d7\u0436\u04c2\u0438\u0439\u0443\u045e\u1ea0\u1eb6\u1ea1\u1eb7", "\u0307B\u1e02C\u010aD\u1e0aE\u0116F\u1e1eG\u0120H\u1e22I\u0130M\u1e40N\u1e44P\u1e56R\u1e58S\u1e60T\u1e6aW\u1e86X\u1e8aY\u1e8eZ\u017bb\u1e03c\u010bd\u1e0be\u0117f\u1e1fg\u0121h\u1e23m\u1e41n\u1e45p\u1e57r\u1e59s\u1e61t\u1e6bw\u1e87x\u1e8by\u1e8fz\u017c\u015a\u1e64\u015b\u1e65\u0160\u1e66\u0161\u1e67\u017f\u1e9b\u0306\u0310\u1e62\u1e68\u1e63\u1e69", "\u0308A\u00c4E\u00cbH\u1e26I\u00cfO\u00d6U\u00dcW\u1e84X\u1e8cY\u0178a\u00e4e\u00ebh\u1e27i\u00efo\u00f6t\u1e97u\u00fcw\u1e85x\u1e8dy\u00ff\u00d5\u1e4e\u00f5\u1e4f\u016a\u1e7a\u016b\u1e7b\u018f\u04da\u019f\u04ea\u0259\u04db\u0275\u04eb\u0399\u03aa\u03a5\u03ab\u03b9\u03ca\u03c5\u03cb\u03d2\u03d4\u0406\u0407\u0410\u04d2\u0415\u0401\u0416\u04dc\u0417\u04de\u0418\u04e4\u041e\u04e6\u0423\u04f0\u0427\u04f4\u042b\u04f8\u0430\u04d3\u0435\u0451\u0436\u04dd\u0437\u04df\u0438\u04e5\u043e\u04e7\u0443\u04f1\u0447\u04f5\u044b\u04f9\u0456\u0457", "\u0309A\u1ea2E\u1ebaI\u1ec8O\u1eceU\u1ee6Y\u1ef6a\u1ea3e\u1ebbi\u1ec9o\u1ecfu\u1ee7y\u1ef7\u00c2\u1ea8\u00ca\u1ec2\u00d4\u1ed4\u00e2\u1ea9\u00ea\u1ec3\u00f4\u1ed5\u0102\u1eb2\u0103\u1eb3\u01a0\u1ede\u01a1\u1edf\u01af\u1eec\u01b0\u1eed", "\u030aA\u00c5U\u016ea\u00e5u\u016fw\u1e98y\u1e99", "\u030bO\u0150U\u0170o\u0151u\u0171\u0423\u04f2\u0443\u04f3", "\u030cA\u01cdC\u010cD\u010eE\u011aG\u01e6I\u01cfK\u01e8L\u013dN\u0147O\u01d1R\u0158S\u0160T\u0164U\u01d3Z\u017da\u01cec\u010dd\u010fe\u011bg\u01e7i\u01d0j\u01f0k\u01e9l\u013en\u0148o\u01d2r\u0159s\u0161t\u0165u\u01d4z\u017e\u00dc\u01d9\u00fc\u01da\u01b7\u01ee\u0292\u01ef", "\u030d\u00a8\u0385\u0308\u0344\u0391\u0386\u0395\u0388\u0397\u0389\u0399\u038a\u039f\u038c\u03a5\u038e\u03a9\u038f\u03b1\u03ac\u03b5\u03ad\u03b7\u03ae\u03b9\u03af\u03bf\u03cc\u03c5\u03cd\u03c9\u03ce\u03d2\u03d3", "\u030fA\u0200E\u0204I\u0208O\u020cR\u0210U\u0214a\u0201e\u0205i\u0209o\u020dr\u0211u\u0215\u0474\u0476\u0475\u0477", "\u0311A\u0202E\u0206I\u020aO\u020eR\u0212U\u0216a\u0203e\u0207i\u020bo\u020fr\u0213u\u0217", "\u0313\u0391\u1f08\u0395\u1f18\u0397\u1f28\u0399\u1f38\u039f\u1f48\u03a9\u1f68\u03b1\u1f00\u03b5\u1f10\u03b7\u1f20\u03b9\u1f30\u03bf\u1f40\u03c1\u1fe4\u03c5\u1f50\u03c9\u1f60", "\u0314\u0391\u1f09\u0395\u1f19\u0397\u1f29\u0399\u1f39\u039f\u1f49\u03a1\u1fec\u03a5\u1f59\u03a9\u1f69\u03b1\u1f01\u03b5\u1f11\u03b7\u1f21\u03b9\u1f31\u03bf\u1f41\u03c1\u1fe5\u03c5\u1f51\u03c9\u1f61", "\u031bO\u01a0U\u01afo\u01a1u\u01b0\u00d2\u1edc\u00d3\u1eda\u00d5\u1ee0\u00d9\u1eea\u00da\u1ee8\u00f2\u1edd\u00f3\u1edb\u00f5\u1ee1\u00f9\u1eeb\u00fa\u1ee9\u0168\u1eee\u0169\u1eef\u1ecc\u1ee2\u1ecd\u1ee3\u1ece\u1ede\u1ecf\u1edf\u1ee4\u1ef0\u1ee5\u1ef1\u1ee6\u1eec\u1ee7\u1eed", "\u0323A\u1ea0B\u1e04D\u1e0cE\u1eb8H\u1e24I\u1ecaK\u1e32L\u1e36M\u1e42N\u1e46O\u1eccR\u1e5aS\u1e62T\u1e6cU\u1ee4V\u1e7eW\u1e88Y\u1ef4Z\u1e92a\u1ea1b\u1e05d\u1e0de\u1eb9h\u1e25i\u1ecbk\u1e33l\u1e37m\u1e43n\u1e47o\u1ecdr\u1e5bs\u1e63t\u1e6du\u1ee5v\u1e7fw\u1e89y\u1ef5z\u1e93\u00c2\u1eac\u00ca\u1ec6\u00d4\u1ed8\u00e2\u1ead\u00ea\u1ec7\u00f4\u1ed9\u0102\u1eb6\u0103\u1eb7\u01a0\u1ee2\u01a1\u1ee3\u01af\u1ef0\u01b0\u1ef1", "\u0324U\u1e72u\u1e73", "\u0325A\u1e00a\u1e01", "\u0327C\u00c7D\u1e10G\u0122H\u1e28K\u0136L\u013bN\u0145R\u0156S\u015eT\u0162c\u00e7d\u1e11g\u0123h\u1e29k\u0137l\u013cn\u0146r\u0157s\u015ft\u0163\u0106\u1e08\u0107\u1e09\u0114\u1e1c\u0115\u1e1d", "\u0328A\u0104E\u0118I\u012eO\u01eaU\u0172a\u0105e\u0119i\u012fo\u01ebu\u0173", "\u032dD\u1e12E\u1e18L\u1e3cN\u1e4aT\u1e70U\u1e76d\u1e13e\u1e19l\u1e3dn\u1e4bt\u1e71u\u1e77", "\u032eH\u1e2ah\u1e2b", "\u0330E\u1e1aI\u1e2cU\u1e74e\u1e1bi\u1e2du\u1e75", "\u0331B\u1e06D\u1e0eK\u1e34L\u1e3aN\u1e48R\u1e5eT\u1e6eZ\u1e94b\u1e07d\u1e0fh\u1e96k\u1e35l\u1e3bn\u1e49r\u1e5ft\u1e6fz\u1e95", "\u0338<\u226e=\u2260>\u226f~\u2241\u00d3\u01fe\u00f3\u01ff\u2203\u2204\u2208\u2209\u220b\u220c\u2223\u2224\u2225\u2226\u2243\u2244\u2245\u2247\u2248\u2249\u224d\u226d\u2261\u2262\u2264\u2270\u2265\u2271\u2272\u2274\u2273\u2275\u2276\u2278\u2277\u2279\u227a\u2280\u227b\u2281\u227c\u22e0\u227d\u22e1\u2282\u2284\u2283\u2285\u2286\u2288\u2287\u2289\u2291\u22e2\u2292\u22e3\u22a2\u22ac\u22a8\u22ad\u22a9\u22ae\u22ab\u22af\u22b2\u22ea\u22b3\u22eb\u22b4\u22ec\u22b5\u22ed", "\u0342\u00a8\u1fc1\u03b1\u1fb6\u03b7\u1fc6\u03b9\u1fd6\u03c5\u1fe6\u03c9\u1ff6\u03ca\u1fd7\u03cb\u1fe7\u1f00\u1f06\u1f01\u1f07\u1f08\u1f0e\u1f09\u1f0f\u1f20\u1f26\u1f21\u1f27\u1f28\u1f2e\u1f29\u1f2f\u1f30\u1f36\u1f31\u1f37\u1f38\u1f3e\u1f39\u1f3f\u1f50\u1f56\u1f51\u1f57\u1f59\u1f5f\u1f60\u1f66\u1f61\u1f67\u1f68\u1f6e\u1f69\u1f6f\u1fbf\u1fcf\u1ffe\u1fdf", "\u0344\u03b9\u0390\u03c5\u03b0", "\u0345\u0391\u1fbc\u0397\u1fcc\u03a9\u1ffc\u03b1\u1fb3\u03b7\u1fc3\u03c9\u1ff3\u1f00\u1f80\u1f01\u1f81\u1f02\u1f82\u1f03\u1f83\u1f04\u1f84\u1f05\u1f85\u1f06\u1f86\u1f07\u1f87\u1f08\u1f88\u1f09\u1f89\u1f0a\u1f8a\u1f0b\u1f8b\u1f0c\u1f8c\u1f0d\u1f8d\u1f0e\u1f8e\u1f0f\u1f8f\u1f20\u1f90\u1f21\u1f91\u1f22\u1f92\u1f23\u1f93\u1f24\u1f94\u1f25\u1f95\u1f26\u1f96\u1f27\u1f97\u1f28\u1f98\u1f29\u1f99\u1f2a\u1f9a\u1f2b\u1f9b\u1f2c\u1f9c\u1f2d\u1f9d\u1f2e\u1f9e\u1f2f\u1f9f\u1f60\u1fa0\u1f61\u1fa1\u1f62\u1fa2\u1f63\u1fa3\u1f64\u1fa4\u1f65\u1fa5\u1f66\u1fa6\u1f67\u1fa7\u1f68\u1fa8\u1f69\u1fa9\u1f6a\u1faa\u1f6b\u1fab\u1f6c\u1fac\u1f6d\u1fad\u1f6e\u1fae\u1f6f\u1faf\u1f70\u1fb2\u1f71\u1fb4\u1f74\u1fc2\u1f75\u1fc4\u1f79\u1ff4\u1f7c\u1ff2\u1fb6\u1fb7\u1fc6\u1fc7\u1ff6\u1ff7", "\u05b7\u05d0\ufb2e", "\u05b8\u05d0\ufb2f", "\u05b9\u05d5\ufb4b", "\u05bc\u05d0\ufb30\u05d1\ufb31\u05d2\ufb32\u05d3\ufb33\u05d4\ufb34\u05d5\ufb35\u05d6\ufb36\u05d8\ufb38\u05d9\ufb39\u05da\ufb3a\u05db\ufb3b\u05dc\ufb3c\u05de\ufb3e\u05e0\ufb40\u05e1\ufb41\u05e3\ufb43\u05e4\ufb44\u05e6\ufb46\u05e7\ufb47\u05e8\ufb48\u05e9\ufb49\u05ea\ufb4a\ufb2a\ufb2c\ufb2b\ufb2d", "\u05bf\u05d1\ufb4c\u05db\ufb4d\u05e4\ufb4e", "\u05c1\u05e9\ufb2a\ufb49\ufb2c", "\u05c2\u05e9\ufb2b\ufb49\ufb2d", "\u093c\u0915\u0958\u0916\u0959\u0917\u095a\u091c\u095b\u0921\u095c\u0922\u095d\u0928\u0929\u092b\u095e\u092f\u095f\u0930\u0931\u0933\u0934", "\u09bc\u09a1\u09dc\u09a2\u09dd\u09ac\u09b0\u09af\u09df", "\u09be\u09c7\u09cb", "\u09d7\u09c7\u09cc", "\u0a3c\u0a16\u0a59\u0a17\u0a5a\u0a1c\u0a5b\u0a21\u0a5c\u0a2b\u0a5e", "\u0b3c\u0b21\u0b5c\u0b22\u0b5d\u0b2f\u0b5f", "\u0b3e\u0b47\u0b4b", "\u0b56\u0b47\u0b48", "\u0b57\u0b47\u0b4c", "\u0bbe\u0bc6\u0bca\u0bc7\u0bcb", "\u0bd7\u0b92\u0b94\u0bc6\u0bcc", "\u0c56\u0c46\u0c48", "\u0cc2\u0cc6\u0cca", "\u0cd5\u0cbf\u0cc0\u0cc6\u0cc7\u0cca\u0ccb", "\u0cd6\u0cc6\u0cc8", "\u0d3e\u0d46\u0d4a\u0d47\u0d4b", "\u0d57\u0d46\u0d4c", "\u0f72\u0f71\u0f73", "\u0f74\u0f71\u0f75", "\u0f76\u0f71\u0f77", "\u0f78\u0f71\u0f79", "\u0f80\u0f71\u0f81\u0fb2\u0f76\u0fb3\u0f78", "\u0fb5\u0f40\u0f69\u0f90\u0fb9", "\u0fb7\u0f42\u0f43\u0f4c\u0f4d\u0f51\u0f52\u0f56\u0f57\u0f5b\u0f5c\u0f92\u0f93\u0f9c\u0f9d\u0fa1\u0fa2\u0fa6\u0fa7\u0fab\u0fac", "\u3099\u3046\u3094\u304b\u304c\u304d\u304e\u304f\u3050\u3051\u3052\u3053\u3054\u3055\u3056\u3057\u3058\u3059\u305a\u305b\u305c\u305d\u305e\u305f\u3060\u3061\u3062\u3064\u3065\u3066\u3067\u3068\u3069\u306f\u3070\u3072\u3073\u3075\u3076\u3078\u3079\u307b\u307c\u309d\u309e\u30a6\u30f4\u30ab\u30ac\u30ad\u30ae\u30af\u30b0\u30b1\u30b2\u30b3\u30b4\u30b5\u30b6\u30b7\u30b8\u30b9\u30ba\u30bb\u30bc\u30bd\u30be\u30bf\u30c0\u30c1\u30c2\u30c4\u30c5\u30c6\u30c7\u30c8\u30c9\u30cf\u30d0\u30d2\u30d3\u30d5\u30d6\u30d8\u30d9\u30db\u30dc\u30ef\u30f7\u30f0\u30f8\u30f1\u30f9\u30f2\u30fa\u30fd\u30fe"};
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            char c = string.charAt(0);
            if (c < minimumCombining) {
                minimumCombining = c;
            }
            int n2 = 1;
            while (n2 < string.length()) {
                composeMapping.put((string.charAt(n2) << 16) + c, string.charAt(n2 + 1));
                n2 += 2;
            }
            ++n;
        }
    }

    static class DecompIterator {
        private CompactShortArray.Iterator iter = Normalizer.access$300().getIterator();
        private StringBuffer buf = new StringBuffer();
        private int decmpLimit = -1;
        private short nextChar = (short)-1;

        DecompIterator(int n) {
            switch (n) {
                case 2: {
                    this.decmpLimit = maximumDecomposition;
                    break;
                }
                case 1: {
                    this.decmpLimit = maximumCanonical;
                }
            }
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        boolean hasNext() {
            while (this.nextChar == -1 && this.iter.hasNext()) {
                short s;
                char c = this.iter.next();
                short s2 = this.iter.shortValue();
                if (s2 >= this.decmpLimit) continue;
                this.nextChar = (short)c;
                this.buf.setLength(0);
                if (true) {
                    s = s2;
                    s2 = (short)(s2 + 1);
                    if ((c = contents.charAt(s)) == '\u0000') continue;
                }
                do {
                    this.buf.append(c);
                    s = s2;
                    s2 = (short)(s2 + 1);
                } while ((c = contents.charAt(s)) != '\u0000');
            }
            if (this.nextChar == -1) return false;
            return true;
        }

        char next() {
            if (this.nextChar == -1 && !this.hasNext()) {
                throw new ArrayIndexOutOfBoundsException();
            }
            char c = (char)this.nextChar;
            this.nextChar = (short)-1;
            return c;
        }

        String decomposition() {
            return this.buf.toString();
        }
    }
}

