/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import com.ibm.jvm.ExtendedSystem;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class HashMap
extends AbstractMap
implements Map,
Cloneable,
Serializable {
    private transient Entry[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;
    private transient int modCount = 0;
    private transient int contentionFlag = 0;
    private transient Set keySet = null;
    private transient Set entrySet = null;
    private transient Collection values = null;
    private static final int KEYS = 0;
    private static final int VALUES = 1;
    private static final int ENTRIES = 2;
    private static EmptyHashIterator emptyHashIterator = new EmptyHashIterator();
    private static final long serialVersionUID = 362498820763181265L;
    static /* synthetic */ Class class$java$util$HashMap$Entry;

    private synchronized void onEntry() {
        switch (this.contentionFlag) {
            case 0: {
                this.contentionFlag = 1;
                break;
            }
            case 1: {
                this.contentionFlag = 2;
            }
            case 2: {
                throw new ConcurrentModificationException("concurrent access to HashMap attempted by " + Thread.currentThread());
            }
            default: {
                throw new RuntimeException("Unexpected contentionFlag " + this.contentionFlag);
            }
        }
    }

    private synchronized void onExit() {
        int n = this.contentionFlag;
        this.contentionFlag = 0;
        switch (n) {
            case 1: {
                break;
            }
            case 2: {
                throw new ConcurrentModificationException("concurrent access to HashMap attempted by " + Thread.currentThread());
            }
            default: {
                throw new RuntimeException("Unexpected contentionFlag " + n);
            }
        }
    }

    public HashMap(int n, float f) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Initial Capacity: " + n);
        }
        if (f <= 0.0f || Float.isNaN(f)) {
            throw new IllegalArgumentException("Illegal Load factor: " + f);
        }
        if (n == 0) {
            n = 1;
        }
        this.loadFactor = f;
        this.table = new Entry[n];
        this.threshold = (int)((float)n * f);
    }

    public HashMap(int n) {
        this(n, 0.75f);
    }

    public HashMap() {
        this(11, 0.75f);
    }

    public HashMap(Map map) {
        this(Math.max(2 * map.size(), 11), 0.75f);
        this.putAll(map);
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public boolean containsValue(Object object) {
        Entry[] entryArray = this.table;
        if (object == null) {
            int n = entryArray.length;
            while (n-- > 0) {
                Entry entry = entryArray[n];
                while (entry != null) {
                    if (entry.value == null) {
                        return true;
                    }
                    entry = entry.next;
                }
            }
        } else {
            int n = entryArray.length;
            while (n-- > 0) {
                Entry entry = entryArray[n];
                while (entry != null) {
                    if (object.equals(entry.value)) {
                        return true;
                    }
                    entry = entry.next;
                }
            }
        }
        return false;
    }

    public boolean containsKey(Object object) {
        Entry[] entryArray = this.table;
        if (object != null) {
            int n = object.hashCode();
            int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
            Entry entry = entryArray[n2];
            while (entry != null) {
                if (entry.hash == n && object.equals(entry.key)) {
                    return true;
                }
                entry = entry.next;
            }
        } else {
            Entry entry = entryArray[0];
            while (entry != null) {
                if (entry.key == null) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    public Object get(Object object) {
        Entry[] entryArray = this.table;
        if (object != null) {
            int n = object.hashCode();
            int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
            Entry entry = entryArray[n2];
            while (entry != null) {
                if (entry.hash == n && object.equals(entry.key)) {
                    return entry.value;
                }
                entry = entry.next;
            }
        } else {
            Entry entry = entryArray[0];
            while (entry != null) {
                if (entry.key == null) {
                    return entry.value;
                }
                entry = entry.next;
            }
        }
        return null;
    }

    private void rehash() {
        this.onEntry();
        try {
            this.rehash0();
            Object var2_1 = null;
            this.onExit();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.onExit();
            throw throwable;
        }
    }

    private void rehash0() {
        int n = this.table.length;
        Entry[] entryArray = this.table;
        int n2 = n * 2 + 1;
        Entry[] entryArray2 = (Entry[])ExtendedSystem.newArray(class$java$util$HashMap$Entry == null ? (class$java$util$HashMap$Entry = HashMap.class$("java.util.HashMap$Entry")) : class$java$util$HashMap$Entry, n2, this);
        ++this.modCount;
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.table = entryArray2;
        int n3 = n;
        while (n3-- > 0) {
            Entry entry = entryArray[n3];
            while (entry != null) {
                Entry entry2 = entry;
                entry = entry.next;
                int n4 = (entry2.hash & Integer.MAX_VALUE) % n2;
                entry2.next = entryArray2[n4];
                entryArray2[n4] = entry2;
            }
        }
    }

    public Object put(Object object, Object object2) {
        Entry entry;
        Entry[] entryArray = this.table;
        int n = 0;
        int n2 = 0;
        if (object != null) {
            n = object.hashCode();
            n2 = (n & Integer.MAX_VALUE) % entryArray.length;
            entry = entryArray[n2];
            while (entry != null) {
                if (entry.hash == n && object.equals(entry.key)) {
                    Object object3 = entry.value;
                    entry.value = object2;
                    return object3;
                }
                entry = entry.next;
            }
        } else {
            entry = entryArray[0];
            while (entry != null) {
                if (entry.key == null) {
                    Object object4 = entry.value;
                    entry.value = object2;
                    return object4;
                }
                entry = entry.next;
            }
        }
        ++this.modCount;
        if (this.count >= this.threshold) {
            this.rehash();
            entryArray = this.table;
            n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        }
        entryArray[n2] = entry = new Entry(n, object, object2, entryArray[n2]);
        ++this.count;
        return null;
    }

    public Object remove(Object object) {
        Entry[] entryArray = this.table;
        if (object != null) {
            int n = object.hashCode();
            int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
            Entry entry = entryArray[n2];
            Entry entry2 = null;
            while (entry != null) {
                if (entry.hash == n && object.equals(entry.key)) {
                    ++this.modCount;
                    if (entry2 != null) {
                        entry2.next = entry.next;
                    } else {
                        entryArray[n2] = entry.next;
                    }
                    --this.count;
                    Object object2 = entry.value;
                    entry.value = null;
                    return object2;
                }
                entry2 = entry;
                entry = entry.next;
            }
        } else {
            Entry entry = entryArray[0];
            Entry entry3 = null;
            while (entry != null) {
                if (entry.key == null) {
                    ++this.modCount;
                    if (entry3 != null) {
                        entry3.next = entry.next;
                    } else {
                        entryArray[0] = entry.next;
                    }
                    --this.count;
                    Object object3 = entry.value;
                    entry.value = null;
                    return object3;
                }
                entry3 = entry;
                entry = entry.next;
            }
        }
        return null;
    }

    public void putAll(Map map) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void clear() {
        Entry[] entryArray = this.table;
        ++this.modCount;
        int n = entryArray.length;
        while (--n >= 0) {
            entryArray[n] = null;
        }
        this.count = 0;
    }

    public Object clone() {
        try {
            HashMap hashMap = (HashMap)super.clone();
            hashMap.table = new Entry[this.table.length];
            int n = this.table.length;
            while (n-- > 0) {
                Entry entry = hashMap.table[n] = this.table[n] != null ? (Entry)this.table[n].clone() : null;
            }
            hashMap.keySet = null;
            hashMap.entrySet = null;
            hashMap.values = null;
            hashMap.modCount = 0;
            return hashMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public Set keySet() {
        if (this.keySet == null) {
            this.keySet = new AbstractSet(){

                public Iterator iterator() {
                    return HashMap.this.getHashIterator(0);
                }

                public int size() {
                    return HashMap.this.count;
                }

                public boolean contains(Object object) {
                    return HashMap.this.containsKey(object);
                }

                public boolean remove(Object object) {
                    int n = HashMap.this.count;
                    HashMap.this.remove(object);
                    return HashMap.this.count != n;
                }

                public void clear() {
                    HashMap.this.clear();
                }
            };
        }
        return this.keySet;
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new AbstractCollection(){

                public Iterator iterator() {
                    return HashMap.this.getHashIterator(1);
                }

                public int size() {
                    return HashMap.this.count;
                }

                public boolean contains(Object object) {
                    return HashMap.this.containsValue(object);
                }

                public void clear() {
                    HashMap.this.clear();
                }
            };
        }
        return this.values;
    }

    public Set entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet(){

                public Iterator iterator() {
                    return HashMap.this.getHashIterator(2);
                }

                public boolean contains(Object object) {
                    if (!(object instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)object;
                    Object object2 = entry.getKey();
                    Entry[] entryArray = HashMap.this.table;
                    int n = object2 == null ? 0 : object2.hashCode();
                    int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
                    Entry entry2 = entryArray[n2];
                    while (entry2 != null) {
                        if (entry2.hash == n && entry2.equals(entry)) {
                            return true;
                        }
                        entry2 = entry2.next;
                    }
                    return false;
                }

                public boolean remove(Object object) {
                    if (!(object instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)object;
                    Object object2 = entry.getKey();
                    Entry[] entryArray = HashMap.this.table;
                    int n = object2 == null ? 0 : object2.hashCode();
                    int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
                    Entry entry2 = entryArray[n2];
                    Entry entry3 = null;
                    while (entry2 != null) {
                        if (entry2.hash == n && entry2.equals(entry)) {
                            HashMap.this.modCount++;
                            if (entry3 != null) {
                                entry3.next = entry2.next;
                            } else {
                                entryArray[n2] = entry2.next;
                            }
                            HashMap.this.count--;
                            entry2.value = null;
                            return true;
                        }
                        entry3 = entry2;
                        entry2 = entry2.next;
                    }
                    return false;
                }

                public int size() {
                    return HashMap.this.count;
                }

                public void clear() {
                    HashMap.this.clear();
                }
            };
        }
        return this.entrySet;
    }

    private Iterator getHashIterator(int n) {
        if (this.count == 0) {
            return emptyHashIterator;
        }
        return new HashIterator(n);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.table.length);
        objectOutputStream.writeInt(this.count);
        int n = this.table.length - 1;
        while (n >= 0) {
            Entry entry = this.table[n];
            while (entry != null) {
                objectOutputStream.writeObject(entry.key);
                objectOutputStream.writeObject(entry.value);
                entry = entry.next;
            }
            --n;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.table = new Entry[n];
        this.table = (Entry[])ExtendedSystem.newArray(class$java$util$HashMap$Entry == null ? (class$java$util$HashMap$Entry = HashMap.class$("java.util.HashMap$Entry")) : class$java$util$HashMap$Entry, n, this);
        int n2 = objectInputStream.readInt();
        int n3 = 0;
        while (n3 < n2) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            this.put(object, object2);
            ++n3;
        }
    }

    int capacity() {
        return this.table.length;
    }

    float loadFactor() {
        return this.loadFactor;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class HashIterator
    implements Iterator {
        Entry[] table;
        int index;
        Entry entry;
        Entry lastReturned;
        int type;
        private int expectedModCount;

        HashIterator(int n) {
            this.table = HashMap.this.table;
            this.index = this.table.length;
            this.entry = null;
            this.lastReturned = null;
            this.expectedModCount = HashMap.this.modCount;
            this.type = n;
        }

        public boolean hasNext() {
            Entry entry = this.entry;
            int n = this.index;
            Entry[] entryArray = this.table;
            while (entry == null && n > 0) {
                entry = entryArray[--n];
            }
            this.entry = entry;
            this.index = n;
            return entry != null;
        }

        public Object next() {
            if (HashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Entry entry = this.entry;
            int n = this.index;
            Entry[] entryArray = this.table;
            while (entry == null && n > 0) {
                entry = entryArray[--n];
            }
            this.entry = entry;
            this.index = n;
            if (entry != null) {
                Entry entry2 = this.lastReturned = this.entry;
                this.entry = entry2.next;
                return this.type == 0 ? entry2.key : (this.type == 1 ? entry2.value : entry2);
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (HashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Entry[] entryArray = HashMap.this.table;
            int n = (this.lastReturned.hash & Integer.MAX_VALUE) % entryArray.length;
            Entry entry = entryArray[n];
            Entry entry2 = null;
            while (entry != null) {
                if (entry == this.lastReturned) {
                    HashMap.this.modCount++;
                    ++this.expectedModCount;
                    if (entry2 == null) {
                        entryArray[n] = entry.next;
                    } else {
                        entry2.next = entry.next;
                    }
                    HashMap.this.count--;
                    this.lastReturned = null;
                    return;
                }
                entry2 = entry;
                entry = entry.next;
            }
            throw new ConcurrentModificationException();
        }
    }

    private static class EmptyHashIterator
    implements Iterator {
        EmptyHashIterator() {
        }

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new IllegalStateException();
        }
    }

    private static class Entry
    implements Map.Entry {
        int hash;
        Object key;
        Object value;
        Entry next;

        Entry(int n, Object object, Object object2, Entry entry) {
            this.hash = n;
            this.key = object;
            this.value = object2;
            this.next = entry;
        }

        protected Object clone() {
            return new Entry(this.hash, this.key, this.value, this.next == null ? null : (Entry)this.next.clone());
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object object) {
            Object object2 = this.value;
            this.value = object;
            return object2;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            boolean bl;
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            if (this.key == null) {
                if (entry.getKey() != null) return false;
                bl = true;
            } else {
                bl = this.key.equals(entry.getKey());
            }
            if (!bl) return false;
            if (this.value == null) {
                if (entry.getValue() != null) return false;
                return true;
            }
            boolean bl2 = this.value.equals(entry.getValue());
            if (!bl2) return false;
            return true;
        }

        public int hashCode() {
            return this.hash ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }
}

