/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.midi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiMessage;

public class SysexMessage
extends MidiMessage {
    public static final int SYSTEM_EXCLUSIVE = 240;
    public static final int SPECIAL_SYSTEM_EXCLUSIVE = 247;
    private static byte[] defaultMessage = new byte[]{-16, -9};

    public SysexMessage() {
        this(defaultMessage);
    }

    protected SysexMessage(byte[] byArray) {
        super(byArray);
    }

    public void setMessage(byte[] byArray, int n) throws InvalidMidiDataException {
        int n2 = 0;
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, 0, n);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            dataInputStream.reset();
            n2 = dataInputStream.readUnsignedByte();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (n2 != 240 && n2 != 247) {
            throw new InvalidMidiDataException("Invalid status byte for sysex message: " + n2);
        }
        this.length = n;
        if (this.data.length < this.length) {
            this.data = new byte[this.length];
        }
        System.arraycopy(byArray, 0, this.data, 0, n);
    }

    public void setMessage(int n, byte[] byArray, int n2) throws InvalidMidiDataException {
        if (n != 240 && n != 247) {
            throw new InvalidMidiDataException("Invalid status byte for sysex message: " + n);
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeByte(n);
            dataOutputStream.write(byArray, 0, n2);
            this.data = byteArrayOutputStream.toByteArray();
            this.length = this.data.length;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public byte[] getData() {
        byte[] byArray = new byte[this.length - 1];
        System.arraycopy(this.data, 1, byArray, 0, this.length - 1);
        return byArray;
    }

    public Object clone() {
        byte[] byArray = new byte[this.length];
        System.arraycopy(this.data, 0, byArray, 0, byArray.length);
        SysexMessage sysexMessage = new SysexMessage(byArray);
        return sysexMessage;
    }
}

