/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.Serializable;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.ViewportLayout;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ViewportUI;

public class JViewport
extends JComponent
implements Accessible {
    private static final String uiClassID = "ViewportUI";
    static final Object EnableWindowBlit = "EnableWindowBlit";
    protected boolean isViewSizeSet = false;
    protected Point lastPaintPosition = null;
    protected boolean backingStore = false;
    protected transient Image backingStoreImage = null;
    protected boolean scrollUnderway = false;
    private ComponentListener viewListener = null;
    private transient ChangeEvent changeEvent = null;
    public static final int BLIT_SCROLL_MODE = 1;
    public static final int BACKINGSTORE_SCROLL_MODE = 2;
    public static final int SIMPLE_SCROLL_MODE = 0;
    private int scrollMode = 1;
    private transient boolean repaintAll;
    private transient boolean waitingForRepaint;
    private transient Timer repaintTimer;
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    public JViewport() {
        this.updateUI();
        this.setLayout(this.createLayoutManager());
        this.setOpaque(true);
    }

    public ViewportUI getUI() {
        return (ViewportUI)this.ui;
    }

    public void setUI(ViewportUI viewportUI) {
        super.setUI(viewportUI);
    }

    public void updateUI() {
        this.setUI((ViewportUI)UIManager.getUI(this));
    }

    public String getUIClassID() {
        return uiClassID;
    }

    protected void addImpl(Component component, Object object, int n) {
        this.setView(component);
    }

    public void remove(Component component) {
        component.removeComponentListener(this.viewListener);
        super.remove(component);
    }

    public void scrollRectToVisible(Rectangle rectangle) {
        Component component = this.getView();
        if (component == null) {
            return;
        }
        if (!component.isValid()) {
            this.validateView();
        }
        int n = 0;
        int n2 = 0;
        n = this.positionAdjustment(this.getWidth(), rectangle.width, rectangle.x);
        n2 = this.positionAdjustment(this.getHeight(), rectangle.height, rectangle.y);
        if (n != 0 || n2 != 0) {
            Point point = this.getViewPosition();
            Dimension dimension = component.getSize();
            int n3 = point.x;
            int n4 = point.y;
            Dimension dimension2 = this.getExtentSize();
            point.x -= n;
            if (point.x + dimension2.width > dimension.width) {
                point.x = Math.max(0, dimension.width - dimension2.width);
            } else if (point.x < 0) {
                point.x = 0;
            }
            point.y -= n2;
            if (point.y + dimension2.height > dimension.height) {
                point.y = Math.max(0, dimension.height - dimension2.height);
            } else if (point.y < 0) {
                point.y = 0;
            }
            if (point.x != n3 || point.y != n4) {
                this.setViewPosition(point);
                this.scrollUnderway = false;
            }
        }
    }

    private void validateView() {
        Component component = null;
        Container container = this;
        while (container != null) {
            if (container instanceof CellRendererPane || container.getPeer() == null) {
                return;
            }
            if (container instanceof JComponent && ((JComponent)container).isValidateRoot()) {
                component = container;
                break;
            }
            container = container.getParent();
        }
        if (component == null) {
            return;
        }
        Component component2 = null;
        Component component3 = component;
        while (component3 != null) {
            if (!component3.isVisible() || component3.getPeer() == null) {
                return;
            }
            if (component3 instanceof Window || component3 instanceof Applet) {
                component2 = component3;
                break;
            }
            component3 = component3.getParent();
        }
        if (component2 == null) {
            return;
        }
        component.validate();
        RepaintManager repaintManager = RepaintManager.currentManager(this);
        if (repaintManager != null) {
            repaintManager.removeInvalidComponent((JComponent)component);
        }
    }

    private int positionAdjustment(int n, int n2, int n3) {
        if (n3 >= 0 && n2 + n3 <= n) {
            return 0;
        }
        if (n3 <= 0 && n2 + n3 >= n) {
            return 0;
        }
        if (n3 > 0 && n2 <= n) {
            return -n3 + n - n2;
        }
        if (n3 >= 0 && n2 >= n) {
            return -n3;
        }
        if (n3 <= 0 && n2 <= n) {
            return -n3;
        }
        if (n3 < 0 && n2 >= n) {
            return -n3 + n - n2;
        }
        return 0;
    }

    public final void setBorder(Border border) {
        if (border != null) {
            throw new IllegalArgumentException("JViewport.setBorder() not supported");
        }
    }

    public final Insets getInsets() {
        return new Insets(0, 0, 0, 0);
    }

    public final Insets getInsets(Insets insets) {
        insets.bottom = 0;
        insets.right = 0;
        insets.top = 0;
        insets.left = 0;
        return insets;
    }

    private Graphics getBackingStoreGraphics(Graphics graphics) {
        Graphics graphics2 = this.backingStoreImage.getGraphics();
        graphics2.setColor(graphics.getColor());
        graphics2.setFont(graphics.getFont());
        graphics2.setClip(graphics.getClipBounds());
        return graphics2;
    }

    private void paintViaBackingStore(Graphics graphics) {
        Graphics graphics2 = this.getBackingStoreGraphics(graphics);
        try {
            super.paint(graphics2);
            graphics.drawImage(this.backingStoreImage, 0, 0, this);
            Object var4_3 = null;
            graphics2.dispose();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            graphics2.dispose();
            throw throwable;
        }
    }

    private void paintViaBackingStore(Graphics graphics, Rectangle rectangle) {
        Graphics graphics2 = this.getBackingStoreGraphics(graphics);
        try {
            super.paint(graphics2);
            graphics.setClip(rectangle);
            graphics.drawImage(this.backingStoreImage, 0, 0, this);
            Object var5_4 = null;
            graphics2.dispose();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            graphics2.dispose();
            throw throwable;
        }
    }

    public boolean isOptimizedDrawingEnabled() {
        return false;
    }

    private Point getViewLocation() {
        Component component = this.getView();
        if (component != null) {
            return component.getLocation();
        }
        return new Point(0, 0);
    }

    public void paint(Graphics graphics) {
        Rectangle rectangle;
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (n <= 0 || n2 <= 0) {
            return;
        }
        if (this.repaintAll) {
            this.repaintAll = false;
            rectangle = graphics.getClipBounds();
            if (rectangle.width < this.getWidth() || rectangle.height < this.getHeight()) {
                this.waitingForRepaint = true;
                if (this.repaintTimer == null) {
                    this.repaintTimer = this.createRepaintTimer();
                }
                this.repaintTimer.stop();
                this.repaintTimer.start();
            } else {
                if (this.repaintTimer != null) {
                    this.repaintTimer.stop();
                }
                this.waitingForRepaint = false;
            }
        } else if (this.waitingForRepaint) {
            rectangle = graphics.getClipBounds();
            if (rectangle.width >= this.getWidth() && rectangle.height >= this.getHeight()) {
                this.waitingForRepaint = false;
                this.repaintTimer.stop();
            }
        }
        if (!this.backingStore || this.isBlitting() || this.getView() == null) {
            super.paint(graphics);
            this.lastPaintPosition = this.getViewLocation();
            return;
        }
        rectangle = this.getView().getBounds();
        if (!this.isOpaque()) {
            graphics.clipRect(0, 0, rectangle.width, rectangle.height);
        }
        if (this.backingStoreImage == null) {
            this.backingStoreImage = this.createImage(n, n2);
            Rectangle rectangle2 = graphics.getClipBounds();
            if (rectangle2.width != n || rectangle2.height != n2) {
                if (!this.isOpaque()) {
                    graphics.setClip(0, 0, Math.min(rectangle.width, n), Math.min(rectangle.height, n2));
                } else {
                    graphics.setClip(0, 0, n, n2);
                }
                this.paintViaBackingStore(graphics, rectangle2);
            } else {
                this.paintViaBackingStore(graphics);
            }
        } else if (!this.scrollUnderway || this.lastPaintPosition.equals(this.getViewLocation())) {
            this.paintViaBackingStore(graphics);
        } else {
            Point point = new Point();
            Point point2 = new Point();
            Dimension dimension = new Dimension();
            Rectangle rectangle3 = new Rectangle();
            Point point3 = this.getViewLocation();
            int n3 = point3.x - this.lastPaintPosition.x;
            int n4 = point3.y - this.lastPaintPosition.y;
            boolean bl = this.computeBlit(n3, n4, point, point2, dimension, rectangle3);
            if (!bl) {
                this.paintViaBackingStore(graphics);
            } else {
                int n5 = point2.x - point.x;
                int n6 = point2.y - point.y;
                Rectangle rectangle4 = graphics.getClipBounds();
                graphics.setClip(0, 0, n, n2);
                Graphics graphics2 = this.getBackingStoreGraphics(graphics);
                try {
                    graphics2.copyArea(point.x, point.y, dimension.width, dimension.height, n5, n6);
                    graphics.setClip(rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height);
                    Rectangle rectangle5 = rectangle.intersection(rectangle3);
                    graphics2.setClip(rectangle5);
                    super.paint(graphics2);
                    graphics.drawImage(this.backingStoreImage, 0, 0, this);
                    Object var19_19 = null;
                    graphics2.dispose();
                }
                catch (Throwable throwable) {
                    Object var19_20 = null;
                    graphics2.dispose();
                    throw throwable;
                }
            }
        }
        this.lastPaintPosition = this.getViewLocation();
        this.scrollUnderway = false;
    }

    public void reshape(int n, int n2, int n3, int n4) {
        boolean bl;
        boolean bl2 = bl = this.getWidth() != n3 || this.getHeight() != n4;
        if (bl) {
            this.backingStoreImage = null;
        }
        super.reshape(n, n2, n3, n4);
        if (bl && (this.isShowing() || !this.isVisible() || !this.isDisplayable())) {
            this.fireStateChanged();
        }
    }

    public void setScrollMode(int n) {
        this.scrollMode = n;
        this.backingStore = n == 2;
    }

    public int getScrollMode() {
        return this.scrollMode;
    }

    public boolean isBackingStoreEnabled() {
        return this.scrollMode == 2;
    }

    public void setBackingStoreEnabled(boolean bl) {
        if (bl) {
            this.setScrollMode(2);
        } else {
            this.setScrollMode(1);
        }
    }

    private final boolean isBlitting() {
        Component component = this.getView();
        return this.scrollMode == 1 && component instanceof JComponent && ((JComponent)component).isOpaque();
    }

    public Component getView() {
        try {
            return this.getComponent(0);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    public void setView(Component component) {
        int n = this.getComponentCount();
        int n2 = n - 1;
        while (n2 >= 0) {
            this.remove(n2);
            --n2;
        }
        this.isViewSizeSet = false;
        if (component != null) {
            super.addImpl(component, null, -1);
            this.viewListener = this.createViewListener();
            component.addComponentListener(this.viewListener);
        }
        this.revalidate();
        this.repaint();
    }

    public Dimension getViewSize() {
        Component component = this.getView();
        if (component == null) {
            return new Dimension(0, 0);
        }
        if (this.isViewSizeSet) {
            return component.getSize();
        }
        return component.getPreferredSize();
    }

    public void setViewSize(Dimension dimension) {
        Dimension dimension2;
        Component component = this.getView();
        if (component != null && !dimension.equals(dimension2 = component.getSize())) {
            this.scrollUnderway = false;
            component.setSize(dimension);
            this.isViewSizeSet = true;
            this.fireStateChanged();
        }
    }

    public Point getViewPosition() {
        Component component = this.getView();
        if (component != null) {
            Point point = component.getLocation();
            point.x = -point.x;
            point.y = -point.y;
            return point;
        }
        return new Point(0, 0);
    }

    public void setViewPosition(Point point) {
        int n;
        int n2;
        Serializable serializable;
        Component component = this.getView();
        if (component == null) {
            return;
        }
        int n3 = point.x;
        int n4 = point.y;
        if (component instanceof JComponent) {
            serializable = (JComponent)component;
            n2 = ((JComponent)serializable).getX();
            n = ((JComponent)serializable).getY();
        } else {
            serializable = component.getBounds();
            n2 = ((Rectangle)serializable).x;
            n = ((Rectangle)serializable).y;
        }
        int n5 = -n3;
        int n6 = -n4;
        if (n2 != n5 || n != n6) {
            if (!this.waitingForRepaint && this.isBlitting() && this.canUseWindowBlitter()) {
                Graphics graphics = this.getGraphics();
                this.flushViewDirtyRegion(graphics);
                component.setLocation(n5, n6);
                graphics.setClip(0, 0, this.getWidth(), Math.min(this.getHeight(), ((JComponent)component).getHeight()));
                this.repaintAll = this.windowBlitPaint(graphics);
                graphics.dispose();
                RepaintManager repaintManager = RepaintManager.currentManager(this);
                repaintManager.markCompletelyClean((JComponent)this.getParent());
                repaintManager.markCompletelyClean(this);
                repaintManager.markCompletelyClean((JComponent)component);
            } else {
                this.scrollUnderway = true;
                component.setLocation(n5, n6);
                this.repaintAll = false;
            }
            this.fireStateChanged();
        }
    }

    public Rectangle getViewRect() {
        return new Rectangle(this.getViewPosition(), this.getExtentSize());
    }

    protected boolean computeBlit(int n, int n2, Point point, Point point2, Dimension dimension, Rectangle rectangle) {
        int n3 = Math.abs(n);
        int n4 = Math.abs(n2);
        Dimension dimension2 = this.getExtentSize();
        if (n == 0 && n2 != 0 && n4 < dimension2.height) {
            if (n2 < 0) {
                point.y = -n2;
                point2.y = 0;
                rectangle.y = dimension2.height + n2;
            } else {
                point.y = 0;
                point2.y = n2;
                rectangle.y = 0;
            }
            point2.x = 0;
            point.x = 0;
            rectangle.x = 0;
            dimension.width = dimension2.width;
            dimension.height = dimension2.height - n4;
            rectangle.width = dimension2.width;
            rectangle.height = n4;
            return true;
        }
        if (n2 == 0 && n != 0 && n3 < dimension2.width) {
            if (n < 0) {
                point.x = -n;
                point2.x = 0;
                rectangle.x = dimension2.width + n;
            } else {
                point.x = 0;
                point2.x = n;
                rectangle.x = 0;
            }
            point2.y = 0;
            point.y = 0;
            rectangle.y = 0;
            dimension.width = dimension2.width - n3;
            dimension.height = dimension2.height;
            rectangle.y = 0;
            rectangle.width = n3;
            rectangle.height = dimension2.height;
            return true;
        }
        return false;
    }

    public Dimension getExtentSize() {
        return this.getSize();
    }

    public Dimension toViewCoordinates(Dimension dimension) {
        return new Dimension(dimension);
    }

    public Point toViewCoordinates(Point point) {
        return new Point(point);
    }

    public void setExtentSize(Dimension dimension) {
        Dimension dimension2 = this.getExtentSize();
        if (!dimension.equals(dimension2)) {
            this.setSize(dimension);
            this.fireStateChanged();
        }
    }

    protected ViewListener createViewListener() {
        return new ViewListener();
    }

    protected LayoutManager createLayoutManager() {
        return new ViewportLayout();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = JViewport.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = JViewport.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    protected void fireStateChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$ChangeListener == null ? JViewport.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) {
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((ChangeListener)objectArray[n + 1]).stateChanged(this.changeEvent);
            }
            n -= 2;
        }
    }

    public void repaint(long l, int n, int n2, int n3, int n4) {
        Container container = this.getParent();
        if (container != null) {
            container.repaint(l, n + this.getX(), n2 + this.getY(), n3, n4);
        } else {
            super.repaint(l, n, n2, n3, n4);
        }
    }

    protected String paramString() {
        String string = this.isViewSizeSet ? "true" : "false";
        String string2 = this.lastPaintPosition != null ? this.lastPaintPosition.toString() : "";
        String string3 = this.scrollUnderway ? "true" : "false";
        return super.paramString() + ",isViewSizeSet=" + string + ",lastPaintPosition=" + string2 + ",scrollUnderway=" + string3;
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        super.firePropertyChange(string, object, object2);
        if (string.equals(EnableWindowBlit)) {
            if (object2 != null) {
                this.setScrollMode(1);
            } else {
                this.setScrollMode(0);
            }
        }
    }

    private Timer createRepaintTimer() {
        Timer timer = new Timer(300, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (JViewport.this.waitingForRepaint) {
                    JViewport.this.repaint();
                }
            }
        });
        timer.setRepeats(false);
        return timer;
    }

    private void flushViewDirtyRegion(Graphics graphics) {
        JComponent jComponent;
        RepaintManager repaintManager = RepaintManager.currentManager(this);
        Rectangle rectangle = repaintManager.getDirtyRegion(jComponent = (JComponent)this.getView());
        if (rectangle != null && rectangle.width > 0 && rectangle.height > 0) {
            rectangle.x += jComponent.getX();
            rectangle.y += jComponent.getY();
            Rectangle rectangle2 = graphics.getClipBounds();
            if (rectangle2 == null) {
                graphics.setClip(0, 0, this.getWidth(), this.getHeight());
            }
            graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            this.paintView(graphics);
        }
    }

    private boolean windowBlitPaint(Graphics graphics) {
        boolean bl;
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (n == 0 || n2 == 0) {
            return false;
        }
        RepaintManager repaintManager = RepaintManager.currentManager(this);
        JComponent jComponent = (JComponent)this.getView();
        if (this.lastPaintPosition == null || this.lastPaintPosition.equals(this.getViewLocation())) {
            this.paintView(graphics);
            bl = false;
        } else {
            Point point = new Point();
            Point point2 = new Point();
            Dimension dimension = new Dimension();
            Rectangle rectangle = new Rectangle();
            Point point3 = this.getViewLocation();
            int n3 = point3.x - this.lastPaintPosition.x;
            int n4 = point3.y - this.lastPaintPosition.y;
            boolean bl2 = this.computeBlit(n3, n4, point, point2, dimension, rectangle);
            if (!bl2) {
                this.paintView(graphics);
                bl = false;
            } else {
                boolean bl3 = repaintManager.isDoubleBufferingEnabled();
                int n5 = point2.x - point.x;
                int n6 = point2.y - point.y;
                Rectangle rectangle2 = jComponent.getBounds().intersection(rectangle);
                rectangle2.x -= jComponent.getX();
                rectangle2.y -= jComponent.getY();
                Image image = repaintManager.getOffscreenBuffer(this, n, n2);
                Graphics graphics2 = image.getGraphics();
                graphics2.translate(-rectangle2.x, -rectangle2.y);
                graphics2.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                repaintManager.setDoubleBufferingEnabled(false);
                jComponent.paint(graphics2);
                repaintManager.setDoubleBufferingEnabled(bl3);
                this.blitWindowGraphics(point.x, point.y, dimension.width, dimension.height, n5, n6);
                rectangle2.x += jComponent.getX();
                rectangle2.y += jComponent.getY();
                graphics.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                graphics.drawImage(image, rectangle2.x, rectangle2.y, null);
                graphics2.dispose();
                bl = true;
            }
        }
        this.lastPaintPosition = this.getViewLocation();
        return bl;
    }

    private void paintView(Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        RepaintManager repaintManager = RepaintManager.currentManager(this);
        boolean bl = repaintManager.isDoubleBufferingEnabled();
        JComponent jComponent = (JComponent)this.getView();
        rectangle.x -= jComponent.getX();
        rectangle.y -= jComponent.getY();
        Image image = repaintManager.getOffscreenBuffer(this, rectangle.width, rectangle.height);
        Graphics graphics2 = image.getGraphics();
        if (jComponent.getWidth() < rectangle.width) {
            graphics2.setColor(this.getBackground());
            graphics2.fillRect(0, 0, rectangle.width, rectangle.height);
        }
        graphics2.translate(-rectangle.x, -rectangle.y);
        graphics2.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        repaintManager.setDoubleBufferingEnabled(false);
        jComponent.paint(graphics2);
        if (bl) {
            repaintManager.setDoubleBufferingEnabled(true);
        }
        graphics.drawImage(image, rectangle.x + jComponent.getX(), rectangle.y + jComponent.getY(), null);
        graphics2.dispose();
    }

    private void blitWindowGraphics(int n, int n2, int n3, int n4, int n5, int n6) {
        Container container = this.getParent();
        while (JComponent.isLightweightComponent(container)) {
            container = container.getParent();
        }
        Graphics graphics = container.getGraphics();
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        rectangle = SwingUtilities.convertRectangle(this, rectangle, container);
        graphics.copyArea(rectangle.x, rectangle.y, rectangle.width, rectangle.height, n5, n6);
        graphics.dispose();
    }

    private boolean canUseWindowBlitter() {
        if (!this.isShowing() || !(this.getParent() instanceof JComponent) && !(this.getView() instanceof JComponent)) {
            return false;
        }
        Rectangle rectangle = new Rectangle(0, 0, this.getWidth(), this.getHeight());
        Rectangle rectangle2 = new Rectangle();
        JViewport jViewport = null;
        Container container = this;
        while (container != null && JComponent.isLightweightComponent(container)) {
            Rectangle rectangle3 = container instanceof JComponent ? ((JComponent)container)._bounds : container.getBounds();
            rectangle2.setBounds(rectangle);
            SwingUtilities.computeIntersection(0, 0, rectangle3.width, rectangle3.height, rectangle);
            if (!rectangle.equals(rectangle2)) {
                return false;
            }
            if (jViewport != null && container instanceof JComponent && !((JComponent)container).isOptimizedDrawingEnabled()) {
                Component[] componentArray = container.getComponents();
                int n = 0;
                int n2 = componentArray.length - 1;
                while (n2 >= 0) {
                    if (componentArray[n2] == jViewport) {
                        n = n2 - 1;
                        break;
                    }
                    --n2;
                }
                while (n >= 0) {
                    Rectangle rectangle4 = componentArray[n] instanceof JComponent ? ((JComponent)componentArray[n])._bounds : componentArray[n].getBounds();
                    if (rectangle4.intersects(rectangle)) {
                        return false;
                    }
                    --n;
                }
            }
            rectangle.x += rectangle3.x;
            rectangle.y += rectangle3.y;
            jViewport = container;
            container = container.getParent();
        }
        return container != null;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJViewport();
        }
        return this.accessibleContext;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class AccessibleJViewport
    extends JComponent.AccessibleJComponent {
        protected AccessibleJViewport() {
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.VIEWPORT;
        }
    }

    protected class ViewListener
    extends ComponentAdapter
    implements Serializable {
        protected ViewListener() {
        }

        public void componentResized(ComponentEvent componentEvent) {
            JViewport.this.fireStateChanged();
        }
    }
}

