/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.colorchooser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.UIManager;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.colorchooser.CenterLayout;
import javax.swing.colorchooser.JIntegerTextField;
import javax.swing.colorchooser.SmartGridLayout;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class DefaultRGBChooserPanel
extends AbstractColorChooserPanel
implements ChangeListener {
    protected JSlider redSlider;
    protected JSlider greenSlider;
    protected JSlider blueSlider;
    protected JIntegerTextField redField;
    protected JIntegerTextField blueField;
    protected JIntegerTextField greenField;
    private final int minValue = 0;
    private final int maxValue = 255;
    boolean isAdjusting = false;

    public void setColor(Color color) {
        this.redSlider.setValue(color.getRed());
        this.greenSlider.setValue(color.getGreen());
        this.blueSlider.setValue(color.getBlue());
    }

    public String getDisplayName() {
        return UIManager.getString("ColorChooser.rgbNameText");
    }

    public Icon getSmallDisplayIcon() {
        return null;
    }

    public Icon getLargeDisplayIcon() {
        return null;
    }

    public void installChooserPanel(JColorChooser jColorChooser) {
        super.installChooserPanel(jColorChooser);
    }

    private int getMnemonic(String string) {
        int n = 0;
        String string2 = UIManager.getString(string);
        if (string2 != null && string2.length() >= 1 && ((n = (int)Character.toUpperCase(string2.charAt(0))) < 65 || n > 90)) {
            n = 0;
        }
        return n;
    }

    protected void buildChooser() {
        String string = UIManager.getString("ColorChooser.rgbRedText");
        String string2 = UIManager.getString("ColorChooser.rgbGreenText");
        String string3 = UIManager.getString("ColorChooser.rgbBlueText");
        this.setLayout(new BorderLayout());
        Color color = this.getColorFromModel();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new SmartGridLayout(3, 3));
        this.add((Component)jPanel, "Center");
        NumberListener numberListener = new NumberListener();
        JLabel jLabel = new JLabel(string);
        jLabel.setDisplayedMnemonic(this.getMnemonic("ColorChooser.rgbRedMnemonic"));
        jPanel.add(jLabel);
        this.redSlider = new JSlider(0, 0, 255, color.getRed());
        this.redSlider.setMajorTickSpacing(85);
        this.redSlider.setMinorTickSpacing(17);
        this.redSlider.setPaintTicks(true);
        this.redSlider.setPaintLabels(true);
        jPanel.add(this.redSlider);
        this.redField = new JIntegerTextField(0, 255, color.getRed());
        jLabel.setLabelFor(this.redSlider);
        JPanel jPanel2 = new JPanel(new CenterLayout());
        this.redField.getDocument().addDocumentListener(numberListener);
        jPanel2.add(this.redField);
        jPanel.add(jPanel2);
        jLabel = new JLabel(string2);
        jLabel.setDisplayedMnemonic(this.getMnemonic("ColorChooser.rgbGreenMnemonic"));
        jPanel.add(jLabel);
        this.greenSlider = new JSlider(0, 0, 255, color.getRed());
        this.greenSlider.setMajorTickSpacing(85);
        this.greenSlider.setMinorTickSpacing(17);
        this.greenSlider.setPaintTicks(true);
        this.greenSlider.setPaintLabels(true);
        jPanel.add(this.greenSlider);
        this.greenField = new JIntegerTextField(0, 255, color.getGreen());
        jLabel.setLabelFor(this.greenSlider);
        JPanel jPanel3 = new JPanel(new CenterLayout());
        jPanel3.add(this.greenField);
        this.greenField.getDocument().addDocumentListener(numberListener);
        jPanel.add(jPanel3);
        jLabel = new JLabel(string3);
        jLabel.setDisplayedMnemonic(this.getMnemonic("ColorChooser.rgbBlueMnemonic"));
        jPanel.add(jLabel);
        this.blueSlider = new JSlider(0, 0, 255, color.getRed());
        this.blueSlider.setMajorTickSpacing(85);
        this.blueSlider.setMinorTickSpacing(17);
        this.blueSlider.setPaintTicks(true);
        this.blueSlider.setPaintLabels(true);
        jPanel.add(this.blueSlider);
        this.blueField = new JIntegerTextField(0, 255, color.getBlue());
        jLabel.setLabelFor(this.blueSlider);
        JPanel jPanel4 = new JPanel(new CenterLayout());
        jPanel4.add(this.blueField);
        this.blueField.getDocument().addDocumentListener(numberListener);
        jPanel.add(jPanel4);
        this.redSlider.addChangeListener(this);
        this.greenSlider.addChangeListener(this);
        this.blueSlider.addChangeListener(this);
        this.redSlider.putClientProperty("JSlider.isFilled", Boolean.TRUE);
        this.greenSlider.putClientProperty("JSlider.isFilled", Boolean.TRUE);
        this.blueSlider.putClientProperty("JSlider.isFilled", Boolean.TRUE);
    }

    public void uninstallChooserPanel(JColorChooser jColorChooser) {
        super.uninstallChooserPanel(jColorChooser);
    }

    public void updateChooser() {
        if (this.isAdjusting) {
            return;
        }
        this.isAdjusting = true;
        Color color = this.getColorFromModel();
        int n = color.getRed();
        int n2 = color.getBlue();
        int n3 = color.getGreen();
        this.redSlider.setValue(n);
        this.blueSlider.setValue(n2);
        this.greenSlider.setValue(n3);
        if (this.redField.getIntegerValue() != n) {
            this.redField.setText(String.valueOf(color.getRed()));
        }
        if (this.greenField.getIntegerValue() != n3) {
            this.greenField.setText(String.valueOf(color.getGreen()));
        }
        if (this.blueField.getIntegerValue() != n2) {
            this.blueField.setText(String.valueOf(color.getBlue()));
        }
        this.isAdjusting = false;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() instanceof JSlider) {
            int n = this.redSlider.getValue();
            int n2 = this.greenSlider.getValue();
            int n3 = this.blueSlider.getValue();
            Color color = new Color(n, n2, n3);
            this.getColorSelectionModel().setSelectedColor(color);
        }
    }

    class NumberListener
    implements DocumentListener,
    Serializable {
        NumberListener() {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.updatePanel(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.updatePanel(documentEvent);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        private void updatePanel(DocumentEvent documentEvent) {
            int n = DefaultRGBChooserPanel.this.redField.getIntegerValue();
            int n2 = DefaultRGBChooserPanel.this.greenField.getIntegerValue();
            int n3 = DefaultRGBChooserPanel.this.blueField.getIntegerValue();
            Color color = new Color(n, n2, n3);
            DefaultRGBChooserPanel.this.getColorSelectionModel().setSelectedColor(color);
        }
    }
}

