/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.colorchooser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.colorchooser.MainSwatchPanel;
import javax.swing.colorchooser.RecentSwatchPanel;
import javax.swing.colorchooser.SwatchPanel;

class DefaultSwatchChooserPanel
extends AbstractColorChooserPanel {
    SwatchPanel swatchPanel;
    RecentSwatchPanel recentSwatchPanel;
    MouseListener mainSwatchListener;
    MouseListener recentSwatchListener;
    private static String recentStr = UIManager.getString("ColorChooser.swatchesRecentText");

    public String getDisplayName() {
        return UIManager.getString("ColorChooser.swatchesNameText");
    }

    public Icon getSmallDisplayIcon() {
        return null;
    }

    public Icon getLargeDisplayIcon() {
        return null;
    }

    public void installChooserPanel(JColorChooser jColorChooser) {
        super.installChooserPanel(jColorChooser);
    }

    protected void buildChooser() {
        JPanel jPanel = new JPanel(new FlowLayout());
        this.swatchPanel = new MainSwatchPanel();
        this.swatchPanel.getAccessibleContext().setAccessibleName(this.getDisplayName());
        this.recentSwatchPanel = new RecentSwatchPanel();
        this.recentSwatchPanel.getAccessibleContext().setAccessibleName(recentStr);
        this.mainSwatchListener = new MainSwatchListener();
        this.swatchPanel.addMouseListener(this.mainSwatchListener);
        this.recentSwatchListener = new RecentSwatchListener();
        this.recentSwatchPanel.addMouseListener(this.recentSwatchListener);
        JPanel jPanel2 = new JPanel(new FlowLayout());
        CompoundBorder compoundBorder = new CompoundBorder(new LineBorder(Color.black), new LineBorder(Color.white));
        jPanel2.setBorder(compoundBorder);
        jPanel2.add(this.swatchPanel);
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel(new FlowLayout());
        this.recentSwatchPanel.addMouseListener(this.recentSwatchListener);
        jPanel3.setBorder(compoundBorder);
        jPanel3.add(this.recentSwatchPanel);
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add((Component)jPanel3, "West");
        JPanel jPanel5 = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel(recentStr);
        jLabel.setLabelFor(this.recentSwatchPanel);
        jPanel5.add((Component)jLabel, "South");
        JPanel jPanel6 = new JPanel(new BorderLayout());
        if (this.getComponentOrientation().isLeftToRight()) {
            jPanel6.setBorder(new EmptyBorder(2, 10, 2, 2));
        } else {
            jPanel6.setBorder(new EmptyBorder(2, 2, 2, 10));
        }
        jPanel6.add((Component)jPanel5, "North");
        jPanel6.add((Component)jPanel4, "Center");
        jPanel.add(jPanel6);
        this.add(jPanel);
    }

    public void uninstallChooserPanel(JColorChooser jColorChooser) {
        super.uninstallChooserPanel(jColorChooser);
        this.swatchPanel.removeMouseListener(this.mainSwatchListener);
        this.recentSwatchPanel.removeMouseListener(this.recentSwatchListener);
        this.swatchPanel = null;
        this.recentSwatchPanel = null;
        this.mainSwatchListener = null;
        this.recentSwatchListener = null;
        this.removeAll();
    }

    public void updateChooser() {
    }

    class MainSwatchListener
    extends MouseAdapter
    implements Serializable {
        MainSwatchListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Color color = DefaultSwatchChooserPanel.this.swatchPanel.getColorForLocation(mouseEvent.getX(), mouseEvent.getY());
            DefaultSwatchChooserPanel.this.getColorSelectionModel().setSelectedColor(color);
            DefaultSwatchChooserPanel.this.recentSwatchPanel.setMostRecentColor(color);
        }
    }

    class RecentSwatchListener
    extends MouseAdapter
    implements Serializable {
        RecentSwatchListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Color color = DefaultSwatchChooserPanel.this.recentSwatchPanel.getColorForLocation(mouseEvent.getX(), mouseEvent.getY());
            DefaultSwatchChooserPanel.this.getColorSelectionModel().setSelectedColor(color);
        }
    }
}

