/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.beans.PropertyVetoException;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.DefaultDesktopManager;
import javax.swing.DesktopManager;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.DesktopPaneUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicScrollBarUI;
import javax.swing.plaf.basic.BasicScrollPaneUI;

public class BasicDesktopPaneUI
extends DesktopPaneUI {
    private static Dimension minSize = new Dimension(0, 0);
    private static Dimension maxSize = new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    protected JDesktopPane desktop;
    protected DesktopManager desktopManager;
    protected KeyStroke minimizeKey;
    protected KeyStroke maximizeKey;
    protected KeyStroke closeKey;
    protected KeyStroke navigateKey;
    protected KeyStroke navigateKey2;
    private static Vector framesCache;
    private static int selectedIndex;
    private NavigateAction nextAction;
    private boolean moving = false;
    private boolean resizing = false;
    private final int MOVE_RESIZE_INCREMENT = 10;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicDesktopPaneUI();
    }

    public void installUI(JComponent jComponent) {
        this.desktop = (JDesktopPane)jComponent;
        this.installDefaults();
        this.installDesktopManager();
        this.installKeyboardActions();
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallKeyboardActions();
        this.uninstallDesktopManager();
        this.uninstallDefaults();
        this.desktop = null;
    }

    protected void installDefaults() {
        if (this.desktop.getBackground() == null || this.desktop.getBackground() instanceof UIResource) {
            this.desktop.setBackground(UIManager.getColor("Desktop.background"));
        }
    }

    protected void uninstallDefaults() {
    }

    protected void installDesktopManager() {
        if (this.desktop.getDesktopManager() == null) {
            this.desktopManager = new DefaultDesktopManager();
            this.desktop.setDesktopManager(this.desktopManager);
        }
    }

    protected void uninstallDesktopManager() {
        if (this.desktop.getDesktopManager() == this.desktopManager) {
            this.desktop.setDesktopManager(null);
        }
        this.desktopManager = null;
    }

    protected void installKeyboardActions() {
        InputMap inputMap = this.getInputMap(2);
        if (inputMap != null) {
            SwingUtilities.replaceUIInputMap(this.desktop, 2, inputMap);
        }
        if ((inputMap = this.getInputMap(1)) != null) {
            SwingUtilities.replaceUIInputMap(this.desktop, 1, inputMap);
        }
        ActionMap actionMap = this.getActionMap();
        SwingUtilities.replaceUIActionMap(this.desktop, actionMap);
        this.registerKeyboardActions();
    }

    protected void registerKeyboardActions() {
    }

    protected void unregisterKeyboardActions() {
    }

    InputMap getInputMap(int n) {
        if (n == 2) {
            return this.createInputMap(n);
        }
        if (n == 1) {
            return (InputMap)UIManager.get("Desktop.ancestorInputMap");
        }
        return null;
    }

    InputMap createInputMap(int n) {
        Object[] objectArray;
        if (n == 2 && (objectArray = (Object[])UIManager.get("Desktop.windowBindings")) != null) {
            return LookAndFeel.makeComponentInputMap(this.desktop, objectArray);
        }
        return null;
    }

    ActionMap getActionMap() {
        return this.createActionMap();
    }

    ActionMap createActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("restore", new OpenAction());
        actionMapUIResource.put("close", new CloseAction());
        actionMapUIResource.put("move", new MoveResizeAction("move"));
        actionMapUIResource.put("resize", new MoveResizeAction("resize"));
        actionMapUIResource.put("left", new MoveResizeAction("left"));
        actionMapUIResource.put("right", new MoveResizeAction("right"));
        actionMapUIResource.put("up", new MoveResizeAction("up"));
        actionMapUIResource.put("down", new MoveResizeAction("down"));
        actionMapUIResource.put("escape", new MoveResizeAction("escape"));
        actionMapUIResource.put("minimize", new MinimizeAction());
        actionMapUIResource.put("maximize", new MaximizeAction());
        this.nextAction = new NavigateAction();
        actionMapUIResource.put("selectNextFrame", this.nextAction);
        actionMapUIResource.put("selectPreviousFrame", new PreviousAction());
        return actionMapUIResource;
    }

    protected void uninstallKeyboardActions() {
        this.unregisterKeyboardActions();
        SwingUtilities.replaceUIInputMap(this.desktop, 2, null);
        SwingUtilities.replaceUIInputMap(this.desktop, 1, null);
        SwingUtilities.replaceUIActionMap(this.desktop, null);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return null;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return minSize;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return maxSize;
    }

    private void verifyFramesCache() {
        Object object;
        boolean bl = false;
        if (framesCache == null) {
            framesCache = new Vector();
            bl = true;
        }
        boolean bl2 = false;
        int n = framesCache.size();
        int n2 = 0;
        while (n2 < n) {
            JInternalFrame jInternalFrame;
            JComponent jComponent;
            object = (JComponent)framesCache.elementAt(n2);
            if (object instanceof JInternalFrame) {
                jComponent = (JInternalFrame)object;
                if (((JInternalFrame)jComponent).isClosed()) {
                    bl2 = true;
                    break;
                }
            } else if (object instanceof JInternalFrame.JDesktopIcon && (jInternalFrame = ((JInternalFrame.JDesktopIcon)(jComponent = (JInternalFrame.JDesktopIcon)object)).getInternalFrame()).isClosed()) {
                bl2 = true;
                break;
            }
            ++n2;
        }
        object = this.desktop.getAllFrames();
        if (bl2 || ((JInternalFrame[])object).length != framesCache.size()) {
            framesCache.clear();
            int n3 = this.desktop.lowestLayer();
            int n4 = this.desktop.highestLayer();
            int n5 = 0;
            int n6 = n4;
            while (n6 >= n3) {
                Component[] componentArray = this.desktop.getComponentsInLayer(n6);
                if (componentArray.length > 0) {
                    int n7 = 0;
                    while (n7 < componentArray.length) {
                        framesCache.addElement(componentArray[n7]);
                        if (bl && componentArray[n7] instanceof JInternalFrame && ((JInternalFrame)componentArray[n7]).isSelected()) {
                            selectedIndex = n5;
                        }
                        ++n5;
                        ++n7;
                    }
                }
                --n6;
            }
        }
    }

    private class PreviousAction
    extends AbstractAction {
        private PreviousAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JComponent jComponent;
            BasicDesktopPaneUI.this.verifyFramesCache();
            selectedIndex--;
            if (selectedIndex < 0) {
                selectedIndex = framesCache.size() - 1;
            }
            if ((jComponent = (JComponent)framesCache.elementAt(selectedIndex)) instanceof JInternalFrame) {
                JInternalFrame jInternalFrame = (JInternalFrame)jComponent;
                try {
                    jInternalFrame.setSelected(true);
                    BasicDesktopPaneUI.this.desktopManager.activateFrame(jInternalFrame);
                }
                catch (PropertyVetoException propertyVetoException) {}
            } else if (jComponent instanceof JInternalFrame.JDesktopIcon) {
                JInternalFrame.JDesktopIcon jDesktopIcon = (JInternalFrame.JDesktopIcon)jComponent;
                JInternalFrame jInternalFrame = jDesktopIcon.getInternalFrame();
                try {
                    jInternalFrame.setSelected(true);
                    BasicDesktopPaneUI.this.desktopManager.activateFrame(jInternalFrame);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }

        public boolean isEnabled() {
            return true;
        }
    }

    protected class NavigateAction
    extends AbstractAction {
        protected NavigateAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JComponent jComponent;
            BasicDesktopPaneUI.this.verifyFramesCache();
            selectedIndex++;
            if (selectedIndex >= framesCache.size()) {
                selectedIndex = 0;
            }
            if ((jComponent = (JComponent)framesCache.elementAt(selectedIndex)) instanceof JInternalFrame) {
                JInternalFrame jInternalFrame = (JInternalFrame)jComponent;
                try {
                    jInternalFrame.setSelected(true);
                    BasicDesktopPaneUI.this.desktopManager.activateFrame(jInternalFrame);
                }
                catch (PropertyVetoException propertyVetoException) {}
            } else if (jComponent instanceof JInternalFrame.JDesktopIcon) {
                JInternalFrame.JDesktopIcon jDesktopIcon = (JInternalFrame.JDesktopIcon)jComponent;
                JInternalFrame jInternalFrame = jDesktopIcon.getInternalFrame();
                try {
                    jInternalFrame.setSelected(true);
                    BasicDesktopPaneUI.this.desktopManager.activateFrame(jInternalFrame);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }

        public boolean isEnabled() {
            return true;
        }
    }

    protected class MaximizeAction
    extends AbstractAction {
        protected MaximizeAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JInternalFrame.JDesktopIcon jDesktopIcon;
            JInternalFrame jInternalFrame;
            BasicDesktopPaneUI.this.verifyFramesCache();
            JComponent jComponent = (JComponent)framesCache.elementAt(selectedIndex);
            if (jComponent instanceof JInternalFrame) {
                JInternalFrame jInternalFrame2 = (JInternalFrame)jComponent;
                if (jInternalFrame2.isMaximizable()) {
                    try {
                        jInternalFrame2.setMaximum(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                }
            } else if (jComponent instanceof JInternalFrame.JDesktopIcon && (jInternalFrame = (jDesktopIcon = (JInternalFrame.JDesktopIcon)jComponent).getInternalFrame()).isMaximizable()) {
                try {
                    jInternalFrame.setIcon(false);
                    jInternalFrame.setMaximum(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }

        public boolean isEnabled() {
            return true;
        }
    }

    protected class MinimizeAction
    extends AbstractAction {
        protected MinimizeAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JInternalFrame jInternalFrame;
            BasicDesktopPaneUI.this.verifyFramesCache();
            JComponent jComponent = (JComponent)framesCache.elementAt(selectedIndex);
            if (jComponent instanceof JInternalFrame && (jInternalFrame = (JInternalFrame)jComponent).isIconifiable()) {
                try {
                    jInternalFrame.setIcon(true);
                    BasicDesktopPaneUI.this.nextAction.actionPerformed(actionEvent);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }

        public boolean isEnabled() {
            return true;
        }
    }

    private class MoveResizeAction
    extends AbstractAction {
        private String command;

        public MoveResizeAction(String string) {
            this.command = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            if ("move".equals(this.command) || "resize".equals(this.command) || "escape".equals(this.command)) {
                int n = BasicDesktopPaneUI.this.desktop.getComponentCount();
                object = BasicDesktopPaneUI.this.desktop.getComponents();
                int n2 = 0;
                while (n2 < n) {
                    JInternalFrame jInternalFrame;
                    Container container;
                    if (object[n2] instanceof JInternalFrame && (container = (jInternalFrame = (JInternalFrame)object[n2]).getContentPane()) instanceof JScrollPane) {
                        Object object2;
                        JScrollPane jScrollPane = (JScrollPane)container;
                        if (jScrollPane.getUI() instanceof BasicScrollPaneUI) {
                            object2 = (BasicScrollPaneUI)jScrollPane.getUI();
                            if ("move".equals(this.command) || "resize".equals(this.command)) {
                                ((BasicScrollPaneUI)object2).uninstallKeyboardActions(jScrollPane);
                            } else if ("escape".equals(this.command) && (BasicDesktopPaneUI.this.moving || BasicDesktopPaneUI.this.resizing)) {
                                ((BasicScrollPaneUI)object2).installKeyboardActions(jScrollPane);
                            }
                        }
                        object2 = jScrollPane.getHorizontalScrollBar();
                        int n3 = 0;
                        while (n3 < 2) {
                            if (object2 != null && ((JScrollBar)object2).getUI() instanceof BasicScrollBarUI) {
                                BasicScrollBarUI basicScrollBarUI = (BasicScrollBarUI)((JScrollBar)object2).getUI();
                                if ("move".equals(this.command) || "resize".equals(this.command)) {
                                    basicScrollBarUI.uninstallKeyboardActions();
                                } else if ("escape".equals(this.command) && (BasicDesktopPaneUI.this.moving || BasicDesktopPaneUI.this.resizing)) {
                                    basicScrollBarUI.installKeyboardActions();
                                }
                            }
                            object2 = jScrollPane.getVerticalScrollBar();
                            ++n3;
                        }
                    }
                    ++n2;
                }
            }
            if ("move".equals(this.command)) {
                BasicDesktopPaneUI.this.moving = true;
                BasicDesktopPaneUI.this.resizing = false;
                return;
            }
            if ("resize".equals(this.command)) {
                BasicDesktopPaneUI.this.moving = false;
                BasicDesktopPaneUI.this.resizing = true;
                return;
            }
            if ("escape".equals(this.command)) {
                BasicDesktopPaneUI.this.moving = (BasicDesktopPaneUI.this.resizing = false);
                return;
            }
            if (!BasicDesktopPaneUI.this.moving && !BasicDesktopPaneUI.this.resizing) {
                return;
            }
            JInternalFrame jInternalFrame = BasicDesktopPaneUI.this.desktop.getSelectedFrame();
            if (jInternalFrame == null || !(jInternalFrame instanceof JInternalFrame)) {
                return;
            }
            object = jInternalFrame.getSize();
            Point point = jInternalFrame.getLocation();
            if ("left".equals(this.command)) {
                if (BasicDesktopPaneUI.this.moving) {
                    jInternalFrame.setLocation(point.x - 10, point.y);
                } else if (BasicDesktopPaneUI.this.resizing) {
                    jInternalFrame.setLocation(point.x - 10, point.y);
                    jInternalFrame.setSize(object.width + 10, object.height);
                }
            } else if ("right".equals(this.command)) {
                if (BasicDesktopPaneUI.this.moving) {
                    jInternalFrame.setLocation(point.x + 10, point.y);
                } else if (BasicDesktopPaneUI.this.resizing) {
                    jInternalFrame.setLocation(point.x, point.y);
                    jInternalFrame.setSize(object.width + 10, object.height);
                }
            } else if ("up".equals(this.command)) {
                if (BasicDesktopPaneUI.this.moving) {
                    jInternalFrame.setLocation(point.x, point.y - 10);
                } else if (BasicDesktopPaneUI.this.resizing) {
                    jInternalFrame.setLocation(point.x, point.y - 10);
                    jInternalFrame.setSize(object.width, object.height + 10);
                }
            } else if ("down".equals(this.command)) {
                if (BasicDesktopPaneUI.this.moving) {
                    jInternalFrame.setLocation(point.x, point.y + 10);
                } else if (BasicDesktopPaneUI.this.resizing) {
                    jInternalFrame.setLocation(point.x, point.y);
                    jInternalFrame.setSize(object.width, object.height + 10);
                }
            }
        }

        public boolean isEnabled() {
            return true;
        }
    }

    protected class CloseAction
    extends AbstractAction {
        protected CloseAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JInternalFrame.JDesktopIcon jDesktopIcon;
            JInternalFrame jInternalFrame;
            BasicDesktopPaneUI.this.verifyFramesCache();
            JComponent jComponent = (JComponent)framesCache.elementAt(selectedIndex);
            if (jComponent instanceof JInternalFrame) {
                JInternalFrame jInternalFrame2 = (JInternalFrame)jComponent;
                if (jInternalFrame2.isClosable()) {
                    jInternalFrame2.doDefaultCloseAction();
                    BasicDesktopPaneUI.this.nextAction.actionPerformed(actionEvent);
                }
            } else if (jComponent instanceof JInternalFrame.JDesktopIcon && (jInternalFrame = (jDesktopIcon = (JInternalFrame.JDesktopIcon)jComponent).getInternalFrame()).isClosable()) {
                try {
                    jInternalFrame.setClosed(true);
                    BasicDesktopPaneUI.this.nextAction.actionPerformed(actionEvent);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }

        public boolean isEnabled() {
            return true;
        }
    }

    protected class OpenAction
    extends AbstractAction {
        protected OpenAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            BasicDesktopPaneUI.this.verifyFramesCache();
            JComponent jComponent = (JComponent)framesCache.elementAt(selectedIndex);
            if (jComponent instanceof JInternalFrame) {
                JInternalFrame jInternalFrame = (JInternalFrame)jComponent;
                try {
                    if (jInternalFrame.isIcon()) {
                        jInternalFrame.setIcon(false);
                    } else if (jInternalFrame.isMaximum()) {
                        jInternalFrame.setMaximum(false);
                    }
                    jInternalFrame.setSelected(true);
                    BasicDesktopPaneUI.this.desktopManager.activateFrame(jInternalFrame);
                }
                catch (PropertyVetoException propertyVetoException) {}
            } else if (jComponent instanceof JInternalFrame.JDesktopIcon) {
                JInternalFrame.JDesktopIcon jDesktopIcon = (JInternalFrame.JDesktopIcon)jComponent;
                JInternalFrame jInternalFrame = jDesktopIcon.getInternalFrame();
                try {
                    jInternalFrame.setIcon(false);
                    jInternalFrame.setSelected(true);
                    BasicDesktopPaneUI.this.desktopManager.activateFrame(jInternalFrame);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }

        public boolean isEnabled() {
            return true;
        }
    }
}

