/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.TextLayout;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.SwingUtilities;

public class BasicGraphicsUtils {
    private static final Insets GROOVE_INSETS = new Insets(2, 2, 2, 2);
    private static final Insets ETCHED_INSETS = new Insets(2, 2, 2, 2);

    public static void drawEtchedRect(Graphics graphics, int n, int n2, int n3, int n4, Color color, Color color2, Color color3, Color color4) {
        Color color5 = graphics.getColor();
        graphics.translate(n, n2);
        graphics.setColor(color);
        graphics.drawLine(0, 0, n3 - 1, 0);
        graphics.drawLine(0, 1, 0, n4 - 2);
        graphics.setColor(color2);
        graphics.drawLine(1, 1, n3 - 3, 1);
        graphics.drawLine(1, 2, 1, n4 - 3);
        graphics.setColor(color4);
        graphics.drawLine(n3 - 1, 0, n3 - 1, n4 - 1);
        graphics.drawLine(0, n4 - 1, n3 - 1, n4 - 1);
        graphics.setColor(color3);
        graphics.drawLine(n3 - 2, 1, n3 - 2, n4 - 3);
        graphics.drawLine(1, n4 - 2, n3 - 2, n4 - 2);
        graphics.translate(-n, -n2);
        graphics.setColor(color5);
    }

    public static Insets getEtchedInsets() {
        return ETCHED_INSETS;
    }

    public static void drawGroove(Graphics graphics, int n, int n2, int n3, int n4, Color color, Color color2) {
        Color color3 = graphics.getColor();
        graphics.translate(n, n2);
        graphics.setColor(color);
        graphics.drawRect(0, 0, n3 - 2, n4 - 2);
        graphics.setColor(color2);
        graphics.drawLine(1, n4 - 3, 1, 1);
        graphics.drawLine(1, 1, n3 - 3, 1);
        graphics.drawLine(0, n4 - 1, n3 - 1, n4 - 1);
        graphics.drawLine(n3 - 1, n4 - 1, n3 - 1, 0);
        graphics.translate(-n, -n2);
        graphics.setColor(color3);
    }

    public static Insets getGrooveInsets() {
        return GROOVE_INSETS;
    }

    public static void drawBezel(Graphics graphics, int n, int n2, int n3, int n4, boolean bl, boolean bl2, Color color, Color color2, Color color3, Color color4) {
        Color color5 = graphics.getColor();
        graphics.translate(n, n2);
        if (bl) {
            if (bl2) {
                graphics.setColor(color2);
                graphics.drawRect(0, 0, n3 - 1, n4 - 1);
            }
            graphics.setColor(color);
            graphics.drawRect(1, 1, n3 - 3, n4 - 3);
        } else {
            if (bl2) {
                graphics.setColor(color2);
                graphics.drawRect(0, 0, n3 - 1, n4 - 1);
                graphics.setColor(color4);
                graphics.drawLine(1, 1, 1, n4 - 3);
                graphics.drawLine(2, 1, n3 - 3, 1);
                graphics.setColor(color3);
                graphics.drawLine(2, 2, 2, n4 - 4);
                graphics.drawLine(3, 2, n3 - 4, 2);
                graphics.setColor(color);
                graphics.drawLine(2, n4 - 3, n3 - 3, n4 - 3);
                graphics.drawLine(n3 - 3, 2, n3 - 3, n4 - 4);
                graphics.setColor(color2);
                graphics.drawLine(1, n4 - 2, n3 - 2, n4 - 2);
                graphics.drawLine(n3 - 2, n4 - 2, n3 - 2, 1);
            } else {
                graphics.setColor(color4);
                graphics.drawLine(0, 0, 0, n4 - 1);
                graphics.drawLine(1, 0, n3 - 2, 0);
                graphics.setColor(color3);
                graphics.drawLine(1, 1, 1, n4 - 3);
                graphics.drawLine(2, 1, n3 - 3, 1);
                graphics.setColor(color);
                graphics.drawLine(1, n4 - 2, n3 - 2, n4 - 2);
                graphics.drawLine(n3 - 2, 1, n3 - 2, n4 - 3);
                graphics.setColor(color2);
                graphics.drawLine(0, n4 - 1, n3 - 1, n4 - 1);
                graphics.drawLine(n3 - 1, n4 - 1, n3 - 1, 0);
            }
            graphics.translate(-n, -n2);
            graphics.setColor(color5);
        }
    }

    public static void drawLoweredBezel(Graphics graphics, int n, int n2, int n3, int n4, Color color, Color color2, Color color3, Color color4) {
        graphics.setColor(color2);
        graphics.drawLine(0, 0, 0, n4 - 1);
        graphics.drawLine(1, 0, n3 - 2, 0);
        graphics.setColor(color);
        graphics.drawLine(1, 1, 1, n4 - 2);
        graphics.drawLine(1, 1, n3 - 3, 1);
        graphics.setColor(color4);
        graphics.drawLine(0, n4 - 1, n3 - 1, n4 - 1);
        graphics.drawLine(n3 - 1, n4 - 1, n3 - 1, 0);
        graphics.setColor(color3);
        graphics.drawLine(1, n4 - 2, n3 - 2, n4 - 2);
        graphics.drawLine(n3 - 2, n4 - 2, n3 - 2, 1);
    }

    public static void drawString(Graphics graphics, String string, int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        Object object;
        int n7 = -1;
        if (n != 0) {
            char c = Character.toUpperCase((char)n);
            char c2 = Character.toLowerCase((char)n);
            int n8 = string.indexOf(c);
            int n9 = string.indexOf(c2);
            if (n8 == -1) {
                n7 = n9;
            } else if (n9 == -1) {
                n7 = n8;
            } else {
                int n10 = n7 = n9 < n8 ? n9 : n8;
            }
        }
        if (n7 < 0 || n7 >= string.length()) {
            graphics.drawString(string, n2, n3);
            return;
        }
        boolean bl = false;
        int n11 = 0;
        while (n11 < string.length()) {
            char c = string.charAt(n11);
            if (c >= '\u0590' && c < '\u109f') {
                bl = true;
                break;
            }
            ++n11;
        }
        if (!bl || !(graphics instanceof Graphics2D)) {
            graphics.drawString(string, n2, n3);
            object = graphics.getFontMetrics();
            n6 = n2 + ((FontMetrics)object).stringWidth(string.substring(0, n7));
            n5 = ((FontMetrics)object).charWidth(string.charAt(n7));
            n4 = ((FontMetrics)object).getDescent();
        } else {
            object = new TextLayout(string, graphics.getFont(), ((Graphics2D)graphics).getFontRenderContext());
            ((TextLayout)object).draw((Graphics2D)graphics, n2, n3);
            Shape shape = ((TextLayout)object).getLogicalHighlightShape(n7, n7 + 1);
            Rectangle rectangle = shape.getBounds();
            n6 = n2 + rectangle.x;
            n5 = rectangle.width;
            n4 = (int)((TextLayout)object).getDescent();
        }
        int n12 = n3 + n4 - 1;
        int n13 = 1;
        graphics.fillRect(n6, n12, n5, n13);
    }

    public static void drawDashedRect(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = n;
        while (n5 < n + n3) {
            graphics.drawLine(n5, n2, n5, n2);
            graphics.drawLine(n5, n2 + n4 - 1, n5, n2 + n4 - 1);
            n5 += 2;
        }
        int n6 = n2;
        while (n6 < n2 + n4) {
            graphics.drawLine(n, n6, n, n6);
            graphics.drawLine(n + n3 - 1, n6, n + n3 - 1, n6);
            n6 += 2;
        }
    }

    public static Dimension getPreferredButtonSize(AbstractButton abstractButton, int n) {
        if (abstractButton.getComponentCount() > 0) {
            return null;
        }
        Icon icon = abstractButton.getIcon();
        String string = abstractButton.getText();
        Font font = abstractButton.getFont();
        FontMetrics fontMetrics = abstractButton.getToolkit().getFontMetrics(font);
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
        SwingUtilities.layoutCompoundLabel(abstractButton, fontMetrics, string, icon, abstractButton.getVerticalAlignment(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalTextPosition(), abstractButton.getHorizontalTextPosition(), rectangle3, rectangle, rectangle2, string == null ? 0 : n);
        Rectangle rectangle4 = rectangle.union(rectangle2);
        Insets insets = abstractButton.getInsets();
        rectangle4.width += insets.left + insets.right;
        rectangle4.height += insets.top + insets.bottom;
        if (rectangle4.width % 2 == 0) {
            ++rectangle4.width;
        }
        if (rectangle4.height % 2 == 0) {
            ++rectangle4.height;
        }
        return rectangle4.getSize();
    }

    static boolean isLeftToRight(Component component) {
        return component.getComponentOrientation().isLeftToRight();
    }

    static void applyOrientation(Component component, ComponentOrientation componentOrientation) {
        component.setComponentOrientation(componentOrientation);
        if (component instanceof Container) {
            Container container = (Container)component;
            int n = container.getComponentCount();
            int n2 = 0;
            while (n2 < n) {
                BasicGraphicsUtils.applyOrientation(container.getComponent(n2), componentOrientation);
                ++n2;
            }
        }
    }
}

