/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class BasicInternalFrameTitlePane
extends JComponent {
    protected JMenuBar menuBar;
    protected JButton iconButton;
    protected JButton maxButton;
    protected JButton closeButton;
    protected JMenu windowMenu;
    protected JInternalFrame frame;
    protected Color selectedTitleColor;
    protected Color selectedTextColor;
    protected Color notSelectedTitleColor;
    protected Color notSelectedTextColor;
    protected Icon maxIcon;
    protected Icon minIcon;
    protected Icon iconIcon;
    protected Icon closeIcon;
    protected PropertyChangeListener propertyChangeListener;
    private DoubleClickAdapter doubleClickAdapter;
    protected Action closeAction;
    protected Action maximizeAction;
    protected Action iconifyAction;
    protected Action restoreAction;
    protected Action moveAction;
    protected Action sizeAction;
    protected static final String CLOSE_CMD = UIManager.getString("InternalFrame.closeText");
    protected static final String ICONIFY_CMD = UIManager.getString("InternalFrame.iconifyText");
    protected static final String RESTORE_CMD = UIManager.getString("InternalFrame.restoreText");
    protected static final String MAXIMIZE_CMD = UIManager.getString("InternalFrame.maximizeText");
    protected static final String MOVE_CMD = UIManager.getString("InternalFrame.moveText");
    protected static final String SIZE_CMD = UIManager.getString("InternalFrame.sizeText");
    static /* synthetic */ Class class$javax$swing$JInternalFrame;

    public BasicInternalFrameTitlePane(JInternalFrame jInternalFrame) {
        this.frame = jInternalFrame;
        this.installTitlePane();
    }

    protected void installTitlePane() {
        this.installDefaults();
        this.createActions();
        this.enableActions();
        this.createActionMap();
        this.setLayout(this.createLayout());
        this.assembleSystemMenu();
        this.createButtons();
        this.addSubComponents();
    }

    protected void addSubComponents() {
        this.add(this.menuBar);
        this.add(this.iconButton);
        this.add(this.maxButton);
        this.add(this.closeButton);
    }

    protected void createActions() {
        this.maximizeAction = new MaximizeAction();
        this.iconifyAction = new IconifyAction();
        this.closeAction = new CloseAction();
        this.restoreAction = new RestoreAction();
        this.moveAction = new MoveAction();
        this.sizeAction = new SizeAction();
    }

    ActionMap createActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("showSystemMenu", new ShowSystemMenuAction(true));
        actionMapUIResource.put("hideSystemMenu", new ShowSystemMenuAction(false));
        return actionMapUIResource;
    }

    protected void installListeners() {
        if (this.propertyChangeListener == null) {
            this.propertyChangeListener = this.createPropertyChangeListener();
        }
        this.frame.addPropertyChangeListener(this.propertyChangeListener);
    }

    protected void uninstallListeners() {
        this.frame.removePropertyChangeListener(this.propertyChangeListener);
    }

    protected void installDefaults() {
        this.maxIcon = UIManager.getIcon("InternalFrame.maximizeIcon");
        this.minIcon = UIManager.getIcon("InternalFrame.minimizeIcon");
        this.iconIcon = UIManager.getIcon("InternalFrame.iconifyIcon");
        this.closeIcon = UIManager.getIcon("InternalFrame.closeIcon");
        this.selectedTitleColor = UIManager.getColor("InternalFrame.activeTitleBackground");
        this.selectedTextColor = UIManager.getColor("InternalFrame.activeTitleForeground");
        this.notSelectedTitleColor = UIManager.getColor("InternalFrame.inactiveTitleBackground");
        this.notSelectedTextColor = UIManager.getColor("InternalFrame.inactiveTitleForeground");
    }

    protected void uninstallDefaults() {
    }

    public void addNotify() {
        super.addNotify();
        this.installListeners();
        this.addSystemMenuItems(this.windowMenu);
        if (this.doubleClickAdapter == null) {
            this.doubleClickAdapter = new DoubleClickAdapter();
            if (this.windowMenu != null) {
                this.windowMenu.addMouseListener(this.doubleClickAdapter);
            }
        }
        this.enableActions();
    }

    public void removeNotify() {
        super.removeNotify();
        if (this.doubleClickAdapter != null) {
            if (this.windowMenu != null) {
                this.windowMenu.removeMouseListener(this.doubleClickAdapter);
            }
            this.doubleClickAdapter = null;
        }
        if (this.windowMenu != null) {
            this.windowMenu.removeAll();
        }
        this.uninstallDefaults();
        this.uninstallListeners();
    }

    protected void createButtons() {
        this.iconButton = new NoFocusButton();
        this.iconButton.addActionListener(this.iconifyAction);
        this.maxButton = new NoFocusButton();
        this.maxButton.addActionListener(this.maximizeAction);
        this.closeButton = new NoFocusButton();
        this.closeButton.addActionListener(this.closeAction);
        this.setButtonIcons();
    }

    protected void setButtonIcons() {
        if (this.frame.isIcon()) {
            this.iconButton.setIcon(this.minIcon);
            this.maxButton.setIcon(this.maxIcon);
        } else if (this.frame.isMaximum()) {
            this.iconButton.setIcon(this.iconIcon);
            this.maxButton.setIcon(this.minIcon);
        } else {
            this.iconButton.setIcon(this.iconIcon);
            this.maxButton.setIcon(this.maxIcon);
        }
        this.closeButton.setIcon(this.closeIcon);
    }

    protected void assembleSystemMenu() {
        this.menuBar = this.createSystemMenuBar();
        this.windowMenu = this.createSystemMenu();
        this.menuBar.add(this.windowMenu);
        this.enableActions();
    }

    protected void addSystemMenuItems(JMenu jMenu) {
        JMenuItem jMenuItem = jMenu.add(this.restoreAction);
        jMenuItem.setMnemonic(UIManager.getString("InternalFrame.restoreTextMnemonic").charAt(0));
        jMenuItem = jMenu.add(this.moveAction);
        jMenuItem.setMnemonic(UIManager.getString("InternalFrame.moveTextMnemonic").charAt(0));
        jMenuItem = jMenu.add(this.sizeAction);
        jMenuItem.setMnemonic(UIManager.getString("InternalFrame.sizeTextMnemonic").charAt(0));
        jMenuItem = jMenu.add(this.iconifyAction);
        jMenuItem.setMnemonic(UIManager.getString("InternalFrame.iconifyTextMnemonic").charAt(0));
        jMenuItem = jMenu.add(this.maximizeAction);
        jMenuItem.setMnemonic(UIManager.getString("InternalFrame.maximizeTextMnemonic").charAt(0));
        jMenu.add(new JSeparator());
        jMenuItem = jMenu.add(this.closeAction);
        jMenuItem.setMnemonic(UIManager.getString("InternalFrame.closeTextMnemonic").charAt(0));
    }

    protected JMenu createSystemMenu() {
        return new JMenu("    ");
    }

    protected JMenuBar createSystemMenuBar() {
        this.menuBar = new SystemMenuBar();
        this.menuBar.setBorderPainted(false);
        return this.menuBar;
    }

    protected void showSystemMenu() {
        this.windowMenu.doClick();
    }

    public void paintComponent(Graphics graphics) {
        boolean bl = this.frame.isSelected();
        if (bl) {
            graphics.setColor(this.selectedTitleColor);
        } else {
            graphics.setColor(this.notSelectedTitleColor);
        }
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.frame.getTitle() != null) {
            Font font = graphics.getFont();
            graphics.setFont(UIManager.getFont("InternalFrame.titleFont"));
            if (bl) {
                graphics.setColor(this.selectedTextColor);
            } else {
                graphics.setColor(this.notSelectedTextColor);
            }
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n = fontMetrics.getHeight() - fontMetrics.getLeading();
            int n2 = (18 - n) / 2 + fontMetrics.getAscent() + fontMetrics.getLeading();
            String string = this.frame.getTitle().trim();
            int n3 = BasicGraphicsUtils.isLeftToRight(this.frame) ? this.menuBar.getX() + this.menuBar.getWidth() + 2 : this.menuBar.getX() - 2 - SwingUtilities.computeStringWidth(fontMetrics, string);
            String string2 = "...";
            int n4 = SwingUtilities.computeStringWidth(fontMetrics, string2);
            boolean bl2 = BasicGraphicsUtils.isLeftToRight(this.frame);
            Rectangle rectangle = graphics.getClip().getBounds();
            int n5 = this.getWidth();
            int n6 = SwingUtilities.computeStringWidth(fontMetrics, string);
            n5 -= bl2 ? 2 : -2;
            if (this.frame.isClosable()) {
                n5 -= bl2 ? 18 : -18;
            }
            if (this.frame.isMaximizable()) {
                n5 -= bl2 ? 18 : -18;
            }
            if (this.frame.isIconifiable()) {
                n5 -= bl2 ? 18 : -18;
            }
            int n7 = n5;
            if (n6 > (n7 -= bl2 ? n3 : -n3)) {
                String string3 = bl2 ? string.trim().concat(string2) : string2.concat(string.trim());
                int n8 = SwingUtilities.computeStringWidth(fontMetrics, string3);
                int n9 = (int)((float)n7 / (float)n8 * (float)string3.length()) + 1;
                while (n8 > n7 && n9 > string2.length() + 1) {
                    string3 = string.substring(0, --n9 - string2.length());
                    string3 = bl2 ? string3.concat(string2) : string2.concat(string3);
                    n8 = SwingUtilities.computeStringWidth(fontMetrics, string3);
                }
                string = string3;
                graphics.setClip(rectangle.x, rectangle.y, n5, rectangle.height);
            }
            graphics.drawString(string, n3, n2);
            if (n6 > n7) {
                graphics.setClip(rectangle);
            }
            graphics.setFont(font);
        }
    }

    protected void postClosingEvent(JInternalFrame jInternalFrame) {
        InternalFrameEvent internalFrameEvent = new InternalFrameEvent(jInternalFrame, 25550);
        if ((class$javax$swing$JInternalFrame == null ? (class$javax$swing$JInternalFrame = BasicInternalFrameTitlePane.class$("javax.swing.JInternalFrame")) : class$javax$swing$JInternalFrame).getClassLoader() == null) {
            try {
                Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(internalFrameEvent);
                return;
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        jInternalFrame.dispatchEvent(internalFrameEvent);
    }

    protected void enableActions() {
        this.restoreAction.setEnabled(this.frame.isMaximum() || this.frame.isIcon());
        this.maximizeAction.setEnabled(this.frame.isMaximizable() && !this.frame.isMaximum());
        this.iconifyAction.setEnabled(this.frame.isIconifiable() && !this.frame.isIcon());
        this.closeAction.setEnabled(this.frame.isClosable());
        this.sizeAction.setEnabled(false);
        this.moveAction.setEnabled(false);
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    protected LayoutManager createLayout() {
        return new TitlePaneLayout();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class DoubleClickAdapter
    extends MouseInputAdapter {
        private DoubleClickAdapter() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (BasicInternalFrameTitlePane.this.frame.isClosable() & mouseEvent.getClickCount() == 2) {
                try {
                    BasicInternalFrameTitlePane.this.frame.setClosed(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                BasicInternalFrameTitlePane.this.windowMenu.setVisible(false);
            }
        }
    }

    private class NoFocusButton
    extends JButton {
        public NoFocusButton() {
            this.setFocusPainted(false);
        }

        public boolean isFocusTraversable() {
            return false;
        }

        public void requestFocus() {
        }

        public boolean isOpaque() {
            return true;
        }
    }

    public class SystemMenuBar
    extends JMenuBar {
        public boolean isFocusTraversable() {
            return false;
        }

        public void requestFocus() {
        }

        public void paint(Graphics graphics) {
            Icon icon = BasicInternalFrameTitlePane.this.frame.getFrameIcon();
            if (icon == null) {
                icon = UIManager.getIcon("InternalFrame.icon");
            }
            if (icon != null) {
                if (icon instanceof ImageIcon && (icon.getIconWidth() > 16 || icon.getIconHeight() > 16)) {
                    Image image = ((ImageIcon)icon).getImage();
                    ((ImageIcon)icon).setImage(image.getScaledInstance(16, 16, 4));
                }
                icon.paintIcon(this, graphics, 0, 0);
            }
        }

        public boolean isOpaque() {
            return true;
        }
    }

    public class SizeAction
    extends AbstractAction {
        public SizeAction() {
            super(SIZE_CMD);
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    private class ShowSystemMenuAction
    extends AbstractAction {
        private boolean show;

        public ShowSystemMenuAction(boolean bl) {
            this.show = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.show) {
                BasicInternalFrameTitlePane.this.windowMenu.doClick();
            } else {
                BasicInternalFrameTitlePane.this.windowMenu.setVisible(false);
            }
        }
    }

    public class MoveAction
    extends AbstractAction {
        public MoveAction() {
            super(MOVE_CMD);
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    public class RestoreAction
    extends AbstractAction {
        public RestoreAction() {
            super(RESTORE_CMD);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (BasicInternalFrameTitlePane.this.frame.isMaximizable() && BasicInternalFrameTitlePane.this.frame.isMaximum()) {
                try {
                    BasicInternalFrameTitlePane.this.frame.setMaximum(false);
                }
                catch (PropertyVetoException propertyVetoException) {}
            } else if (BasicInternalFrameTitlePane.this.frame.isIconifiable() && BasicInternalFrameTitlePane.this.frame.isIcon()) {
                try {
                    BasicInternalFrameTitlePane.this.frame.setIcon(false);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }
    }

    public class IconifyAction
    extends AbstractAction {
        public IconifyAction() {
            super(ICONIFY_CMD);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (BasicInternalFrameTitlePane.this.frame.isIconifiable()) {
                if (!BasicInternalFrameTitlePane.this.frame.isIcon()) {
                    try {
                        BasicInternalFrameTitlePane.this.frame.setIcon(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                } else {
                    try {
                        BasicInternalFrameTitlePane.this.frame.setIcon(false);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public class MaximizeAction
    extends AbstractAction {
        public MaximizeAction() {
            super(MAXIMIZE_CMD);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (BasicInternalFrameTitlePane.this.frame.isMaximizable()) {
                if (!BasicInternalFrameTitlePane.this.frame.isMaximum()) {
                    try {
                        BasicInternalFrameTitlePane.this.frame.setMaximum(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                } else {
                    try {
                        if (BasicInternalFrameTitlePane.this.frame.isIconifiable() && BasicInternalFrameTitlePane.this.frame.isIcon()) {
                            BasicInternalFrameTitlePane.this.frame.setIcon(false);
                        } else {
                            BasicInternalFrameTitlePane.this.frame.setMaximum(false);
                        }
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super(CLOSE_CMD);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (BasicInternalFrameTitlePane.this.frame.isClosable()) {
                BasicInternalFrameTitlePane.this.frame.doDefaultCloseAction();
            }
        }
    }

    public class TitlePaneLayout
    implements LayoutManager {
        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            return new Dimension(100, 18);
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        public void layoutContainer(Container container) {
            boolean bl = BasicGraphicsUtils.isLeftToRight(BasicInternalFrameTitlePane.this.frame);
            int n = BasicInternalFrameTitlePane.this.getWidth();
            int n2 = bl ? 2 : n - 16 - 2;
            BasicInternalFrameTitlePane.this.menuBar.setBounds(n2, 1, 16, 16);
            int n3 = n2 = bl ? n - 16 - 2 : 2;
            if (BasicInternalFrameTitlePane.this.frame.isClosable()) {
                BasicInternalFrameTitlePane.this.closeButton.setBounds(n2, 2, 16, 14);
                n2 += bl ? -18 : 18;
            }
            if (BasicInternalFrameTitlePane.this.frame.isMaximizable()) {
                BasicInternalFrameTitlePane.this.maxButton.setBounds(n2, 2, 16, 14);
                n2 += bl ? -18 : 18;
            }
            if (BasicInternalFrameTitlePane.this.frame.isIconifiable()) {
                BasicInternalFrameTitlePane.this.iconButton.setBounds(n2, 2, 16, 14);
            }
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("selected".equals(string)) {
                BasicInternalFrameTitlePane.this.repaint();
                return;
            }
            if ("icon".equals(string) || "maximum".equals(string)) {
                BasicInternalFrameTitlePane.this.setButtonIcons();
                BasicInternalFrameTitlePane.this.enableActions();
                return;
            }
            if (string.equals("closable")) {
                if ((Boolean)propertyChangeEvent.getNewValue() == Boolean.TRUE) {
                    BasicInternalFrameTitlePane.this.add(BasicInternalFrameTitlePane.this.closeButton);
                } else {
                    BasicInternalFrameTitlePane.this.remove(BasicInternalFrameTitlePane.this.closeButton);
                }
            } else if (string.equals("maximizable")) {
                if ((Boolean)propertyChangeEvent.getNewValue() == Boolean.TRUE) {
                    BasicInternalFrameTitlePane.this.add(BasicInternalFrameTitlePane.this.maxButton);
                } else {
                    BasicInternalFrameTitlePane.this.remove(BasicInternalFrameTitlePane.this.maxButton);
                }
            } else if (string.equals("iconifiable")) {
                if ((Boolean)propertyChangeEvent.getNewValue() == Boolean.TRUE) {
                    BasicInternalFrameTitlePane.this.add(BasicInternalFrameTitlePane.this.iconButton);
                } else {
                    BasicInternalFrameTitlePane.this.remove(BasicInternalFrameTitlePane.this.iconButton);
                }
            }
            BasicInternalFrameTitlePane.this.enableActions();
            BasicInternalFrameTitlePane.this.revalidate();
            BasicInternalFrameTitlePane.this.repaint();
        }
    }
}

