/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.font.TextAttribute;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentInputMapUIResource;
import javax.swing.plaf.InputMapUIResource;
import javax.swing.plaf.TextUI;
import javax.swing.plaf.UIResource;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public abstract class BasicTextUI
extends TextUI
implements ViewFactory {
    static final String LTRName = "ltr orientation";
    static final String ComplexName = "complex text";
    static final String ContextualName = "contextual line direction";
    boolean docIsComplex;
    boolean docIsComplexLock;
    private static final EditorKit defaultKit = new DefaultEditorKit();
    transient JTextComponent editor;
    transient boolean painted = false;
    transient RootView rootView = new RootView();
    transient UpdateHandler updateHandler = new UpdateHandler();
    private static final Position.Bias[] discardBias = new Position.Bias[1];

    protected Caret createCaret() {
        return new BasicCaret();
    }

    protected Highlighter createHighlighter() {
        return new BasicHighlighter();
    }

    protected String getKeymapName() {
        String string = this.getClass().getName();
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            string = string.substring(n + 1, string.length());
        }
        return string;
    }

    protected Keymap createKeymap() {
        String string = this.getKeymapName();
        Keymap keymap = JTextComponent.getKeymap(string);
        if (keymap == null) {
            Keymap keymap2 = JTextComponent.getKeymap("default");
            keymap = JTextComponent.addKeymap(string, keymap2);
            String string2 = this.getPropertyPrefix();
            Object object = UIManager.get(string2 + ".keyBindings");
            if (object != null && object instanceof JTextComponent.KeyBinding[]) {
                JTextComponent.KeyBinding[] keyBindingArray = (JTextComponent.KeyBinding[])object;
                JTextComponent.loadKeymap(keymap, keyBindingArray, this.getComponent().getActions());
            }
        }
        return keymap;
    }

    protected void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals(LTRName) || string.equals(ComplexName) || string.equals(ContextualName)) {
            this.modelChanged();
            this.getComponent().repaint();
        }
    }

    protected abstract String getPropertyPrefix();

    protected void installDefaults() {
        Object object;
        Caret caret;
        Insets insets;
        Border border;
        Color color;
        Color color2;
        Color color3;
        Color color4;
        Color color5;
        Color color6;
        String string = this.getPropertyPrefix();
        Font font = this.editor.getFont();
        if (font == null || font instanceof UIResource) {
            this.editor.setFont(UIManager.getFont(string + ".font"));
        }
        if ((color6 = this.editor.getBackground()) == null || color6 instanceof UIResource) {
            this.editor.setBackground(UIManager.getColor(string + ".background"));
        }
        if ((color5 = this.editor.getForeground()) == null || color5 instanceof UIResource) {
            this.editor.setForeground(UIManager.getColor(string + ".foreground"));
        }
        if ((color4 = this.editor.getCaretColor()) == null || color4 instanceof UIResource) {
            this.editor.setCaretColor(UIManager.getColor(string + ".caretForeground"));
        }
        if ((color3 = this.editor.getSelectionColor()) == null || color3 instanceof UIResource) {
            this.editor.setSelectionColor(UIManager.getColor(string + ".selectionBackground"));
        }
        if ((color2 = this.editor.getSelectedTextColor()) == null || color2 instanceof UIResource) {
            this.editor.setSelectedTextColor(UIManager.getColor(string + ".selectionForeground"));
        }
        if ((color = this.editor.getDisabledTextColor()) == null || color instanceof UIResource) {
            this.editor.setDisabledTextColor(UIManager.getColor(string + ".inactiveForeground"));
        }
        if ((border = this.editor.getBorder()) == null || border instanceof UIResource) {
            this.editor.setBorder(UIManager.getBorder(string + ".border"));
        }
        if ((insets = this.editor.getMargin()) == null || insets instanceof UIResource) {
            this.editor.setMargin(UIManager.getInsets(string + ".margin"));
        }
        if ((caret = this.editor.getCaret()) == null || caret instanceof UIResource) {
            caret = this.createCaret();
            this.editor.setCaret(caret);
            object = UIManager.get(string + ".caretBlinkRate");
            if (object != null && object instanceof Integer) {
                Integer n = (Integer)object;
                caret.setBlinkRate(n);
            }
        }
        if ((object = this.editor.getHighlighter()) == null || object instanceof UIResource) {
            this.editor.setHighlighter(this.createHighlighter());
        }
    }

    protected void uninstallDefaults() {
        if (this.editor.getCaretColor() instanceof UIResource) {
            this.editor.setCaretColor(null);
        }
        if (this.editor.getSelectionColor() instanceof UIResource) {
            this.editor.setSelectionColor(null);
        }
        if (this.editor.getDisabledTextColor() instanceof UIResource) {
            this.editor.setDisabledTextColor(null);
        }
        if (this.editor.getSelectedTextColor() instanceof UIResource) {
            this.editor.setSelectedTextColor(null);
        }
        if (this.editor.getBorder() instanceof UIResource) {
            this.editor.setBorder(null);
        }
        if (this.editor.getMargin() instanceof UIResource) {
            this.editor.setMargin(null);
        }
        if (this.editor.getCaret() instanceof UIResource) {
            this.editor.setCaret(null);
        }
        if (this.editor.getHighlighter() instanceof UIResource) {
            this.editor.setHighlighter(null);
        }
    }

    protected void installListeners() {
    }

    protected void uninstallListeners() {
    }

    protected void installKeyboardActions() {
        ActionMap actionMap;
        this.editor.setKeymap(this.createKeymap());
        InputMap inputMap = this.getInputMap();
        if (inputMap != null) {
            SwingUtilities.replaceUIInputMap(this.editor, 0, inputMap);
        }
        if ((actionMap = this.getActionMap()) != null) {
            SwingUtilities.replaceUIActionMap(this.editor, actionMap);
        }
        this.updateFocusAcceleratorBinding(false);
    }

    InputMap getInputMap() {
        InputMapUIResource inputMapUIResource = new InputMapUIResource();
        InputMap inputMap = (InputMap)UIManager.get(this.getPropertyPrefix() + ".focusInputMap");
        if (inputMap != null) {
            inputMapUIResource.setParent(inputMap);
        }
        return inputMapUIResource;
    }

    void updateFocusAcceleratorBinding(boolean bl) {
        char c = this.editor.getFocusAccelerator();
        if (bl || c != '\u0000') {
            InputMap inputMap = SwingUtilities.getUIInputMap(this.editor, 2);
            if (inputMap == null && c != '\u0000') {
                inputMap = new ComponentInputMapUIResource(this.editor);
                SwingUtilities.replaceUIInputMap(this.editor, 2, inputMap);
                ActionMap actionMap = this.getActionMap();
                SwingUtilities.replaceUIActionMap(this.editor, actionMap);
            }
            if (inputMap != null) {
                inputMap.clear();
                if (c != '\u0000') {
                    inputMap.put(KeyStroke.getKeyStroke((int)c, 8), "requestFocus");
                }
            }
        }
    }

    ActionMap getActionMap() {
        String string = this.getPropertyPrefix() + ".actionMap";
        ActionMap actionMap = (ActionMap)UIManager.get(string);
        if (actionMap == null && (actionMap = this.createActionMap()) != null) {
            UIManager.put(string, actionMap);
        }
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("requestFocus", new FocusAction());
        if (actionMap != null) {
            actionMapUIResource.setParent(actionMap);
        }
        return actionMapUIResource;
    }

    ActionMap createActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        Action[] actionArray = this.editor.getActions();
        int n = actionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Action action = actionArray[n2];
            actionMapUIResource.put(action.getValue("Name"), action);
            ++n2;
        }
        return actionMapUIResource;
    }

    protected void uninstallKeyboardActions() {
        this.editor.setKeymap(null);
        SwingUtilities.replaceUIInputMap(this.editor, 2, null);
        SwingUtilities.replaceUIActionMap(this.editor, null);
    }

    protected void paintBackground(Graphics graphics) {
        graphics.setColor(this.editor.getBackground());
        graphics.fillRect(0, 0, this.editor.getWidth(), this.editor.getHeight());
    }

    protected final JTextComponent getComponent() {
        return this.editor;
    }

    protected void modelChanged() {
        ViewFactory viewFactory = this.rootView.getViewFactory();
        Document document = this.editor.getDocument();
        Element element = document.getDefaultRootElement();
        this.setView(viewFactory.create(element));
    }

    protected final void setView(View view) {
        this.editor.removeAll();
        this.rootView.setView(view);
        this.painted = false;
        this.editor.revalidate();
        this.editor.repaint();
    }

    protected void paintSafely(Graphics graphics) {
        this.painted = true;
        Highlighter highlighter = this.editor.getHighlighter();
        Caret caret = this.editor.getCaret();
        if (this.editor.isOpaque()) {
            this.paintBackground(graphics);
        }
        if (highlighter != null) {
            highlighter.paint(graphics);
        }
        Rectangle rectangle = this.getVisibleEditorRect();
        this.rootView.paint(graphics, rectangle);
        if (caret != null) {
            caret.paint(graphics);
        }
    }

    boolean computeIsDocComplex(Document document, int n, int n2) {
        boolean bl = false;
        if (document instanceof AbstractDocument) {
            AbstractDocument abstractDocument = (AbstractDocument)document;
            Object object = abstractDocument.getProperty(LTRName);
            bl = Boolean.FALSE.equals(object);
            if (!bl) {
                AbstractDocument.AbstractElement abstractElement;
                Integer n3;
                Element element = abstractDocument.getBidiRootElement();
                boolean bl2 = bl = element.getElementCount() > 1;
                if (!bl && (n3 = (Integer)(abstractElement = (AbstractDocument.AbstractElement)element.getElement(0)).getAttribute(StyleConstants.BidiLevel)) != null) {
                    boolean bl3 = bl = (n3 & 1) != 0;
                }
            }
            if (!bl && (bl = BasicTextUI.docHasHindiOrThai(document, n, n2))) {
                this.docIsComplexLock = true;
            }
        }
        return bl;
    }

    static boolean docHasHindiOrThai(Document document, int n, int n2) {
        Segment segment = new Segment();
        try {
            ((AbstractDocument)document).getText(n, n2, segment);
            int n3 = segment.offset;
            int n4 = n3 + segment.count;
            while (n3 < n4) {
                char c = segment.array[n3];
                if (c >= '\u0900' && c < '\u0e80') {
                    return true;
                }
                ++n3;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return false;
    }

    void updateDocIsComplex(int n, int n2) {
        Document document;
        if (!this.docIsComplexLock && this.editor != null && (document = this.editor.getDocument()) != null) {
            if (n2 <= 0) {
                n2 = document.getLength();
            }
            this.docIsComplex = this.computeIsDocComplex(document, n, n2);
        }
    }

    public void installUI(JComponent jComponent) {
        if (jComponent instanceof JTextComponent) {
            this.editor = (JTextComponent)jComponent;
            this.installDefaults();
            this.editor.setOpaque(true);
            this.editor.setAutoscrolls(true);
            this.editor.addPropertyChangeListener(this.updateHandler);
            Document document = this.editor.getDocument();
            if (document == null) {
                this.editor.setDocument(this.getEditorKit(this.editor).createDefaultDocument());
            } else {
                document.addDocumentListener(this.updateHandler);
                this.modelChanged();
            }
            this.installListeners();
            this.installKeyboardActions();
            LayoutManager layoutManager = this.editor.getLayout();
            if (layoutManager == null || layoutManager instanceof UIResource) {
                this.editor.setLayout(this.updateHandler);
            }
        } else {
            throw new Error("TextUI needs JTextComponent");
        }
    }

    public void uninstallUI(JComponent jComponent) {
        this.editor.removePropertyChangeListener(this.updateHandler);
        this.editor.getDocument().removeDocumentListener(this.updateHandler);
        this.painted = false;
        this.uninstallDefaults();
        this.rootView.setView(null);
        jComponent.removeAll();
        LayoutManager layoutManager = jComponent.getLayout();
        if (layoutManager instanceof UIResource) {
            jComponent.setLayout(null);
        }
        this.uninstallKeyboardActions();
        this.uninstallListeners();
    }

    public void update(Graphics graphics, JComponent jComponent) {
        this.paint(graphics, jComponent);
    }

    public final void paint(Graphics graphics, JComponent jComponent) {
        if (this.rootView.getViewCount() > 0 && this.rootView.getView(0) != null) {
            Document document = this.editor.getDocument();
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).readLock();
            }
            try {
                this.paintSafely(graphics);
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (document instanceof AbstractDocument) {
                    ((AbstractDocument)document).readUnlock();
                }
                throw throwable;
            }
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).readUnlock();
            }
        }
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Document document = this.editor.getDocument();
        Insets insets = jComponent.getInsets();
        Dimension dimension = jComponent.getSize();
        if (document instanceof AbstractDocument) {
            ((AbstractDocument)document).readLock();
        }
        try {
            if (dimension.width > insets.left + insets.right && dimension.height > insets.top + insets.bottom) {
                this.rootView.setSize(dimension.width - insets.left - insets.right, dimension.height - insets.top - insets.bottom);
            }
            dimension.width = (int)Math.min((long)this.rootView.getPreferredSpan(0) + (long)insets.left + (long)insets.right, Integer.MAX_VALUE);
            dimension.height = (int)Math.min((long)this.rootView.getPreferredSpan(1) + (long)insets.top + (long)insets.bottom, Integer.MAX_VALUE);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).readUnlock();
            }
            throw throwable;
        }
        if (document instanceof AbstractDocument) {
            ((AbstractDocument)document).readUnlock();
        }
        return dimension;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        Document document = this.editor.getDocument();
        Insets insets = jComponent.getInsets();
        Dimension dimension = new Dimension();
        if (document instanceof AbstractDocument) {
            ((AbstractDocument)document).readLock();
        }
        try {
            dimension.width = (int)this.rootView.getMinimumSpan(0) + insets.left + insets.right;
            dimension.height = (int)this.rootView.getMinimumSpan(1) + insets.top + insets.bottom;
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).readUnlock();
            }
            throw throwable;
        }
        if (document instanceof AbstractDocument) {
            ((AbstractDocument)document).readUnlock();
        }
        return dimension;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        Document document = this.editor.getDocument();
        Insets insets = jComponent.getInsets();
        Dimension dimension = new Dimension();
        if (document instanceof AbstractDocument) {
            ((AbstractDocument)document).readLock();
        }
        try {
            dimension.width = (int)Math.min((long)this.rootView.getMaximumSpan(0) + (long)insets.left + (long)insets.right, Integer.MAX_VALUE);
            dimension.height = (int)Math.min((long)this.rootView.getMaximumSpan(1) + (long)insets.top + (long)insets.bottom, Integer.MAX_VALUE);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).readUnlock();
            }
            throw throwable;
        }
        if (document instanceof AbstractDocument) {
            ((AbstractDocument)document).readUnlock();
        }
        return dimension;
    }

    protected Rectangle getVisibleEditorRect() {
        Rectangle rectangle = this.editor.getBounds();
        if (rectangle.width > 0 && rectangle.height > 0) {
            rectangle.y = 0;
            rectangle.x = 0;
            Insets insets = this.editor.getInsets();
            rectangle.x += insets.left;
            rectangle.y += insets.top;
            rectangle.width -= insets.left + insets.right;
            rectangle.height -= insets.top + insets.bottom;
            return rectangle;
        }
        return null;
    }

    public Rectangle modelToView(JTextComponent jTextComponent, int n) throws BadLocationException {
        return this.modelToView(jTextComponent, n, Position.Bias.Forward);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Rectangle modelToView(JTextComponent jTextComponent, int n, Position.Bias bias) throws BadLocationException {
        Document document;
        block3: {
            Rectangle rectangle;
            document = this.editor.getDocument();
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).readLock();
            }
            try {
                Rectangle rectangle2 = this.getVisibleEditorRect();
                if (rectangle2 == null) break block3;
                this.rootView.setSize(rectangle2.width, rectangle2.height);
                Shape shape = this.rootView.modelToView(n, rectangle2, bias);
                if (shape == null) break block3;
                rectangle = shape.getBounds();
                Object var9_8 = null;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                if (!(document instanceof AbstractDocument)) throw throwable;
                ((AbstractDocument)document).readUnlock();
                throw throwable;
            }
            if (!(document instanceof AbstractDocument)) return rectangle;
            ((AbstractDocument)document).readUnlock();
            return rectangle;
        }
        Object var9_9 = null;
        if (!(document instanceof AbstractDocument)) return null;
        ((AbstractDocument)document).readUnlock();
        return null;
    }

    public int viewToModel(JTextComponent jTextComponent, Point point) {
        return this.viewToModel(jTextComponent, point, discardBias);
    }

    public int viewToModel(JTextComponent jTextComponent, Point point, Position.Bias[] biasArray) {
        int n = -1;
        Document document = this.editor.getDocument();
        if (document instanceof AbstractDocument) {
            ((AbstractDocument)document).readLock();
        }
        try {
            Rectangle rectangle = this.getVisibleEditorRect();
            if (rectangle != null) {
                this.rootView.setSize(rectangle.width, rectangle.height);
                n = this.rootView.viewToModel(point.x, point.y, rectangle, biasArray);
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).readUnlock();
            }
            throw throwable;
        }
        if (document instanceof AbstractDocument) {
            ((AbstractDocument)document).readUnlock();
        }
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getNextVisualPositionFrom(JTextComponent jTextComponent, int n, Position.Bias bias, int n2, Position.Bias[] biasArray) throws BadLocationException {
        Document document;
        block4: {
            int n3;
            document = this.editor.getDocument();
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).readLock();
            }
            try {
                if (!this.painted) break block4;
                Rectangle rectangle = this.getVisibleEditorRect();
                if (rectangle == null) {
                    throw new BadLocationException("no visible rect", 0);
                }
                this.rootView.setSize(rectangle.width, rectangle.height);
                n3 = this.rootView.getNextVisualPositionFrom(n, bias, rectangle, n2, biasArray);
                Object var10_9 = null;
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                if (!(document instanceof AbstractDocument)) throw throwable;
                ((AbstractDocument)document).readUnlock();
                throw throwable;
            }
            if (!(document instanceof AbstractDocument)) return n3;
            ((AbstractDocument)document).readUnlock();
            return n3;
        }
        Object var10_10 = null;
        if (!(document instanceof AbstractDocument)) return -1;
        ((AbstractDocument)document).readUnlock();
        return -1;
    }

    public void damageRange(JTextComponent jTextComponent, int n, int n2) {
        this.damageRange(jTextComponent, n, n2, Position.Bias.Forward, Position.Bias.Backward);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void damageRange(JTextComponent jTextComponent, int n, int n2, Position.Bias bias, Position.Bias bias2) {
        if (!this.painted) return;
        Rectangle rectangle = this.getVisibleEditorRect();
        Document document = jTextComponent.getDocument();
        if (document instanceof AbstractDocument) {
            ((AbstractDocument)document).readLock();
        }
        try {
            try {
                this.rootView.setSize(rectangle.width, rectangle.height);
                Shape shape = this.rootView.modelToView(n, bias, n2, bias2, rectangle);
                Rectangle rectangle2 = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
                this.editor.repaint(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            }
            catch (BadLocationException badLocationException) {
                Object var11_12 = null;
                if (!(document instanceof AbstractDocument)) return;
                ((AbstractDocument)document).readUnlock();
                return;
            }
            Object var11_11 = null;
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            if (!(document instanceof AbstractDocument)) throw throwable;
            ((AbstractDocument)document).readUnlock();
            throw throwable;
        }
        if (!(document instanceof AbstractDocument)) return;
        ((AbstractDocument)document).readUnlock();
    }

    public EditorKit getEditorKit(JTextComponent jTextComponent) {
        return defaultKit;
    }

    public View getRootView(JTextComponent jTextComponent) {
        return this.rootView;
    }

    public View create(Element element) {
        return null;
    }

    public View create(Element element, int n, int n2) {
        return null;
    }

    class FocusAction
    extends AbstractAction {
        FocusAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            BasicTextUI.this.editor.requestFocus();
        }

        public boolean isEnabled() {
            return BasicTextUI.this.editor.isEditable();
        }
    }

    class UpdateHandler
    implements PropertyChangeListener,
    DocumentListener,
    LayoutManager2,
    Runnable,
    UIResource {
        private Hashtable constraints;
        private boolean i18nView = false;

        UpdateHandler() {
        }

        public final void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object = propertyChangeEvent.getOldValue();
            Object object2 = propertyChangeEvent.getNewValue();
            if (object instanceof Document || object2 instanceof Document) {
                if (object != null) {
                    ((Document)object).removeDocumentListener(this);
                }
                if (object2 != null) {
                    ((Document)object2).addDocumentListener(this);
                }
                this.i18nView = false;
                BasicTextUI.this.updateDocIsComplex(0, 0);
                BasicTextUI.this.modelChanged();
            } else if (BasicTextUI.LTRName.equals(propertyChangeEvent.getPropertyName())) {
                BasicTextUI.this.updateDocIsComplex(0, 0);
            }
            if ("focusAcceleratorKey".equals(propertyChangeEvent.getPropertyName())) {
                BasicTextUI.this.updateFocusAcceleratorBinding(true);
            } else if ("componentOrientation".equals(propertyChangeEvent.getPropertyName())) {
                ComponentOrientation componentOrientation = (ComponentOrientation)propertyChangeEvent.getNewValue();
                Boolean bl = componentOrientation.isLeftToRight() ? TextAttribute.RUN_DIRECTION_LTR : TextAttribute.RUN_DIRECTION_RTL;
                Document document = BasicTextUI.this.editor.getDocument();
                document.putProperty(TextAttribute.RUN_DIRECTION, bl);
                BasicTextUI.this.modelChanged();
            }
            BasicTextUI.this.propertyChange(propertyChangeEvent);
        }

        public final void insertUpdate(DocumentEvent documentEvent) {
            Boolean bl;
            Document document = documentEvent.getDocument();
            Object object = document.getProperty("i18n");
            if (object instanceof Boolean && (bl = (Boolean)object) != this.i18nView) {
                this.i18nView = bl;
                ViewFactory viewFactory = BasicTextUI.this.rootView.getViewFactory();
                Document document2 = BasicTextUI.this.editor.getDocument();
                Element element = document2.getDefaultRootElement();
                View view = viewFactory.create(element);
                BasicTextUI.this.rootView.setView(view);
                BasicTextUI.this.painted = false;
                BasicTextUI.this.editor.revalidate();
                BasicTextUI.this.editor.repaint();
                return;
            }
            bl = BasicTextUI.this.painted ? BasicTextUI.this.getVisibleEditorRect() : null;
            BasicTextUI.this.rootView.insertUpdate(documentEvent, (Shape)((Object)bl), BasicTextUI.this.rootView.getViewFactory());
        }

        public final void removeUpdate(DocumentEvent documentEvent) {
            if (BasicTextUI.this.docIsComplex) {
                BasicTextUI.this.updateDocIsComplex(0, 0);
                if (!BasicTextUI.this.docIsComplex) {
                    BasicTextUI.this.getComponent().firePropertyChange(BasicTextUI.ComplexName, true, false);
                }
            }
            if (this.constraints != null && !this.constraints.isEmpty()) {
                if (SwingUtilities.isEventDispatchThread()) {
                    this.run();
                } else {
                    SwingUtilities.invokeLater(this);
                }
            }
            Rectangle rectangle = BasicTextUI.this.painted ? BasicTextUI.this.getVisibleEditorRect() : null;
            BasicTextUI.this.rootView.removeUpdate(documentEvent, rectangle, BasicTextUI.this.rootView.getViewFactory());
        }

        public final void changedUpdate(DocumentEvent documentEvent) {
            boolean bl = BasicTextUI.this.docIsComplex;
            int n = 0;
            int n2 = 0;
            if (!BasicTextUI.this.docIsComplex) {
                n = documentEvent.getOffset();
                n2 = documentEvent.getLength();
            }
            BasicTextUI.this.updateDocIsComplex(n, n2);
            if (bl != BasicTextUI.this.docIsComplex) {
                BasicTextUI.this.getComponent().firePropertyChange(BasicTextUI.ComplexName, bl, BasicTextUI.this.docIsComplex);
            }
            Rectangle rectangle = BasicTextUI.this.painted ? BasicTextUI.this.getVisibleEditorRect() : null;
            BasicTextUI.this.rootView.changedUpdate(documentEvent, rectangle, BasicTextUI.this.rootView.getViewFactory());
        }

        public void run() {
            Vector vector = null;
            Enumeration enumeration = this.constraints.keys();
            while (enumeration.hasMoreElements()) {
                Component component = (Component)enumeration.nextElement();
                View view = (View)this.constraints.get(component);
                if (view.getStartOffset() != view.getEndOffset()) continue;
                if (vector == null) {
                    vector = new Vector();
                }
                vector.addElement(component);
            }
            if (vector != null) {
                int n = vector.size();
                int n2 = 0;
                while (n2 < n) {
                    BasicTextUI.this.editor.remove((Component)vector.elementAt(n2));
                    ++n2;
                }
            }
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
            if (this.constraints != null) {
                this.constraints.remove(component);
            }
        }

        public Dimension preferredLayoutSize(Container container) {
            return null;
        }

        public Dimension minimumLayoutSize(Container container) {
            return null;
        }

        public void layoutContainer(Container container) {
            Rectangle rectangle;
            if (this.constraints != null && !this.constraints.isEmpty() && (rectangle = BasicTextUI.this.getVisibleEditorRect()) != null) {
                Document document = BasicTextUI.this.editor.getDocument();
                if (document instanceof AbstractDocument) {
                    ((AbstractDocument)document).readLock();
                }
                try {
                    BasicTextUI.this.rootView.setSize(rectangle.width, rectangle.height);
                    Enumeration enumeration = this.constraints.keys();
                    while (enumeration.hasMoreElements()) {
                        Component component = (Component)enumeration.nextElement();
                        View view = (View)this.constraints.get(component);
                        Shape shape = this.calculateViewPosition(rectangle, view);
                        if (shape == null) continue;
                        Rectangle rectangle2 = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
                        component.setBounds(rectangle2);
                    }
                    Object var10_9 = null;
                }
                catch (Throwable throwable) {
                    Object var10_10 = null;
                    if (document instanceof AbstractDocument) {
                        ((AbstractDocument)document).readUnlock();
                    }
                    throw throwable;
                }
                if (document instanceof AbstractDocument) {
                    ((AbstractDocument)document).readUnlock();
                }
            }
        }

        Shape calculateViewPosition(Shape shape, View view) {
            int n = view.getStartOffset();
            View view2 = null;
            View view3 = BasicTextUI.this.rootView;
            while (view3 != null && view3 != view) {
                int n2 = ((View)view3).getViewIndex(n, Position.Bias.Forward);
                shape = ((View)view3).getChildAllocation(n2, shape);
                view2 = ((View)view3).getView(n2);
                view3 = view2;
            }
            return view2 != null ? shape : null;
        }

        public void addLayoutComponent(Component component, Object object) {
            if (object instanceof View) {
                if (this.constraints == null) {
                    this.constraints = new Hashtable(7);
                }
                this.constraints.put(component, object);
            }
        }

        public Dimension maximumLayoutSize(Container container) {
            return null;
        }

        public float getLayoutAlignmentX(Container container) {
            return 0.5f;
        }

        public float getLayoutAlignmentY(Container container) {
            return 0.5f;
        }

        public void invalidateLayout(Container container) {
        }
    }

    class RootView
    extends View {
        private View view;

        RootView() {
            super(null);
        }

        void setView(View view) {
            if (this.view != null) {
                this.view.setParent(null);
            }
            this.view = view;
            if (this.view != null) {
                this.view.setParent(this);
            }
        }

        public AttributeSet getAttributes() {
            return null;
        }

        public float getPreferredSpan(int n) {
            if (this.view != null) {
                return this.view.getPreferredSpan(n);
            }
            return 10.0f;
        }

        public float getMinimumSpan(int n) {
            if (this.view != null) {
                return this.view.getMinimumSpan(n);
            }
            return 10.0f;
        }

        public float getMaximumSpan(int n) {
            return 2.1474836E9f;
        }

        public void preferenceChanged(View view, boolean bl, boolean bl2) {
            BasicTextUI.this.editor.revalidate();
        }

        public float getAlignment(int n) {
            if (this.view != null) {
                return this.view.getAlignment(n);
            }
            return 0.0f;
        }

        public void paint(Graphics graphics, Shape shape) {
            if (this.view != null) {
                Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
                this.view.setSize(rectangle.width, rectangle.height);
                this.view.paint(graphics, shape);
            }
        }

        public void setParent(View view) {
            throw new Error("Can't set parent on root view");
        }

        public int getViewCount() {
            return 1;
        }

        public View getView(int n) {
            return this.view;
        }

        public int getViewIndex(int n, Position.Bias bias) {
            return 0;
        }

        public Shape getChildAllocation(int n, Shape shape) {
            return shape;
        }

        public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
            if (this.view != null) {
                return this.view.modelToView(n, shape, bias);
            }
            return null;
        }

        public Shape modelToView(int n, Position.Bias bias, int n2, Position.Bias bias2, Shape shape) throws BadLocationException {
            if (this.view != null) {
                return this.view.modelToView(n, bias, n2, bias2, shape);
            }
            return null;
        }

        public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
            if (this.view != null) {
                int n = this.view.viewToModel(f, f2, shape, biasArray);
                return n;
            }
            return -1;
        }

        public int getNextVisualPositionFrom(int n, Position.Bias bias, Shape shape, int n2, Position.Bias[] biasArray) throws BadLocationException {
            if (this.view != null) {
                int n3 = this.view.getNextVisualPositionFrom(n, bias, shape, n2, biasArray);
                if (n3 != -1) {
                    n = n3;
                } else {
                    biasArray[0] = bias;
                }
            }
            return n;
        }

        public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            if (this.view != null) {
                this.view.insertUpdate(documentEvent, shape, viewFactory);
            }
        }

        public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            if (this.view != null) {
                this.view.removeUpdate(documentEvent, shape, viewFactory);
            }
        }

        public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            if (this.view != null) {
                this.view.changedUpdate(documentEvent, shape, viewFactory);
            }
        }

        public Document getDocument() {
            return BasicTextUI.this.editor.getDocument();
        }

        public int getStartOffset() {
            if (this.view != null) {
                return this.view.getStartOffset();
            }
            return this.getElement().getStartOffset();
        }

        public int getEndOffset() {
            if (this.view != null) {
                return this.view.getEndOffset();
            }
            return this.getElement().getEndOffset();
        }

        public Element getElement() {
            if (this.view != null) {
                return this.view.getElement();
            }
            return BasicTextUI.this.editor.getDocument().getDefaultRootElement();
        }

        public View breakView(int n, float f, Shape shape) {
            throw new Error("Can't break root view");
        }

        public int getResizeWeight(int n) {
            if (this.view != null) {
                return this.view.getResizeWeight(n);
            }
            return 0;
        }

        public void setSize(float f, float f2) {
            if (this.view != null) {
                this.view.setSize(f, f2);
            }
        }

        public Container getContainer() {
            return BasicTextUI.this.editor;
        }

        public ViewFactory getViewFactory() {
            EditorKit editorKit = BasicTextUI.this.getEditorKit(BasicTextUI.this.editor);
            ViewFactory viewFactory = editorKit.getViewFactory();
            if (viewFactory != null) {
                return viewFactory;
            }
            return BasicTextUI.this;
        }
    }

    public static class BasicHighlighter
    extends DefaultHighlighter
    implements UIResource {
    }

    public static class BasicCaret
    extends DefaultCaret
    implements UIResource {
    }
}

